// Code generated by go-swagger; DO NOT EDIT.

package support

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// CoredumpGetReader is a Reader for the CoredumpGet structure.
type CoredumpGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *CoredumpGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewCoredumpGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewCoredumpGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewCoredumpGetOK creates a CoredumpGetOK with default headers values
func NewCoredumpGetOK() *CoredumpGetOK {
	return &CoredumpGetOK{}
}

/*
CoredumpGetOK describes a response with status code 200, with default header values.

OK
*/
type CoredumpGetOK struct {
	Payload *models.Coredump
}

// IsSuccess returns true when this coredump get o k response has a 2xx status code
func (o *CoredumpGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this coredump get o k response has a 3xx status code
func (o *CoredumpGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this coredump get o k response has a 4xx status code
func (o *CoredumpGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this coredump get o k response has a 5xx status code
func (o *CoredumpGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this coredump get o k response a status code equal to that given
func (o *CoredumpGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the coredump get o k response
func (o *CoredumpGetOK) Code() int {
	return 200
}

func (o *CoredumpGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /support/coredump/coredumps/{node.uuid}/{name}][%d] coredumpGetOK %s", 200, payload)
}

func (o *CoredumpGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /support/coredump/coredumps/{node.uuid}/{name}][%d] coredumpGetOK %s", 200, payload)
}

func (o *CoredumpGetOK) GetPayload() *models.Coredump {
	return o.Payload
}

func (o *CoredumpGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Coredump)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCoredumpGetDefault creates a CoredumpGetDefault with default headers values
func NewCoredumpGetDefault(code int) *CoredumpGetDefault {
	return &CoredumpGetDefault{
		_statusCode: code,
	}
}

/*
CoredumpGetDefault describes a response with status code -1, with default header values.

Error
*/
type CoredumpGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this coredump get default response has a 2xx status code
func (o *CoredumpGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this coredump get default response has a 3xx status code
func (o *CoredumpGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this coredump get default response has a 4xx status code
func (o *CoredumpGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this coredump get default response has a 5xx status code
func (o *CoredumpGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this coredump get default response a status code equal to that given
func (o *CoredumpGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the coredump get default response
func (o *CoredumpGetDefault) Code() int {
	return o._statusCode
}

func (o *CoredumpGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /support/coredump/coredumps/{node.uuid}/{name}][%d] coredump_get default %s", o._statusCode, payload)
}

func (o *CoredumpGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /support/coredump/coredumps/{node.uuid}/{name}][%d] coredump_get default %s", o._statusCode, payload)
}

func (o *CoredumpGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *CoredumpGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
