// Code generated by go-swagger; DO NOT EDIT.

package support

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewEmsDestinationCreateParams creates a new EmsDestinationCreateParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewEmsDestinationCreateParams() *EmsDestinationCreateParams {
	return &EmsDestinationCreateParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewEmsDestinationCreateParamsWithTimeout creates a new EmsDestinationCreateParams object
// with the ability to set a timeout on a request.
func NewEmsDestinationCreateParamsWithTimeout(timeout time.Duration) *EmsDestinationCreateParams {
	return &EmsDestinationCreateParams{
		timeout: timeout,
	}
}

// NewEmsDestinationCreateParamsWithContext creates a new EmsDestinationCreateParams object
// with the ability to set a context for a request.
func NewEmsDestinationCreateParamsWithContext(ctx context.Context) *EmsDestinationCreateParams {
	return &EmsDestinationCreateParams{
		Context: ctx,
	}
}

// NewEmsDestinationCreateParamsWithHTTPClient creates a new EmsDestinationCreateParams object
// with the ability to set a custom HTTPClient for a request.
func NewEmsDestinationCreateParamsWithHTTPClient(client *http.Client) *EmsDestinationCreateParams {
	return &EmsDestinationCreateParams{
		HTTPClient: client,
	}
}

/*
EmsDestinationCreateParams contains all the parameters to send to the API endpoint

	for the ems destination create operation.

	Typically these are written to a http.Request.
*/
type EmsDestinationCreateParams struct {

	/* Info.

	   Information specification
	*/
	Info *models.EmsDestination

	/* ReturnRecords.

	   The default is false.  If set to true, the records are returned.
	*/
	ReturnRecords *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the ems destination create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *EmsDestinationCreateParams) WithDefaults() *EmsDestinationCreateParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the ems destination create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *EmsDestinationCreateParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(false)
	)

	val := EmsDestinationCreateParams{
		ReturnRecords: &returnRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the ems destination create params
func (o *EmsDestinationCreateParams) WithTimeout(timeout time.Duration) *EmsDestinationCreateParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the ems destination create params
func (o *EmsDestinationCreateParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the ems destination create params
func (o *EmsDestinationCreateParams) WithContext(ctx context.Context) *EmsDestinationCreateParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the ems destination create params
func (o *EmsDestinationCreateParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the ems destination create params
func (o *EmsDestinationCreateParams) WithHTTPClient(client *http.Client) *EmsDestinationCreateParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the ems destination create params
func (o *EmsDestinationCreateParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithInfo adds the info to the ems destination create params
func (o *EmsDestinationCreateParams) WithInfo(info *models.EmsDestination) *EmsDestinationCreateParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the ems destination create params
func (o *EmsDestinationCreateParams) SetInfo(info *models.EmsDestination) {
	o.Info = info
}

// WithReturnRecords adds the returnRecords to the ems destination create params
func (o *EmsDestinationCreateParams) WithReturnRecords(returnRecords *bool) *EmsDestinationCreateParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the ems destination create params
func (o *EmsDestinationCreateParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WriteToRequest writes these params to a swagger request
func (o *EmsDestinationCreateParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
