// Code generated by go-swagger; DO NOT EDIT.

package support

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// EmsDestinationDeleteCollectionReader is a Reader for the EmsDestinationDeleteCollection structure.
type EmsDestinationDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *EmsDestinationDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewEmsDestinationDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewEmsDestinationDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewEmsDestinationDeleteCollectionOK creates a EmsDestinationDeleteCollectionOK with default headers values
func NewEmsDestinationDeleteCollectionOK() *EmsDestinationDeleteCollectionOK {
	return &EmsDestinationDeleteCollectionOK{}
}

/*
EmsDestinationDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type EmsDestinationDeleteCollectionOK struct {
}

// IsSuccess returns true when this ems destination delete collection o k response has a 2xx status code
func (o *EmsDestinationDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this ems destination delete collection o k response has a 3xx status code
func (o *EmsDestinationDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this ems destination delete collection o k response has a 4xx status code
func (o *EmsDestinationDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this ems destination delete collection o k response has a 5xx status code
func (o *EmsDestinationDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this ems destination delete collection o k response a status code equal to that given
func (o *EmsDestinationDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the ems destination delete collection o k response
func (o *EmsDestinationDeleteCollectionOK) Code() int {
	return 200
}

func (o *EmsDestinationDeleteCollectionOK) Error() string {
	return fmt.Sprintf("[DELETE /support/ems/destinations][%d] emsDestinationDeleteCollectionOK", 200)
}

func (o *EmsDestinationDeleteCollectionOK) String() string {
	return fmt.Sprintf("[DELETE /support/ems/destinations][%d] emsDestinationDeleteCollectionOK", 200)
}

func (o *EmsDestinationDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewEmsDestinationDeleteCollectionDefault creates a EmsDestinationDeleteCollectionDefault with default headers values
func NewEmsDestinationDeleteCollectionDefault(code int) *EmsDestinationDeleteCollectionDefault {
	return &EmsDestinationDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
	EmsDestinationDeleteCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 983152 | Default destinations cannot be modified or removed |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type EmsDestinationDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this ems destination delete collection default response has a 2xx status code
func (o *EmsDestinationDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this ems destination delete collection default response has a 3xx status code
func (o *EmsDestinationDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this ems destination delete collection default response has a 4xx status code
func (o *EmsDestinationDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this ems destination delete collection default response has a 5xx status code
func (o *EmsDestinationDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this ems destination delete collection default response a status code equal to that given
func (o *EmsDestinationDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the ems destination delete collection default response
func (o *EmsDestinationDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *EmsDestinationDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /support/ems/destinations][%d] ems_destination_delete_collection default %s", o._statusCode, payload)
}

func (o *EmsDestinationDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /support/ems/destinations][%d] ems_destination_delete_collection default %s", o._statusCode, payload)
}

func (o *EmsDestinationDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *EmsDestinationDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
EmsDestinationDeleteCollectionBody ems destination delete collection body
swagger:model EmsDestinationDeleteCollectionBody
*/
type EmsDestinationDeleteCollectionBody struct {

	// ems destination response inline records
	EmsDestinationResponseInlineRecords []*models.EmsDestinationResponseInlineRecordsInlineArrayItem `json:"records,omitempty"`
}

// Validate validates this ems destination delete collection body
func (o *EmsDestinationDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateEmsDestinationResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsDestinationDeleteCollectionBody) validateEmsDestinationResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.EmsDestinationResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.EmsDestinationResponseInlineRecords); i++ {
		if swag.IsZero(o.EmsDestinationResponseInlineRecords[i]) { // not required
			continue
		}

		if o.EmsDestinationResponseInlineRecords[i] != nil {
			if err := o.EmsDestinationResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this ems destination delete collection body based on the context it is used
func (o *EmsDestinationDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateEmsDestinationResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsDestinationDeleteCollectionBody) contextValidateEmsDestinationResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.EmsDestinationResponseInlineRecords); i++ {

		if o.EmsDestinationResponseInlineRecords[i] != nil {
			if err := o.EmsDestinationResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *EmsDestinationDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *EmsDestinationDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res EmsDestinationDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
EmsDestinationDeleteCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0 Error object included in the event of connectivity failure.
swagger:model EmsDestinationDeleteCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0
*/
type EmsDestinationDeleteCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0 struct {

	// message
	Message *EmsDestinationDeleteCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0Message `json:"message,omitempty"`

	// node
	Node *EmsDestinationDeleteCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0Node `json:"node,omitempty"`
}

// Validate validates this ems destination delete collection params body records items0 connectivity errors items0
func (o *EmsDestinationDeleteCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateMessage(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsDestinationDeleteCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0) validateMessage(formats strfmt.Registry) error {
	if swag.IsZero(o.Message) { // not required
		return nil
	}

	if o.Message != nil {
		if err := o.Message.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("message")
			}
			return err
		}
	}

	return nil
}

func (o *EmsDestinationDeleteCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0) validateNode(formats strfmt.Registry) error {
	if swag.IsZero(o.Node) { // not required
		return nil
	}

	if o.Node != nil {
		if err := o.Node.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ems destination delete collection params body records items0 connectivity errors items0 based on the context it is used
func (o *EmsDestinationDeleteCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsDestinationDeleteCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if o.Message != nil {
		if err := o.Message.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("message")
			}
			return err
		}
	}

	return nil
}

func (o *EmsDestinationDeleteCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if o.Node != nil {
		if err := o.Node.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *EmsDestinationDeleteCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *EmsDestinationDeleteCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0) UnmarshalBinary(b []byte) error {
	var res EmsDestinationDeleteCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
EmsDestinationDeleteCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0Message Information to be displayed to the user.
swagger:model EmsDestinationDeleteCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0Message
*/
type EmsDestinationDeleteCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0Message struct {

	// Message arguments
	// Read Only: true
	Arguments []*EmsDestinationDeleteCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0MessageArgumentsItems0 `json:"arguments"`

	// Unique message code.
	// Example: 4
	// Read Only: true
	Code *string `json:"code,omitempty"`

	// User message.
	// Example: entry doesn't exist
	// Read Only: true
	Message *string `json:"message,omitempty"`
}

// Validate validates this ems destination delete collection params body records items0 connectivity errors items0 message
func (o *EmsDestinationDeleteCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0Message) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateArguments(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsDestinationDeleteCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0Message) validateArguments(formats strfmt.Registry) error {
	if swag.IsZero(o.Arguments) { // not required
		return nil
	}

	for i := 0; i < len(o.Arguments); i++ {
		if swag.IsZero(o.Arguments[i]) { // not required
			continue
		}

		if o.Arguments[i] != nil {
			if err := o.Arguments[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("message" + "." + "arguments" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this ems destination delete collection params body records items0 connectivity errors items0 message based on the context it is used
func (o *EmsDestinationDeleteCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0Message) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateArguments(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateCode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsDestinationDeleteCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0Message) contextValidateArguments(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "message"+"."+"arguments", "body", []*EmsDestinationDeleteCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0MessageArgumentsItems0(o.Arguments)); err != nil {
		return err
	}

	for i := 0; i < len(o.Arguments); i++ {

		if o.Arguments[i] != nil {
			if err := o.Arguments[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("message" + "." + "arguments" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *EmsDestinationDeleteCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0Message) contextValidateCode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "message"+"."+"code", "body", o.Code); err != nil {
		return err
	}

	return nil
}

func (o *EmsDestinationDeleteCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0Message) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "message"+"."+"message", "body", o.Message); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *EmsDestinationDeleteCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0Message) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *EmsDestinationDeleteCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0Message) UnmarshalBinary(b []byte) error {
	var res EmsDestinationDeleteCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0Message
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
EmsDestinationDeleteCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0MessageArgumentsItems0 ems destination delete collection params body records items0 connectivity errors items0 message arguments items0
swagger:model EmsDestinationDeleteCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0MessageArgumentsItems0
*/
type EmsDestinationDeleteCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0MessageArgumentsItems0 struct {

	// Argument code
	// Read Only: true
	Code *string `json:"code,omitempty"`

	// Message argument
	// Read Only: true
	Message *string `json:"message,omitempty"`
}

// Validate validates this ems destination delete collection params body records items0 connectivity errors items0 message arguments items0
func (o *EmsDestinationDeleteCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0MessageArgumentsItems0) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this ems destination delete collection params body records items0 connectivity errors items0 message arguments items0 based on the context it is used
func (o *EmsDestinationDeleteCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0MessageArgumentsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateCode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsDestinationDeleteCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0MessageArgumentsItems0) contextValidateCode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "code", "body", o.Code); err != nil {
		return err
	}

	return nil
}

func (o *EmsDestinationDeleteCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0MessageArgumentsItems0) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "message", "body", o.Message); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *EmsDestinationDeleteCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0MessageArgumentsItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *EmsDestinationDeleteCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0MessageArgumentsItems0) UnmarshalBinary(b []byte) error {
	var res EmsDestinationDeleteCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0MessageArgumentsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
EmsDestinationDeleteCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0Node ems destination delete collection params body records items0 connectivity errors items0 node
swagger:model EmsDestinationDeleteCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0Node
*/
type EmsDestinationDeleteCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0Node struct {

	// links
	Links *EmsDestinationDeleteCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0NodeLinks `json:"_links,omitempty"`

	// name
	// Example: node1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this ems destination delete collection params body records items0 connectivity errors items0 node
func (o *EmsDestinationDeleteCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0Node) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsDestinationDeleteCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0Node) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ems destination delete collection params body records items0 connectivity errors items0 node based on the context it is used
func (o *EmsDestinationDeleteCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0Node) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsDestinationDeleteCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0Node) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *EmsDestinationDeleteCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0Node) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *EmsDestinationDeleteCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0Node) UnmarshalBinary(b []byte) error {
	var res EmsDestinationDeleteCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0Node
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
EmsDestinationDeleteCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0NodeLinks ems destination delete collection params body records items0 connectivity errors items0 node links
swagger:model EmsDestinationDeleteCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0NodeLinks
*/
type EmsDestinationDeleteCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0NodeLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this ems destination delete collection params body records items0 connectivity errors items0 node links
func (o *EmsDestinationDeleteCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0NodeLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsDestinationDeleteCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0NodeLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ems destination delete collection params body records items0 connectivity errors items0 node links based on the context it is used
func (o *EmsDestinationDeleteCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0NodeLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsDestinationDeleteCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0NodeLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *EmsDestinationDeleteCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0NodeLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *EmsDestinationDeleteCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0NodeLinks) UnmarshalBinary(b []byte) error {
	var res EmsDestinationDeleteCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0NodeLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
EmsDestinationDeleteCollectionParamsBodyRecordsItems0FiltersItems0 ems destination delete collection params body records items0 filters items0
swagger:model EmsDestinationDeleteCollectionParamsBodyRecordsItems0FiltersItems0
*/
type EmsDestinationDeleteCollectionParamsBodyRecordsItems0FiltersItems0 struct {

	// links
	Links *EmsDestinationDeleteCollectionParamsBodyRecordsItems0FiltersItems0Links `json:"_links,omitempty"`

	// name
	// Example: important-events
	Name *string `json:"name,omitempty"`
}

// Validate validates this ems destination delete collection params body records items0 filters items0
func (o *EmsDestinationDeleteCollectionParamsBodyRecordsItems0FiltersItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsDestinationDeleteCollectionParamsBodyRecordsItems0FiltersItems0) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ems destination delete collection params body records items0 filters items0 based on the context it is used
func (o *EmsDestinationDeleteCollectionParamsBodyRecordsItems0FiltersItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsDestinationDeleteCollectionParamsBodyRecordsItems0FiltersItems0) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *EmsDestinationDeleteCollectionParamsBodyRecordsItems0FiltersItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *EmsDestinationDeleteCollectionParamsBodyRecordsItems0FiltersItems0) UnmarshalBinary(b []byte) error {
	var res EmsDestinationDeleteCollectionParamsBodyRecordsItems0FiltersItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
EmsDestinationDeleteCollectionParamsBodyRecordsItems0FiltersItems0Links ems destination delete collection params body records items0 filters items0 links
swagger:model EmsDestinationDeleteCollectionParamsBodyRecordsItems0FiltersItems0Links
*/
type EmsDestinationDeleteCollectionParamsBodyRecordsItems0FiltersItems0Links struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this ems destination delete collection params body records items0 filters items0 links
func (o *EmsDestinationDeleteCollectionParamsBodyRecordsItems0FiltersItems0Links) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsDestinationDeleteCollectionParamsBodyRecordsItems0FiltersItems0Links) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ems destination delete collection params body records items0 filters items0 links based on the context it is used
func (o *EmsDestinationDeleteCollectionParamsBodyRecordsItems0FiltersItems0Links) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsDestinationDeleteCollectionParamsBodyRecordsItems0FiltersItems0Links) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *EmsDestinationDeleteCollectionParamsBodyRecordsItems0FiltersItems0Links) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *EmsDestinationDeleteCollectionParamsBodyRecordsItems0FiltersItems0Links) UnmarshalBinary(b []byte) error {
	var res EmsDestinationDeleteCollectionParamsBodyRecordsItems0FiltersItems0Links
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
EmsDestinationResponseInlineRecordsInlineArrayItem ems destination response inline records inline array item
swagger:model ems_destination_response_inline_records_inline_array_item
*/
type EmsDestinationResponseInlineRecordsInlineArrayItem struct {

	// links
	Links *models.EmsDestinationResponseInlineRecordsInlineArrayItemInlineLinks `json:"_links,omitempty"`

	// access control role
	AccessControlRole *models.EmsDestinationResponseInlineRecordsInlineArrayItemInlineAccessControlRole `json:"access_control_role,omitempty"`

	// certificate
	Certificate *models.EmsDestinationResponseInlineRecordsInlineArrayItemInlineCertificate `json:"certificate,omitempty"`

	// connectivity
	Connectivity *models.EmsDestinationResponseInlineRecordsInlineArrayItemInlineConnectivity `json:"connectivity,omitempty"`

	// Event destination
	// Example: administrator@mycompany.com
	Destination *string `json:"destination,omitempty"`

	// filters
	Filters []*EmsDestinationDeleteCollectionParamsBodyRecordsItems0FiltersItems0 `json:"filters"`

	// Destination name.  Valid in POST.
	// Example: Admin_Email
	Name *string `json:"name,omitempty"`

	// syslog
	Syslog *models.EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslog `json:"syslog,omitempty"`

	// Flag indicating system-defined destinations.
	// Example: true
	// Read Only: true
	SystemDefined *bool `json:"system_defined,omitempty"`

	// Type of destination. Valid in POST.
	// Example: email
	// Enum: ["snmp","email","syslog","rest_api"]
	Type *string `json:"type,omitempty"`
}

// Validate validates this ems destination response inline records inline array item
func (o *EmsDestinationResponseInlineRecordsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateAccessControlRole(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateCertificate(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateConnectivity(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateFilters(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSyslog(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsDestinationResponseInlineRecordsInlineArrayItem) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (o *EmsDestinationResponseInlineRecordsInlineArrayItem) validateAccessControlRole(formats strfmt.Registry) error {
	if swag.IsZero(o.AccessControlRole) { // not required
		return nil
	}

	if o.AccessControlRole != nil {
		if err := o.AccessControlRole.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("access_control_role")
			}
			return err
		}
	}

	return nil
}

func (o *EmsDestinationResponseInlineRecordsInlineArrayItem) validateCertificate(formats strfmt.Registry) error {
	if swag.IsZero(o.Certificate) { // not required
		return nil
	}

	if o.Certificate != nil {
		if err := o.Certificate.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("certificate")
			}
			return err
		}
	}

	return nil
}

func (o *EmsDestinationResponseInlineRecordsInlineArrayItem) validateConnectivity(formats strfmt.Registry) error {
	if swag.IsZero(o.Connectivity) { // not required
		return nil
	}

	if o.Connectivity != nil {
		if err := o.Connectivity.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("connectivity")
			}
			return err
		}
	}

	return nil
}

func (o *EmsDestinationResponseInlineRecordsInlineArrayItem) validateFilters(formats strfmt.Registry) error {
	if swag.IsZero(o.Filters) { // not required
		return nil
	}

	for i := 0; i < len(o.Filters); i++ {
		if swag.IsZero(o.Filters[i]) { // not required
			continue
		}

		if o.Filters[i] != nil {
			if err := o.Filters[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("filters" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *EmsDestinationResponseInlineRecordsInlineArrayItem) validateSyslog(formats strfmt.Registry) error {
	if swag.IsZero(o.Syslog) { // not required
		return nil
	}

	if o.Syslog != nil {
		if err := o.Syslog.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("syslog")
			}
			return err
		}
	}

	return nil
}

var emsDestinationResponseInlineRecordsInlineArrayItemTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["snmp","email","syslog","rest_api"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		emsDestinationResponseInlineRecordsInlineArrayItemTypeTypePropEnum = append(emsDestinationResponseInlineRecordsInlineArrayItemTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ems_destination_response_inline_records_inline_array_item
	// EmsDestinationResponseInlineRecordsInlineArrayItem
	// type
	// Type
	// snmp
	// END DEBUGGING
	// EmsDestinationResponseInlineRecordsInlineArrayItemTypeSnmp captures enum value "snmp"
	EmsDestinationResponseInlineRecordsInlineArrayItemTypeSnmp string = "snmp"

	// BEGIN DEBUGGING
	// ems_destination_response_inline_records_inline_array_item
	// EmsDestinationResponseInlineRecordsInlineArrayItem
	// type
	// Type
	// email
	// END DEBUGGING
	// EmsDestinationResponseInlineRecordsInlineArrayItemTypeEmail captures enum value "email"
	EmsDestinationResponseInlineRecordsInlineArrayItemTypeEmail string = "email"

	// BEGIN DEBUGGING
	// ems_destination_response_inline_records_inline_array_item
	// EmsDestinationResponseInlineRecordsInlineArrayItem
	// type
	// Type
	// syslog
	// END DEBUGGING
	// EmsDestinationResponseInlineRecordsInlineArrayItemTypeSyslog captures enum value "syslog"
	EmsDestinationResponseInlineRecordsInlineArrayItemTypeSyslog string = "syslog"

	// BEGIN DEBUGGING
	// ems_destination_response_inline_records_inline_array_item
	// EmsDestinationResponseInlineRecordsInlineArrayItem
	// type
	// Type
	// rest_api
	// END DEBUGGING
	// EmsDestinationResponseInlineRecordsInlineArrayItemTypeRestAPI captures enum value "rest_api"
	EmsDestinationResponseInlineRecordsInlineArrayItemTypeRestAPI string = "rest_api"
)

// prop value enum
func (o *EmsDestinationResponseInlineRecordsInlineArrayItem) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, emsDestinationResponseInlineRecordsInlineArrayItemTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *EmsDestinationResponseInlineRecordsInlineArrayItem) validateType(formats strfmt.Registry) error {
	if swag.IsZero(o.Type) { // not required
		return nil
	}

	// value enum
	if err := o.validateTypeEnum("type", "body", *o.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this ems destination response inline records inline array item based on the context it is used
func (o *EmsDestinationResponseInlineRecordsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateAccessControlRole(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateCertificate(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateConnectivity(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateFilters(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSyslog(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSystemDefined(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsDestinationResponseInlineRecordsInlineArrayItem) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (o *EmsDestinationResponseInlineRecordsInlineArrayItem) contextValidateAccessControlRole(ctx context.Context, formats strfmt.Registry) error {

	if o.AccessControlRole != nil {
		if err := o.AccessControlRole.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("access_control_role")
			}
			return err
		}
	}

	return nil
}

func (o *EmsDestinationResponseInlineRecordsInlineArrayItem) contextValidateCertificate(ctx context.Context, formats strfmt.Registry) error {

	if o.Certificate != nil {
		if err := o.Certificate.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("certificate")
			}
			return err
		}
	}

	return nil
}

func (o *EmsDestinationResponseInlineRecordsInlineArrayItem) contextValidateConnectivity(ctx context.Context, formats strfmt.Registry) error {

	if o.Connectivity != nil {
		if err := o.Connectivity.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("connectivity")
			}
			return err
		}
	}

	return nil
}

func (o *EmsDestinationResponseInlineRecordsInlineArrayItem) contextValidateFilters(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.Filters); i++ {

		if o.Filters[i] != nil {
			if err := o.Filters[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("filters" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *EmsDestinationResponseInlineRecordsInlineArrayItem) contextValidateSyslog(ctx context.Context, formats strfmt.Registry) error {

	if o.Syslog != nil {
		if err := o.Syslog.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("syslog")
			}
			return err
		}
	}

	return nil
}

func (o *EmsDestinationResponseInlineRecordsInlineArrayItem) contextValidateSystemDefined(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "system_defined", "body", o.SystemDefined); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *EmsDestinationResponseInlineRecordsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *EmsDestinationResponseInlineRecordsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res EmsDestinationResponseInlineRecordsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
EmsDestinationResponseInlineRecordsInlineArrayItemInlineLinks ems destination response inline records inline array item inline links
swagger:model ems_destination_response_inline_records_inline_array_item_inline__links
*/
type EmsDestinationResponseInlineRecordsInlineArrayItemInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this ems destination response inline records inline array item inline links
func (o *EmsDestinationResponseInlineRecordsInlineArrayItemInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsDestinationResponseInlineRecordsInlineArrayItemInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ems destination response inline records inline array item inline links based on the context it is used
func (o *EmsDestinationResponseInlineRecordsInlineArrayItemInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsDestinationResponseInlineRecordsInlineArrayItemInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *EmsDestinationResponseInlineRecordsInlineArrayItemInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *EmsDestinationResponseInlineRecordsInlineArrayItemInlineLinks) UnmarshalBinary(b []byte) error {
	var res EmsDestinationResponseInlineRecordsInlineArrayItemInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
EmsDestinationResponseInlineRecordsInlineArrayItemInlineAccessControlRole Indicates the access control role that created the event destination and is used to control access to the destination based on role-based access control (RBAC) rules. If created by the 'admin' user, the field is unset.
swagger:model ems_destination_response_inline_records_inline_array_item_inline_access_control_role
*/
type EmsDestinationResponseInlineRecordsInlineArrayItemInlineAccessControlRole struct {

	// links
	Links *models.EmsDestinationResponseInlineRecordsInlineArrayItemInlineAccessControlRoleInlineLinks `json:"_links,omitempty"`

	// Role name
	// Example: admin
	Name *string `json:"name,omitempty"`
}

// Validate validates this ems destination response inline records inline array item inline access control role
func (o *EmsDestinationResponseInlineRecordsInlineArrayItemInlineAccessControlRole) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsDestinationResponseInlineRecordsInlineArrayItemInlineAccessControlRole) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("access_control_role" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ems destination response inline records inline array item inline access control role based on the context it is used
func (o *EmsDestinationResponseInlineRecordsInlineArrayItemInlineAccessControlRole) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsDestinationResponseInlineRecordsInlineArrayItemInlineAccessControlRole) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("access_control_role" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *EmsDestinationResponseInlineRecordsInlineArrayItemInlineAccessControlRole) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *EmsDestinationResponseInlineRecordsInlineArrayItemInlineAccessControlRole) UnmarshalBinary(b []byte) error {
	var res EmsDestinationResponseInlineRecordsInlineArrayItemInlineAccessControlRole
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
EmsDestinationResponseInlineRecordsInlineArrayItemInlineAccessControlRoleInlineLinks ems destination response inline records inline array item inline access control role inline links
swagger:model ems_destination_response_inline_records_inline_array_item_inline_access_control_role_inline__links
*/
type EmsDestinationResponseInlineRecordsInlineArrayItemInlineAccessControlRoleInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this ems destination response inline records inline array item inline access control role inline links
func (o *EmsDestinationResponseInlineRecordsInlineArrayItemInlineAccessControlRoleInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsDestinationResponseInlineRecordsInlineArrayItemInlineAccessControlRoleInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("access_control_role" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ems destination response inline records inline array item inline access control role inline links based on the context it is used
func (o *EmsDestinationResponseInlineRecordsInlineArrayItemInlineAccessControlRoleInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsDestinationResponseInlineRecordsInlineArrayItemInlineAccessControlRoleInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("access_control_role" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *EmsDestinationResponseInlineRecordsInlineArrayItemInlineAccessControlRoleInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *EmsDestinationResponseInlineRecordsInlineArrayItemInlineAccessControlRoleInlineLinks) UnmarshalBinary(b []byte) error {
	var res EmsDestinationResponseInlineRecordsInlineArrayItemInlineAccessControlRoleInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
EmsDestinationResponseInlineRecordsInlineArrayItemInlineCertificate Specifies the client-side certificate used by the ONTAP system when mutual authentication is required. This object is only applicable for __rest_api__ type destinations. Both the `ca` and `serial_number` fields must be specified when configuring a certificate in a PATCH or POST request. The `name` field is read-only and cannot be used to configure a client-side certificate.
//
swagger:model ems_destination_response_inline_records_inline_array_item_inline_certificate
*/
type EmsDestinationResponseInlineRecordsInlineArrayItemInlineCertificate struct {

	// links
	Links *models.EmsDestinationResponseInlineRecordsInlineArrayItemInlineCertificateInlineLinks `json:"_links,omitempty"`

	// Client certificate issuing CA
	// Example: VeriSign
	// Max Length: 256
	// Min Length: 1
	Ca *string `json:"ca,omitempty"`

	// Certificate name
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// Client certificate serial number
	// Example: 1234567890
	// Max Length: 40
	// Min Length: 1
	SerialNumber *string `json:"serial_number,omitempty"`
}

// Validate validates this ems destination response inline records inline array item inline certificate
func (o *EmsDestinationResponseInlineRecordsInlineArrayItemInlineCertificate) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateCa(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSerialNumber(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsDestinationResponseInlineRecordsInlineArrayItemInlineCertificate) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("certificate" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *EmsDestinationResponseInlineRecordsInlineArrayItemInlineCertificate) validateCa(formats strfmt.Registry) error {
	if swag.IsZero(o.Ca) { // not required
		return nil
	}

	if err := validate.MinLength("certificate"+"."+"ca", "body", *o.Ca, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("certificate"+"."+"ca", "body", *o.Ca, 256); err != nil {
		return err
	}

	return nil
}

func (o *EmsDestinationResponseInlineRecordsInlineArrayItemInlineCertificate) validateSerialNumber(formats strfmt.Registry) error {
	if swag.IsZero(o.SerialNumber) { // not required
		return nil
	}

	if err := validate.MinLength("certificate"+"."+"serial_number", "body", *o.SerialNumber, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("certificate"+"."+"serial_number", "body", *o.SerialNumber, 40); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this ems destination response inline records inline array item inline certificate based on the context it is used
func (o *EmsDestinationResponseInlineRecordsInlineArrayItemInlineCertificate) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsDestinationResponseInlineRecordsInlineArrayItemInlineCertificate) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("certificate" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *EmsDestinationResponseInlineRecordsInlineArrayItemInlineCertificate) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "certificate"+"."+"name", "body", o.Name); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *EmsDestinationResponseInlineRecordsInlineArrayItemInlineCertificate) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *EmsDestinationResponseInlineRecordsInlineArrayItemInlineCertificate) UnmarshalBinary(b []byte) error {
	var res EmsDestinationResponseInlineRecordsInlineArrayItemInlineCertificate
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
EmsDestinationResponseInlineRecordsInlineArrayItemInlineCertificateInlineLinks ems destination response inline records inline array item inline certificate inline links
swagger:model ems_destination_response_inline_records_inline_array_item_inline_certificate_inline__links
*/
type EmsDestinationResponseInlineRecordsInlineArrayItemInlineCertificateInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this ems destination response inline records inline array item inline certificate inline links
func (o *EmsDestinationResponseInlineRecordsInlineArrayItemInlineCertificateInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsDestinationResponseInlineRecordsInlineArrayItemInlineCertificateInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("certificate" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ems destination response inline records inline array item inline certificate inline links based on the context it is used
func (o *EmsDestinationResponseInlineRecordsInlineArrayItemInlineCertificateInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsDestinationResponseInlineRecordsInlineArrayItemInlineCertificateInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("certificate" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *EmsDestinationResponseInlineRecordsInlineArrayItemInlineCertificateInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *EmsDestinationResponseInlineRecordsInlineArrayItemInlineCertificateInlineLinks) UnmarshalBinary(b []byte) error {
	var res EmsDestinationResponseInlineRecordsInlineArrayItemInlineCertificateInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
EmsDestinationResponseInlineRecordsInlineArrayItemInlineConnectivity ems destination response inline records inline array item inline connectivity
swagger:model ems_destination_response_inline_records_inline_array_item_inline_connectivity
*/
type EmsDestinationResponseInlineRecordsInlineArrayItemInlineConnectivity struct {

	// A list of errors encountered during connectivity checks.
	// Read Only: true
	Errors []*EmsDestinationDeleteCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0 `json:"errors"`

	// Current connectivity state.
	// Example: fail
	// Read Only: true
	// Enum: ["success","fail","not_supported"]
	State *string `json:"state,omitempty"`
}

// Validate validates this ems destination response inline records inline array item inline connectivity
func (o *EmsDestinationResponseInlineRecordsInlineArrayItemInlineConnectivity) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateErrors(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsDestinationResponseInlineRecordsInlineArrayItemInlineConnectivity) validateErrors(formats strfmt.Registry) error {
	if swag.IsZero(o.Errors) { // not required
		return nil
	}

	for i := 0; i < len(o.Errors); i++ {
		if swag.IsZero(o.Errors[i]) { // not required
			continue
		}

		if o.Errors[i] != nil {
			if err := o.Errors[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("connectivity" + "." + "errors" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var emsDestinationResponseInlineRecordsInlineArrayItemInlineConnectivityTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["success","fail","not_supported"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		emsDestinationResponseInlineRecordsInlineArrayItemInlineConnectivityTypeStatePropEnum = append(emsDestinationResponseInlineRecordsInlineArrayItemInlineConnectivityTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ems_destination_response_inline_records_inline_array_item_inline_connectivity
	// EmsDestinationResponseInlineRecordsInlineArrayItemInlineConnectivity
	// state
	// State
	// success
	// END DEBUGGING
	// EmsDestinationResponseInlineRecordsInlineArrayItemInlineConnectivityStateSuccess captures enum value "success"
	EmsDestinationResponseInlineRecordsInlineArrayItemInlineConnectivityStateSuccess string = "success"

	// BEGIN DEBUGGING
	// ems_destination_response_inline_records_inline_array_item_inline_connectivity
	// EmsDestinationResponseInlineRecordsInlineArrayItemInlineConnectivity
	// state
	// State
	// fail
	// END DEBUGGING
	// EmsDestinationResponseInlineRecordsInlineArrayItemInlineConnectivityStateFail captures enum value "fail"
	EmsDestinationResponseInlineRecordsInlineArrayItemInlineConnectivityStateFail string = "fail"

	// BEGIN DEBUGGING
	// ems_destination_response_inline_records_inline_array_item_inline_connectivity
	// EmsDestinationResponseInlineRecordsInlineArrayItemInlineConnectivity
	// state
	// State
	// not_supported
	// END DEBUGGING
	// EmsDestinationResponseInlineRecordsInlineArrayItemInlineConnectivityStateNotSupported captures enum value "not_supported"
	EmsDestinationResponseInlineRecordsInlineArrayItemInlineConnectivityStateNotSupported string = "not_supported"
)

// prop value enum
func (o *EmsDestinationResponseInlineRecordsInlineArrayItemInlineConnectivity) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, emsDestinationResponseInlineRecordsInlineArrayItemInlineConnectivityTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *EmsDestinationResponseInlineRecordsInlineArrayItemInlineConnectivity) validateState(formats strfmt.Registry) error {
	if swag.IsZero(o.State) { // not required
		return nil
	}

	// value enum
	if err := o.validateStateEnum("connectivity"+"."+"state", "body", *o.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this ems destination response inline records inline array item inline connectivity based on the context it is used
func (o *EmsDestinationResponseInlineRecordsInlineArrayItemInlineConnectivity) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateErrors(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsDestinationResponseInlineRecordsInlineArrayItemInlineConnectivity) contextValidateErrors(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "connectivity"+"."+"errors", "body", []*EmsDestinationDeleteCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0(o.Errors)); err != nil {
		return err
	}

	for i := 0; i < len(o.Errors); i++ {

		if o.Errors[i] != nil {
			if err := o.Errors[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("connectivity" + "." + "errors" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *EmsDestinationResponseInlineRecordsInlineArrayItemInlineConnectivity) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "connectivity"+"."+"state", "body", o.State); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *EmsDestinationResponseInlineRecordsInlineArrayItemInlineConnectivity) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *EmsDestinationResponseInlineRecordsInlineArrayItemInlineConnectivity) UnmarshalBinary(b []byte) error {
	var res EmsDestinationResponseInlineRecordsInlineArrayItemInlineConnectivity
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslog ems destination response inline records inline array item inline syslog
swagger:model ems_destination_response_inline_records_inline_array_item_inline_syslog
*/
type EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslog struct {

	// format
	Format *models.EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormat `json:"format,omitempty"`

	// Syslog Port.
	// Example: 514
	Port *int64 `json:"port,omitempty"`

	// Syslog Transport Protocol.
	// Enum: ["udp_unencrypted","tcp_unencrypted","tcp_encrypted"]
	Transport *string `json:"transport,omitempty"`
}

// Validate validates this ems destination response inline records inline array item inline syslog
func (o *EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslog) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateFormat(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateTransport(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslog) validateFormat(formats strfmt.Registry) error {
	if swag.IsZero(o.Format) { // not required
		return nil
	}

	if o.Format != nil {
		if err := o.Format.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("syslog" + "." + "format")
			}
			return err
		}
	}

	return nil
}

var emsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogTypeTransportPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["udp_unencrypted","tcp_unencrypted","tcp_encrypted"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		emsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogTypeTransportPropEnum = append(emsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogTypeTransportPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ems_destination_response_inline_records_inline_array_item_inline_syslog
	// EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslog
	// transport
	// Transport
	// udp_unencrypted
	// END DEBUGGING
	// EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogTransportUDPUnencrypted captures enum value "udp_unencrypted"
	EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogTransportUDPUnencrypted string = "udp_unencrypted"

	// BEGIN DEBUGGING
	// ems_destination_response_inline_records_inline_array_item_inline_syslog
	// EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslog
	// transport
	// Transport
	// tcp_unencrypted
	// END DEBUGGING
	// EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogTransportTCPUnencrypted captures enum value "tcp_unencrypted"
	EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogTransportTCPUnencrypted string = "tcp_unencrypted"

	// BEGIN DEBUGGING
	// ems_destination_response_inline_records_inline_array_item_inline_syslog
	// EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslog
	// transport
	// Transport
	// tcp_encrypted
	// END DEBUGGING
	// EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogTransportTCPEncrypted captures enum value "tcp_encrypted"
	EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogTransportTCPEncrypted string = "tcp_encrypted"
)

// prop value enum
func (o *EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslog) validateTransportEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, emsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogTypeTransportPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslog) validateTransport(formats strfmt.Registry) error {
	if swag.IsZero(o.Transport) { // not required
		return nil
	}

	// value enum
	if err := o.validateTransportEnum("syslog"+"."+"transport", "body", *o.Transport); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this ems destination response inline records inline array item inline syslog based on the context it is used
func (o *EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslog) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateFormat(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslog) contextValidateFormat(ctx context.Context, formats strfmt.Registry) error {

	if o.Format != nil {
		if err := o.Format.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("syslog" + "." + "format")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslog) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslog) UnmarshalBinary(b []byte) error {
	var res EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslog
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormat ems destination response inline records inline array item inline syslog inline format
swagger:model ems_destination_response_inline_records_inline_array_item_inline_syslog_inline_format
*/
type EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormat struct {

	// Syslog Hostname Format Override. The supported hostname formats are no_override (hostname format based on the syslog.format.message property i.e. fqdn if syslog.format.message is rfc_5424, hostname_only if syslog.format.message is legacy_netapp), fqdn (Fully Qualified Domain Name) and hostname_only.
	//
	// Enum: ["no_override","fqdn","hostname_only"]
	HostnameOverride *string `json:"hostname_override,omitempty"`

	// Syslog Message Format. The supported message formats are legacy_netapp (format: &lt;PRIVAL&gt;TIMESTAMP [HOSTNAME:Event-name:Event-severity]: MSG) and rfc_5424 (format: &lt;PRIVAL&gt;VERSION TIMESTAMP HOSTNAME Event-source - Event-name - MSG).
	//
	// Enum: ["legacy_netapp","rfc_5424"]
	Message *string `json:"message,omitempty"`

	// Syslog Timestamp Format Override. The supported timestamp formats are no_override (timestamp format based on the syslog.format.message property i.e. rfc_3164 if syslog.format.message is legacy_netapp, iso_8601_local_time if syslog.format.message is rfc_5424), rfc_3164 (format: Mmm dd hh:mm:ss), iso_8601_local_time (format: YYYY-MM-DDThh:mm:ss+/-hh:mm) and iso_8601_utc (format: YYYY-MM-DDThh:mm:ssZ).
	//
	// Enum: ["no_override","rfc_3164","iso_8601_local_time","iso_8601_utc"]
	TimestampOverride *string `json:"timestamp_override,omitempty"`
}

// Validate validates this ems destination response inline records inline array item inline syslog inline format
func (o *EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormat) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateHostnameOverride(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMessage(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateTimestampOverride(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var emsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormatTypeHostnameOverridePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["no_override","fqdn","hostname_only"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		emsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormatTypeHostnameOverridePropEnum = append(emsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormatTypeHostnameOverridePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ems_destination_response_inline_records_inline_array_item_inline_syslog_inline_format
	// EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormat
	// hostname_override
	// HostnameOverride
	// no_override
	// END DEBUGGING
	// EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormatHostnameOverrideNoOverride captures enum value "no_override"
	EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormatHostnameOverrideNoOverride string = "no_override"

	// BEGIN DEBUGGING
	// ems_destination_response_inline_records_inline_array_item_inline_syslog_inline_format
	// EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormat
	// hostname_override
	// HostnameOverride
	// fqdn
	// END DEBUGGING
	// EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormatHostnameOverrideFqdn captures enum value "fqdn"
	EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormatHostnameOverrideFqdn string = "fqdn"

	// BEGIN DEBUGGING
	// ems_destination_response_inline_records_inline_array_item_inline_syslog_inline_format
	// EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormat
	// hostname_override
	// HostnameOverride
	// hostname_only
	// END DEBUGGING
	// EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormatHostnameOverrideHostnameOnly captures enum value "hostname_only"
	EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormatHostnameOverrideHostnameOnly string = "hostname_only"
)

// prop value enum
func (o *EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormat) validateHostnameOverrideEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, emsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormatTypeHostnameOverridePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormat) validateHostnameOverride(formats strfmt.Registry) error {
	if swag.IsZero(o.HostnameOverride) { // not required
		return nil
	}

	// value enum
	if err := o.validateHostnameOverrideEnum("syslog"+"."+"format"+"."+"hostname_override", "body", *o.HostnameOverride); err != nil {
		return err
	}

	return nil
}

var emsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormatTypeMessagePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["legacy_netapp","rfc_5424"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		emsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormatTypeMessagePropEnum = append(emsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormatTypeMessagePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ems_destination_response_inline_records_inline_array_item_inline_syslog_inline_format
	// EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormat
	// message
	// Message
	// legacy_netapp
	// END DEBUGGING
	// EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormatMessageLegacyNetapp captures enum value "legacy_netapp"
	EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormatMessageLegacyNetapp string = "legacy_netapp"

	// BEGIN DEBUGGING
	// ems_destination_response_inline_records_inline_array_item_inline_syslog_inline_format
	// EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormat
	// message
	// Message
	// rfc_5424
	// END DEBUGGING
	// EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormatMessageRfc5424 captures enum value "rfc_5424"
	EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormatMessageRfc5424 string = "rfc_5424"
)

// prop value enum
func (o *EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormat) validateMessageEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, emsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormatTypeMessagePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormat) validateMessage(formats strfmt.Registry) error {
	if swag.IsZero(o.Message) { // not required
		return nil
	}

	// value enum
	if err := o.validateMessageEnum("syslog"+"."+"format"+"."+"message", "body", *o.Message); err != nil {
		return err
	}

	return nil
}

var emsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormatTypeTimestampOverridePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["no_override","rfc_3164","iso_8601_local_time","iso_8601_utc"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		emsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormatTypeTimestampOverridePropEnum = append(emsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormatTypeTimestampOverridePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ems_destination_response_inline_records_inline_array_item_inline_syslog_inline_format
	// EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormat
	// timestamp_override
	// TimestampOverride
	// no_override
	// END DEBUGGING
	// EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormatTimestampOverrideNoOverride captures enum value "no_override"
	EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormatTimestampOverrideNoOverride string = "no_override"

	// BEGIN DEBUGGING
	// ems_destination_response_inline_records_inline_array_item_inline_syslog_inline_format
	// EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormat
	// timestamp_override
	// TimestampOverride
	// rfc_3164
	// END DEBUGGING
	// EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormatTimestampOverrideRfc3164 captures enum value "rfc_3164"
	EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormatTimestampOverrideRfc3164 string = "rfc_3164"

	// BEGIN DEBUGGING
	// ems_destination_response_inline_records_inline_array_item_inline_syslog_inline_format
	// EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormat
	// timestamp_override
	// TimestampOverride
	// iso_8601_local_time
	// END DEBUGGING
	// EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormatTimestampOverrideIso8601LocalTime captures enum value "iso_8601_local_time"
	EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormatTimestampOverrideIso8601LocalTime string = "iso_8601_local_time"

	// BEGIN DEBUGGING
	// ems_destination_response_inline_records_inline_array_item_inline_syslog_inline_format
	// EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormat
	// timestamp_override
	// TimestampOverride
	// iso_8601_utc
	// END DEBUGGING
	// EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormatTimestampOverrideIso8601Utc captures enum value "iso_8601_utc"
	EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormatTimestampOverrideIso8601Utc string = "iso_8601_utc"
)

// prop value enum
func (o *EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormat) validateTimestampOverrideEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, emsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormatTypeTimestampOverridePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormat) validateTimestampOverride(formats strfmt.Registry) error {
	if swag.IsZero(o.TimestampOverride) { // not required
		return nil
	}

	// value enum
	if err := o.validateTimestampOverrideEnum("syslog"+"."+"format"+"."+"timestamp_override", "body", *o.TimestampOverride); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this ems destination response inline records inline array item inline syslog inline format based on context it is used
func (o *EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormat) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormat) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormat) UnmarshalBinary(b []byte) error {
	var res EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslogInlineFormat
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
