// Code generated by go-swagger; DO NOT EDIT.

package support

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// EmsDestinationGetReader is a Reader for the EmsDestinationGet structure.
type EmsDestinationGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *EmsDestinationGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewEmsDestinationGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewEmsDestinationGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewEmsDestinationGetOK creates a EmsDestinationGetOK with default headers values
func NewEmsDestinationGetOK() *EmsDestinationGetOK {
	return &EmsDestinationGetOK{}
}

/*
EmsDestinationGetOK describes a response with status code 200, with default header values.

OK
*/
type EmsDestinationGetOK struct {
	Payload *models.EmsDestination
}

// IsSuccess returns true when this ems destination get o k response has a 2xx status code
func (o *EmsDestinationGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this ems destination get o k response has a 3xx status code
func (o *EmsDestinationGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this ems destination get o k response has a 4xx status code
func (o *EmsDestinationGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this ems destination get o k response has a 5xx status code
func (o *EmsDestinationGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this ems destination get o k response a status code equal to that given
func (o *EmsDestinationGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the ems destination get o k response
func (o *EmsDestinationGetOK) Code() int {
	return 200
}

func (o *EmsDestinationGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /support/ems/destinations/{name}][%d] emsDestinationGetOK %s", 200, payload)
}

func (o *EmsDestinationGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /support/ems/destinations/{name}][%d] emsDestinationGetOK %s", 200, payload)
}

func (o *EmsDestinationGetOK) GetPayload() *models.EmsDestination {
	return o.Payload
}

func (o *EmsDestinationGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.EmsDestination)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewEmsDestinationGetDefault creates a EmsDestinationGetDefault with default headers values
func NewEmsDestinationGetDefault(code int) *EmsDestinationGetDefault {
	return &EmsDestinationGetDefault{
		_statusCode: code,
	}
}

/*
EmsDestinationGetDefault describes a response with status code -1, with default header values.

Error
*/
type EmsDestinationGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this ems destination get default response has a 2xx status code
func (o *EmsDestinationGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this ems destination get default response has a 3xx status code
func (o *EmsDestinationGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this ems destination get default response has a 4xx status code
func (o *EmsDestinationGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this ems destination get default response has a 5xx status code
func (o *EmsDestinationGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this ems destination get default response a status code equal to that given
func (o *EmsDestinationGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the ems destination get default response
func (o *EmsDestinationGetDefault) Code() int {
	return o._statusCode
}

func (o *EmsDestinationGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /support/ems/destinations/{name}][%d] ems_destination_get default %s", o._statusCode, payload)
}

func (o *EmsDestinationGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /support/ems/destinations/{name}][%d] ems_destination_get default %s", o._statusCode, payload)
}

func (o *EmsDestinationGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *EmsDestinationGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
