// Code generated by go-swagger; DO NOT EDIT.

package support

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewEmsDestinationModifyCollectionParams creates a new EmsDestinationModifyCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewEmsDestinationModifyCollectionParams() *EmsDestinationModifyCollectionParams {
	return &EmsDestinationModifyCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewEmsDestinationModifyCollectionParamsWithTimeout creates a new EmsDestinationModifyCollectionParams object
// with the ability to set a timeout on a request.
func NewEmsDestinationModifyCollectionParamsWithTimeout(timeout time.Duration) *EmsDestinationModifyCollectionParams {
	return &EmsDestinationModifyCollectionParams{
		timeout: timeout,
	}
}

// NewEmsDestinationModifyCollectionParamsWithContext creates a new EmsDestinationModifyCollectionParams object
// with the ability to set a context for a request.
func NewEmsDestinationModifyCollectionParamsWithContext(ctx context.Context) *EmsDestinationModifyCollectionParams {
	return &EmsDestinationModifyCollectionParams{
		Context: ctx,
	}
}

// NewEmsDestinationModifyCollectionParamsWithHTTPClient creates a new EmsDestinationModifyCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewEmsDestinationModifyCollectionParamsWithHTTPClient(client *http.Client) *EmsDestinationModifyCollectionParams {
	return &EmsDestinationModifyCollectionParams{
		HTTPClient: client,
	}
}

/*
EmsDestinationModifyCollectionParams contains all the parameters to send to the API endpoint

	for the ems destination modify collection operation.

	Typically these are written to a http.Request.
*/
type EmsDestinationModifyCollectionParams struct {

	/* AccessControlRoleName.

	   Filter by access_control_role.name
	*/
	AccessControlRoleName *string

	/* CertificateCa.

	   Filter by certificate.ca
	*/
	CertificateCa *string

	/* CertificateName.

	   Filter by certificate.name
	*/
	CertificateName *string

	/* CertificateSerialNumber.

	   Filter by certificate.serial_number
	*/
	CertificateSerialNumber *string

	/* ConnectivityErrorsMessageArgumentsCode.

	   Filter by connectivity.errors.message.arguments.code
	*/
	ConnectivityErrorsMessageArgumentsCode *string

	/* ConnectivityErrorsMessageArgumentsMessage.

	   Filter by connectivity.errors.message.arguments.message
	*/
	ConnectivityErrorsMessageArgumentsMessage *string

	/* ConnectivityErrorsMessageCode.

	   Filter by connectivity.errors.message.code
	*/
	ConnectivityErrorsMessageCode *string

	/* ConnectivityErrorsMessageMessage.

	   Filter by connectivity.errors.message.message
	*/
	ConnectivityErrorsMessageMessage *string

	/* ConnectivityErrorsNodeName.

	   Filter by connectivity.errors.node.name
	*/
	ConnectivityErrorsNodeName *string

	/* ConnectivityErrorsNodeUUID.

	   Filter by connectivity.errors.node.uuid
	*/
	ConnectivityErrorsNodeUUID *string

	/* ConnectivityState.

	   Filter by connectivity.state
	*/
	ConnectivityState *string

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* Destination.

	   Filter by destination
	*/
	Destination *string

	/* FiltersName.

	   Filter by filters.name
	*/
	FiltersName *string

	/* Info.

	   Info specification
	*/
	Info EmsDestinationModifyCollectionBody

	/* Name.

	   Filter by name
	*/
	Name *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* SyslogFormatHostnameOverride.

	   Filter by syslog.format.hostname_override
	*/
	SyslogFormatHostnameOverride *string

	/* SyslogFormatMessage.

	   Filter by syslog.format.message
	*/
	SyslogFormatMessage *string

	/* SyslogFormatTimestampOverride.

	   Filter by syslog.format.timestamp_override
	*/
	SyslogFormatTimestampOverride *string

	/* SyslogPort.

	   Filter by syslog.port
	*/
	SyslogPort *int64

	/* SyslogTransport.

	   Filter by syslog.transport
	*/
	SyslogTransport *string

	/* SystemDefined.

	   Filter by system_defined
	*/
	SystemDefined *bool

	/* Type.

	   Filter by type
	*/
	Type *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the ems destination modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *EmsDestinationModifyCollectionParams) WithDefaults() *EmsDestinationModifyCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the ems destination modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *EmsDestinationModifyCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := EmsDestinationModifyCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the ems destination modify collection params
func (o *EmsDestinationModifyCollectionParams) WithTimeout(timeout time.Duration) *EmsDestinationModifyCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the ems destination modify collection params
func (o *EmsDestinationModifyCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the ems destination modify collection params
func (o *EmsDestinationModifyCollectionParams) WithContext(ctx context.Context) *EmsDestinationModifyCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the ems destination modify collection params
func (o *EmsDestinationModifyCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the ems destination modify collection params
func (o *EmsDestinationModifyCollectionParams) WithHTTPClient(client *http.Client) *EmsDestinationModifyCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the ems destination modify collection params
func (o *EmsDestinationModifyCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAccessControlRoleName adds the accessControlRoleName to the ems destination modify collection params
func (o *EmsDestinationModifyCollectionParams) WithAccessControlRoleName(accessControlRoleName *string) *EmsDestinationModifyCollectionParams {
	o.SetAccessControlRoleName(accessControlRoleName)
	return o
}

// SetAccessControlRoleName adds the accessControlRoleName to the ems destination modify collection params
func (o *EmsDestinationModifyCollectionParams) SetAccessControlRoleName(accessControlRoleName *string) {
	o.AccessControlRoleName = accessControlRoleName
}

// WithCertificateCa adds the certificateCa to the ems destination modify collection params
func (o *EmsDestinationModifyCollectionParams) WithCertificateCa(certificateCa *string) *EmsDestinationModifyCollectionParams {
	o.SetCertificateCa(certificateCa)
	return o
}

// SetCertificateCa adds the certificateCa to the ems destination modify collection params
func (o *EmsDestinationModifyCollectionParams) SetCertificateCa(certificateCa *string) {
	o.CertificateCa = certificateCa
}

// WithCertificateName adds the certificateName to the ems destination modify collection params
func (o *EmsDestinationModifyCollectionParams) WithCertificateName(certificateName *string) *EmsDestinationModifyCollectionParams {
	o.SetCertificateName(certificateName)
	return o
}

// SetCertificateName adds the certificateName to the ems destination modify collection params
func (o *EmsDestinationModifyCollectionParams) SetCertificateName(certificateName *string) {
	o.CertificateName = certificateName
}

// WithCertificateSerialNumber adds the certificateSerialNumber to the ems destination modify collection params
func (o *EmsDestinationModifyCollectionParams) WithCertificateSerialNumber(certificateSerialNumber *string) *EmsDestinationModifyCollectionParams {
	o.SetCertificateSerialNumber(certificateSerialNumber)
	return o
}

// SetCertificateSerialNumber adds the certificateSerialNumber to the ems destination modify collection params
func (o *EmsDestinationModifyCollectionParams) SetCertificateSerialNumber(certificateSerialNumber *string) {
	o.CertificateSerialNumber = certificateSerialNumber
}

// WithConnectivityErrorsMessageArgumentsCode adds the connectivityErrorsMessageArgumentsCode to the ems destination modify collection params
func (o *EmsDestinationModifyCollectionParams) WithConnectivityErrorsMessageArgumentsCode(connectivityErrorsMessageArgumentsCode *string) *EmsDestinationModifyCollectionParams {
	o.SetConnectivityErrorsMessageArgumentsCode(connectivityErrorsMessageArgumentsCode)
	return o
}

// SetConnectivityErrorsMessageArgumentsCode adds the connectivityErrorsMessageArgumentsCode to the ems destination modify collection params
func (o *EmsDestinationModifyCollectionParams) SetConnectivityErrorsMessageArgumentsCode(connectivityErrorsMessageArgumentsCode *string) {
	o.ConnectivityErrorsMessageArgumentsCode = connectivityErrorsMessageArgumentsCode
}

// WithConnectivityErrorsMessageArgumentsMessage adds the connectivityErrorsMessageArgumentsMessage to the ems destination modify collection params
func (o *EmsDestinationModifyCollectionParams) WithConnectivityErrorsMessageArgumentsMessage(connectivityErrorsMessageArgumentsMessage *string) *EmsDestinationModifyCollectionParams {
	o.SetConnectivityErrorsMessageArgumentsMessage(connectivityErrorsMessageArgumentsMessage)
	return o
}

// SetConnectivityErrorsMessageArgumentsMessage adds the connectivityErrorsMessageArgumentsMessage to the ems destination modify collection params
func (o *EmsDestinationModifyCollectionParams) SetConnectivityErrorsMessageArgumentsMessage(connectivityErrorsMessageArgumentsMessage *string) {
	o.ConnectivityErrorsMessageArgumentsMessage = connectivityErrorsMessageArgumentsMessage
}

// WithConnectivityErrorsMessageCode adds the connectivityErrorsMessageCode to the ems destination modify collection params
func (o *EmsDestinationModifyCollectionParams) WithConnectivityErrorsMessageCode(connectivityErrorsMessageCode *string) *EmsDestinationModifyCollectionParams {
	o.SetConnectivityErrorsMessageCode(connectivityErrorsMessageCode)
	return o
}

// SetConnectivityErrorsMessageCode adds the connectivityErrorsMessageCode to the ems destination modify collection params
func (o *EmsDestinationModifyCollectionParams) SetConnectivityErrorsMessageCode(connectivityErrorsMessageCode *string) {
	o.ConnectivityErrorsMessageCode = connectivityErrorsMessageCode
}

// WithConnectivityErrorsMessageMessage adds the connectivityErrorsMessageMessage to the ems destination modify collection params
func (o *EmsDestinationModifyCollectionParams) WithConnectivityErrorsMessageMessage(connectivityErrorsMessageMessage *string) *EmsDestinationModifyCollectionParams {
	o.SetConnectivityErrorsMessageMessage(connectivityErrorsMessageMessage)
	return o
}

// SetConnectivityErrorsMessageMessage adds the connectivityErrorsMessageMessage to the ems destination modify collection params
func (o *EmsDestinationModifyCollectionParams) SetConnectivityErrorsMessageMessage(connectivityErrorsMessageMessage *string) {
	o.ConnectivityErrorsMessageMessage = connectivityErrorsMessageMessage
}

// WithConnectivityErrorsNodeName adds the connectivityErrorsNodeName to the ems destination modify collection params
func (o *EmsDestinationModifyCollectionParams) WithConnectivityErrorsNodeName(connectivityErrorsNodeName *string) *EmsDestinationModifyCollectionParams {
	o.SetConnectivityErrorsNodeName(connectivityErrorsNodeName)
	return o
}

// SetConnectivityErrorsNodeName adds the connectivityErrorsNodeName to the ems destination modify collection params
func (o *EmsDestinationModifyCollectionParams) SetConnectivityErrorsNodeName(connectivityErrorsNodeName *string) {
	o.ConnectivityErrorsNodeName = connectivityErrorsNodeName
}

// WithConnectivityErrorsNodeUUID adds the connectivityErrorsNodeUUID to the ems destination modify collection params
func (o *EmsDestinationModifyCollectionParams) WithConnectivityErrorsNodeUUID(connectivityErrorsNodeUUID *string) *EmsDestinationModifyCollectionParams {
	o.SetConnectivityErrorsNodeUUID(connectivityErrorsNodeUUID)
	return o
}

// SetConnectivityErrorsNodeUUID adds the connectivityErrorsNodeUuid to the ems destination modify collection params
func (o *EmsDestinationModifyCollectionParams) SetConnectivityErrorsNodeUUID(connectivityErrorsNodeUUID *string) {
	o.ConnectivityErrorsNodeUUID = connectivityErrorsNodeUUID
}

// WithConnectivityState adds the connectivityState to the ems destination modify collection params
func (o *EmsDestinationModifyCollectionParams) WithConnectivityState(connectivityState *string) *EmsDestinationModifyCollectionParams {
	o.SetConnectivityState(connectivityState)
	return o
}

// SetConnectivityState adds the connectivityState to the ems destination modify collection params
func (o *EmsDestinationModifyCollectionParams) SetConnectivityState(connectivityState *string) {
	o.ConnectivityState = connectivityState
}

// WithContinueOnFailure adds the continueOnFailure to the ems destination modify collection params
func (o *EmsDestinationModifyCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *EmsDestinationModifyCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the ems destination modify collection params
func (o *EmsDestinationModifyCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithDestination adds the destination to the ems destination modify collection params
func (o *EmsDestinationModifyCollectionParams) WithDestination(destination *string) *EmsDestinationModifyCollectionParams {
	o.SetDestination(destination)
	return o
}

// SetDestination adds the destination to the ems destination modify collection params
func (o *EmsDestinationModifyCollectionParams) SetDestination(destination *string) {
	o.Destination = destination
}

// WithFiltersName adds the filtersName to the ems destination modify collection params
func (o *EmsDestinationModifyCollectionParams) WithFiltersName(filtersName *string) *EmsDestinationModifyCollectionParams {
	o.SetFiltersName(filtersName)
	return o
}

// SetFiltersName adds the filtersName to the ems destination modify collection params
func (o *EmsDestinationModifyCollectionParams) SetFiltersName(filtersName *string) {
	o.FiltersName = filtersName
}

// WithInfo adds the info to the ems destination modify collection params
func (o *EmsDestinationModifyCollectionParams) WithInfo(info EmsDestinationModifyCollectionBody) *EmsDestinationModifyCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the ems destination modify collection params
func (o *EmsDestinationModifyCollectionParams) SetInfo(info EmsDestinationModifyCollectionBody) {
	o.Info = info
}

// WithName adds the name to the ems destination modify collection params
func (o *EmsDestinationModifyCollectionParams) WithName(name *string) *EmsDestinationModifyCollectionParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the ems destination modify collection params
func (o *EmsDestinationModifyCollectionParams) SetName(name *string) {
	o.Name = name
}

// WithReturnRecords adds the returnRecords to the ems destination modify collection params
func (o *EmsDestinationModifyCollectionParams) WithReturnRecords(returnRecords *bool) *EmsDestinationModifyCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the ems destination modify collection params
func (o *EmsDestinationModifyCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the ems destination modify collection params
func (o *EmsDestinationModifyCollectionParams) WithReturnTimeout(returnTimeout *int64) *EmsDestinationModifyCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the ems destination modify collection params
func (o *EmsDestinationModifyCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSerialRecords adds the serialRecords to the ems destination modify collection params
func (o *EmsDestinationModifyCollectionParams) WithSerialRecords(serialRecords *bool) *EmsDestinationModifyCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the ems destination modify collection params
func (o *EmsDestinationModifyCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithSyslogFormatHostnameOverride adds the syslogFormatHostnameOverride to the ems destination modify collection params
func (o *EmsDestinationModifyCollectionParams) WithSyslogFormatHostnameOverride(syslogFormatHostnameOverride *string) *EmsDestinationModifyCollectionParams {
	o.SetSyslogFormatHostnameOverride(syslogFormatHostnameOverride)
	return o
}

// SetSyslogFormatHostnameOverride adds the syslogFormatHostnameOverride to the ems destination modify collection params
func (o *EmsDestinationModifyCollectionParams) SetSyslogFormatHostnameOverride(syslogFormatHostnameOverride *string) {
	o.SyslogFormatHostnameOverride = syslogFormatHostnameOverride
}

// WithSyslogFormatMessage adds the syslogFormatMessage to the ems destination modify collection params
func (o *EmsDestinationModifyCollectionParams) WithSyslogFormatMessage(syslogFormatMessage *string) *EmsDestinationModifyCollectionParams {
	o.SetSyslogFormatMessage(syslogFormatMessage)
	return o
}

// SetSyslogFormatMessage adds the syslogFormatMessage to the ems destination modify collection params
func (o *EmsDestinationModifyCollectionParams) SetSyslogFormatMessage(syslogFormatMessage *string) {
	o.SyslogFormatMessage = syslogFormatMessage
}

// WithSyslogFormatTimestampOverride adds the syslogFormatTimestampOverride to the ems destination modify collection params
func (o *EmsDestinationModifyCollectionParams) WithSyslogFormatTimestampOverride(syslogFormatTimestampOverride *string) *EmsDestinationModifyCollectionParams {
	o.SetSyslogFormatTimestampOverride(syslogFormatTimestampOverride)
	return o
}

// SetSyslogFormatTimestampOverride adds the syslogFormatTimestampOverride to the ems destination modify collection params
func (o *EmsDestinationModifyCollectionParams) SetSyslogFormatTimestampOverride(syslogFormatTimestampOverride *string) {
	o.SyslogFormatTimestampOverride = syslogFormatTimestampOverride
}

// WithSyslogPort adds the syslogPort to the ems destination modify collection params
func (o *EmsDestinationModifyCollectionParams) WithSyslogPort(syslogPort *int64) *EmsDestinationModifyCollectionParams {
	o.SetSyslogPort(syslogPort)
	return o
}

// SetSyslogPort adds the syslogPort to the ems destination modify collection params
func (o *EmsDestinationModifyCollectionParams) SetSyslogPort(syslogPort *int64) {
	o.SyslogPort = syslogPort
}

// WithSyslogTransport adds the syslogTransport to the ems destination modify collection params
func (o *EmsDestinationModifyCollectionParams) WithSyslogTransport(syslogTransport *string) *EmsDestinationModifyCollectionParams {
	o.SetSyslogTransport(syslogTransport)
	return o
}

// SetSyslogTransport adds the syslogTransport to the ems destination modify collection params
func (o *EmsDestinationModifyCollectionParams) SetSyslogTransport(syslogTransport *string) {
	o.SyslogTransport = syslogTransport
}

// WithSystemDefined adds the systemDefined to the ems destination modify collection params
func (o *EmsDestinationModifyCollectionParams) WithSystemDefined(systemDefined *bool) *EmsDestinationModifyCollectionParams {
	o.SetSystemDefined(systemDefined)
	return o
}

// SetSystemDefined adds the systemDefined to the ems destination modify collection params
func (o *EmsDestinationModifyCollectionParams) SetSystemDefined(systemDefined *bool) {
	o.SystemDefined = systemDefined
}

// WithType adds the typeVar to the ems destination modify collection params
func (o *EmsDestinationModifyCollectionParams) WithType(typeVar *string) *EmsDestinationModifyCollectionParams {
	o.SetType(typeVar)
	return o
}

// SetType adds the type to the ems destination modify collection params
func (o *EmsDestinationModifyCollectionParams) SetType(typeVar *string) {
	o.Type = typeVar
}

// WriteToRequest writes these params to a swagger request
func (o *EmsDestinationModifyCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.AccessControlRoleName != nil {

		// query param access_control_role.name
		var qrAccessControlRoleName string

		if o.AccessControlRoleName != nil {
			qrAccessControlRoleName = *o.AccessControlRoleName
		}
		qAccessControlRoleName := qrAccessControlRoleName
		if qAccessControlRoleName != "" {

			if err := r.SetQueryParam("access_control_role.name", qAccessControlRoleName); err != nil {
				return err
			}
		}
	}

	if o.CertificateCa != nil {

		// query param certificate.ca
		var qrCertificateCa string

		if o.CertificateCa != nil {
			qrCertificateCa = *o.CertificateCa
		}
		qCertificateCa := qrCertificateCa
		if qCertificateCa != "" {

			if err := r.SetQueryParam("certificate.ca", qCertificateCa); err != nil {
				return err
			}
		}
	}

	if o.CertificateName != nil {

		// query param certificate.name
		var qrCertificateName string

		if o.CertificateName != nil {
			qrCertificateName = *o.CertificateName
		}
		qCertificateName := qrCertificateName
		if qCertificateName != "" {

			if err := r.SetQueryParam("certificate.name", qCertificateName); err != nil {
				return err
			}
		}
	}

	if o.CertificateSerialNumber != nil {

		// query param certificate.serial_number
		var qrCertificateSerialNumber string

		if o.CertificateSerialNumber != nil {
			qrCertificateSerialNumber = *o.CertificateSerialNumber
		}
		qCertificateSerialNumber := qrCertificateSerialNumber
		if qCertificateSerialNumber != "" {

			if err := r.SetQueryParam("certificate.serial_number", qCertificateSerialNumber); err != nil {
				return err
			}
		}
	}

	if o.ConnectivityErrorsMessageArgumentsCode != nil {

		// query param connectivity.errors.message.arguments.code
		var qrConnectivityErrorsMessageArgumentsCode string

		if o.ConnectivityErrorsMessageArgumentsCode != nil {
			qrConnectivityErrorsMessageArgumentsCode = *o.ConnectivityErrorsMessageArgumentsCode
		}
		qConnectivityErrorsMessageArgumentsCode := qrConnectivityErrorsMessageArgumentsCode
		if qConnectivityErrorsMessageArgumentsCode != "" {

			if err := r.SetQueryParam("connectivity.errors.message.arguments.code", qConnectivityErrorsMessageArgumentsCode); err != nil {
				return err
			}
		}
	}

	if o.ConnectivityErrorsMessageArgumentsMessage != nil {

		// query param connectivity.errors.message.arguments.message
		var qrConnectivityErrorsMessageArgumentsMessage string

		if o.ConnectivityErrorsMessageArgumentsMessage != nil {
			qrConnectivityErrorsMessageArgumentsMessage = *o.ConnectivityErrorsMessageArgumentsMessage
		}
		qConnectivityErrorsMessageArgumentsMessage := qrConnectivityErrorsMessageArgumentsMessage
		if qConnectivityErrorsMessageArgumentsMessage != "" {

			if err := r.SetQueryParam("connectivity.errors.message.arguments.message", qConnectivityErrorsMessageArgumentsMessage); err != nil {
				return err
			}
		}
	}

	if o.ConnectivityErrorsMessageCode != nil {

		// query param connectivity.errors.message.code
		var qrConnectivityErrorsMessageCode string

		if o.ConnectivityErrorsMessageCode != nil {
			qrConnectivityErrorsMessageCode = *o.ConnectivityErrorsMessageCode
		}
		qConnectivityErrorsMessageCode := qrConnectivityErrorsMessageCode
		if qConnectivityErrorsMessageCode != "" {

			if err := r.SetQueryParam("connectivity.errors.message.code", qConnectivityErrorsMessageCode); err != nil {
				return err
			}
		}
	}

	if o.ConnectivityErrorsMessageMessage != nil {

		// query param connectivity.errors.message.message
		var qrConnectivityErrorsMessageMessage string

		if o.ConnectivityErrorsMessageMessage != nil {
			qrConnectivityErrorsMessageMessage = *o.ConnectivityErrorsMessageMessage
		}
		qConnectivityErrorsMessageMessage := qrConnectivityErrorsMessageMessage
		if qConnectivityErrorsMessageMessage != "" {

			if err := r.SetQueryParam("connectivity.errors.message.message", qConnectivityErrorsMessageMessage); err != nil {
				return err
			}
		}
	}

	if o.ConnectivityErrorsNodeName != nil {

		// query param connectivity.errors.node.name
		var qrConnectivityErrorsNodeName string

		if o.ConnectivityErrorsNodeName != nil {
			qrConnectivityErrorsNodeName = *o.ConnectivityErrorsNodeName
		}
		qConnectivityErrorsNodeName := qrConnectivityErrorsNodeName
		if qConnectivityErrorsNodeName != "" {

			if err := r.SetQueryParam("connectivity.errors.node.name", qConnectivityErrorsNodeName); err != nil {
				return err
			}
		}
	}

	if o.ConnectivityErrorsNodeUUID != nil {

		// query param connectivity.errors.node.uuid
		var qrConnectivityErrorsNodeUUID string

		if o.ConnectivityErrorsNodeUUID != nil {
			qrConnectivityErrorsNodeUUID = *o.ConnectivityErrorsNodeUUID
		}
		qConnectivityErrorsNodeUUID := qrConnectivityErrorsNodeUUID
		if qConnectivityErrorsNodeUUID != "" {

			if err := r.SetQueryParam("connectivity.errors.node.uuid", qConnectivityErrorsNodeUUID); err != nil {
				return err
			}
		}
	}

	if o.ConnectivityState != nil {

		// query param connectivity.state
		var qrConnectivityState string

		if o.ConnectivityState != nil {
			qrConnectivityState = *o.ConnectivityState
		}
		qConnectivityState := qrConnectivityState
		if qConnectivityState != "" {

			if err := r.SetQueryParam("connectivity.state", qConnectivityState); err != nil {
				return err
			}
		}
	}

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}

	if o.Destination != nil {

		// query param destination
		var qrDestination string

		if o.Destination != nil {
			qrDestination = *o.Destination
		}
		qDestination := qrDestination
		if qDestination != "" {

			if err := r.SetQueryParam("destination", qDestination); err != nil {
				return err
			}
		}
	}

	if o.FiltersName != nil {

		// query param filters.name
		var qrFiltersName string

		if o.FiltersName != nil {
			qrFiltersName = *o.FiltersName
		}
		qFiltersName := qrFiltersName
		if qFiltersName != "" {

			if err := r.SetQueryParam("filters.name", qFiltersName); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.SyslogFormatHostnameOverride != nil {

		// query param syslog.format.hostname_override
		var qrSyslogFormatHostnameOverride string

		if o.SyslogFormatHostnameOverride != nil {
			qrSyslogFormatHostnameOverride = *o.SyslogFormatHostnameOverride
		}
		qSyslogFormatHostnameOverride := qrSyslogFormatHostnameOverride
		if qSyslogFormatHostnameOverride != "" {

			if err := r.SetQueryParam("syslog.format.hostname_override", qSyslogFormatHostnameOverride); err != nil {
				return err
			}
		}
	}

	if o.SyslogFormatMessage != nil {

		// query param syslog.format.message
		var qrSyslogFormatMessage string

		if o.SyslogFormatMessage != nil {
			qrSyslogFormatMessage = *o.SyslogFormatMessage
		}
		qSyslogFormatMessage := qrSyslogFormatMessage
		if qSyslogFormatMessage != "" {

			if err := r.SetQueryParam("syslog.format.message", qSyslogFormatMessage); err != nil {
				return err
			}
		}
	}

	if o.SyslogFormatTimestampOverride != nil {

		// query param syslog.format.timestamp_override
		var qrSyslogFormatTimestampOverride string

		if o.SyslogFormatTimestampOverride != nil {
			qrSyslogFormatTimestampOverride = *o.SyslogFormatTimestampOverride
		}
		qSyslogFormatTimestampOverride := qrSyslogFormatTimestampOverride
		if qSyslogFormatTimestampOverride != "" {

			if err := r.SetQueryParam("syslog.format.timestamp_override", qSyslogFormatTimestampOverride); err != nil {
				return err
			}
		}
	}

	if o.SyslogPort != nil {

		// query param syslog.port
		var qrSyslogPort int64

		if o.SyslogPort != nil {
			qrSyslogPort = *o.SyslogPort
		}
		qSyslogPort := swag.FormatInt64(qrSyslogPort)
		if qSyslogPort != "" {

			if err := r.SetQueryParam("syslog.port", qSyslogPort); err != nil {
				return err
			}
		}
	}

	if o.SyslogTransport != nil {

		// query param syslog.transport
		var qrSyslogTransport string

		if o.SyslogTransport != nil {
			qrSyslogTransport = *o.SyslogTransport
		}
		qSyslogTransport := qrSyslogTransport
		if qSyslogTransport != "" {

			if err := r.SetQueryParam("syslog.transport", qSyslogTransport); err != nil {
				return err
			}
		}
	}

	if o.SystemDefined != nil {

		// query param system_defined
		var qrSystemDefined bool

		if o.SystemDefined != nil {
			qrSystemDefined = *o.SystemDefined
		}
		qSystemDefined := swag.FormatBool(qrSystemDefined)
		if qSystemDefined != "" {

			if err := r.SetQueryParam("system_defined", qSystemDefined); err != nil {
				return err
			}
		}
	}

	if o.Type != nil {

		// query param type
		var qrType string

		if o.Type != nil {
			qrType = *o.Type
		}
		qType := qrType
		if qType != "" {

			if err := r.SetQueryParam("type", qType); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
