// Code generated by go-swagger; DO NOT EDIT.

package support

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// EmsDestinationModifyCollectionReader is a Reader for the EmsDestinationModifyCollection structure.
type EmsDestinationModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *EmsDestinationModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewEmsDestinationModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewEmsDestinationModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewEmsDestinationModifyCollectionOK creates a EmsDestinationModifyCollectionOK with default headers values
func NewEmsDestinationModifyCollectionOK() *EmsDestinationModifyCollectionOK {
	return &EmsDestinationModifyCollectionOK{}
}

/*
EmsDestinationModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type EmsDestinationModifyCollectionOK struct {
	Payload *models.EmsDestination
}

// IsSuccess returns true when this ems destination modify collection o k response has a 2xx status code
func (o *EmsDestinationModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this ems destination modify collection o k response has a 3xx status code
func (o *EmsDestinationModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this ems destination modify collection o k response has a 4xx status code
func (o *EmsDestinationModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this ems destination modify collection o k response has a 5xx status code
func (o *EmsDestinationModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this ems destination modify collection o k response a status code equal to that given
func (o *EmsDestinationModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the ems destination modify collection o k response
func (o *EmsDestinationModifyCollectionOK) Code() int {
	return 200
}

func (o *EmsDestinationModifyCollectionOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /support/ems/destinations][%d] emsDestinationModifyCollectionOK %s", 200, payload)
}

func (o *EmsDestinationModifyCollectionOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /support/ems/destinations][%d] emsDestinationModifyCollectionOK %s", 200, payload)
}

func (o *EmsDestinationModifyCollectionOK) GetPayload() *models.EmsDestination {
	return o.Payload
}

func (o *EmsDestinationModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.EmsDestination)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewEmsDestinationModifyCollectionDefault creates a EmsDestinationModifyCollectionDefault with default headers values
func NewEmsDestinationModifyCollectionDefault(code int) *EmsDestinationModifyCollectionDefault {
	return &EmsDestinationModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	EmsDestinationModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 983088 | The destination name provided cannot be empty |
| 983089 | The destination name provided cannot contain spaces |
| 983094 | The destination name provided is invalid. The destination name must contain between 2 and 64 characters and start and end with an alphanumeric symbol or _(underscore). The allowed special characters are _(underscore) and -(hyphen) |
| 983104 | The syslog destination provided is invalid |
| 983107 | A provided filter does not exist |
| 983116 | The number of notifications has reached maximum capacity |
| 983117 | The number of destinations has reached maximum capacity |
| 983129 | The rest-api destination must contain a valid scheme, such as http// or https// |
| 983130 | The rest-api destination provided contains an invalid URL |
| 983131 | The rest-api destination provided contains an invalid IPv6 URL |
| 983142 | The security certificate provided does not exist |
| 983143 | The private security key provided does not exist |
| 983144 | The security certificate information provided is incomplete. Provide the certificate and serial number |
| 983145 | The rest-api destination provided has an 'http://' scheme. It is invalid to provide certificate information |
| 983150 | The type of an existing destination cannot be changed |
| 983152 | Default destinations cannot be modified or removed |
| 983184 | A provided property cannot be configured on the requested destination type |
| 983200 | Access control role compatibility issue with provided filters |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type EmsDestinationModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this ems destination modify collection default response has a 2xx status code
func (o *EmsDestinationModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this ems destination modify collection default response has a 3xx status code
func (o *EmsDestinationModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this ems destination modify collection default response has a 4xx status code
func (o *EmsDestinationModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this ems destination modify collection default response has a 5xx status code
func (o *EmsDestinationModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this ems destination modify collection default response a status code equal to that given
func (o *EmsDestinationModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the ems destination modify collection default response
func (o *EmsDestinationModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *EmsDestinationModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /support/ems/destinations][%d] ems_destination_modify_collection default %s", o._statusCode, payload)
}

func (o *EmsDestinationModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /support/ems/destinations][%d] ems_destination_modify_collection default %s", o._statusCode, payload)
}

func (o *EmsDestinationModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *EmsDestinationModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
EmsDestinationModifyCollectionBody ems destination modify collection body
swagger:model EmsDestinationModifyCollectionBody
*/
type EmsDestinationModifyCollectionBody struct {

	// links
	Links *models.EmsDestinationResponseInlineRecordsInlineArrayItemInlineLinks `json:"_links,omitempty"`

	// access control role
	AccessControlRole *models.EmsDestinationResponseInlineRecordsInlineArrayItemInlineAccessControlRole `json:"access_control_role,omitempty"`

	// certificate
	Certificate *models.EmsDestinationResponseInlineRecordsInlineArrayItemInlineCertificate `json:"certificate,omitempty"`

	// connectivity
	Connectivity *models.EmsDestinationResponseInlineRecordsInlineArrayItemInlineConnectivity `json:"connectivity,omitempty"`

	// Event destination
	// Example: administrator@mycompany.com
	Destination *string `json:"destination,omitempty"`

	// ems destination response inline records
	EmsDestinationResponseInlineRecords []*models.EmsDestinationResponseInlineRecordsInlineArrayItem `json:"records,omitempty"`

	// filters
	Filters []*EmsDestinationModifyCollectionParamsBodyFiltersItems0 `json:"filters"`

	// Destination name.  Valid in POST.
	// Example: Admin_Email
	Name *string `json:"name,omitempty"`

	// syslog
	Syslog *models.EmsDestinationResponseInlineRecordsInlineArrayItemInlineSyslog `json:"syslog,omitempty"`

	// Flag indicating system-defined destinations.
	// Example: true
	// Read Only: true
	SystemDefined *bool `json:"system_defined,omitempty"`

	// Type of destination. Valid in POST.
	// Example: email
	// Enum: ["snmp","email","syslog","rest_api"]
	Type *string `json:"type,omitempty"`
}

// Validate validates this ems destination modify collection body
func (o *EmsDestinationModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateAccessControlRole(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateCertificate(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateConnectivity(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateEmsDestinationResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateFilters(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSyslog(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsDestinationModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *EmsDestinationModifyCollectionBody) validateAccessControlRole(formats strfmt.Registry) error {
	if swag.IsZero(o.AccessControlRole) { // not required
		return nil
	}

	if o.AccessControlRole != nil {
		if err := o.AccessControlRole.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "access_control_role")
			}
			return err
		}
	}

	return nil
}

func (o *EmsDestinationModifyCollectionBody) validateCertificate(formats strfmt.Registry) error {
	if swag.IsZero(o.Certificate) { // not required
		return nil
	}

	if o.Certificate != nil {
		if err := o.Certificate.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "certificate")
			}
			return err
		}
	}

	return nil
}

func (o *EmsDestinationModifyCollectionBody) validateConnectivity(formats strfmt.Registry) error {
	if swag.IsZero(o.Connectivity) { // not required
		return nil
	}

	if o.Connectivity != nil {
		if err := o.Connectivity.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "connectivity")
			}
			return err
		}
	}

	return nil
}

func (o *EmsDestinationModifyCollectionBody) validateEmsDestinationResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.EmsDestinationResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.EmsDestinationResponseInlineRecords); i++ {
		if swag.IsZero(o.EmsDestinationResponseInlineRecords[i]) { // not required
			continue
		}

		if o.EmsDestinationResponseInlineRecords[i] != nil {
			if err := o.EmsDestinationResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *EmsDestinationModifyCollectionBody) validateFilters(formats strfmt.Registry) error {
	if swag.IsZero(o.Filters) { // not required
		return nil
	}

	for i := 0; i < len(o.Filters); i++ {
		if swag.IsZero(o.Filters[i]) { // not required
			continue
		}

		if o.Filters[i] != nil {
			if err := o.Filters[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "filters" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *EmsDestinationModifyCollectionBody) validateSyslog(formats strfmt.Registry) error {
	if swag.IsZero(o.Syslog) { // not required
		return nil
	}

	if o.Syslog != nil {
		if err := o.Syslog.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "syslog")
			}
			return err
		}
	}

	return nil
}

var emsDestinationModifyCollectionBodyTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["snmp","email","syslog","rest_api"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		emsDestinationModifyCollectionBodyTypeTypePropEnum = append(emsDestinationModifyCollectionBodyTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// EmsDestinationModifyCollectionBody
	// EmsDestinationModifyCollectionBody
	// type
	// Type
	// snmp
	// END DEBUGGING
	// EmsDestinationModifyCollectionBodyTypeSnmp captures enum value "snmp"
	EmsDestinationModifyCollectionBodyTypeSnmp string = "snmp"

	// BEGIN DEBUGGING
	// EmsDestinationModifyCollectionBody
	// EmsDestinationModifyCollectionBody
	// type
	// Type
	// email
	// END DEBUGGING
	// EmsDestinationModifyCollectionBodyTypeEmail captures enum value "email"
	EmsDestinationModifyCollectionBodyTypeEmail string = "email"

	// BEGIN DEBUGGING
	// EmsDestinationModifyCollectionBody
	// EmsDestinationModifyCollectionBody
	// type
	// Type
	// syslog
	// END DEBUGGING
	// EmsDestinationModifyCollectionBodyTypeSyslog captures enum value "syslog"
	EmsDestinationModifyCollectionBodyTypeSyslog string = "syslog"

	// BEGIN DEBUGGING
	// EmsDestinationModifyCollectionBody
	// EmsDestinationModifyCollectionBody
	// type
	// Type
	// rest_api
	// END DEBUGGING
	// EmsDestinationModifyCollectionBodyTypeRestAPI captures enum value "rest_api"
	EmsDestinationModifyCollectionBodyTypeRestAPI string = "rest_api"
)

// prop value enum
func (o *EmsDestinationModifyCollectionBody) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, emsDestinationModifyCollectionBodyTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *EmsDestinationModifyCollectionBody) validateType(formats strfmt.Registry) error {
	if swag.IsZero(o.Type) { // not required
		return nil
	}

	// value enum
	if err := o.validateTypeEnum("info"+"."+"type", "body", *o.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this ems destination modify collection body based on the context it is used
func (o *EmsDestinationModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateAccessControlRole(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateCertificate(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateConnectivity(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateEmsDestinationResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateFilters(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSyslog(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSystemDefined(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsDestinationModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *EmsDestinationModifyCollectionBody) contextValidateAccessControlRole(ctx context.Context, formats strfmt.Registry) error {

	if o.AccessControlRole != nil {
		if err := o.AccessControlRole.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "access_control_role")
			}
			return err
		}
	}

	return nil
}

func (o *EmsDestinationModifyCollectionBody) contextValidateCertificate(ctx context.Context, formats strfmt.Registry) error {

	if o.Certificate != nil {
		if err := o.Certificate.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "certificate")
			}
			return err
		}
	}

	return nil
}

func (o *EmsDestinationModifyCollectionBody) contextValidateConnectivity(ctx context.Context, formats strfmt.Registry) error {

	if o.Connectivity != nil {
		if err := o.Connectivity.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "connectivity")
			}
			return err
		}
	}

	return nil
}

func (o *EmsDestinationModifyCollectionBody) contextValidateEmsDestinationResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.EmsDestinationResponseInlineRecords); i++ {

		if o.EmsDestinationResponseInlineRecords[i] != nil {
			if err := o.EmsDestinationResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *EmsDestinationModifyCollectionBody) contextValidateFilters(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.Filters); i++ {

		if o.Filters[i] != nil {
			if err := o.Filters[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "filters" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *EmsDestinationModifyCollectionBody) contextValidateSyslog(ctx context.Context, formats strfmt.Registry) error {

	if o.Syslog != nil {
		if err := o.Syslog.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "syslog")
			}
			return err
		}
	}

	return nil
}

func (o *EmsDestinationModifyCollectionBody) contextValidateSystemDefined(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"system_defined", "body", o.SystemDefined); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *EmsDestinationModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *EmsDestinationModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res EmsDestinationModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
EmsDestinationModifyCollectionParamsBodyConnectivityErrorsItems0 Error object included in the event of connectivity failure.
swagger:model EmsDestinationModifyCollectionParamsBodyConnectivityErrorsItems0
*/
type EmsDestinationModifyCollectionParamsBodyConnectivityErrorsItems0 struct {

	// message
	Message *EmsDestinationModifyCollectionParamsBodyConnectivityErrorsItems0Message `json:"message,omitempty"`

	// node
	Node *EmsDestinationModifyCollectionParamsBodyConnectivityErrorsItems0Node `json:"node,omitempty"`
}

// Validate validates this ems destination modify collection params body connectivity errors items0
func (o *EmsDestinationModifyCollectionParamsBodyConnectivityErrorsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateMessage(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsDestinationModifyCollectionParamsBodyConnectivityErrorsItems0) validateMessage(formats strfmt.Registry) error {
	if swag.IsZero(o.Message) { // not required
		return nil
	}

	if o.Message != nil {
		if err := o.Message.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("message")
			}
			return err
		}
	}

	return nil
}

func (o *EmsDestinationModifyCollectionParamsBodyConnectivityErrorsItems0) validateNode(formats strfmt.Registry) error {
	if swag.IsZero(o.Node) { // not required
		return nil
	}

	if o.Node != nil {
		if err := o.Node.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ems destination modify collection params body connectivity errors items0 based on the context it is used
func (o *EmsDestinationModifyCollectionParamsBodyConnectivityErrorsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsDestinationModifyCollectionParamsBodyConnectivityErrorsItems0) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if o.Message != nil {
		if err := o.Message.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("message")
			}
			return err
		}
	}

	return nil
}

func (o *EmsDestinationModifyCollectionParamsBodyConnectivityErrorsItems0) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if o.Node != nil {
		if err := o.Node.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *EmsDestinationModifyCollectionParamsBodyConnectivityErrorsItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *EmsDestinationModifyCollectionParamsBodyConnectivityErrorsItems0) UnmarshalBinary(b []byte) error {
	var res EmsDestinationModifyCollectionParamsBodyConnectivityErrorsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
EmsDestinationModifyCollectionParamsBodyConnectivityErrorsItems0Message Information to be displayed to the user.
swagger:model EmsDestinationModifyCollectionParamsBodyConnectivityErrorsItems0Message
*/
type EmsDestinationModifyCollectionParamsBodyConnectivityErrorsItems0Message struct {

	// Message arguments
	// Read Only: true
	Arguments []*EmsDestinationModifyCollectionParamsBodyConnectivityErrorsItems0MessageArgumentsItems0 `json:"arguments"`

	// Unique message code.
	// Example: 4
	// Read Only: true
	Code *string `json:"code,omitempty"`

	// User message.
	// Example: entry doesn't exist
	// Read Only: true
	Message *string `json:"message,omitempty"`
}

// Validate validates this ems destination modify collection params body connectivity errors items0 message
func (o *EmsDestinationModifyCollectionParamsBodyConnectivityErrorsItems0Message) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateArguments(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsDestinationModifyCollectionParamsBodyConnectivityErrorsItems0Message) validateArguments(formats strfmt.Registry) error {
	if swag.IsZero(o.Arguments) { // not required
		return nil
	}

	for i := 0; i < len(o.Arguments); i++ {
		if swag.IsZero(o.Arguments[i]) { // not required
			continue
		}

		if o.Arguments[i] != nil {
			if err := o.Arguments[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("message" + "." + "arguments" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this ems destination modify collection params body connectivity errors items0 message based on the context it is used
func (o *EmsDestinationModifyCollectionParamsBodyConnectivityErrorsItems0Message) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateArguments(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateCode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsDestinationModifyCollectionParamsBodyConnectivityErrorsItems0Message) contextValidateArguments(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "message"+"."+"arguments", "body", []*EmsDestinationModifyCollectionParamsBodyConnectivityErrorsItems0MessageArgumentsItems0(o.Arguments)); err != nil {
		return err
	}

	for i := 0; i < len(o.Arguments); i++ {

		if o.Arguments[i] != nil {
			if err := o.Arguments[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("message" + "." + "arguments" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *EmsDestinationModifyCollectionParamsBodyConnectivityErrorsItems0Message) contextValidateCode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "message"+"."+"code", "body", o.Code); err != nil {
		return err
	}

	return nil
}

func (o *EmsDestinationModifyCollectionParamsBodyConnectivityErrorsItems0Message) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "message"+"."+"message", "body", o.Message); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *EmsDestinationModifyCollectionParamsBodyConnectivityErrorsItems0Message) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *EmsDestinationModifyCollectionParamsBodyConnectivityErrorsItems0Message) UnmarshalBinary(b []byte) error {
	var res EmsDestinationModifyCollectionParamsBodyConnectivityErrorsItems0Message
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
EmsDestinationModifyCollectionParamsBodyConnectivityErrorsItems0MessageArgumentsItems0 ems destination modify collection params body connectivity errors items0 message arguments items0
swagger:model EmsDestinationModifyCollectionParamsBodyConnectivityErrorsItems0MessageArgumentsItems0
*/
type EmsDestinationModifyCollectionParamsBodyConnectivityErrorsItems0MessageArgumentsItems0 struct {

	// Argument code
	// Read Only: true
	Code *string `json:"code,omitempty"`

	// Message argument
	// Read Only: true
	Message *string `json:"message,omitempty"`
}

// Validate validates this ems destination modify collection params body connectivity errors items0 message arguments items0
func (o *EmsDestinationModifyCollectionParamsBodyConnectivityErrorsItems0MessageArgumentsItems0) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this ems destination modify collection params body connectivity errors items0 message arguments items0 based on the context it is used
func (o *EmsDestinationModifyCollectionParamsBodyConnectivityErrorsItems0MessageArgumentsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateCode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsDestinationModifyCollectionParamsBodyConnectivityErrorsItems0MessageArgumentsItems0) contextValidateCode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "code", "body", o.Code); err != nil {
		return err
	}

	return nil
}

func (o *EmsDestinationModifyCollectionParamsBodyConnectivityErrorsItems0MessageArgumentsItems0) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "message", "body", o.Message); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *EmsDestinationModifyCollectionParamsBodyConnectivityErrorsItems0MessageArgumentsItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *EmsDestinationModifyCollectionParamsBodyConnectivityErrorsItems0MessageArgumentsItems0) UnmarshalBinary(b []byte) error {
	var res EmsDestinationModifyCollectionParamsBodyConnectivityErrorsItems0MessageArgumentsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
EmsDestinationModifyCollectionParamsBodyConnectivityErrorsItems0Node ems destination modify collection params body connectivity errors items0 node
swagger:model EmsDestinationModifyCollectionParamsBodyConnectivityErrorsItems0Node
*/
type EmsDestinationModifyCollectionParamsBodyConnectivityErrorsItems0Node struct {

	// links
	Links *EmsDestinationModifyCollectionParamsBodyConnectivityErrorsItems0NodeLinks `json:"_links,omitempty"`

	// name
	// Example: node1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this ems destination modify collection params body connectivity errors items0 node
func (o *EmsDestinationModifyCollectionParamsBodyConnectivityErrorsItems0Node) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsDestinationModifyCollectionParamsBodyConnectivityErrorsItems0Node) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ems destination modify collection params body connectivity errors items0 node based on the context it is used
func (o *EmsDestinationModifyCollectionParamsBodyConnectivityErrorsItems0Node) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsDestinationModifyCollectionParamsBodyConnectivityErrorsItems0Node) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *EmsDestinationModifyCollectionParamsBodyConnectivityErrorsItems0Node) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *EmsDestinationModifyCollectionParamsBodyConnectivityErrorsItems0Node) UnmarshalBinary(b []byte) error {
	var res EmsDestinationModifyCollectionParamsBodyConnectivityErrorsItems0Node
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
EmsDestinationModifyCollectionParamsBodyConnectivityErrorsItems0NodeLinks ems destination modify collection params body connectivity errors items0 node links
swagger:model EmsDestinationModifyCollectionParamsBodyConnectivityErrorsItems0NodeLinks
*/
type EmsDestinationModifyCollectionParamsBodyConnectivityErrorsItems0NodeLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this ems destination modify collection params body connectivity errors items0 node links
func (o *EmsDestinationModifyCollectionParamsBodyConnectivityErrorsItems0NodeLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsDestinationModifyCollectionParamsBodyConnectivityErrorsItems0NodeLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ems destination modify collection params body connectivity errors items0 node links based on the context it is used
func (o *EmsDestinationModifyCollectionParamsBodyConnectivityErrorsItems0NodeLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsDestinationModifyCollectionParamsBodyConnectivityErrorsItems0NodeLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *EmsDestinationModifyCollectionParamsBodyConnectivityErrorsItems0NodeLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *EmsDestinationModifyCollectionParamsBodyConnectivityErrorsItems0NodeLinks) UnmarshalBinary(b []byte) error {
	var res EmsDestinationModifyCollectionParamsBodyConnectivityErrorsItems0NodeLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
EmsDestinationModifyCollectionParamsBodyFiltersItems0 ems destination modify collection params body filters items0
swagger:model EmsDestinationModifyCollectionParamsBodyFiltersItems0
*/
type EmsDestinationModifyCollectionParamsBodyFiltersItems0 struct {

	// links
	Links *EmsDestinationModifyCollectionParamsBodyFiltersItems0Links `json:"_links,omitempty"`

	// name
	// Example: important-events
	Name *string `json:"name,omitempty"`
}

// Validate validates this ems destination modify collection params body filters items0
func (o *EmsDestinationModifyCollectionParamsBodyFiltersItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsDestinationModifyCollectionParamsBodyFiltersItems0) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ems destination modify collection params body filters items0 based on the context it is used
func (o *EmsDestinationModifyCollectionParamsBodyFiltersItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsDestinationModifyCollectionParamsBodyFiltersItems0) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *EmsDestinationModifyCollectionParamsBodyFiltersItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *EmsDestinationModifyCollectionParamsBodyFiltersItems0) UnmarshalBinary(b []byte) error {
	var res EmsDestinationModifyCollectionParamsBodyFiltersItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
EmsDestinationModifyCollectionParamsBodyFiltersItems0Links ems destination modify collection params body filters items0 links
swagger:model EmsDestinationModifyCollectionParamsBodyFiltersItems0Links
*/
type EmsDestinationModifyCollectionParamsBodyFiltersItems0Links struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this ems destination modify collection params body filters items0 links
func (o *EmsDestinationModifyCollectionParamsBodyFiltersItems0Links) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsDestinationModifyCollectionParamsBodyFiltersItems0Links) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ems destination modify collection params body filters items0 links based on the context it is used
func (o *EmsDestinationModifyCollectionParamsBodyFiltersItems0Links) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsDestinationModifyCollectionParamsBodyFiltersItems0Links) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *EmsDestinationModifyCollectionParamsBodyFiltersItems0Links) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *EmsDestinationModifyCollectionParamsBodyFiltersItems0Links) UnmarshalBinary(b []byte) error {
	var res EmsDestinationModifyCollectionParamsBodyFiltersItems0Links
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
EmsDestinationModifyCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0 Error object included in the event of connectivity failure.
swagger:model EmsDestinationModifyCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0
*/
type EmsDestinationModifyCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0 struct {

	// message
	Message *EmsDestinationModifyCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0Message `json:"message,omitempty"`

	// node
	Node *EmsDestinationModifyCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0Node `json:"node,omitempty"`
}

// Validate validates this ems destination modify collection params body records items0 connectivity errors items0
func (o *EmsDestinationModifyCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateMessage(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsDestinationModifyCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0) validateMessage(formats strfmt.Registry) error {
	if swag.IsZero(o.Message) { // not required
		return nil
	}

	if o.Message != nil {
		if err := o.Message.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("message")
			}
			return err
		}
	}

	return nil
}

func (o *EmsDestinationModifyCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0) validateNode(formats strfmt.Registry) error {
	if swag.IsZero(o.Node) { // not required
		return nil
	}

	if o.Node != nil {
		if err := o.Node.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ems destination modify collection params body records items0 connectivity errors items0 based on the context it is used
func (o *EmsDestinationModifyCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsDestinationModifyCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if o.Message != nil {
		if err := o.Message.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("message")
			}
			return err
		}
	}

	return nil
}

func (o *EmsDestinationModifyCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if o.Node != nil {
		if err := o.Node.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *EmsDestinationModifyCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *EmsDestinationModifyCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0) UnmarshalBinary(b []byte) error {
	var res EmsDestinationModifyCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
EmsDestinationModifyCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0Message Information to be displayed to the user.
swagger:model EmsDestinationModifyCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0Message
*/
type EmsDestinationModifyCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0Message struct {

	// Message arguments
	// Read Only: true
	Arguments []*EmsDestinationModifyCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0MessageArgumentsItems0 `json:"arguments"`

	// Unique message code.
	// Example: 4
	// Read Only: true
	Code *string `json:"code,omitempty"`

	// User message.
	// Example: entry doesn't exist
	// Read Only: true
	Message *string `json:"message,omitempty"`
}

// Validate validates this ems destination modify collection params body records items0 connectivity errors items0 message
func (o *EmsDestinationModifyCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0Message) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateArguments(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsDestinationModifyCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0Message) validateArguments(formats strfmt.Registry) error {
	if swag.IsZero(o.Arguments) { // not required
		return nil
	}

	for i := 0; i < len(o.Arguments); i++ {
		if swag.IsZero(o.Arguments[i]) { // not required
			continue
		}

		if o.Arguments[i] != nil {
			if err := o.Arguments[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("message" + "." + "arguments" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this ems destination modify collection params body records items0 connectivity errors items0 message based on the context it is used
func (o *EmsDestinationModifyCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0Message) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateArguments(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateCode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsDestinationModifyCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0Message) contextValidateArguments(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "message"+"."+"arguments", "body", []*EmsDestinationModifyCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0MessageArgumentsItems0(o.Arguments)); err != nil {
		return err
	}

	for i := 0; i < len(o.Arguments); i++ {

		if o.Arguments[i] != nil {
			if err := o.Arguments[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("message" + "." + "arguments" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *EmsDestinationModifyCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0Message) contextValidateCode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "message"+"."+"code", "body", o.Code); err != nil {
		return err
	}

	return nil
}

func (o *EmsDestinationModifyCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0Message) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "message"+"."+"message", "body", o.Message); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *EmsDestinationModifyCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0Message) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *EmsDestinationModifyCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0Message) UnmarshalBinary(b []byte) error {
	var res EmsDestinationModifyCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0Message
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
EmsDestinationModifyCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0MessageArgumentsItems0 ems destination modify collection params body records items0 connectivity errors items0 message arguments items0
swagger:model EmsDestinationModifyCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0MessageArgumentsItems0
*/
type EmsDestinationModifyCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0MessageArgumentsItems0 struct {

	// Argument code
	// Read Only: true
	Code *string `json:"code,omitempty"`

	// Message argument
	// Read Only: true
	Message *string `json:"message,omitempty"`
}

// Validate validates this ems destination modify collection params body records items0 connectivity errors items0 message arguments items0
func (o *EmsDestinationModifyCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0MessageArgumentsItems0) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this ems destination modify collection params body records items0 connectivity errors items0 message arguments items0 based on the context it is used
func (o *EmsDestinationModifyCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0MessageArgumentsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateCode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsDestinationModifyCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0MessageArgumentsItems0) contextValidateCode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "code", "body", o.Code); err != nil {
		return err
	}

	return nil
}

func (o *EmsDestinationModifyCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0MessageArgumentsItems0) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "message", "body", o.Message); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *EmsDestinationModifyCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0MessageArgumentsItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *EmsDestinationModifyCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0MessageArgumentsItems0) UnmarshalBinary(b []byte) error {
	var res EmsDestinationModifyCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0MessageArgumentsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
EmsDestinationModifyCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0Node ems destination modify collection params body records items0 connectivity errors items0 node
swagger:model EmsDestinationModifyCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0Node
*/
type EmsDestinationModifyCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0Node struct {

	// links
	Links *EmsDestinationModifyCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0NodeLinks `json:"_links,omitempty"`

	// name
	// Example: node1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this ems destination modify collection params body records items0 connectivity errors items0 node
func (o *EmsDestinationModifyCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0Node) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsDestinationModifyCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0Node) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ems destination modify collection params body records items0 connectivity errors items0 node based on the context it is used
func (o *EmsDestinationModifyCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0Node) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsDestinationModifyCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0Node) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *EmsDestinationModifyCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0Node) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *EmsDestinationModifyCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0Node) UnmarshalBinary(b []byte) error {
	var res EmsDestinationModifyCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0Node
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
EmsDestinationModifyCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0NodeLinks ems destination modify collection params body records items0 connectivity errors items0 node links
swagger:model EmsDestinationModifyCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0NodeLinks
*/
type EmsDestinationModifyCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0NodeLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this ems destination modify collection params body records items0 connectivity errors items0 node links
func (o *EmsDestinationModifyCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0NodeLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsDestinationModifyCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0NodeLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ems destination modify collection params body records items0 connectivity errors items0 node links based on the context it is used
func (o *EmsDestinationModifyCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0NodeLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsDestinationModifyCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0NodeLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *EmsDestinationModifyCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0NodeLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *EmsDestinationModifyCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0NodeLinks) UnmarshalBinary(b []byte) error {
	var res EmsDestinationModifyCollectionParamsBodyRecordsItems0ConnectivityErrorsItems0NodeLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
EmsDestinationModifyCollectionParamsBodyRecordsItems0FiltersItems0 ems destination modify collection params body records items0 filters items0
swagger:model EmsDestinationModifyCollectionParamsBodyRecordsItems0FiltersItems0
*/
type EmsDestinationModifyCollectionParamsBodyRecordsItems0FiltersItems0 struct {

	// links
	Links *EmsDestinationModifyCollectionParamsBodyRecordsItems0FiltersItems0Links `json:"_links,omitempty"`

	// name
	// Example: important-events
	Name *string `json:"name,omitempty"`
}

// Validate validates this ems destination modify collection params body records items0 filters items0
func (o *EmsDestinationModifyCollectionParamsBodyRecordsItems0FiltersItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsDestinationModifyCollectionParamsBodyRecordsItems0FiltersItems0) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ems destination modify collection params body records items0 filters items0 based on the context it is used
func (o *EmsDestinationModifyCollectionParamsBodyRecordsItems0FiltersItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsDestinationModifyCollectionParamsBodyRecordsItems0FiltersItems0) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *EmsDestinationModifyCollectionParamsBodyRecordsItems0FiltersItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *EmsDestinationModifyCollectionParamsBodyRecordsItems0FiltersItems0) UnmarshalBinary(b []byte) error {
	var res EmsDestinationModifyCollectionParamsBodyRecordsItems0FiltersItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
EmsDestinationModifyCollectionParamsBodyRecordsItems0FiltersItems0Links ems destination modify collection params body records items0 filters items0 links
swagger:model EmsDestinationModifyCollectionParamsBodyRecordsItems0FiltersItems0Links
*/
type EmsDestinationModifyCollectionParamsBodyRecordsItems0FiltersItems0Links struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this ems destination modify collection params body records items0 filters items0 links
func (o *EmsDestinationModifyCollectionParamsBodyRecordsItems0FiltersItems0Links) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsDestinationModifyCollectionParamsBodyRecordsItems0FiltersItems0Links) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ems destination modify collection params body records items0 filters items0 links based on the context it is used
func (o *EmsDestinationModifyCollectionParamsBodyRecordsItems0FiltersItems0Links) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsDestinationModifyCollectionParamsBodyRecordsItems0FiltersItems0Links) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *EmsDestinationModifyCollectionParamsBodyRecordsItems0FiltersItems0Links) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *EmsDestinationModifyCollectionParamsBodyRecordsItems0FiltersItems0Links) UnmarshalBinary(b []byte) error {
	var res EmsDestinationModifyCollectionParamsBodyRecordsItems0FiltersItems0Links
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
