// Code generated by go-swagger; DO NOT EDIT.

package support

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// EmsDestinationModifyReader is a Reader for the EmsDestinationModify structure.
type EmsDestinationModifyReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *EmsDestinationModifyReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewEmsDestinationModifyOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewEmsDestinationModifyDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewEmsDestinationModifyOK creates a EmsDestinationModifyOK with default headers values
func NewEmsDestinationModifyOK() *EmsDestinationModifyOK {
	return &EmsDestinationModifyOK{}
}

/*
EmsDestinationModifyOK describes a response with status code 200, with default header values.

OK
*/
type EmsDestinationModifyOK struct {
	Payload *models.EmsDestination
}

// IsSuccess returns true when this ems destination modify o k response has a 2xx status code
func (o *EmsDestinationModifyOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this ems destination modify o k response has a 3xx status code
func (o *EmsDestinationModifyOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this ems destination modify o k response has a 4xx status code
func (o *EmsDestinationModifyOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this ems destination modify o k response has a 5xx status code
func (o *EmsDestinationModifyOK) IsServerError() bool {
	return false
}

// IsCode returns true when this ems destination modify o k response a status code equal to that given
func (o *EmsDestinationModifyOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the ems destination modify o k response
func (o *EmsDestinationModifyOK) Code() int {
	return 200
}

func (o *EmsDestinationModifyOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /support/ems/destinations/{name}][%d] emsDestinationModifyOK %s", 200, payload)
}

func (o *EmsDestinationModifyOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /support/ems/destinations/{name}][%d] emsDestinationModifyOK %s", 200, payload)
}

func (o *EmsDestinationModifyOK) GetPayload() *models.EmsDestination {
	return o.Payload
}

func (o *EmsDestinationModifyOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.EmsDestination)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewEmsDestinationModifyDefault creates a EmsDestinationModifyDefault with default headers values
func NewEmsDestinationModifyDefault(code int) *EmsDestinationModifyDefault {
	return &EmsDestinationModifyDefault{
		_statusCode: code,
	}
}

/*
	EmsDestinationModifyDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 983088 | The destination name provided cannot be empty |
| 983089 | The destination name provided cannot contain spaces |
| 983094 | The destination name provided is invalid. The destination name must contain between 2 and 64 characters and start and end with an alphanumeric symbol or _(underscore). The allowed special characters are _(underscore) and -(hyphen) |
| 983104 | The syslog destination provided is invalid |
| 983107 | A provided filter does not exist |
| 983116 | The number of notifications has reached maximum capacity |
| 983117 | The number of destinations has reached maximum capacity |
| 983129 | The rest-api destination must contain a valid scheme, such as http// or https// |
| 983130 | The rest-api destination provided contains an invalid URL |
| 983131 | The rest-api destination provided contains an invalid IPv6 URL |
| 983142 | The security certificate provided does not exist |
| 983143 | The private security key provided does not exist |
| 983144 | The security certificate information provided is incomplete. Provide the certificate and serial number |
| 983145 | The rest-api destination provided has an 'http://' scheme. It is invalid to provide certificate information |
| 983150 | The type of an existing destination cannot be changed |
| 983152 | Default destinations cannot be modified or removed |
| 983184 | A provided property cannot be configured on the requested destination type |
| 983200 | Access control role compatibility issue with provided filters |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type EmsDestinationModifyDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this ems destination modify default response has a 2xx status code
func (o *EmsDestinationModifyDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this ems destination modify default response has a 3xx status code
func (o *EmsDestinationModifyDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this ems destination modify default response has a 4xx status code
func (o *EmsDestinationModifyDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this ems destination modify default response has a 5xx status code
func (o *EmsDestinationModifyDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this ems destination modify default response a status code equal to that given
func (o *EmsDestinationModifyDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the ems destination modify default response
func (o *EmsDestinationModifyDefault) Code() int {
	return o._statusCode
}

func (o *EmsDestinationModifyDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /support/ems/destinations/{name}][%d] ems_destination_modify default %s", o._statusCode, payload)
}

func (o *EmsDestinationModifyDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /support/ems/destinations/{name}][%d] ems_destination_modify default %s", o._statusCode, payload)
}

func (o *EmsDestinationModifyDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *EmsDestinationModifyDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
