// Code generated by go-swagger; DO NOT EDIT.

package support

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewEmsEventCollectionGetParams creates a new EmsEventCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewEmsEventCollectionGetParams() *EmsEventCollectionGetParams {
	return &EmsEventCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewEmsEventCollectionGetParamsWithTimeout creates a new EmsEventCollectionGetParams object
// with the ability to set a timeout on a request.
func NewEmsEventCollectionGetParamsWithTimeout(timeout time.Duration) *EmsEventCollectionGetParams {
	return &EmsEventCollectionGetParams{
		timeout: timeout,
	}
}

// NewEmsEventCollectionGetParamsWithContext creates a new EmsEventCollectionGetParams object
// with the ability to set a context for a request.
func NewEmsEventCollectionGetParamsWithContext(ctx context.Context) *EmsEventCollectionGetParams {
	return &EmsEventCollectionGetParams{
		Context: ctx,
	}
}

// NewEmsEventCollectionGetParamsWithHTTPClient creates a new EmsEventCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewEmsEventCollectionGetParamsWithHTTPClient(client *http.Client) *EmsEventCollectionGetParams {
	return &EmsEventCollectionGetParams{
		HTTPClient: client,
	}
}

/*
EmsEventCollectionGetParams contains all the parameters to send to the API endpoint

	for the ems event collection get operation.

	Typically these are written to a http.Request.
*/
type EmsEventCollectionGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* FilterName.

	   Filter the collection returned using an event filter
	*/
	FilterName *string

	/* Index.

	   Filter by index
	*/
	Index *int64

	/* LogMessage.

	   Filter by log_message
	*/
	LogMessage *string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* MessageName.

	   Filter by message.name
	*/
	MessageName *string

	/* MessageSeverity.

	   Filter by message.severity
	*/
	MessageSeverity *string

	/* NodeName.

	   Filter by node.name
	*/
	NodeName *string

	/* NodeUUID.

	   Filter by node.uuid
	*/
	NodeUUID *string

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* ParametersName.

	   Filter by parameters.name
	*/
	ParametersName *string

	/* ParametersValue.

	   Filter by parameters.value
	*/
	ParametersValue *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* Source.

	   Filter by source
	*/
	Source *string

	/* Time.

	   Filter by time
	*/
	Time *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the ems event collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *EmsEventCollectionGetParams) WithDefaults() *EmsEventCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the ems event collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *EmsEventCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := EmsEventCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the ems event collection get params
func (o *EmsEventCollectionGetParams) WithTimeout(timeout time.Duration) *EmsEventCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the ems event collection get params
func (o *EmsEventCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the ems event collection get params
func (o *EmsEventCollectionGetParams) WithContext(ctx context.Context) *EmsEventCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the ems event collection get params
func (o *EmsEventCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the ems event collection get params
func (o *EmsEventCollectionGetParams) WithHTTPClient(client *http.Client) *EmsEventCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the ems event collection get params
func (o *EmsEventCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the ems event collection get params
func (o *EmsEventCollectionGetParams) WithFields(fields []string) *EmsEventCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the ems event collection get params
func (o *EmsEventCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithFilterName adds the filterName to the ems event collection get params
func (o *EmsEventCollectionGetParams) WithFilterName(filterName *string) *EmsEventCollectionGetParams {
	o.SetFilterName(filterName)
	return o
}

// SetFilterName adds the filterName to the ems event collection get params
func (o *EmsEventCollectionGetParams) SetFilterName(filterName *string) {
	o.FilterName = filterName
}

// WithIndex adds the index to the ems event collection get params
func (o *EmsEventCollectionGetParams) WithIndex(index *int64) *EmsEventCollectionGetParams {
	o.SetIndex(index)
	return o
}

// SetIndex adds the index to the ems event collection get params
func (o *EmsEventCollectionGetParams) SetIndex(index *int64) {
	o.Index = index
}

// WithLogMessage adds the logMessage to the ems event collection get params
func (o *EmsEventCollectionGetParams) WithLogMessage(logMessage *string) *EmsEventCollectionGetParams {
	o.SetLogMessage(logMessage)
	return o
}

// SetLogMessage adds the logMessage to the ems event collection get params
func (o *EmsEventCollectionGetParams) SetLogMessage(logMessage *string) {
	o.LogMessage = logMessage
}

// WithMaxRecords adds the maxRecords to the ems event collection get params
func (o *EmsEventCollectionGetParams) WithMaxRecords(maxRecords *int64) *EmsEventCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the ems event collection get params
func (o *EmsEventCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithMessageName adds the messageName to the ems event collection get params
func (o *EmsEventCollectionGetParams) WithMessageName(messageName *string) *EmsEventCollectionGetParams {
	o.SetMessageName(messageName)
	return o
}

// SetMessageName adds the messageName to the ems event collection get params
func (o *EmsEventCollectionGetParams) SetMessageName(messageName *string) {
	o.MessageName = messageName
}

// WithMessageSeverity adds the messageSeverity to the ems event collection get params
func (o *EmsEventCollectionGetParams) WithMessageSeverity(messageSeverity *string) *EmsEventCollectionGetParams {
	o.SetMessageSeverity(messageSeverity)
	return o
}

// SetMessageSeverity adds the messageSeverity to the ems event collection get params
func (o *EmsEventCollectionGetParams) SetMessageSeverity(messageSeverity *string) {
	o.MessageSeverity = messageSeverity
}

// WithNodeName adds the nodeName to the ems event collection get params
func (o *EmsEventCollectionGetParams) WithNodeName(nodeName *string) *EmsEventCollectionGetParams {
	o.SetNodeName(nodeName)
	return o
}

// SetNodeName adds the nodeName to the ems event collection get params
func (o *EmsEventCollectionGetParams) SetNodeName(nodeName *string) {
	o.NodeName = nodeName
}

// WithNodeUUID adds the nodeUUID to the ems event collection get params
func (o *EmsEventCollectionGetParams) WithNodeUUID(nodeUUID *string) *EmsEventCollectionGetParams {
	o.SetNodeUUID(nodeUUID)
	return o
}

// SetNodeUUID adds the nodeUuid to the ems event collection get params
func (o *EmsEventCollectionGetParams) SetNodeUUID(nodeUUID *string) {
	o.NodeUUID = nodeUUID
}

// WithOrderBy adds the orderBy to the ems event collection get params
func (o *EmsEventCollectionGetParams) WithOrderBy(orderBy []string) *EmsEventCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the ems event collection get params
func (o *EmsEventCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithParametersName adds the parametersName to the ems event collection get params
func (o *EmsEventCollectionGetParams) WithParametersName(parametersName *string) *EmsEventCollectionGetParams {
	o.SetParametersName(parametersName)
	return o
}

// SetParametersName adds the parametersName to the ems event collection get params
func (o *EmsEventCollectionGetParams) SetParametersName(parametersName *string) {
	o.ParametersName = parametersName
}

// WithParametersValue adds the parametersValue to the ems event collection get params
func (o *EmsEventCollectionGetParams) WithParametersValue(parametersValue *string) *EmsEventCollectionGetParams {
	o.SetParametersValue(parametersValue)
	return o
}

// SetParametersValue adds the parametersValue to the ems event collection get params
func (o *EmsEventCollectionGetParams) SetParametersValue(parametersValue *string) {
	o.ParametersValue = parametersValue
}

// WithReturnRecords adds the returnRecords to the ems event collection get params
func (o *EmsEventCollectionGetParams) WithReturnRecords(returnRecords *bool) *EmsEventCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the ems event collection get params
func (o *EmsEventCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the ems event collection get params
func (o *EmsEventCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *EmsEventCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the ems event collection get params
func (o *EmsEventCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSource adds the source to the ems event collection get params
func (o *EmsEventCollectionGetParams) WithSource(source *string) *EmsEventCollectionGetParams {
	o.SetSource(source)
	return o
}

// SetSource adds the source to the ems event collection get params
func (o *EmsEventCollectionGetParams) SetSource(source *string) {
	o.Source = source
}

// WithTime adds the time to the ems event collection get params
func (o *EmsEventCollectionGetParams) WithTime(time *string) *EmsEventCollectionGetParams {
	o.SetTime(time)
	return o
}

// SetTime adds the time to the ems event collection get params
func (o *EmsEventCollectionGetParams) SetTime(time *string) {
	o.Time = time
}

// WriteToRequest writes these params to a swagger request
func (o *EmsEventCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.FilterName != nil {

		// query param filter.name
		var qrFilterName string

		if o.FilterName != nil {
			qrFilterName = *o.FilterName
		}
		qFilterName := qrFilterName
		if qFilterName != "" {

			if err := r.SetQueryParam("filter.name", qFilterName); err != nil {
				return err
			}
		}
	}

	if o.Index != nil {

		// query param index
		var qrIndex int64

		if o.Index != nil {
			qrIndex = *o.Index
		}
		qIndex := swag.FormatInt64(qrIndex)
		if qIndex != "" {

			if err := r.SetQueryParam("index", qIndex); err != nil {
				return err
			}
		}
	}

	if o.LogMessage != nil {

		// query param log_message
		var qrLogMessage string

		if o.LogMessage != nil {
			qrLogMessage = *o.LogMessage
		}
		qLogMessage := qrLogMessage
		if qLogMessage != "" {

			if err := r.SetQueryParam("log_message", qLogMessage); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.MessageName != nil {

		// query param message.name
		var qrMessageName string

		if o.MessageName != nil {
			qrMessageName = *o.MessageName
		}
		qMessageName := qrMessageName
		if qMessageName != "" {

			if err := r.SetQueryParam("message.name", qMessageName); err != nil {
				return err
			}
		}
	}

	if o.MessageSeverity != nil {

		// query param message.severity
		var qrMessageSeverity string

		if o.MessageSeverity != nil {
			qrMessageSeverity = *o.MessageSeverity
		}
		qMessageSeverity := qrMessageSeverity
		if qMessageSeverity != "" {

			if err := r.SetQueryParam("message.severity", qMessageSeverity); err != nil {
				return err
			}
		}
	}

	if o.NodeName != nil {

		// query param node.name
		var qrNodeName string

		if o.NodeName != nil {
			qrNodeName = *o.NodeName
		}
		qNodeName := qrNodeName
		if qNodeName != "" {

			if err := r.SetQueryParam("node.name", qNodeName); err != nil {
				return err
			}
		}
	}

	if o.NodeUUID != nil {

		// query param node.uuid
		var qrNodeUUID string

		if o.NodeUUID != nil {
			qrNodeUUID = *o.NodeUUID
		}
		qNodeUUID := qrNodeUUID
		if qNodeUUID != "" {

			if err := r.SetQueryParam("node.uuid", qNodeUUID); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.ParametersName != nil {

		// query param parameters.name
		var qrParametersName string

		if o.ParametersName != nil {
			qrParametersName = *o.ParametersName
		}
		qParametersName := qrParametersName
		if qParametersName != "" {

			if err := r.SetQueryParam("parameters.name", qParametersName); err != nil {
				return err
			}
		}
	}

	if o.ParametersValue != nil {

		// query param parameters.value
		var qrParametersValue string

		if o.ParametersValue != nil {
			qrParametersValue = *o.ParametersValue
		}
		qParametersValue := qrParametersValue
		if qParametersValue != "" {

			if err := r.SetQueryParam("parameters.value", qParametersValue); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.Source != nil {

		// query param source
		var qrSource string

		if o.Source != nil {
			qrSource = *o.Source
		}
		qSource := qrSource
		if qSource != "" {

			if err := r.SetQueryParam("source", qSource); err != nil {
				return err
			}
		}
	}

	if o.Time != nil {

		// query param time
		var qrTime string

		if o.Time != nil {
			qrTime = *o.Time
		}
		qTime := qrTime
		if qTime != "" {

			if err := r.SetQueryParam("time", qTime); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamEmsEventCollectionGet binds the parameter fields
func (o *EmsEventCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamEmsEventCollectionGet binds the parameter order_by
func (o *EmsEventCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
