// Code generated by go-swagger; DO NOT EDIT.

package support

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// EmsFilterDeleteCollectionReader is a Reader for the EmsFilterDeleteCollection structure.
type EmsFilterDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *EmsFilterDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewEmsFilterDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewEmsFilterDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewEmsFilterDeleteCollectionOK creates a EmsFilterDeleteCollectionOK with default headers values
func NewEmsFilterDeleteCollectionOK() *EmsFilterDeleteCollectionOK {
	return &EmsFilterDeleteCollectionOK{}
}

/*
EmsFilterDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type EmsFilterDeleteCollectionOK struct {
}

// IsSuccess returns true when this ems filter delete collection o k response has a 2xx status code
func (o *EmsFilterDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this ems filter delete collection o k response has a 3xx status code
func (o *EmsFilterDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this ems filter delete collection o k response has a 4xx status code
func (o *EmsFilterDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this ems filter delete collection o k response has a 5xx status code
func (o *EmsFilterDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this ems filter delete collection o k response a status code equal to that given
func (o *EmsFilterDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the ems filter delete collection o k response
func (o *EmsFilterDeleteCollectionOK) Code() int {
	return 200
}

func (o *EmsFilterDeleteCollectionOK) Error() string {
	return fmt.Sprintf("[DELETE /support/ems/filters][%d] emsFilterDeleteCollectionOK", 200)
}

func (o *EmsFilterDeleteCollectionOK) String() string {
	return fmt.Sprintf("[DELETE /support/ems/filters][%d] emsFilterDeleteCollectionOK", 200)
}

func (o *EmsFilterDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewEmsFilterDeleteCollectionDefault creates a EmsFilterDeleteCollectionDefault with default headers values
func NewEmsFilterDeleteCollectionDefault(code int) *EmsFilterDeleteCollectionDefault {
	return &EmsFilterDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
	EmsFilterDeleteCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 983113 | Default filters cannot be modified or removed |
| 983124 | Filter is being referenced by a destination |
| 983204 | Filter is being used for role-based operations |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type EmsFilterDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this ems filter delete collection default response has a 2xx status code
func (o *EmsFilterDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this ems filter delete collection default response has a 3xx status code
func (o *EmsFilterDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this ems filter delete collection default response has a 4xx status code
func (o *EmsFilterDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this ems filter delete collection default response has a 5xx status code
func (o *EmsFilterDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this ems filter delete collection default response a status code equal to that given
func (o *EmsFilterDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the ems filter delete collection default response
func (o *EmsFilterDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *EmsFilterDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /support/ems/filters][%d] ems_filter_delete_collection default %s", o._statusCode, payload)
}

func (o *EmsFilterDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /support/ems/filters][%d] ems_filter_delete_collection default %s", o._statusCode, payload)
}

func (o *EmsFilterDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *EmsFilterDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
EmsFilterDeleteCollectionBody ems filter delete collection body
swagger:model EmsFilterDeleteCollectionBody
*/
type EmsFilterDeleteCollectionBody struct {

	// ems filter response inline records
	EmsFilterResponseInlineRecords []*models.EmsFilterResponseInlineRecordsInlineArrayItem `json:"records,omitempty"`
}

// Validate validates this ems filter delete collection body
func (o *EmsFilterDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateEmsFilterResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsFilterDeleteCollectionBody) validateEmsFilterResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.EmsFilterResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.EmsFilterResponseInlineRecords); i++ {
		if swag.IsZero(o.EmsFilterResponseInlineRecords[i]) { // not required
			continue
		}

		if o.EmsFilterResponseInlineRecords[i] != nil {
			if err := o.EmsFilterResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this ems filter delete collection body based on the context it is used
func (o *EmsFilterDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateEmsFilterResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsFilterDeleteCollectionBody) contextValidateEmsFilterResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.EmsFilterResponseInlineRecords); i++ {

		if o.EmsFilterResponseInlineRecords[i] != nil {
			if err := o.EmsFilterResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *EmsFilterDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *EmsFilterDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res EmsFilterDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
EmsFilterDeleteCollectionParamsBodyRecordsItems0RulesItems0 Rule for an event filter
swagger:model EmsFilterDeleteCollectionParamsBodyRecordsItems0RulesItems0
*/
type EmsFilterDeleteCollectionParamsBodyRecordsItems0RulesItems0 struct {

	// links
	Links *EmsFilterDeleteCollectionParamsBodyRecordsItems0RulesItems0Links `json:"_links,omitempty"`

	// Rule index. Rules are evaluated in ascending order. If a rule's index order is not specified during creation, the rule is appended to the end of the list.
	// Example: 1
	Index *int64 `json:"index,omitempty"`

	// message criteria
	MessageCriteria *EmsFilterDeleteCollectionParamsBodyRecordsItems0RulesItems0MessageCriteria `json:"message_criteria,omitempty"`

	// Parameter criteria used to match against events' parameters. Each parameter consists of a name and a value. When multiple parameter criteria are provided in a rule, all must match for the rule to be considered matched. A pattern can include one or more wildcard '*' characters.
	ParameterCriteria []*EmsFilterDeleteCollectionParamsBodyRecordsItems0RulesItems0ParameterCriteriaItems0 `json:"parameter_criteria"`

	// Rule type
	// Example: include
	// Enum: ["include","exclude"]
	Type *string `json:"type,omitempty"`
}

// Validate validates this ems filter delete collection params body records items0 rules items0
func (o *EmsFilterDeleteCollectionParamsBodyRecordsItems0RulesItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMessageCriteria(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateParameterCriteria(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsFilterDeleteCollectionParamsBodyRecordsItems0RulesItems0) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (o *EmsFilterDeleteCollectionParamsBodyRecordsItems0RulesItems0) validateMessageCriteria(formats strfmt.Registry) error {
	if swag.IsZero(o.MessageCriteria) { // not required
		return nil
	}

	if o.MessageCriteria != nil {
		if err := o.MessageCriteria.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("message_criteria")
			}
			return err
		}
	}

	return nil
}

func (o *EmsFilterDeleteCollectionParamsBodyRecordsItems0RulesItems0) validateParameterCriteria(formats strfmt.Registry) error {
	if swag.IsZero(o.ParameterCriteria) { // not required
		return nil
	}

	for i := 0; i < len(o.ParameterCriteria); i++ {
		if swag.IsZero(o.ParameterCriteria[i]) { // not required
			continue
		}

		if o.ParameterCriteria[i] != nil {
			if err := o.ParameterCriteria[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("parameter_criteria" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var emsFilterDeleteCollectionParamsBodyRecordsItems0RulesItems0TypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["include","exclude"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		emsFilterDeleteCollectionParamsBodyRecordsItems0RulesItems0TypeTypePropEnum = append(emsFilterDeleteCollectionParamsBodyRecordsItems0RulesItems0TypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// EmsFilterDeleteCollectionParamsBodyRecordsItems0RulesItems0
	// EmsFilterDeleteCollectionParamsBodyRecordsItems0RulesItems0
	// type
	// Type
	// include
	// END DEBUGGING
	// EmsFilterDeleteCollectionParamsBodyRecordsItems0RulesItems0TypeInclude captures enum value "include"
	EmsFilterDeleteCollectionParamsBodyRecordsItems0RulesItems0TypeInclude string = "include"

	// BEGIN DEBUGGING
	// EmsFilterDeleteCollectionParamsBodyRecordsItems0RulesItems0
	// EmsFilterDeleteCollectionParamsBodyRecordsItems0RulesItems0
	// type
	// Type
	// exclude
	// END DEBUGGING
	// EmsFilterDeleteCollectionParamsBodyRecordsItems0RulesItems0TypeExclude captures enum value "exclude"
	EmsFilterDeleteCollectionParamsBodyRecordsItems0RulesItems0TypeExclude string = "exclude"
)

// prop value enum
func (o *EmsFilterDeleteCollectionParamsBodyRecordsItems0RulesItems0) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, emsFilterDeleteCollectionParamsBodyRecordsItems0RulesItems0TypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *EmsFilterDeleteCollectionParamsBodyRecordsItems0RulesItems0) validateType(formats strfmt.Registry) error {
	if swag.IsZero(o.Type) { // not required
		return nil
	}

	// value enum
	if err := o.validateTypeEnum("type", "body", *o.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this ems filter delete collection params body records items0 rules items0 based on the context it is used
func (o *EmsFilterDeleteCollectionParamsBodyRecordsItems0RulesItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMessageCriteria(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateParameterCriteria(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsFilterDeleteCollectionParamsBodyRecordsItems0RulesItems0) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (o *EmsFilterDeleteCollectionParamsBodyRecordsItems0RulesItems0) contextValidateMessageCriteria(ctx context.Context, formats strfmt.Registry) error {

	if o.MessageCriteria != nil {
		if err := o.MessageCriteria.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("message_criteria")
			}
			return err
		}
	}

	return nil
}

func (o *EmsFilterDeleteCollectionParamsBodyRecordsItems0RulesItems0) contextValidateParameterCriteria(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.ParameterCriteria); i++ {

		if o.ParameterCriteria[i] != nil {
			if err := o.ParameterCriteria[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("parameter_criteria" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *EmsFilterDeleteCollectionParamsBodyRecordsItems0RulesItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *EmsFilterDeleteCollectionParamsBodyRecordsItems0RulesItems0) UnmarshalBinary(b []byte) error {
	var res EmsFilterDeleteCollectionParamsBodyRecordsItems0RulesItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
EmsFilterDeleteCollectionParamsBodyRecordsItems0RulesItems0Links ems filter delete collection params body records items0 rules items0 links
swagger:model EmsFilterDeleteCollectionParamsBodyRecordsItems0RulesItems0Links
*/
type EmsFilterDeleteCollectionParamsBodyRecordsItems0RulesItems0Links struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this ems filter delete collection params body records items0 rules items0 links
func (o *EmsFilterDeleteCollectionParamsBodyRecordsItems0RulesItems0Links) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsFilterDeleteCollectionParamsBodyRecordsItems0RulesItems0Links) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ems filter delete collection params body records items0 rules items0 links based on the context it is used
func (o *EmsFilterDeleteCollectionParamsBodyRecordsItems0RulesItems0Links) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsFilterDeleteCollectionParamsBodyRecordsItems0RulesItems0Links) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *EmsFilterDeleteCollectionParamsBodyRecordsItems0RulesItems0Links) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *EmsFilterDeleteCollectionParamsBodyRecordsItems0RulesItems0Links) UnmarshalBinary(b []byte) error {
	var res EmsFilterDeleteCollectionParamsBodyRecordsItems0RulesItems0Links
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
EmsFilterDeleteCollectionParamsBodyRecordsItems0RulesItems0MessageCriteria Matching message definitions for the filter. A property must be specified.
swagger:model EmsFilterDeleteCollectionParamsBodyRecordsItems0RulesItems0MessageCriteria
*/
type EmsFilterDeleteCollectionParamsBodyRecordsItems0RulesItems0MessageCriteria struct {

	// links
	Links *EmsFilterDeleteCollectionParamsBodyRecordsItems0RulesItems0MessageCriteriaLinks `json:"_links,omitempty"`

	// Message name filter on which to match. Supports wildcards. Defaults to * if not specified.
	// Example: wafl.*
	NamePattern *string `json:"name_pattern,omitempty"`

	// A comma-separated list of severities or a wildcard.
	// Example: emergency,alert,error
	Severities *string `json:"severities,omitempty"`

	// A comma separated list of snmp_trap_types or a wildcard.
	// Example: standard,built_in
	SnmpTrapTypes *string `json:"snmp_trap_types,omitempty"`
}

// Validate validates this ems filter delete collection params body records items0 rules items0 message criteria
func (o *EmsFilterDeleteCollectionParamsBodyRecordsItems0RulesItems0MessageCriteria) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsFilterDeleteCollectionParamsBodyRecordsItems0RulesItems0MessageCriteria) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("message_criteria" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ems filter delete collection params body records items0 rules items0 message criteria based on the context it is used
func (o *EmsFilterDeleteCollectionParamsBodyRecordsItems0RulesItems0MessageCriteria) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsFilterDeleteCollectionParamsBodyRecordsItems0RulesItems0MessageCriteria) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("message_criteria" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *EmsFilterDeleteCollectionParamsBodyRecordsItems0RulesItems0MessageCriteria) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *EmsFilterDeleteCollectionParamsBodyRecordsItems0RulesItems0MessageCriteria) UnmarshalBinary(b []byte) error {
	var res EmsFilterDeleteCollectionParamsBodyRecordsItems0RulesItems0MessageCriteria
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
EmsFilterDeleteCollectionParamsBodyRecordsItems0RulesItems0MessageCriteriaLinks ems filter delete collection params body records items0 rules items0 message criteria links
swagger:model EmsFilterDeleteCollectionParamsBodyRecordsItems0RulesItems0MessageCriteriaLinks
*/
type EmsFilterDeleteCollectionParamsBodyRecordsItems0RulesItems0MessageCriteriaLinks struct {

	// related
	Related *models.Href `json:"related,omitempty"`
}

// Validate validates this ems filter delete collection params body records items0 rules items0 message criteria links
func (o *EmsFilterDeleteCollectionParamsBodyRecordsItems0RulesItems0MessageCriteriaLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateRelated(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsFilterDeleteCollectionParamsBodyRecordsItems0RulesItems0MessageCriteriaLinks) validateRelated(formats strfmt.Registry) error {
	if swag.IsZero(o.Related) { // not required
		return nil
	}

	if o.Related != nil {
		if err := o.Related.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("message_criteria" + "." + "_links" + "." + "related")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ems filter delete collection params body records items0 rules items0 message criteria links based on the context it is used
func (o *EmsFilterDeleteCollectionParamsBodyRecordsItems0RulesItems0MessageCriteriaLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateRelated(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsFilterDeleteCollectionParamsBodyRecordsItems0RulesItems0MessageCriteriaLinks) contextValidateRelated(ctx context.Context, formats strfmt.Registry) error {

	if o.Related != nil {
		if err := o.Related.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("message_criteria" + "." + "_links" + "." + "related")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *EmsFilterDeleteCollectionParamsBodyRecordsItems0RulesItems0MessageCriteriaLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *EmsFilterDeleteCollectionParamsBodyRecordsItems0RulesItems0MessageCriteriaLinks) UnmarshalBinary(b []byte) error {
	var res EmsFilterDeleteCollectionParamsBodyRecordsItems0RulesItems0MessageCriteriaLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
EmsFilterDeleteCollectionParamsBodyRecordsItems0RulesItems0ParameterCriteriaItems0 Criterion used for parameter based filtering
swagger:model EmsFilterDeleteCollectionParamsBodyRecordsItems0RulesItems0ParameterCriteriaItems0
*/
type EmsFilterDeleteCollectionParamsBodyRecordsItems0RulesItems0ParameterCriteriaItems0 struct {

	// Parameter name pattern. Wildcard character '*' is supported.
	// Example: vol
	NamePattern *string `json:"name_pattern,omitempty"`

	// Parameter value pattern. Wildcard character '*' is supported.
	// Example: cloud*
	ValuePattern *string `json:"value_pattern,omitempty"`
}

// Validate validates this ems filter delete collection params body records items0 rules items0 parameter criteria items0
func (o *EmsFilterDeleteCollectionParamsBodyRecordsItems0RulesItems0ParameterCriteriaItems0) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this ems filter delete collection params body records items0 rules items0 parameter criteria items0 based on context it is used
func (o *EmsFilterDeleteCollectionParamsBodyRecordsItems0RulesItems0ParameterCriteriaItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *EmsFilterDeleteCollectionParamsBodyRecordsItems0RulesItems0ParameterCriteriaItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *EmsFilterDeleteCollectionParamsBodyRecordsItems0RulesItems0ParameterCriteriaItems0) UnmarshalBinary(b []byte) error {
	var res EmsFilterDeleteCollectionParamsBodyRecordsItems0RulesItems0ParameterCriteriaItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
EmsFilterResponseInlineRecordsInlineArrayItem ems filter response inline records inline array item
swagger:model ems_filter_response_inline_records_inline_array_item
*/
type EmsFilterResponseInlineRecordsInlineArrayItem struct {

	// links
	Links *models.EmsFilterResponseInlineRecordsInlineArrayItemInlineLinks `json:"_links,omitempty"`

	// access control role
	AccessControlRole *models.EmsFilterResponseInlineRecordsInlineArrayItemInlineAccessControlRole `json:"access_control_role,omitempty"`

	// Filter name
	// Example: wafl-critical-events
	Name *string `json:"name,omitempty"`

	// Array of event filter rules on which to match.
	Rules []*EmsFilterDeleteCollectionParamsBodyRecordsItems0RulesItems0 `json:"rules"`

	// Flag indicating system-defined filters.
	// Example: true
	// Read Only: true
	SystemDefined *bool `json:"system_defined,omitempty"`
}

// Validate validates this ems filter response inline records inline array item
func (o *EmsFilterResponseInlineRecordsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateAccessControlRole(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateRules(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsFilterResponseInlineRecordsInlineArrayItem) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (o *EmsFilterResponseInlineRecordsInlineArrayItem) validateAccessControlRole(formats strfmt.Registry) error {
	if swag.IsZero(o.AccessControlRole) { // not required
		return nil
	}

	if o.AccessControlRole != nil {
		if err := o.AccessControlRole.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("access_control_role")
			}
			return err
		}
	}

	return nil
}

func (o *EmsFilterResponseInlineRecordsInlineArrayItem) validateRules(formats strfmt.Registry) error {
	if swag.IsZero(o.Rules) { // not required
		return nil
	}

	for i := 0; i < len(o.Rules); i++ {
		if swag.IsZero(o.Rules[i]) { // not required
			continue
		}

		if o.Rules[i] != nil {
			if err := o.Rules[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("rules" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this ems filter response inline records inline array item based on the context it is used
func (o *EmsFilterResponseInlineRecordsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateAccessControlRole(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateRules(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSystemDefined(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsFilterResponseInlineRecordsInlineArrayItem) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (o *EmsFilterResponseInlineRecordsInlineArrayItem) contextValidateAccessControlRole(ctx context.Context, formats strfmt.Registry) error {

	if o.AccessControlRole != nil {
		if err := o.AccessControlRole.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("access_control_role")
			}
			return err
		}
	}

	return nil
}

func (o *EmsFilterResponseInlineRecordsInlineArrayItem) contextValidateRules(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.Rules); i++ {

		if o.Rules[i] != nil {
			if err := o.Rules[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("rules" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *EmsFilterResponseInlineRecordsInlineArrayItem) contextValidateSystemDefined(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "system_defined", "body", o.SystemDefined); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *EmsFilterResponseInlineRecordsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *EmsFilterResponseInlineRecordsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res EmsFilterResponseInlineRecordsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
EmsFilterResponseInlineRecordsInlineArrayItemInlineLinks ems filter response inline records inline array item inline links
swagger:model ems_filter_response_inline_records_inline_array_item_inline__links
*/
type EmsFilterResponseInlineRecordsInlineArrayItemInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this ems filter response inline records inline array item inline links
func (o *EmsFilterResponseInlineRecordsInlineArrayItemInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsFilterResponseInlineRecordsInlineArrayItemInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ems filter response inline records inline array item inline links based on the context it is used
func (o *EmsFilterResponseInlineRecordsInlineArrayItemInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsFilterResponseInlineRecordsInlineArrayItemInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *EmsFilterResponseInlineRecordsInlineArrayItemInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *EmsFilterResponseInlineRecordsInlineArrayItemInlineLinks) UnmarshalBinary(b []byte) error {
	var res EmsFilterResponseInlineRecordsInlineArrayItemInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
EmsFilterResponseInlineRecordsInlineArrayItemInlineAccessControlRole Indicates the access control role that created the event filter and is used to control access to the filter based on role-based access control (RBAC) rules. If created by the 'admin' user, the field is unset.
swagger:model ems_filter_response_inline_records_inline_array_item_inline_access_control_role
*/
type EmsFilterResponseInlineRecordsInlineArrayItemInlineAccessControlRole struct {

	// links
	Links *models.EmsFilterResponseInlineRecordsInlineArrayItemInlineAccessControlRoleInlineLinks `json:"_links,omitempty"`

	// Role name
	// Example: admin
	Name *string `json:"name,omitempty"`
}

// Validate validates this ems filter response inline records inline array item inline access control role
func (o *EmsFilterResponseInlineRecordsInlineArrayItemInlineAccessControlRole) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsFilterResponseInlineRecordsInlineArrayItemInlineAccessControlRole) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("access_control_role" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ems filter response inline records inline array item inline access control role based on the context it is used
func (o *EmsFilterResponseInlineRecordsInlineArrayItemInlineAccessControlRole) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsFilterResponseInlineRecordsInlineArrayItemInlineAccessControlRole) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("access_control_role" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *EmsFilterResponseInlineRecordsInlineArrayItemInlineAccessControlRole) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *EmsFilterResponseInlineRecordsInlineArrayItemInlineAccessControlRole) UnmarshalBinary(b []byte) error {
	var res EmsFilterResponseInlineRecordsInlineArrayItemInlineAccessControlRole
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
EmsFilterResponseInlineRecordsInlineArrayItemInlineAccessControlRoleInlineLinks ems filter response inline records inline array item inline access control role inline links
swagger:model ems_filter_response_inline_records_inline_array_item_inline_access_control_role_inline__links
*/
type EmsFilterResponseInlineRecordsInlineArrayItemInlineAccessControlRoleInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this ems filter response inline records inline array item inline access control role inline links
func (o *EmsFilterResponseInlineRecordsInlineArrayItemInlineAccessControlRoleInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsFilterResponseInlineRecordsInlineArrayItemInlineAccessControlRoleInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("access_control_role" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ems filter response inline records inline array item inline access control role inline links based on the context it is used
func (o *EmsFilterResponseInlineRecordsInlineArrayItemInlineAccessControlRoleInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsFilterResponseInlineRecordsInlineArrayItemInlineAccessControlRoleInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("access_control_role" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *EmsFilterResponseInlineRecordsInlineArrayItemInlineAccessControlRoleInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *EmsFilterResponseInlineRecordsInlineArrayItemInlineAccessControlRoleInlineLinks) UnmarshalBinary(b []byte) error {
	var res EmsFilterResponseInlineRecordsInlineArrayItemInlineAccessControlRoleInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
