// Code generated by go-swagger; DO NOT EDIT.

package support

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewEmsFilterGetParams creates a new EmsFilterGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewEmsFilterGetParams() *EmsFilterGetParams {
	return &EmsFilterGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewEmsFilterGetParamsWithTimeout creates a new EmsFilterGetParams object
// with the ability to set a timeout on a request.
func NewEmsFilterGetParamsWithTimeout(timeout time.Duration) *EmsFilterGetParams {
	return &EmsFilterGetParams{
		timeout: timeout,
	}
}

// NewEmsFilterGetParamsWithContext creates a new EmsFilterGetParams object
// with the ability to set a context for a request.
func NewEmsFilterGetParamsWithContext(ctx context.Context) *EmsFilterGetParams {
	return &EmsFilterGetParams{
		Context: ctx,
	}
}

// NewEmsFilterGetParamsWithHTTPClient creates a new EmsFilterGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewEmsFilterGetParamsWithHTTPClient(client *http.Client) *EmsFilterGetParams {
	return &EmsFilterGetParams{
		HTTPClient: client,
	}
}

/*
EmsFilterGetParams contains all the parameters to send to the API endpoint

	for the ems filter get operation.

	Typically these are written to a http.Request.
*/
type EmsFilterGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* Name.

	   Filter name
	*/
	Name string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the ems filter get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *EmsFilterGetParams) WithDefaults() *EmsFilterGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the ems filter get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *EmsFilterGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the ems filter get params
func (o *EmsFilterGetParams) WithTimeout(timeout time.Duration) *EmsFilterGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the ems filter get params
func (o *EmsFilterGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the ems filter get params
func (o *EmsFilterGetParams) WithContext(ctx context.Context) *EmsFilterGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the ems filter get params
func (o *EmsFilterGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the ems filter get params
func (o *EmsFilterGetParams) WithHTTPClient(client *http.Client) *EmsFilterGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the ems filter get params
func (o *EmsFilterGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the ems filter get params
func (o *EmsFilterGetParams) WithFields(fields []string) *EmsFilterGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the ems filter get params
func (o *EmsFilterGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithName adds the name to the ems filter get params
func (o *EmsFilterGetParams) WithName(name string) *EmsFilterGetParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the ems filter get params
func (o *EmsFilterGetParams) SetName(name string) {
	o.Name = name
}

// WriteToRequest writes these params to a swagger request
func (o *EmsFilterGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	// path param name
	if err := r.SetPathParam("name", o.Name); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamEmsFilterGet binds the parameter fields
func (o *EmsFilterGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
