// Code generated by go-swagger; DO NOT EDIT.

package support

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// EmsFilterGetReader is a Reader for the EmsFilterGet structure.
type EmsFilterGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *EmsFilterGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewEmsFilterGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewEmsFilterGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewEmsFilterGetOK creates a EmsFilterGetOK with default headers values
func NewEmsFilterGetOK() *EmsFilterGetOK {
	return &EmsFilterGetOK{}
}

/*
EmsFilterGetOK describes a response with status code 200, with default header values.

OK
*/
type EmsFilterGetOK struct {
	Payload *models.EmsFilter
}

// IsSuccess returns true when this ems filter get o k response has a 2xx status code
func (o *EmsFilterGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this ems filter get o k response has a 3xx status code
func (o *EmsFilterGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this ems filter get o k response has a 4xx status code
func (o *EmsFilterGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this ems filter get o k response has a 5xx status code
func (o *EmsFilterGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this ems filter get o k response a status code equal to that given
func (o *EmsFilterGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the ems filter get o k response
func (o *EmsFilterGetOK) Code() int {
	return 200
}

func (o *EmsFilterGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /support/ems/filters/{name}][%d] emsFilterGetOK %s", 200, payload)
}

func (o *EmsFilterGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /support/ems/filters/{name}][%d] emsFilterGetOK %s", 200, payload)
}

func (o *EmsFilterGetOK) GetPayload() *models.EmsFilter {
	return o.Payload
}

func (o *EmsFilterGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.EmsFilter)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewEmsFilterGetDefault creates a EmsFilterGetDefault with default headers values
func NewEmsFilterGetDefault(code int) *EmsFilterGetDefault {
	return &EmsFilterGetDefault{
		_statusCode: code,
	}
}

/*
EmsFilterGetDefault describes a response with status code -1, with default header values.

Error
*/
type EmsFilterGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this ems filter get default response has a 2xx status code
func (o *EmsFilterGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this ems filter get default response has a 3xx status code
func (o *EmsFilterGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this ems filter get default response has a 4xx status code
func (o *EmsFilterGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this ems filter get default response has a 5xx status code
func (o *EmsFilterGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this ems filter get default response a status code equal to that given
func (o *EmsFilterGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the ems filter get default response
func (o *EmsFilterGetDefault) Code() int {
	return o._statusCode
}

func (o *EmsFilterGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /support/ems/filters/{name}][%d] ems_filter_get default %s", o._statusCode, payload)
}

func (o *EmsFilterGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /support/ems/filters/{name}][%d] ems_filter_get default %s", o._statusCode, payload)
}

func (o *EmsFilterGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *EmsFilterGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
