// Code generated by go-swagger; DO NOT EDIT.

package support

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// EmsFilterModifyCollectionReader is a Reader for the EmsFilterModifyCollection structure.
type EmsFilterModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *EmsFilterModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewEmsFilterModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewEmsFilterModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewEmsFilterModifyCollectionOK creates a EmsFilterModifyCollectionOK with default headers values
func NewEmsFilterModifyCollectionOK() *EmsFilterModifyCollectionOK {
	return &EmsFilterModifyCollectionOK{}
}

/*
EmsFilterModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type EmsFilterModifyCollectionOK struct {
}

// IsSuccess returns true when this ems filter modify collection o k response has a 2xx status code
func (o *EmsFilterModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this ems filter modify collection o k response has a 3xx status code
func (o *EmsFilterModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this ems filter modify collection o k response has a 4xx status code
func (o *EmsFilterModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this ems filter modify collection o k response has a 5xx status code
func (o *EmsFilterModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this ems filter modify collection o k response a status code equal to that given
func (o *EmsFilterModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the ems filter modify collection o k response
func (o *EmsFilterModifyCollectionOK) Code() int {
	return 200
}

func (o *EmsFilterModifyCollectionOK) Error() string {
	return fmt.Sprintf("[PATCH /support/ems/filters][%d] emsFilterModifyCollectionOK", 200)
}

func (o *EmsFilterModifyCollectionOK) String() string {
	return fmt.Sprintf("[PATCH /support/ems/filters][%d] emsFilterModifyCollectionOK", 200)
}

func (o *EmsFilterModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewEmsFilterModifyCollectionDefault creates a EmsFilterModifyCollectionDefault with default headers values
func NewEmsFilterModifyCollectionDefault(code int) *EmsFilterModifyCollectionDefault {
	return &EmsFilterModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	EmsFilterModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 983088 | The filter name provided is empty |
| 983089 | The filter name provided cannot contain spaces |
| 983092 | The index of the rule provided is outside the allowed range for the filter provided |
| 983094 | The filter name provided is invalid. The filter name must contain between 2 and 64 characters and start and end with an alphanumeric symbol or (underscore). The allowed special characters are (underscore) and -(hyphen) |
| 983095 | The rule index provided is invalid for the filter provided |
| 983101 | No event is matched by the rule provided |
| 983113 | Default filters cannot be modified or removed |
| 983114 | The maximum number of filters is reached |
| 983115 | The maximum number of filter rules is reached |
| 983126 | A rule requires at least one name_pattern, severities, snmp_trap_types, or parameter pattern to be defined |
| 983127 | A property cannot contain a combination of the wildcard characters and other values |
| 983128 | An invalid value is provided for the property 'snmp_trap_types' |
| 983146 | An invalid value is provided for the property 'severities' |
| 983147 | The severities provided are not supported |
| 983155 | The provided severities property does not match that of the name_pattern |
| 983156 | The provided snmp_trap_types property does not match that of the name_pattern |
| 983157 | The provided severities and snmp_trap_types properties do not match those of the name_pattern |
| 983158 | The name_pattern provided does not exist |
| 983195 | Empty field in parameter_criteria. Both name and value patterns must be specified |
| 983196 | name_pattern and value_pattern fields in parameter_criteria are empty |
| 983211 | Parameter criteria based filtering is not supported in this version of ONTAP |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type EmsFilterModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this ems filter modify collection default response has a 2xx status code
func (o *EmsFilterModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this ems filter modify collection default response has a 3xx status code
func (o *EmsFilterModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this ems filter modify collection default response has a 4xx status code
func (o *EmsFilterModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this ems filter modify collection default response has a 5xx status code
func (o *EmsFilterModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this ems filter modify collection default response a status code equal to that given
func (o *EmsFilterModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the ems filter modify collection default response
func (o *EmsFilterModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *EmsFilterModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /support/ems/filters][%d] ems_filter_modify_collection default %s", o._statusCode, payload)
}

func (o *EmsFilterModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /support/ems/filters][%d] ems_filter_modify_collection default %s", o._statusCode, payload)
}

func (o *EmsFilterModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *EmsFilterModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
EmsFilterModifyCollectionBody ems filter modify collection body
swagger:model EmsFilterModifyCollectionBody
*/
type EmsFilterModifyCollectionBody struct {

	// links
	Links *models.EmsFilterResponseInlineRecordsInlineArrayItemInlineLinks `json:"_links,omitempty"`

	// access control role
	AccessControlRole *models.EmsFilterResponseInlineRecordsInlineArrayItemInlineAccessControlRole `json:"access_control_role,omitempty"`

	// ems filter response inline records
	EmsFilterResponseInlineRecords []*models.EmsFilterResponseInlineRecordsInlineArrayItem `json:"records,omitempty"`

	// Filter name
	// Example: wafl-critical-events
	Name *string `json:"name,omitempty"`

	// Array of event filter rules on which to match.
	Rules []*EmsFilterModifyCollectionParamsBodyRulesItems0 `json:"rules"`

	// Flag indicating system-defined filters.
	// Example: true
	// Read Only: true
	SystemDefined *bool `json:"system_defined,omitempty"`
}

// Validate validates this ems filter modify collection body
func (o *EmsFilterModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateAccessControlRole(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateEmsFilterResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateRules(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsFilterModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *EmsFilterModifyCollectionBody) validateAccessControlRole(formats strfmt.Registry) error {
	if swag.IsZero(o.AccessControlRole) { // not required
		return nil
	}

	if o.AccessControlRole != nil {
		if err := o.AccessControlRole.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "access_control_role")
			}
			return err
		}
	}

	return nil
}

func (o *EmsFilterModifyCollectionBody) validateEmsFilterResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.EmsFilterResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.EmsFilterResponseInlineRecords); i++ {
		if swag.IsZero(o.EmsFilterResponseInlineRecords[i]) { // not required
			continue
		}

		if o.EmsFilterResponseInlineRecords[i] != nil {
			if err := o.EmsFilterResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *EmsFilterModifyCollectionBody) validateRules(formats strfmt.Registry) error {
	if swag.IsZero(o.Rules) { // not required
		return nil
	}

	for i := 0; i < len(o.Rules); i++ {
		if swag.IsZero(o.Rules[i]) { // not required
			continue
		}

		if o.Rules[i] != nil {
			if err := o.Rules[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "rules" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this ems filter modify collection body based on the context it is used
func (o *EmsFilterModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateAccessControlRole(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateEmsFilterResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateRules(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSystemDefined(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsFilterModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *EmsFilterModifyCollectionBody) contextValidateAccessControlRole(ctx context.Context, formats strfmt.Registry) error {

	if o.AccessControlRole != nil {
		if err := o.AccessControlRole.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "access_control_role")
			}
			return err
		}
	}

	return nil
}

func (o *EmsFilterModifyCollectionBody) contextValidateEmsFilterResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.EmsFilterResponseInlineRecords); i++ {

		if o.EmsFilterResponseInlineRecords[i] != nil {
			if err := o.EmsFilterResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *EmsFilterModifyCollectionBody) contextValidateRules(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.Rules); i++ {

		if o.Rules[i] != nil {
			if err := o.Rules[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "rules" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *EmsFilterModifyCollectionBody) contextValidateSystemDefined(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"system_defined", "body", o.SystemDefined); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *EmsFilterModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *EmsFilterModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res EmsFilterModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
EmsFilterModifyCollectionParamsBodyRecordsItems0RulesItems0 Rule for an event filter
swagger:model EmsFilterModifyCollectionParamsBodyRecordsItems0RulesItems0
*/
type EmsFilterModifyCollectionParamsBodyRecordsItems0RulesItems0 struct {

	// links
	Links *EmsFilterModifyCollectionParamsBodyRecordsItems0RulesItems0Links `json:"_links,omitempty"`

	// Rule index. Rules are evaluated in ascending order. If a rule's index order is not specified during creation, the rule is appended to the end of the list.
	// Example: 1
	Index *int64 `json:"index,omitempty"`

	// message criteria
	MessageCriteria *EmsFilterModifyCollectionParamsBodyRecordsItems0RulesItems0MessageCriteria `json:"message_criteria,omitempty"`

	// Parameter criteria used to match against events' parameters. Each parameter consists of a name and a value. When multiple parameter criteria are provided in a rule, all must match for the rule to be considered matched. A pattern can include one or more wildcard '*' characters.
	ParameterCriteria []*EmsFilterModifyCollectionParamsBodyRecordsItems0RulesItems0ParameterCriteriaItems0 `json:"parameter_criteria"`

	// Rule type
	// Example: include
	// Enum: ["include","exclude"]
	Type *string `json:"type,omitempty"`
}

// Validate validates this ems filter modify collection params body records items0 rules items0
func (o *EmsFilterModifyCollectionParamsBodyRecordsItems0RulesItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMessageCriteria(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateParameterCriteria(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsFilterModifyCollectionParamsBodyRecordsItems0RulesItems0) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (o *EmsFilterModifyCollectionParamsBodyRecordsItems0RulesItems0) validateMessageCriteria(formats strfmt.Registry) error {
	if swag.IsZero(o.MessageCriteria) { // not required
		return nil
	}

	if o.MessageCriteria != nil {
		if err := o.MessageCriteria.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("message_criteria")
			}
			return err
		}
	}

	return nil
}

func (o *EmsFilterModifyCollectionParamsBodyRecordsItems0RulesItems0) validateParameterCriteria(formats strfmt.Registry) error {
	if swag.IsZero(o.ParameterCriteria) { // not required
		return nil
	}

	for i := 0; i < len(o.ParameterCriteria); i++ {
		if swag.IsZero(o.ParameterCriteria[i]) { // not required
			continue
		}

		if o.ParameterCriteria[i] != nil {
			if err := o.ParameterCriteria[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("parameter_criteria" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var emsFilterModifyCollectionParamsBodyRecordsItems0RulesItems0TypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["include","exclude"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		emsFilterModifyCollectionParamsBodyRecordsItems0RulesItems0TypeTypePropEnum = append(emsFilterModifyCollectionParamsBodyRecordsItems0RulesItems0TypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// EmsFilterModifyCollectionParamsBodyRecordsItems0RulesItems0
	// EmsFilterModifyCollectionParamsBodyRecordsItems0RulesItems0
	// type
	// Type
	// include
	// END DEBUGGING
	// EmsFilterModifyCollectionParamsBodyRecordsItems0RulesItems0TypeInclude captures enum value "include"
	EmsFilterModifyCollectionParamsBodyRecordsItems0RulesItems0TypeInclude string = "include"

	// BEGIN DEBUGGING
	// EmsFilterModifyCollectionParamsBodyRecordsItems0RulesItems0
	// EmsFilterModifyCollectionParamsBodyRecordsItems0RulesItems0
	// type
	// Type
	// exclude
	// END DEBUGGING
	// EmsFilterModifyCollectionParamsBodyRecordsItems0RulesItems0TypeExclude captures enum value "exclude"
	EmsFilterModifyCollectionParamsBodyRecordsItems0RulesItems0TypeExclude string = "exclude"
)

// prop value enum
func (o *EmsFilterModifyCollectionParamsBodyRecordsItems0RulesItems0) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, emsFilterModifyCollectionParamsBodyRecordsItems0RulesItems0TypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *EmsFilterModifyCollectionParamsBodyRecordsItems0RulesItems0) validateType(formats strfmt.Registry) error {
	if swag.IsZero(o.Type) { // not required
		return nil
	}

	// value enum
	if err := o.validateTypeEnum("type", "body", *o.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this ems filter modify collection params body records items0 rules items0 based on the context it is used
func (o *EmsFilterModifyCollectionParamsBodyRecordsItems0RulesItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMessageCriteria(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateParameterCriteria(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsFilterModifyCollectionParamsBodyRecordsItems0RulesItems0) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (o *EmsFilterModifyCollectionParamsBodyRecordsItems0RulesItems0) contextValidateMessageCriteria(ctx context.Context, formats strfmt.Registry) error {

	if o.MessageCriteria != nil {
		if err := o.MessageCriteria.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("message_criteria")
			}
			return err
		}
	}

	return nil
}

func (o *EmsFilterModifyCollectionParamsBodyRecordsItems0RulesItems0) contextValidateParameterCriteria(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.ParameterCriteria); i++ {

		if o.ParameterCriteria[i] != nil {
			if err := o.ParameterCriteria[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("parameter_criteria" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *EmsFilterModifyCollectionParamsBodyRecordsItems0RulesItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *EmsFilterModifyCollectionParamsBodyRecordsItems0RulesItems0) UnmarshalBinary(b []byte) error {
	var res EmsFilterModifyCollectionParamsBodyRecordsItems0RulesItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
EmsFilterModifyCollectionParamsBodyRecordsItems0RulesItems0Links ems filter modify collection params body records items0 rules items0 links
swagger:model EmsFilterModifyCollectionParamsBodyRecordsItems0RulesItems0Links
*/
type EmsFilterModifyCollectionParamsBodyRecordsItems0RulesItems0Links struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this ems filter modify collection params body records items0 rules items0 links
func (o *EmsFilterModifyCollectionParamsBodyRecordsItems0RulesItems0Links) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsFilterModifyCollectionParamsBodyRecordsItems0RulesItems0Links) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ems filter modify collection params body records items0 rules items0 links based on the context it is used
func (o *EmsFilterModifyCollectionParamsBodyRecordsItems0RulesItems0Links) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsFilterModifyCollectionParamsBodyRecordsItems0RulesItems0Links) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *EmsFilterModifyCollectionParamsBodyRecordsItems0RulesItems0Links) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *EmsFilterModifyCollectionParamsBodyRecordsItems0RulesItems0Links) UnmarshalBinary(b []byte) error {
	var res EmsFilterModifyCollectionParamsBodyRecordsItems0RulesItems0Links
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
EmsFilterModifyCollectionParamsBodyRecordsItems0RulesItems0MessageCriteria Matching message definitions for the filter. A property must be specified.
swagger:model EmsFilterModifyCollectionParamsBodyRecordsItems0RulesItems0MessageCriteria
*/
type EmsFilterModifyCollectionParamsBodyRecordsItems0RulesItems0MessageCriteria struct {

	// links
	Links *EmsFilterModifyCollectionParamsBodyRecordsItems0RulesItems0MessageCriteriaLinks `json:"_links,omitempty"`

	// Message name filter on which to match. Supports wildcards. Defaults to * if not specified.
	// Example: wafl.*
	NamePattern *string `json:"name_pattern,omitempty"`

	// A comma-separated list of severities or a wildcard.
	// Example: emergency,alert,error
	Severities *string `json:"severities,omitempty"`

	// A comma separated list of snmp_trap_types or a wildcard.
	// Example: standard,built_in
	SnmpTrapTypes *string `json:"snmp_trap_types,omitempty"`
}

// Validate validates this ems filter modify collection params body records items0 rules items0 message criteria
func (o *EmsFilterModifyCollectionParamsBodyRecordsItems0RulesItems0MessageCriteria) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsFilterModifyCollectionParamsBodyRecordsItems0RulesItems0MessageCriteria) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("message_criteria" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ems filter modify collection params body records items0 rules items0 message criteria based on the context it is used
func (o *EmsFilterModifyCollectionParamsBodyRecordsItems0RulesItems0MessageCriteria) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsFilterModifyCollectionParamsBodyRecordsItems0RulesItems0MessageCriteria) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("message_criteria" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *EmsFilterModifyCollectionParamsBodyRecordsItems0RulesItems0MessageCriteria) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *EmsFilterModifyCollectionParamsBodyRecordsItems0RulesItems0MessageCriteria) UnmarshalBinary(b []byte) error {
	var res EmsFilterModifyCollectionParamsBodyRecordsItems0RulesItems0MessageCriteria
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
EmsFilterModifyCollectionParamsBodyRecordsItems0RulesItems0MessageCriteriaLinks ems filter modify collection params body records items0 rules items0 message criteria links
swagger:model EmsFilterModifyCollectionParamsBodyRecordsItems0RulesItems0MessageCriteriaLinks
*/
type EmsFilterModifyCollectionParamsBodyRecordsItems0RulesItems0MessageCriteriaLinks struct {

	// related
	Related *models.Href `json:"related,omitempty"`
}

// Validate validates this ems filter modify collection params body records items0 rules items0 message criteria links
func (o *EmsFilterModifyCollectionParamsBodyRecordsItems0RulesItems0MessageCriteriaLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateRelated(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsFilterModifyCollectionParamsBodyRecordsItems0RulesItems0MessageCriteriaLinks) validateRelated(formats strfmt.Registry) error {
	if swag.IsZero(o.Related) { // not required
		return nil
	}

	if o.Related != nil {
		if err := o.Related.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("message_criteria" + "." + "_links" + "." + "related")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ems filter modify collection params body records items0 rules items0 message criteria links based on the context it is used
func (o *EmsFilterModifyCollectionParamsBodyRecordsItems0RulesItems0MessageCriteriaLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateRelated(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsFilterModifyCollectionParamsBodyRecordsItems0RulesItems0MessageCriteriaLinks) contextValidateRelated(ctx context.Context, formats strfmt.Registry) error {

	if o.Related != nil {
		if err := o.Related.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("message_criteria" + "." + "_links" + "." + "related")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *EmsFilterModifyCollectionParamsBodyRecordsItems0RulesItems0MessageCriteriaLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *EmsFilterModifyCollectionParamsBodyRecordsItems0RulesItems0MessageCriteriaLinks) UnmarshalBinary(b []byte) error {
	var res EmsFilterModifyCollectionParamsBodyRecordsItems0RulesItems0MessageCriteriaLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
EmsFilterModifyCollectionParamsBodyRecordsItems0RulesItems0ParameterCriteriaItems0 Criterion used for parameter based filtering
swagger:model EmsFilterModifyCollectionParamsBodyRecordsItems0RulesItems0ParameterCriteriaItems0
*/
type EmsFilterModifyCollectionParamsBodyRecordsItems0RulesItems0ParameterCriteriaItems0 struct {

	// Parameter name pattern. Wildcard character '*' is supported.
	// Example: vol
	NamePattern *string `json:"name_pattern,omitempty"`

	// Parameter value pattern. Wildcard character '*' is supported.
	// Example: cloud*
	ValuePattern *string `json:"value_pattern,omitempty"`
}

// Validate validates this ems filter modify collection params body records items0 rules items0 parameter criteria items0
func (o *EmsFilterModifyCollectionParamsBodyRecordsItems0RulesItems0ParameterCriteriaItems0) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this ems filter modify collection params body records items0 rules items0 parameter criteria items0 based on context it is used
func (o *EmsFilterModifyCollectionParamsBodyRecordsItems0RulesItems0ParameterCriteriaItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *EmsFilterModifyCollectionParamsBodyRecordsItems0RulesItems0ParameterCriteriaItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *EmsFilterModifyCollectionParamsBodyRecordsItems0RulesItems0ParameterCriteriaItems0) UnmarshalBinary(b []byte) error {
	var res EmsFilterModifyCollectionParamsBodyRecordsItems0RulesItems0ParameterCriteriaItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
EmsFilterModifyCollectionParamsBodyRulesItems0 Rule for an event filter
swagger:model EmsFilterModifyCollectionParamsBodyRulesItems0
*/
type EmsFilterModifyCollectionParamsBodyRulesItems0 struct {

	// links
	Links *EmsFilterModifyCollectionParamsBodyRulesItems0Links `json:"_links,omitempty"`

	// Rule index. Rules are evaluated in ascending order. If a rule's index order is not specified during creation, the rule is appended to the end of the list.
	// Example: 1
	Index *int64 `json:"index,omitempty"`

	// message criteria
	MessageCriteria *EmsFilterModifyCollectionParamsBodyRulesItems0MessageCriteria `json:"message_criteria,omitempty"`

	// Parameter criteria used to match against events' parameters. Each parameter consists of a name and a value. When multiple parameter criteria are provided in a rule, all must match for the rule to be considered matched. A pattern can include one or more wildcard '*' characters.
	ParameterCriteria []*EmsFilterModifyCollectionParamsBodyRulesItems0ParameterCriteriaItems0 `json:"parameter_criteria"`

	// Rule type
	// Example: include
	// Enum: ["include","exclude"]
	Type *string `json:"type,omitempty"`
}

// Validate validates this ems filter modify collection params body rules items0
func (o *EmsFilterModifyCollectionParamsBodyRulesItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMessageCriteria(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateParameterCriteria(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsFilterModifyCollectionParamsBodyRulesItems0) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (o *EmsFilterModifyCollectionParamsBodyRulesItems0) validateMessageCriteria(formats strfmt.Registry) error {
	if swag.IsZero(o.MessageCriteria) { // not required
		return nil
	}

	if o.MessageCriteria != nil {
		if err := o.MessageCriteria.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("message_criteria")
			}
			return err
		}
	}

	return nil
}

func (o *EmsFilterModifyCollectionParamsBodyRulesItems0) validateParameterCriteria(formats strfmt.Registry) error {
	if swag.IsZero(o.ParameterCriteria) { // not required
		return nil
	}

	for i := 0; i < len(o.ParameterCriteria); i++ {
		if swag.IsZero(o.ParameterCriteria[i]) { // not required
			continue
		}

		if o.ParameterCriteria[i] != nil {
			if err := o.ParameterCriteria[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("parameter_criteria" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var emsFilterModifyCollectionParamsBodyRulesItems0TypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["include","exclude"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		emsFilterModifyCollectionParamsBodyRulesItems0TypeTypePropEnum = append(emsFilterModifyCollectionParamsBodyRulesItems0TypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// EmsFilterModifyCollectionParamsBodyRulesItems0
	// EmsFilterModifyCollectionParamsBodyRulesItems0
	// type
	// Type
	// include
	// END DEBUGGING
	// EmsFilterModifyCollectionParamsBodyRulesItems0TypeInclude captures enum value "include"
	EmsFilterModifyCollectionParamsBodyRulesItems0TypeInclude string = "include"

	// BEGIN DEBUGGING
	// EmsFilterModifyCollectionParamsBodyRulesItems0
	// EmsFilterModifyCollectionParamsBodyRulesItems0
	// type
	// Type
	// exclude
	// END DEBUGGING
	// EmsFilterModifyCollectionParamsBodyRulesItems0TypeExclude captures enum value "exclude"
	EmsFilterModifyCollectionParamsBodyRulesItems0TypeExclude string = "exclude"
)

// prop value enum
func (o *EmsFilterModifyCollectionParamsBodyRulesItems0) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, emsFilterModifyCollectionParamsBodyRulesItems0TypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *EmsFilterModifyCollectionParamsBodyRulesItems0) validateType(formats strfmt.Registry) error {
	if swag.IsZero(o.Type) { // not required
		return nil
	}

	// value enum
	if err := o.validateTypeEnum("type", "body", *o.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this ems filter modify collection params body rules items0 based on the context it is used
func (o *EmsFilterModifyCollectionParamsBodyRulesItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMessageCriteria(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateParameterCriteria(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsFilterModifyCollectionParamsBodyRulesItems0) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (o *EmsFilterModifyCollectionParamsBodyRulesItems0) contextValidateMessageCriteria(ctx context.Context, formats strfmt.Registry) error {

	if o.MessageCriteria != nil {
		if err := o.MessageCriteria.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("message_criteria")
			}
			return err
		}
	}

	return nil
}

func (o *EmsFilterModifyCollectionParamsBodyRulesItems0) contextValidateParameterCriteria(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.ParameterCriteria); i++ {

		if o.ParameterCriteria[i] != nil {
			if err := o.ParameterCriteria[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("parameter_criteria" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *EmsFilterModifyCollectionParamsBodyRulesItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *EmsFilterModifyCollectionParamsBodyRulesItems0) UnmarshalBinary(b []byte) error {
	var res EmsFilterModifyCollectionParamsBodyRulesItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
EmsFilterModifyCollectionParamsBodyRulesItems0Links ems filter modify collection params body rules items0 links
swagger:model EmsFilterModifyCollectionParamsBodyRulesItems0Links
*/
type EmsFilterModifyCollectionParamsBodyRulesItems0Links struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this ems filter modify collection params body rules items0 links
func (o *EmsFilterModifyCollectionParamsBodyRulesItems0Links) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsFilterModifyCollectionParamsBodyRulesItems0Links) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ems filter modify collection params body rules items0 links based on the context it is used
func (o *EmsFilterModifyCollectionParamsBodyRulesItems0Links) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsFilterModifyCollectionParamsBodyRulesItems0Links) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *EmsFilterModifyCollectionParamsBodyRulesItems0Links) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *EmsFilterModifyCollectionParamsBodyRulesItems0Links) UnmarshalBinary(b []byte) error {
	var res EmsFilterModifyCollectionParamsBodyRulesItems0Links
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
EmsFilterModifyCollectionParamsBodyRulesItems0MessageCriteria Matching message definitions for the filter. A property must be specified.
swagger:model EmsFilterModifyCollectionParamsBodyRulesItems0MessageCriteria
*/
type EmsFilterModifyCollectionParamsBodyRulesItems0MessageCriteria struct {

	// links
	Links *EmsFilterModifyCollectionParamsBodyRulesItems0MessageCriteriaLinks `json:"_links,omitempty"`

	// Message name filter on which to match. Supports wildcards. Defaults to * if not specified.
	// Example: wafl.*
	NamePattern *string `json:"name_pattern,omitempty"`

	// A comma-separated list of severities or a wildcard.
	// Example: emergency,alert,error
	Severities *string `json:"severities,omitempty"`

	// A comma separated list of snmp_trap_types or a wildcard.
	// Example: standard,built_in
	SnmpTrapTypes *string `json:"snmp_trap_types,omitempty"`
}

// Validate validates this ems filter modify collection params body rules items0 message criteria
func (o *EmsFilterModifyCollectionParamsBodyRulesItems0MessageCriteria) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsFilterModifyCollectionParamsBodyRulesItems0MessageCriteria) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("message_criteria" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ems filter modify collection params body rules items0 message criteria based on the context it is used
func (o *EmsFilterModifyCollectionParamsBodyRulesItems0MessageCriteria) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsFilterModifyCollectionParamsBodyRulesItems0MessageCriteria) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("message_criteria" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *EmsFilterModifyCollectionParamsBodyRulesItems0MessageCriteria) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *EmsFilterModifyCollectionParamsBodyRulesItems0MessageCriteria) UnmarshalBinary(b []byte) error {
	var res EmsFilterModifyCollectionParamsBodyRulesItems0MessageCriteria
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
EmsFilterModifyCollectionParamsBodyRulesItems0MessageCriteriaLinks ems filter modify collection params body rules items0 message criteria links
swagger:model EmsFilterModifyCollectionParamsBodyRulesItems0MessageCriteriaLinks
*/
type EmsFilterModifyCollectionParamsBodyRulesItems0MessageCriteriaLinks struct {

	// related
	Related *models.Href `json:"related,omitempty"`
}

// Validate validates this ems filter modify collection params body rules items0 message criteria links
func (o *EmsFilterModifyCollectionParamsBodyRulesItems0MessageCriteriaLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateRelated(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsFilterModifyCollectionParamsBodyRulesItems0MessageCriteriaLinks) validateRelated(formats strfmt.Registry) error {
	if swag.IsZero(o.Related) { // not required
		return nil
	}

	if o.Related != nil {
		if err := o.Related.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("message_criteria" + "." + "_links" + "." + "related")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ems filter modify collection params body rules items0 message criteria links based on the context it is used
func (o *EmsFilterModifyCollectionParamsBodyRulesItems0MessageCriteriaLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateRelated(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsFilterModifyCollectionParamsBodyRulesItems0MessageCriteriaLinks) contextValidateRelated(ctx context.Context, formats strfmt.Registry) error {

	if o.Related != nil {
		if err := o.Related.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("message_criteria" + "." + "_links" + "." + "related")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *EmsFilterModifyCollectionParamsBodyRulesItems0MessageCriteriaLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *EmsFilterModifyCollectionParamsBodyRulesItems0MessageCriteriaLinks) UnmarshalBinary(b []byte) error {
	var res EmsFilterModifyCollectionParamsBodyRulesItems0MessageCriteriaLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
EmsFilterModifyCollectionParamsBodyRulesItems0ParameterCriteriaItems0 Criterion used for parameter based filtering
swagger:model EmsFilterModifyCollectionParamsBodyRulesItems0ParameterCriteriaItems0
*/
type EmsFilterModifyCollectionParamsBodyRulesItems0ParameterCriteriaItems0 struct {

	// Parameter name pattern. Wildcard character '*' is supported.
	// Example: vol
	NamePattern *string `json:"name_pattern,omitempty"`

	// Parameter value pattern. Wildcard character '*' is supported.
	// Example: cloud*
	ValuePattern *string `json:"value_pattern,omitempty"`
}

// Validate validates this ems filter modify collection params body rules items0 parameter criteria items0
func (o *EmsFilterModifyCollectionParamsBodyRulesItems0ParameterCriteriaItems0) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this ems filter modify collection params body rules items0 parameter criteria items0 based on context it is used
func (o *EmsFilterModifyCollectionParamsBodyRulesItems0ParameterCriteriaItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *EmsFilterModifyCollectionParamsBodyRulesItems0ParameterCriteriaItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *EmsFilterModifyCollectionParamsBodyRulesItems0ParameterCriteriaItems0) UnmarshalBinary(b []byte) error {
	var res EmsFilterModifyCollectionParamsBodyRulesItems0ParameterCriteriaItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
