// Code generated by go-swagger; DO NOT EDIT.

package support

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewEmsFilterModifyParams creates a new EmsFilterModifyParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewEmsFilterModifyParams() *EmsFilterModifyParams {
	return &EmsFilterModifyParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewEmsFilterModifyParamsWithTimeout creates a new EmsFilterModifyParams object
// with the ability to set a timeout on a request.
func NewEmsFilterModifyParamsWithTimeout(timeout time.Duration) *EmsFilterModifyParams {
	return &EmsFilterModifyParams{
		timeout: timeout,
	}
}

// NewEmsFilterModifyParamsWithContext creates a new EmsFilterModifyParams object
// with the ability to set a context for a request.
func NewEmsFilterModifyParamsWithContext(ctx context.Context) *EmsFilterModifyParams {
	return &EmsFilterModifyParams{
		Context: ctx,
	}
}

// NewEmsFilterModifyParamsWithHTTPClient creates a new EmsFilterModifyParams object
// with the ability to set a custom HTTPClient for a request.
func NewEmsFilterModifyParamsWithHTTPClient(client *http.Client) *EmsFilterModifyParams {
	return &EmsFilterModifyParams{
		HTTPClient: client,
	}
}

/*
EmsFilterModifyParams contains all the parameters to send to the API endpoint

	for the ems filter modify operation.

	Typically these are written to a http.Request.
*/
type EmsFilterModifyParams struct {

	/* Info.

	   Information specification
	*/
	Info *models.EmsFilter

	/* Name.

	   Filter name
	*/
	Name string

	/* NewName.

	   New filter name for renames. Valid in PATCH.
	*/
	NewName *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the ems filter modify params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *EmsFilterModifyParams) WithDefaults() *EmsFilterModifyParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the ems filter modify params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *EmsFilterModifyParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the ems filter modify params
func (o *EmsFilterModifyParams) WithTimeout(timeout time.Duration) *EmsFilterModifyParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the ems filter modify params
func (o *EmsFilterModifyParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the ems filter modify params
func (o *EmsFilterModifyParams) WithContext(ctx context.Context) *EmsFilterModifyParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the ems filter modify params
func (o *EmsFilterModifyParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the ems filter modify params
func (o *EmsFilterModifyParams) WithHTTPClient(client *http.Client) *EmsFilterModifyParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the ems filter modify params
func (o *EmsFilterModifyParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithInfo adds the info to the ems filter modify params
func (o *EmsFilterModifyParams) WithInfo(info *models.EmsFilter) *EmsFilterModifyParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the ems filter modify params
func (o *EmsFilterModifyParams) SetInfo(info *models.EmsFilter) {
	o.Info = info
}

// WithName adds the name to the ems filter modify params
func (o *EmsFilterModifyParams) WithName(name string) *EmsFilterModifyParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the ems filter modify params
func (o *EmsFilterModifyParams) SetName(name string) {
	o.Name = name
}

// WithNewName adds the newName to the ems filter modify params
func (o *EmsFilterModifyParams) WithNewName(newName *string) *EmsFilterModifyParams {
	o.SetNewName(newName)
	return o
}

// SetNewName adds the newName to the ems filter modify params
func (o *EmsFilterModifyParams) SetNewName(newName *string) {
	o.NewName = newName
}

// WriteToRequest writes these params to a swagger request
func (o *EmsFilterModifyParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	// path param name
	if err := r.SetPathParam("name", o.Name); err != nil {
		return err
	}

	if o.NewName != nil {

		// query param new_name
		var qrNewName string

		if o.NewName != nil {
			qrNewName = *o.NewName
		}
		qNewName := qrNewName
		if qNewName != "" {

			if err := r.SetQueryParam("new_name", qNewName); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
