// Code generated by go-swagger; DO NOT EDIT.

package support

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewEmsFilterRuleDeleteCollectionParams creates a new EmsFilterRuleDeleteCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewEmsFilterRuleDeleteCollectionParams() *EmsFilterRuleDeleteCollectionParams {
	return &EmsFilterRuleDeleteCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewEmsFilterRuleDeleteCollectionParamsWithTimeout creates a new EmsFilterRuleDeleteCollectionParams object
// with the ability to set a timeout on a request.
func NewEmsFilterRuleDeleteCollectionParamsWithTimeout(timeout time.Duration) *EmsFilterRuleDeleteCollectionParams {
	return &EmsFilterRuleDeleteCollectionParams{
		timeout: timeout,
	}
}

// NewEmsFilterRuleDeleteCollectionParamsWithContext creates a new EmsFilterRuleDeleteCollectionParams object
// with the ability to set a context for a request.
func NewEmsFilterRuleDeleteCollectionParamsWithContext(ctx context.Context) *EmsFilterRuleDeleteCollectionParams {
	return &EmsFilterRuleDeleteCollectionParams{
		Context: ctx,
	}
}

// NewEmsFilterRuleDeleteCollectionParamsWithHTTPClient creates a new EmsFilterRuleDeleteCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewEmsFilterRuleDeleteCollectionParamsWithHTTPClient(client *http.Client) *EmsFilterRuleDeleteCollectionParams {
	return &EmsFilterRuleDeleteCollectionParams{
		HTTPClient: client,
	}
}

/*
EmsFilterRuleDeleteCollectionParams contains all the parameters to send to the API endpoint

	for the ems filter rule delete collection operation.

	Typically these are written to a http.Request.
*/
type EmsFilterRuleDeleteCollectionParams struct {

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* Index.

	   Filter by index
	*/
	Index *int64

	/* Info.

	   Info specification
	*/
	Info EmsFilterRuleDeleteCollectionBody

	/* MessageCriteriaNamePattern.

	   Filter by message_criteria.name_pattern
	*/
	MessageCriteriaNamePattern *string

	/* MessageCriteriaSeverities.

	   Filter by message_criteria.severities
	*/
	MessageCriteriaSeverities *string

	/* MessageCriteriaSnmpTrapTypes.

	   Filter by message_criteria.snmp_trap_types
	*/
	MessageCriteriaSnmpTrapTypes *string

	/* Name.

	   Filter Name
	*/
	Name string

	/* ParameterCriteriaNamePattern.

	   Filter by parameter_criteria.name_pattern
	*/
	ParameterCriteriaNamePattern *string

	/* ParameterCriteriaValuePattern.

	   Filter by parameter_criteria.value_pattern
	*/
	ParameterCriteriaValuePattern *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* Type.

	   Filter by type
	*/
	Type *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the ems filter rule delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *EmsFilterRuleDeleteCollectionParams) WithDefaults() *EmsFilterRuleDeleteCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the ems filter rule delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *EmsFilterRuleDeleteCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := EmsFilterRuleDeleteCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the ems filter rule delete collection params
func (o *EmsFilterRuleDeleteCollectionParams) WithTimeout(timeout time.Duration) *EmsFilterRuleDeleteCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the ems filter rule delete collection params
func (o *EmsFilterRuleDeleteCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the ems filter rule delete collection params
func (o *EmsFilterRuleDeleteCollectionParams) WithContext(ctx context.Context) *EmsFilterRuleDeleteCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the ems filter rule delete collection params
func (o *EmsFilterRuleDeleteCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the ems filter rule delete collection params
func (o *EmsFilterRuleDeleteCollectionParams) WithHTTPClient(client *http.Client) *EmsFilterRuleDeleteCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the ems filter rule delete collection params
func (o *EmsFilterRuleDeleteCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithContinueOnFailure adds the continueOnFailure to the ems filter rule delete collection params
func (o *EmsFilterRuleDeleteCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *EmsFilterRuleDeleteCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the ems filter rule delete collection params
func (o *EmsFilterRuleDeleteCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithIndex adds the index to the ems filter rule delete collection params
func (o *EmsFilterRuleDeleteCollectionParams) WithIndex(index *int64) *EmsFilterRuleDeleteCollectionParams {
	o.SetIndex(index)
	return o
}

// SetIndex adds the index to the ems filter rule delete collection params
func (o *EmsFilterRuleDeleteCollectionParams) SetIndex(index *int64) {
	o.Index = index
}

// WithInfo adds the info to the ems filter rule delete collection params
func (o *EmsFilterRuleDeleteCollectionParams) WithInfo(info EmsFilterRuleDeleteCollectionBody) *EmsFilterRuleDeleteCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the ems filter rule delete collection params
func (o *EmsFilterRuleDeleteCollectionParams) SetInfo(info EmsFilterRuleDeleteCollectionBody) {
	o.Info = info
}

// WithMessageCriteriaNamePattern adds the messageCriteriaNamePattern to the ems filter rule delete collection params
func (o *EmsFilterRuleDeleteCollectionParams) WithMessageCriteriaNamePattern(messageCriteriaNamePattern *string) *EmsFilterRuleDeleteCollectionParams {
	o.SetMessageCriteriaNamePattern(messageCriteriaNamePattern)
	return o
}

// SetMessageCriteriaNamePattern adds the messageCriteriaNamePattern to the ems filter rule delete collection params
func (o *EmsFilterRuleDeleteCollectionParams) SetMessageCriteriaNamePattern(messageCriteriaNamePattern *string) {
	o.MessageCriteriaNamePattern = messageCriteriaNamePattern
}

// WithMessageCriteriaSeverities adds the messageCriteriaSeverities to the ems filter rule delete collection params
func (o *EmsFilterRuleDeleteCollectionParams) WithMessageCriteriaSeverities(messageCriteriaSeverities *string) *EmsFilterRuleDeleteCollectionParams {
	o.SetMessageCriteriaSeverities(messageCriteriaSeverities)
	return o
}

// SetMessageCriteriaSeverities adds the messageCriteriaSeverities to the ems filter rule delete collection params
func (o *EmsFilterRuleDeleteCollectionParams) SetMessageCriteriaSeverities(messageCriteriaSeverities *string) {
	o.MessageCriteriaSeverities = messageCriteriaSeverities
}

// WithMessageCriteriaSnmpTrapTypes adds the messageCriteriaSnmpTrapTypes to the ems filter rule delete collection params
func (o *EmsFilterRuleDeleteCollectionParams) WithMessageCriteriaSnmpTrapTypes(messageCriteriaSnmpTrapTypes *string) *EmsFilterRuleDeleteCollectionParams {
	o.SetMessageCriteriaSnmpTrapTypes(messageCriteriaSnmpTrapTypes)
	return o
}

// SetMessageCriteriaSnmpTrapTypes adds the messageCriteriaSnmpTrapTypes to the ems filter rule delete collection params
func (o *EmsFilterRuleDeleteCollectionParams) SetMessageCriteriaSnmpTrapTypes(messageCriteriaSnmpTrapTypes *string) {
	o.MessageCriteriaSnmpTrapTypes = messageCriteriaSnmpTrapTypes
}

// WithName adds the name to the ems filter rule delete collection params
func (o *EmsFilterRuleDeleteCollectionParams) WithName(name string) *EmsFilterRuleDeleteCollectionParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the ems filter rule delete collection params
func (o *EmsFilterRuleDeleteCollectionParams) SetName(name string) {
	o.Name = name
}

// WithParameterCriteriaNamePattern adds the parameterCriteriaNamePattern to the ems filter rule delete collection params
func (o *EmsFilterRuleDeleteCollectionParams) WithParameterCriteriaNamePattern(parameterCriteriaNamePattern *string) *EmsFilterRuleDeleteCollectionParams {
	o.SetParameterCriteriaNamePattern(parameterCriteriaNamePattern)
	return o
}

// SetParameterCriteriaNamePattern adds the parameterCriteriaNamePattern to the ems filter rule delete collection params
func (o *EmsFilterRuleDeleteCollectionParams) SetParameterCriteriaNamePattern(parameterCriteriaNamePattern *string) {
	o.ParameterCriteriaNamePattern = parameterCriteriaNamePattern
}

// WithParameterCriteriaValuePattern adds the parameterCriteriaValuePattern to the ems filter rule delete collection params
func (o *EmsFilterRuleDeleteCollectionParams) WithParameterCriteriaValuePattern(parameterCriteriaValuePattern *string) *EmsFilterRuleDeleteCollectionParams {
	o.SetParameterCriteriaValuePattern(parameterCriteriaValuePattern)
	return o
}

// SetParameterCriteriaValuePattern adds the parameterCriteriaValuePattern to the ems filter rule delete collection params
func (o *EmsFilterRuleDeleteCollectionParams) SetParameterCriteriaValuePattern(parameterCriteriaValuePattern *string) {
	o.ParameterCriteriaValuePattern = parameterCriteriaValuePattern
}

// WithReturnRecords adds the returnRecords to the ems filter rule delete collection params
func (o *EmsFilterRuleDeleteCollectionParams) WithReturnRecords(returnRecords *bool) *EmsFilterRuleDeleteCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the ems filter rule delete collection params
func (o *EmsFilterRuleDeleteCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the ems filter rule delete collection params
func (o *EmsFilterRuleDeleteCollectionParams) WithReturnTimeout(returnTimeout *int64) *EmsFilterRuleDeleteCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the ems filter rule delete collection params
func (o *EmsFilterRuleDeleteCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSerialRecords adds the serialRecords to the ems filter rule delete collection params
func (o *EmsFilterRuleDeleteCollectionParams) WithSerialRecords(serialRecords *bool) *EmsFilterRuleDeleteCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the ems filter rule delete collection params
func (o *EmsFilterRuleDeleteCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithType adds the typeVar to the ems filter rule delete collection params
func (o *EmsFilterRuleDeleteCollectionParams) WithType(typeVar *string) *EmsFilterRuleDeleteCollectionParams {
	o.SetType(typeVar)
	return o
}

// SetType adds the type to the ems filter rule delete collection params
func (o *EmsFilterRuleDeleteCollectionParams) SetType(typeVar *string) {
	o.Type = typeVar
}

// WriteToRequest writes these params to a swagger request
func (o *EmsFilterRuleDeleteCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}

	if o.Index != nil {

		// query param index
		var qrIndex int64

		if o.Index != nil {
			qrIndex = *o.Index
		}
		qIndex := swag.FormatInt64(qrIndex)
		if qIndex != "" {

			if err := r.SetQueryParam("index", qIndex); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.MessageCriteriaNamePattern != nil {

		// query param message_criteria.name_pattern
		var qrMessageCriteriaNamePattern string

		if o.MessageCriteriaNamePattern != nil {
			qrMessageCriteriaNamePattern = *o.MessageCriteriaNamePattern
		}
		qMessageCriteriaNamePattern := qrMessageCriteriaNamePattern
		if qMessageCriteriaNamePattern != "" {

			if err := r.SetQueryParam("message_criteria.name_pattern", qMessageCriteriaNamePattern); err != nil {
				return err
			}
		}
	}

	if o.MessageCriteriaSeverities != nil {

		// query param message_criteria.severities
		var qrMessageCriteriaSeverities string

		if o.MessageCriteriaSeverities != nil {
			qrMessageCriteriaSeverities = *o.MessageCriteriaSeverities
		}
		qMessageCriteriaSeverities := qrMessageCriteriaSeverities
		if qMessageCriteriaSeverities != "" {

			if err := r.SetQueryParam("message_criteria.severities", qMessageCriteriaSeverities); err != nil {
				return err
			}
		}
	}

	if o.MessageCriteriaSnmpTrapTypes != nil {

		// query param message_criteria.snmp_trap_types
		var qrMessageCriteriaSnmpTrapTypes string

		if o.MessageCriteriaSnmpTrapTypes != nil {
			qrMessageCriteriaSnmpTrapTypes = *o.MessageCriteriaSnmpTrapTypes
		}
		qMessageCriteriaSnmpTrapTypes := qrMessageCriteriaSnmpTrapTypes
		if qMessageCriteriaSnmpTrapTypes != "" {

			if err := r.SetQueryParam("message_criteria.snmp_trap_types", qMessageCriteriaSnmpTrapTypes); err != nil {
				return err
			}
		}
	}

	// path param name
	if err := r.SetPathParam("name", o.Name); err != nil {
		return err
	}

	if o.ParameterCriteriaNamePattern != nil {

		// query param parameter_criteria.name_pattern
		var qrParameterCriteriaNamePattern string

		if o.ParameterCriteriaNamePattern != nil {
			qrParameterCriteriaNamePattern = *o.ParameterCriteriaNamePattern
		}
		qParameterCriteriaNamePattern := qrParameterCriteriaNamePattern
		if qParameterCriteriaNamePattern != "" {

			if err := r.SetQueryParam("parameter_criteria.name_pattern", qParameterCriteriaNamePattern); err != nil {
				return err
			}
		}
	}

	if o.ParameterCriteriaValuePattern != nil {

		// query param parameter_criteria.value_pattern
		var qrParameterCriteriaValuePattern string

		if o.ParameterCriteriaValuePattern != nil {
			qrParameterCriteriaValuePattern = *o.ParameterCriteriaValuePattern
		}
		qParameterCriteriaValuePattern := qrParameterCriteriaValuePattern
		if qParameterCriteriaValuePattern != "" {

			if err := r.SetQueryParam("parameter_criteria.value_pattern", qParameterCriteriaValuePattern); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.Type != nil {

		// query param type
		var qrType string

		if o.Type != nil {
			qrType = *o.Type
		}
		qType := qrType
		if qType != "" {

			if err := r.SetQueryParam("type", qType); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
