// Code generated by go-swagger; DO NOT EDIT.

package support

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// EmsFilterRuleDeleteCollectionReader is a Reader for the EmsFilterRuleDeleteCollection structure.
type EmsFilterRuleDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *EmsFilterRuleDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewEmsFilterRuleDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewEmsFilterRuleDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewEmsFilterRuleDeleteCollectionOK creates a EmsFilterRuleDeleteCollectionOK with default headers values
func NewEmsFilterRuleDeleteCollectionOK() *EmsFilterRuleDeleteCollectionOK {
	return &EmsFilterRuleDeleteCollectionOK{}
}

/*
EmsFilterRuleDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type EmsFilterRuleDeleteCollectionOK struct {
}

// IsSuccess returns true when this ems filter rule delete collection o k response has a 2xx status code
func (o *EmsFilterRuleDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this ems filter rule delete collection o k response has a 3xx status code
func (o *EmsFilterRuleDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this ems filter rule delete collection o k response has a 4xx status code
func (o *EmsFilterRuleDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this ems filter rule delete collection o k response has a 5xx status code
func (o *EmsFilterRuleDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this ems filter rule delete collection o k response a status code equal to that given
func (o *EmsFilterRuleDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the ems filter rule delete collection o k response
func (o *EmsFilterRuleDeleteCollectionOK) Code() int {
	return 200
}

func (o *EmsFilterRuleDeleteCollectionOK) Error() string {
	return fmt.Sprintf("[DELETE /support/ems/filters/{name}/rules][%d] emsFilterRuleDeleteCollectionOK", 200)
}

func (o *EmsFilterRuleDeleteCollectionOK) String() string {
	return fmt.Sprintf("[DELETE /support/ems/filters/{name}/rules][%d] emsFilterRuleDeleteCollectionOK", 200)
}

func (o *EmsFilterRuleDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewEmsFilterRuleDeleteCollectionDefault creates a EmsFilterRuleDeleteCollectionDefault with default headers values
func NewEmsFilterRuleDeleteCollectionDefault(code int) *EmsFilterRuleDeleteCollectionDefault {
	return &EmsFilterRuleDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
	EmsFilterRuleDeleteCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 983091 | A default rule cannot be removed |
| 983092 | The index of the rule provided is outside the allowed range for the filter provided |
| 983095 | The rule index provided is invalid for the filter provided |
| 983110 | There are no user defined rules in the filter provided |
| 983113 | Default filters cannot be modified or removed |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type EmsFilterRuleDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this ems filter rule delete collection default response has a 2xx status code
func (o *EmsFilterRuleDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this ems filter rule delete collection default response has a 3xx status code
func (o *EmsFilterRuleDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this ems filter rule delete collection default response has a 4xx status code
func (o *EmsFilterRuleDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this ems filter rule delete collection default response has a 5xx status code
func (o *EmsFilterRuleDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this ems filter rule delete collection default response a status code equal to that given
func (o *EmsFilterRuleDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the ems filter rule delete collection default response
func (o *EmsFilterRuleDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *EmsFilterRuleDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /support/ems/filters/{name}/rules][%d] ems_filter_rule_delete_collection default %s", o._statusCode, payload)
}

func (o *EmsFilterRuleDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /support/ems/filters/{name}/rules][%d] ems_filter_rule_delete_collection default %s", o._statusCode, payload)
}

func (o *EmsFilterRuleDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *EmsFilterRuleDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
EmsFilterRuleDeleteCollectionBody ems filter rule delete collection body
swagger:model EmsFilterRuleDeleteCollectionBody
*/
type EmsFilterRuleDeleteCollectionBody struct {

	// ems filter rule response inline records
	EmsFilterRuleResponseInlineRecords []*models.EmsFilterRuleResponseInlineRecordsInlineArrayItem `json:"records,omitempty"`
}

// Validate validates this ems filter rule delete collection body
func (o *EmsFilterRuleDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateEmsFilterRuleResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsFilterRuleDeleteCollectionBody) validateEmsFilterRuleResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.EmsFilterRuleResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.EmsFilterRuleResponseInlineRecords); i++ {
		if swag.IsZero(o.EmsFilterRuleResponseInlineRecords[i]) { // not required
			continue
		}

		if o.EmsFilterRuleResponseInlineRecords[i] != nil {
			if err := o.EmsFilterRuleResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this ems filter rule delete collection body based on the context it is used
func (o *EmsFilterRuleDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateEmsFilterRuleResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsFilterRuleDeleteCollectionBody) contextValidateEmsFilterRuleResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.EmsFilterRuleResponseInlineRecords); i++ {

		if o.EmsFilterRuleResponseInlineRecords[i] != nil {
			if err := o.EmsFilterRuleResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *EmsFilterRuleDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *EmsFilterRuleDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res EmsFilterRuleDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
EmsFilterRuleDeleteCollectionParamsBodyRecordsItems0ParameterCriteriaItems0 Criterion used for parameter based filtering
swagger:model EmsFilterRuleDeleteCollectionParamsBodyRecordsItems0ParameterCriteriaItems0
*/
type EmsFilterRuleDeleteCollectionParamsBodyRecordsItems0ParameterCriteriaItems0 struct {

	// Parameter name pattern. Wildcard character '*' is supported.
	// Example: vol
	NamePattern *string `json:"name_pattern,omitempty"`

	// Parameter value pattern. Wildcard character '*' is supported.
	// Example: cloud*
	ValuePattern *string `json:"value_pattern,omitempty"`
}

// Validate validates this ems filter rule delete collection params body records items0 parameter criteria items0
func (o *EmsFilterRuleDeleteCollectionParamsBodyRecordsItems0ParameterCriteriaItems0) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this ems filter rule delete collection params body records items0 parameter criteria items0 based on context it is used
func (o *EmsFilterRuleDeleteCollectionParamsBodyRecordsItems0ParameterCriteriaItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *EmsFilterRuleDeleteCollectionParamsBodyRecordsItems0ParameterCriteriaItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *EmsFilterRuleDeleteCollectionParamsBodyRecordsItems0ParameterCriteriaItems0) UnmarshalBinary(b []byte) error {
	var res EmsFilterRuleDeleteCollectionParamsBodyRecordsItems0ParameterCriteriaItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
EmsFilterRuleResponseInlineRecordsInlineArrayItem Rule for an event filter
swagger:model ems_filter_rule_response_inline_records_inline_array_item
*/
type EmsFilterRuleResponseInlineRecordsInlineArrayItem struct {

	// links
	Links *models.EmsFilterRuleResponseInlineRecordsInlineArrayItemInlineLinks `json:"_links,omitempty"`

	// Rule index. Rules are evaluated in ascending order. If a rule's index order is not specified during creation, the rule is appended to the end of the list.
	// Example: 1
	Index *int64 `json:"index,omitempty"`

	// message criteria
	MessageCriteria *models.EmsFilterRuleResponseInlineRecordsInlineArrayItemInlineMessageCriteria `json:"message_criteria,omitempty"`

	// Parameter criteria used to match against events' parameters. Each parameter consists of a name and a value. When multiple parameter criteria are provided in a rule, all must match for the rule to be considered matched. A pattern can include one or more wildcard '*' characters.
	ParameterCriteria []*EmsFilterRuleDeleteCollectionParamsBodyRecordsItems0ParameterCriteriaItems0 `json:"parameter_criteria"`

	// Rule type
	// Example: include
	// Enum: ["include","exclude"]
	Type *string `json:"type,omitempty"`
}

// Validate validates this ems filter rule response inline records inline array item
func (o *EmsFilterRuleResponseInlineRecordsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMessageCriteria(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateParameterCriteria(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsFilterRuleResponseInlineRecordsInlineArrayItem) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (o *EmsFilterRuleResponseInlineRecordsInlineArrayItem) validateMessageCriteria(formats strfmt.Registry) error {
	if swag.IsZero(o.MessageCriteria) { // not required
		return nil
	}

	if o.MessageCriteria != nil {
		if err := o.MessageCriteria.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("message_criteria")
			}
			return err
		}
	}

	return nil
}

func (o *EmsFilterRuleResponseInlineRecordsInlineArrayItem) validateParameterCriteria(formats strfmt.Registry) error {
	if swag.IsZero(o.ParameterCriteria) { // not required
		return nil
	}

	for i := 0; i < len(o.ParameterCriteria); i++ {
		if swag.IsZero(o.ParameterCriteria[i]) { // not required
			continue
		}

		if o.ParameterCriteria[i] != nil {
			if err := o.ParameterCriteria[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("parameter_criteria" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var emsFilterRuleResponseInlineRecordsInlineArrayItemTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["include","exclude"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		emsFilterRuleResponseInlineRecordsInlineArrayItemTypeTypePropEnum = append(emsFilterRuleResponseInlineRecordsInlineArrayItemTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ems_filter_rule_response_inline_records_inline_array_item
	// EmsFilterRuleResponseInlineRecordsInlineArrayItem
	// type
	// Type
	// include
	// END DEBUGGING
	// EmsFilterRuleResponseInlineRecordsInlineArrayItemTypeInclude captures enum value "include"
	EmsFilterRuleResponseInlineRecordsInlineArrayItemTypeInclude string = "include"

	// BEGIN DEBUGGING
	// ems_filter_rule_response_inline_records_inline_array_item
	// EmsFilterRuleResponseInlineRecordsInlineArrayItem
	// type
	// Type
	// exclude
	// END DEBUGGING
	// EmsFilterRuleResponseInlineRecordsInlineArrayItemTypeExclude captures enum value "exclude"
	EmsFilterRuleResponseInlineRecordsInlineArrayItemTypeExclude string = "exclude"
)

// prop value enum
func (o *EmsFilterRuleResponseInlineRecordsInlineArrayItem) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, emsFilterRuleResponseInlineRecordsInlineArrayItemTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *EmsFilterRuleResponseInlineRecordsInlineArrayItem) validateType(formats strfmt.Registry) error {
	if swag.IsZero(o.Type) { // not required
		return nil
	}

	// value enum
	if err := o.validateTypeEnum("type", "body", *o.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this ems filter rule response inline records inline array item based on the context it is used
func (o *EmsFilterRuleResponseInlineRecordsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMessageCriteria(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateParameterCriteria(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsFilterRuleResponseInlineRecordsInlineArrayItem) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (o *EmsFilterRuleResponseInlineRecordsInlineArrayItem) contextValidateMessageCriteria(ctx context.Context, formats strfmt.Registry) error {

	if o.MessageCriteria != nil {
		if err := o.MessageCriteria.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("message_criteria")
			}
			return err
		}
	}

	return nil
}

func (o *EmsFilterRuleResponseInlineRecordsInlineArrayItem) contextValidateParameterCriteria(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.ParameterCriteria); i++ {

		if o.ParameterCriteria[i] != nil {
			if err := o.ParameterCriteria[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("parameter_criteria" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *EmsFilterRuleResponseInlineRecordsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *EmsFilterRuleResponseInlineRecordsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res EmsFilterRuleResponseInlineRecordsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
EmsFilterRuleResponseInlineRecordsInlineArrayItemInlineLinks ems filter rule response inline records inline array item inline links
swagger:model ems_filter_rule_response_inline_records_inline_array_item_inline__links
*/
type EmsFilterRuleResponseInlineRecordsInlineArrayItemInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this ems filter rule response inline records inline array item inline links
func (o *EmsFilterRuleResponseInlineRecordsInlineArrayItemInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsFilterRuleResponseInlineRecordsInlineArrayItemInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ems filter rule response inline records inline array item inline links based on the context it is used
func (o *EmsFilterRuleResponseInlineRecordsInlineArrayItemInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsFilterRuleResponseInlineRecordsInlineArrayItemInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *EmsFilterRuleResponseInlineRecordsInlineArrayItemInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *EmsFilterRuleResponseInlineRecordsInlineArrayItemInlineLinks) UnmarshalBinary(b []byte) error {
	var res EmsFilterRuleResponseInlineRecordsInlineArrayItemInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
EmsFilterRuleResponseInlineRecordsInlineArrayItemInlineMessageCriteria Matching message definitions for the filter. A property must be specified.
swagger:model ems_filter_rule_response_inline_records_inline_array_item_inline_message_criteria
*/
type EmsFilterRuleResponseInlineRecordsInlineArrayItemInlineMessageCriteria struct {

	// links
	Links *models.EmsFilterRuleResponseInlineRecordsInlineArrayItemInlineMessageCriteriaInlineLinks `json:"_links,omitempty"`

	// Message name filter on which to match. Supports wildcards. Defaults to * if not specified.
	// Example: wafl.*
	NamePattern *string `json:"name_pattern,omitempty"`

	// A comma-separated list of severities or a wildcard.
	// Example: emergency,alert,error
	Severities *string `json:"severities,omitempty"`

	// A comma separated list of snmp_trap_types or a wildcard.
	// Example: standard,built_in
	SnmpTrapTypes *string `json:"snmp_trap_types,omitempty"`
}

// Validate validates this ems filter rule response inline records inline array item inline message criteria
func (o *EmsFilterRuleResponseInlineRecordsInlineArrayItemInlineMessageCriteria) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsFilterRuleResponseInlineRecordsInlineArrayItemInlineMessageCriteria) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("message_criteria" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ems filter rule response inline records inline array item inline message criteria based on the context it is used
func (o *EmsFilterRuleResponseInlineRecordsInlineArrayItemInlineMessageCriteria) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsFilterRuleResponseInlineRecordsInlineArrayItemInlineMessageCriteria) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("message_criteria" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *EmsFilterRuleResponseInlineRecordsInlineArrayItemInlineMessageCriteria) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *EmsFilterRuleResponseInlineRecordsInlineArrayItemInlineMessageCriteria) UnmarshalBinary(b []byte) error {
	var res EmsFilterRuleResponseInlineRecordsInlineArrayItemInlineMessageCriteria
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
EmsFilterRuleResponseInlineRecordsInlineArrayItemInlineMessageCriteriaInlineLinks ems filter rule response inline records inline array item inline message criteria inline links
swagger:model ems_filter_rule_response_inline_records_inline_array_item_inline_message_criteria_inline__links
*/
type EmsFilterRuleResponseInlineRecordsInlineArrayItemInlineMessageCriteriaInlineLinks struct {

	// related
	Related *models.Href `json:"related,omitempty"`
}

// Validate validates this ems filter rule response inline records inline array item inline message criteria inline links
func (o *EmsFilterRuleResponseInlineRecordsInlineArrayItemInlineMessageCriteriaInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateRelated(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsFilterRuleResponseInlineRecordsInlineArrayItemInlineMessageCriteriaInlineLinks) validateRelated(formats strfmt.Registry) error {
	if swag.IsZero(o.Related) { // not required
		return nil
	}

	if o.Related != nil {
		if err := o.Related.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("message_criteria" + "." + "_links" + "." + "related")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ems filter rule response inline records inline array item inline message criteria inline links based on the context it is used
func (o *EmsFilterRuleResponseInlineRecordsInlineArrayItemInlineMessageCriteriaInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateRelated(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsFilterRuleResponseInlineRecordsInlineArrayItemInlineMessageCriteriaInlineLinks) contextValidateRelated(ctx context.Context, formats strfmt.Registry) error {

	if o.Related != nil {
		if err := o.Related.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("message_criteria" + "." + "_links" + "." + "related")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *EmsFilterRuleResponseInlineRecordsInlineArrayItemInlineMessageCriteriaInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *EmsFilterRuleResponseInlineRecordsInlineArrayItemInlineMessageCriteriaInlineLinks) UnmarshalBinary(b []byte) error {
	var res EmsFilterRuleResponseInlineRecordsInlineArrayItemInlineMessageCriteriaInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
