// Code generated by go-swagger; DO NOT EDIT.

package support

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// EmsFilterRuleGetReader is a Reader for the EmsFilterRuleGet structure.
type EmsFilterRuleGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *EmsFilterRuleGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewEmsFilterRuleGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewEmsFilterRuleGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewEmsFilterRuleGetOK creates a EmsFilterRuleGetOK with default headers values
func NewEmsFilterRuleGetOK() *EmsFilterRuleGetOK {
	return &EmsFilterRuleGetOK{}
}

/*
EmsFilterRuleGetOK describes a response with status code 200, with default header values.

OK
*/
type EmsFilterRuleGetOK struct {
	Payload *models.EmsFilterRule
}

// IsSuccess returns true when this ems filter rule get o k response has a 2xx status code
func (o *EmsFilterRuleGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this ems filter rule get o k response has a 3xx status code
func (o *EmsFilterRuleGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this ems filter rule get o k response has a 4xx status code
func (o *EmsFilterRuleGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this ems filter rule get o k response has a 5xx status code
func (o *EmsFilterRuleGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this ems filter rule get o k response a status code equal to that given
func (o *EmsFilterRuleGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the ems filter rule get o k response
func (o *EmsFilterRuleGetOK) Code() int {
	return 200
}

func (o *EmsFilterRuleGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /support/ems/filters/{name}/rules/{index}][%d] emsFilterRuleGetOK %s", 200, payload)
}

func (o *EmsFilterRuleGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /support/ems/filters/{name}/rules/{index}][%d] emsFilterRuleGetOK %s", 200, payload)
}

func (o *EmsFilterRuleGetOK) GetPayload() *models.EmsFilterRule {
	return o.Payload
}

func (o *EmsFilterRuleGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.EmsFilterRule)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewEmsFilterRuleGetDefault creates a EmsFilterRuleGetDefault with default headers values
func NewEmsFilterRuleGetDefault(code int) *EmsFilterRuleGetDefault {
	return &EmsFilterRuleGetDefault{
		_statusCode: code,
	}
}

/*
EmsFilterRuleGetDefault describes a response with status code -1, with default header values.

Error
*/
type EmsFilterRuleGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this ems filter rule get default response has a 2xx status code
func (o *EmsFilterRuleGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this ems filter rule get default response has a 3xx status code
func (o *EmsFilterRuleGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this ems filter rule get default response has a 4xx status code
func (o *EmsFilterRuleGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this ems filter rule get default response has a 5xx status code
func (o *EmsFilterRuleGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this ems filter rule get default response a status code equal to that given
func (o *EmsFilterRuleGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the ems filter rule get default response
func (o *EmsFilterRuleGetDefault) Code() int {
	return o._statusCode
}

func (o *EmsFilterRuleGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /support/ems/filters/{name}/rules/{index}][%d] ems_filter_rule_get default %s", o._statusCode, payload)
}

func (o *EmsFilterRuleGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /support/ems/filters/{name}/rules/{index}][%d] ems_filter_rule_get default %s", o._statusCode, payload)
}

func (o *EmsFilterRuleGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *EmsFilterRuleGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
