// Code generated by go-swagger; DO NOT EDIT.

package support

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// EmsFilterRuleModifyCollectionReader is a Reader for the EmsFilterRuleModifyCollection structure.
type EmsFilterRuleModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *EmsFilterRuleModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewEmsFilterRuleModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewEmsFilterRuleModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewEmsFilterRuleModifyCollectionOK creates a EmsFilterRuleModifyCollectionOK with default headers values
func NewEmsFilterRuleModifyCollectionOK() *EmsFilterRuleModifyCollectionOK {
	return &EmsFilterRuleModifyCollectionOK{}
}

/*
EmsFilterRuleModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type EmsFilterRuleModifyCollectionOK struct {
}

// IsSuccess returns true when this ems filter rule modify collection o k response has a 2xx status code
func (o *EmsFilterRuleModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this ems filter rule modify collection o k response has a 3xx status code
func (o *EmsFilterRuleModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this ems filter rule modify collection o k response has a 4xx status code
func (o *EmsFilterRuleModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this ems filter rule modify collection o k response has a 5xx status code
func (o *EmsFilterRuleModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this ems filter rule modify collection o k response a status code equal to that given
func (o *EmsFilterRuleModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the ems filter rule modify collection o k response
func (o *EmsFilterRuleModifyCollectionOK) Code() int {
	return 200
}

func (o *EmsFilterRuleModifyCollectionOK) Error() string {
	return fmt.Sprintf("[PATCH /support/ems/filters/{name}/rules][%d] emsFilterRuleModifyCollectionOK", 200)
}

func (o *EmsFilterRuleModifyCollectionOK) String() string {
	return fmt.Sprintf("[PATCH /support/ems/filters/{name}/rules][%d] emsFilterRuleModifyCollectionOK", 200)
}

func (o *EmsFilterRuleModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewEmsFilterRuleModifyCollectionDefault creates a EmsFilterRuleModifyCollectionDefault with default headers values
func NewEmsFilterRuleModifyCollectionDefault(code int) *EmsFilterRuleModifyCollectionDefault {
	return &EmsFilterRuleModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	EmsFilterRuleModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 983092 | The index of the rule provided is outside the allowed range for the filter provided |
| 983095 | The rule index provided is invalid for the filter provided |
| 983113 | Default filters cannot be modified or removed |
| 983126 | A rule requires at least one name_pattern, severities, snmp_trap_types, or parameter pattern to be defined |
| 983127 | A property cannot contain a combination of the wildcard characters and other values. |
| 983128 | An invalid value is provided for the property 'snmp_trap_types' |
| 983146 | An invalid value is provided for the property 'severities' |
| 983147 | The severities provided are not supported |
| 983155 | The provided severities property does not match that of the name_pattern |
| 983156 | The provided snmp_trap_types property does not match that of the name_pattern |
| 983157 | The provided severities and snmp_trap_types properties do not match those of the name_pattern |
| 983158 | The name_pattern provided does not exist |
| 983195 | Empty field in parameter_criteria. Both name and value patterns must be specified |
| 983196 | name_pattern and value_pattern fields in parameter_criteria are empty |
| 983211 | Parameter criteria based filtering is not supported in this version of ONTAP |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type EmsFilterRuleModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this ems filter rule modify collection default response has a 2xx status code
func (o *EmsFilterRuleModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this ems filter rule modify collection default response has a 3xx status code
func (o *EmsFilterRuleModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this ems filter rule modify collection default response has a 4xx status code
func (o *EmsFilterRuleModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this ems filter rule modify collection default response has a 5xx status code
func (o *EmsFilterRuleModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this ems filter rule modify collection default response a status code equal to that given
func (o *EmsFilterRuleModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the ems filter rule modify collection default response
func (o *EmsFilterRuleModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *EmsFilterRuleModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /support/ems/filters/{name}/rules][%d] ems_filter_rule_modify_collection default %s", o._statusCode, payload)
}

func (o *EmsFilterRuleModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /support/ems/filters/{name}/rules][%d] ems_filter_rule_modify_collection default %s", o._statusCode, payload)
}

func (o *EmsFilterRuleModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *EmsFilterRuleModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
EmsFilterRuleModifyCollectionBody ems filter rule modify collection body
swagger:model EmsFilterRuleModifyCollectionBody
*/
type EmsFilterRuleModifyCollectionBody struct {

	// links
	Links *models.EmsFilterRuleResponseInlineRecordsInlineArrayItemInlineLinks `json:"_links,omitempty"`

	// ems filter rule response inline records
	EmsFilterRuleResponseInlineRecords []*models.EmsFilterRuleResponseInlineRecordsInlineArrayItem `json:"records,omitempty"`

	// Rule index. Rules are evaluated in ascending order. If a rule's index order is not specified during creation, the rule is appended to the end of the list.
	// Example: 1
	Index *int64 `json:"index,omitempty"`

	// message criteria
	MessageCriteria *models.EmsFilterRuleResponseInlineRecordsInlineArrayItemInlineMessageCriteria `json:"message_criteria,omitempty"`

	// Parameter criteria used to match against events' parameters. Each parameter consists of a name and a value. When multiple parameter criteria are provided in a rule, all must match for the rule to be considered matched. A pattern can include one or more wildcard '*' characters.
	ParameterCriteria []*EmsFilterRuleModifyCollectionParamsBodyParameterCriteriaItems0 `json:"parameter_criteria"`

	// Rule type
	// Example: include
	// Enum: ["include","exclude"]
	Type *string `json:"type,omitempty"`
}

// Validate validates this ems filter rule modify collection body
func (o *EmsFilterRuleModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateEmsFilterRuleResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMessageCriteria(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateParameterCriteria(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsFilterRuleModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *EmsFilterRuleModifyCollectionBody) validateEmsFilterRuleResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.EmsFilterRuleResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.EmsFilterRuleResponseInlineRecords); i++ {
		if swag.IsZero(o.EmsFilterRuleResponseInlineRecords[i]) { // not required
			continue
		}

		if o.EmsFilterRuleResponseInlineRecords[i] != nil {
			if err := o.EmsFilterRuleResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *EmsFilterRuleModifyCollectionBody) validateMessageCriteria(formats strfmt.Registry) error {
	if swag.IsZero(o.MessageCriteria) { // not required
		return nil
	}

	if o.MessageCriteria != nil {
		if err := o.MessageCriteria.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "message_criteria")
			}
			return err
		}
	}

	return nil
}

func (o *EmsFilterRuleModifyCollectionBody) validateParameterCriteria(formats strfmt.Registry) error {
	if swag.IsZero(o.ParameterCriteria) { // not required
		return nil
	}

	for i := 0; i < len(o.ParameterCriteria); i++ {
		if swag.IsZero(o.ParameterCriteria[i]) { // not required
			continue
		}

		if o.ParameterCriteria[i] != nil {
			if err := o.ParameterCriteria[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "parameter_criteria" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var emsFilterRuleModifyCollectionBodyTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["include","exclude"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		emsFilterRuleModifyCollectionBodyTypeTypePropEnum = append(emsFilterRuleModifyCollectionBodyTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// EmsFilterRuleModifyCollectionBody
	// EmsFilterRuleModifyCollectionBody
	// type
	// Type
	// include
	// END DEBUGGING
	// EmsFilterRuleModifyCollectionBodyTypeInclude captures enum value "include"
	EmsFilterRuleModifyCollectionBodyTypeInclude string = "include"

	// BEGIN DEBUGGING
	// EmsFilterRuleModifyCollectionBody
	// EmsFilterRuleModifyCollectionBody
	// type
	// Type
	// exclude
	// END DEBUGGING
	// EmsFilterRuleModifyCollectionBodyTypeExclude captures enum value "exclude"
	EmsFilterRuleModifyCollectionBodyTypeExclude string = "exclude"
)

// prop value enum
func (o *EmsFilterRuleModifyCollectionBody) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, emsFilterRuleModifyCollectionBodyTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *EmsFilterRuleModifyCollectionBody) validateType(formats strfmt.Registry) error {
	if swag.IsZero(o.Type) { // not required
		return nil
	}

	// value enum
	if err := o.validateTypeEnum("info"+"."+"type", "body", *o.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this ems filter rule modify collection body based on the context it is used
func (o *EmsFilterRuleModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateEmsFilterRuleResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMessageCriteria(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateParameterCriteria(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsFilterRuleModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *EmsFilterRuleModifyCollectionBody) contextValidateEmsFilterRuleResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.EmsFilterRuleResponseInlineRecords); i++ {

		if o.EmsFilterRuleResponseInlineRecords[i] != nil {
			if err := o.EmsFilterRuleResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *EmsFilterRuleModifyCollectionBody) contextValidateMessageCriteria(ctx context.Context, formats strfmt.Registry) error {

	if o.MessageCriteria != nil {
		if err := o.MessageCriteria.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "message_criteria")
			}
			return err
		}
	}

	return nil
}

func (o *EmsFilterRuleModifyCollectionBody) contextValidateParameterCriteria(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.ParameterCriteria); i++ {

		if o.ParameterCriteria[i] != nil {
			if err := o.ParameterCriteria[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "parameter_criteria" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *EmsFilterRuleModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *EmsFilterRuleModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res EmsFilterRuleModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
EmsFilterRuleModifyCollectionParamsBodyParameterCriteriaItems0 Criterion used for parameter based filtering
swagger:model EmsFilterRuleModifyCollectionParamsBodyParameterCriteriaItems0
*/
type EmsFilterRuleModifyCollectionParamsBodyParameterCriteriaItems0 struct {

	// Parameter name pattern. Wildcard character '*' is supported.
	// Example: vol
	NamePattern *string `json:"name_pattern,omitempty"`

	// Parameter value pattern. Wildcard character '*' is supported.
	// Example: cloud*
	ValuePattern *string `json:"value_pattern,omitempty"`
}

// Validate validates this ems filter rule modify collection params body parameter criteria items0
func (o *EmsFilterRuleModifyCollectionParamsBodyParameterCriteriaItems0) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this ems filter rule modify collection params body parameter criteria items0 based on context it is used
func (o *EmsFilterRuleModifyCollectionParamsBodyParameterCriteriaItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *EmsFilterRuleModifyCollectionParamsBodyParameterCriteriaItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *EmsFilterRuleModifyCollectionParamsBodyParameterCriteriaItems0) UnmarshalBinary(b []byte) error {
	var res EmsFilterRuleModifyCollectionParamsBodyParameterCriteriaItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
EmsFilterRuleModifyCollectionParamsBodyRecordsItems0ParameterCriteriaItems0 Criterion used for parameter based filtering
swagger:model EmsFilterRuleModifyCollectionParamsBodyRecordsItems0ParameterCriteriaItems0
*/
type EmsFilterRuleModifyCollectionParamsBodyRecordsItems0ParameterCriteriaItems0 struct {

	// Parameter name pattern. Wildcard character '*' is supported.
	// Example: vol
	NamePattern *string `json:"name_pattern,omitempty"`

	// Parameter value pattern. Wildcard character '*' is supported.
	// Example: cloud*
	ValuePattern *string `json:"value_pattern,omitempty"`
}

// Validate validates this ems filter rule modify collection params body records items0 parameter criteria items0
func (o *EmsFilterRuleModifyCollectionParamsBodyRecordsItems0ParameterCriteriaItems0) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this ems filter rule modify collection params body records items0 parameter criteria items0 based on context it is used
func (o *EmsFilterRuleModifyCollectionParamsBodyRecordsItems0ParameterCriteriaItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *EmsFilterRuleModifyCollectionParamsBodyRecordsItems0ParameterCriteriaItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *EmsFilterRuleModifyCollectionParamsBodyRecordsItems0ParameterCriteriaItems0) UnmarshalBinary(b []byte) error {
	var res EmsFilterRuleModifyCollectionParamsBodyRecordsItems0ParameterCriteriaItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
