// Code generated by go-swagger; DO NOT EDIT.

package support

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewEmsFilterRuleModifyParams creates a new EmsFilterRuleModifyParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewEmsFilterRuleModifyParams() *EmsFilterRuleModifyParams {
	return &EmsFilterRuleModifyParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewEmsFilterRuleModifyParamsWithTimeout creates a new EmsFilterRuleModifyParams object
// with the ability to set a timeout on a request.
func NewEmsFilterRuleModifyParamsWithTimeout(timeout time.Duration) *EmsFilterRuleModifyParams {
	return &EmsFilterRuleModifyParams{
		timeout: timeout,
	}
}

// NewEmsFilterRuleModifyParamsWithContext creates a new EmsFilterRuleModifyParams object
// with the ability to set a context for a request.
func NewEmsFilterRuleModifyParamsWithContext(ctx context.Context) *EmsFilterRuleModifyParams {
	return &EmsFilterRuleModifyParams{
		Context: ctx,
	}
}

// NewEmsFilterRuleModifyParamsWithHTTPClient creates a new EmsFilterRuleModifyParams object
// with the ability to set a custom HTTPClient for a request.
func NewEmsFilterRuleModifyParamsWithHTTPClient(client *http.Client) *EmsFilterRuleModifyParams {
	return &EmsFilterRuleModifyParams{
		HTTPClient: client,
	}
}

/*
EmsFilterRuleModifyParams contains all the parameters to send to the API endpoint

	for the ems filter rule modify operation.

	Typically these are written to a http.Request.
*/
type EmsFilterRuleModifyParams struct {

	/* Index.

	   Filter rule index
	*/
	Index string

	/* Info.

	   Information specification
	*/
	Info *models.EmsFilterRule

	/* Name.

	   Filter name
	*/
	Name string

	/* NewIndex.

	   New position for the filter rule index
	*/
	NewIndex *int64

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the ems filter rule modify params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *EmsFilterRuleModifyParams) WithDefaults() *EmsFilterRuleModifyParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the ems filter rule modify params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *EmsFilterRuleModifyParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the ems filter rule modify params
func (o *EmsFilterRuleModifyParams) WithTimeout(timeout time.Duration) *EmsFilterRuleModifyParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the ems filter rule modify params
func (o *EmsFilterRuleModifyParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the ems filter rule modify params
func (o *EmsFilterRuleModifyParams) WithContext(ctx context.Context) *EmsFilterRuleModifyParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the ems filter rule modify params
func (o *EmsFilterRuleModifyParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the ems filter rule modify params
func (o *EmsFilterRuleModifyParams) WithHTTPClient(client *http.Client) *EmsFilterRuleModifyParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the ems filter rule modify params
func (o *EmsFilterRuleModifyParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithIndex adds the index to the ems filter rule modify params
func (o *EmsFilterRuleModifyParams) WithIndex(index string) *EmsFilterRuleModifyParams {
	o.SetIndex(index)
	return o
}

// SetIndex adds the index to the ems filter rule modify params
func (o *EmsFilterRuleModifyParams) SetIndex(index string) {
	o.Index = index
}

// WithInfo adds the info to the ems filter rule modify params
func (o *EmsFilterRuleModifyParams) WithInfo(info *models.EmsFilterRule) *EmsFilterRuleModifyParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the ems filter rule modify params
func (o *EmsFilterRuleModifyParams) SetInfo(info *models.EmsFilterRule) {
	o.Info = info
}

// WithName adds the name to the ems filter rule modify params
func (o *EmsFilterRuleModifyParams) WithName(name string) *EmsFilterRuleModifyParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the ems filter rule modify params
func (o *EmsFilterRuleModifyParams) SetName(name string) {
	o.Name = name
}

// WithNewIndex adds the newIndex to the ems filter rule modify params
func (o *EmsFilterRuleModifyParams) WithNewIndex(newIndex *int64) *EmsFilterRuleModifyParams {
	o.SetNewIndex(newIndex)
	return o
}

// SetNewIndex adds the newIndex to the ems filter rule modify params
func (o *EmsFilterRuleModifyParams) SetNewIndex(newIndex *int64) {
	o.NewIndex = newIndex
}

// WriteToRequest writes these params to a swagger request
func (o *EmsFilterRuleModifyParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param index
	if err := r.SetPathParam("index", o.Index); err != nil {
		return err
	}
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	// path param name
	if err := r.SetPathParam("name", o.Name); err != nil {
		return err
	}

	if o.NewIndex != nil {

		// query param new_index
		var qrNewIndex int64

		if o.NewIndex != nil {
			qrNewIndex = *o.NewIndex
		}
		qNewIndex := swag.FormatInt64(qrNewIndex)
		if qNewIndex != "" {

			if err := r.SetQueryParam("new_index", qNewIndex); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
