// Code generated by go-swagger; DO NOT EDIT.

package support

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewEmsFiltersRulesCreateParams creates a new EmsFiltersRulesCreateParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewEmsFiltersRulesCreateParams() *EmsFiltersRulesCreateParams {
	return &EmsFiltersRulesCreateParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewEmsFiltersRulesCreateParamsWithTimeout creates a new EmsFiltersRulesCreateParams object
// with the ability to set a timeout on a request.
func NewEmsFiltersRulesCreateParamsWithTimeout(timeout time.Duration) *EmsFiltersRulesCreateParams {
	return &EmsFiltersRulesCreateParams{
		timeout: timeout,
	}
}

// NewEmsFiltersRulesCreateParamsWithContext creates a new EmsFiltersRulesCreateParams object
// with the ability to set a context for a request.
func NewEmsFiltersRulesCreateParamsWithContext(ctx context.Context) *EmsFiltersRulesCreateParams {
	return &EmsFiltersRulesCreateParams{
		Context: ctx,
	}
}

// NewEmsFiltersRulesCreateParamsWithHTTPClient creates a new EmsFiltersRulesCreateParams object
// with the ability to set a custom HTTPClient for a request.
func NewEmsFiltersRulesCreateParamsWithHTTPClient(client *http.Client) *EmsFiltersRulesCreateParams {
	return &EmsFiltersRulesCreateParams{
		HTTPClient: client,
	}
}

/*
EmsFiltersRulesCreateParams contains all the parameters to send to the API endpoint

	for the ems filters rules create operation.

	Typically these are written to a http.Request.
*/
type EmsFiltersRulesCreateParams struct {

	/* Info.

	   Information specification
	*/
	Info *models.EmsFilterRule

	/* Name.

	   Filter name
	*/
	Name string

	/* ReturnRecords.

	   The default is false.  If set to true, the records are returned.
	*/
	ReturnRecords *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the ems filters rules create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *EmsFiltersRulesCreateParams) WithDefaults() *EmsFiltersRulesCreateParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the ems filters rules create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *EmsFiltersRulesCreateParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(false)
	)

	val := EmsFiltersRulesCreateParams{
		ReturnRecords: &returnRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the ems filters rules create params
func (o *EmsFiltersRulesCreateParams) WithTimeout(timeout time.Duration) *EmsFiltersRulesCreateParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the ems filters rules create params
func (o *EmsFiltersRulesCreateParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the ems filters rules create params
func (o *EmsFiltersRulesCreateParams) WithContext(ctx context.Context) *EmsFiltersRulesCreateParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the ems filters rules create params
func (o *EmsFiltersRulesCreateParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the ems filters rules create params
func (o *EmsFiltersRulesCreateParams) WithHTTPClient(client *http.Client) *EmsFiltersRulesCreateParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the ems filters rules create params
func (o *EmsFiltersRulesCreateParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithInfo adds the info to the ems filters rules create params
func (o *EmsFiltersRulesCreateParams) WithInfo(info *models.EmsFilterRule) *EmsFiltersRulesCreateParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the ems filters rules create params
func (o *EmsFiltersRulesCreateParams) SetInfo(info *models.EmsFilterRule) {
	o.Info = info
}

// WithName adds the name to the ems filters rules create params
func (o *EmsFiltersRulesCreateParams) WithName(name string) *EmsFiltersRulesCreateParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the ems filters rules create params
func (o *EmsFiltersRulesCreateParams) SetName(name string) {
	o.Name = name
}

// WithReturnRecords adds the returnRecords to the ems filters rules create params
func (o *EmsFiltersRulesCreateParams) WithReturnRecords(returnRecords *bool) *EmsFiltersRulesCreateParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the ems filters rules create params
func (o *EmsFiltersRulesCreateParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WriteToRequest writes these params to a swagger request
func (o *EmsFiltersRulesCreateParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	// path param name
	if err := r.SetPathParam("name", o.Name); err != nil {
		return err
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
