// Code generated by go-swagger; DO NOT EDIT.

package support

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewEmsRoleConfigCollectionGetParams creates a new EmsRoleConfigCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewEmsRoleConfigCollectionGetParams() *EmsRoleConfigCollectionGetParams {
	return &EmsRoleConfigCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewEmsRoleConfigCollectionGetParamsWithTimeout creates a new EmsRoleConfigCollectionGetParams object
// with the ability to set a timeout on a request.
func NewEmsRoleConfigCollectionGetParamsWithTimeout(timeout time.Duration) *EmsRoleConfigCollectionGetParams {
	return &EmsRoleConfigCollectionGetParams{
		timeout: timeout,
	}
}

// NewEmsRoleConfigCollectionGetParamsWithContext creates a new EmsRoleConfigCollectionGetParams object
// with the ability to set a context for a request.
func NewEmsRoleConfigCollectionGetParamsWithContext(ctx context.Context) *EmsRoleConfigCollectionGetParams {
	return &EmsRoleConfigCollectionGetParams{
		Context: ctx,
	}
}

// NewEmsRoleConfigCollectionGetParamsWithHTTPClient creates a new EmsRoleConfigCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewEmsRoleConfigCollectionGetParamsWithHTTPClient(client *http.Client) *EmsRoleConfigCollectionGetParams {
	return &EmsRoleConfigCollectionGetParams{
		HTTPClient: client,
	}
}

/*
EmsRoleConfigCollectionGetParams contains all the parameters to send to the API endpoint

	for the ems role config collection get operation.

	Typically these are written to a http.Request.
*/
type EmsRoleConfigCollectionGetParams struct {

	/* AccessControlRoleName.

	   Filter by access_control_role.name
	*/
	AccessControlRoleName *string

	/* EventFilterName.

	   Filter by event_filter.name
	*/
	EventFilterName *string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* LimitAccessToGlobalConfigs.

	   Filter by limit_access_to_global_configs
	*/
	LimitAccessToGlobalConfigs *bool

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the ems role config collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *EmsRoleConfigCollectionGetParams) WithDefaults() *EmsRoleConfigCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the ems role config collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *EmsRoleConfigCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := EmsRoleConfigCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the ems role config collection get params
func (o *EmsRoleConfigCollectionGetParams) WithTimeout(timeout time.Duration) *EmsRoleConfigCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the ems role config collection get params
func (o *EmsRoleConfigCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the ems role config collection get params
func (o *EmsRoleConfigCollectionGetParams) WithContext(ctx context.Context) *EmsRoleConfigCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the ems role config collection get params
func (o *EmsRoleConfigCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the ems role config collection get params
func (o *EmsRoleConfigCollectionGetParams) WithHTTPClient(client *http.Client) *EmsRoleConfigCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the ems role config collection get params
func (o *EmsRoleConfigCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAccessControlRoleName adds the accessControlRoleName to the ems role config collection get params
func (o *EmsRoleConfigCollectionGetParams) WithAccessControlRoleName(accessControlRoleName *string) *EmsRoleConfigCollectionGetParams {
	o.SetAccessControlRoleName(accessControlRoleName)
	return o
}

// SetAccessControlRoleName adds the accessControlRoleName to the ems role config collection get params
func (o *EmsRoleConfigCollectionGetParams) SetAccessControlRoleName(accessControlRoleName *string) {
	o.AccessControlRoleName = accessControlRoleName
}

// WithEventFilterName adds the eventFilterName to the ems role config collection get params
func (o *EmsRoleConfigCollectionGetParams) WithEventFilterName(eventFilterName *string) *EmsRoleConfigCollectionGetParams {
	o.SetEventFilterName(eventFilterName)
	return o
}

// SetEventFilterName adds the eventFilterName to the ems role config collection get params
func (o *EmsRoleConfigCollectionGetParams) SetEventFilterName(eventFilterName *string) {
	o.EventFilterName = eventFilterName
}

// WithFields adds the fields to the ems role config collection get params
func (o *EmsRoleConfigCollectionGetParams) WithFields(fields []string) *EmsRoleConfigCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the ems role config collection get params
func (o *EmsRoleConfigCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithLimitAccessToGlobalConfigs adds the limitAccessToGlobalConfigs to the ems role config collection get params
func (o *EmsRoleConfigCollectionGetParams) WithLimitAccessToGlobalConfigs(limitAccessToGlobalConfigs *bool) *EmsRoleConfigCollectionGetParams {
	o.SetLimitAccessToGlobalConfigs(limitAccessToGlobalConfigs)
	return o
}

// SetLimitAccessToGlobalConfigs adds the limitAccessToGlobalConfigs to the ems role config collection get params
func (o *EmsRoleConfigCollectionGetParams) SetLimitAccessToGlobalConfigs(limitAccessToGlobalConfigs *bool) {
	o.LimitAccessToGlobalConfigs = limitAccessToGlobalConfigs
}

// WithMaxRecords adds the maxRecords to the ems role config collection get params
func (o *EmsRoleConfigCollectionGetParams) WithMaxRecords(maxRecords *int64) *EmsRoleConfigCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the ems role config collection get params
func (o *EmsRoleConfigCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithOrderBy adds the orderBy to the ems role config collection get params
func (o *EmsRoleConfigCollectionGetParams) WithOrderBy(orderBy []string) *EmsRoleConfigCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the ems role config collection get params
func (o *EmsRoleConfigCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithReturnRecords adds the returnRecords to the ems role config collection get params
func (o *EmsRoleConfigCollectionGetParams) WithReturnRecords(returnRecords *bool) *EmsRoleConfigCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the ems role config collection get params
func (o *EmsRoleConfigCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the ems role config collection get params
func (o *EmsRoleConfigCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *EmsRoleConfigCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the ems role config collection get params
func (o *EmsRoleConfigCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WriteToRequest writes these params to a swagger request
func (o *EmsRoleConfigCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.AccessControlRoleName != nil {

		// query param access_control_role.name
		var qrAccessControlRoleName string

		if o.AccessControlRoleName != nil {
			qrAccessControlRoleName = *o.AccessControlRoleName
		}
		qAccessControlRoleName := qrAccessControlRoleName
		if qAccessControlRoleName != "" {

			if err := r.SetQueryParam("access_control_role.name", qAccessControlRoleName); err != nil {
				return err
			}
		}
	}

	if o.EventFilterName != nil {

		// query param event_filter.name
		var qrEventFilterName string

		if o.EventFilterName != nil {
			qrEventFilterName = *o.EventFilterName
		}
		qEventFilterName := qrEventFilterName
		if qEventFilterName != "" {

			if err := r.SetQueryParam("event_filter.name", qEventFilterName); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.LimitAccessToGlobalConfigs != nil {

		// query param limit_access_to_global_configs
		var qrLimitAccessToGlobalConfigs bool

		if o.LimitAccessToGlobalConfigs != nil {
			qrLimitAccessToGlobalConfigs = *o.LimitAccessToGlobalConfigs
		}
		qLimitAccessToGlobalConfigs := swag.FormatBool(qrLimitAccessToGlobalConfigs)
		if qLimitAccessToGlobalConfigs != "" {

			if err := r.SetQueryParam("limit_access_to_global_configs", qLimitAccessToGlobalConfigs); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamEmsRoleConfigCollectionGet binds the parameter fields
func (o *EmsRoleConfigCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamEmsRoleConfigCollectionGet binds the parameter order_by
func (o *EmsRoleConfigCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
