// Code generated by go-swagger; DO NOT EDIT.

package support

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// EmsRoleConfigDeleteCollectionReader is a Reader for the EmsRoleConfigDeleteCollection structure.
type EmsRoleConfigDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *EmsRoleConfigDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewEmsRoleConfigDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewEmsRoleConfigDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewEmsRoleConfigDeleteCollectionOK creates a EmsRoleConfigDeleteCollectionOK with default headers values
func NewEmsRoleConfigDeleteCollectionOK() *EmsRoleConfigDeleteCollectionOK {
	return &EmsRoleConfigDeleteCollectionOK{}
}

/*
EmsRoleConfigDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type EmsRoleConfigDeleteCollectionOK struct {
}

// IsSuccess returns true when this ems role config delete collection o k response has a 2xx status code
func (o *EmsRoleConfigDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this ems role config delete collection o k response has a 3xx status code
func (o *EmsRoleConfigDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this ems role config delete collection o k response has a 4xx status code
func (o *EmsRoleConfigDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this ems role config delete collection o k response has a 5xx status code
func (o *EmsRoleConfigDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this ems role config delete collection o k response a status code equal to that given
func (o *EmsRoleConfigDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the ems role config delete collection o k response
func (o *EmsRoleConfigDeleteCollectionOK) Code() int {
	return 200
}

func (o *EmsRoleConfigDeleteCollectionOK) Error() string {
	return fmt.Sprintf("[DELETE /support/ems/role-configs][%d] emsRoleConfigDeleteCollectionOK", 200)
}

func (o *EmsRoleConfigDeleteCollectionOK) String() string {
	return fmt.Sprintf("[DELETE /support/ems/role-configs][%d] emsRoleConfigDeleteCollectionOK", 200)
}

func (o *EmsRoleConfigDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewEmsRoleConfigDeleteCollectionDefault creates a EmsRoleConfigDeleteCollectionDefault with default headers values
func NewEmsRoleConfigDeleteCollectionDefault(code int) *EmsRoleConfigDeleteCollectionDefault {
	return &EmsRoleConfigDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
EmsRoleConfigDeleteCollectionDefault describes a response with status code -1, with default header values.

Error
*/
type EmsRoleConfigDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this ems role config delete collection default response has a 2xx status code
func (o *EmsRoleConfigDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this ems role config delete collection default response has a 3xx status code
func (o *EmsRoleConfigDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this ems role config delete collection default response has a 4xx status code
func (o *EmsRoleConfigDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this ems role config delete collection default response has a 5xx status code
func (o *EmsRoleConfigDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this ems role config delete collection default response a status code equal to that given
func (o *EmsRoleConfigDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the ems role config delete collection default response
func (o *EmsRoleConfigDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *EmsRoleConfigDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /support/ems/role-configs][%d] ems_role_config_delete_collection default %s", o._statusCode, payload)
}

func (o *EmsRoleConfigDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /support/ems/role-configs][%d] ems_role_config_delete_collection default %s", o._statusCode, payload)
}

func (o *EmsRoleConfigDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *EmsRoleConfigDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
EmsRoleConfigDeleteCollectionBody ems role config delete collection body
swagger:model EmsRoleConfigDeleteCollectionBody
*/
type EmsRoleConfigDeleteCollectionBody struct {

	// ems role config response inline records
	EmsRoleConfigResponseInlineRecords []*models.EmsRoleConfigResponseInlineRecordsInlineArrayItem `json:"records,omitempty"`
}

// Validate validates this ems role config delete collection body
func (o *EmsRoleConfigDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateEmsRoleConfigResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsRoleConfigDeleteCollectionBody) validateEmsRoleConfigResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.EmsRoleConfigResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.EmsRoleConfigResponseInlineRecords); i++ {
		if swag.IsZero(o.EmsRoleConfigResponseInlineRecords[i]) { // not required
			continue
		}

		if o.EmsRoleConfigResponseInlineRecords[i] != nil {
			if err := o.EmsRoleConfigResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this ems role config delete collection body based on the context it is used
func (o *EmsRoleConfigDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateEmsRoleConfigResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsRoleConfigDeleteCollectionBody) contextValidateEmsRoleConfigResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.EmsRoleConfigResponseInlineRecords); i++ {

		if o.EmsRoleConfigResponseInlineRecords[i] != nil {
			if err := o.EmsRoleConfigResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *EmsRoleConfigDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *EmsRoleConfigDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res EmsRoleConfigDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
EmsRoleConfigResponseInlineRecordsInlineArrayItem ems role config response inline records inline array item
swagger:model ems_role_config_response_inline_records_inline_array_item
*/
type EmsRoleConfigResponseInlineRecordsInlineArrayItem struct {

	// links
	Links *models.EmsRoleConfigResponseInlineRecordsInlineArrayItemInlineLinks `json:"_links,omitempty"`

	// access control role
	AccessControlRole *models.EmsRoleConfigResponseInlineRecordsInlineArrayItemInlineAccessControlRole `json:"access_control_role,omitempty"`

	// event filter
	EventFilter *models.EmsRoleConfigResponseInlineRecordsInlineArrayItemInlineEventFilter `json:"event_filter,omitempty"`

	// Indicates whether the access control has limited access to global EMS configurations.
	LimitAccessToGlobalConfigs *bool `json:"limit_access_to_global_configs,omitempty"`
}

// Validate validates this ems role config response inline records inline array item
func (o *EmsRoleConfigResponseInlineRecordsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateAccessControlRole(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateEventFilter(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsRoleConfigResponseInlineRecordsInlineArrayItem) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (o *EmsRoleConfigResponseInlineRecordsInlineArrayItem) validateAccessControlRole(formats strfmt.Registry) error {
	if swag.IsZero(o.AccessControlRole) { // not required
		return nil
	}

	if o.AccessControlRole != nil {
		if err := o.AccessControlRole.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("access_control_role")
			}
			return err
		}
	}

	return nil
}

func (o *EmsRoleConfigResponseInlineRecordsInlineArrayItem) validateEventFilter(formats strfmt.Registry) error {
	if swag.IsZero(o.EventFilter) { // not required
		return nil
	}

	if o.EventFilter != nil {
		if err := o.EventFilter.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("event_filter")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ems role config response inline records inline array item based on the context it is used
func (o *EmsRoleConfigResponseInlineRecordsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateAccessControlRole(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateEventFilter(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsRoleConfigResponseInlineRecordsInlineArrayItem) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (o *EmsRoleConfigResponseInlineRecordsInlineArrayItem) contextValidateAccessControlRole(ctx context.Context, formats strfmt.Registry) error {

	if o.AccessControlRole != nil {
		if err := o.AccessControlRole.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("access_control_role")
			}
			return err
		}
	}

	return nil
}

func (o *EmsRoleConfigResponseInlineRecordsInlineArrayItem) contextValidateEventFilter(ctx context.Context, formats strfmt.Registry) error {

	if o.EventFilter != nil {
		if err := o.EventFilter.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("event_filter")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *EmsRoleConfigResponseInlineRecordsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *EmsRoleConfigResponseInlineRecordsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res EmsRoleConfigResponseInlineRecordsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
EmsRoleConfigResponseInlineRecordsInlineArrayItemInlineLinks ems role config response inline records inline array item inline links
swagger:model ems_role_config_response_inline_records_inline_array_item_inline__links
*/
type EmsRoleConfigResponseInlineRecordsInlineArrayItemInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this ems role config response inline records inline array item inline links
func (o *EmsRoleConfigResponseInlineRecordsInlineArrayItemInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsRoleConfigResponseInlineRecordsInlineArrayItemInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ems role config response inline records inline array item inline links based on the context it is used
func (o *EmsRoleConfigResponseInlineRecordsInlineArrayItemInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsRoleConfigResponseInlineRecordsInlineArrayItemInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *EmsRoleConfigResponseInlineRecordsInlineArrayItemInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *EmsRoleConfigResponseInlineRecordsInlineArrayItemInlineLinks) UnmarshalBinary(b []byte) error {
	var res EmsRoleConfigResponseInlineRecordsInlineArrayItemInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
EmsRoleConfigResponseInlineRecordsInlineArrayItemInlineAccessControlRole Access control role that the event filter is assigned to.
swagger:model ems_role_config_response_inline_records_inline_array_item_inline_access_control_role
*/
type EmsRoleConfigResponseInlineRecordsInlineArrayItemInlineAccessControlRole struct {

	// links
	Links *models.EmsRoleConfigResponseInlineRecordsInlineArrayItemInlineAccessControlRoleInlineLinks `json:"_links,omitempty"`

	// Role name
	// Example: admin
	Name *string `json:"name,omitempty"`
}

// Validate validates this ems role config response inline records inline array item inline access control role
func (o *EmsRoleConfigResponseInlineRecordsInlineArrayItemInlineAccessControlRole) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsRoleConfigResponseInlineRecordsInlineArrayItemInlineAccessControlRole) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("access_control_role" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ems role config response inline records inline array item inline access control role based on the context it is used
func (o *EmsRoleConfigResponseInlineRecordsInlineArrayItemInlineAccessControlRole) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsRoleConfigResponseInlineRecordsInlineArrayItemInlineAccessControlRole) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("access_control_role" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *EmsRoleConfigResponseInlineRecordsInlineArrayItemInlineAccessControlRole) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *EmsRoleConfigResponseInlineRecordsInlineArrayItemInlineAccessControlRole) UnmarshalBinary(b []byte) error {
	var res EmsRoleConfigResponseInlineRecordsInlineArrayItemInlineAccessControlRole
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
EmsRoleConfigResponseInlineRecordsInlineArrayItemInlineAccessControlRoleInlineLinks ems role config response inline records inline array item inline access control role inline links
swagger:model ems_role_config_response_inline_records_inline_array_item_inline_access_control_role_inline__links
*/
type EmsRoleConfigResponseInlineRecordsInlineArrayItemInlineAccessControlRoleInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this ems role config response inline records inline array item inline access control role inline links
func (o *EmsRoleConfigResponseInlineRecordsInlineArrayItemInlineAccessControlRoleInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsRoleConfigResponseInlineRecordsInlineArrayItemInlineAccessControlRoleInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("access_control_role" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ems role config response inline records inline array item inline access control role inline links based on the context it is used
func (o *EmsRoleConfigResponseInlineRecordsInlineArrayItemInlineAccessControlRoleInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsRoleConfigResponseInlineRecordsInlineArrayItemInlineAccessControlRoleInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("access_control_role" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *EmsRoleConfigResponseInlineRecordsInlineArrayItemInlineAccessControlRoleInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *EmsRoleConfigResponseInlineRecordsInlineArrayItemInlineAccessControlRoleInlineLinks) UnmarshalBinary(b []byte) error {
	var res EmsRoleConfigResponseInlineRecordsInlineArrayItemInlineAccessControlRoleInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
EmsRoleConfigResponseInlineRecordsInlineArrayItemInlineEventFilter Event filter that is assigned to the access control role.
swagger:model ems_role_config_response_inline_records_inline_array_item_inline_event_filter
*/
type EmsRoleConfigResponseInlineRecordsInlineArrayItemInlineEventFilter struct {

	// links
	Links *models.EmsRoleConfigResponseInlineRecordsInlineArrayItemInlineEventFilterInlineLinks `json:"_links,omitempty"`

	// name
	// Example: important-events
	Name *string `json:"name,omitempty"`
}

// Validate validates this ems role config response inline records inline array item inline event filter
func (o *EmsRoleConfigResponseInlineRecordsInlineArrayItemInlineEventFilter) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsRoleConfigResponseInlineRecordsInlineArrayItemInlineEventFilter) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("event_filter" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ems role config response inline records inline array item inline event filter based on the context it is used
func (o *EmsRoleConfigResponseInlineRecordsInlineArrayItemInlineEventFilter) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsRoleConfigResponseInlineRecordsInlineArrayItemInlineEventFilter) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("event_filter" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *EmsRoleConfigResponseInlineRecordsInlineArrayItemInlineEventFilter) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *EmsRoleConfigResponseInlineRecordsInlineArrayItemInlineEventFilter) UnmarshalBinary(b []byte) error {
	var res EmsRoleConfigResponseInlineRecordsInlineArrayItemInlineEventFilter
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
EmsRoleConfigResponseInlineRecordsInlineArrayItemInlineEventFilterInlineLinks ems role config response inline records inline array item inline event filter inline links
swagger:model ems_role_config_response_inline_records_inline_array_item_inline_event_filter_inline__links
*/
type EmsRoleConfigResponseInlineRecordsInlineArrayItemInlineEventFilterInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this ems role config response inline records inline array item inline event filter inline links
func (o *EmsRoleConfigResponseInlineRecordsInlineArrayItemInlineEventFilterInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsRoleConfigResponseInlineRecordsInlineArrayItemInlineEventFilterInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("event_filter" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ems role config response inline records inline array item inline event filter inline links based on the context it is used
func (o *EmsRoleConfigResponseInlineRecordsInlineArrayItemInlineEventFilterInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsRoleConfigResponseInlineRecordsInlineArrayItemInlineEventFilterInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("event_filter" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *EmsRoleConfigResponseInlineRecordsInlineArrayItemInlineEventFilterInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *EmsRoleConfigResponseInlineRecordsInlineArrayItemInlineEventFilterInlineLinks) UnmarshalBinary(b []byte) error {
	var res EmsRoleConfigResponseInlineRecordsInlineArrayItemInlineEventFilterInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
