// Code generated by go-swagger; DO NOT EDIT.

package support

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewEmsRoleConfigGetParams creates a new EmsRoleConfigGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewEmsRoleConfigGetParams() *EmsRoleConfigGetParams {
	return &EmsRoleConfigGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewEmsRoleConfigGetParamsWithTimeout creates a new EmsRoleConfigGetParams object
// with the ability to set a timeout on a request.
func NewEmsRoleConfigGetParamsWithTimeout(timeout time.Duration) *EmsRoleConfigGetParams {
	return &EmsRoleConfigGetParams{
		timeout: timeout,
	}
}

// NewEmsRoleConfigGetParamsWithContext creates a new EmsRoleConfigGetParams object
// with the ability to set a context for a request.
func NewEmsRoleConfigGetParamsWithContext(ctx context.Context) *EmsRoleConfigGetParams {
	return &EmsRoleConfigGetParams{
		Context: ctx,
	}
}

// NewEmsRoleConfigGetParamsWithHTTPClient creates a new EmsRoleConfigGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewEmsRoleConfigGetParamsWithHTTPClient(client *http.Client) *EmsRoleConfigGetParams {
	return &EmsRoleConfigGetParams{
		HTTPClient: client,
	}
}

/*
EmsRoleConfigGetParams contains all the parameters to send to the API endpoint

	for the ems role config get operation.

	Typically these are written to a http.Request.
*/
type EmsRoleConfigGetParams struct {

	/* AccessControlRoleName.

	   Access control role name
	*/
	AccessControlRoleName string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the ems role config get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *EmsRoleConfigGetParams) WithDefaults() *EmsRoleConfigGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the ems role config get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *EmsRoleConfigGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the ems role config get params
func (o *EmsRoleConfigGetParams) WithTimeout(timeout time.Duration) *EmsRoleConfigGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the ems role config get params
func (o *EmsRoleConfigGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the ems role config get params
func (o *EmsRoleConfigGetParams) WithContext(ctx context.Context) *EmsRoleConfigGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the ems role config get params
func (o *EmsRoleConfigGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the ems role config get params
func (o *EmsRoleConfigGetParams) WithHTTPClient(client *http.Client) *EmsRoleConfigGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the ems role config get params
func (o *EmsRoleConfigGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAccessControlRoleName adds the accessControlRoleName to the ems role config get params
func (o *EmsRoleConfigGetParams) WithAccessControlRoleName(accessControlRoleName string) *EmsRoleConfigGetParams {
	o.SetAccessControlRoleName(accessControlRoleName)
	return o
}

// SetAccessControlRoleName adds the accessControlRoleName to the ems role config get params
func (o *EmsRoleConfigGetParams) SetAccessControlRoleName(accessControlRoleName string) {
	o.AccessControlRoleName = accessControlRoleName
}

// WithFields adds the fields to the ems role config get params
func (o *EmsRoleConfigGetParams) WithFields(fields []string) *EmsRoleConfigGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the ems role config get params
func (o *EmsRoleConfigGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WriteToRequest writes these params to a swagger request
func (o *EmsRoleConfigGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param access_control_role.name
	if err := r.SetPathParam("access_control_role.name", o.AccessControlRoleName); err != nil {
		return err
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamEmsRoleConfigGet binds the parameter fields
func (o *EmsRoleConfigGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
