// Code generated by go-swagger; DO NOT EDIT.

package support

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// EmsRoleConfigModifyCollectionReader is a Reader for the EmsRoleConfigModifyCollection structure.
type EmsRoleConfigModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *EmsRoleConfigModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewEmsRoleConfigModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewEmsRoleConfigModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewEmsRoleConfigModifyCollectionOK creates a EmsRoleConfigModifyCollectionOK with default headers values
func NewEmsRoleConfigModifyCollectionOK() *EmsRoleConfigModifyCollectionOK {
	return &EmsRoleConfigModifyCollectionOK{}
}

/*
EmsRoleConfigModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type EmsRoleConfigModifyCollectionOK struct {
}

// IsSuccess returns true when this ems role config modify collection o k response has a 2xx status code
func (o *EmsRoleConfigModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this ems role config modify collection o k response has a 3xx status code
func (o *EmsRoleConfigModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this ems role config modify collection o k response has a 4xx status code
func (o *EmsRoleConfigModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this ems role config modify collection o k response has a 5xx status code
func (o *EmsRoleConfigModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this ems role config modify collection o k response a status code equal to that given
func (o *EmsRoleConfigModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the ems role config modify collection o k response
func (o *EmsRoleConfigModifyCollectionOK) Code() int {
	return 200
}

func (o *EmsRoleConfigModifyCollectionOK) Error() string {
	return fmt.Sprintf("[PATCH /support/ems/role-configs][%d] emsRoleConfigModifyCollectionOK", 200)
}

func (o *EmsRoleConfigModifyCollectionOK) String() string {
	return fmt.Sprintf("[PATCH /support/ems/role-configs][%d] emsRoleConfigModifyCollectionOK", 200)
}

func (o *EmsRoleConfigModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewEmsRoleConfigModifyCollectionDefault creates a EmsRoleConfigModifyCollectionDefault with default headers values
func NewEmsRoleConfigModifyCollectionDefault(code int) *EmsRoleConfigModifyCollectionDefault {
	return &EmsRoleConfigModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	EmsRoleConfigModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 983197 | The event filter provided is the same as the currently assigned filter. |
| 983198 | The event filter provided does not exist. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type EmsRoleConfigModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this ems role config modify collection default response has a 2xx status code
func (o *EmsRoleConfigModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this ems role config modify collection default response has a 3xx status code
func (o *EmsRoleConfigModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this ems role config modify collection default response has a 4xx status code
func (o *EmsRoleConfigModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this ems role config modify collection default response has a 5xx status code
func (o *EmsRoleConfigModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this ems role config modify collection default response a status code equal to that given
func (o *EmsRoleConfigModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the ems role config modify collection default response
func (o *EmsRoleConfigModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *EmsRoleConfigModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /support/ems/role-configs][%d] ems_role_config_modify_collection default %s", o._statusCode, payload)
}

func (o *EmsRoleConfigModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /support/ems/role-configs][%d] ems_role_config_modify_collection default %s", o._statusCode, payload)
}

func (o *EmsRoleConfigModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *EmsRoleConfigModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
EmsRoleConfigModifyCollectionBody ems role config modify collection body
swagger:model EmsRoleConfigModifyCollectionBody
*/
type EmsRoleConfigModifyCollectionBody struct {

	// links
	Links *models.EmsRoleConfigResponseInlineRecordsInlineArrayItemInlineLinks `json:"_links,omitempty"`

	// access control role
	AccessControlRole *models.EmsRoleConfigResponseInlineRecordsInlineArrayItemInlineAccessControlRole `json:"access_control_role,omitempty"`

	// ems role config response inline records
	EmsRoleConfigResponseInlineRecords []*models.EmsRoleConfigResponseInlineRecordsInlineArrayItem `json:"records,omitempty"`

	// event filter
	EventFilter *models.EmsRoleConfigResponseInlineRecordsInlineArrayItemInlineEventFilter `json:"event_filter,omitempty"`

	// Indicates whether the access control has limited access to global EMS configurations.
	LimitAccessToGlobalConfigs *bool `json:"limit_access_to_global_configs,omitempty"`
}

// Validate validates this ems role config modify collection body
func (o *EmsRoleConfigModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateAccessControlRole(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateEmsRoleConfigResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateEventFilter(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsRoleConfigModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *EmsRoleConfigModifyCollectionBody) validateAccessControlRole(formats strfmt.Registry) error {
	if swag.IsZero(o.AccessControlRole) { // not required
		return nil
	}

	if o.AccessControlRole != nil {
		if err := o.AccessControlRole.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "access_control_role")
			}
			return err
		}
	}

	return nil
}

func (o *EmsRoleConfigModifyCollectionBody) validateEmsRoleConfigResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.EmsRoleConfigResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.EmsRoleConfigResponseInlineRecords); i++ {
		if swag.IsZero(o.EmsRoleConfigResponseInlineRecords[i]) { // not required
			continue
		}

		if o.EmsRoleConfigResponseInlineRecords[i] != nil {
			if err := o.EmsRoleConfigResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *EmsRoleConfigModifyCollectionBody) validateEventFilter(formats strfmt.Registry) error {
	if swag.IsZero(o.EventFilter) { // not required
		return nil
	}

	if o.EventFilter != nil {
		if err := o.EventFilter.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "event_filter")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ems role config modify collection body based on the context it is used
func (o *EmsRoleConfigModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateAccessControlRole(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateEmsRoleConfigResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateEventFilter(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *EmsRoleConfigModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *EmsRoleConfigModifyCollectionBody) contextValidateAccessControlRole(ctx context.Context, formats strfmt.Registry) error {

	if o.AccessControlRole != nil {
		if err := o.AccessControlRole.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "access_control_role")
			}
			return err
		}
	}

	return nil
}

func (o *EmsRoleConfigModifyCollectionBody) contextValidateEmsRoleConfigResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.EmsRoleConfigResponseInlineRecords); i++ {

		if o.EmsRoleConfigResponseInlineRecords[i] != nil {
			if err := o.EmsRoleConfigResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *EmsRoleConfigModifyCollectionBody) contextValidateEventFilter(ctx context.Context, formats strfmt.Registry) error {

	if o.EventFilter != nil {
		if err := o.EventFilter.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "event_filter")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *EmsRoleConfigModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *EmsRoleConfigModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res EmsRoleConfigModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
