// Code generated by go-swagger; DO NOT EDIT.

package support

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// EmsRoleConfigModifyReader is a Reader for the EmsRoleConfigModify structure.
type EmsRoleConfigModifyReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *EmsRoleConfigModifyReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewEmsRoleConfigModifyOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewEmsRoleConfigModifyDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewEmsRoleConfigModifyOK creates a EmsRoleConfigModifyOK with default headers values
func NewEmsRoleConfigModifyOK() *EmsRoleConfigModifyOK {
	return &EmsRoleConfigModifyOK{}
}

/*
EmsRoleConfigModifyOK describes a response with status code 200, with default header values.

OK
*/
type EmsRoleConfigModifyOK struct {
}

// IsSuccess returns true when this ems role config modify o k response has a 2xx status code
func (o *EmsRoleConfigModifyOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this ems role config modify o k response has a 3xx status code
func (o *EmsRoleConfigModifyOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this ems role config modify o k response has a 4xx status code
func (o *EmsRoleConfigModifyOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this ems role config modify o k response has a 5xx status code
func (o *EmsRoleConfigModifyOK) IsServerError() bool {
	return false
}

// IsCode returns true when this ems role config modify o k response a status code equal to that given
func (o *EmsRoleConfigModifyOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the ems role config modify o k response
func (o *EmsRoleConfigModifyOK) Code() int {
	return 200
}

func (o *EmsRoleConfigModifyOK) Error() string {
	return fmt.Sprintf("[PATCH /support/ems/role-configs/{access_control_role.name}][%d] emsRoleConfigModifyOK", 200)
}

func (o *EmsRoleConfigModifyOK) String() string {
	return fmt.Sprintf("[PATCH /support/ems/role-configs/{access_control_role.name}][%d] emsRoleConfigModifyOK", 200)
}

func (o *EmsRoleConfigModifyOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewEmsRoleConfigModifyDefault creates a EmsRoleConfigModifyDefault with default headers values
func NewEmsRoleConfigModifyDefault(code int) *EmsRoleConfigModifyDefault {
	return &EmsRoleConfigModifyDefault{
		_statusCode: code,
	}
}

/*
	EmsRoleConfigModifyDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 983197 | The event filter provided is the same as the currently assigned filter. |
| 983198 | The event filter provided does not exist. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type EmsRoleConfigModifyDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this ems role config modify default response has a 2xx status code
func (o *EmsRoleConfigModifyDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this ems role config modify default response has a 3xx status code
func (o *EmsRoleConfigModifyDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this ems role config modify default response has a 4xx status code
func (o *EmsRoleConfigModifyDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this ems role config modify default response has a 5xx status code
func (o *EmsRoleConfigModifyDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this ems role config modify default response a status code equal to that given
func (o *EmsRoleConfigModifyDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the ems role config modify default response
func (o *EmsRoleConfigModifyDefault) Code() int {
	return o._statusCode
}

func (o *EmsRoleConfigModifyDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /support/ems/role-configs/{access_control_role.name}][%d] ems_role_config_modify default %s", o._statusCode, payload)
}

func (o *EmsRoleConfigModifyDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /support/ems/role-configs/{access_control_role.name}][%d] ems_role_config_modify default %s", o._statusCode, payload)
}

func (o *EmsRoleConfigModifyDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *EmsRoleConfigModifyDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
