// Code generated by go-swagger; DO NOT EDIT.

package support

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SnmpGetReader is a Reader for the SnmpGet structure.
type SnmpGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SnmpGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSnmpGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSnmpGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSnmpGetOK creates a SnmpGetOK with default headers values
func NewSnmpGetOK() *SnmpGetOK {
	return &SnmpGetOK{}
}

/*
SnmpGetOK describes a response with status code 200, with default header values.

OK
*/
type SnmpGetOK struct {
	Payload *models.Snmp
}

// IsSuccess returns true when this snmp get o k response has a 2xx status code
func (o *SnmpGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this snmp get o k response has a 3xx status code
func (o *SnmpGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this snmp get o k response has a 4xx status code
func (o *SnmpGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this snmp get o k response has a 5xx status code
func (o *SnmpGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this snmp get o k response a status code equal to that given
func (o *SnmpGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the snmp get o k response
func (o *SnmpGetOK) Code() int {
	return 200
}

func (o *SnmpGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /support/snmp][%d] snmpGetOK %s", 200, payload)
}

func (o *SnmpGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /support/snmp][%d] snmpGetOK %s", 200, payload)
}

func (o *SnmpGetOK) GetPayload() *models.Snmp {
	return o.Payload
}

func (o *SnmpGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Snmp)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSnmpGetDefault creates a SnmpGetDefault with default headers values
func NewSnmpGetDefault(code int) *SnmpGetDefault {
	return &SnmpGetDefault{
		_statusCode: code,
	}
}

/*
SnmpGetDefault describes a response with status code -1, with default header values.

Error
*/
type SnmpGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this snmp get default response has a 2xx status code
func (o *SnmpGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this snmp get default response has a 3xx status code
func (o *SnmpGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this snmp get default response has a 4xx status code
func (o *SnmpGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this snmp get default response has a 5xx status code
func (o *SnmpGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this snmp get default response a status code equal to that given
func (o *SnmpGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the snmp get default response
func (o *SnmpGetDefault) Code() int {
	return o._statusCode
}

func (o *SnmpGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /support/snmp][%d] snmp_get default %s", o._statusCode, payload)
}

func (o *SnmpGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /support/snmp][%d] snmp_get default %s", o._statusCode, payload)
}

func (o *SnmpGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SnmpGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
