// Code generated by go-swagger; DO NOT EDIT.

package support

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SnmpModifyReader is a Reader for the SnmpModify structure.
type SnmpModifyReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SnmpModifyReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSnmpModifyOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSnmpModifyDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSnmpModifyOK creates a SnmpModifyOK with default headers values
func NewSnmpModifyOK() *SnmpModifyOK {
	return &SnmpModifyOK{}
}

/*
SnmpModifyOK describes a response with status code 200, with default header values.

OK
*/
type SnmpModifyOK struct {
}

// IsSuccess returns true when this snmp modify o k response has a 2xx status code
func (o *SnmpModifyOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this snmp modify o k response has a 3xx status code
func (o *SnmpModifyOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this snmp modify o k response has a 4xx status code
func (o *SnmpModifyOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this snmp modify o k response has a 5xx status code
func (o *SnmpModifyOK) IsServerError() bool {
	return false
}

// IsCode returns true when this snmp modify o k response a status code equal to that given
func (o *SnmpModifyOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the snmp modify o k response
func (o *SnmpModifyOK) Code() int {
	return 200
}

func (o *SnmpModifyOK) Error() string {
	return fmt.Sprintf("[PATCH /support/snmp][%d] snmpModifyOK", 200)
}

func (o *SnmpModifyOK) String() string {
	return fmt.Sprintf("[PATCH /support/snmp][%d] snmpModifyOK", 200)
}

func (o *SnmpModifyOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewSnmpModifyDefault creates a SnmpModifyDefault with default headers values
func NewSnmpModifyDefault(code int) *SnmpModifyDefault {
	return &SnmpModifyDefault{
		_statusCode: code,
	}
}

/*
	SnmpModifyDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 1179738 | Cluster identification not available for modification since a cluster has not been created. |
| 1179739 | Cluster identification modification is not available in maintenance mode or other boot modes. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type SnmpModifyDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this snmp modify default response has a 2xx status code
func (o *SnmpModifyDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this snmp modify default response has a 3xx status code
func (o *SnmpModifyDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this snmp modify default response has a 4xx status code
func (o *SnmpModifyDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this snmp modify default response has a 5xx status code
func (o *SnmpModifyDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this snmp modify default response a status code equal to that given
func (o *SnmpModifyDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the snmp modify default response
func (o *SnmpModifyDefault) Code() int {
	return o._statusCode
}

func (o *SnmpModifyDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /support/snmp][%d] snmp_modify default %s", o._statusCode, payload)
}

func (o *SnmpModifyDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /support/snmp][%d] snmp_modify default %s", o._statusCode, payload)
}

func (o *SnmpModifyDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SnmpModifyDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
