// Code generated by go-swagger; DO NOT EDIT.

package support

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewSnmpTraphostsCreateParams creates a new SnmpTraphostsCreateParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSnmpTraphostsCreateParams() *SnmpTraphostsCreateParams {
	return &SnmpTraphostsCreateParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSnmpTraphostsCreateParamsWithTimeout creates a new SnmpTraphostsCreateParams object
// with the ability to set a timeout on a request.
func NewSnmpTraphostsCreateParamsWithTimeout(timeout time.Duration) *SnmpTraphostsCreateParams {
	return &SnmpTraphostsCreateParams{
		timeout: timeout,
	}
}

// NewSnmpTraphostsCreateParamsWithContext creates a new SnmpTraphostsCreateParams object
// with the ability to set a context for a request.
func NewSnmpTraphostsCreateParamsWithContext(ctx context.Context) *SnmpTraphostsCreateParams {
	return &SnmpTraphostsCreateParams{
		Context: ctx,
	}
}

// NewSnmpTraphostsCreateParamsWithHTTPClient creates a new SnmpTraphostsCreateParams object
// with the ability to set a custom HTTPClient for a request.
func NewSnmpTraphostsCreateParamsWithHTTPClient(client *http.Client) *SnmpTraphostsCreateParams {
	return &SnmpTraphostsCreateParams{
		HTTPClient: client,
	}
}

/*
SnmpTraphostsCreateParams contains all the parameters to send to the API endpoint

	for the snmp traphosts create operation.

	Typically these are written to a http.Request.
*/
type SnmpTraphostsCreateParams struct {

	/* Info.

	   Info specification
	*/
	Info *models.SnmpTraphost

	/* ReturnRecords.

	   The default is false.  If set to true, the records are returned.
	*/
	ReturnRecords *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the snmp traphosts create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SnmpTraphostsCreateParams) WithDefaults() *SnmpTraphostsCreateParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the snmp traphosts create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SnmpTraphostsCreateParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(false)
	)

	val := SnmpTraphostsCreateParams{
		ReturnRecords: &returnRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the snmp traphosts create params
func (o *SnmpTraphostsCreateParams) WithTimeout(timeout time.Duration) *SnmpTraphostsCreateParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the snmp traphosts create params
func (o *SnmpTraphostsCreateParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the snmp traphosts create params
func (o *SnmpTraphostsCreateParams) WithContext(ctx context.Context) *SnmpTraphostsCreateParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the snmp traphosts create params
func (o *SnmpTraphostsCreateParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the snmp traphosts create params
func (o *SnmpTraphostsCreateParams) WithHTTPClient(client *http.Client) *SnmpTraphostsCreateParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the snmp traphosts create params
func (o *SnmpTraphostsCreateParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithInfo adds the info to the snmp traphosts create params
func (o *SnmpTraphostsCreateParams) WithInfo(info *models.SnmpTraphost) *SnmpTraphostsCreateParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the snmp traphosts create params
func (o *SnmpTraphostsCreateParams) SetInfo(info *models.SnmpTraphost) {
	o.Info = info
}

// WithReturnRecords adds the returnRecords to the snmp traphosts create params
func (o *SnmpTraphostsCreateParams) WithReturnRecords(returnRecords *bool) *SnmpTraphostsCreateParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the snmp traphosts create params
func (o *SnmpTraphostsCreateParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WriteToRequest writes these params to a swagger request
func (o *SnmpTraphostsCreateParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
