// Code generated by go-swagger; DO NOT EDIT.

package support

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewSnmpTraphostsDeleteCollectionParams creates a new SnmpTraphostsDeleteCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSnmpTraphostsDeleteCollectionParams() *SnmpTraphostsDeleteCollectionParams {
	return &SnmpTraphostsDeleteCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSnmpTraphostsDeleteCollectionParamsWithTimeout creates a new SnmpTraphostsDeleteCollectionParams object
// with the ability to set a timeout on a request.
func NewSnmpTraphostsDeleteCollectionParamsWithTimeout(timeout time.Duration) *SnmpTraphostsDeleteCollectionParams {
	return &SnmpTraphostsDeleteCollectionParams{
		timeout: timeout,
	}
}

// NewSnmpTraphostsDeleteCollectionParamsWithContext creates a new SnmpTraphostsDeleteCollectionParams object
// with the ability to set a context for a request.
func NewSnmpTraphostsDeleteCollectionParamsWithContext(ctx context.Context) *SnmpTraphostsDeleteCollectionParams {
	return &SnmpTraphostsDeleteCollectionParams{
		Context: ctx,
	}
}

// NewSnmpTraphostsDeleteCollectionParamsWithHTTPClient creates a new SnmpTraphostsDeleteCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewSnmpTraphostsDeleteCollectionParamsWithHTTPClient(client *http.Client) *SnmpTraphostsDeleteCollectionParams {
	return &SnmpTraphostsDeleteCollectionParams{
		HTTPClient: client,
	}
}

/*
SnmpTraphostsDeleteCollectionParams contains all the parameters to send to the API endpoint

	for the snmp traphosts delete collection operation.

	Typically these are written to a http.Request.
*/
type SnmpTraphostsDeleteCollectionParams struct {

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* Host.

	   Filter by host
	*/
	Host *string

	/* Info.

	   Info specification
	*/
	Info SnmpTraphostsDeleteCollectionBody

	/* IPAddress.

	   Filter by ip_address
	*/
	IPAddress *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* UserName.

	   Filter by user.name
	*/
	UserName *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the snmp traphosts delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SnmpTraphostsDeleteCollectionParams) WithDefaults() *SnmpTraphostsDeleteCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the snmp traphosts delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SnmpTraphostsDeleteCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := SnmpTraphostsDeleteCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the snmp traphosts delete collection params
func (o *SnmpTraphostsDeleteCollectionParams) WithTimeout(timeout time.Duration) *SnmpTraphostsDeleteCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the snmp traphosts delete collection params
func (o *SnmpTraphostsDeleteCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the snmp traphosts delete collection params
func (o *SnmpTraphostsDeleteCollectionParams) WithContext(ctx context.Context) *SnmpTraphostsDeleteCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the snmp traphosts delete collection params
func (o *SnmpTraphostsDeleteCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the snmp traphosts delete collection params
func (o *SnmpTraphostsDeleteCollectionParams) WithHTTPClient(client *http.Client) *SnmpTraphostsDeleteCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the snmp traphosts delete collection params
func (o *SnmpTraphostsDeleteCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithContinueOnFailure adds the continueOnFailure to the snmp traphosts delete collection params
func (o *SnmpTraphostsDeleteCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *SnmpTraphostsDeleteCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the snmp traphosts delete collection params
func (o *SnmpTraphostsDeleteCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithHost adds the host to the snmp traphosts delete collection params
func (o *SnmpTraphostsDeleteCollectionParams) WithHost(host *string) *SnmpTraphostsDeleteCollectionParams {
	o.SetHost(host)
	return o
}

// SetHost adds the host to the snmp traphosts delete collection params
func (o *SnmpTraphostsDeleteCollectionParams) SetHost(host *string) {
	o.Host = host
}

// WithInfo adds the info to the snmp traphosts delete collection params
func (o *SnmpTraphostsDeleteCollectionParams) WithInfo(info SnmpTraphostsDeleteCollectionBody) *SnmpTraphostsDeleteCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the snmp traphosts delete collection params
func (o *SnmpTraphostsDeleteCollectionParams) SetInfo(info SnmpTraphostsDeleteCollectionBody) {
	o.Info = info
}

// WithIPAddress adds the iPAddress to the snmp traphosts delete collection params
func (o *SnmpTraphostsDeleteCollectionParams) WithIPAddress(iPAddress *string) *SnmpTraphostsDeleteCollectionParams {
	o.SetIPAddress(iPAddress)
	return o
}

// SetIPAddress adds the ipAddress to the snmp traphosts delete collection params
func (o *SnmpTraphostsDeleteCollectionParams) SetIPAddress(iPAddress *string) {
	o.IPAddress = iPAddress
}

// WithReturnRecords adds the returnRecords to the snmp traphosts delete collection params
func (o *SnmpTraphostsDeleteCollectionParams) WithReturnRecords(returnRecords *bool) *SnmpTraphostsDeleteCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the snmp traphosts delete collection params
func (o *SnmpTraphostsDeleteCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the snmp traphosts delete collection params
func (o *SnmpTraphostsDeleteCollectionParams) WithReturnTimeout(returnTimeout *int64) *SnmpTraphostsDeleteCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the snmp traphosts delete collection params
func (o *SnmpTraphostsDeleteCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSerialRecords adds the serialRecords to the snmp traphosts delete collection params
func (o *SnmpTraphostsDeleteCollectionParams) WithSerialRecords(serialRecords *bool) *SnmpTraphostsDeleteCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the snmp traphosts delete collection params
func (o *SnmpTraphostsDeleteCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithUserName adds the userName to the snmp traphosts delete collection params
func (o *SnmpTraphostsDeleteCollectionParams) WithUserName(userName *string) *SnmpTraphostsDeleteCollectionParams {
	o.SetUserName(userName)
	return o
}

// SetUserName adds the userName to the snmp traphosts delete collection params
func (o *SnmpTraphostsDeleteCollectionParams) SetUserName(userName *string) {
	o.UserName = userName
}

// WriteToRequest writes these params to a swagger request
func (o *SnmpTraphostsDeleteCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}

	if o.Host != nil {

		// query param host
		var qrHost string

		if o.Host != nil {
			qrHost = *o.Host
		}
		qHost := qrHost
		if qHost != "" {

			if err := r.SetQueryParam("host", qHost); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.IPAddress != nil {

		// query param ip_address
		var qrIPAddress string

		if o.IPAddress != nil {
			qrIPAddress = *o.IPAddress
		}
		qIPAddress := qrIPAddress
		if qIPAddress != "" {

			if err := r.SetQueryParam("ip_address", qIPAddress); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.UserName != nil {

		// query param user.name
		var qrUserName string

		if o.UserName != nil {
			qrUserName = *o.UserName
		}
		qUserName := qrUserName
		if qUserName != "" {

			if err := r.SetQueryParam("user.name", qUserName); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
