// Code generated by go-swagger; DO NOT EDIT.

package support

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SnmpTraphostsDeleteCollectionReader is a Reader for the SnmpTraphostsDeleteCollection structure.
type SnmpTraphostsDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SnmpTraphostsDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSnmpTraphostsDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSnmpTraphostsDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSnmpTraphostsDeleteCollectionOK creates a SnmpTraphostsDeleteCollectionOK with default headers values
func NewSnmpTraphostsDeleteCollectionOK() *SnmpTraphostsDeleteCollectionOK {
	return &SnmpTraphostsDeleteCollectionOK{}
}

/*
SnmpTraphostsDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type SnmpTraphostsDeleteCollectionOK struct {
}

// IsSuccess returns true when this snmp traphosts delete collection o k response has a 2xx status code
func (o *SnmpTraphostsDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this snmp traphosts delete collection o k response has a 3xx status code
func (o *SnmpTraphostsDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this snmp traphosts delete collection o k response has a 4xx status code
func (o *SnmpTraphostsDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this snmp traphosts delete collection o k response has a 5xx status code
func (o *SnmpTraphostsDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this snmp traphosts delete collection o k response a status code equal to that given
func (o *SnmpTraphostsDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the snmp traphosts delete collection o k response
func (o *SnmpTraphostsDeleteCollectionOK) Code() int {
	return 200
}

func (o *SnmpTraphostsDeleteCollectionOK) Error() string {
	return fmt.Sprintf("[DELETE /support/snmp/traphosts][%d] snmpTraphostsDeleteCollectionOK", 200)
}

func (o *SnmpTraphostsDeleteCollectionOK) String() string {
	return fmt.Sprintf("[DELETE /support/snmp/traphosts][%d] snmpTraphostsDeleteCollectionOK", 200)
}

func (o *SnmpTraphostsDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewSnmpTraphostsDeleteCollectionDefault creates a SnmpTraphostsDeleteCollectionDefault with default headers values
func NewSnmpTraphostsDeleteCollectionDefault(code int) *SnmpTraphostsDeleteCollectionDefault {
	return &SnmpTraphostsDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
	SnmpTraphostsDeleteCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 8847365 | Unknown host. |
| 9043970 | Traphost entry does not exist. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type SnmpTraphostsDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this snmp traphosts delete collection default response has a 2xx status code
func (o *SnmpTraphostsDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this snmp traphosts delete collection default response has a 3xx status code
func (o *SnmpTraphostsDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this snmp traphosts delete collection default response has a 4xx status code
func (o *SnmpTraphostsDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this snmp traphosts delete collection default response has a 5xx status code
func (o *SnmpTraphostsDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this snmp traphosts delete collection default response a status code equal to that given
func (o *SnmpTraphostsDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the snmp traphosts delete collection default response
func (o *SnmpTraphostsDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *SnmpTraphostsDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /support/snmp/traphosts][%d] snmp_traphosts_delete_collection default %s", o._statusCode, payload)
}

func (o *SnmpTraphostsDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /support/snmp/traphosts][%d] snmp_traphosts_delete_collection default %s", o._statusCode, payload)
}

func (o *SnmpTraphostsDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SnmpTraphostsDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
SnmpTraphostsDeleteCollectionBody List of SNMP traphosts, along with their corresponding SNMP users, configured in ONTAP. This includes SNMPv1/SNMPv2 traphosts as well as SNMPv3 traphosts.
swagger:model SnmpTraphostsDeleteCollectionBody
*/
type SnmpTraphostsDeleteCollectionBody struct {

	// snmp traphost response inline records
	SnmpTraphostResponseInlineRecords []*models.SnmpTraphost `json:"records,omitempty"`
}

// Validate validates this snmp traphosts delete collection body
func (o *SnmpTraphostsDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSnmpTraphostResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SnmpTraphostsDeleteCollectionBody) validateSnmpTraphostResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.SnmpTraphostResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.SnmpTraphostResponseInlineRecords); i++ {
		if swag.IsZero(o.SnmpTraphostResponseInlineRecords[i]) { // not required
			continue
		}

		if o.SnmpTraphostResponseInlineRecords[i] != nil {
			if err := o.SnmpTraphostResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this snmp traphosts delete collection body based on the context it is used
func (o *SnmpTraphostsDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSnmpTraphostResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SnmpTraphostsDeleteCollectionBody) contextValidateSnmpTraphostResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.SnmpTraphostResponseInlineRecords); i++ {

		if o.SnmpTraphostResponseInlineRecords[i] != nil {
			if err := o.SnmpTraphostResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *SnmpTraphostsDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SnmpTraphostsDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res SnmpTraphostsDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
