// Code generated by go-swagger; DO NOT EDIT.

package support

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewSnmpTraphostsDeleteParams creates a new SnmpTraphostsDeleteParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSnmpTraphostsDeleteParams() *SnmpTraphostsDeleteParams {
	return &SnmpTraphostsDeleteParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSnmpTraphostsDeleteParamsWithTimeout creates a new SnmpTraphostsDeleteParams object
// with the ability to set a timeout on a request.
func NewSnmpTraphostsDeleteParamsWithTimeout(timeout time.Duration) *SnmpTraphostsDeleteParams {
	return &SnmpTraphostsDeleteParams{
		timeout: timeout,
	}
}

// NewSnmpTraphostsDeleteParamsWithContext creates a new SnmpTraphostsDeleteParams object
// with the ability to set a context for a request.
func NewSnmpTraphostsDeleteParamsWithContext(ctx context.Context) *SnmpTraphostsDeleteParams {
	return &SnmpTraphostsDeleteParams{
		Context: ctx,
	}
}

// NewSnmpTraphostsDeleteParamsWithHTTPClient creates a new SnmpTraphostsDeleteParams object
// with the ability to set a custom HTTPClient for a request.
func NewSnmpTraphostsDeleteParamsWithHTTPClient(client *http.Client) *SnmpTraphostsDeleteParams {
	return &SnmpTraphostsDeleteParams{
		HTTPClient: client,
	}
}

/*
SnmpTraphostsDeleteParams contains all the parameters to send to the API endpoint

	for the snmp traphosts delete operation.

	Typically these are written to a http.Request.
*/
type SnmpTraphostsDeleteParams struct {

	/* Host.

	   Fully Qualified Domain Name (FQDN), IPv4 address or IPv6 address of SNMP traphost.
	*/
	Host string

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning. When doing a POST, PATCH, or DELETE operation on a single record, the default is 0 seconds.  This means that if an asynchronous operation is started, the server immediately returns HTTP code 202 (Accepted) along with a link to the job.  If a non-zero value is specified for POST, PATCH, or DELETE operations, ONTAP waits that length of time to see if the job completes so it can return something other than 202.
	*/
	ReturnTimeout *int64

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the snmp traphosts delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SnmpTraphostsDeleteParams) WithDefaults() *SnmpTraphostsDeleteParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the snmp traphosts delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SnmpTraphostsDeleteParams) SetDefaults() {
	var (
		returnTimeoutDefault = int64(0)
	)

	val := SnmpTraphostsDeleteParams{
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the snmp traphosts delete params
func (o *SnmpTraphostsDeleteParams) WithTimeout(timeout time.Duration) *SnmpTraphostsDeleteParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the snmp traphosts delete params
func (o *SnmpTraphostsDeleteParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the snmp traphosts delete params
func (o *SnmpTraphostsDeleteParams) WithContext(ctx context.Context) *SnmpTraphostsDeleteParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the snmp traphosts delete params
func (o *SnmpTraphostsDeleteParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the snmp traphosts delete params
func (o *SnmpTraphostsDeleteParams) WithHTTPClient(client *http.Client) *SnmpTraphostsDeleteParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the snmp traphosts delete params
func (o *SnmpTraphostsDeleteParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithHost adds the host to the snmp traphosts delete params
func (o *SnmpTraphostsDeleteParams) WithHost(host string) *SnmpTraphostsDeleteParams {
	o.SetHost(host)
	return o
}

// SetHost adds the host to the snmp traphosts delete params
func (o *SnmpTraphostsDeleteParams) SetHost(host string) {
	o.Host = host
}

// WithReturnTimeout adds the returnTimeout to the snmp traphosts delete params
func (o *SnmpTraphostsDeleteParams) WithReturnTimeout(returnTimeout *int64) *SnmpTraphostsDeleteParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the snmp traphosts delete params
func (o *SnmpTraphostsDeleteParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WriteToRequest writes these params to a swagger request
func (o *SnmpTraphostsDeleteParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param host
	if err := r.SetPathParam("host", o.Host); err != nil {
		return err
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
