// Code generated by go-swagger; DO NOT EDIT.

package support

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewSnmpUsersCollectionGetParams creates a new SnmpUsersCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSnmpUsersCollectionGetParams() *SnmpUsersCollectionGetParams {
	return &SnmpUsersCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSnmpUsersCollectionGetParamsWithTimeout creates a new SnmpUsersCollectionGetParams object
// with the ability to set a timeout on a request.
func NewSnmpUsersCollectionGetParamsWithTimeout(timeout time.Duration) *SnmpUsersCollectionGetParams {
	return &SnmpUsersCollectionGetParams{
		timeout: timeout,
	}
}

// NewSnmpUsersCollectionGetParamsWithContext creates a new SnmpUsersCollectionGetParams object
// with the ability to set a context for a request.
func NewSnmpUsersCollectionGetParamsWithContext(ctx context.Context) *SnmpUsersCollectionGetParams {
	return &SnmpUsersCollectionGetParams{
		Context: ctx,
	}
}

// NewSnmpUsersCollectionGetParamsWithHTTPClient creates a new SnmpUsersCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewSnmpUsersCollectionGetParamsWithHTTPClient(client *http.Client) *SnmpUsersCollectionGetParams {
	return &SnmpUsersCollectionGetParams{
		HTTPClient: client,
	}
}

/*
SnmpUsersCollectionGetParams contains all the parameters to send to the API endpoint

	for the snmp users collection get operation.

	Typically these are written to a http.Request.
*/
type SnmpUsersCollectionGetParams struct {

	/* AuthenticationMethod.

	   Filter by authentication_method
	*/
	AuthenticationMethod *string

	/* Comment.

	   Filter by comment
	*/
	Comment *string

	/* EngineID.

	   Filter by engine_id
	*/
	EngineID *string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* Name.

	   Filter by name
	*/
	Name *string

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* OwnerName.

	   Filter by owner.name
	*/
	OwnerName *string

	/* OwnerUUID.

	   Filter by owner.uuid
	*/
	OwnerUUID *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* Scope.

	   Filter by scope
	*/
	Scope *string

	/* Snmpv3AuthenticationProtocol.

	   Filter by snmpv3.authentication_protocol
	*/
	Snmpv3AuthenticationProtocol *string

	/* Snmpv3PrivacyProtocol.

	   Filter by snmpv3.privacy_protocol
	*/
	Snmpv3PrivacyProtocol *string

	/* SwitchAddress.

	   Filter by switch_address
	*/
	SwitchAddress *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the snmp users collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SnmpUsersCollectionGetParams) WithDefaults() *SnmpUsersCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the snmp users collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SnmpUsersCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := SnmpUsersCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the snmp users collection get params
func (o *SnmpUsersCollectionGetParams) WithTimeout(timeout time.Duration) *SnmpUsersCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the snmp users collection get params
func (o *SnmpUsersCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the snmp users collection get params
func (o *SnmpUsersCollectionGetParams) WithContext(ctx context.Context) *SnmpUsersCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the snmp users collection get params
func (o *SnmpUsersCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the snmp users collection get params
func (o *SnmpUsersCollectionGetParams) WithHTTPClient(client *http.Client) *SnmpUsersCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the snmp users collection get params
func (o *SnmpUsersCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAuthenticationMethod adds the authenticationMethod to the snmp users collection get params
func (o *SnmpUsersCollectionGetParams) WithAuthenticationMethod(authenticationMethod *string) *SnmpUsersCollectionGetParams {
	o.SetAuthenticationMethod(authenticationMethod)
	return o
}

// SetAuthenticationMethod adds the authenticationMethod to the snmp users collection get params
func (o *SnmpUsersCollectionGetParams) SetAuthenticationMethod(authenticationMethod *string) {
	o.AuthenticationMethod = authenticationMethod
}

// WithComment adds the comment to the snmp users collection get params
func (o *SnmpUsersCollectionGetParams) WithComment(comment *string) *SnmpUsersCollectionGetParams {
	o.SetComment(comment)
	return o
}

// SetComment adds the comment to the snmp users collection get params
func (o *SnmpUsersCollectionGetParams) SetComment(comment *string) {
	o.Comment = comment
}

// WithEngineID adds the engineID to the snmp users collection get params
func (o *SnmpUsersCollectionGetParams) WithEngineID(engineID *string) *SnmpUsersCollectionGetParams {
	o.SetEngineID(engineID)
	return o
}

// SetEngineID adds the engineId to the snmp users collection get params
func (o *SnmpUsersCollectionGetParams) SetEngineID(engineID *string) {
	o.EngineID = engineID
}

// WithFields adds the fields to the snmp users collection get params
func (o *SnmpUsersCollectionGetParams) WithFields(fields []string) *SnmpUsersCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the snmp users collection get params
func (o *SnmpUsersCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithMaxRecords adds the maxRecords to the snmp users collection get params
func (o *SnmpUsersCollectionGetParams) WithMaxRecords(maxRecords *int64) *SnmpUsersCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the snmp users collection get params
func (o *SnmpUsersCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithName adds the name to the snmp users collection get params
func (o *SnmpUsersCollectionGetParams) WithName(name *string) *SnmpUsersCollectionGetParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the snmp users collection get params
func (o *SnmpUsersCollectionGetParams) SetName(name *string) {
	o.Name = name
}

// WithOrderBy adds the orderBy to the snmp users collection get params
func (o *SnmpUsersCollectionGetParams) WithOrderBy(orderBy []string) *SnmpUsersCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the snmp users collection get params
func (o *SnmpUsersCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithOwnerName adds the ownerName to the snmp users collection get params
func (o *SnmpUsersCollectionGetParams) WithOwnerName(ownerName *string) *SnmpUsersCollectionGetParams {
	o.SetOwnerName(ownerName)
	return o
}

// SetOwnerName adds the ownerName to the snmp users collection get params
func (o *SnmpUsersCollectionGetParams) SetOwnerName(ownerName *string) {
	o.OwnerName = ownerName
}

// WithOwnerUUID adds the ownerUUID to the snmp users collection get params
func (o *SnmpUsersCollectionGetParams) WithOwnerUUID(ownerUUID *string) *SnmpUsersCollectionGetParams {
	o.SetOwnerUUID(ownerUUID)
	return o
}

// SetOwnerUUID adds the ownerUuid to the snmp users collection get params
func (o *SnmpUsersCollectionGetParams) SetOwnerUUID(ownerUUID *string) {
	o.OwnerUUID = ownerUUID
}

// WithReturnRecords adds the returnRecords to the snmp users collection get params
func (o *SnmpUsersCollectionGetParams) WithReturnRecords(returnRecords *bool) *SnmpUsersCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the snmp users collection get params
func (o *SnmpUsersCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the snmp users collection get params
func (o *SnmpUsersCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *SnmpUsersCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the snmp users collection get params
func (o *SnmpUsersCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithScope adds the scope to the snmp users collection get params
func (o *SnmpUsersCollectionGetParams) WithScope(scope *string) *SnmpUsersCollectionGetParams {
	o.SetScope(scope)
	return o
}

// SetScope adds the scope to the snmp users collection get params
func (o *SnmpUsersCollectionGetParams) SetScope(scope *string) {
	o.Scope = scope
}

// WithSnmpv3AuthenticationProtocol adds the snmpv3AuthenticationProtocol to the snmp users collection get params
func (o *SnmpUsersCollectionGetParams) WithSnmpv3AuthenticationProtocol(snmpv3AuthenticationProtocol *string) *SnmpUsersCollectionGetParams {
	o.SetSnmpv3AuthenticationProtocol(snmpv3AuthenticationProtocol)
	return o
}

// SetSnmpv3AuthenticationProtocol adds the snmpv3AuthenticationProtocol to the snmp users collection get params
func (o *SnmpUsersCollectionGetParams) SetSnmpv3AuthenticationProtocol(snmpv3AuthenticationProtocol *string) {
	o.Snmpv3AuthenticationProtocol = snmpv3AuthenticationProtocol
}

// WithSnmpv3PrivacyProtocol adds the snmpv3PrivacyProtocol to the snmp users collection get params
func (o *SnmpUsersCollectionGetParams) WithSnmpv3PrivacyProtocol(snmpv3PrivacyProtocol *string) *SnmpUsersCollectionGetParams {
	o.SetSnmpv3PrivacyProtocol(snmpv3PrivacyProtocol)
	return o
}

// SetSnmpv3PrivacyProtocol adds the snmpv3PrivacyProtocol to the snmp users collection get params
func (o *SnmpUsersCollectionGetParams) SetSnmpv3PrivacyProtocol(snmpv3PrivacyProtocol *string) {
	o.Snmpv3PrivacyProtocol = snmpv3PrivacyProtocol
}

// WithSwitchAddress adds the switchAddress to the snmp users collection get params
func (o *SnmpUsersCollectionGetParams) WithSwitchAddress(switchAddress *string) *SnmpUsersCollectionGetParams {
	o.SetSwitchAddress(switchAddress)
	return o
}

// SetSwitchAddress adds the switchAddress to the snmp users collection get params
func (o *SnmpUsersCollectionGetParams) SetSwitchAddress(switchAddress *string) {
	o.SwitchAddress = switchAddress
}

// WriteToRequest writes these params to a swagger request
func (o *SnmpUsersCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.AuthenticationMethod != nil {

		// query param authentication_method
		var qrAuthenticationMethod string

		if o.AuthenticationMethod != nil {
			qrAuthenticationMethod = *o.AuthenticationMethod
		}
		qAuthenticationMethod := qrAuthenticationMethod
		if qAuthenticationMethod != "" {

			if err := r.SetQueryParam("authentication_method", qAuthenticationMethod); err != nil {
				return err
			}
		}
	}

	if o.Comment != nil {

		// query param comment
		var qrComment string

		if o.Comment != nil {
			qrComment = *o.Comment
		}
		qComment := qrComment
		if qComment != "" {

			if err := r.SetQueryParam("comment", qComment); err != nil {
				return err
			}
		}
	}

	if o.EngineID != nil {

		// query param engine_id
		var qrEngineID string

		if o.EngineID != nil {
			qrEngineID = *o.EngineID
		}
		qEngineID := qrEngineID
		if qEngineID != "" {

			if err := r.SetQueryParam("engine_id", qEngineID); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.OwnerName != nil {

		// query param owner.name
		var qrOwnerName string

		if o.OwnerName != nil {
			qrOwnerName = *o.OwnerName
		}
		qOwnerName := qrOwnerName
		if qOwnerName != "" {

			if err := r.SetQueryParam("owner.name", qOwnerName); err != nil {
				return err
			}
		}
	}

	if o.OwnerUUID != nil {

		// query param owner.uuid
		var qrOwnerUUID string

		if o.OwnerUUID != nil {
			qrOwnerUUID = *o.OwnerUUID
		}
		qOwnerUUID := qrOwnerUUID
		if qOwnerUUID != "" {

			if err := r.SetQueryParam("owner.uuid", qOwnerUUID); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.Scope != nil {

		// query param scope
		var qrScope string

		if o.Scope != nil {
			qrScope = *o.Scope
		}
		qScope := qrScope
		if qScope != "" {

			if err := r.SetQueryParam("scope", qScope); err != nil {
				return err
			}
		}
	}

	if o.Snmpv3AuthenticationProtocol != nil {

		// query param snmpv3.authentication_protocol
		var qrSnmpv3AuthenticationProtocol string

		if o.Snmpv3AuthenticationProtocol != nil {
			qrSnmpv3AuthenticationProtocol = *o.Snmpv3AuthenticationProtocol
		}
		qSnmpv3AuthenticationProtocol := qrSnmpv3AuthenticationProtocol
		if qSnmpv3AuthenticationProtocol != "" {

			if err := r.SetQueryParam("snmpv3.authentication_protocol", qSnmpv3AuthenticationProtocol); err != nil {
				return err
			}
		}
	}

	if o.Snmpv3PrivacyProtocol != nil {

		// query param snmpv3.privacy_protocol
		var qrSnmpv3PrivacyProtocol string

		if o.Snmpv3PrivacyProtocol != nil {
			qrSnmpv3PrivacyProtocol = *o.Snmpv3PrivacyProtocol
		}
		qSnmpv3PrivacyProtocol := qrSnmpv3PrivacyProtocol
		if qSnmpv3PrivacyProtocol != "" {

			if err := r.SetQueryParam("snmpv3.privacy_protocol", qSnmpv3PrivacyProtocol); err != nil {
				return err
			}
		}
	}

	if o.SwitchAddress != nil {

		// query param switch_address
		var qrSwitchAddress string

		if o.SwitchAddress != nil {
			qrSwitchAddress = *o.SwitchAddress
		}
		qSwitchAddress := qrSwitchAddress
		if qSwitchAddress != "" {

			if err := r.SetQueryParam("switch_address", qSwitchAddress); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamSnmpUsersCollectionGet binds the parameter fields
func (o *SnmpUsersCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamSnmpUsersCollectionGet binds the parameter order_by
func (o *SnmpUsersCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
