// Code generated by go-swagger; DO NOT EDIT.

package support

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SnmpUsersCreateReader is a Reader for the SnmpUsersCreate structure.
type SnmpUsersCreateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SnmpUsersCreateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewSnmpUsersCreateCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSnmpUsersCreateDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSnmpUsersCreateCreated creates a SnmpUsersCreateCreated with default headers values
func NewSnmpUsersCreateCreated() *SnmpUsersCreateCreated {
	return &SnmpUsersCreateCreated{}
}

/*
SnmpUsersCreateCreated describes a response with status code 201, with default header values.

Created
*/
type SnmpUsersCreateCreated struct {

	/* Useful for tracking the resource location
	 */
	Location string

	Payload *models.SnmpUser
}

// IsSuccess returns true when this snmp users create created response has a 2xx status code
func (o *SnmpUsersCreateCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this snmp users create created response has a 3xx status code
func (o *SnmpUsersCreateCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this snmp users create created response has a 4xx status code
func (o *SnmpUsersCreateCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this snmp users create created response has a 5xx status code
func (o *SnmpUsersCreateCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this snmp users create created response a status code equal to that given
func (o *SnmpUsersCreateCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the snmp users create created response
func (o *SnmpUsersCreateCreated) Code() int {
	return 201
}

func (o *SnmpUsersCreateCreated) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /support/snmp/users][%d] snmpUsersCreateCreated %s", 201, payload)
}

func (o *SnmpUsersCreateCreated) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /support/snmp/users][%d] snmpUsersCreateCreated %s", 201, payload)
}

func (o *SnmpUsersCreateCreated) GetPayload() *models.SnmpUser {
	return o.Payload
}

func (o *SnmpUsersCreateCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	o.Payload = new(models.SnmpUser)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSnmpUsersCreateDefault creates a SnmpUsersCreateDefault with default headers values
func NewSnmpUsersCreateDefault(code int) *SnmpUsersCreateDefault {
	return &SnmpUsersCreateDefault{
		_statusCode: code,
	}
}

/*
	SnmpUsersCreateDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 1263341 | Invalid authentication protocol. |
| 1263342 | Invalid privacy protocol. |
| 1263567 | Authentication password not supplied. |
| 1263568 | Privacy password not supplied. |
| 1263569 | Authentication password does not conform to ONTAP requirements. |
| 1263570 | Privacy password does not conform to ONTAP requirements. |
| 2621475 | This operation is not allowed on a node SVM. |
| 2621601 | This operation is not permitted on a system SVM. |
| 5636101 | One role for all applications and authentication methods is recommended for a user account. |
| 5636106 | Engine ID starting with first bit set as 1 in first octet should have a minimum of 5 or maximum of 32 octets. |
| 5636107 | Engine ID specified is based on an IP address, and must therefore be 9 octets in length. |
| 5636108 | Engine ID specified is based on an IPv6 address, and must therefore be 21 octets in length. |
| 5636109 | Engine ID specified is based on a MAC address, and must therefore be 11 octets in length. |
| 5636110 | Engine ID starting with first bit set as 0 in the first octet needs to be 12 octets in length. |
| 5636111 | Engine ID cannot have all zeroes. |
| 5636112 | Invalid Engine ID specified. |
| 5636113 | Cannot enable SNMP user capability for data SVM. |
| 5636116 | Cannot read SNMP user capability for data SVM. |
| 5636121 | User account name is reserved for use by the system. |
| 5636123 | Cannot create an SNMP user with a role other than readonly, none, or admin. |
| 5636124 | Cannot create an SNMP user with a role other than vsadmin-readonly, none, or vsadmin. |
| 5636148 | Failed to discover SNMPv3 engine ID of remote SNMP agent. |
| 5636150 | The switch_address parameter can be specified only for administrative SVMs. |
| 5636152 | 0.0.0.0 cannot be specified as the IP Address for the switch_address parameter. |
| 5636153 | Engine ID is already associated with user. |
| 7077897 | Invalid character in username. Valid characters\":\" A-Z, a-z, 0-9, \".\", \"_\", and \"-\". Note that the user name cannot start with \"-\". |
| 7077899 | Username does not meet length requirements. |
| 7077906 | Cannot use given role with this SVM because a role with that name has not been defined for the SVM. |
| 9043995 | Failed to create SNMP community. Reason\":\" SNMPv1 and SNMPv2c are not supported when cluster FIPS mode is enabled. |
| 9043999 | ONTAP failed to create an SNMPv3 user because SNMPv3 is disabled in the cluster. |
| 9044020 | Customized engine-id cannot be specified for community users. |
| 9044021 | The specified authentication protocol is not supported when cluster FIPS mode is enabled. |
| 9044022 | The specified privacy protocol is not supported when cluster FIPS mode is enabled. |
| 9044023 | The switch_address parameter can be specified only for creating remote SNMPv3 users. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type SnmpUsersCreateDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this snmp users create default response has a 2xx status code
func (o *SnmpUsersCreateDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this snmp users create default response has a 3xx status code
func (o *SnmpUsersCreateDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this snmp users create default response has a 4xx status code
func (o *SnmpUsersCreateDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this snmp users create default response has a 5xx status code
func (o *SnmpUsersCreateDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this snmp users create default response a status code equal to that given
func (o *SnmpUsersCreateDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the snmp users create default response
func (o *SnmpUsersCreateDefault) Code() int {
	return o._statusCode
}

func (o *SnmpUsersCreateDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /support/snmp/users][%d] snmp_users_create default %s", o._statusCode, payload)
}

func (o *SnmpUsersCreateDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /support/snmp/users][%d] snmp_users_create default %s", o._statusCode, payload)
}

func (o *SnmpUsersCreateDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SnmpUsersCreateDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
