// Code generated by go-swagger; DO NOT EDIT.

package support

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SnmpUsersDeleteCollectionReader is a Reader for the SnmpUsersDeleteCollection structure.
type SnmpUsersDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SnmpUsersDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSnmpUsersDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSnmpUsersDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSnmpUsersDeleteCollectionOK creates a SnmpUsersDeleteCollectionOK with default headers values
func NewSnmpUsersDeleteCollectionOK() *SnmpUsersDeleteCollectionOK {
	return &SnmpUsersDeleteCollectionOK{}
}

/*
SnmpUsersDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type SnmpUsersDeleteCollectionOK struct {
}

// IsSuccess returns true when this snmp users delete collection o k response has a 2xx status code
func (o *SnmpUsersDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this snmp users delete collection o k response has a 3xx status code
func (o *SnmpUsersDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this snmp users delete collection o k response has a 4xx status code
func (o *SnmpUsersDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this snmp users delete collection o k response has a 5xx status code
func (o *SnmpUsersDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this snmp users delete collection o k response a status code equal to that given
func (o *SnmpUsersDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the snmp users delete collection o k response
func (o *SnmpUsersDeleteCollectionOK) Code() int {
	return 200
}

func (o *SnmpUsersDeleteCollectionOK) Error() string {
	return fmt.Sprintf("[DELETE /support/snmp/users][%d] snmpUsersDeleteCollectionOK", 200)
}

func (o *SnmpUsersDeleteCollectionOK) String() string {
	return fmt.Sprintf("[DELETE /support/snmp/users][%d] snmpUsersDeleteCollectionOK", 200)
}

func (o *SnmpUsersDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewSnmpUsersDeleteCollectionDefault creates a SnmpUsersDeleteCollectionDefault with default headers values
func NewSnmpUsersDeleteCollectionDefault(code int) *SnmpUsersDeleteCollectionDefault {
	return &SnmpUsersDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
SnmpUsersDeleteCollectionDefault describes a response with status code -1, with default header values.

Error
*/
type SnmpUsersDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this snmp users delete collection default response has a 2xx status code
func (o *SnmpUsersDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this snmp users delete collection default response has a 3xx status code
func (o *SnmpUsersDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this snmp users delete collection default response has a 4xx status code
func (o *SnmpUsersDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this snmp users delete collection default response has a 5xx status code
func (o *SnmpUsersDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this snmp users delete collection default response a status code equal to that given
func (o *SnmpUsersDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the snmp users delete collection default response
func (o *SnmpUsersDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *SnmpUsersDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /support/snmp/users][%d] snmp_users_delete_collection default %s", o._statusCode, payload)
}

func (o *SnmpUsersDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /support/snmp/users][%d] snmp_users_delete_collection default %s", o._statusCode, payload)
}

func (o *SnmpUsersDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SnmpUsersDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
SnmpUsersDeleteCollectionBody List of SNMP users, along with their associated properties, configured in ONTAP. This includes SNMPv1/SNMPv2c community users as well as SNMPv3 users.
swagger:model SnmpUsersDeleteCollectionBody
*/
type SnmpUsersDeleteCollectionBody struct {

	// snmp user response inline records
	SnmpUserResponseInlineRecords []*models.SnmpUser `json:"records,omitempty"`
}

// Validate validates this snmp users delete collection body
func (o *SnmpUsersDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSnmpUserResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SnmpUsersDeleteCollectionBody) validateSnmpUserResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.SnmpUserResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.SnmpUserResponseInlineRecords); i++ {
		if swag.IsZero(o.SnmpUserResponseInlineRecords[i]) { // not required
			continue
		}

		if o.SnmpUserResponseInlineRecords[i] != nil {
			if err := o.SnmpUserResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this snmp users delete collection body based on the context it is used
func (o *SnmpUsersDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSnmpUserResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SnmpUsersDeleteCollectionBody) contextValidateSnmpUserResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.SnmpUserResponseInlineRecords); i++ {

		if o.SnmpUserResponseInlineRecords[i] != nil {
			if err := o.SnmpUserResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *SnmpUsersDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SnmpUsersDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res SnmpUsersDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
