// Code generated by go-swagger; DO NOT EDIT.

package support

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SnmpUsersDeleteReader is a Reader for the SnmpUsersDelete structure.
type SnmpUsersDeleteReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SnmpUsersDeleteReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSnmpUsersDeleteOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSnmpUsersDeleteDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSnmpUsersDeleteOK creates a SnmpUsersDeleteOK with default headers values
func NewSnmpUsersDeleteOK() *SnmpUsersDeleteOK {
	return &SnmpUsersDeleteOK{}
}

/*
SnmpUsersDeleteOK describes a response with status code 200, with default header values.

OK
*/
type SnmpUsersDeleteOK struct {
}

// IsSuccess returns true when this snmp users delete o k response has a 2xx status code
func (o *SnmpUsersDeleteOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this snmp users delete o k response has a 3xx status code
func (o *SnmpUsersDeleteOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this snmp users delete o k response has a 4xx status code
func (o *SnmpUsersDeleteOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this snmp users delete o k response has a 5xx status code
func (o *SnmpUsersDeleteOK) IsServerError() bool {
	return false
}

// IsCode returns true when this snmp users delete o k response a status code equal to that given
func (o *SnmpUsersDeleteOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the snmp users delete o k response
func (o *SnmpUsersDeleteOK) Code() int {
	return 200
}

func (o *SnmpUsersDeleteOK) Error() string {
	return fmt.Sprintf("[DELETE /support/snmp/users/{engine_id}/{name}][%d] snmpUsersDeleteOK", 200)
}

func (o *SnmpUsersDeleteOK) String() string {
	return fmt.Sprintf("[DELETE /support/snmp/users/{engine_id}/{name}][%d] snmpUsersDeleteOK", 200)
}

func (o *SnmpUsersDeleteOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewSnmpUsersDeleteDefault creates a SnmpUsersDeleteDefault with default headers values
func NewSnmpUsersDeleteDefault(code int) *SnmpUsersDeleteDefault {
	return &SnmpUsersDeleteDefault{
		_statusCode: code,
	}
}

/*
SnmpUsersDeleteDefault describes a response with status code -1, with default header values.

Error
*/
type SnmpUsersDeleteDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this snmp users delete default response has a 2xx status code
func (o *SnmpUsersDeleteDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this snmp users delete default response has a 3xx status code
func (o *SnmpUsersDeleteDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this snmp users delete default response has a 4xx status code
func (o *SnmpUsersDeleteDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this snmp users delete default response has a 5xx status code
func (o *SnmpUsersDeleteDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this snmp users delete default response a status code equal to that given
func (o *SnmpUsersDeleteDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the snmp users delete default response
func (o *SnmpUsersDeleteDefault) Code() int {
	return o._statusCode
}

func (o *SnmpUsersDeleteDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /support/snmp/users/{engine_id}/{name}][%d] snmp_users_delete default %s", o._statusCode, payload)
}

func (o *SnmpUsersDeleteDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /support/snmp/users/{engine_id}/{name}][%d] snmp_users_delete default %s", o._statusCode, payload)
}

func (o *SnmpUsersDeleteDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SnmpUsersDeleteDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
