// Code generated by go-swagger; DO NOT EDIT.

package support

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewSnmpUsersGetParams creates a new SnmpUsersGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSnmpUsersGetParams() *SnmpUsersGetParams {
	return &SnmpUsersGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSnmpUsersGetParamsWithTimeout creates a new SnmpUsersGetParams object
// with the ability to set a timeout on a request.
func NewSnmpUsersGetParamsWithTimeout(timeout time.Duration) *SnmpUsersGetParams {
	return &SnmpUsersGetParams{
		timeout: timeout,
	}
}

// NewSnmpUsersGetParamsWithContext creates a new SnmpUsersGetParams object
// with the ability to set a context for a request.
func NewSnmpUsersGetParamsWithContext(ctx context.Context) *SnmpUsersGetParams {
	return &SnmpUsersGetParams{
		Context: ctx,
	}
}

// NewSnmpUsersGetParamsWithHTTPClient creates a new SnmpUsersGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewSnmpUsersGetParamsWithHTTPClient(client *http.Client) *SnmpUsersGetParams {
	return &SnmpUsersGetParams{
		HTTPClient: client,
	}
}

/*
SnmpUsersGetParams contains all the parameters to send to the API endpoint

	for the snmp users get operation.

	Typically these are written to a http.Request.
*/
type SnmpUsersGetParams struct {

	/* EngineID.

	   Engine ID of owning SVM or remote switch.
	*/
	EngineID string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* Name.

	   SNMP user name.
	*/
	Name string

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the snmp users get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SnmpUsersGetParams) WithDefaults() *SnmpUsersGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the snmp users get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SnmpUsersGetParams) SetDefaults() {
	var (
		returnTimeoutDefault = int64(15)
	)

	val := SnmpUsersGetParams{
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the snmp users get params
func (o *SnmpUsersGetParams) WithTimeout(timeout time.Duration) *SnmpUsersGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the snmp users get params
func (o *SnmpUsersGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the snmp users get params
func (o *SnmpUsersGetParams) WithContext(ctx context.Context) *SnmpUsersGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the snmp users get params
func (o *SnmpUsersGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the snmp users get params
func (o *SnmpUsersGetParams) WithHTTPClient(client *http.Client) *SnmpUsersGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the snmp users get params
func (o *SnmpUsersGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithEngineID adds the engineID to the snmp users get params
func (o *SnmpUsersGetParams) WithEngineID(engineID string) *SnmpUsersGetParams {
	o.SetEngineID(engineID)
	return o
}

// SetEngineID adds the engineId to the snmp users get params
func (o *SnmpUsersGetParams) SetEngineID(engineID string) {
	o.EngineID = engineID
}

// WithFields adds the fields to the snmp users get params
func (o *SnmpUsersGetParams) WithFields(fields []string) *SnmpUsersGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the snmp users get params
func (o *SnmpUsersGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithName adds the name to the snmp users get params
func (o *SnmpUsersGetParams) WithName(name string) *SnmpUsersGetParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the snmp users get params
func (o *SnmpUsersGetParams) SetName(name string) {
	o.Name = name
}

// WithReturnTimeout adds the returnTimeout to the snmp users get params
func (o *SnmpUsersGetParams) WithReturnTimeout(returnTimeout *int64) *SnmpUsersGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the snmp users get params
func (o *SnmpUsersGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WriteToRequest writes these params to a swagger request
func (o *SnmpUsersGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param engine_id
	if err := r.SetPathParam("engine_id", o.EngineID); err != nil {
		return err
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	// path param name
	if err := r.SetPathParam("name", o.Name); err != nil {
		return err
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamSnmpUsersGet binds the parameter fields
func (o *SnmpUsersGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
