// Code generated by go-swagger; DO NOT EDIT.

package support

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SnmpUsersModifyCollectionReader is a Reader for the SnmpUsersModifyCollection structure.
type SnmpUsersModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SnmpUsersModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSnmpUsersModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSnmpUsersModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSnmpUsersModifyCollectionOK creates a SnmpUsersModifyCollectionOK with default headers values
func NewSnmpUsersModifyCollectionOK() *SnmpUsersModifyCollectionOK {
	return &SnmpUsersModifyCollectionOK{}
}

/*
SnmpUsersModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type SnmpUsersModifyCollectionOK struct {
}

// IsSuccess returns true when this snmp users modify collection o k response has a 2xx status code
func (o *SnmpUsersModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this snmp users modify collection o k response has a 3xx status code
func (o *SnmpUsersModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this snmp users modify collection o k response has a 4xx status code
func (o *SnmpUsersModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this snmp users modify collection o k response has a 5xx status code
func (o *SnmpUsersModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this snmp users modify collection o k response a status code equal to that given
func (o *SnmpUsersModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the snmp users modify collection o k response
func (o *SnmpUsersModifyCollectionOK) Code() int {
	return 200
}

func (o *SnmpUsersModifyCollectionOK) Error() string {
	return fmt.Sprintf("[PATCH /support/snmp/users][%d] snmpUsersModifyCollectionOK", 200)
}

func (o *SnmpUsersModifyCollectionOK) String() string {
	return fmt.Sprintf("[PATCH /support/snmp/users][%d] snmpUsersModifyCollectionOK", 200)
}

func (o *SnmpUsersModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewSnmpUsersModifyCollectionDefault creates a SnmpUsersModifyCollectionDefault with default headers values
func NewSnmpUsersModifyCollectionDefault(code int) *SnmpUsersModifyCollectionDefault {
	return &SnmpUsersModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	SnmpUsersModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 2621475 | This operation is not allowed on a node SVM. |
| 2621699 | This operation is not allowed on a system SVM. |
| 5636123 | Cannot create an SNMP user with a role other than readonly, none, or admin. |
| 5636124 | Cannot create an SNMP user with a role other than vsadmin-readonly, none, or vsadmin. |
| 5832712 | Cannot modify attributes for user \"diag.\" |
| 7077906 | Cannot use given role with this SVM because a role with that name has not been defined for the SVM. |
| 9043999 | ONTAP failed to create an SNMPv3 user because SNMPv3 is disabled in the cluster. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type SnmpUsersModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this snmp users modify collection default response has a 2xx status code
func (o *SnmpUsersModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this snmp users modify collection default response has a 3xx status code
func (o *SnmpUsersModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this snmp users modify collection default response has a 4xx status code
func (o *SnmpUsersModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this snmp users modify collection default response has a 5xx status code
func (o *SnmpUsersModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this snmp users modify collection default response a status code equal to that given
func (o *SnmpUsersModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the snmp users modify collection default response
func (o *SnmpUsersModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *SnmpUsersModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /support/snmp/users][%d] snmp_users_modify_collection default %s", o._statusCode, payload)
}

func (o *SnmpUsersModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /support/snmp/users][%d] snmp_users_modify_collection default %s", o._statusCode, payload)
}

func (o *SnmpUsersModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SnmpUsersModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
SnmpUsersModifyCollectionBody List of SNMP users, along with their associated properties, configured in ONTAP. This includes SNMPv1/SNMPv2c community users as well as SNMPv3 users.
swagger:model SnmpUsersModifyCollectionBody
*/
type SnmpUsersModifyCollectionBody struct {

	// links
	Links *models.SnmpUserInlineLinks `json:"_links,omitempty"`

	// Optional authentication method.
	// Example: usm
	// Enum: ["community","usm","both"]
	AuthenticationMethod *string `json:"authentication_method,omitempty"`

	// Optional comment text.
	// Example: This is a comment.
	// Max Length: 128
	// Min Length: 0
	Comment *string `json:"comment,omitempty"`

	// Optional SNMPv3 engine identifier. For a local SNMP user belonging to the administrative Storage Virtual Machine (SVM), the default value of this parameter is the SNMPv3 engine identifier for the administrative SVM. For a local SNMP user belonging to a data SVM, the default value of this parameter is the SNMPv3 engine identifier for that data SVM. For an SNMPv1/SNMPv2c community, this parameter should not be specified in "POST" method. For a remote switch SNMPv3 user, this parameter specifies the SNMPv3 engine identifier for the remote switch. This parameter can also optionally specify a custom engine identifier.
	// Example: 80000315055415ab26d4aae811ac4d005056bb792e
	EngineID *string `json:"engine_id,omitempty"`

	// SNMP user name.
	// Example: snmpv3user2
	// Max Length: 32
	Name *string `json:"name,omitempty"`

	// owner
	Owner *models.SnmpUserInlineOwner `json:"owner,omitempty"`

	// Set to "svm" for data Storage Virtual Machine (SVM) SNMP users and to "cluster" for administrative SVM SNMP users.
	// Example: svm
	// Read Only: true
	// Enum: ["svm","cluster"]
	Scope *string `json:"scope,omitempty"`

	// snmp user response inline records
	SnmpUserResponseInlineRecords []*models.SnmpUser `json:"records,omitempty"`

	// snmpv3
	Snmpv3 *models.SnmpUserInlineSnmpv3 `json:"snmpv3,omitempty"`

	// Optional remote switch address. It can be an IPv4 address or an IPv6 address. A remote switch can be queried over SNMPv3 using ONTAP SNMP client functionality. Querying such a switch requires an SNMPv3 user (remote switch user) to be configured on the switch. Since ONTAP requires remote switch user's SNMPv3 credentials (to query it), this user must be configured in ONTAP as well. This parameter is specified when configuring such a user.
	// Example: 10.23.34.45
	SwitchAddress *string `json:"switch_address,omitempty"`
}

// Validate validates this snmp users modify collection body
func (o *SnmpUsersModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateAuthenticationMethod(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateComment(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateOwner(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateScope(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSnmpUserResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSnmpv3(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SnmpUsersModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

var snmpUsersModifyCollectionBodyTypeAuthenticationMethodPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["community","usm","both"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		snmpUsersModifyCollectionBodyTypeAuthenticationMethodPropEnum = append(snmpUsersModifyCollectionBodyTypeAuthenticationMethodPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// SnmpUsersModifyCollectionBody
	// SnmpUsersModifyCollectionBody
	// authentication_method
	// AuthenticationMethod
	// community
	// END DEBUGGING
	// SnmpUsersModifyCollectionBodyAuthenticationMethodCommunity captures enum value "community"
	SnmpUsersModifyCollectionBodyAuthenticationMethodCommunity string = "community"

	// BEGIN DEBUGGING
	// SnmpUsersModifyCollectionBody
	// SnmpUsersModifyCollectionBody
	// authentication_method
	// AuthenticationMethod
	// usm
	// END DEBUGGING
	// SnmpUsersModifyCollectionBodyAuthenticationMethodUsm captures enum value "usm"
	SnmpUsersModifyCollectionBodyAuthenticationMethodUsm string = "usm"

	// BEGIN DEBUGGING
	// SnmpUsersModifyCollectionBody
	// SnmpUsersModifyCollectionBody
	// authentication_method
	// AuthenticationMethod
	// both
	// END DEBUGGING
	// SnmpUsersModifyCollectionBodyAuthenticationMethodBoth captures enum value "both"
	SnmpUsersModifyCollectionBodyAuthenticationMethodBoth string = "both"
)

// prop value enum
func (o *SnmpUsersModifyCollectionBody) validateAuthenticationMethodEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, snmpUsersModifyCollectionBodyTypeAuthenticationMethodPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *SnmpUsersModifyCollectionBody) validateAuthenticationMethod(formats strfmt.Registry) error {
	if swag.IsZero(o.AuthenticationMethod) { // not required
		return nil
	}

	// value enum
	if err := o.validateAuthenticationMethodEnum("info"+"."+"authentication_method", "body", *o.AuthenticationMethod); err != nil {
		return err
	}

	return nil
}

func (o *SnmpUsersModifyCollectionBody) validateComment(formats strfmt.Registry) error {
	if swag.IsZero(o.Comment) { // not required
		return nil
	}

	if err := validate.MinLength("info"+"."+"comment", "body", *o.Comment, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("info"+"."+"comment", "body", *o.Comment, 128); err != nil {
		return err
	}

	return nil
}

func (o *SnmpUsersModifyCollectionBody) validateName(formats strfmt.Registry) error {
	if swag.IsZero(o.Name) { // not required
		return nil
	}

	if err := validate.MaxLength("info"+"."+"name", "body", *o.Name, 32); err != nil {
		return err
	}

	return nil
}

func (o *SnmpUsersModifyCollectionBody) validateOwner(formats strfmt.Registry) error {
	if swag.IsZero(o.Owner) { // not required
		return nil
	}

	if o.Owner != nil {
		if err := o.Owner.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "owner")
			}
			return err
		}
	}

	return nil
}

var snmpUsersModifyCollectionBodyTypeScopePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["svm","cluster"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		snmpUsersModifyCollectionBodyTypeScopePropEnum = append(snmpUsersModifyCollectionBodyTypeScopePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// SnmpUsersModifyCollectionBody
	// SnmpUsersModifyCollectionBody
	// scope
	// Scope
	// svm
	// END DEBUGGING
	// SnmpUsersModifyCollectionBodyScopeSvm captures enum value "svm"
	SnmpUsersModifyCollectionBodyScopeSvm string = "svm"

	// BEGIN DEBUGGING
	// SnmpUsersModifyCollectionBody
	// SnmpUsersModifyCollectionBody
	// scope
	// Scope
	// cluster
	// END DEBUGGING
	// SnmpUsersModifyCollectionBodyScopeCluster captures enum value "cluster"
	SnmpUsersModifyCollectionBodyScopeCluster string = "cluster"
)

// prop value enum
func (o *SnmpUsersModifyCollectionBody) validateScopeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, snmpUsersModifyCollectionBodyTypeScopePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *SnmpUsersModifyCollectionBody) validateScope(formats strfmt.Registry) error {
	if swag.IsZero(o.Scope) { // not required
		return nil
	}

	// value enum
	if err := o.validateScopeEnum("info"+"."+"scope", "body", *o.Scope); err != nil {
		return err
	}

	return nil
}

func (o *SnmpUsersModifyCollectionBody) validateSnmpUserResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.SnmpUserResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.SnmpUserResponseInlineRecords); i++ {
		if swag.IsZero(o.SnmpUserResponseInlineRecords[i]) { // not required
			continue
		}

		if o.SnmpUserResponseInlineRecords[i] != nil {
			if err := o.SnmpUserResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *SnmpUsersModifyCollectionBody) validateSnmpv3(formats strfmt.Registry) error {
	if swag.IsZero(o.Snmpv3) { // not required
		return nil
	}

	if o.Snmpv3 != nil {
		if err := o.Snmpv3.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "snmpv3")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this snmp users modify collection body based on the context it is used
func (o *SnmpUsersModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateOwner(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateScope(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSnmpUserResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSnmpv3(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SnmpUsersModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *SnmpUsersModifyCollectionBody) contextValidateOwner(ctx context.Context, formats strfmt.Registry) error {

	if o.Owner != nil {
		if err := o.Owner.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "owner")
			}
			return err
		}
	}

	return nil
}

func (o *SnmpUsersModifyCollectionBody) contextValidateScope(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"scope", "body", o.Scope); err != nil {
		return err
	}

	return nil
}

func (o *SnmpUsersModifyCollectionBody) contextValidateSnmpUserResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.SnmpUserResponseInlineRecords); i++ {

		if o.SnmpUserResponseInlineRecords[i] != nil {
			if err := o.SnmpUserResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *SnmpUsersModifyCollectionBody) contextValidateSnmpv3(ctx context.Context, formats strfmt.Registry) error {

	if o.Snmpv3 != nil {
		if err := o.Snmpv3.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "snmpv3")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SnmpUsersModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SnmpUsersModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res SnmpUsersModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SnmpUserInlineLinks snmp user inline links
swagger:model snmp_user_inline__links
*/
type SnmpUserInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this snmp user inline links
func (o *SnmpUserInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SnmpUserInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this snmp user inline links based on the context it is used
func (o *SnmpUserInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SnmpUserInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SnmpUserInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SnmpUserInlineLinks) UnmarshalBinary(b []byte) error {
	var res SnmpUserInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SnmpUserInlineOwner Optional name and UUID of owning Storage Virtual Machine (SVM).
swagger:model snmp_user_inline_owner
*/
type SnmpUserInlineOwner struct {

	// links
	Links *models.SnmpUserInlineOwnerInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this snmp user inline owner
func (o *SnmpUserInlineOwner) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SnmpUserInlineOwner) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "owner" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this snmp user inline owner based on the context it is used
func (o *SnmpUserInlineOwner) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SnmpUserInlineOwner) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "owner" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SnmpUserInlineOwner) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SnmpUserInlineOwner) UnmarshalBinary(b []byte) error {
	var res SnmpUserInlineOwner
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SnmpUserInlineOwnerInlineLinks snmp user inline owner inline links
swagger:model snmp_user_inline_owner_inline__links
*/
type SnmpUserInlineOwnerInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this snmp user inline owner inline links
func (o *SnmpUserInlineOwnerInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SnmpUserInlineOwnerInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "owner" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this snmp user inline owner inline links based on the context it is used
func (o *SnmpUserInlineOwnerInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SnmpUserInlineOwnerInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "owner" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SnmpUserInlineOwnerInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SnmpUserInlineOwnerInlineLinks) UnmarshalBinary(b []byte) error {
	var res SnmpUserInlineOwnerInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SnmpUserInlineSnmpv3 Optional parameter that can be specified only for an SNMPv3 user i.e. when 'authentication_method' is either 'usm' or 'both'. This parameter defines the SNMPv3 credentials for an SNMPv3 user.
swagger:model snmp_user_inline_snmpv3
*/
type SnmpUserInlineSnmpv3 struct {

	// links
	Links *models.SnmpUserInlineSnmpv3InlineLinks `json:"_links,omitempty"`

	// Authentication protocol password.
	// Example: humTdumt*@t0nAwa11
	// Min Length: 8
	AuthenticationPassword *string `json:"authentication_password,omitempty"`

	// Authentication protocol.
	// Example: sha2_256
	// Enum: ["none","md5","sha","sha2_256"]
	AuthenticationProtocol *string `json:"authentication_protocol,omitempty"`

	// Privacy protocol password.
	// Example: p@**GOandCLCt*200
	// Min Length: 8
	PrivacyPassword *string `json:"privacy_password,omitempty"`

	// Privacy protocol.
	// Example: aes128
	// Enum: ["none","des","aes128"]
	PrivacyProtocol *string `json:"privacy_protocol,omitempty"`
}

// Validate validates this snmp user inline snmpv3
func (o *SnmpUserInlineSnmpv3) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateAuthenticationPassword(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateAuthenticationProtocol(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validatePrivacyPassword(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validatePrivacyProtocol(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SnmpUserInlineSnmpv3) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "snmpv3" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *SnmpUserInlineSnmpv3) validateAuthenticationPassword(formats strfmt.Registry) error {
	if swag.IsZero(o.AuthenticationPassword) { // not required
		return nil
	}

	if err := validate.MinLength("info"+"."+"snmpv3"+"."+"authentication_password", "body", *o.AuthenticationPassword, 8); err != nil {
		return err
	}

	return nil
}

var snmpUserInlineSnmpv3TypeAuthenticationProtocolPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["none","md5","sha","sha2_256"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		snmpUserInlineSnmpv3TypeAuthenticationProtocolPropEnum = append(snmpUserInlineSnmpv3TypeAuthenticationProtocolPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// snmp_user_inline_snmpv3
	// SnmpUserInlineSnmpv3
	// authentication_protocol
	// AuthenticationProtocol
	// none
	// END DEBUGGING
	// SnmpUserInlineSnmpv3AuthenticationProtocolNone captures enum value "none"
	SnmpUserInlineSnmpv3AuthenticationProtocolNone string = "none"

	// BEGIN DEBUGGING
	// snmp_user_inline_snmpv3
	// SnmpUserInlineSnmpv3
	// authentication_protocol
	// AuthenticationProtocol
	// md5
	// END DEBUGGING
	// SnmpUserInlineSnmpv3AuthenticationProtocolMd5 captures enum value "md5"
	SnmpUserInlineSnmpv3AuthenticationProtocolMd5 string = "md5"

	// BEGIN DEBUGGING
	// snmp_user_inline_snmpv3
	// SnmpUserInlineSnmpv3
	// authentication_protocol
	// AuthenticationProtocol
	// sha
	// END DEBUGGING
	// SnmpUserInlineSnmpv3AuthenticationProtocolSha captures enum value "sha"
	SnmpUserInlineSnmpv3AuthenticationProtocolSha string = "sha"

	// BEGIN DEBUGGING
	// snmp_user_inline_snmpv3
	// SnmpUserInlineSnmpv3
	// authentication_protocol
	// AuthenticationProtocol
	// sha2_256
	// END DEBUGGING
	// SnmpUserInlineSnmpv3AuthenticationProtocolSha2256 captures enum value "sha2_256"
	SnmpUserInlineSnmpv3AuthenticationProtocolSha2256 string = "sha2_256"
)

// prop value enum
func (o *SnmpUserInlineSnmpv3) validateAuthenticationProtocolEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, snmpUserInlineSnmpv3TypeAuthenticationProtocolPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *SnmpUserInlineSnmpv3) validateAuthenticationProtocol(formats strfmt.Registry) error {
	if swag.IsZero(o.AuthenticationProtocol) { // not required
		return nil
	}

	// value enum
	if err := o.validateAuthenticationProtocolEnum("info"+"."+"snmpv3"+"."+"authentication_protocol", "body", *o.AuthenticationProtocol); err != nil {
		return err
	}

	return nil
}

func (o *SnmpUserInlineSnmpv3) validatePrivacyPassword(formats strfmt.Registry) error {
	if swag.IsZero(o.PrivacyPassword) { // not required
		return nil
	}

	if err := validate.MinLength("info"+"."+"snmpv3"+"."+"privacy_password", "body", *o.PrivacyPassword, 8); err != nil {
		return err
	}

	return nil
}

var snmpUserInlineSnmpv3TypePrivacyProtocolPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["none","des","aes128"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		snmpUserInlineSnmpv3TypePrivacyProtocolPropEnum = append(snmpUserInlineSnmpv3TypePrivacyProtocolPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// snmp_user_inline_snmpv3
	// SnmpUserInlineSnmpv3
	// privacy_protocol
	// PrivacyProtocol
	// none
	// END DEBUGGING
	// SnmpUserInlineSnmpv3PrivacyProtocolNone captures enum value "none"
	SnmpUserInlineSnmpv3PrivacyProtocolNone string = "none"

	// BEGIN DEBUGGING
	// snmp_user_inline_snmpv3
	// SnmpUserInlineSnmpv3
	// privacy_protocol
	// PrivacyProtocol
	// des
	// END DEBUGGING
	// SnmpUserInlineSnmpv3PrivacyProtocolDes captures enum value "des"
	SnmpUserInlineSnmpv3PrivacyProtocolDes string = "des"

	// BEGIN DEBUGGING
	// snmp_user_inline_snmpv3
	// SnmpUserInlineSnmpv3
	// privacy_protocol
	// PrivacyProtocol
	// aes128
	// END DEBUGGING
	// SnmpUserInlineSnmpv3PrivacyProtocolAes128 captures enum value "aes128"
	SnmpUserInlineSnmpv3PrivacyProtocolAes128 string = "aes128"
)

// prop value enum
func (o *SnmpUserInlineSnmpv3) validatePrivacyProtocolEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, snmpUserInlineSnmpv3TypePrivacyProtocolPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *SnmpUserInlineSnmpv3) validatePrivacyProtocol(formats strfmt.Registry) error {
	if swag.IsZero(o.PrivacyProtocol) { // not required
		return nil
	}

	// value enum
	if err := o.validatePrivacyProtocolEnum("info"+"."+"snmpv3"+"."+"privacy_protocol", "body", *o.PrivacyProtocol); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this snmp user inline snmpv3 based on the context it is used
func (o *SnmpUserInlineSnmpv3) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SnmpUserInlineSnmpv3) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "snmpv3" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SnmpUserInlineSnmpv3) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SnmpUserInlineSnmpv3) UnmarshalBinary(b []byte) error {
	var res SnmpUserInlineSnmpv3
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SnmpUserInlineSnmpv3InlineLinks snmp user inline snmpv3 inline links
swagger:model snmp_user_inline_snmpv3_inline__links
*/
type SnmpUserInlineSnmpv3InlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this snmp user inline snmpv3 inline links
func (o *SnmpUserInlineSnmpv3InlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SnmpUserInlineSnmpv3InlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "snmpv3" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this snmp user inline snmpv3 inline links based on the context it is used
func (o *SnmpUserInlineSnmpv3InlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SnmpUserInlineSnmpv3InlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "snmpv3" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SnmpUserInlineSnmpv3InlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SnmpUserInlineSnmpv3InlineLinks) UnmarshalBinary(b []byte) error {
	var res SnmpUserInlineSnmpv3InlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
