// Code generated by go-swagger; DO NOT EDIT.

package support

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewSnmpUsersModifyParams creates a new SnmpUsersModifyParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSnmpUsersModifyParams() *SnmpUsersModifyParams {
	return &SnmpUsersModifyParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSnmpUsersModifyParamsWithTimeout creates a new SnmpUsersModifyParams object
// with the ability to set a timeout on a request.
func NewSnmpUsersModifyParamsWithTimeout(timeout time.Duration) *SnmpUsersModifyParams {
	return &SnmpUsersModifyParams{
		timeout: timeout,
	}
}

// NewSnmpUsersModifyParamsWithContext creates a new SnmpUsersModifyParams object
// with the ability to set a context for a request.
func NewSnmpUsersModifyParamsWithContext(ctx context.Context) *SnmpUsersModifyParams {
	return &SnmpUsersModifyParams{
		Context: ctx,
	}
}

// NewSnmpUsersModifyParamsWithHTTPClient creates a new SnmpUsersModifyParams object
// with the ability to set a custom HTTPClient for a request.
func NewSnmpUsersModifyParamsWithHTTPClient(client *http.Client) *SnmpUsersModifyParams {
	return &SnmpUsersModifyParams{
		HTTPClient: client,
	}
}

/*
SnmpUsersModifyParams contains all the parameters to send to the API endpoint

	for the snmp users modify operation.

	Typically these are written to a http.Request.
*/
type SnmpUsersModifyParams struct {

	/* EngineID.

	   Engine ID of owning SVM or remote switch.
	*/
	EngineID string

	/* Info.

	   Info specification
	*/
	Info *models.SnmpUser

	/* Name.

	   SNMP user name.
	*/
	Name string

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning. When doing a POST, PATCH, or DELETE operation on a single record, the default is 0 seconds.  This means that if an asynchronous operation is started, the server immediately returns HTTP code 202 (Accepted) along with a link to the job.  If a non-zero value is specified for POST, PATCH, or DELETE operations, ONTAP waits that length of time to see if the job completes so it can return something other than 202.
	*/
	ReturnTimeout *int64

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the snmp users modify params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SnmpUsersModifyParams) WithDefaults() *SnmpUsersModifyParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the snmp users modify params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SnmpUsersModifyParams) SetDefaults() {
	var (
		returnTimeoutDefault = int64(0)
	)

	val := SnmpUsersModifyParams{
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the snmp users modify params
func (o *SnmpUsersModifyParams) WithTimeout(timeout time.Duration) *SnmpUsersModifyParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the snmp users modify params
func (o *SnmpUsersModifyParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the snmp users modify params
func (o *SnmpUsersModifyParams) WithContext(ctx context.Context) *SnmpUsersModifyParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the snmp users modify params
func (o *SnmpUsersModifyParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the snmp users modify params
func (o *SnmpUsersModifyParams) WithHTTPClient(client *http.Client) *SnmpUsersModifyParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the snmp users modify params
func (o *SnmpUsersModifyParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithEngineID adds the engineID to the snmp users modify params
func (o *SnmpUsersModifyParams) WithEngineID(engineID string) *SnmpUsersModifyParams {
	o.SetEngineID(engineID)
	return o
}

// SetEngineID adds the engineId to the snmp users modify params
func (o *SnmpUsersModifyParams) SetEngineID(engineID string) {
	o.EngineID = engineID
}

// WithInfo adds the info to the snmp users modify params
func (o *SnmpUsersModifyParams) WithInfo(info *models.SnmpUser) *SnmpUsersModifyParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the snmp users modify params
func (o *SnmpUsersModifyParams) SetInfo(info *models.SnmpUser) {
	o.Info = info
}

// WithName adds the name to the snmp users modify params
func (o *SnmpUsersModifyParams) WithName(name string) *SnmpUsersModifyParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the snmp users modify params
func (o *SnmpUsersModifyParams) SetName(name string) {
	o.Name = name
}

// WithReturnTimeout adds the returnTimeout to the snmp users modify params
func (o *SnmpUsersModifyParams) WithReturnTimeout(returnTimeout *int64) *SnmpUsersModifyParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the snmp users modify params
func (o *SnmpUsersModifyParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WriteToRequest writes these params to a swagger request
func (o *SnmpUsersModifyParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param engine_id
	if err := r.SetPathParam("engine_id", o.EngineID); err != nil {
		return err
	}
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	// path param name
	if err := r.SetPathParam("name", o.Name); err != nil {
		return err
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
