// Code generated by go-swagger; DO NOT EDIT.

package support

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
)

// New creates a new support API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

/*
Client for support API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption is the option for Client methods
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	AutoUpdateConfigurationCollectionGet(params *AutoUpdateConfigurationCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AutoUpdateConfigurationCollectionGetOK, error)

	AutoUpdateConfigurationGet(params *AutoUpdateConfigurationGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AutoUpdateConfigurationGetOK, error)

	AutoUpdateConfigurationModify(params *AutoUpdateConfigurationModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AutoUpdateConfigurationModifyOK, error)

	AutoUpdateConfigurationModifyCollection(params *AutoUpdateConfigurationModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AutoUpdateConfigurationModifyCollectionOK, error)

	AutoUpdateInfoGet(params *AutoUpdateInfoGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AutoUpdateInfoGetOK, error)

	AutoUpdateInfoModify(params *AutoUpdateInfoModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AutoUpdateInfoModifyOK, error)

	AutoUpdateStatusCollectionGet(params *AutoUpdateStatusCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AutoUpdateStatusCollectionGetOK, error)

	AutoUpdateStatusGet(params *AutoUpdateStatusGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AutoUpdateStatusGetOK, error)

	AutoUpdateStatusModify(params *AutoUpdateStatusModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AutoUpdateStatusModifyOK, error)

	AutoUpdateStatusModifyCollection(params *AutoUpdateStatusModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AutoUpdateStatusModifyCollectionOK, error)

	AutosupportCreate(params *AutosupportCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AutosupportCreateCreated, error)

	AutosupportGet(params *AutosupportGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AutosupportGetOK, error)

	AutosupportMessageCollectionGet(params *AutosupportMessageCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AutosupportMessageCollectionGetOK, error)

	AutosupportMessageGet(params *AutosupportMessageGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AutosupportMessageGetOK, error)

	AutosupportModify(params *AutosupportModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AutosupportModifyOK, error)

	ConfigurationBackupFileCollectionGet(params *ConfigurationBackupFileCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ConfigurationBackupFileCollectionGetOK, error)

	ConfigurationBackupFileCreate(params *ConfigurationBackupFileCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ConfigurationBackupFileCreateCreated, *ConfigurationBackupFileCreateAccepted, error)

	ConfigurationBackupFileDelete(params *ConfigurationBackupFileDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ConfigurationBackupFileDeleteOK, error)

	ConfigurationBackupFileDeleteCollection(params *ConfigurationBackupFileDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ConfigurationBackupFileDeleteCollectionOK, error)

	ConfigurationBackupFileGet(params *ConfigurationBackupFileGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ConfigurationBackupFileGetOK, error)

	ConfigurationBackupGet(params *ConfigurationBackupGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ConfigurationBackupGetOK, error)

	ConfigurationBackupModify(params *ConfigurationBackupModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ConfigurationBackupModifyOK, error)

	CoredumpCollectionGet(params *CoredumpCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CoredumpCollectionGetOK, error)

	CoredumpDelete(params *CoredumpDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CoredumpDeleteOK, error)

	CoredumpDeleteCollection(params *CoredumpDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CoredumpDeleteCollectionOK, error)

	CoredumpGet(params *CoredumpGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CoredumpGetOK, error)

	EmsApplicationLogsCreate(params *EmsApplicationLogsCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*EmsApplicationLogsCreateCreated, error)

	EmsConfigGet(params *EmsConfigGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*EmsConfigGetOK, error)

	EmsConfigModify(params *EmsConfigModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*EmsConfigModifyOK, error)

	EmsDestinationCollectionGet(params *EmsDestinationCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*EmsDestinationCollectionGetOK, error)

	EmsDestinationCreate(params *EmsDestinationCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*EmsDestinationCreateCreated, error)

	EmsDestinationDelete(params *EmsDestinationDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*EmsDestinationDeleteOK, error)

	EmsDestinationDeleteCollection(params *EmsDestinationDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*EmsDestinationDeleteCollectionOK, error)

	EmsDestinationGet(params *EmsDestinationGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*EmsDestinationGetOK, error)

	EmsDestinationModify(params *EmsDestinationModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*EmsDestinationModifyOK, error)

	EmsDestinationModifyCollection(params *EmsDestinationModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*EmsDestinationModifyCollectionOK, error)

	EmsEventCollectionGet(params *EmsEventCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*EmsEventCollectionGetOK, error)

	EmsFilterCollectionGet(params *EmsFilterCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*EmsFilterCollectionGetOK, error)

	EmsFilterCreate(params *EmsFilterCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*EmsFilterCreateCreated, error)

	EmsFilterDelete(params *EmsFilterDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*EmsFilterDeleteOK, error)

	EmsFilterDeleteCollection(params *EmsFilterDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*EmsFilterDeleteCollectionOK, error)

	EmsFilterGet(params *EmsFilterGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*EmsFilterGetOK, error)

	EmsFilterModify(params *EmsFilterModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*EmsFilterModifyOK, error)

	EmsFilterModifyCollection(params *EmsFilterModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*EmsFilterModifyCollectionOK, error)

	EmsFilterRuleCollectionGet(params *EmsFilterRuleCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*EmsFilterRuleCollectionGetOK, error)

	EmsFilterRuleDelete(params *EmsFilterRuleDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*EmsFilterRuleDeleteOK, error)

	EmsFilterRuleDeleteCollection(params *EmsFilterRuleDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*EmsFilterRuleDeleteCollectionOK, error)

	EmsFilterRuleGet(params *EmsFilterRuleGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*EmsFilterRuleGetOK, error)

	EmsFilterRuleModify(params *EmsFilterRuleModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*EmsFilterRuleModifyOK, error)

	EmsFilterRuleModifyCollection(params *EmsFilterRuleModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*EmsFilterRuleModifyCollectionOK, error)

	EmsFiltersRulesCreate(params *EmsFiltersRulesCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*EmsFiltersRulesCreateCreated, error)

	EmsMessageCollectionGet(params *EmsMessageCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*EmsMessageCollectionGetOK, error)

	EmsRoleConfigCollectionGet(params *EmsRoleConfigCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*EmsRoleConfigCollectionGetOK, error)

	EmsRoleConfigCreate(params *EmsRoleConfigCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*EmsRoleConfigCreateCreated, error)

	EmsRoleConfigDelete(params *EmsRoleConfigDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*EmsRoleConfigDeleteOK, error)

	EmsRoleConfigDeleteCollection(params *EmsRoleConfigDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*EmsRoleConfigDeleteCollectionOK, error)

	EmsRoleConfigGet(params *EmsRoleConfigGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*EmsRoleConfigGetOK, error)

	EmsRoleConfigModify(params *EmsRoleConfigModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*EmsRoleConfigModifyOK, error)

	EmsRoleConfigModifyCollection(params *EmsRoleConfigModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*EmsRoleConfigModifyCollectionOK, error)

	SnmpGet(params *SnmpGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnmpGetOK, error)

	SnmpModify(params *SnmpModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnmpModifyOK, error)

	SnmpTraphostsCollectionGet(params *SnmpTraphostsCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnmpTraphostsCollectionGetOK, error)

	SnmpTraphostsCreate(params *SnmpTraphostsCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnmpTraphostsCreateCreated, error)

	SnmpTraphostsDelete(params *SnmpTraphostsDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnmpTraphostsDeleteOK, error)

	SnmpTraphostsDeleteCollection(params *SnmpTraphostsDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnmpTraphostsDeleteCollectionOK, error)

	SnmpTraphostsGet(params *SnmpTraphostsGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnmpTraphostsGetOK, error)

	SnmpUsersCollectionGet(params *SnmpUsersCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnmpUsersCollectionGetOK, error)

	SnmpUsersCreate(params *SnmpUsersCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnmpUsersCreateCreated, error)

	SnmpUsersDelete(params *SnmpUsersDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnmpUsersDeleteOK, error)

	SnmpUsersDeleteCollection(params *SnmpUsersDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnmpUsersDeleteCollectionOK, error)

	SnmpUsersGet(params *SnmpUsersGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnmpUsersGetOK, error)

	SnmpUsersModify(params *SnmpUsersModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnmpUsersModifyOK, error)

	SnmpUsersModifyCollection(params *SnmpUsersModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnmpUsersModifyCollectionOK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
AutoUpdateConfigurationCollectionGet Retrieves the configuration for automatic updates.
*/
func (a *Client) AutoUpdateConfigurationCollectionGet(params *AutoUpdateConfigurationCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AutoUpdateConfigurationCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAutoUpdateConfigurationCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "auto_update_configuration_collection_get",
		Method:             "GET",
		PathPattern:        "/support/auto-update/configurations",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AutoUpdateConfigurationCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*AutoUpdateConfigurationCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*AutoUpdateConfigurationCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
AutoUpdateConfigurationGet Retrieves the configuration for a specified automatic update.
*/
func (a *Client) AutoUpdateConfigurationGet(params *AutoUpdateConfigurationGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AutoUpdateConfigurationGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAutoUpdateConfigurationGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "auto_update_configuration_get",
		Method:             "GET",
		PathPattern:        "/support/auto-update/configurations/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AutoUpdateConfigurationGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*AutoUpdateConfigurationGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*AutoUpdateConfigurationGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
AutoUpdateConfigurationModify Updates the configuration for a specified automatic update.
*/
func (a *Client) AutoUpdateConfigurationModify(params *AutoUpdateConfigurationModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AutoUpdateConfigurationModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAutoUpdateConfigurationModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "auto_update_configuration_modify",
		Method:             "PATCH",
		PathPattern:        "/support/auto-update/configurations/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AutoUpdateConfigurationModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*AutoUpdateConfigurationModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*AutoUpdateConfigurationModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
AutoUpdateConfigurationModifyCollection auto update configuration modify collection API
*/
func (a *Client) AutoUpdateConfigurationModifyCollection(params *AutoUpdateConfigurationModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AutoUpdateConfigurationModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAutoUpdateConfigurationModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "auto_update_configuration_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/support/auto-update/configurations",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AutoUpdateConfigurationModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*AutoUpdateConfigurationModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*AutoUpdateConfigurationModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
AutoUpdateInfoGet Retrieves the current status of the automatic update feature and the End User License Agreement (EULA).
*/
func (a *Client) AutoUpdateInfoGet(params *AutoUpdateInfoGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AutoUpdateInfoGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAutoUpdateInfoGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "auto_update_info_get",
		Method:             "GET",
		PathPattern:        "/support/auto-update",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AutoUpdateInfoGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*AutoUpdateInfoGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*AutoUpdateInfoGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
AutoUpdateInfoModify Updates the current enabled status of the automatic update feature and accepts the EULA.
*/
func (a *Client) AutoUpdateInfoModify(params *AutoUpdateInfoModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AutoUpdateInfoModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAutoUpdateInfoModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "auto_update_info_modify",
		Method:             "PATCH",
		PathPattern:        "/support/auto-update",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AutoUpdateInfoModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*AutoUpdateInfoModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*AutoUpdateInfoModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
AutoUpdateStatusCollectionGet Retrieves the status of all updates.
*/
func (a *Client) AutoUpdateStatusCollectionGet(params *AutoUpdateStatusCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AutoUpdateStatusCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAutoUpdateStatusCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "auto_update_status_collection_get",
		Method:             "GET",
		PathPattern:        "/support/auto-update/updates",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AutoUpdateStatusCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*AutoUpdateStatusCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*AutoUpdateStatusCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
AutoUpdateStatusGet Retrieves the status of an update.
*/
func (a *Client) AutoUpdateStatusGet(params *AutoUpdateStatusGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AutoUpdateStatusGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAutoUpdateStatusGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "auto_update_status_get",
		Method:             "GET",
		PathPattern:        "/support/auto-update/updates/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AutoUpdateStatusGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*AutoUpdateStatusGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*AutoUpdateStatusGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
AutoUpdateStatusModify Perform an action on the update.
*/
func (a *Client) AutoUpdateStatusModify(params *AutoUpdateStatusModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AutoUpdateStatusModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAutoUpdateStatusModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "auto_update_status_modify",
		Method:             "PATCH",
		PathPattern:        "/support/auto-update/updates/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AutoUpdateStatusModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*AutoUpdateStatusModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*AutoUpdateStatusModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
AutoUpdateStatusModifyCollection auto update status modify collection API
*/
func (a *Client) AutoUpdateStatusModifyCollection(params *AutoUpdateStatusModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AutoUpdateStatusModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAutoUpdateStatusModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "auto_update_status_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/support/auto-update/updates",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AutoUpdateStatusModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*AutoUpdateStatusModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*AutoUpdateStatusModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	AutosupportCreate Creates and sends an AutoSupport message with the provided input parameters.<p/>

Important note:
* By default, the response is an empty object. If `return_records=true` is passed in the request, the response includes information about the node and the index of the invoked AutoSupport message.
### Recommended optional properties
* `message` - Message included in the AutoSupport subject. Use this to identify the generated AutoSupport message.
### Default property values
If not specified in POST, the following are the default property values:
* `type` - _all_
* `node.name` or `node.uuid` - Not specifying these properties invokes AutoSupport on all nodes in the cluster.
### Related ONTAP commands
* `system node autosupport invoke`
### Learn more
* [`DOC /support/autosupport/messages`](#docs-support-support_autosupport_messages)
*/
func (a *Client) AutosupportCreate(params *AutosupportCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AutosupportCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAutosupportCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "autosupport_create",
		Method:             "POST",
		PathPattern:        "/support/autosupport/messages",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AutosupportCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*AutosupportCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*AutosupportCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	AutosupportGet Retrieves the AutoSupport configuration of the cluster and if requested, returns connectivity issues with the AutoSupport configuration.<p/>

</br>Important note:
* The **issues** field consists of a list of objects containing details of the node that has a connectivity issue, the issue description, and corrective action you can take to address the issue. When not empty, this indicates a connection issue to the **HTTPS**, **SMTP**, or **AutoSupport On Demand** server.
### Expensive properties
There is an added computational cost to retrieving values for these properties. They are not included by default in GET results and must be explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.
* `issues`
### Related ONTAP commands
* `system node autosupport show -instance`
* `system node autosupport check show-details`
### Learn more
* [`DOC /support/autosupport`](#docs-support-support_autosupport)
*/
func (a *Client) AutosupportGet(params *AutosupportGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AutosupportGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAutosupportGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "autosupport_get",
		Method:             "GET",
		PathPattern:        "/support/autosupport",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AutosupportGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*AutosupportGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*AutosupportGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	AutosupportMessageCollectionGet Retrieves AutoSupport message history from all nodes in the cluster.<p/>

There can be a short delay on invoked AutoSupport messages showing in history, dependent on processing of other AutoSupports in the queue.
### Related ONTAP commands
* `system node autosupport history show`
### Learn more
* [`DOC /support/autosupport/messages`](#docs-support-support_autosupport_messages)
*/
func (a *Client) AutosupportMessageCollectionGet(params *AutosupportMessageCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AutosupportMessageCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAutosupportMessageCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "autosupport_message_collection_get",
		Method:             "GET",
		PathPattern:        "/support/autosupport/messages",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AutosupportMessageCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*AutosupportMessageCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*AutosupportMessageCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
AutosupportMessageGet Retrieves information about a single Autosupport message.
*/
func (a *Client) AutosupportMessageGet(params *AutosupportMessageGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AutosupportMessageGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAutosupportMessageGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "autosupport_message_get",
		Method:             "GET",
		PathPattern:        "/support/autosupport/messages/{node.uuid}/{index}/{destination}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AutosupportMessageGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*AutosupportMessageGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*AutosupportMessageGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	AutosupportModify Updates the AutoSupport configuration for the entire cluster.

### Related ONTAP commands
* `system node autosupport modify`
### Learn more
* [`DOC /support/autosupport`](#docs-support-support_autosupport)
*/
func (a *Client) AutosupportModify(params *AutosupportModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AutosupportModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAutosupportModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "autosupport_modify",
		Method:             "PATCH",
		PathPattern:        "/support/autosupport",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AutosupportModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*AutosupportModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*AutosupportModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ConfigurationBackupFileCollectionGet Retrieves a list of configuration backup files.

### Related ONTAP commands
* `system configuration backup show`
*/
func (a *Client) ConfigurationBackupFileCollectionGet(params *ConfigurationBackupFileCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ConfigurationBackupFileCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewConfigurationBackupFileCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "configuration_backup_file_collection_get",
		Method:             "GET",
		PathPattern:        "/support/configuration-backup/backups",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ConfigurationBackupFileCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ConfigurationBackupFileCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ConfigurationBackupFileCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ConfigurationBackupFileCreate Creates a configuration backup. The required backup file name must end with .7z extension.

### Required properties
* `node.uuid` or `node.name` - The node UUID or node name on which the configuration backup will be created.
* `name` - The backup file name
### Related ONTAP commands
* `system configuration backup create`
*/
func (a *Client) ConfigurationBackupFileCreate(params *ConfigurationBackupFileCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ConfigurationBackupFileCreateCreated, *ConfigurationBackupFileCreateAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewConfigurationBackupFileCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "configuration_backup_file_create",
		Method:             "POST",
		PathPattern:        "/support/configuration-backup/backups",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ConfigurationBackupFileCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *ConfigurationBackupFileCreateCreated:
		return value, nil, nil
	case *ConfigurationBackupFileCreateAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ConfigurationBackupFileCreateDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ConfigurationBackupFileDelete Deletes a configuration backup.

### Related ONTAP commands
* `system configuration backup delete`
*/
func (a *Client) ConfigurationBackupFileDelete(params *ConfigurationBackupFileDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ConfigurationBackupFileDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewConfigurationBackupFileDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "configuration_backup_file_delete",
		Method:             "DELETE",
		PathPattern:        "/support/configuration-backup/backups/{node.uuid}/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ConfigurationBackupFileDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ConfigurationBackupFileDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ConfigurationBackupFileDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ConfigurationBackupFileDeleteCollection configuration backup file delete collection API
*/
func (a *Client) ConfigurationBackupFileDeleteCollection(params *ConfigurationBackupFileDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ConfigurationBackupFileDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewConfigurationBackupFileDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "configuration_backup_file_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/support/configuration-backup/backups",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ConfigurationBackupFileDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ConfigurationBackupFileDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ConfigurationBackupFileDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ConfigurationBackupFileGet Retrieves details of the specified configuration backup file.

### Related ONTAP commands
* `system configuration backup show`
*/
func (a *Client) ConfigurationBackupFileGet(params *ConfigurationBackupFileGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ConfigurationBackupFileGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewConfigurationBackupFileGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "configuration_backup_file_get",
		Method:             "GET",
		PathPattern:        "/support/configuration-backup/backups/{node.uuid}/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ConfigurationBackupFileGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ConfigurationBackupFileGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ConfigurationBackupFileGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ConfigurationBackupGet Retrieves the cluster configuration backup information.
*/
func (a *Client) ConfigurationBackupGet(params *ConfigurationBackupGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ConfigurationBackupGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewConfigurationBackupGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "configuration_backup_get",
		Method:             "GET",
		PathPattern:        "/support/configuration-backup",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ConfigurationBackupGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ConfigurationBackupGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ConfigurationBackupGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ConfigurationBackupModify Updates the cluster configuration backup information.
*/
func (a *Client) ConfigurationBackupModify(params *ConfigurationBackupModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ConfigurationBackupModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewConfigurationBackupModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "configuration_backup_modify",
		Method:             "PATCH",
		PathPattern:        "/support/configuration-backup",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ConfigurationBackupModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ConfigurationBackupModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ConfigurationBackupModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	CoredumpCollectionGet Retrieves a collection of coredumps.

### Related ONTAP commands
* `system node coredump show`
*/
func (a *Client) CoredumpCollectionGet(params *CoredumpCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CoredumpCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCoredumpCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "coredump_collection_get",
		Method:             "GET",
		PathPattern:        "/support/coredump/coredumps",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CoredumpCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CoredumpCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CoredumpCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	CoredumpDelete Deletes a core dump.

### Related ONTAP commands
* `system node coredump delete`
*/
func (a *Client) CoredumpDelete(params *CoredumpDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CoredumpDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCoredumpDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "coredump_delete",
		Method:             "DELETE",
		PathPattern:        "/support/coredump/coredumps/{node.uuid}/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CoredumpDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CoredumpDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CoredumpDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
CoredumpDeleteCollection coredump delete collection API
*/
func (a *Client) CoredumpDeleteCollection(params *CoredumpDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CoredumpDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCoredumpDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "coredump_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/support/coredump/coredumps",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CoredumpDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CoredumpDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CoredumpDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	CoredumpGet Retrieves a specific core dump.

### Related ONTAP commands
* `system node coredump show`
*/
func (a *Client) CoredumpGet(params *CoredumpGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CoredumpGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCoredumpGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "coredump_get",
		Method:             "GET",
		PathPattern:        "/support/coredump/coredumps/{node.uuid}/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CoredumpGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CoredumpGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CoredumpGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	EmsApplicationLogsCreate Creates an app.log.* event. Setting the "autosupport_required" flag causes callhome.client.app.* events also to be generated, which in turn triggers AutoSupports.

### Required properties
* `computer_name` - Client computer connected to the cluster.
* `event_source` - Client application that generated this event.
* `app_version` - Client application version.
* `event_id` - Application eventID.
* `category` - Event category.
* `event_description` - Event description.
* `severity` - Severity of the event.
* `autosupport_required` - Indicates whether AutoSupport generation is required.
*/
func (a *Client) EmsApplicationLogsCreate(params *EmsApplicationLogsCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*EmsApplicationLogsCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewEmsApplicationLogsCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ems_application_logs_create",
		Method:             "POST",
		PathPattern:        "/support/ems/application-logs",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &EmsApplicationLogsCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*EmsApplicationLogsCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*EmsApplicationLogsCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	EmsConfigGet Retrieves the EMS configuration.

### Related ONTAP commands
* `event config show`
*/
func (a *Client) EmsConfigGet(params *EmsConfigGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*EmsConfigGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewEmsConfigGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ems_config_get",
		Method:             "GET",
		PathPattern:        "/support/ems",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &EmsConfigGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*EmsConfigGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*EmsConfigGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	EmsConfigModify Updates the EMS configuration.

### Related ONTAP commands
* `event config modify`
*/
func (a *Client) EmsConfigModify(params *EmsConfigModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*EmsConfigModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewEmsConfigModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ems_config_modify",
		Method:             "PATCH",
		PathPattern:        "/support/ems",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &EmsConfigModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*EmsConfigModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*EmsConfigModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	EmsDestinationCollectionGet Retrieves a collection of event destinations.

### Related ONTAP commands
* `event notification destination show`
* `event notification show`
*/
func (a *Client) EmsDestinationCollectionGet(params *EmsDestinationCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*EmsDestinationCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewEmsDestinationCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ems_destination_collection_get",
		Method:             "GET",
		PathPattern:        "/support/ems/destinations",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &EmsDestinationCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*EmsDestinationCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*EmsDestinationCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	EmsDestinationCreate Creates an event destination.

### Required properties
* `name` - String that uniquely identifies the destination.
* `type` - Type of destination that is to be created.
* `destination` - String that identifies the destination. The contents of this property changes depending on type.
### Recommended optional properties
* `filters.name` - List of filter names that should direct to this destination.
* `certificate` - When specifying a rest api destination, a client certificate can be provided.
* `syslog` - When specifying a syslog destination, a port, transport protocol, message format, timestamp format and hostname format can be provided.
### Related ONTAP commands
* `event notification destination create`
* `event notification create`
*/
func (a *Client) EmsDestinationCreate(params *EmsDestinationCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*EmsDestinationCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewEmsDestinationCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ems_destination_create",
		Method:             "POST",
		PathPattern:        "/support/ems/destinations",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &EmsDestinationCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*EmsDestinationCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*EmsDestinationCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	EmsDestinationDelete Deletes an event destination.

### Related ONTAP commands
* `event notification destination delete`
* `event notification delete`
*/
func (a *Client) EmsDestinationDelete(params *EmsDestinationDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*EmsDestinationDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewEmsDestinationDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ems_destination_delete",
		Method:             "DELETE",
		PathPattern:        "/support/ems/destinations/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &EmsDestinationDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*EmsDestinationDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*EmsDestinationDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
EmsDestinationDeleteCollection ems destination delete collection API
*/
func (a *Client) EmsDestinationDeleteCollection(params *EmsDestinationDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*EmsDestinationDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewEmsDestinationDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ems_destination_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/support/ems/destinations",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &EmsDestinationDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*EmsDestinationDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*EmsDestinationDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	EmsDestinationGet Retrieves event destinations.

### Expensive properties
There is an added computational cost to retrieving values for these properties. They are not included by default in GET results and must be explicitly requested using the `fields` query parameter.
* `connectivity.*`
### Related ONTAP commands
* `event notification destination show`
* `event notification show`
*/
func (a *Client) EmsDestinationGet(params *EmsDestinationGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*EmsDestinationGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewEmsDestinationGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ems_destination_get",
		Method:             "GET",
		PathPattern:        "/support/ems/destinations/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &EmsDestinationGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*EmsDestinationGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*EmsDestinationGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	EmsDestinationModify Updates an event destination.

### Recommended optional properties
* `filters.name` - New list of filters that should direct to this destination. The existing list is discarded.
* `certificate` - New certificate parameters when the destination type is `rest api`.
### Related ONTAP commands
* `event notification destination modify`
* `event notification modify`
*/
func (a *Client) EmsDestinationModify(params *EmsDestinationModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*EmsDestinationModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewEmsDestinationModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ems_destination_modify",
		Method:             "PATCH",
		PathPattern:        "/support/ems/destinations/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &EmsDestinationModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*EmsDestinationModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*EmsDestinationModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
EmsDestinationModifyCollection ems destination modify collection API
*/
func (a *Client) EmsDestinationModifyCollection(params *EmsDestinationModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*EmsDestinationModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewEmsDestinationModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ems_destination_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/support/ems/destinations",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &EmsDestinationModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*EmsDestinationModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*EmsDestinationModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	EmsEventCollectionGet Retrieves a collection of observed events.

###
Note: The default behavior is to filter 'DEBUG' severity events. If those events are required, a severity query must be provided.
### Related ONTAP commands
* `event log show`
*/
func (a *Client) EmsEventCollectionGet(params *EmsEventCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*EmsEventCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewEmsEventCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ems_event_collection_get",
		Method:             "GET",
		PathPattern:        "/support/ems/events",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &EmsEventCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*EmsEventCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*EmsEventCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	EmsFilterCollectionGet Retrieves a collection of event filters.

### Related ONTAP commands
* `event filter show`
*/
func (a *Client) EmsFilterCollectionGet(params *EmsFilterCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*EmsFilterCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewEmsFilterCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ems_filter_collection_get",
		Method:             "GET",
		PathPattern:        "/support/ems/filters",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &EmsFilterCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*EmsFilterCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*EmsFilterCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	EmsFilterCreate Creates an event filter.

### Required properties
* `name` - String that uniquely identifies the filter.
### Recommended optional properties
* `rules` - List of criteria which is used to match a filter with an event.
### Related ONTAP commands
* `event filter create`
*/
func (a *Client) EmsFilterCreate(params *EmsFilterCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*EmsFilterCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewEmsFilterCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ems_filter_create",
		Method:             "POST",
		PathPattern:        "/support/ems/filters",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &EmsFilterCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*EmsFilterCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*EmsFilterCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	EmsFilterDelete Deletes an event filter.

### Related ONTAP commands
* `event filter delete`
*/
func (a *Client) EmsFilterDelete(params *EmsFilterDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*EmsFilterDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewEmsFilterDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ems_filter_delete",
		Method:             "DELETE",
		PathPattern:        "/support/ems/filters/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &EmsFilterDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*EmsFilterDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*EmsFilterDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
EmsFilterDeleteCollection ems filter delete collection API
*/
func (a *Client) EmsFilterDeleteCollection(params *EmsFilterDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*EmsFilterDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewEmsFilterDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ems_filter_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/support/ems/filters",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &EmsFilterDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*EmsFilterDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*EmsFilterDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	EmsFilterGet Retrieves an event filter.

### Related ONTAP commands
* `event filter show`
*/
func (a *Client) EmsFilterGet(params *EmsFilterGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*EmsFilterGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewEmsFilterGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ems_filter_get",
		Method:             "GET",
		PathPattern:        "/support/ems/filters/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &EmsFilterGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*EmsFilterGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*EmsFilterGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	EmsFilterModify Updates an event filter.

### Recommended optional properties
* `new_name` - New string that uniquely identifies a filter.
* `rules` - New list of criteria used to match the filter with an event. The existing list is discarded.
### Related ONTAP commands
* `event filter rename`
* `event filter rule add`
* `event filter rule delete`
* `event filter rule reorder`
*/
func (a *Client) EmsFilterModify(params *EmsFilterModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*EmsFilterModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewEmsFilterModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ems_filter_modify",
		Method:             "PATCH",
		PathPattern:        "/support/ems/filters/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &EmsFilterModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*EmsFilterModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*EmsFilterModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
EmsFilterModifyCollection ems filter modify collection API
*/
func (a *Client) EmsFilterModifyCollection(params *EmsFilterModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*EmsFilterModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewEmsFilterModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ems_filter_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/support/ems/filters",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &EmsFilterModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*EmsFilterModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*EmsFilterModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	EmsFilterRuleCollectionGet Retrieves event filter rules.

### Related ONTAP commands
* `event filter show`
*/
func (a *Client) EmsFilterRuleCollectionGet(params *EmsFilterRuleCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*EmsFilterRuleCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewEmsFilterRuleCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ems_filter_rule_collection_get",
		Method:             "GET",
		PathPattern:        "/support/ems/filters/{name}/rules",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &EmsFilterRuleCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*EmsFilterRuleCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*EmsFilterRuleCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	EmsFilterRuleDelete Deletes an event filter rule.

### Related ONTAP commands
* `event filter rule delete`
*/
func (a *Client) EmsFilterRuleDelete(params *EmsFilterRuleDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*EmsFilterRuleDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewEmsFilterRuleDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ems_filter_rule_delete",
		Method:             "DELETE",
		PathPattern:        "/support/ems/filters/{name}/rules/{index}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &EmsFilterRuleDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*EmsFilterRuleDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*EmsFilterRuleDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
EmsFilterRuleDeleteCollection ems filter rule delete collection API
*/
func (a *Client) EmsFilterRuleDeleteCollection(params *EmsFilterRuleDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*EmsFilterRuleDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewEmsFilterRuleDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ems_filter_rule_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/support/ems/filters/{name}/rules",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &EmsFilterRuleDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*EmsFilterRuleDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*EmsFilterRuleDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	EmsFilterRuleGet Retrieves an event filter rule.

### Related ONTAP commands
* `event filter show`
*/
func (a *Client) EmsFilterRuleGet(params *EmsFilterRuleGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*EmsFilterRuleGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewEmsFilterRuleGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ems_filter_rule_get",
		Method:             "GET",
		PathPattern:        "/support/ems/filters/{name}/rules/{index}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &EmsFilterRuleGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*EmsFilterRuleGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*EmsFilterRuleGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	EmsFilterRuleModify Updates an event filter rule.

### Recommended optional properties
* `message_criteria` - Message criteria used by a rule to match an event.
* `parameter_criteria` - Parameter criteria used by a rule to match an event.
### Related ONTAP commands
* `event filter rule add`
* `event filter rule delete`
*/
func (a *Client) EmsFilterRuleModify(params *EmsFilterRuleModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*EmsFilterRuleModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewEmsFilterRuleModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ems_filter_rule_modify",
		Method:             "PATCH",
		PathPattern:        "/support/ems/filters/{name}/rules/{index}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &EmsFilterRuleModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*EmsFilterRuleModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*EmsFilterRuleModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
EmsFilterRuleModifyCollection ems filter rule modify collection API
*/
func (a *Client) EmsFilterRuleModifyCollection(params *EmsFilterRuleModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*EmsFilterRuleModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewEmsFilterRuleModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ems_filter_rule_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/support/ems/filters/{name}/rules",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &EmsFilterRuleModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*EmsFilterRuleModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*EmsFilterRuleModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	EmsFiltersRulesCreate Creates an event filter rule.

### Required properties
* `type` - Enumeration indicating whether the rule is for include or exclude.
* `message_criteria` - Message criteria used by a rule to match an event.
* `parameter_criteria` - Parameter criteria used by a rule to match an event.
Note: At least one pattern needs to be provided for message_criteria and / or
parameter_criteria.
### Recommended optional properties
* `index` - One-based position index of the new rule.
### Related ONTAP commands
* `event filter rule add`
*/
func (a *Client) EmsFiltersRulesCreate(params *EmsFiltersRulesCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*EmsFiltersRulesCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewEmsFiltersRulesCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ems_filters_rules_create",
		Method:             "POST",
		PathPattern:        "/support/ems/filters/{name}/rules",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &EmsFiltersRulesCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*EmsFiltersRulesCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*EmsFiltersRulesCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	EmsMessageCollectionGet Retrieves the event catalog definitions.

### Related ONTAP commands
* `event catalog show`
*/
func (a *Client) EmsMessageCollectionGet(params *EmsMessageCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*EmsMessageCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewEmsMessageCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ems_message_collection_get",
		Method:             "GET",
		PathPattern:        "/support/ems/messages",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &EmsMessageCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*EmsMessageCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*EmsMessageCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	EmsRoleConfigCollectionGet Retrieves a collection of the EMS role-based configurations.

### Related ONTAP commands
* `event role-config show`
*/
func (a *Client) EmsRoleConfigCollectionGet(params *EmsRoleConfigCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*EmsRoleConfigCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewEmsRoleConfigCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ems_role_config_collection_get",
		Method:             "GET",
		PathPattern:        "/support/ems/role-configs",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &EmsRoleConfigCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*EmsRoleConfigCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*EmsRoleConfigCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	EmsRoleConfigCreate Creates an EMS role-based configuration for an access control role.

### Required properties
* `access_control_role` - Uniquely identifies the access control role.
### Recommended optional properties
* `event_filter` - Identifies the event filter.
* `limit_access_to_global_configs` - Indicates whether the access control role has limited access to global EMS configurations.
### Related ONTAP commands
* `event role-config create`
*/
func (a *Client) EmsRoleConfigCreate(params *EmsRoleConfigCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*EmsRoleConfigCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewEmsRoleConfigCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ems_role_config_create",
		Method:             "POST",
		PathPattern:        "/support/ems/role-configs",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &EmsRoleConfigCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*EmsRoleConfigCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*EmsRoleConfigCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	EmsRoleConfigDelete Removes the EMS role-based configuration of the access control role.

### Related ONTAP commands
* `event role-config delete`
*/
func (a *Client) EmsRoleConfigDelete(params *EmsRoleConfigDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*EmsRoleConfigDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewEmsRoleConfigDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ems_role_config_delete",
		Method:             "DELETE",
		PathPattern:        "/support/ems/role-configs/{access_control_role.name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &EmsRoleConfigDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*EmsRoleConfigDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*EmsRoleConfigDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
EmsRoleConfigDeleteCollection ems role config delete collection API
*/
func (a *Client) EmsRoleConfigDeleteCollection(params *EmsRoleConfigDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*EmsRoleConfigDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewEmsRoleConfigDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ems_role_config_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/support/ems/role-configs",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &EmsRoleConfigDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*EmsRoleConfigDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*EmsRoleConfigDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	EmsRoleConfigGet Retrieves the EMS role-based configuration of the access control role.

### Related ONTAP commands
* `event role-config show`
*/
func (a *Client) EmsRoleConfigGet(params *EmsRoleConfigGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*EmsRoleConfigGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewEmsRoleConfigGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ems_role_config_get",
		Method:             "GET",
		PathPattern:        "/support/ems/role-configs/{access_control_role.name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &EmsRoleConfigGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*EmsRoleConfigGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*EmsRoleConfigGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	EmsRoleConfigModify Updates the EMS role-based configuration of the access control role.

### Recommended optional properties
* `event_filter` - Identifies the event filter.
* `limit_access_to_global_configs` - Indicates whether the access control role has limited access to global EMS configurations.
### Related ONTAP commands
* `event role-config modify`
*/
func (a *Client) EmsRoleConfigModify(params *EmsRoleConfigModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*EmsRoleConfigModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewEmsRoleConfigModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ems_role_config_modify",
		Method:             "PATCH",
		PathPattern:        "/support/ems/role-configs/{access_control_role.name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &EmsRoleConfigModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*EmsRoleConfigModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*EmsRoleConfigModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
EmsRoleConfigModifyCollection ems role config modify collection API
*/
func (a *Client) EmsRoleConfigModifyCollection(params *EmsRoleConfigModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*EmsRoleConfigModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewEmsRoleConfigModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ems_role_config_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/support/ems/role-configs",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &EmsRoleConfigModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*EmsRoleConfigModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*EmsRoleConfigModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SnmpGet Retrieves the cluster wide SNMP configuration.

### Related ONTAP commands
* `options snmp.enable`
* `system snmp show`
### Learn more
* [`DOC /support/snmp`](#docs-support-support_snmp)
*/
func (a *Client) SnmpGet(params *SnmpGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnmpGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSnmpGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "snmp_get",
		Method:             "GET",
		PathPattern:        "/support/snmp",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SnmpGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SnmpGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SnmpGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SnmpModify Updates the cluster wide SNMP configuration, such as:

* enabling or disabling SNMP
* enabling or disabling SNMP traps
* enabling or disabling authentication traps
* setting the contact and location information for the SNMP server
* triggering an SNMP test trap
### Related ONTAP commands
* `options snmp.enable`
* `system snmp authtrap`
* `system snmp init`
### Learn more
* [`DOC /support/snmp`](#docs-support-support_snmp)
*/
func (a *Client) SnmpModify(params *SnmpModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnmpModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSnmpModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "snmp_modify",
		Method:             "PATCH",
		PathPattern:        "/support/snmp",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SnmpModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SnmpModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SnmpModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SnmpTraphostsCollectionGet Retrieves the list of SNMP traphosts along with the SNMP users configured for those traphosts.

### Related ONTAP commands
* `system snmp traphost show`
### Learn more
* [`DOC /support/snmp/traphosts`](#docs-support-support_snmp_traphosts)
*/
func (a *Client) SnmpTraphostsCollectionGet(params *SnmpTraphostsCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnmpTraphostsCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSnmpTraphostsCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "snmp_traphosts_collection_get",
		Method:             "GET",
		PathPattern:        "/support/snmp/traphosts",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SnmpTraphostsCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SnmpTraphostsCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SnmpTraphostsCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SnmpTraphostsCreate Creates SNMP traphosts. While adding an SNMPv3 traphost, an SNMPv3 user configured in ONTAP must be specified. ONTAP uses this user's credentials to authenticate and/or encrypt traps sent to this SNMPv3 traphost. While adding an SNMPv1/SNMPv2c traphost, SNMPv1/SNMPv2c user or community need not be specified.

### Required properties
* `host` - Fully Qualified Domain Name (FQDN), IPv4 address or IPv6 address of SNMP traphost.
### Recommended optional properties
* If `host` refers to an SNMPv3 traphost, the following field is required:
  - `user` - SNMPv3 or User-based Security Model (USM) user.

* For an SNMPv1/SNMPv2c traphost, ONTAP automatically uses 'public' if 'public' is configured or no community is configured. Otherwise, ONTAP uses the first configured community.
### Related ONTAP commands
* `system snmp traphost add`
### Learn more
* [`DOC /support/snmp/traphosts`](#docs-support-support_snmp_traphosts)
*/
func (a *Client) SnmpTraphostsCreate(params *SnmpTraphostsCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnmpTraphostsCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSnmpTraphostsCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "snmp_traphosts_create",
		Method:             "POST",
		PathPattern:        "/support/snmp/traphosts",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SnmpTraphostsCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SnmpTraphostsCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SnmpTraphostsCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SnmpTraphostsDelete Deletes an SNMP traphost.

### Learn more
* [`DOC /support/snmp/traphosts/{host}`](#docs-support-support_snmp_traphosts_{host})
*/
func (a *Client) SnmpTraphostsDelete(params *SnmpTraphostsDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnmpTraphostsDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSnmpTraphostsDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "snmp_traphosts_delete",
		Method:             "DELETE",
		PathPattern:        "/support/snmp/traphosts/{host}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SnmpTraphostsDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SnmpTraphostsDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SnmpTraphostsDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
SnmpTraphostsDeleteCollection snmp traphosts delete collection API
*/
func (a *Client) SnmpTraphostsDeleteCollection(params *SnmpTraphostsDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnmpTraphostsDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSnmpTraphostsDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "snmp_traphosts_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/support/snmp/traphosts",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SnmpTraphostsDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SnmpTraphostsDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SnmpTraphostsDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SnmpTraphostsGet Retrieves the details of an SNMP traphost along with the SNMP user configured for that traphost.

### Learn more
* [`DOC /support/snmp/traphosts/{host}`](#docs-support-support_snmp_traphosts_{host})
*/
func (a *Client) SnmpTraphostsGet(params *SnmpTraphostsGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnmpTraphostsGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSnmpTraphostsGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "snmp_traphosts_get",
		Method:             "GET",
		PathPattern:        "/support/snmp/traphosts/{host}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SnmpTraphostsGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SnmpTraphostsGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SnmpTraphostsGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SnmpUsersCollectionGet Retrieves the list of SNMP users on the cluster.

### Related ONTAP commands
* `security snmpusers`
* `security login show -application snmp`
### Learn more
* [`DOC /support/snmp/users`](#docs-support-support_snmp_users)
*/
func (a *Client) SnmpUsersCollectionGet(params *SnmpUsersCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnmpUsersCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSnmpUsersCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "snmp_users_collection_get",
		Method:             "GET",
		PathPattern:        "/support/snmp/users",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SnmpUsersCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SnmpUsersCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SnmpUsersCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SnmpUsersCreate Creates either a cluster-scoped or an SVM-scoped SNMP user. This user can be an SNMPv1 or SNMPv2c community user or an SNMPv3 user. An SNMPv3 user can be a local SNMPv3 user or a remote SNMPv3 user.

### Required properties
* `name` - SNMP user name
### Optional properties
* `owner` - Name and UUID of owning SVM.
* `engine_id` - Engine ID of owning SVM or remote switch.
* `authentication_method` - Authentication method
* `switch_address` - Optional remote switch address
* `snmpv3` - SNMPv3-specific credentials
* `comment` - Comment text
### Default property values
* `snmpv3.authentication_protocol` - none
* `snmpv3.privacy_protocol` - none
### Related ONTAP commands
* `security login create`
* `system snmp community add`
### Learn more
* [`DOC /support/snmp/users`](#docs-support-support_snmp_users)
*/
func (a *Client) SnmpUsersCreate(params *SnmpUsersCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnmpUsersCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSnmpUsersCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "snmp_users_create",
		Method:             "POST",
		PathPattern:        "/support/snmp/users",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SnmpUsersCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SnmpUsersCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SnmpUsersCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SnmpUsersDelete Deletes an SNMP user. The engine ID can be the engine ID of the administrative SVM or a data SVM. It can also be the SNMPv3 engine ID of a remote switch.

### Related ONTAP commands
* `security login delete`
* `system snmp community delete`
### Learn more
* [`DOC /support/snmp/users/{engine_id}/{name}`](#docs-support-support_snmp_users_{engine_id}_{name})
*/
func (a *Client) SnmpUsersDelete(params *SnmpUsersDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnmpUsersDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSnmpUsersDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "snmp_users_delete",
		Method:             "DELETE",
		PathPattern:        "/support/snmp/users/{engine_id}/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SnmpUsersDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SnmpUsersDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SnmpUsersDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
SnmpUsersDeleteCollection snmp users delete collection API
*/
func (a *Client) SnmpUsersDeleteCollection(params *SnmpUsersDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnmpUsersDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSnmpUsersDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "snmp_users_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/support/snmp/users",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SnmpUsersDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SnmpUsersDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SnmpUsersDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SnmpUsersGet Retrieves the details of an SNMP user. The engine ID can be the engine ID of the administrative SVM or a data SVM. It can also be the SNMPv3 engine ID of a remote switch.

### Related ONTAP commands
* `security snmpusers -vserver <SVM Name> -username <User Name>`
* `security login show -application snmp -vserver <SVM Name> -user-or-group-name <User Name>`
### Learn more
* [`DOC /support/snmp/users/{engine_id}/{name}`](#docs-support-support_snmp_users_{engine_id}_{name})
*/
func (a *Client) SnmpUsersGet(params *SnmpUsersGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnmpUsersGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSnmpUsersGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "snmp_users_get",
		Method:             "GET",
		PathPattern:        "/support/snmp/users/{engine_id}/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SnmpUsersGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SnmpUsersGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SnmpUsersGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SnmpUsersModify Updates the comment parameter of an SNMP user.

### Optional properties
* `comment` - Comment text.
### Related ONTAP commands
* `security login modify`
### Learn more
* [`DOC /support/snmp/users/{engine_id}/{name}`](#docs-support-support_snmp_users_{engine_id}_{name})
*/
func (a *Client) SnmpUsersModify(params *SnmpUsersModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnmpUsersModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSnmpUsersModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "snmp_users_modify",
		Method:             "PATCH",
		PathPattern:        "/support/snmp/users/{engine_id}/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SnmpUsersModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SnmpUsersModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SnmpUsersModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
SnmpUsersModifyCollection snmp users modify collection API
*/
func (a *Client) SnmpUsersModifyCollection(params *SnmpUsersModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SnmpUsersModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSnmpUsersModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "snmp_users_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/support/snmp/users",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SnmpUsersModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SnmpUsersModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SnmpUsersModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}
