// Code generated by go-swagger; DO NOT EDIT.

package svm

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
)

// New creates a new svm API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

/*
Client for svm API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption is the option for Client methods
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	SvmCollectionGet(params *SvmCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SvmCollectionGetOK, error)

	SvmCreate(params *SvmCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SvmCreateCreated, *SvmCreateAccepted, error)

	SvmDelete(params *SvmDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SvmDeleteOK, *SvmDeleteAccepted, error)

	SvmDeleteCollection(params *SvmDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SvmDeleteCollectionOK, *SvmDeleteCollectionAccepted, error)

	SvmGet(params *SvmGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SvmGetOK, error)

	SvmMigrationCollectionGet(params *SvmMigrationCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SvmMigrationCollectionGetOK, error)

	SvmMigrationCreate(params *SvmMigrationCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SvmMigrationCreateCreated, *SvmMigrationCreateAccepted, error)

	SvmMigrationDelete(params *SvmMigrationDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SvmMigrationDeleteOK, *SvmMigrationDeleteAccepted, error)

	SvmMigrationDeleteCollection(params *SvmMigrationDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SvmMigrationDeleteCollectionOK, *SvmMigrationDeleteCollectionAccepted, error)

	SvmMigrationGet(params *SvmMigrationGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SvmMigrationGetOK, error)

	SvmMigrationModify(params *SvmMigrationModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SvmMigrationModifyOK, *SvmMigrationModifyAccepted, error)

	SvmMigrationModifyCollection(params *SvmMigrationModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SvmMigrationModifyCollectionOK, *SvmMigrationModifyCollectionAccepted, error)

	SvmMigrationVolumeCollectionGet(params *SvmMigrationVolumeCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SvmMigrationVolumeCollectionGetOK, error)

	SvmMigrationVolumeGet(params *SvmMigrationVolumeGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SvmMigrationVolumeGetOK, error)

	SvmModify(params *SvmModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SvmModifyOK, *SvmModifyAccepted, error)

	SvmModifyCollection(params *SvmModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SvmModifyCollectionOK, *SvmModifyCollectionAccepted, error)

	SvmPeerCollectionGet(params *SvmPeerCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SvmPeerCollectionGetOK, error)

	SvmPeerCreate(params *SvmPeerCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SvmPeerCreateCreated, *SvmPeerCreateAccepted, error)

	SvmPeerDelete(params *SvmPeerDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SvmPeerDeleteOK, *SvmPeerDeleteAccepted, error)

	SvmPeerDeleteCollection(params *SvmPeerDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SvmPeerDeleteCollectionOK, *SvmPeerDeleteCollectionAccepted, error)

	SvmPeerInstanceGet(params *SvmPeerInstanceGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SvmPeerInstanceGetOK, error)

	SvmPeerModify(params *SvmPeerModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SvmPeerModifyOK, *SvmPeerModifyAccepted, error)

	SvmPeerModifyCollection(params *SvmPeerModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SvmPeerModifyCollectionOK, *SvmPeerModifyCollectionAccepted, error)

	SvmPeerPermissionCollectionGet(params *SvmPeerPermissionCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SvmPeerPermissionCollectionGetOK, error)

	SvmPeerPermissionCreate(params *SvmPeerPermissionCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SvmPeerPermissionCreateCreated, error)

	SvmPeerPermissionDelete(params *SvmPeerPermissionDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SvmPeerPermissionDeleteOK, error)

	SvmPeerPermissionDeleteCollection(params *SvmPeerPermissionDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SvmPeerPermissionDeleteCollectionOK, error)

	SvmPeerPermissionInstanceGet(params *SvmPeerPermissionInstanceGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SvmPeerPermissionInstanceGetOK, error)

	SvmPeerPermissionModify(params *SvmPeerPermissionModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SvmPeerPermissionModifyOK, error)

	SvmPeerPermissionModifyCollection(params *SvmPeerPermissionModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SvmPeerPermissionModifyCollectionOK, error)

	TopMetricsSvmClientCollectionGet(params *TopMetricsSvmClientCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*TopMetricsSvmClientCollectionGetOK, error)

	TopMetricsSvmDirectoryCollectionGet(params *TopMetricsSvmDirectoryCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*TopMetricsSvmDirectoryCollectionGetOK, error)

	TopMetricsSvmFileCollectionGet(params *TopMetricsSvmFileCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*TopMetricsSvmFileCollectionGetOK, error)

	TopMetricsSvmUserCollectionGet(params *TopMetricsSvmUserCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*TopMetricsSvmUserCollectionGetOK, error)

	WebSvmGet(params *WebSvmGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WebSvmGetOK, error)

	WebSvmModify(params *WebSvmModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WebSvmModifyOK, *WebSvmModifyAccepted, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
	SvmCollectionGet Retrieves a list of SVMs and individual SVM properties. This includes protocol configurations such as CIFS, NFS and S3, export policies, name service configurations, and network services.

### Important notes
* The SVM object includes a large set of fields and can be expensive to retrieve. Use this API to list the collection of SVMs, and to retrieve only the full details of individual SVMs as needed.
* It is not recommended to create or delete more than five SVMs in parallel.
* REST APIs only expose a data SVM as an SVM.
### Expensive properties
There is an added computational cost to retrieving values for these properties. They are not included by default in GET results and must be explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.
* `snapmirror.*`
### Related ONTAP commands
* `vserver show`
### Examples
  - Retrieves a list of SVMs in the cluster sorted by name.
    <br/>
    ```
    GET "/api/svm/svms?order_by=name"
    ```
    <br/>
  - Retrieves a list of SVMs in the cluster that have the NFS protocol enabled.
    <br/>
    ```
    GET "/api/svm/svms?nfs.enabled=true"
    ```
    <br/>
  - Retrieves a list of SVMs in the cluster that have the CIFS protocol enabled.
    <br/>
    ```
    GET "/api/svm/svms?cifs.enabled=true"
    ```
    <br/>
  - Retrieves a list of SVMs in the cluster that have the S3 protocol enabled.
    <br/>
    ```
    GET "/api/svm/svms?s3.enabled=true"
    ```
    <br/>

<personalities supports=asar2,unified>
  - Retrieves a list of SVMs in the cluster that have the FCP protocol allowed.
    <br/>
    ```
    GET "/api/svm/svms?fcp.allowed=true"
    ```
    <br/>

</personalities>
  - Retrieves a list of SVMs in the cluster that have the CIFS protocol allowed.
    <br/>
    ```
    GET "/api/svm/svms?cifs.allowed=true"
    ```
    <br/>
  - Retrieves a list of SVMs in the cluster where the NDMP protocol is specified as allowed.
    <br/>
    ```
    GET "/api/svm/svms?ndmp.allowed=true"
    ```
    <br/>
  - Retrieves a list of SVMs in the cluster that have the s3 protocol allowed.
    <br/>
    ```
    GET "/api/svm/svms?s3.allowed=true"
    ```
    <br/>

### Learn more
* [`DOC /svm/svms`](#docs-svm-svm_svms)
*/
func (a *Client) SvmCollectionGet(params *SvmCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SvmCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSvmCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "svm_collection_get",
		Method:             "GET",
		PathPattern:        "/svm/svms",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SvmCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SvmCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SvmCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SvmCreate Creates and provisions an SVM. If no IPspace is provided, then the SVM is created on the `Default` IPspace.

* The number of parallel SVMs that can be created must not be greater than five.
* If a sixth SVM POST request is issued, the following error message is generated: "Maximum allowed SVM jobs exceeded. Wait for the existing SVM jobs to complete and try again."
### Required properties
* `name` - Name of the SVM to be created.
### Recommended optional properties
* `ipspace.name` or `ipspace.uuid` - IPspace of the SVM
* `is_space_reporting_logical` - Logical Space Reporting parameter of the SVM
* `is_space_enforcement_logical` - Logical Space Enforcement parameter of the SVM
* `ip_interfaces` - If provided, the following fields are required:
* `ip_interfaces.name` - Name of the interface
* `ip_interfaces.ip.address` - IP address
* `ip_interfaces.ip.netmask` - Netmask length or IP address
* `ip_interfaces.location.broadcast_domain.uuid` or `ip_interfaces.location.broadcast_domain.name` - Broadcast domain name or UUID belonging to the same IPspace of the SVM.
* `ip_interfaces.location.home_port.name` - Home port name
* `ip_interfaces.location.home_port.uuid` - Home port uuid
* `subnet.uuid` or `subnet.name` - Either name or UUID of the subnet to create.
* `routes` - If provided, the following field is required:
  - `routes.gateway` - Gateway IP address

* `cifs` - If provided, interfaces, routes and DNS must be provided. The following fields are also required:
  - `cifs.name` - Name of the CIFS server to be created for the SVM.
  - `cifs.ad_domain.fqdn` - Fully qualified domain name
  - `cifs.ad_domain.user` - Administrator username
  - `cifs.ad_domain.password` - User password

* `ldap` - If provided, the following fields are required:
  - `ldap.servers` or `ldap.ad_domain` - LDAP server list or Active Directory domain
  - `ldap.bind_dn` - Bind DN
  - `ldap.base_dn` - Base DN

* `nis` - If provided, the following fields are required:
  - `nis.servers` - NIS servers
  - `nis.domain` - NIS domain

* `dns` - If provided, the following fields are required:
  - `dns.servers` - Name servers
  - `dns.domains` - Domains
    <personalities supports=asar2,unified>

* `fc_interfaces` - If provided, the following fields are required:
  - `fc_interfaces.name` - Fibre Channel interface name
  - `fc_interfaces.data_protocol` - Fibre Channel interface data protocol
  - `fc_interfaces.location.port.uuid` or `fc_interfaces.location.port.name` and `fc_interfaces.location.port.node.name` - Either port UUID or port name and node name together must be provided.
    </personalities>

* `s3` - If provided, the following field should also be specified:
  - `s3.name` - Name of the S3 server. If `s3.name' is not specified while `s3.enabled` is set to 'true', the S3 server will be created with the default name '<svm.name>_S3Server'.
  - `s3.port` - S3 server listener port.
  - `s3.secure_port` - S3 server listener port for HTTPS.
  - `s3.is_http_enabled` - S3 server connections over HTTP.
  - `s3.is_https_enabled` - S3 server connections over HTTPS.
  - `s3.certificate.name` - S3 server certificate name. This is required if the S3 server runs over HTTPS.
  - `s3.certificate.uuid` - S3 server certificate UUID. This is required if the S3 server runs over HTTPS.

* `auto_enable_analytics` - Auto-enable file system analytics on new volumes created in the SVM.
* `auto_enable_activity_tracking` - Auto-enable volume activity-tracking on new volumes created in the SVM.
* `storage.limit` - Maximum storage permitted on a single SVM.
* `storage.limit_threshold_alert` - At what percentage of storage capacity, alert message needs to be sent.
### Default property values
If not specified in POST, the following default property values are assigned:
* `language` - _C.UTF-8_
* `ipspace.name` - _Default_
* `snapshot_policy.name` - _Default_
* `subtype` - _Default_ ( _sync-source_ if MetroCluster configuration )
* `anti_ransomware_default_volume_state` - _disabled_
* `qos_adaptive_policy_group_template` - _extreme_ ( if using a platform with disaggregated storage and neither qos_policy_group_template nor qos_adaptive_policy_group_template are provided)
### Related ONTAP commands
* `vserver create`
* `vserver add-aggregates`
* `network interface create`
* `network route create`
* `vserver services name-service dns create`
* `vserver nfs create`
* `vserver services name-service ldap client create`
* `vserver cifs create`
* `vserver services name-service nis-domain create`
<personalities supports=asar2,unified>
* `vserver iscsi create`
* `vserver nvme create`
* `vserver fcp create`
</personalities>
* `vserver services name-service ns-switch create`
* `vserver object-store-server create`
* `vserver add-protocols`
* `vserver remove-protocols`
### Examples
  - Creates an SVM with default "snapshot_policy".
    <br/>
    ```
    POST "/api/svm/svms" '{"name":"testVs", "snapshot_policy":{"name":"default"}}'
    ```
    <br/>
  - Creates an SVM and configures NFS, CIFS, and S3.
    <br/>
    ```
    POST "/api/svm/svms" '{"name":"testVs", "nfs":{"enabled":"true"}, "cifs":{"enabled":"true"}, "s3":{"enabled":"true"}}'
    ```
    <br/>

<personalities supports=asar2,unified>
  - Creates an SVM and configures NVMe.
    <br/>
    ```
    POST "/api/svm/svms" '{"name":"testVs", "nvme":{"enabled":"true"}}'
    ```
    <br/>

</personalities>
  - Creates an SVM and configures LDAP.
    <br/>
    ```
    POST "/api/svm/svms" '{"name":"testVs", "snapshot_policy":{"name":"default"}, "ldap":{"servers":["10.140.101.1","10.140.101.2"], "ad_domain":"abc.com", "base_dn":"dc=netapp,dc=com", "bind_dn":"dc=netapp,dc=com"}}'
    ```
    <br/>
  - Creates an SVM and configures NIS.
    <br/>
    ```
    POST "/api/svm/svms" '{"name":"testVs", "snapshot_policy":{"name":"default"}, "nis":{"enabled":"true", "domain":"def.com","servers":["10.224.223.130", "10.224.223.131"]}}'
    ```
    <br/>
  - Creates an SVM and configures DNS.
    <br/>
    ```
    POST "/api/svm/svms" '{"name":"testVs", "snapshot_policy":{"name":"default"}, "dns":{"domains":["abc.com","def.com"], "servers":["10.224.223.130", "10.224.223.131"]}}'
    ```
    <br/>
  - Creates an SVM and configures a LIF.
    <br/>
    ```
    POST "/api/svm/svms" '{"name":"testVs", "ip_interfaces": [{"name":"lif1", "ip":{"address":"10.10.10.7", "netmask": "255.255.255.0"}, "location":{"broadcast_domain":{"name":"bd1"}, "home_node":{"name":"node1"}}, "service_policy": "default-management"}]}'
    ```
    <br/>
  - Creates an SVM and configures a LIF with IPV6 address.
    <br/>
    ```
    POST "/api/svm/svms" '{"name":"testVs", "ip_interfaces": [{"name":"lif2", "ip":{"address":"fd22:8b1e:b255:202:2a0:98ff:fe01:7d5b", "netmask":"24"}, "location":{"broadcast_domain":{"name":"bd1"}, "home_node":{"name":"node1"}}, "service_policy": "default-management"}]}'
    ```
    <br/>
  - Creates an SVM and configures CIFS.
    <br/>
    ```
    POST "/api/svm/svms" '{"name":"testVs", "cifs":{"name":"CIFDOC", "ad_domain":{"fqdn":"abc.def.com", "organizational_unit":"CN=Computers", "user":"cif_admin", "password":"abc123"}}, "ip_interfaces":[{"name":"lif1", "ip":{"address":"10.10.10.7", "netmask": "255.255.255.0"}, "location":{"broadcast_domain":{"name":"bd1"}, "home_node":{"name":"node1"}}, "service_policy": "default-management"}],"routes": [{"destination": {"address": "0.0.0.0", "netmask": "0"}, "gateway": "10.10.10.7"}], "dns":{"domains":["abc.def.com", "def.com"], "servers":["10.224.223.130", "10.224.223.131"]}}'
    ```
    <br/>
  - Creates an SVM with an S3 server enabled and configured.
    <br/>
    ```
    POST "/api/svm/svms" '{"name":"svm5", "s3":{"name":"s3-server-1", "enabled":true, "allowed":true, "is_http_enabled": true, "is_https_enabled":false}}'
    ```
    <br/>

<personalities supports=asar2,unified>
  - Creates an SVM and disallows NVMe service for the SVM.
    <br/>
    ```
    POST "/api/svm/svms" '{"name":"testVs", "nvme":{"allowed":"false"}}'
    ```
    <br/>

</personalities>
  - Creates an SVM, allows and configures the NFS service for the SVM.
    <br/>
    ```
    POST "/api/svm/svms" '{"name":"testVs", "nfs":{"allowed":"true", "enabled":true}}'
    ```
    <br/>
  - Create an SVM and set the max volume limit for the SVM.
    <br/>
    ```
    POST "/api/svm/svms/" '{"name":"testVs", "max_volumes":"200"}'
    ```
    <br/>
  - Creates an SVM and disallows the NDMP service for the SVM.
    <br/>
    ```
    POST "/api/svm/svms" '{"name":"testVs", "ndmp":{"allowed":"false"}}'
    ```
    <br/>
  - Creates an SVM and specifies whether file system analytics is enabled on all newly created volumes in the SVM.
    <br/>
    ```
    POST "/api/svm/svms" '{"name":"testVs", "auto_enable_analytics":true}}'
    ```
    <br/>
  - Creates an SVM and specifies whether volume_activity_tracking is enabled on all newly created volumes in the SVM.
    <br/>
    ```
    POST "/api/svm/svms" '{"name":"testVs", "auto_enable_activity_tracking":true}}'
    ```
    <br/>
  - Creates an SVM and specifies whether file system analytics is enabled on all newly created volumes in the SVM.
    <br/>
    ```
    POST "/api/svm/svms" '{"name":"testVs", "auto_enable_analytics":true}}'
    ```
    <br/>
  - Creates an SVM and specifies the maximum storage limit for a single SVM.
    <br/>
    ```
    POST "/api/svm/svms" '{"name":"testVs", "storage": {"limit":"4GB"}}'
    ```
    <br/>
  - Creates an SVM and specifies at what percentage of storage capacity an alert message is sent. Default value is 90.
    <br/>
    ```
    POST "/api/svm/svms" '{"name":"testVs", "storage": {"limit":"20GB", "limit_threshold_alert":"95"}}'
    ```
    <br/>
  - Creates an SVM and specifies the QoS policy group template to be assigned to the SVM.
    <br/>
    ```
    POST "/api/svm/svms" '{"name":"testVs", "qos_policy_group_template":{"name":"performance-fixed"}}'
    ```
    <br/>
  - Creates an SVM and specifies the QoS adaptive policy group template to be assigned to the SVM.
    <br/>
    ```
    POST "/api/svm/svms" '{"name":"testVs", "qos_adaptive_policy_group_template":{"name":"performance"}}'
    ```
    <br/>

<personalities supports=asar2>
  - On ASA r2 platforms, _fcp_, _iscsi_, and _nvme_ services are enabled and allowed by default, and are not necessary in the POST request.
    <br/>
    ```
    POST "/api/svm/svms" '{"name":"testVs"}'
    ```
    <br/>

</personalities>
### Learn more
* [`DOC /svm/svms`](#docs-svm-svm_svms)
*/
func (a *Client) SvmCreate(params *SvmCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SvmCreateCreated, *SvmCreateAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSvmCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "svm_create",
		Method:             "POST",
		PathPattern:        "/svm/svms",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SvmCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *SvmCreateCreated:
		return value, nil, nil
	case *SvmCreateAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SvmCreateDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SvmDelete Deletes an SVM. As a prerequisite, SVM objects must be deleted first. SnapMirror relationships must be deleted and data volumes must be offline and deleted.

* The number of parallel SVMs that can be created must not be greater than five.
* If a sixth SVM POST request is issued, the following error message is generated: "Maximum allowed SVM jobs exceeded. Wait for the existing SVM jobs to complete and try again."
### Related ONTAP commands
* `vserver delete`
### Example
Deleting an individual SVM in the cluster.

	<br/>
	```
	DELETE "/api/svm/svms/f16f0935-5281-11e8-b94d-005056b46485"
	```
	<br/>

### Learn more
* [`DOC /svm/svms`](#docs-svm-svm_svms)
*/
func (a *Client) SvmDelete(params *SvmDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SvmDeleteOK, *SvmDeleteAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSvmDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "svm_delete",
		Method:             "DELETE",
		PathPattern:        "/svm/svms/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SvmDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *SvmDeleteOK:
		return value, nil, nil
	case *SvmDeleteAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SvmDeleteDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
SvmDeleteCollection svm delete collection API
*/
func (a *Client) SvmDeleteCollection(params *SvmDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SvmDeleteCollectionOK, *SvmDeleteCollectionAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSvmDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "svm_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/svm/svms",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SvmDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *SvmDeleteCollectionOK:
		return value, nil, nil
	case *SvmDeleteCollectionAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SvmDeleteCollectionDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SvmGet Retrieves the properties for an individual SVM. This includes protocol configurations such as CIFS and NFS, export policies, name service configurations, and network services.

### Important notes
* The SVM object includes a large set of fields and can be expensive to retrieve.
* REST APIs only expose a data SVM as an SVM.
### Expensive properties
There is an added computational cost to retrieving values for these properties. They are not included by default in GET results and must be explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.
* `snapmirror.*`
### Example

	Retrieving an individual SVM in the cluster
	<br/>
	```
	GET "/api/svm/svms/f16f0935-5281-11e8-b94d-005056b46485"
	```
	<br/>
*/
func (a *Client) SvmGet(params *SvmGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SvmGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSvmGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "svm_get",
		Method:             "GET",
		PathPattern:        "/svm/svms/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SvmGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SvmGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SvmGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SvmMigrationCollectionGet Retrieves the SVM migration status.

### Related ONTAP commands
* `vserver migrate show`
*/
func (a *Client) SvmMigrationCollectionGet(params *SvmMigrationCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SvmMigrationCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSvmMigrationCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "svm_migration_collection_get",
		Method:             "GET",
		PathPattern:        "/svm/migrations",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SvmMigrationCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SvmMigrationCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SvmMigrationCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SvmMigrationCreate Creates an SVM migration operation. This API must be executed on the destination cluster. This API creates an SVM on the destination cluster and preserves the SVM's identity specified in the source cluster.

Optionally, you can specify the <personalities supports=unified>aggregate list for creating the volumes, and </personalities>IPspace. You can perform pre-checks to verify if SVM migration is possible, by setting the "check-only" option to "true". By default the values for auto-source-cleanup and auto-cutover is true.
### Required properties
* `source.svm.name` or `source.svm.uuid` - Source SVM name or source SVM UUID.
* `source.cluster.name` or `source.cluster.uuid` - Source cluster name or source cluster UUID
### Optional properties
* `destination.ipspace.name` or `destination.ipspace.uuid` - Destination IP Space name or UUID where the SVM will be migrated to.<personalities supports=unified>
* `destination.volume_placement.aggregates` - List of aggregates where the migrating volumes should go on the destination.
* `destination.volume_placement.volume_aggregate_pairs` - List of volume aggregate pairs indicating where the migrating volumes should go on the destination.</personalities>
* `ip_interface_placement` -  List of source SVM's IP interface and port pairs on the destination for migrating the SVM's IP interfaces.
* `auto_cutover` - Option to specify whether to perform cutover automatically. Default is true.
* `auto_source_cleanup` - Option to specify whether to perform source cleanup automatically. Default is true.
* `check_only` - Option to perform all the prechecks for migrate without actually starting the migrate. Default is false.
* `throttle` - Option to specify a throttle value in KB/s. Defaults to unlimited.
### Related ONTAP commands
* `vserver migrate start`
*/
func (a *Client) SvmMigrationCreate(params *SvmMigrationCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SvmMigrationCreateCreated, *SvmMigrationCreateAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSvmMigrationCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "svm_migration_create",
		Method:             "POST",
		PathPattern:        "/svm/migrations",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SvmMigrationCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *SvmMigrationCreateCreated:
		return value, nil, nil
	case *SvmMigrationCreateAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SvmMigrationCreateDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SvmMigrationDelete Deletes the SVM migration.

### Related ONTAP commands
* `vserver migrate abort`
*/
func (a *Client) SvmMigrationDelete(params *SvmMigrationDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SvmMigrationDeleteOK, *SvmMigrationDeleteAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSvmMigrationDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "svm_migration_delete",
		Method:             "DELETE",
		PathPattern:        "/svm/migrations/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SvmMigrationDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *SvmMigrationDeleteOK:
		return value, nil, nil
	case *SvmMigrationDeleteAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SvmMigrationDeleteDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
SvmMigrationDeleteCollection svm migration delete collection API
*/
func (a *Client) SvmMigrationDeleteCollection(params *SvmMigrationDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SvmMigrationDeleteCollectionOK, *SvmMigrationDeleteCollectionAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSvmMigrationDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "svm_migration_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/svm/migrations",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SvmMigrationDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *SvmMigrationDeleteCollectionOK:
		return value, nil, nil
	case *SvmMigrationDeleteCollectionAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SvmMigrationDeleteCollectionDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SvmMigrationGet Retrieves the migration status of an individual SVM.

### Important notes
* The "migrations" object includes a large set of fields and can be expensive to retrieve.
* REST APIs only expose a data SVM as an SVM.
* There are subsystem specific errors that can be returned from this endpoint. If a subsystem specific error is returned and this is the first migrate operation attempt, it is embedded in one of the following errors. If a subsystem specific error is returned and this is not the first migrate operation attempt, the subsystem specific error is returned directly.
### Example

	Retrieving an individual SVM migration status.
	<br/>
	```
	GET "/api/svm/migrations/a14ae39f-8d85-11e9-b4a7-00505682dc8b/svms/f16f0935-5281-11e8-b94d-005056b46485"
	```
	<br/>
*/
func (a *Client) SvmMigrationGet(params *SvmMigrationGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SvmMigrationGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSvmMigrationGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "svm_migration_get",
		Method:             "GET",
		PathPattern:        "/svm/migrations/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SvmMigrationGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SvmMigrationGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SvmMigrationGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SvmMigrationModify Actions that can be performed during an SVM migration.

### Related ONTAP commands
* `vserver migrate pause`
* `vserver migrate resume`
* `vserver migrate cutover`
* `vserver migrate source-cleanup`
*/
func (a *Client) SvmMigrationModify(params *SvmMigrationModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SvmMigrationModifyOK, *SvmMigrationModifyAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSvmMigrationModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "svm_migration_modify",
		Method:             "PATCH",
		PathPattern:        "/svm/migrations/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SvmMigrationModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *SvmMigrationModifyOK:
		return value, nil, nil
	case *SvmMigrationModifyAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SvmMigrationModifyDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
SvmMigrationModifyCollection svm migration modify collection API
*/
func (a *Client) SvmMigrationModifyCollection(params *SvmMigrationModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SvmMigrationModifyCollectionOK, *SvmMigrationModifyCollectionAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSvmMigrationModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "svm_migration_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/svm/migrations",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SvmMigrationModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *SvmMigrationModifyCollectionOK:
		return value, nil, nil
	case *SvmMigrationModifyCollectionAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SvmMigrationModifyCollectionDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SvmMigrationVolumeCollectionGet Retrieves the transfer status of the volumes in the SVM.

### Related ONTAP commands
* `vserver migrate show-volume`
*/
func (a *Client) SvmMigrationVolumeCollectionGet(params *SvmMigrationVolumeCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SvmMigrationVolumeCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSvmMigrationVolumeCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "svm_migration_volume_collection_get",
		Method:             "GET",
		PathPattern:        "/svm/migrations/{svm_migration.uuid}/volumes",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SvmMigrationVolumeCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SvmMigrationVolumeCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SvmMigrationVolumeCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SvmMigrationVolumeGet Retrieves the volume transfer status of the specified volume.uuid.

### Related ONTAP commands
* `vserver migrate show-volume`
*/
func (a *Client) SvmMigrationVolumeGet(params *SvmMigrationVolumeGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SvmMigrationVolumeGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSvmMigrationVolumeGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "svm_migration_volume_get",
		Method:             "GET",
		PathPattern:        "/svm/migrations/{svm_migration.uuid}/volumes/{volume.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SvmMigrationVolumeGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SvmMigrationVolumeGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SvmMigrationVolumeGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SvmModify Updates one or more of the following properties of an individual SVM: SVM name, SVM default volume language code, SVM comment, and SVM state.

### Related ONTAP commands
* `vserver modify`
* `vserver rename`
* `vserver start`
* `vserver stop`
* `security ssl modify`
* `vserver add-protocols`
* `vserver remove-protocols`
### Examples
 1. Stops an SVM and updates the "comment" field for an individual SVM
    <br/>
    ```
    PATCH "/api/svm/svms/f16f0935-5281-11e8-b94d-005056b46485" '{"state":"stopped", "comment":"This SVM is stopped."}'
    ```
    <br/>
 2. Starts an SVM and updates the "comment" field for an individual SVM
    <br/>
    ```
    PATCH "/api/svm/svms/f16f0935-5281-11e8-b94d-005056b46485" '{"state":"running", "comment":"This SVM is running."}'
    ```
    <br/>
 3. Updates the "language" field for an individual SVM
    <br/>
    ```
    PATCH "/api/svm/svms/f16f0935-5281-11e8-b94d-005056b46485" '{"language":"en.UTF-8"}'
    ```
    <br/>
 4. Updates the "name" field for an SVM or renames the SVM
    <br/>
    ```
    PATCH "/api/svm/svms/f16f0935-5281-11e8-b94d-005056b46485" '{"name":"svm_new"}'
    ```
    <br/>
 5. Updates the aggregates for an individual SVM
    <br/>
    ```
    PATCH "/api/svm/svms/f16f0935-5281-11e8-b94d-005056b46485" '{"aggregates":["{"name":aggr1"},{"name":"aggr2"},{"name":"aggr3"}]}'
    ```
    <br/>
 6. Updates the snapshot policy for an individual SVM
    <br/>
    ```
    PATCH "/api/svm/svms/f16f0935-5281-11e8-b94d-005056b46485" '{"snapshot_policy":{"name":"custom1"}}'
    ```
    <br/>
 7. Updates the TLS certificate for an individual SVM
    <br/>
    ```
    PATCH "/api/svm/svms/f16f0935-5281-11e8-b94d-005056b46485" '{"certificate":{"uuid":"1cd8a442-86d1-11e0-ae1c-123478563412"}}'
    ```
    <br/>
 8. Updates the QoS policy for the SVM
    <br/>
    ```
    PATCH "/api/svm/svms/f16f0935-5281-11e8-b94d-005056b46485" '{"qos_policy_group":{"name":"qpolicy1"}}'
    ```
    <br/>
 9. Allows NFS protocol which was previously disallowed for the SVM
    <br/>
    ```
    PATCH "/api/svm/svms/f16f0935-5281-11e8-b94d-005056b46485" '{"nfs":{"allowed":"true"}}'
    ```
    <br/>
 10. Updates the max volume limit for the SVM
    <br/>
    ```
    PATCH "/api/svm/svms/f16f0935-5281-11e8-b94d-005056b46485" '{"max_volumes":"200"}'
    ```
    <br/>
 11. Updates whether file system analytics is enabled on all newly created volumes in the SVM.
    <br/>
    ```
    PATCH "/api/svm/svms/f16f0935-5281-11e8-b94d-005056b46485" '{"auto_enable_analytics":"true"}'
    ```
    <br/>
 12. Updates whether volume activity tracking is enabled on all newly created volumes in the SVM.
    <br/>
    ```
    PATCH "/api/svm/svms/f16f0935-5281-11e8-b94d-005056b46485" '{"auto_enable_activity_tracking":"true"}'
    ```
    <br/>
 13. Updates the QoS adaptive policy group template for the SVM.
    <br/>
    ```
    PATCH "/api/svm/svms/f16f0935-5281-11e8-b94d-005056b46485" '{"qos_adaptive_policy_group_template":{"name":"aqpolicy1"}}'
    ```
    <br/>
 14. Updates the maximum storage permitted on a single SVM.
    <br/>
    ```
    PATCH "/api/svm/svms/f16f0935-5281-11e8-b94d-005056b46485" '{"storage":{"limit":"40GB"}}'
    ```
    <br/>
 15. Updates the percentage of storage capacity at which an alert message is sent.
    <br/>
    ```
    PATCH "/api/svm/svms/f16f0935-5281-11e8-b94d-005056b46485" '{"storage":{"limit":"400MB", "limit_threshold_alert":"98"}}'
    ```
    <br/>
 16. Updates the QoS policy group template for the SVM.
    <br/>
    ```
    PATCH "/api/svm/svms/f16f0935-5281-11e8-b94d-005056b46485" '{"qos_policy_group_template":{"name":"policy1"}}'
    ```
    <br/>
 17. Updates the S3 protocol that was previously disallowed for the SVM
    <br/>
    ```
    PATCH "/api/svm/svms/f16f0935-5281-11e8-b94d-005056b46485" '{"s3":{"allowed":"true"}}'
    ```
    <br/>

### Learn more
* [`DOC /svm/svms`](#docs-svm-svm_svms)
*/
func (a *Client) SvmModify(params *SvmModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SvmModifyOK, *SvmModifyAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSvmModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "svm_modify",
		Method:             "PATCH",
		PathPattern:        "/svm/svms/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SvmModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *SvmModifyOK:
		return value, nil, nil
	case *SvmModifyAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SvmModifyDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
SvmModifyCollection svm modify collection API
*/
func (a *Client) SvmModifyCollection(params *SvmModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SvmModifyCollectionOK, *SvmModifyCollectionAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSvmModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "svm_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/svm/svms",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SvmModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *SvmModifyCollectionOK:
		return value, nil, nil
	case *SvmModifyCollectionAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SvmModifyCollectionDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SvmPeerCollectionGet Retrieves the list of SVM peer relationships.

### Related ONTAP commands
* `vserver peer show`
### Examples
The following examples show how to retrieve a collection of SVM peer relationships based on a query.
 1. Retrieves a list of SVM peers of a specific local SVM
    <br/>
    ```
    GET "/api/svm/peers/?svm.name=VS1"
    ```
    <br/>
 2. Retrieves a list of SVM peers of a specific cluster peer
    <br/>
    ```
    GET "/api/svm/peers/?peer.cluster.name=cluster2"
    ```
    <br/>

### Learn more
* [`DOC /svm/peers`](#docs-svm-svm_peers)
*/
func (a *Client) SvmPeerCollectionGet(params *SvmPeerCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SvmPeerCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSvmPeerCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "svm_peer_collection_get",
		Method:             "GET",
		PathPattern:        "/svm/peers",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SvmPeerCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SvmPeerCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SvmPeerCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SvmPeerCreate Creates a new SVM peer relationship.

### Important notes
  - The create request accepts peer SVM name as input instead of peer SVM UUID as the local cluster cannot validate peer SVM based on UUID.
  - The input parameter `name` refers to the local name of the peer SVM. The `peer cluster name` parameter is optional for creating intracluster SVM peer relationships.

### Required properties
* `svm.name` or `svm.uuid` - SVM name or SVM UUID
* `peer.svm.name` or `peer.svm.uuid` - Peer SVM name or Peer SVM UUID
* `peer.cluster.name` or `peer.cluster.uuid` - Peer cluster name or peer cluster UUID
* `applications` - Peering applications
### Related ONTAP commands
* `vserver peer create`
### Example
Creates a new SVM peer relationship.
<br/>
```
POST "/api/svm/peers" '{"svm":{"name":"vs1"}, "peer.cluster.name":"cluster2", "peer.svm.name":"VS1", "applications":["snapmirror"]}'
```
<br/>
### Learn more
* [`DOC /svm/peers`](#docs-svm-svm_peers)
*/
func (a *Client) SvmPeerCreate(params *SvmPeerCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SvmPeerCreateCreated, *SvmPeerCreateAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSvmPeerCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "svm_peer_create",
		Method:             "POST",
		PathPattern:        "/svm/peers",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SvmPeerCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *SvmPeerCreateCreated:
		return value, nil, nil
	case *SvmPeerCreateAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SvmPeerCreateDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SvmPeerDelete Deletes the SVM peer relationship.

### Related ONTAP commands
* `vserver peer delete`
### Example
 1. Deletes an SVM peer relationship.
    <br/>
    ```
    DELETE "/api/svm/peers/d3268a74-ee76-11e8-a9bb-005056ac6dc9"
    ```
    <br/>
 2. Deletes an SVM peer relationship using force flag
    <br/>
    ```
    DELETE "/api/svm/peers/d3268a74-ee76-11e8-a9bb-005056ac6dc9" '{"force": "true"}'
    ```
    <br/>

### Learn more
* [`DOC /svm/peers`](#docs-svm-svm_peers)
*/
func (a *Client) SvmPeerDelete(params *SvmPeerDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SvmPeerDeleteOK, *SvmPeerDeleteAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSvmPeerDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "svm_peer_delete",
		Method:             "DELETE",
		PathPattern:        "/svm/peers/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SvmPeerDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *SvmPeerDeleteOK:
		return value, nil, nil
	case *SvmPeerDeleteAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SvmPeerDeleteDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
SvmPeerDeleteCollection svm peer delete collection API
*/
func (a *Client) SvmPeerDeleteCollection(params *SvmPeerDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SvmPeerDeleteCollectionOK, *SvmPeerDeleteCollectionAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSvmPeerDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "svm_peer_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/svm/peers",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SvmPeerDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *SvmPeerDeleteCollectionOK:
		return value, nil, nil
	case *SvmPeerDeleteCollectionAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SvmPeerDeleteCollectionDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SvmPeerInstanceGet Retrieves the SVM peer relationship instance.

### Related ONTAP commands
* `vserver peer show`
### Example
Retrieves the parameters of an SVM peer relationship.
<br/>
```
GET "/api/svm/peers/d3268a74-ee76-11e8-a9bb-005056ac6dc9"
```
<br/>
### Learn more
* [`DOC /svm/peers`](#docs-svm-svm_peers)
*/
func (a *Client) SvmPeerInstanceGet(params *SvmPeerInstanceGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SvmPeerInstanceGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSvmPeerInstanceGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "svm_peer_instance_get",
		Method:             "GET",
		PathPattern:        "/svm/peers/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SvmPeerInstanceGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SvmPeerInstanceGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SvmPeerInstanceGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SvmPeerModify Updates the SVM peer relationship.

### Related ONTAP commands
* `vserver peer modify`
### Examples
The following examples show how to update an SVM peer relationship. The input parameter 'name' refers to the local name of the peer SVM.
<br/>
 1. Accepts an SVM peer relationship
    <br/>
    ```
    PATCH "/api/svm/peers/d3268a74-ee76-11e8-a9bb-005056ac6dc9" '{"state":"peered"}'
    ```
    <br/>
 2. Updates the local name of an SVM peer relationship
    <br/>
    ```
    PATCH "/api/svm/peers/d3268a74-ee76-11e8-a9bb-005056ac6dc9" '{"name":"vs2"}'
    ```
    <br/>
 2. Suspends an SVM peer relationship using force flag
    <br/>
    ```
    PATCH "/api/svm/peers/d3268a74-ee76-11e8-a9bb-005056ac6dc9" '{"state":"suspended", "force": "true"}'
    ```
    <br/>

### Learn more
* [`DOC /svm/peers`](#docs-svm-svm_peers)
*/
func (a *Client) SvmPeerModify(params *SvmPeerModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SvmPeerModifyOK, *SvmPeerModifyAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSvmPeerModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "svm_peer_modify",
		Method:             "PATCH",
		PathPattern:        "/svm/peers/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SvmPeerModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *SvmPeerModifyOK:
		return value, nil, nil
	case *SvmPeerModifyAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SvmPeerModifyDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
SvmPeerModifyCollection svm peer modify collection API
*/
func (a *Client) SvmPeerModifyCollection(params *SvmPeerModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SvmPeerModifyCollectionOK, *SvmPeerModifyCollectionAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSvmPeerModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "svm_peer_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/svm/peers",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SvmPeerModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *SvmPeerModifyCollectionOK:
		return value, nil, nil
	case *SvmPeerModifyCollectionAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SvmPeerModifyCollectionDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SvmPeerPermissionCollectionGet Retrieves the list of SVM peer permissions.

### Related ONTAP commands
* `vserver peer permission show`
### Examples
The following examples show how to retrieve a collection of SVM peer permissions based on a query.
<br/>
 1. Retrieves a list of SVM peer permissions of a specific local SVM
    <br/>
    ```
    GET "/api/svm/peer-permissions/?svm.name=VS1"
    ```
    <br/>
 2. Retrieves a list of SVM peer permissions of a specific cluster peer
    <br/>
    ```
    GET "/api/svm/peer-permissions/?cluster_peer.name=cluster2"
    ```
    <br/>

### Learn more
* [`DOC /svm/peer-permissions`](#docs-svm-svm_peer-permissions)
*/
func (a *Client) SvmPeerPermissionCollectionGet(params *SvmPeerPermissionCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SvmPeerPermissionCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSvmPeerPermissionCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "svm_peer_permission_collection_get",
		Method:             "GET",
		PathPattern:        "/svm/peer-permissions",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SvmPeerPermissionCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SvmPeerPermissionCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SvmPeerPermissionCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SvmPeerPermissionCreate Creates an SVM peer permission.

### Required properties
* `svm.name` or `svm.uuid` - SVM name
* `cluster_peer.uuid` or `cluster_peer.name` - Peer cluster name or peer cluster UUID
* `applications` - Peering applications
### Related ONTAP commands
* `vserver peer permission create`
### Examples
The following examples show how to create SVM peer permissions.
<br/>
 1. Creates an SVM peer permission entry with the local SVM and cluster peer names
    <br/>
    ```
    POST "/api/svm/peer-permissions" '{"cluster_peer":{"name":"cluster2"}, "svm":{"name":"VS1"}, "applications":["snapmirror"]}'
    ```
    <br/>
 2. Creates an SVM peer permission entry with the local SVM and cluster peer UUID
    <br/>
    ```
    POST "/api/svm/peer-permissions" '{"cluster_peer":{"uuid":"d3268a74-ee76-11e8-a9bb-005056ac6dc9"}, "svm":{"uuid":"8f467b93-f2f1-11e8-9027-005056ac81fc"}, "applications":["snapmirror"]}'
    ```
    <br/>
 3. Creates an SVM peer permission entry with all SVMs and the cluster peer name
    <br/>
    ```
    POST "/api/svm/peer-permissions" '{"cluster_peer":{"name":"cluster2"}, "svm":{"name":"*"}, "applications":["snapmirror"]}'
    ```
    <br/>

### Learn more
* [`DOC /svm/peer-permissions`](#docs-svm-svm_peer-permissions)
*/
func (a *Client) SvmPeerPermissionCreate(params *SvmPeerPermissionCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SvmPeerPermissionCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSvmPeerPermissionCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "svm_peer_permission_create",
		Method:             "POST",
		PathPattern:        "/svm/peer-permissions",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SvmPeerPermissionCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SvmPeerPermissionCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SvmPeerPermissionCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SvmPeerPermissionDelete Deletes the SVM peer permissions.

### Related ONTAP commands
* `vserver peer permission delete`
### Example
Deletes an SVM peer permission.
<br/>
```
DELETE "/api/svm/peer-permissions/d3268a74-ee76-11e8-a9bb-005056ac6dc9/8f467b93-f2f1-11e8-9027-005056ac81fc"
```
<br/>
### Learn more
* [`DOC /svm/peer-permissions`](#docs-svm-svm_peer-permissions)
*/
func (a *Client) SvmPeerPermissionDelete(params *SvmPeerPermissionDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SvmPeerPermissionDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSvmPeerPermissionDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "svm_peer_permission_delete",
		Method:             "DELETE",
		PathPattern:        "/svm/peer-permissions/{cluster_peer.uuid}/{svm.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SvmPeerPermissionDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SvmPeerPermissionDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SvmPeerPermissionDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
SvmPeerPermissionDeleteCollection svm peer permission delete collection API
*/
func (a *Client) SvmPeerPermissionDeleteCollection(params *SvmPeerPermissionDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SvmPeerPermissionDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSvmPeerPermissionDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "svm_peer_permission_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/svm/peer-permissions",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SvmPeerPermissionDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SvmPeerPermissionDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SvmPeerPermissionDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SvmPeerPermissionInstanceGet Retrieves the SVM peer permission instance.

### Related ONTAP commands
* `vserver peer permission show`
### Example
The following example shows how to retrieve the parameters for an SVM peer permission.
<br/>
```
GET "/api/svm/peer-permissions/d3268a74-ee76-11e8-a9bb-005056ac6dc9/8f467b93-f2f1-11e8-9027-005056ac81fc"
```
<br/>
### Learn more
* [`DOC /svm/peer-permissions`](#docs-svm-svm_peer-permissions)
*/
func (a *Client) SvmPeerPermissionInstanceGet(params *SvmPeerPermissionInstanceGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SvmPeerPermissionInstanceGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSvmPeerPermissionInstanceGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "svm_peer_permission_instance_get",
		Method:             "GET",
		PathPattern:        "/svm/peer-permissions/{cluster_peer.uuid}/{svm.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SvmPeerPermissionInstanceGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SvmPeerPermissionInstanceGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SvmPeerPermissionInstanceGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SvmPeerPermissionModify Updates the SVM peer permissions.

### Related ONTAP commands
* `vserver peer permission modify`
### Example
Updates an SVM peer permission.
<br/>
```
PATCH "/api/svm/peer-permissions/d3268a74-ee76-11e8-a9bb-005056ac6dc9/8f467b93-f2f1-11e8-9027-005056ac81fc" '{"applications":["flexcache"]}'
```
<br/>
### Learn more
* [`DOC /svm/peer-permissions`](#docs-svm-svm_peer-permissions)
*/
func (a *Client) SvmPeerPermissionModify(params *SvmPeerPermissionModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SvmPeerPermissionModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSvmPeerPermissionModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "svm_peer_permission_modify",
		Method:             "PATCH",
		PathPattern:        "/svm/peer-permissions/{cluster_peer.uuid}/{svm.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SvmPeerPermissionModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SvmPeerPermissionModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SvmPeerPermissionModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
SvmPeerPermissionModifyCollection svm peer permission modify collection API
*/
func (a *Client) SvmPeerPermissionModifyCollection(params *SvmPeerPermissionModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SvmPeerPermissionModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSvmPeerPermissionModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "svm_peer_permission_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/svm/peer-permissions",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SvmPeerPermissionModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SvmPeerPermissionModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SvmPeerPermissionModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
TopMetricsSvmClientCollectionGet Retrieves a list of clients with the most I/O activity.
*/
func (a *Client) TopMetricsSvmClientCollectionGet(params *TopMetricsSvmClientCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*TopMetricsSvmClientCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewTopMetricsSvmClientCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "top_metrics_svm_client_collection_get",
		Method:             "GET",
		PathPattern:        "/svm/svms/{svm.uuid}/top-metrics/clients",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &TopMetricsSvmClientCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*TopMetricsSvmClientCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*TopMetricsSvmClientCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
TopMetricsSvmDirectoryCollectionGet Retrieves a list of directories with the most I/O activity.
*/
func (a *Client) TopMetricsSvmDirectoryCollectionGet(params *TopMetricsSvmDirectoryCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*TopMetricsSvmDirectoryCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewTopMetricsSvmDirectoryCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "top_metrics_svm_directory_collection_get",
		Method:             "GET",
		PathPattern:        "/svm/svms/{svm.uuid}/top-metrics/directories",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &TopMetricsSvmDirectoryCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*TopMetricsSvmDirectoryCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*TopMetricsSvmDirectoryCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
TopMetricsSvmFileCollectionGet Retrieves a list of files with the most I/O activity.
*/
func (a *Client) TopMetricsSvmFileCollectionGet(params *TopMetricsSvmFileCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*TopMetricsSvmFileCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewTopMetricsSvmFileCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "top_metrics_svm_file_collection_get",
		Method:             "GET",
		PathPattern:        "/svm/svms/{svm.uuid}/top-metrics/files",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &TopMetricsSvmFileCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*TopMetricsSvmFileCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*TopMetricsSvmFileCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
TopMetricsSvmUserCollectionGet Retrieves a list of users with the most I/O activity.
*/
func (a *Client) TopMetricsSvmUserCollectionGet(params *TopMetricsSvmUserCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*TopMetricsSvmUserCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewTopMetricsSvmUserCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "top_metrics_svm_user_collection_get",
		Method:             "GET",
		PathPattern:        "/svm/svms/{svm.uuid}/top-metrics/users",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &TopMetricsSvmUserCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*TopMetricsSvmUserCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*TopMetricsSvmUserCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WebSvmGet Retrieves the web services security configuration.
*/
func (a *Client) WebSvmGet(params *WebSvmGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WebSvmGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWebSvmGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "web_svm_get",
		Method:             "GET",
		PathPattern:        "/svm/svms/{svm.uuid}/web",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WebSvmGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WebSvmGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WebSvmGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WebSvmModify Updates the web services security configuration.
*/
func (a *Client) WebSvmModify(params *WebSvmModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WebSvmModifyOK, *WebSvmModifyAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWebSvmModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "web_svm_modify",
		Method:             "PATCH",
		PathPattern:        "/svm/svms/{svm.uuid}/web",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WebSvmModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *WebSvmModifyOK:
		return value, nil, nil
	case *WebSvmModifyAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WebSvmModifyDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}
