// Code generated by go-swagger; DO NOT EDIT.

package svm

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SvmCollectionGetReader is a Reader for the SvmCollectionGet structure.
type SvmCollectionGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SvmCollectionGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSvmCollectionGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSvmCollectionGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSvmCollectionGetOK creates a SvmCollectionGetOK with default headers values
func NewSvmCollectionGetOK() *SvmCollectionGetOK {
	return &SvmCollectionGetOK{}
}

/*
SvmCollectionGetOK describes a response with status code 200, with default header values.

OK
*/
type SvmCollectionGetOK struct {
	Payload *models.SvmResponse
}

// IsSuccess returns true when this svm collection get o k response has a 2xx status code
func (o *SvmCollectionGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this svm collection get o k response has a 3xx status code
func (o *SvmCollectionGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this svm collection get o k response has a 4xx status code
func (o *SvmCollectionGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this svm collection get o k response has a 5xx status code
func (o *SvmCollectionGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this svm collection get o k response a status code equal to that given
func (o *SvmCollectionGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the svm collection get o k response
func (o *SvmCollectionGetOK) Code() int {
	return 200
}

func (o *SvmCollectionGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /svm/svms][%d] svmCollectionGetOK %s", 200, payload)
}

func (o *SvmCollectionGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /svm/svms][%d] svmCollectionGetOK %s", 200, payload)
}

func (o *SvmCollectionGetOK) GetPayload() *models.SvmResponse {
	return o.Payload
}

func (o *SvmCollectionGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SvmResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSvmCollectionGetDefault creates a SvmCollectionGetDefault with default headers values
func NewSvmCollectionGetDefault(code int) *SvmCollectionGetDefault {
	return &SvmCollectionGetDefault{
		_statusCode: code,
	}
}

/*
SvmCollectionGetDefault describes a response with status code -1, with default header values.

Error
*/
type SvmCollectionGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this svm collection get default response has a 2xx status code
func (o *SvmCollectionGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this svm collection get default response has a 3xx status code
func (o *SvmCollectionGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this svm collection get default response has a 4xx status code
func (o *SvmCollectionGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this svm collection get default response has a 5xx status code
func (o *SvmCollectionGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this svm collection get default response a status code equal to that given
func (o *SvmCollectionGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the svm collection get default response
func (o *SvmCollectionGetDefault) Code() int {
	return o._statusCode
}

func (o *SvmCollectionGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /svm/svms][%d] svm_collection_get default %s", o._statusCode, payload)
}

func (o *SvmCollectionGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /svm/svms][%d] svm_collection_get default %s", o._statusCode, payload)
}

func (o *SvmCollectionGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SvmCollectionGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
