// Code generated by go-swagger; DO NOT EDIT.

package svm

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SvmDeleteCollectionReader is a Reader for the SvmDeleteCollection structure.
type SvmDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SvmDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSvmDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewSvmDeleteCollectionAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSvmDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSvmDeleteCollectionOK creates a SvmDeleteCollectionOK with default headers values
func NewSvmDeleteCollectionOK() *SvmDeleteCollectionOK {
	return &SvmDeleteCollectionOK{}
}

/*
SvmDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type SvmDeleteCollectionOK struct {
	Payload *models.SvmJobLinkResponse
}

// IsSuccess returns true when this svm delete collection o k response has a 2xx status code
func (o *SvmDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this svm delete collection o k response has a 3xx status code
func (o *SvmDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this svm delete collection o k response has a 4xx status code
func (o *SvmDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this svm delete collection o k response has a 5xx status code
func (o *SvmDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this svm delete collection o k response a status code equal to that given
func (o *SvmDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the svm delete collection o k response
func (o *SvmDeleteCollectionOK) Code() int {
	return 200
}

func (o *SvmDeleteCollectionOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /svm/svms][%d] svmDeleteCollectionOK %s", 200, payload)
}

func (o *SvmDeleteCollectionOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /svm/svms][%d] svmDeleteCollectionOK %s", 200, payload)
}

func (o *SvmDeleteCollectionOK) GetPayload() *models.SvmJobLinkResponse {
	return o.Payload
}

func (o *SvmDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SvmJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSvmDeleteCollectionAccepted creates a SvmDeleteCollectionAccepted with default headers values
func NewSvmDeleteCollectionAccepted() *SvmDeleteCollectionAccepted {
	return &SvmDeleteCollectionAccepted{}
}

/*
SvmDeleteCollectionAccepted describes a response with status code 202, with default header values.

Accepted
*/
type SvmDeleteCollectionAccepted struct {
	Payload *models.SvmJobLinkResponse
}

// IsSuccess returns true when this svm delete collection accepted response has a 2xx status code
func (o *SvmDeleteCollectionAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this svm delete collection accepted response has a 3xx status code
func (o *SvmDeleteCollectionAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this svm delete collection accepted response has a 4xx status code
func (o *SvmDeleteCollectionAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this svm delete collection accepted response has a 5xx status code
func (o *SvmDeleteCollectionAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this svm delete collection accepted response a status code equal to that given
func (o *SvmDeleteCollectionAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the svm delete collection accepted response
func (o *SvmDeleteCollectionAccepted) Code() int {
	return 202
}

func (o *SvmDeleteCollectionAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /svm/svms][%d] svmDeleteCollectionAccepted %s", 202, payload)
}

func (o *SvmDeleteCollectionAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /svm/svms][%d] svmDeleteCollectionAccepted %s", 202, payload)
}

func (o *SvmDeleteCollectionAccepted) GetPayload() *models.SvmJobLinkResponse {
	return o.Payload
}

func (o *SvmDeleteCollectionAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SvmJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSvmDeleteCollectionDefault creates a SvmDeleteCollectionDefault with default headers values
func NewSvmDeleteCollectionDefault(code int) *SvmDeleteCollectionDefault {
	return &SvmDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
	SvmDeleteCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

<br/>
```
| Error codes | Description |
| ----------- | ----------- |
| 13434894    | Maximum allowed SVM jobs exceeded. Wait and retry. |
| 2621525     | SVM cannot be deleted as it is associated with an Active Directory configured CIFS server. Delete the CIFS server using "cifs delete" and retry the operation. |
```
<br/>
*/
type SvmDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this svm delete collection default response has a 2xx status code
func (o *SvmDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this svm delete collection default response has a 3xx status code
func (o *SvmDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this svm delete collection default response has a 4xx status code
func (o *SvmDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this svm delete collection default response has a 5xx status code
func (o *SvmDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this svm delete collection default response a status code equal to that given
func (o *SvmDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the svm delete collection default response
func (o *SvmDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *SvmDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /svm/svms][%d] svm_delete_collection default %s", o._statusCode, payload)
}

func (o *SvmDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /svm/svms][%d] svm_delete_collection default %s", o._statusCode, payload)
}

func (o *SvmDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SvmDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
SvmDeleteCollectionBody svm delete collection body
swagger:model SvmDeleteCollectionBody
*/
type SvmDeleteCollectionBody struct {

	// svm response inline records
	SvmResponseInlineRecords []*models.Svm `json:"records,omitempty"`
}

// Validate validates this svm delete collection body
func (o *SvmDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSvmResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmDeleteCollectionBody) validateSvmResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.SvmResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.SvmResponseInlineRecords); i++ {
		if swag.IsZero(o.SvmResponseInlineRecords[i]) { // not required
			continue
		}

		if o.SvmResponseInlineRecords[i] != nil {
			if err := o.SvmResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this svm delete collection body based on the context it is used
func (o *SvmDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSvmResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmDeleteCollectionBody) contextValidateSvmResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.SvmResponseInlineRecords); i++ {

		if o.SvmResponseInlineRecords[i] != nil {
			if err := o.SvmResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *SvmDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SvmDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res SvmDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
