// Code generated by go-swagger; DO NOT EDIT.

package svm

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewSvmMigrationCollectionGetParams creates a new SvmMigrationCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSvmMigrationCollectionGetParams() *SvmMigrationCollectionGetParams {
	return &SvmMigrationCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSvmMigrationCollectionGetParamsWithTimeout creates a new SvmMigrationCollectionGetParams object
// with the ability to set a timeout on a request.
func NewSvmMigrationCollectionGetParamsWithTimeout(timeout time.Duration) *SvmMigrationCollectionGetParams {
	return &SvmMigrationCollectionGetParams{
		timeout: timeout,
	}
}

// NewSvmMigrationCollectionGetParamsWithContext creates a new SvmMigrationCollectionGetParams object
// with the ability to set a context for a request.
func NewSvmMigrationCollectionGetParamsWithContext(ctx context.Context) *SvmMigrationCollectionGetParams {
	return &SvmMigrationCollectionGetParams{
		Context: ctx,
	}
}

// NewSvmMigrationCollectionGetParamsWithHTTPClient creates a new SvmMigrationCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewSvmMigrationCollectionGetParamsWithHTTPClient(client *http.Client) *SvmMigrationCollectionGetParams {
	return &SvmMigrationCollectionGetParams{
		HTTPClient: client,
	}
}

/*
SvmMigrationCollectionGetParams contains all the parameters to send to the API endpoint

	for the svm migration collection get operation.

	Typically these are written to a http.Request.
*/
type SvmMigrationCollectionGetParams struct {

	/* AutoCutover.

	   Filter by auto_cutover
	*/
	AutoCutover *bool

	/* AutoSourceCleanup.

	   Filter by auto_source_cleanup
	*/
	AutoSourceCleanup *bool

	/* CurrentOperation.

	   Filter by current_operation
	*/
	CurrentOperation *string

	/* DestinationIpspaceName.

	   Filter by destination.ipspace.name
	*/
	DestinationIpspaceName *string

	/* DestinationIpspaceUUID.

	   Filter by destination.ipspace.uuid
	*/
	DestinationIpspaceUUID *string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* LastFailedState.

	   Filter by last_failed_state
	*/
	LastFailedState *string

	/* LastOperation.

	   Filter by last_operation
	*/
	LastOperation *string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* MessagesCode.

	   Filter by messages.code
	*/
	MessagesCode *string

	/* MessagesMessage.

	   Filter by messages.message
	*/
	MessagesMessage *string

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* PointOfNoReturn.

	   Filter by point_of_no_return
	*/
	PointOfNoReturn *bool

	/* PostPonrRetryCount.

	   Filter by post_ponr_retry_count
	*/
	PostPonrRetryCount *int64

	/* RestartCount.

	   Filter by restart_count
	*/
	RestartCount *int64

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SourceClusterName.

	   Filter by source.cluster.name
	*/
	SourceClusterName *string

	/* SourceClusterUUID.

	   Filter by source.cluster.uuid
	*/
	SourceClusterUUID *string

	/* SourceSvmName.

	   Filter by source.svm.name
	*/
	SourceSvmName *string

	/* SourceSvmUUID.

	   Filter by source.svm.uuid
	*/
	SourceSvmUUID *string

	/* State.

	   Filter by state
	*/
	State *string

	/* Throttle.

	   Filter by throttle
	*/
	Throttle *int64

	/* TimeMetricsCutoverCompleteTime.

	   Filter by time_metrics.cutover_complete_time
	*/
	TimeMetricsCutoverCompleteTime *string

	/* TimeMetricsCutoverStartTime.

	   Filter by time_metrics.cutover_start_time
	*/
	TimeMetricsCutoverStartTime *string

	/* TimeMetricsCutoverTriggerTime.

	   Filter by time_metrics.cutover_trigger_time
	*/
	TimeMetricsCutoverTriggerTime *string

	/* TimeMetricsEndTime.

	   Filter by time_metrics.end_time
	*/
	TimeMetricsEndTime *string

	/* TimeMetricsLastPauseTime.

	   Filter by time_metrics.last_pause_time
	*/
	TimeMetricsLastPauseTime *string

	/* TimeMetricsLastPostPonrRetryTime.

	   Filter by time_metrics.last_post_ponr_retry_time
	*/
	TimeMetricsLastPostPonrRetryTime *string

	/* TimeMetricsLastResumeTime.

	   Filter by time_metrics.last_resume_time
	*/
	TimeMetricsLastResumeTime *string

	/* TimeMetricsStartTime.

	   Filter by time_metrics.start_time
	*/
	TimeMetricsStartTime *string

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the svm migration collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SvmMigrationCollectionGetParams) WithDefaults() *SvmMigrationCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the svm migration collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SvmMigrationCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := SvmMigrationCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the svm migration collection get params
func (o *SvmMigrationCollectionGetParams) WithTimeout(timeout time.Duration) *SvmMigrationCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the svm migration collection get params
func (o *SvmMigrationCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the svm migration collection get params
func (o *SvmMigrationCollectionGetParams) WithContext(ctx context.Context) *SvmMigrationCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the svm migration collection get params
func (o *SvmMigrationCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the svm migration collection get params
func (o *SvmMigrationCollectionGetParams) WithHTTPClient(client *http.Client) *SvmMigrationCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the svm migration collection get params
func (o *SvmMigrationCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAutoCutover adds the autoCutover to the svm migration collection get params
func (o *SvmMigrationCollectionGetParams) WithAutoCutover(autoCutover *bool) *SvmMigrationCollectionGetParams {
	o.SetAutoCutover(autoCutover)
	return o
}

// SetAutoCutover adds the autoCutover to the svm migration collection get params
func (o *SvmMigrationCollectionGetParams) SetAutoCutover(autoCutover *bool) {
	o.AutoCutover = autoCutover
}

// WithAutoSourceCleanup adds the autoSourceCleanup to the svm migration collection get params
func (o *SvmMigrationCollectionGetParams) WithAutoSourceCleanup(autoSourceCleanup *bool) *SvmMigrationCollectionGetParams {
	o.SetAutoSourceCleanup(autoSourceCleanup)
	return o
}

// SetAutoSourceCleanup adds the autoSourceCleanup to the svm migration collection get params
func (o *SvmMigrationCollectionGetParams) SetAutoSourceCleanup(autoSourceCleanup *bool) {
	o.AutoSourceCleanup = autoSourceCleanup
}

// WithCurrentOperation adds the currentOperation to the svm migration collection get params
func (o *SvmMigrationCollectionGetParams) WithCurrentOperation(currentOperation *string) *SvmMigrationCollectionGetParams {
	o.SetCurrentOperation(currentOperation)
	return o
}

// SetCurrentOperation adds the currentOperation to the svm migration collection get params
func (o *SvmMigrationCollectionGetParams) SetCurrentOperation(currentOperation *string) {
	o.CurrentOperation = currentOperation
}

// WithDestinationIpspaceName adds the destinationIpspaceName to the svm migration collection get params
func (o *SvmMigrationCollectionGetParams) WithDestinationIpspaceName(destinationIpspaceName *string) *SvmMigrationCollectionGetParams {
	o.SetDestinationIpspaceName(destinationIpspaceName)
	return o
}

// SetDestinationIpspaceName adds the destinationIpspaceName to the svm migration collection get params
func (o *SvmMigrationCollectionGetParams) SetDestinationIpspaceName(destinationIpspaceName *string) {
	o.DestinationIpspaceName = destinationIpspaceName
}

// WithDestinationIpspaceUUID adds the destinationIpspaceUUID to the svm migration collection get params
func (o *SvmMigrationCollectionGetParams) WithDestinationIpspaceUUID(destinationIpspaceUUID *string) *SvmMigrationCollectionGetParams {
	o.SetDestinationIpspaceUUID(destinationIpspaceUUID)
	return o
}

// SetDestinationIpspaceUUID adds the destinationIpspaceUuid to the svm migration collection get params
func (o *SvmMigrationCollectionGetParams) SetDestinationIpspaceUUID(destinationIpspaceUUID *string) {
	o.DestinationIpspaceUUID = destinationIpspaceUUID
}

// WithFields adds the fields to the svm migration collection get params
func (o *SvmMigrationCollectionGetParams) WithFields(fields []string) *SvmMigrationCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the svm migration collection get params
func (o *SvmMigrationCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithLastFailedState adds the lastFailedState to the svm migration collection get params
func (o *SvmMigrationCollectionGetParams) WithLastFailedState(lastFailedState *string) *SvmMigrationCollectionGetParams {
	o.SetLastFailedState(lastFailedState)
	return o
}

// SetLastFailedState adds the lastFailedState to the svm migration collection get params
func (o *SvmMigrationCollectionGetParams) SetLastFailedState(lastFailedState *string) {
	o.LastFailedState = lastFailedState
}

// WithLastOperation adds the lastOperation to the svm migration collection get params
func (o *SvmMigrationCollectionGetParams) WithLastOperation(lastOperation *string) *SvmMigrationCollectionGetParams {
	o.SetLastOperation(lastOperation)
	return o
}

// SetLastOperation adds the lastOperation to the svm migration collection get params
func (o *SvmMigrationCollectionGetParams) SetLastOperation(lastOperation *string) {
	o.LastOperation = lastOperation
}

// WithMaxRecords adds the maxRecords to the svm migration collection get params
func (o *SvmMigrationCollectionGetParams) WithMaxRecords(maxRecords *int64) *SvmMigrationCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the svm migration collection get params
func (o *SvmMigrationCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithMessagesCode adds the messagesCode to the svm migration collection get params
func (o *SvmMigrationCollectionGetParams) WithMessagesCode(messagesCode *string) *SvmMigrationCollectionGetParams {
	o.SetMessagesCode(messagesCode)
	return o
}

// SetMessagesCode adds the messagesCode to the svm migration collection get params
func (o *SvmMigrationCollectionGetParams) SetMessagesCode(messagesCode *string) {
	o.MessagesCode = messagesCode
}

// WithMessagesMessage adds the messagesMessage to the svm migration collection get params
func (o *SvmMigrationCollectionGetParams) WithMessagesMessage(messagesMessage *string) *SvmMigrationCollectionGetParams {
	o.SetMessagesMessage(messagesMessage)
	return o
}

// SetMessagesMessage adds the messagesMessage to the svm migration collection get params
func (o *SvmMigrationCollectionGetParams) SetMessagesMessage(messagesMessage *string) {
	o.MessagesMessage = messagesMessage
}

// WithOrderBy adds the orderBy to the svm migration collection get params
func (o *SvmMigrationCollectionGetParams) WithOrderBy(orderBy []string) *SvmMigrationCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the svm migration collection get params
func (o *SvmMigrationCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithPointOfNoReturn adds the pointOfNoReturn to the svm migration collection get params
func (o *SvmMigrationCollectionGetParams) WithPointOfNoReturn(pointOfNoReturn *bool) *SvmMigrationCollectionGetParams {
	o.SetPointOfNoReturn(pointOfNoReturn)
	return o
}

// SetPointOfNoReturn adds the pointOfNoReturn to the svm migration collection get params
func (o *SvmMigrationCollectionGetParams) SetPointOfNoReturn(pointOfNoReturn *bool) {
	o.PointOfNoReturn = pointOfNoReturn
}

// WithPostPonrRetryCount adds the postPonrRetryCount to the svm migration collection get params
func (o *SvmMigrationCollectionGetParams) WithPostPonrRetryCount(postPonrRetryCount *int64) *SvmMigrationCollectionGetParams {
	o.SetPostPonrRetryCount(postPonrRetryCount)
	return o
}

// SetPostPonrRetryCount adds the postPonrRetryCount to the svm migration collection get params
func (o *SvmMigrationCollectionGetParams) SetPostPonrRetryCount(postPonrRetryCount *int64) {
	o.PostPonrRetryCount = postPonrRetryCount
}

// WithRestartCount adds the restartCount to the svm migration collection get params
func (o *SvmMigrationCollectionGetParams) WithRestartCount(restartCount *int64) *SvmMigrationCollectionGetParams {
	o.SetRestartCount(restartCount)
	return o
}

// SetRestartCount adds the restartCount to the svm migration collection get params
func (o *SvmMigrationCollectionGetParams) SetRestartCount(restartCount *int64) {
	o.RestartCount = restartCount
}

// WithReturnRecords adds the returnRecords to the svm migration collection get params
func (o *SvmMigrationCollectionGetParams) WithReturnRecords(returnRecords *bool) *SvmMigrationCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the svm migration collection get params
func (o *SvmMigrationCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the svm migration collection get params
func (o *SvmMigrationCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *SvmMigrationCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the svm migration collection get params
func (o *SvmMigrationCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSourceClusterName adds the sourceClusterName to the svm migration collection get params
func (o *SvmMigrationCollectionGetParams) WithSourceClusterName(sourceClusterName *string) *SvmMigrationCollectionGetParams {
	o.SetSourceClusterName(sourceClusterName)
	return o
}

// SetSourceClusterName adds the sourceClusterName to the svm migration collection get params
func (o *SvmMigrationCollectionGetParams) SetSourceClusterName(sourceClusterName *string) {
	o.SourceClusterName = sourceClusterName
}

// WithSourceClusterUUID adds the sourceClusterUUID to the svm migration collection get params
func (o *SvmMigrationCollectionGetParams) WithSourceClusterUUID(sourceClusterUUID *string) *SvmMigrationCollectionGetParams {
	o.SetSourceClusterUUID(sourceClusterUUID)
	return o
}

// SetSourceClusterUUID adds the sourceClusterUuid to the svm migration collection get params
func (o *SvmMigrationCollectionGetParams) SetSourceClusterUUID(sourceClusterUUID *string) {
	o.SourceClusterUUID = sourceClusterUUID
}

// WithSourceSvmName adds the sourceSvmName to the svm migration collection get params
func (o *SvmMigrationCollectionGetParams) WithSourceSvmName(sourceSvmName *string) *SvmMigrationCollectionGetParams {
	o.SetSourceSvmName(sourceSvmName)
	return o
}

// SetSourceSvmName adds the sourceSvmName to the svm migration collection get params
func (o *SvmMigrationCollectionGetParams) SetSourceSvmName(sourceSvmName *string) {
	o.SourceSvmName = sourceSvmName
}

// WithSourceSvmUUID adds the sourceSvmUUID to the svm migration collection get params
func (o *SvmMigrationCollectionGetParams) WithSourceSvmUUID(sourceSvmUUID *string) *SvmMigrationCollectionGetParams {
	o.SetSourceSvmUUID(sourceSvmUUID)
	return o
}

// SetSourceSvmUUID adds the sourceSvmUuid to the svm migration collection get params
func (o *SvmMigrationCollectionGetParams) SetSourceSvmUUID(sourceSvmUUID *string) {
	o.SourceSvmUUID = sourceSvmUUID
}

// WithState adds the state to the svm migration collection get params
func (o *SvmMigrationCollectionGetParams) WithState(state *string) *SvmMigrationCollectionGetParams {
	o.SetState(state)
	return o
}

// SetState adds the state to the svm migration collection get params
func (o *SvmMigrationCollectionGetParams) SetState(state *string) {
	o.State = state
}

// WithThrottle adds the throttle to the svm migration collection get params
func (o *SvmMigrationCollectionGetParams) WithThrottle(throttle *int64) *SvmMigrationCollectionGetParams {
	o.SetThrottle(throttle)
	return o
}

// SetThrottle adds the throttle to the svm migration collection get params
func (o *SvmMigrationCollectionGetParams) SetThrottle(throttle *int64) {
	o.Throttle = throttle
}

// WithTimeMetricsCutoverCompleteTime adds the timeMetricsCutoverCompleteTime to the svm migration collection get params
func (o *SvmMigrationCollectionGetParams) WithTimeMetricsCutoverCompleteTime(timeMetricsCutoverCompleteTime *string) *SvmMigrationCollectionGetParams {
	o.SetTimeMetricsCutoverCompleteTime(timeMetricsCutoverCompleteTime)
	return o
}

// SetTimeMetricsCutoverCompleteTime adds the timeMetricsCutoverCompleteTime to the svm migration collection get params
func (o *SvmMigrationCollectionGetParams) SetTimeMetricsCutoverCompleteTime(timeMetricsCutoverCompleteTime *string) {
	o.TimeMetricsCutoverCompleteTime = timeMetricsCutoverCompleteTime
}

// WithTimeMetricsCutoverStartTime adds the timeMetricsCutoverStartTime to the svm migration collection get params
func (o *SvmMigrationCollectionGetParams) WithTimeMetricsCutoverStartTime(timeMetricsCutoverStartTime *string) *SvmMigrationCollectionGetParams {
	o.SetTimeMetricsCutoverStartTime(timeMetricsCutoverStartTime)
	return o
}

// SetTimeMetricsCutoverStartTime adds the timeMetricsCutoverStartTime to the svm migration collection get params
func (o *SvmMigrationCollectionGetParams) SetTimeMetricsCutoverStartTime(timeMetricsCutoverStartTime *string) {
	o.TimeMetricsCutoverStartTime = timeMetricsCutoverStartTime
}

// WithTimeMetricsCutoverTriggerTime adds the timeMetricsCutoverTriggerTime to the svm migration collection get params
func (o *SvmMigrationCollectionGetParams) WithTimeMetricsCutoverTriggerTime(timeMetricsCutoverTriggerTime *string) *SvmMigrationCollectionGetParams {
	o.SetTimeMetricsCutoverTriggerTime(timeMetricsCutoverTriggerTime)
	return o
}

// SetTimeMetricsCutoverTriggerTime adds the timeMetricsCutoverTriggerTime to the svm migration collection get params
func (o *SvmMigrationCollectionGetParams) SetTimeMetricsCutoverTriggerTime(timeMetricsCutoverTriggerTime *string) {
	o.TimeMetricsCutoverTriggerTime = timeMetricsCutoverTriggerTime
}

// WithTimeMetricsEndTime adds the timeMetricsEndTime to the svm migration collection get params
func (o *SvmMigrationCollectionGetParams) WithTimeMetricsEndTime(timeMetricsEndTime *string) *SvmMigrationCollectionGetParams {
	o.SetTimeMetricsEndTime(timeMetricsEndTime)
	return o
}

// SetTimeMetricsEndTime adds the timeMetricsEndTime to the svm migration collection get params
func (o *SvmMigrationCollectionGetParams) SetTimeMetricsEndTime(timeMetricsEndTime *string) {
	o.TimeMetricsEndTime = timeMetricsEndTime
}

// WithTimeMetricsLastPauseTime adds the timeMetricsLastPauseTime to the svm migration collection get params
func (o *SvmMigrationCollectionGetParams) WithTimeMetricsLastPauseTime(timeMetricsLastPauseTime *string) *SvmMigrationCollectionGetParams {
	o.SetTimeMetricsLastPauseTime(timeMetricsLastPauseTime)
	return o
}

// SetTimeMetricsLastPauseTime adds the timeMetricsLastPauseTime to the svm migration collection get params
func (o *SvmMigrationCollectionGetParams) SetTimeMetricsLastPauseTime(timeMetricsLastPauseTime *string) {
	o.TimeMetricsLastPauseTime = timeMetricsLastPauseTime
}

// WithTimeMetricsLastPostPonrRetryTime adds the timeMetricsLastPostPonrRetryTime to the svm migration collection get params
func (o *SvmMigrationCollectionGetParams) WithTimeMetricsLastPostPonrRetryTime(timeMetricsLastPostPonrRetryTime *string) *SvmMigrationCollectionGetParams {
	o.SetTimeMetricsLastPostPonrRetryTime(timeMetricsLastPostPonrRetryTime)
	return o
}

// SetTimeMetricsLastPostPonrRetryTime adds the timeMetricsLastPostPonrRetryTime to the svm migration collection get params
func (o *SvmMigrationCollectionGetParams) SetTimeMetricsLastPostPonrRetryTime(timeMetricsLastPostPonrRetryTime *string) {
	o.TimeMetricsLastPostPonrRetryTime = timeMetricsLastPostPonrRetryTime
}

// WithTimeMetricsLastResumeTime adds the timeMetricsLastResumeTime to the svm migration collection get params
func (o *SvmMigrationCollectionGetParams) WithTimeMetricsLastResumeTime(timeMetricsLastResumeTime *string) *SvmMigrationCollectionGetParams {
	o.SetTimeMetricsLastResumeTime(timeMetricsLastResumeTime)
	return o
}

// SetTimeMetricsLastResumeTime adds the timeMetricsLastResumeTime to the svm migration collection get params
func (o *SvmMigrationCollectionGetParams) SetTimeMetricsLastResumeTime(timeMetricsLastResumeTime *string) {
	o.TimeMetricsLastResumeTime = timeMetricsLastResumeTime
}

// WithTimeMetricsStartTime adds the timeMetricsStartTime to the svm migration collection get params
func (o *SvmMigrationCollectionGetParams) WithTimeMetricsStartTime(timeMetricsStartTime *string) *SvmMigrationCollectionGetParams {
	o.SetTimeMetricsStartTime(timeMetricsStartTime)
	return o
}

// SetTimeMetricsStartTime adds the timeMetricsStartTime to the svm migration collection get params
func (o *SvmMigrationCollectionGetParams) SetTimeMetricsStartTime(timeMetricsStartTime *string) {
	o.TimeMetricsStartTime = timeMetricsStartTime
}

// WithUUID adds the uuid to the svm migration collection get params
func (o *SvmMigrationCollectionGetParams) WithUUID(uuid *string) *SvmMigrationCollectionGetParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the svm migration collection get params
func (o *SvmMigrationCollectionGetParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *SvmMigrationCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.AutoCutover != nil {

		// query param auto_cutover
		var qrAutoCutover bool

		if o.AutoCutover != nil {
			qrAutoCutover = *o.AutoCutover
		}
		qAutoCutover := swag.FormatBool(qrAutoCutover)
		if qAutoCutover != "" {

			if err := r.SetQueryParam("auto_cutover", qAutoCutover); err != nil {
				return err
			}
		}
	}

	if o.AutoSourceCleanup != nil {

		// query param auto_source_cleanup
		var qrAutoSourceCleanup bool

		if o.AutoSourceCleanup != nil {
			qrAutoSourceCleanup = *o.AutoSourceCleanup
		}
		qAutoSourceCleanup := swag.FormatBool(qrAutoSourceCleanup)
		if qAutoSourceCleanup != "" {

			if err := r.SetQueryParam("auto_source_cleanup", qAutoSourceCleanup); err != nil {
				return err
			}
		}
	}

	if o.CurrentOperation != nil {

		// query param current_operation
		var qrCurrentOperation string

		if o.CurrentOperation != nil {
			qrCurrentOperation = *o.CurrentOperation
		}
		qCurrentOperation := qrCurrentOperation
		if qCurrentOperation != "" {

			if err := r.SetQueryParam("current_operation", qCurrentOperation); err != nil {
				return err
			}
		}
	}

	if o.DestinationIpspaceName != nil {

		// query param destination.ipspace.name
		var qrDestinationIpspaceName string

		if o.DestinationIpspaceName != nil {
			qrDestinationIpspaceName = *o.DestinationIpspaceName
		}
		qDestinationIpspaceName := qrDestinationIpspaceName
		if qDestinationIpspaceName != "" {

			if err := r.SetQueryParam("destination.ipspace.name", qDestinationIpspaceName); err != nil {
				return err
			}
		}
	}

	if o.DestinationIpspaceUUID != nil {

		// query param destination.ipspace.uuid
		var qrDestinationIpspaceUUID string

		if o.DestinationIpspaceUUID != nil {
			qrDestinationIpspaceUUID = *o.DestinationIpspaceUUID
		}
		qDestinationIpspaceUUID := qrDestinationIpspaceUUID
		if qDestinationIpspaceUUID != "" {

			if err := r.SetQueryParam("destination.ipspace.uuid", qDestinationIpspaceUUID); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.LastFailedState != nil {

		// query param last_failed_state
		var qrLastFailedState string

		if o.LastFailedState != nil {
			qrLastFailedState = *o.LastFailedState
		}
		qLastFailedState := qrLastFailedState
		if qLastFailedState != "" {

			if err := r.SetQueryParam("last_failed_state", qLastFailedState); err != nil {
				return err
			}
		}
	}

	if o.LastOperation != nil {

		// query param last_operation
		var qrLastOperation string

		if o.LastOperation != nil {
			qrLastOperation = *o.LastOperation
		}
		qLastOperation := qrLastOperation
		if qLastOperation != "" {

			if err := r.SetQueryParam("last_operation", qLastOperation); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.MessagesCode != nil {

		// query param messages.code
		var qrMessagesCode string

		if o.MessagesCode != nil {
			qrMessagesCode = *o.MessagesCode
		}
		qMessagesCode := qrMessagesCode
		if qMessagesCode != "" {

			if err := r.SetQueryParam("messages.code", qMessagesCode); err != nil {
				return err
			}
		}
	}

	if o.MessagesMessage != nil {

		// query param messages.message
		var qrMessagesMessage string

		if o.MessagesMessage != nil {
			qrMessagesMessage = *o.MessagesMessage
		}
		qMessagesMessage := qrMessagesMessage
		if qMessagesMessage != "" {

			if err := r.SetQueryParam("messages.message", qMessagesMessage); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.PointOfNoReturn != nil {

		// query param point_of_no_return
		var qrPointOfNoReturn bool

		if o.PointOfNoReturn != nil {
			qrPointOfNoReturn = *o.PointOfNoReturn
		}
		qPointOfNoReturn := swag.FormatBool(qrPointOfNoReturn)
		if qPointOfNoReturn != "" {

			if err := r.SetQueryParam("point_of_no_return", qPointOfNoReturn); err != nil {
				return err
			}
		}
	}

	if o.PostPonrRetryCount != nil {

		// query param post_ponr_retry_count
		var qrPostPonrRetryCount int64

		if o.PostPonrRetryCount != nil {
			qrPostPonrRetryCount = *o.PostPonrRetryCount
		}
		qPostPonrRetryCount := swag.FormatInt64(qrPostPonrRetryCount)
		if qPostPonrRetryCount != "" {

			if err := r.SetQueryParam("post_ponr_retry_count", qPostPonrRetryCount); err != nil {
				return err
			}
		}
	}

	if o.RestartCount != nil {

		// query param restart_count
		var qrRestartCount int64

		if o.RestartCount != nil {
			qrRestartCount = *o.RestartCount
		}
		qRestartCount := swag.FormatInt64(qrRestartCount)
		if qRestartCount != "" {

			if err := r.SetQueryParam("restart_count", qRestartCount); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SourceClusterName != nil {

		// query param source.cluster.name
		var qrSourceClusterName string

		if o.SourceClusterName != nil {
			qrSourceClusterName = *o.SourceClusterName
		}
		qSourceClusterName := qrSourceClusterName
		if qSourceClusterName != "" {

			if err := r.SetQueryParam("source.cluster.name", qSourceClusterName); err != nil {
				return err
			}
		}
	}

	if o.SourceClusterUUID != nil {

		// query param source.cluster.uuid
		var qrSourceClusterUUID string

		if o.SourceClusterUUID != nil {
			qrSourceClusterUUID = *o.SourceClusterUUID
		}
		qSourceClusterUUID := qrSourceClusterUUID
		if qSourceClusterUUID != "" {

			if err := r.SetQueryParam("source.cluster.uuid", qSourceClusterUUID); err != nil {
				return err
			}
		}
	}

	if o.SourceSvmName != nil {

		// query param source.svm.name
		var qrSourceSvmName string

		if o.SourceSvmName != nil {
			qrSourceSvmName = *o.SourceSvmName
		}
		qSourceSvmName := qrSourceSvmName
		if qSourceSvmName != "" {

			if err := r.SetQueryParam("source.svm.name", qSourceSvmName); err != nil {
				return err
			}
		}
	}

	if o.SourceSvmUUID != nil {

		// query param source.svm.uuid
		var qrSourceSvmUUID string

		if o.SourceSvmUUID != nil {
			qrSourceSvmUUID = *o.SourceSvmUUID
		}
		qSourceSvmUUID := qrSourceSvmUUID
		if qSourceSvmUUID != "" {

			if err := r.SetQueryParam("source.svm.uuid", qSourceSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.State != nil {

		// query param state
		var qrState string

		if o.State != nil {
			qrState = *o.State
		}
		qState := qrState
		if qState != "" {

			if err := r.SetQueryParam("state", qState); err != nil {
				return err
			}
		}
	}

	if o.Throttle != nil {

		// query param throttle
		var qrThrottle int64

		if o.Throttle != nil {
			qrThrottle = *o.Throttle
		}
		qThrottle := swag.FormatInt64(qrThrottle)
		if qThrottle != "" {

			if err := r.SetQueryParam("throttle", qThrottle); err != nil {
				return err
			}
		}
	}

	if o.TimeMetricsCutoverCompleteTime != nil {

		// query param time_metrics.cutover_complete_time
		var qrTimeMetricsCutoverCompleteTime string

		if o.TimeMetricsCutoverCompleteTime != nil {
			qrTimeMetricsCutoverCompleteTime = *o.TimeMetricsCutoverCompleteTime
		}
		qTimeMetricsCutoverCompleteTime := qrTimeMetricsCutoverCompleteTime
		if qTimeMetricsCutoverCompleteTime != "" {

			if err := r.SetQueryParam("time_metrics.cutover_complete_time", qTimeMetricsCutoverCompleteTime); err != nil {
				return err
			}
		}
	}

	if o.TimeMetricsCutoverStartTime != nil {

		// query param time_metrics.cutover_start_time
		var qrTimeMetricsCutoverStartTime string

		if o.TimeMetricsCutoverStartTime != nil {
			qrTimeMetricsCutoverStartTime = *o.TimeMetricsCutoverStartTime
		}
		qTimeMetricsCutoverStartTime := qrTimeMetricsCutoverStartTime
		if qTimeMetricsCutoverStartTime != "" {

			if err := r.SetQueryParam("time_metrics.cutover_start_time", qTimeMetricsCutoverStartTime); err != nil {
				return err
			}
		}
	}

	if o.TimeMetricsCutoverTriggerTime != nil {

		// query param time_metrics.cutover_trigger_time
		var qrTimeMetricsCutoverTriggerTime string

		if o.TimeMetricsCutoverTriggerTime != nil {
			qrTimeMetricsCutoverTriggerTime = *o.TimeMetricsCutoverTriggerTime
		}
		qTimeMetricsCutoverTriggerTime := qrTimeMetricsCutoverTriggerTime
		if qTimeMetricsCutoverTriggerTime != "" {

			if err := r.SetQueryParam("time_metrics.cutover_trigger_time", qTimeMetricsCutoverTriggerTime); err != nil {
				return err
			}
		}
	}

	if o.TimeMetricsEndTime != nil {

		// query param time_metrics.end_time
		var qrTimeMetricsEndTime string

		if o.TimeMetricsEndTime != nil {
			qrTimeMetricsEndTime = *o.TimeMetricsEndTime
		}
		qTimeMetricsEndTime := qrTimeMetricsEndTime
		if qTimeMetricsEndTime != "" {

			if err := r.SetQueryParam("time_metrics.end_time", qTimeMetricsEndTime); err != nil {
				return err
			}
		}
	}

	if o.TimeMetricsLastPauseTime != nil {

		// query param time_metrics.last_pause_time
		var qrTimeMetricsLastPauseTime string

		if o.TimeMetricsLastPauseTime != nil {
			qrTimeMetricsLastPauseTime = *o.TimeMetricsLastPauseTime
		}
		qTimeMetricsLastPauseTime := qrTimeMetricsLastPauseTime
		if qTimeMetricsLastPauseTime != "" {

			if err := r.SetQueryParam("time_metrics.last_pause_time", qTimeMetricsLastPauseTime); err != nil {
				return err
			}
		}
	}

	if o.TimeMetricsLastPostPonrRetryTime != nil {

		// query param time_metrics.last_post_ponr_retry_time
		var qrTimeMetricsLastPostPonrRetryTime string

		if o.TimeMetricsLastPostPonrRetryTime != nil {
			qrTimeMetricsLastPostPonrRetryTime = *o.TimeMetricsLastPostPonrRetryTime
		}
		qTimeMetricsLastPostPonrRetryTime := qrTimeMetricsLastPostPonrRetryTime
		if qTimeMetricsLastPostPonrRetryTime != "" {

			if err := r.SetQueryParam("time_metrics.last_post_ponr_retry_time", qTimeMetricsLastPostPonrRetryTime); err != nil {
				return err
			}
		}
	}

	if o.TimeMetricsLastResumeTime != nil {

		// query param time_metrics.last_resume_time
		var qrTimeMetricsLastResumeTime string

		if o.TimeMetricsLastResumeTime != nil {
			qrTimeMetricsLastResumeTime = *o.TimeMetricsLastResumeTime
		}
		qTimeMetricsLastResumeTime := qrTimeMetricsLastResumeTime
		if qTimeMetricsLastResumeTime != "" {

			if err := r.SetQueryParam("time_metrics.last_resume_time", qTimeMetricsLastResumeTime); err != nil {
				return err
			}
		}
	}

	if o.TimeMetricsStartTime != nil {

		// query param time_metrics.start_time
		var qrTimeMetricsStartTime string

		if o.TimeMetricsStartTime != nil {
			qrTimeMetricsStartTime = *o.TimeMetricsStartTime
		}
		qTimeMetricsStartTime := qrTimeMetricsStartTime
		if qTimeMetricsStartTime != "" {

			if err := r.SetQueryParam("time_metrics.start_time", qTimeMetricsStartTime); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamSvmMigrationCollectionGet binds the parameter fields
func (o *SvmMigrationCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamSvmMigrationCollectionGet binds the parameter order_by
func (o *SvmMigrationCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
