// Code generated by go-swagger; DO NOT EDIT.

package svm

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SvmMigrationDeleteCollectionReader is a Reader for the SvmMigrationDeleteCollection structure.
type SvmMigrationDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SvmMigrationDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSvmMigrationDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewSvmMigrationDeleteCollectionAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSvmMigrationDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSvmMigrationDeleteCollectionOK creates a SvmMigrationDeleteCollectionOK with default headers values
func NewSvmMigrationDeleteCollectionOK() *SvmMigrationDeleteCollectionOK {
	return &SvmMigrationDeleteCollectionOK{}
}

/*
SvmMigrationDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type SvmMigrationDeleteCollectionOK struct {
	Payload *models.SvmMigrationJobLinkResponse
}

// IsSuccess returns true when this svm migration delete collection o k response has a 2xx status code
func (o *SvmMigrationDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this svm migration delete collection o k response has a 3xx status code
func (o *SvmMigrationDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this svm migration delete collection o k response has a 4xx status code
func (o *SvmMigrationDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this svm migration delete collection o k response has a 5xx status code
func (o *SvmMigrationDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this svm migration delete collection o k response a status code equal to that given
func (o *SvmMigrationDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the svm migration delete collection o k response
func (o *SvmMigrationDeleteCollectionOK) Code() int {
	return 200
}

func (o *SvmMigrationDeleteCollectionOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /svm/migrations][%d] svmMigrationDeleteCollectionOK %s", 200, payload)
}

func (o *SvmMigrationDeleteCollectionOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /svm/migrations][%d] svmMigrationDeleteCollectionOK %s", 200, payload)
}

func (o *SvmMigrationDeleteCollectionOK) GetPayload() *models.SvmMigrationJobLinkResponse {
	return o.Payload
}

func (o *SvmMigrationDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SvmMigrationJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSvmMigrationDeleteCollectionAccepted creates a SvmMigrationDeleteCollectionAccepted with default headers values
func NewSvmMigrationDeleteCollectionAccepted() *SvmMigrationDeleteCollectionAccepted {
	return &SvmMigrationDeleteCollectionAccepted{}
}

/*
SvmMigrationDeleteCollectionAccepted describes a response with status code 202, with default header values.

Accepted
*/
type SvmMigrationDeleteCollectionAccepted struct {
	Payload *models.SvmMigrationJobLinkResponse
}

// IsSuccess returns true when this svm migration delete collection accepted response has a 2xx status code
func (o *SvmMigrationDeleteCollectionAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this svm migration delete collection accepted response has a 3xx status code
func (o *SvmMigrationDeleteCollectionAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this svm migration delete collection accepted response has a 4xx status code
func (o *SvmMigrationDeleteCollectionAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this svm migration delete collection accepted response has a 5xx status code
func (o *SvmMigrationDeleteCollectionAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this svm migration delete collection accepted response a status code equal to that given
func (o *SvmMigrationDeleteCollectionAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the svm migration delete collection accepted response
func (o *SvmMigrationDeleteCollectionAccepted) Code() int {
	return 202
}

func (o *SvmMigrationDeleteCollectionAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /svm/migrations][%d] svmMigrationDeleteCollectionAccepted %s", 202, payload)
}

func (o *SvmMigrationDeleteCollectionAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /svm/migrations][%d] svmMigrationDeleteCollectionAccepted %s", 202, payload)
}

func (o *SvmMigrationDeleteCollectionAccepted) GetPayload() *models.SvmMigrationJobLinkResponse {
	return o.Payload
}

func (o *SvmMigrationDeleteCollectionAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SvmMigrationJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSvmMigrationDeleteCollectionDefault creates a SvmMigrationDeleteCollectionDefault with default headers values
func NewSvmMigrationDeleteCollectionDefault(code int) *SvmMigrationDeleteCollectionDefault {
	return &SvmMigrationDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
	SvmMigrationDeleteCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 13172783 | Migrate RDB lookup failed |
| 13173738 | REST API DELETE method \\"/api/svm/migrations\\" is only supported on the destination cluster. Issue the REST API DELETE request to the destination cluster. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type SvmMigrationDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this svm migration delete collection default response has a 2xx status code
func (o *SvmMigrationDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this svm migration delete collection default response has a 3xx status code
func (o *SvmMigrationDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this svm migration delete collection default response has a 4xx status code
func (o *SvmMigrationDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this svm migration delete collection default response has a 5xx status code
func (o *SvmMigrationDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this svm migration delete collection default response a status code equal to that given
func (o *SvmMigrationDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the svm migration delete collection default response
func (o *SvmMigrationDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *SvmMigrationDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /svm/migrations][%d] svm_migration_delete_collection default %s", o._statusCode, payload)
}

func (o *SvmMigrationDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /svm/migrations][%d] svm_migration_delete_collection default %s", o._statusCode, payload)
}

func (o *SvmMigrationDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SvmMigrationDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
SvmMigrationDeleteCollectionBody svm migration delete collection body
swagger:model SvmMigrationDeleteCollectionBody
*/
type SvmMigrationDeleteCollectionBody struct {

	// svm migration response inline records
	SvmMigrationResponseInlineRecords []*models.SvmMigration `json:"records,omitempty"`
}

// Validate validates this svm migration delete collection body
func (o *SvmMigrationDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSvmMigrationResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmMigrationDeleteCollectionBody) validateSvmMigrationResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.SvmMigrationResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.SvmMigrationResponseInlineRecords); i++ {
		if swag.IsZero(o.SvmMigrationResponseInlineRecords[i]) { // not required
			continue
		}

		if o.SvmMigrationResponseInlineRecords[i] != nil {
			if err := o.SvmMigrationResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this svm migration delete collection body based on the context it is used
func (o *SvmMigrationDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSvmMigrationResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmMigrationDeleteCollectionBody) contextValidateSvmMigrationResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.SvmMigrationResponseInlineRecords); i++ {

		if o.SvmMigrationResponseInlineRecords[i] != nil {
			if err := o.SvmMigrationResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *SvmMigrationDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SvmMigrationDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res SvmMigrationDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
