// Code generated by go-swagger; DO NOT EDIT.

package svm

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewSvmMigrationModifyCollectionParams creates a new SvmMigrationModifyCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSvmMigrationModifyCollectionParams() *SvmMigrationModifyCollectionParams {
	return &SvmMigrationModifyCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSvmMigrationModifyCollectionParamsWithTimeout creates a new SvmMigrationModifyCollectionParams object
// with the ability to set a timeout on a request.
func NewSvmMigrationModifyCollectionParamsWithTimeout(timeout time.Duration) *SvmMigrationModifyCollectionParams {
	return &SvmMigrationModifyCollectionParams{
		timeout: timeout,
	}
}

// NewSvmMigrationModifyCollectionParamsWithContext creates a new SvmMigrationModifyCollectionParams object
// with the ability to set a context for a request.
func NewSvmMigrationModifyCollectionParamsWithContext(ctx context.Context) *SvmMigrationModifyCollectionParams {
	return &SvmMigrationModifyCollectionParams{
		Context: ctx,
	}
}

// NewSvmMigrationModifyCollectionParamsWithHTTPClient creates a new SvmMigrationModifyCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewSvmMigrationModifyCollectionParamsWithHTTPClient(client *http.Client) *SvmMigrationModifyCollectionParams {
	return &SvmMigrationModifyCollectionParams{
		HTTPClient: client,
	}
}

/*
SvmMigrationModifyCollectionParams contains all the parameters to send to the API endpoint

	for the svm migration modify collection operation.

	Typically these are written to a http.Request.
*/
type SvmMigrationModifyCollectionParams struct {

	/* Action.

	     The pause action pauses the SVM migration. This action stops data transfer and configuration replication. This operation must be performed on the destination cluster.
	The resume action resumes an SVM migration from a paused or failed state. If the SVM migration is in a cleanup_failed state, volume placement is ignored. This operation must be performed on the destination cluster.
	The cutover action triggers the cutover of an SVM from the source cluster to the destination cluster.
	The source_clean up action performs a clean up of the SVM on the source cluster.

	*/
	Action *string

	/* AutoCutover.

	   Filter by auto_cutover
	*/
	AutoCutover *bool

	/* AutoSourceCleanup.

	   Filter by auto_source_cleanup
	*/
	AutoSourceCleanup *bool

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* CurrentOperation.

	   Filter by current_operation
	*/
	CurrentOperation *string

	/* DestinationIpspaceName.

	   Filter by destination.ipspace.name
	*/
	DestinationIpspaceName *string

	/* DestinationIpspaceUUID.

	   Filter by destination.ipspace.uuid
	*/
	DestinationIpspaceUUID *string

	/* Info.

	   Info specification
	*/
	Info SvmMigrationModifyCollectionBody

	/* LastFailedState.

	   Filter by last_failed_state
	*/
	LastFailedState *string

	/* LastOperation.

	   Filter by last_operation
	*/
	LastOperation *string

	/* MessagesCode.

	   Filter by messages.code
	*/
	MessagesCode *string

	/* MessagesMessage.

	   Filter by messages.message
	*/
	MessagesMessage *string

	/* PointOfNoReturn.

	   Filter by point_of_no_return
	*/
	PointOfNoReturn *bool

	/* PostPonrRetryCount.

	   Filter by post_ponr_retry_count
	*/
	PostPonrRetryCount *int64

	/* RestartCount.

	   Filter by restart_count
	*/
	RestartCount *int64

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* SourceClusterName.

	   Filter by source.cluster.name
	*/
	SourceClusterName *string

	/* SourceClusterUUID.

	   Filter by source.cluster.uuid
	*/
	SourceClusterUUID *string

	/* SourceSvmName.

	   Filter by source.svm.name
	*/
	SourceSvmName *string

	/* SourceSvmUUID.

	   Filter by source.svm.uuid
	*/
	SourceSvmUUID *string

	/* State.

	   Filter by state
	*/
	State *string

	/* Throttle.

	   Filter by throttle
	*/
	Throttle *int64

	/* TimeMetricsCutoverCompleteTime.

	   Filter by time_metrics.cutover_complete_time
	*/
	TimeMetricsCutoverCompleteTime *string

	/* TimeMetricsCutoverStartTime.

	   Filter by time_metrics.cutover_start_time
	*/
	TimeMetricsCutoverStartTime *string

	/* TimeMetricsCutoverTriggerTime.

	   Filter by time_metrics.cutover_trigger_time
	*/
	TimeMetricsCutoverTriggerTime *string

	/* TimeMetricsEndTime.

	   Filter by time_metrics.end_time
	*/
	TimeMetricsEndTime *string

	/* TimeMetricsLastPauseTime.

	   Filter by time_metrics.last_pause_time
	*/
	TimeMetricsLastPauseTime *string

	/* TimeMetricsLastPostPonrRetryTime.

	   Filter by time_metrics.last_post_ponr_retry_time
	*/
	TimeMetricsLastPostPonrRetryTime *string

	/* TimeMetricsLastResumeTime.

	   Filter by time_metrics.last_resume_time
	*/
	TimeMetricsLastResumeTime *string

	/* TimeMetricsStartTime.

	   Filter by time_metrics.start_time
	*/
	TimeMetricsStartTime *string

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the svm migration modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SvmMigrationModifyCollectionParams) WithDefaults() *SvmMigrationModifyCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the svm migration modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SvmMigrationModifyCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := SvmMigrationModifyCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the svm migration modify collection params
func (o *SvmMigrationModifyCollectionParams) WithTimeout(timeout time.Duration) *SvmMigrationModifyCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the svm migration modify collection params
func (o *SvmMigrationModifyCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the svm migration modify collection params
func (o *SvmMigrationModifyCollectionParams) WithContext(ctx context.Context) *SvmMigrationModifyCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the svm migration modify collection params
func (o *SvmMigrationModifyCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the svm migration modify collection params
func (o *SvmMigrationModifyCollectionParams) WithHTTPClient(client *http.Client) *SvmMigrationModifyCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the svm migration modify collection params
func (o *SvmMigrationModifyCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAction adds the action to the svm migration modify collection params
func (o *SvmMigrationModifyCollectionParams) WithAction(action *string) *SvmMigrationModifyCollectionParams {
	o.SetAction(action)
	return o
}

// SetAction adds the action to the svm migration modify collection params
func (o *SvmMigrationModifyCollectionParams) SetAction(action *string) {
	o.Action = action
}

// WithAutoCutover adds the autoCutover to the svm migration modify collection params
func (o *SvmMigrationModifyCollectionParams) WithAutoCutover(autoCutover *bool) *SvmMigrationModifyCollectionParams {
	o.SetAutoCutover(autoCutover)
	return o
}

// SetAutoCutover adds the autoCutover to the svm migration modify collection params
func (o *SvmMigrationModifyCollectionParams) SetAutoCutover(autoCutover *bool) {
	o.AutoCutover = autoCutover
}

// WithAutoSourceCleanup adds the autoSourceCleanup to the svm migration modify collection params
func (o *SvmMigrationModifyCollectionParams) WithAutoSourceCleanup(autoSourceCleanup *bool) *SvmMigrationModifyCollectionParams {
	o.SetAutoSourceCleanup(autoSourceCleanup)
	return o
}

// SetAutoSourceCleanup adds the autoSourceCleanup to the svm migration modify collection params
func (o *SvmMigrationModifyCollectionParams) SetAutoSourceCleanup(autoSourceCleanup *bool) {
	o.AutoSourceCleanup = autoSourceCleanup
}

// WithContinueOnFailure adds the continueOnFailure to the svm migration modify collection params
func (o *SvmMigrationModifyCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *SvmMigrationModifyCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the svm migration modify collection params
func (o *SvmMigrationModifyCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithCurrentOperation adds the currentOperation to the svm migration modify collection params
func (o *SvmMigrationModifyCollectionParams) WithCurrentOperation(currentOperation *string) *SvmMigrationModifyCollectionParams {
	o.SetCurrentOperation(currentOperation)
	return o
}

// SetCurrentOperation adds the currentOperation to the svm migration modify collection params
func (o *SvmMigrationModifyCollectionParams) SetCurrentOperation(currentOperation *string) {
	o.CurrentOperation = currentOperation
}

// WithDestinationIpspaceName adds the destinationIpspaceName to the svm migration modify collection params
func (o *SvmMigrationModifyCollectionParams) WithDestinationIpspaceName(destinationIpspaceName *string) *SvmMigrationModifyCollectionParams {
	o.SetDestinationIpspaceName(destinationIpspaceName)
	return o
}

// SetDestinationIpspaceName adds the destinationIpspaceName to the svm migration modify collection params
func (o *SvmMigrationModifyCollectionParams) SetDestinationIpspaceName(destinationIpspaceName *string) {
	o.DestinationIpspaceName = destinationIpspaceName
}

// WithDestinationIpspaceUUID adds the destinationIpspaceUUID to the svm migration modify collection params
func (o *SvmMigrationModifyCollectionParams) WithDestinationIpspaceUUID(destinationIpspaceUUID *string) *SvmMigrationModifyCollectionParams {
	o.SetDestinationIpspaceUUID(destinationIpspaceUUID)
	return o
}

// SetDestinationIpspaceUUID adds the destinationIpspaceUuid to the svm migration modify collection params
func (o *SvmMigrationModifyCollectionParams) SetDestinationIpspaceUUID(destinationIpspaceUUID *string) {
	o.DestinationIpspaceUUID = destinationIpspaceUUID
}

// WithInfo adds the info to the svm migration modify collection params
func (o *SvmMigrationModifyCollectionParams) WithInfo(info SvmMigrationModifyCollectionBody) *SvmMigrationModifyCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the svm migration modify collection params
func (o *SvmMigrationModifyCollectionParams) SetInfo(info SvmMigrationModifyCollectionBody) {
	o.Info = info
}

// WithLastFailedState adds the lastFailedState to the svm migration modify collection params
func (o *SvmMigrationModifyCollectionParams) WithLastFailedState(lastFailedState *string) *SvmMigrationModifyCollectionParams {
	o.SetLastFailedState(lastFailedState)
	return o
}

// SetLastFailedState adds the lastFailedState to the svm migration modify collection params
func (o *SvmMigrationModifyCollectionParams) SetLastFailedState(lastFailedState *string) {
	o.LastFailedState = lastFailedState
}

// WithLastOperation adds the lastOperation to the svm migration modify collection params
func (o *SvmMigrationModifyCollectionParams) WithLastOperation(lastOperation *string) *SvmMigrationModifyCollectionParams {
	o.SetLastOperation(lastOperation)
	return o
}

// SetLastOperation adds the lastOperation to the svm migration modify collection params
func (o *SvmMigrationModifyCollectionParams) SetLastOperation(lastOperation *string) {
	o.LastOperation = lastOperation
}

// WithMessagesCode adds the messagesCode to the svm migration modify collection params
func (o *SvmMigrationModifyCollectionParams) WithMessagesCode(messagesCode *string) *SvmMigrationModifyCollectionParams {
	o.SetMessagesCode(messagesCode)
	return o
}

// SetMessagesCode adds the messagesCode to the svm migration modify collection params
func (o *SvmMigrationModifyCollectionParams) SetMessagesCode(messagesCode *string) {
	o.MessagesCode = messagesCode
}

// WithMessagesMessage adds the messagesMessage to the svm migration modify collection params
func (o *SvmMigrationModifyCollectionParams) WithMessagesMessage(messagesMessage *string) *SvmMigrationModifyCollectionParams {
	o.SetMessagesMessage(messagesMessage)
	return o
}

// SetMessagesMessage adds the messagesMessage to the svm migration modify collection params
func (o *SvmMigrationModifyCollectionParams) SetMessagesMessage(messagesMessage *string) {
	o.MessagesMessage = messagesMessage
}

// WithPointOfNoReturn adds the pointOfNoReturn to the svm migration modify collection params
func (o *SvmMigrationModifyCollectionParams) WithPointOfNoReturn(pointOfNoReturn *bool) *SvmMigrationModifyCollectionParams {
	o.SetPointOfNoReturn(pointOfNoReturn)
	return o
}

// SetPointOfNoReturn adds the pointOfNoReturn to the svm migration modify collection params
func (o *SvmMigrationModifyCollectionParams) SetPointOfNoReturn(pointOfNoReturn *bool) {
	o.PointOfNoReturn = pointOfNoReturn
}

// WithPostPonrRetryCount adds the postPonrRetryCount to the svm migration modify collection params
func (o *SvmMigrationModifyCollectionParams) WithPostPonrRetryCount(postPonrRetryCount *int64) *SvmMigrationModifyCollectionParams {
	o.SetPostPonrRetryCount(postPonrRetryCount)
	return o
}

// SetPostPonrRetryCount adds the postPonrRetryCount to the svm migration modify collection params
func (o *SvmMigrationModifyCollectionParams) SetPostPonrRetryCount(postPonrRetryCount *int64) {
	o.PostPonrRetryCount = postPonrRetryCount
}

// WithRestartCount adds the restartCount to the svm migration modify collection params
func (o *SvmMigrationModifyCollectionParams) WithRestartCount(restartCount *int64) *SvmMigrationModifyCollectionParams {
	o.SetRestartCount(restartCount)
	return o
}

// SetRestartCount adds the restartCount to the svm migration modify collection params
func (o *SvmMigrationModifyCollectionParams) SetRestartCount(restartCount *int64) {
	o.RestartCount = restartCount
}

// WithReturnRecords adds the returnRecords to the svm migration modify collection params
func (o *SvmMigrationModifyCollectionParams) WithReturnRecords(returnRecords *bool) *SvmMigrationModifyCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the svm migration modify collection params
func (o *SvmMigrationModifyCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the svm migration modify collection params
func (o *SvmMigrationModifyCollectionParams) WithReturnTimeout(returnTimeout *int64) *SvmMigrationModifyCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the svm migration modify collection params
func (o *SvmMigrationModifyCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSerialRecords adds the serialRecords to the svm migration modify collection params
func (o *SvmMigrationModifyCollectionParams) WithSerialRecords(serialRecords *bool) *SvmMigrationModifyCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the svm migration modify collection params
func (o *SvmMigrationModifyCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithSourceClusterName adds the sourceClusterName to the svm migration modify collection params
func (o *SvmMigrationModifyCollectionParams) WithSourceClusterName(sourceClusterName *string) *SvmMigrationModifyCollectionParams {
	o.SetSourceClusterName(sourceClusterName)
	return o
}

// SetSourceClusterName adds the sourceClusterName to the svm migration modify collection params
func (o *SvmMigrationModifyCollectionParams) SetSourceClusterName(sourceClusterName *string) {
	o.SourceClusterName = sourceClusterName
}

// WithSourceClusterUUID adds the sourceClusterUUID to the svm migration modify collection params
func (o *SvmMigrationModifyCollectionParams) WithSourceClusterUUID(sourceClusterUUID *string) *SvmMigrationModifyCollectionParams {
	o.SetSourceClusterUUID(sourceClusterUUID)
	return o
}

// SetSourceClusterUUID adds the sourceClusterUuid to the svm migration modify collection params
func (o *SvmMigrationModifyCollectionParams) SetSourceClusterUUID(sourceClusterUUID *string) {
	o.SourceClusterUUID = sourceClusterUUID
}

// WithSourceSvmName adds the sourceSvmName to the svm migration modify collection params
func (o *SvmMigrationModifyCollectionParams) WithSourceSvmName(sourceSvmName *string) *SvmMigrationModifyCollectionParams {
	o.SetSourceSvmName(sourceSvmName)
	return o
}

// SetSourceSvmName adds the sourceSvmName to the svm migration modify collection params
func (o *SvmMigrationModifyCollectionParams) SetSourceSvmName(sourceSvmName *string) {
	o.SourceSvmName = sourceSvmName
}

// WithSourceSvmUUID adds the sourceSvmUUID to the svm migration modify collection params
func (o *SvmMigrationModifyCollectionParams) WithSourceSvmUUID(sourceSvmUUID *string) *SvmMigrationModifyCollectionParams {
	o.SetSourceSvmUUID(sourceSvmUUID)
	return o
}

// SetSourceSvmUUID adds the sourceSvmUuid to the svm migration modify collection params
func (o *SvmMigrationModifyCollectionParams) SetSourceSvmUUID(sourceSvmUUID *string) {
	o.SourceSvmUUID = sourceSvmUUID
}

// WithState adds the state to the svm migration modify collection params
func (o *SvmMigrationModifyCollectionParams) WithState(state *string) *SvmMigrationModifyCollectionParams {
	o.SetState(state)
	return o
}

// SetState adds the state to the svm migration modify collection params
func (o *SvmMigrationModifyCollectionParams) SetState(state *string) {
	o.State = state
}

// WithThrottle adds the throttle to the svm migration modify collection params
func (o *SvmMigrationModifyCollectionParams) WithThrottle(throttle *int64) *SvmMigrationModifyCollectionParams {
	o.SetThrottle(throttle)
	return o
}

// SetThrottle adds the throttle to the svm migration modify collection params
func (o *SvmMigrationModifyCollectionParams) SetThrottle(throttle *int64) {
	o.Throttle = throttle
}

// WithTimeMetricsCutoverCompleteTime adds the timeMetricsCutoverCompleteTime to the svm migration modify collection params
func (o *SvmMigrationModifyCollectionParams) WithTimeMetricsCutoverCompleteTime(timeMetricsCutoverCompleteTime *string) *SvmMigrationModifyCollectionParams {
	o.SetTimeMetricsCutoverCompleteTime(timeMetricsCutoverCompleteTime)
	return o
}

// SetTimeMetricsCutoverCompleteTime adds the timeMetricsCutoverCompleteTime to the svm migration modify collection params
func (o *SvmMigrationModifyCollectionParams) SetTimeMetricsCutoverCompleteTime(timeMetricsCutoverCompleteTime *string) {
	o.TimeMetricsCutoverCompleteTime = timeMetricsCutoverCompleteTime
}

// WithTimeMetricsCutoverStartTime adds the timeMetricsCutoverStartTime to the svm migration modify collection params
func (o *SvmMigrationModifyCollectionParams) WithTimeMetricsCutoverStartTime(timeMetricsCutoverStartTime *string) *SvmMigrationModifyCollectionParams {
	o.SetTimeMetricsCutoverStartTime(timeMetricsCutoverStartTime)
	return o
}

// SetTimeMetricsCutoverStartTime adds the timeMetricsCutoverStartTime to the svm migration modify collection params
func (o *SvmMigrationModifyCollectionParams) SetTimeMetricsCutoverStartTime(timeMetricsCutoverStartTime *string) {
	o.TimeMetricsCutoverStartTime = timeMetricsCutoverStartTime
}

// WithTimeMetricsCutoverTriggerTime adds the timeMetricsCutoverTriggerTime to the svm migration modify collection params
func (o *SvmMigrationModifyCollectionParams) WithTimeMetricsCutoverTriggerTime(timeMetricsCutoverTriggerTime *string) *SvmMigrationModifyCollectionParams {
	o.SetTimeMetricsCutoverTriggerTime(timeMetricsCutoverTriggerTime)
	return o
}

// SetTimeMetricsCutoverTriggerTime adds the timeMetricsCutoverTriggerTime to the svm migration modify collection params
func (o *SvmMigrationModifyCollectionParams) SetTimeMetricsCutoverTriggerTime(timeMetricsCutoverTriggerTime *string) {
	o.TimeMetricsCutoverTriggerTime = timeMetricsCutoverTriggerTime
}

// WithTimeMetricsEndTime adds the timeMetricsEndTime to the svm migration modify collection params
func (o *SvmMigrationModifyCollectionParams) WithTimeMetricsEndTime(timeMetricsEndTime *string) *SvmMigrationModifyCollectionParams {
	o.SetTimeMetricsEndTime(timeMetricsEndTime)
	return o
}

// SetTimeMetricsEndTime adds the timeMetricsEndTime to the svm migration modify collection params
func (o *SvmMigrationModifyCollectionParams) SetTimeMetricsEndTime(timeMetricsEndTime *string) {
	o.TimeMetricsEndTime = timeMetricsEndTime
}

// WithTimeMetricsLastPauseTime adds the timeMetricsLastPauseTime to the svm migration modify collection params
func (o *SvmMigrationModifyCollectionParams) WithTimeMetricsLastPauseTime(timeMetricsLastPauseTime *string) *SvmMigrationModifyCollectionParams {
	o.SetTimeMetricsLastPauseTime(timeMetricsLastPauseTime)
	return o
}

// SetTimeMetricsLastPauseTime adds the timeMetricsLastPauseTime to the svm migration modify collection params
func (o *SvmMigrationModifyCollectionParams) SetTimeMetricsLastPauseTime(timeMetricsLastPauseTime *string) {
	o.TimeMetricsLastPauseTime = timeMetricsLastPauseTime
}

// WithTimeMetricsLastPostPonrRetryTime adds the timeMetricsLastPostPonrRetryTime to the svm migration modify collection params
func (o *SvmMigrationModifyCollectionParams) WithTimeMetricsLastPostPonrRetryTime(timeMetricsLastPostPonrRetryTime *string) *SvmMigrationModifyCollectionParams {
	o.SetTimeMetricsLastPostPonrRetryTime(timeMetricsLastPostPonrRetryTime)
	return o
}

// SetTimeMetricsLastPostPonrRetryTime adds the timeMetricsLastPostPonrRetryTime to the svm migration modify collection params
func (o *SvmMigrationModifyCollectionParams) SetTimeMetricsLastPostPonrRetryTime(timeMetricsLastPostPonrRetryTime *string) {
	o.TimeMetricsLastPostPonrRetryTime = timeMetricsLastPostPonrRetryTime
}

// WithTimeMetricsLastResumeTime adds the timeMetricsLastResumeTime to the svm migration modify collection params
func (o *SvmMigrationModifyCollectionParams) WithTimeMetricsLastResumeTime(timeMetricsLastResumeTime *string) *SvmMigrationModifyCollectionParams {
	o.SetTimeMetricsLastResumeTime(timeMetricsLastResumeTime)
	return o
}

// SetTimeMetricsLastResumeTime adds the timeMetricsLastResumeTime to the svm migration modify collection params
func (o *SvmMigrationModifyCollectionParams) SetTimeMetricsLastResumeTime(timeMetricsLastResumeTime *string) {
	o.TimeMetricsLastResumeTime = timeMetricsLastResumeTime
}

// WithTimeMetricsStartTime adds the timeMetricsStartTime to the svm migration modify collection params
func (o *SvmMigrationModifyCollectionParams) WithTimeMetricsStartTime(timeMetricsStartTime *string) *SvmMigrationModifyCollectionParams {
	o.SetTimeMetricsStartTime(timeMetricsStartTime)
	return o
}

// SetTimeMetricsStartTime adds the timeMetricsStartTime to the svm migration modify collection params
func (o *SvmMigrationModifyCollectionParams) SetTimeMetricsStartTime(timeMetricsStartTime *string) {
	o.TimeMetricsStartTime = timeMetricsStartTime
}

// WithUUID adds the uuid to the svm migration modify collection params
func (o *SvmMigrationModifyCollectionParams) WithUUID(uuid *string) *SvmMigrationModifyCollectionParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the svm migration modify collection params
func (o *SvmMigrationModifyCollectionParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *SvmMigrationModifyCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Action != nil {

		// query param action
		var qrAction string

		if o.Action != nil {
			qrAction = *o.Action
		}
		qAction := qrAction
		if qAction != "" {

			if err := r.SetQueryParam("action", qAction); err != nil {
				return err
			}
		}
	}

	if o.AutoCutover != nil {

		// query param auto_cutover
		var qrAutoCutover bool

		if o.AutoCutover != nil {
			qrAutoCutover = *o.AutoCutover
		}
		qAutoCutover := swag.FormatBool(qrAutoCutover)
		if qAutoCutover != "" {

			if err := r.SetQueryParam("auto_cutover", qAutoCutover); err != nil {
				return err
			}
		}
	}

	if o.AutoSourceCleanup != nil {

		// query param auto_source_cleanup
		var qrAutoSourceCleanup bool

		if o.AutoSourceCleanup != nil {
			qrAutoSourceCleanup = *o.AutoSourceCleanup
		}
		qAutoSourceCleanup := swag.FormatBool(qrAutoSourceCleanup)
		if qAutoSourceCleanup != "" {

			if err := r.SetQueryParam("auto_source_cleanup", qAutoSourceCleanup); err != nil {
				return err
			}
		}
	}

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}

	if o.CurrentOperation != nil {

		// query param current_operation
		var qrCurrentOperation string

		if o.CurrentOperation != nil {
			qrCurrentOperation = *o.CurrentOperation
		}
		qCurrentOperation := qrCurrentOperation
		if qCurrentOperation != "" {

			if err := r.SetQueryParam("current_operation", qCurrentOperation); err != nil {
				return err
			}
		}
	}

	if o.DestinationIpspaceName != nil {

		// query param destination.ipspace.name
		var qrDestinationIpspaceName string

		if o.DestinationIpspaceName != nil {
			qrDestinationIpspaceName = *o.DestinationIpspaceName
		}
		qDestinationIpspaceName := qrDestinationIpspaceName
		if qDestinationIpspaceName != "" {

			if err := r.SetQueryParam("destination.ipspace.name", qDestinationIpspaceName); err != nil {
				return err
			}
		}
	}

	if o.DestinationIpspaceUUID != nil {

		// query param destination.ipspace.uuid
		var qrDestinationIpspaceUUID string

		if o.DestinationIpspaceUUID != nil {
			qrDestinationIpspaceUUID = *o.DestinationIpspaceUUID
		}
		qDestinationIpspaceUUID := qrDestinationIpspaceUUID
		if qDestinationIpspaceUUID != "" {

			if err := r.SetQueryParam("destination.ipspace.uuid", qDestinationIpspaceUUID); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.LastFailedState != nil {

		// query param last_failed_state
		var qrLastFailedState string

		if o.LastFailedState != nil {
			qrLastFailedState = *o.LastFailedState
		}
		qLastFailedState := qrLastFailedState
		if qLastFailedState != "" {

			if err := r.SetQueryParam("last_failed_state", qLastFailedState); err != nil {
				return err
			}
		}
	}

	if o.LastOperation != nil {

		// query param last_operation
		var qrLastOperation string

		if o.LastOperation != nil {
			qrLastOperation = *o.LastOperation
		}
		qLastOperation := qrLastOperation
		if qLastOperation != "" {

			if err := r.SetQueryParam("last_operation", qLastOperation); err != nil {
				return err
			}
		}
	}

	if o.MessagesCode != nil {

		// query param messages.code
		var qrMessagesCode string

		if o.MessagesCode != nil {
			qrMessagesCode = *o.MessagesCode
		}
		qMessagesCode := qrMessagesCode
		if qMessagesCode != "" {

			if err := r.SetQueryParam("messages.code", qMessagesCode); err != nil {
				return err
			}
		}
	}

	if o.MessagesMessage != nil {

		// query param messages.message
		var qrMessagesMessage string

		if o.MessagesMessage != nil {
			qrMessagesMessage = *o.MessagesMessage
		}
		qMessagesMessage := qrMessagesMessage
		if qMessagesMessage != "" {

			if err := r.SetQueryParam("messages.message", qMessagesMessage); err != nil {
				return err
			}
		}
	}

	if o.PointOfNoReturn != nil {

		// query param point_of_no_return
		var qrPointOfNoReturn bool

		if o.PointOfNoReturn != nil {
			qrPointOfNoReturn = *o.PointOfNoReturn
		}
		qPointOfNoReturn := swag.FormatBool(qrPointOfNoReturn)
		if qPointOfNoReturn != "" {

			if err := r.SetQueryParam("point_of_no_return", qPointOfNoReturn); err != nil {
				return err
			}
		}
	}

	if o.PostPonrRetryCount != nil {

		// query param post_ponr_retry_count
		var qrPostPonrRetryCount int64

		if o.PostPonrRetryCount != nil {
			qrPostPonrRetryCount = *o.PostPonrRetryCount
		}
		qPostPonrRetryCount := swag.FormatInt64(qrPostPonrRetryCount)
		if qPostPonrRetryCount != "" {

			if err := r.SetQueryParam("post_ponr_retry_count", qPostPonrRetryCount); err != nil {
				return err
			}
		}
	}

	if o.RestartCount != nil {

		// query param restart_count
		var qrRestartCount int64

		if o.RestartCount != nil {
			qrRestartCount = *o.RestartCount
		}
		qRestartCount := swag.FormatInt64(qrRestartCount)
		if qRestartCount != "" {

			if err := r.SetQueryParam("restart_count", qRestartCount); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.SourceClusterName != nil {

		// query param source.cluster.name
		var qrSourceClusterName string

		if o.SourceClusterName != nil {
			qrSourceClusterName = *o.SourceClusterName
		}
		qSourceClusterName := qrSourceClusterName
		if qSourceClusterName != "" {

			if err := r.SetQueryParam("source.cluster.name", qSourceClusterName); err != nil {
				return err
			}
		}
	}

	if o.SourceClusterUUID != nil {

		// query param source.cluster.uuid
		var qrSourceClusterUUID string

		if o.SourceClusterUUID != nil {
			qrSourceClusterUUID = *o.SourceClusterUUID
		}
		qSourceClusterUUID := qrSourceClusterUUID
		if qSourceClusterUUID != "" {

			if err := r.SetQueryParam("source.cluster.uuid", qSourceClusterUUID); err != nil {
				return err
			}
		}
	}

	if o.SourceSvmName != nil {

		// query param source.svm.name
		var qrSourceSvmName string

		if o.SourceSvmName != nil {
			qrSourceSvmName = *o.SourceSvmName
		}
		qSourceSvmName := qrSourceSvmName
		if qSourceSvmName != "" {

			if err := r.SetQueryParam("source.svm.name", qSourceSvmName); err != nil {
				return err
			}
		}
	}

	if o.SourceSvmUUID != nil {

		// query param source.svm.uuid
		var qrSourceSvmUUID string

		if o.SourceSvmUUID != nil {
			qrSourceSvmUUID = *o.SourceSvmUUID
		}
		qSourceSvmUUID := qrSourceSvmUUID
		if qSourceSvmUUID != "" {

			if err := r.SetQueryParam("source.svm.uuid", qSourceSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.State != nil {

		// query param state
		var qrState string

		if o.State != nil {
			qrState = *o.State
		}
		qState := qrState
		if qState != "" {

			if err := r.SetQueryParam("state", qState); err != nil {
				return err
			}
		}
	}

	if o.Throttle != nil {

		// query param throttle
		var qrThrottle int64

		if o.Throttle != nil {
			qrThrottle = *o.Throttle
		}
		qThrottle := swag.FormatInt64(qrThrottle)
		if qThrottle != "" {

			if err := r.SetQueryParam("throttle", qThrottle); err != nil {
				return err
			}
		}
	}

	if o.TimeMetricsCutoverCompleteTime != nil {

		// query param time_metrics.cutover_complete_time
		var qrTimeMetricsCutoverCompleteTime string

		if o.TimeMetricsCutoverCompleteTime != nil {
			qrTimeMetricsCutoverCompleteTime = *o.TimeMetricsCutoverCompleteTime
		}
		qTimeMetricsCutoverCompleteTime := qrTimeMetricsCutoverCompleteTime
		if qTimeMetricsCutoverCompleteTime != "" {

			if err := r.SetQueryParam("time_metrics.cutover_complete_time", qTimeMetricsCutoverCompleteTime); err != nil {
				return err
			}
		}
	}

	if o.TimeMetricsCutoverStartTime != nil {

		// query param time_metrics.cutover_start_time
		var qrTimeMetricsCutoverStartTime string

		if o.TimeMetricsCutoverStartTime != nil {
			qrTimeMetricsCutoverStartTime = *o.TimeMetricsCutoverStartTime
		}
		qTimeMetricsCutoverStartTime := qrTimeMetricsCutoverStartTime
		if qTimeMetricsCutoverStartTime != "" {

			if err := r.SetQueryParam("time_metrics.cutover_start_time", qTimeMetricsCutoverStartTime); err != nil {
				return err
			}
		}
	}

	if o.TimeMetricsCutoverTriggerTime != nil {

		// query param time_metrics.cutover_trigger_time
		var qrTimeMetricsCutoverTriggerTime string

		if o.TimeMetricsCutoverTriggerTime != nil {
			qrTimeMetricsCutoverTriggerTime = *o.TimeMetricsCutoverTriggerTime
		}
		qTimeMetricsCutoverTriggerTime := qrTimeMetricsCutoverTriggerTime
		if qTimeMetricsCutoverTriggerTime != "" {

			if err := r.SetQueryParam("time_metrics.cutover_trigger_time", qTimeMetricsCutoverTriggerTime); err != nil {
				return err
			}
		}
	}

	if o.TimeMetricsEndTime != nil {

		// query param time_metrics.end_time
		var qrTimeMetricsEndTime string

		if o.TimeMetricsEndTime != nil {
			qrTimeMetricsEndTime = *o.TimeMetricsEndTime
		}
		qTimeMetricsEndTime := qrTimeMetricsEndTime
		if qTimeMetricsEndTime != "" {

			if err := r.SetQueryParam("time_metrics.end_time", qTimeMetricsEndTime); err != nil {
				return err
			}
		}
	}

	if o.TimeMetricsLastPauseTime != nil {

		// query param time_metrics.last_pause_time
		var qrTimeMetricsLastPauseTime string

		if o.TimeMetricsLastPauseTime != nil {
			qrTimeMetricsLastPauseTime = *o.TimeMetricsLastPauseTime
		}
		qTimeMetricsLastPauseTime := qrTimeMetricsLastPauseTime
		if qTimeMetricsLastPauseTime != "" {

			if err := r.SetQueryParam("time_metrics.last_pause_time", qTimeMetricsLastPauseTime); err != nil {
				return err
			}
		}
	}

	if o.TimeMetricsLastPostPonrRetryTime != nil {

		// query param time_metrics.last_post_ponr_retry_time
		var qrTimeMetricsLastPostPonrRetryTime string

		if o.TimeMetricsLastPostPonrRetryTime != nil {
			qrTimeMetricsLastPostPonrRetryTime = *o.TimeMetricsLastPostPonrRetryTime
		}
		qTimeMetricsLastPostPonrRetryTime := qrTimeMetricsLastPostPonrRetryTime
		if qTimeMetricsLastPostPonrRetryTime != "" {

			if err := r.SetQueryParam("time_metrics.last_post_ponr_retry_time", qTimeMetricsLastPostPonrRetryTime); err != nil {
				return err
			}
		}
	}

	if o.TimeMetricsLastResumeTime != nil {

		// query param time_metrics.last_resume_time
		var qrTimeMetricsLastResumeTime string

		if o.TimeMetricsLastResumeTime != nil {
			qrTimeMetricsLastResumeTime = *o.TimeMetricsLastResumeTime
		}
		qTimeMetricsLastResumeTime := qrTimeMetricsLastResumeTime
		if qTimeMetricsLastResumeTime != "" {

			if err := r.SetQueryParam("time_metrics.last_resume_time", qTimeMetricsLastResumeTime); err != nil {
				return err
			}
		}
	}

	if o.TimeMetricsStartTime != nil {

		// query param time_metrics.start_time
		var qrTimeMetricsStartTime string

		if o.TimeMetricsStartTime != nil {
			qrTimeMetricsStartTime = *o.TimeMetricsStartTime
		}
		qTimeMetricsStartTime := qrTimeMetricsStartTime
		if qTimeMetricsStartTime != "" {

			if err := r.SetQueryParam("time_metrics.start_time", qTimeMetricsStartTime); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
