// Code generated by go-swagger; DO NOT EDIT.

package svm

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SvmMigrationModifyCollectionReader is a Reader for the SvmMigrationModifyCollection structure.
type SvmMigrationModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SvmMigrationModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSvmMigrationModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewSvmMigrationModifyCollectionAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSvmMigrationModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSvmMigrationModifyCollectionOK creates a SvmMigrationModifyCollectionOK with default headers values
func NewSvmMigrationModifyCollectionOK() *SvmMigrationModifyCollectionOK {
	return &SvmMigrationModifyCollectionOK{}
}

/*
SvmMigrationModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type SvmMigrationModifyCollectionOK struct {
	Payload *models.SvmMigrationJobLinkResponse
}

// IsSuccess returns true when this svm migration modify collection o k response has a 2xx status code
func (o *SvmMigrationModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this svm migration modify collection o k response has a 3xx status code
func (o *SvmMigrationModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this svm migration modify collection o k response has a 4xx status code
func (o *SvmMigrationModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this svm migration modify collection o k response has a 5xx status code
func (o *SvmMigrationModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this svm migration modify collection o k response a status code equal to that given
func (o *SvmMigrationModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the svm migration modify collection o k response
func (o *SvmMigrationModifyCollectionOK) Code() int {
	return 200
}

func (o *SvmMigrationModifyCollectionOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /svm/migrations][%d] svmMigrationModifyCollectionOK %s", 200, payload)
}

func (o *SvmMigrationModifyCollectionOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /svm/migrations][%d] svmMigrationModifyCollectionOK %s", 200, payload)
}

func (o *SvmMigrationModifyCollectionOK) GetPayload() *models.SvmMigrationJobLinkResponse {
	return o.Payload
}

func (o *SvmMigrationModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SvmMigrationJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSvmMigrationModifyCollectionAccepted creates a SvmMigrationModifyCollectionAccepted with default headers values
func NewSvmMigrationModifyCollectionAccepted() *SvmMigrationModifyCollectionAccepted {
	return &SvmMigrationModifyCollectionAccepted{}
}

/*
SvmMigrationModifyCollectionAccepted describes a response with status code 202, with default header values.

Accepted
*/
type SvmMigrationModifyCollectionAccepted struct {
	Payload *models.SvmMigrationJobLinkResponse
}

// IsSuccess returns true when this svm migration modify collection accepted response has a 2xx status code
func (o *SvmMigrationModifyCollectionAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this svm migration modify collection accepted response has a 3xx status code
func (o *SvmMigrationModifyCollectionAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this svm migration modify collection accepted response has a 4xx status code
func (o *SvmMigrationModifyCollectionAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this svm migration modify collection accepted response has a 5xx status code
func (o *SvmMigrationModifyCollectionAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this svm migration modify collection accepted response a status code equal to that given
func (o *SvmMigrationModifyCollectionAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the svm migration modify collection accepted response
func (o *SvmMigrationModifyCollectionAccepted) Code() int {
	return 202
}

func (o *SvmMigrationModifyCollectionAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /svm/migrations][%d] svmMigrationModifyCollectionAccepted %s", 202, payload)
}

func (o *SvmMigrationModifyCollectionAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /svm/migrations][%d] svmMigrationModifyCollectionAccepted %s", 202, payload)
}

func (o *SvmMigrationModifyCollectionAccepted) GetPayload() *models.SvmMigrationJobLinkResponse {
	return o.Payload
}

func (o *SvmMigrationModifyCollectionAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SvmMigrationJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSvmMigrationModifyCollectionDefault creates a SvmMigrationModifyCollectionDefault with default headers values
func NewSvmMigrationModifyCollectionDefault(code int) *SvmMigrationModifyCollectionDefault {
	return &SvmMigrationModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	SvmMigrationModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 13172783 | Migrate RDB lookup failed |
| 13173737 | REST API PATCH method \\"/api/svm/migrations\\" is only supported on the destination cluster. Issue the REST API PATCH request to the destination cluster. |
| 13173746 | Migrate resume operation failed. Cannot specify volume granular placement during resume if aggregate placement was specified during start operation. |
| 13173747 | Migrate operation failed. Volume placement can only be specified on PATCH with an action of \\"resume\\". |
| 13173748 | Migrate request cannot contain both \\"aggregates\\" and \\"volume_aggregate_pairs\\" within the \\"volume_placement\\" object. |
| 13173763 | Migrate operation failed. LIF placement is not supported in PATCH operations. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type SvmMigrationModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this svm migration modify collection default response has a 2xx status code
func (o *SvmMigrationModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this svm migration modify collection default response has a 3xx status code
func (o *SvmMigrationModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this svm migration modify collection default response has a 4xx status code
func (o *SvmMigrationModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this svm migration modify collection default response has a 5xx status code
func (o *SvmMigrationModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this svm migration modify collection default response a status code equal to that given
func (o *SvmMigrationModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the svm migration modify collection default response
func (o *SvmMigrationModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *SvmMigrationModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /svm/migrations][%d] svm_migration_modify_collection default %s", o._statusCode, payload)
}

func (o *SvmMigrationModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /svm/migrations][%d] svm_migration_modify_collection default %s", o._statusCode, payload)
}

func (o *SvmMigrationModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SvmMigrationModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
SvmMigrationModifyCollectionBody svm migration modify collection body
swagger:model SvmMigrationModifyCollectionBody
*/
type SvmMigrationModifyCollectionBody struct {

	// Optional property that when set to true automatically performs cutover when the migration state reaches "ready for cutover".
	AutoCutover *bool `json:"auto_cutover,omitempty"`

	// Optional property that when set to true automatically cleans up the SVM on the source cluster after the migration cutover.
	AutoSourceCleanup *bool `json:"auto_source_cleanup,omitempty"`

	// Optional property that when set to true performs only migration pre-checks not the actual migration.
	CheckOnly *bool `json:"check_only,omitempty"`

	// current operation
	// Read Only: true
	CurrentOperation *models.SvmMigrationOperation `json:"current_operation,omitempty"`

	// destination
	Destination *models.SvmMigrationInlineDestination `json:"destination,omitempty"`

	// Optional property used to specify the IP interface placement in the destination. It is input only and is not returned by a subsequent GET.
	IPInterfacePlacement *models.SvmMigrationIPInterfacePlacement `json:"ip_interface_placement,omitempty"`

	// last failed state
	// Read Only: true
	LastFailedState *models.SvmMigrationState `json:"last_failed_state,omitempty"`

	// last operation
	// Read Only: true
	// Enum: ["none","start","resume","pause","cleanup","cutover"]
	LastOperation *string `json:"last_operation,omitempty"`

	// Indicates if the migration has progressed beyond the point of no return. When true, the migration cannot be aborted or paused. When false, the migration can be paused or aborted.
	// Read Only: true
	PointOfNoReturn *bool `json:"point_of_no_return,omitempty"`

	// Number of times the migration restarted after the point of no return.
	// Read Only: true
	PostPonrRetryCount *int64 `json:"post_ponr_retry_count,omitempty"`

	// Number of times migrate restarted the transfer, for example, rollback to transfer after starting the cutover.
	// Read Only: true
	RestartCount *int64 `json:"restart_count,omitempty"`

	// source
	Source *models.SvmMigrationInlineSource `json:"source,omitempty"`

	// state
	// Read Only: true
	State *models.SvmMigrationState `json:"state,omitempty"`

	// Errors and warnings returned/displayed during migration.
	// Read Only: true
	SvmMigrationInlineMessages []*models.SvmMigrationInlineMessagesInlineArrayItem `json:"messages,omitempty"`

	// svm migration response inline records
	SvmMigrationResponseInlineRecords []*models.SvmMigration `json:"records,omitempty"`

	// Optional property to specify a throttle value in KB/s for each individual volume transfer. Defaults to 0 if not set, which is interpreted as unlimited. The minimum throttle value is 4 KB/s, so if you specify a throttle value between 1 and 4, it will be treated as if you specified 4.
	Throttle *int64 `json:"throttle,omitempty"`

	// time metrics
	TimeMetrics *models.SvmMigrationInlineTimeMetrics `json:"time_metrics,omitempty"`

	// SVM migration UUID
	// Example: 4ea7a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this svm migration modify collection body
func (o *SvmMigrationModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateCurrentOperation(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateDestination(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateIPInterfacePlacement(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLastFailedState(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLastOperation(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSource(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSvmMigrationInlineMessages(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSvmMigrationResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateTimeMetrics(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmMigrationModifyCollectionBody) validateCurrentOperation(formats strfmt.Registry) error {
	if swag.IsZero(o.CurrentOperation) { // not required
		return nil
	}

	if o.CurrentOperation != nil {
		if err := o.CurrentOperation.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "current_operation")
			}
			return err
		}
	}

	return nil
}

func (o *SvmMigrationModifyCollectionBody) validateDestination(formats strfmt.Registry) error {
	if swag.IsZero(o.Destination) { // not required
		return nil
	}

	if o.Destination != nil {
		if err := o.Destination.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "destination")
			}
			return err
		}
	}

	return nil
}

func (o *SvmMigrationModifyCollectionBody) validateIPInterfacePlacement(formats strfmt.Registry) error {
	if swag.IsZero(o.IPInterfacePlacement) { // not required
		return nil
	}

	if o.IPInterfacePlacement != nil {
		if err := o.IPInterfacePlacement.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "ip_interface_placement")
			}
			return err
		}
	}

	return nil
}

func (o *SvmMigrationModifyCollectionBody) validateLastFailedState(formats strfmt.Registry) error {
	if swag.IsZero(o.LastFailedState) { // not required
		return nil
	}

	if o.LastFailedState != nil {
		if err := o.LastFailedState.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "last_failed_state")
			}
			return err
		}
	}

	return nil
}

var svmMigrationModifyCollectionBodyTypeLastOperationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["none","start","resume","pause","cleanup","cutover"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		svmMigrationModifyCollectionBodyTypeLastOperationPropEnum = append(svmMigrationModifyCollectionBodyTypeLastOperationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// SvmMigrationModifyCollectionBody
	// SvmMigrationModifyCollectionBody
	// last_operation
	// LastOperation
	// none
	// END DEBUGGING
	// SvmMigrationModifyCollectionBodyLastOperationNone captures enum value "none"
	SvmMigrationModifyCollectionBodyLastOperationNone string = "none"

	// BEGIN DEBUGGING
	// SvmMigrationModifyCollectionBody
	// SvmMigrationModifyCollectionBody
	// last_operation
	// LastOperation
	// start
	// END DEBUGGING
	// SvmMigrationModifyCollectionBodyLastOperationStart captures enum value "start"
	SvmMigrationModifyCollectionBodyLastOperationStart string = "start"

	// BEGIN DEBUGGING
	// SvmMigrationModifyCollectionBody
	// SvmMigrationModifyCollectionBody
	// last_operation
	// LastOperation
	// resume
	// END DEBUGGING
	// SvmMigrationModifyCollectionBodyLastOperationResume captures enum value "resume"
	SvmMigrationModifyCollectionBodyLastOperationResume string = "resume"

	// BEGIN DEBUGGING
	// SvmMigrationModifyCollectionBody
	// SvmMigrationModifyCollectionBody
	// last_operation
	// LastOperation
	// pause
	// END DEBUGGING
	// SvmMigrationModifyCollectionBodyLastOperationPause captures enum value "pause"
	SvmMigrationModifyCollectionBodyLastOperationPause string = "pause"

	// BEGIN DEBUGGING
	// SvmMigrationModifyCollectionBody
	// SvmMigrationModifyCollectionBody
	// last_operation
	// LastOperation
	// cleanup
	// END DEBUGGING
	// SvmMigrationModifyCollectionBodyLastOperationCleanup captures enum value "cleanup"
	SvmMigrationModifyCollectionBodyLastOperationCleanup string = "cleanup"

	// BEGIN DEBUGGING
	// SvmMigrationModifyCollectionBody
	// SvmMigrationModifyCollectionBody
	// last_operation
	// LastOperation
	// cutover
	// END DEBUGGING
	// SvmMigrationModifyCollectionBodyLastOperationCutover captures enum value "cutover"
	SvmMigrationModifyCollectionBodyLastOperationCutover string = "cutover"
)

// prop value enum
func (o *SvmMigrationModifyCollectionBody) validateLastOperationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, svmMigrationModifyCollectionBodyTypeLastOperationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *SvmMigrationModifyCollectionBody) validateLastOperation(formats strfmt.Registry) error {
	if swag.IsZero(o.LastOperation) { // not required
		return nil
	}

	// value enum
	if err := o.validateLastOperationEnum("info"+"."+"last_operation", "body", *o.LastOperation); err != nil {
		return err
	}

	return nil
}

func (o *SvmMigrationModifyCollectionBody) validateSource(formats strfmt.Registry) error {
	if swag.IsZero(o.Source) { // not required
		return nil
	}

	if o.Source != nil {
		if err := o.Source.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "source")
			}
			return err
		}
	}

	return nil
}

func (o *SvmMigrationModifyCollectionBody) validateState(formats strfmt.Registry) error {
	if swag.IsZero(o.State) { // not required
		return nil
	}

	if o.State != nil {
		if err := o.State.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "state")
			}
			return err
		}
	}

	return nil
}

func (o *SvmMigrationModifyCollectionBody) validateSvmMigrationInlineMessages(formats strfmt.Registry) error {
	if swag.IsZero(o.SvmMigrationInlineMessages) { // not required
		return nil
	}

	for i := 0; i < len(o.SvmMigrationInlineMessages); i++ {
		if swag.IsZero(o.SvmMigrationInlineMessages[i]) { // not required
			continue
		}

		if o.SvmMigrationInlineMessages[i] != nil {
			if err := o.SvmMigrationInlineMessages[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "messages" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *SvmMigrationModifyCollectionBody) validateSvmMigrationResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.SvmMigrationResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.SvmMigrationResponseInlineRecords); i++ {
		if swag.IsZero(o.SvmMigrationResponseInlineRecords[i]) { // not required
			continue
		}

		if o.SvmMigrationResponseInlineRecords[i] != nil {
			if err := o.SvmMigrationResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *SvmMigrationModifyCollectionBody) validateTimeMetrics(formats strfmt.Registry) error {
	if swag.IsZero(o.TimeMetrics) { // not required
		return nil
	}

	if o.TimeMetrics != nil {
		if err := o.TimeMetrics.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "time_metrics")
			}
			return err
		}
	}

	return nil
}

func (o *SvmMigrationModifyCollectionBody) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(o.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"uuid", "body", "uuid", o.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this svm migration modify collection body based on the context it is used
func (o *SvmMigrationModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateCurrentOperation(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateDestination(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIPInterfacePlacement(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLastFailedState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLastOperation(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidatePointOfNoReturn(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidatePostPonrRetryCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateRestartCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSource(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSvmMigrationInlineMessages(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSvmMigrationResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTimeMetrics(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmMigrationModifyCollectionBody) contextValidateCurrentOperation(ctx context.Context, formats strfmt.Registry) error {

	if o.CurrentOperation != nil {
		if err := o.CurrentOperation.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "current_operation")
			}
			return err
		}
	}

	return nil
}

func (o *SvmMigrationModifyCollectionBody) contextValidateDestination(ctx context.Context, formats strfmt.Registry) error {

	if o.Destination != nil {
		if err := o.Destination.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "destination")
			}
			return err
		}
	}

	return nil
}

func (o *SvmMigrationModifyCollectionBody) contextValidateIPInterfacePlacement(ctx context.Context, formats strfmt.Registry) error {

	if o.IPInterfacePlacement != nil {
		if err := o.IPInterfacePlacement.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "ip_interface_placement")
			}
			return err
		}
	}

	return nil
}

func (o *SvmMigrationModifyCollectionBody) contextValidateLastFailedState(ctx context.Context, formats strfmt.Registry) error {

	if o.LastFailedState != nil {
		if err := o.LastFailedState.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "last_failed_state")
			}
			return err
		}
	}

	return nil
}

func (o *SvmMigrationModifyCollectionBody) contextValidateLastOperation(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"last_operation", "body", o.LastOperation); err != nil {
		return err
	}

	return nil
}

func (o *SvmMigrationModifyCollectionBody) contextValidatePointOfNoReturn(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"point_of_no_return", "body", o.PointOfNoReturn); err != nil {
		return err
	}

	return nil
}

func (o *SvmMigrationModifyCollectionBody) contextValidatePostPonrRetryCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"post_ponr_retry_count", "body", o.PostPonrRetryCount); err != nil {
		return err
	}

	return nil
}

func (o *SvmMigrationModifyCollectionBody) contextValidateRestartCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"restart_count", "body", o.RestartCount); err != nil {
		return err
	}

	return nil
}

func (o *SvmMigrationModifyCollectionBody) contextValidateSource(ctx context.Context, formats strfmt.Registry) error {

	if o.Source != nil {
		if err := o.Source.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "source")
			}
			return err
		}
	}

	return nil
}

func (o *SvmMigrationModifyCollectionBody) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if o.State != nil {
		if err := o.State.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "state")
			}
			return err
		}
	}

	return nil
}

func (o *SvmMigrationModifyCollectionBody) contextValidateSvmMigrationInlineMessages(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"messages", "body", []*models.SvmMigrationInlineMessagesInlineArrayItem(o.SvmMigrationInlineMessages)); err != nil {
		return err
	}

	for i := 0; i < len(o.SvmMigrationInlineMessages); i++ {

		if o.SvmMigrationInlineMessages[i] != nil {
			if err := o.SvmMigrationInlineMessages[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "messages" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *SvmMigrationModifyCollectionBody) contextValidateSvmMigrationResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.SvmMigrationResponseInlineRecords); i++ {

		if o.SvmMigrationResponseInlineRecords[i] != nil {
			if err := o.SvmMigrationResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *SvmMigrationModifyCollectionBody) contextValidateTimeMetrics(ctx context.Context, formats strfmt.Registry) error {

	if o.TimeMetrics != nil {
		if err := o.TimeMetrics.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "time_metrics")
			}
			return err
		}
	}

	return nil
}

func (o *SvmMigrationModifyCollectionBody) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SvmMigrationModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SvmMigrationModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res SvmMigrationModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SvmMigrationModifyCollectionParamsBodyDestinationVolumePlacementAggregatesItems0 Aggregate
swagger:model SvmMigrationModifyCollectionParamsBodyDestinationVolumePlacementAggregatesItems0
*/
type SvmMigrationModifyCollectionParamsBodyDestinationVolumePlacementAggregatesItems0 struct {

	// links
	Links *SvmMigrationModifyCollectionParamsBodyDestinationVolumePlacementAggregatesItems0Links `json:"_links,omitempty"`

	// name
	// Example: aggr1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this svm migration modify collection params body destination volume placement aggregates items0
func (o *SvmMigrationModifyCollectionParamsBodyDestinationVolumePlacementAggregatesItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmMigrationModifyCollectionParamsBodyDestinationVolumePlacementAggregatesItems0) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm migration modify collection params body destination volume placement aggregates items0 based on the context it is used
func (o *SvmMigrationModifyCollectionParamsBodyDestinationVolumePlacementAggregatesItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmMigrationModifyCollectionParamsBodyDestinationVolumePlacementAggregatesItems0) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SvmMigrationModifyCollectionParamsBodyDestinationVolumePlacementAggregatesItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SvmMigrationModifyCollectionParamsBodyDestinationVolumePlacementAggregatesItems0) UnmarshalBinary(b []byte) error {
	var res SvmMigrationModifyCollectionParamsBodyDestinationVolumePlacementAggregatesItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SvmMigrationModifyCollectionParamsBodyDestinationVolumePlacementAggregatesItems0Links svm migration modify collection params body destination volume placement aggregates items0 links
swagger:model SvmMigrationModifyCollectionParamsBodyDestinationVolumePlacementAggregatesItems0Links
*/
type SvmMigrationModifyCollectionParamsBodyDestinationVolumePlacementAggregatesItems0Links struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this svm migration modify collection params body destination volume placement aggregates items0 links
func (o *SvmMigrationModifyCollectionParamsBodyDestinationVolumePlacementAggregatesItems0Links) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmMigrationModifyCollectionParamsBodyDestinationVolumePlacementAggregatesItems0Links) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm migration modify collection params body destination volume placement aggregates items0 links based on the context it is used
func (o *SvmMigrationModifyCollectionParamsBodyDestinationVolumePlacementAggregatesItems0Links) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmMigrationModifyCollectionParamsBodyDestinationVolumePlacementAggregatesItems0Links) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SvmMigrationModifyCollectionParamsBodyDestinationVolumePlacementAggregatesItems0Links) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SvmMigrationModifyCollectionParamsBodyDestinationVolumePlacementAggregatesItems0Links) UnmarshalBinary(b []byte) error {
	var res SvmMigrationModifyCollectionParamsBodyDestinationVolumePlacementAggregatesItems0Links
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SvmMigrationModifyCollectionParamsBodyDestinationVolumePlacementVolumeAggregatePairsItems0 Volume-aggregate pair information.
swagger:model SvmMigrationModifyCollectionParamsBodyDestinationVolumePlacementVolumeAggregatePairsItems0
*/
type SvmMigrationModifyCollectionParamsBodyDestinationVolumePlacementVolumeAggregatePairsItems0 struct {

	// aggregate
	Aggregate *SvmMigrationModifyCollectionParamsBodyDestinationVolumePlacementVolumeAggregatePairsItems0Aggregate `json:"aggregate,omitempty"`

	// volume
	Volume *SvmMigrationModifyCollectionParamsBodyDestinationVolumePlacementVolumeAggregatePairsItems0Volume `json:"volume,omitempty"`
}

// Validate validates this svm migration modify collection params body destination volume placement volume aggregate pairs items0
func (o *SvmMigrationModifyCollectionParamsBodyDestinationVolumePlacementVolumeAggregatePairsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateAggregate(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateVolume(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmMigrationModifyCollectionParamsBodyDestinationVolumePlacementVolumeAggregatePairsItems0) validateAggregate(formats strfmt.Registry) error {
	if swag.IsZero(o.Aggregate) { // not required
		return nil
	}

	if o.Aggregate != nil {
		if err := o.Aggregate.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("aggregate")
			}
			return err
		}
	}

	return nil
}

func (o *SvmMigrationModifyCollectionParamsBodyDestinationVolumePlacementVolumeAggregatePairsItems0) validateVolume(formats strfmt.Registry) error {
	if swag.IsZero(o.Volume) { // not required
		return nil
	}

	if o.Volume != nil {
		if err := o.Volume.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm migration modify collection params body destination volume placement volume aggregate pairs items0 based on the context it is used
func (o *SvmMigrationModifyCollectionParamsBodyDestinationVolumePlacementVolumeAggregatePairsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateAggregate(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateVolume(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmMigrationModifyCollectionParamsBodyDestinationVolumePlacementVolumeAggregatePairsItems0) contextValidateAggregate(ctx context.Context, formats strfmt.Registry) error {

	if o.Aggregate != nil {
		if err := o.Aggregate.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("aggregate")
			}
			return err
		}
	}

	return nil
}

func (o *SvmMigrationModifyCollectionParamsBodyDestinationVolumePlacementVolumeAggregatePairsItems0) contextValidateVolume(ctx context.Context, formats strfmt.Registry) error {

	if o.Volume != nil {
		if err := o.Volume.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SvmMigrationModifyCollectionParamsBodyDestinationVolumePlacementVolumeAggregatePairsItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SvmMigrationModifyCollectionParamsBodyDestinationVolumePlacementVolumeAggregatePairsItems0) UnmarshalBinary(b []byte) error {
	var res SvmMigrationModifyCollectionParamsBodyDestinationVolumePlacementVolumeAggregatePairsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SvmMigrationModifyCollectionParamsBodyDestinationVolumePlacementVolumeAggregatePairsItems0Aggregate Aggregate to use for volume creation.
swagger:model SvmMigrationModifyCollectionParamsBodyDestinationVolumePlacementVolumeAggregatePairsItems0Aggregate
*/
type SvmMigrationModifyCollectionParamsBodyDestinationVolumePlacementVolumeAggregatePairsItems0Aggregate struct {

	// links
	Links *SvmMigrationModifyCollectionParamsBodyDestinationVolumePlacementVolumeAggregatePairsItems0AggregateLinks `json:"_links,omitempty"`

	// name
	// Example: aggr1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this svm migration modify collection params body destination volume placement volume aggregate pairs items0 aggregate
func (o *SvmMigrationModifyCollectionParamsBodyDestinationVolumePlacementVolumeAggregatePairsItems0Aggregate) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmMigrationModifyCollectionParamsBodyDestinationVolumePlacementVolumeAggregatePairsItems0Aggregate) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("aggregate" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm migration modify collection params body destination volume placement volume aggregate pairs items0 aggregate based on the context it is used
func (o *SvmMigrationModifyCollectionParamsBodyDestinationVolumePlacementVolumeAggregatePairsItems0Aggregate) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmMigrationModifyCollectionParamsBodyDestinationVolumePlacementVolumeAggregatePairsItems0Aggregate) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("aggregate" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SvmMigrationModifyCollectionParamsBodyDestinationVolumePlacementVolumeAggregatePairsItems0Aggregate) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SvmMigrationModifyCollectionParamsBodyDestinationVolumePlacementVolumeAggregatePairsItems0Aggregate) UnmarshalBinary(b []byte) error {
	var res SvmMigrationModifyCollectionParamsBodyDestinationVolumePlacementVolumeAggregatePairsItems0Aggregate
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SvmMigrationModifyCollectionParamsBodyDestinationVolumePlacementVolumeAggregatePairsItems0AggregateLinks svm migration modify collection params body destination volume placement volume aggregate pairs items0 aggregate links
swagger:model SvmMigrationModifyCollectionParamsBodyDestinationVolumePlacementVolumeAggregatePairsItems0AggregateLinks
*/
type SvmMigrationModifyCollectionParamsBodyDestinationVolumePlacementVolumeAggregatePairsItems0AggregateLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this svm migration modify collection params body destination volume placement volume aggregate pairs items0 aggregate links
func (o *SvmMigrationModifyCollectionParamsBodyDestinationVolumePlacementVolumeAggregatePairsItems0AggregateLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmMigrationModifyCollectionParamsBodyDestinationVolumePlacementVolumeAggregatePairsItems0AggregateLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("aggregate" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm migration modify collection params body destination volume placement volume aggregate pairs items0 aggregate links based on the context it is used
func (o *SvmMigrationModifyCollectionParamsBodyDestinationVolumePlacementVolumeAggregatePairsItems0AggregateLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmMigrationModifyCollectionParamsBodyDestinationVolumePlacementVolumeAggregatePairsItems0AggregateLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("aggregate" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SvmMigrationModifyCollectionParamsBodyDestinationVolumePlacementVolumeAggregatePairsItems0AggregateLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SvmMigrationModifyCollectionParamsBodyDestinationVolumePlacementVolumeAggregatePairsItems0AggregateLinks) UnmarshalBinary(b []byte) error {
	var res SvmMigrationModifyCollectionParamsBodyDestinationVolumePlacementVolumeAggregatePairsItems0AggregateLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SvmMigrationModifyCollectionParamsBodyDestinationVolumePlacementVolumeAggregatePairsItems0Volume Property indicating the source volume.
swagger:model SvmMigrationModifyCollectionParamsBodyDestinationVolumePlacementVolumeAggregatePairsItems0Volume
*/
type SvmMigrationModifyCollectionParamsBodyDestinationVolumePlacementVolumeAggregatePairsItems0Volume struct {

	// links
	Links *SvmMigrationModifyCollectionParamsBodyDestinationVolumePlacementVolumeAggregatePairsItems0VolumeLinks `json:"_links,omitempty"`

	// The name of the volume. This field cannot be specified in a PATCH method.
	// Example: volume1
	Name *string `json:"name,omitempty"`

	// Unique identifier for the volume. This corresponds to the instance-uuid that is exposed in the CLI and ONTAPI. It does not change due to a volume move.
	// Example: 028baa66-41bd-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this svm migration modify collection params body destination volume placement volume aggregate pairs items0 volume
func (o *SvmMigrationModifyCollectionParamsBodyDestinationVolumePlacementVolumeAggregatePairsItems0Volume) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmMigrationModifyCollectionParamsBodyDestinationVolumePlacementVolumeAggregatePairsItems0Volume) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm migration modify collection params body destination volume placement volume aggregate pairs items0 volume based on the context it is used
func (o *SvmMigrationModifyCollectionParamsBodyDestinationVolumePlacementVolumeAggregatePairsItems0Volume) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmMigrationModifyCollectionParamsBodyDestinationVolumePlacementVolumeAggregatePairsItems0Volume) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SvmMigrationModifyCollectionParamsBodyDestinationVolumePlacementVolumeAggregatePairsItems0Volume) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SvmMigrationModifyCollectionParamsBodyDestinationVolumePlacementVolumeAggregatePairsItems0Volume) UnmarshalBinary(b []byte) error {
	var res SvmMigrationModifyCollectionParamsBodyDestinationVolumePlacementVolumeAggregatePairsItems0Volume
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SvmMigrationModifyCollectionParamsBodyDestinationVolumePlacementVolumeAggregatePairsItems0VolumeLinks svm migration modify collection params body destination volume placement volume aggregate pairs items0 volume links
swagger:model SvmMigrationModifyCollectionParamsBodyDestinationVolumePlacementVolumeAggregatePairsItems0VolumeLinks
*/
type SvmMigrationModifyCollectionParamsBodyDestinationVolumePlacementVolumeAggregatePairsItems0VolumeLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this svm migration modify collection params body destination volume placement volume aggregate pairs items0 volume links
func (o *SvmMigrationModifyCollectionParamsBodyDestinationVolumePlacementVolumeAggregatePairsItems0VolumeLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmMigrationModifyCollectionParamsBodyDestinationVolumePlacementVolumeAggregatePairsItems0VolumeLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm migration modify collection params body destination volume placement volume aggregate pairs items0 volume links based on the context it is used
func (o *SvmMigrationModifyCollectionParamsBodyDestinationVolumePlacementVolumeAggregatePairsItems0VolumeLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmMigrationModifyCollectionParamsBodyDestinationVolumePlacementVolumeAggregatePairsItems0VolumeLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SvmMigrationModifyCollectionParamsBodyDestinationVolumePlacementVolumeAggregatePairsItems0VolumeLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SvmMigrationModifyCollectionParamsBodyDestinationVolumePlacementVolumeAggregatePairsItems0VolumeLinks) UnmarshalBinary(b []byte) error {
	var res SvmMigrationModifyCollectionParamsBodyDestinationVolumePlacementVolumeAggregatePairsItems0VolumeLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SvmMigrationInlineDestination Destination cluster details for the SVM migration.
swagger:model svm_migration_inline_destination
*/
type SvmMigrationInlineDestination struct {

	// ipspace
	Ipspace *models.SvmMigrationInlineDestinationInlineIpspace `json:"ipspace,omitempty"`

	// volume placement
	VolumePlacement *models.SvmMigrationInlineDestinationInlineVolumePlacement `json:"volume_placement,omitempty"`
}

// Validate validates this svm migration inline destination
func (o *SvmMigrationInlineDestination) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateIpspace(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateVolumePlacement(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmMigrationInlineDestination) validateIpspace(formats strfmt.Registry) error {
	if swag.IsZero(o.Ipspace) { // not required
		return nil
	}

	if o.Ipspace != nil {
		if err := o.Ipspace.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "destination" + "." + "ipspace")
			}
			return err
		}
	}

	return nil
}

func (o *SvmMigrationInlineDestination) validateVolumePlacement(formats strfmt.Registry) error {
	if swag.IsZero(o.VolumePlacement) { // not required
		return nil
	}

	if o.VolumePlacement != nil {
		if err := o.VolumePlacement.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "destination" + "." + "volume_placement")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm migration inline destination based on the context it is used
func (o *SvmMigrationInlineDestination) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateIpspace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateVolumePlacement(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmMigrationInlineDestination) contextValidateIpspace(ctx context.Context, formats strfmt.Registry) error {

	if o.Ipspace != nil {
		if err := o.Ipspace.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "destination" + "." + "ipspace")
			}
			return err
		}
	}

	return nil
}

func (o *SvmMigrationInlineDestination) contextValidateVolumePlacement(ctx context.Context, formats strfmt.Registry) error {

	if o.VolumePlacement != nil {
		if err := o.VolumePlacement.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "destination" + "." + "volume_placement")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SvmMigrationInlineDestination) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SvmMigrationInlineDestination) UnmarshalBinary(b []byte) error {
	var res SvmMigrationInlineDestination
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SvmMigrationInlineDestinationInlineIpspace Optional property used to specify which IPspace to use for the SVM. By default, the "default" ipspace is used.
swagger:model svm_migration_inline_destination_inline_ipspace
*/
type SvmMigrationInlineDestinationInlineIpspace struct {

	// links
	Links *models.SvmMigrationInlineDestinationInlineIpspaceInlineLinks `json:"_links,omitempty"`

	// IPspace name
	// Example: Default
	Name *string `json:"name,omitempty"`

	// IPspace UUID
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this svm migration inline destination inline ipspace
func (o *SvmMigrationInlineDestinationInlineIpspace) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmMigrationInlineDestinationInlineIpspace) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "destination" + "." + "ipspace" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm migration inline destination inline ipspace based on the context it is used
func (o *SvmMigrationInlineDestinationInlineIpspace) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmMigrationInlineDestinationInlineIpspace) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "destination" + "." + "ipspace" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SvmMigrationInlineDestinationInlineIpspace) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SvmMigrationInlineDestinationInlineIpspace) UnmarshalBinary(b []byte) error {
	var res SvmMigrationInlineDestinationInlineIpspace
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SvmMigrationInlineDestinationInlineIpspaceInlineLinks svm migration inline destination inline ipspace inline links
swagger:model svm_migration_inline_destination_inline_ipspace_inline__links
*/
type SvmMigrationInlineDestinationInlineIpspaceInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this svm migration inline destination inline ipspace inline links
func (o *SvmMigrationInlineDestinationInlineIpspaceInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmMigrationInlineDestinationInlineIpspaceInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "destination" + "." + "ipspace" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm migration inline destination inline ipspace inline links based on the context it is used
func (o *SvmMigrationInlineDestinationInlineIpspaceInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmMigrationInlineDestinationInlineIpspaceInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "destination" + "." + "ipspace" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SvmMigrationInlineDestinationInlineIpspaceInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SvmMigrationInlineDestinationInlineIpspaceInlineLinks) UnmarshalBinary(b []byte) error {
	var res SvmMigrationInlineDestinationInlineIpspaceInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SvmMigrationInlineDestinationInlineVolumePlacement Optional property to specify the source volume placement in the destination. It is input only and won't be returned by a subsequent GET. Volume placement is ignored if the migration resumes from the cleanup_failed state.
swagger:model svm_migration_inline_destination_inline_volume_placement
*/
type SvmMigrationInlineDestinationInlineVolumePlacement struct {

	// Optional property used to specify the list of desired aggregates to use for volume creation in the destination.
	Aggregates []*SvmMigrationModifyCollectionParamsBodyDestinationVolumePlacementAggregatesItems0 `json:"aggregates,omitempty"`

	// Optional property used to specify the list of desired volume-aggregate pairs in the destination.
	VolumeAggregatePairs []*SvmMigrationModifyCollectionParamsBodyDestinationVolumePlacementVolumeAggregatePairsItems0 `json:"volume_aggregate_pairs,omitempty"`
}

// Validate validates this svm migration inline destination inline volume placement
func (o *SvmMigrationInlineDestinationInlineVolumePlacement) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateAggregates(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateVolumeAggregatePairs(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmMigrationInlineDestinationInlineVolumePlacement) validateAggregates(formats strfmt.Registry) error {
	if swag.IsZero(o.Aggregates) { // not required
		return nil
	}

	for i := 0; i < len(o.Aggregates); i++ {
		if swag.IsZero(o.Aggregates[i]) { // not required
			continue
		}

		if o.Aggregates[i] != nil {
			if err := o.Aggregates[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "destination" + "." + "volume_placement" + "." + "aggregates" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *SvmMigrationInlineDestinationInlineVolumePlacement) validateVolumeAggregatePairs(formats strfmt.Registry) error {
	if swag.IsZero(o.VolumeAggregatePairs) { // not required
		return nil
	}

	for i := 0; i < len(o.VolumeAggregatePairs); i++ {
		if swag.IsZero(o.VolumeAggregatePairs[i]) { // not required
			continue
		}

		if o.VolumeAggregatePairs[i] != nil {
			if err := o.VolumeAggregatePairs[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "destination" + "." + "volume_placement" + "." + "volume_aggregate_pairs" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this svm migration inline destination inline volume placement based on the context it is used
func (o *SvmMigrationInlineDestinationInlineVolumePlacement) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateAggregates(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateVolumeAggregatePairs(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmMigrationInlineDestinationInlineVolumePlacement) contextValidateAggregates(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.Aggregates); i++ {

		if o.Aggregates[i] != nil {
			if err := o.Aggregates[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "destination" + "." + "volume_placement" + "." + "aggregates" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *SvmMigrationInlineDestinationInlineVolumePlacement) contextValidateVolumeAggregatePairs(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.VolumeAggregatePairs); i++ {

		if o.VolumeAggregatePairs[i] != nil {
			if err := o.VolumeAggregatePairs[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "destination" + "." + "volume_placement" + "." + "volume_aggregate_pairs" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *SvmMigrationInlineDestinationInlineVolumePlacement) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SvmMigrationInlineDestinationInlineVolumePlacement) UnmarshalBinary(b []byte) error {
	var res SvmMigrationInlineDestinationInlineVolumePlacement
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SvmMigrationInlineMessagesInlineArrayItem svm migration inline messages inline array item
swagger:model svm_migration_inline_messages_inline_array_item
*/
type SvmMigrationInlineMessagesInlineArrayItem struct {

	// Argument code
	// Read Only: true
	Code *string `json:"code,omitempty"`

	// Message argument
	// Read Only: true
	Message *string `json:"message,omitempty"`
}

// Validate validates this svm migration inline messages inline array item
func (o *SvmMigrationInlineMessagesInlineArrayItem) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this svm migration inline messages inline array item based on the context it is used
func (o *SvmMigrationInlineMessagesInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateCode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmMigrationInlineMessagesInlineArrayItem) contextValidateCode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "code", "body", o.Code); err != nil {
		return err
	}

	return nil
}

func (o *SvmMigrationInlineMessagesInlineArrayItem) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "message", "body", o.Message); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SvmMigrationInlineMessagesInlineArrayItem) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SvmMigrationInlineMessagesInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res SvmMigrationInlineMessagesInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SvmMigrationInlineSource Source cluster details for the SVM migration.
swagger:model svm_migration_inline_source
*/
type SvmMigrationInlineSource struct {

	// cluster
	Cluster *models.SvmMigrationInlineSourceInlineCluster `json:"cluster,omitempty"`

	// svm
	Svm *models.SvmMigrationInlineSourceInlineSvm `json:"svm,omitempty"`
}

// Validate validates this svm migration inline source
func (o *SvmMigrationInlineSource) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateCluster(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmMigrationInlineSource) validateCluster(formats strfmt.Registry) error {
	if swag.IsZero(o.Cluster) { // not required
		return nil
	}

	if o.Cluster != nil {
		if err := o.Cluster.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "source" + "." + "cluster")
			}
			return err
		}
	}

	return nil
}

func (o *SvmMigrationInlineSource) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(o.Svm) { // not required
		return nil
	}

	if o.Svm != nil {
		if err := o.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "source" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm migration inline source based on the context it is used
func (o *SvmMigrationInlineSource) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateCluster(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmMigrationInlineSource) contextValidateCluster(ctx context.Context, formats strfmt.Registry) error {

	if o.Cluster != nil {
		if err := o.Cluster.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "source" + "." + "cluster")
			}
			return err
		}
	}

	return nil
}

func (o *SvmMigrationInlineSource) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if o.Svm != nil {
		if err := o.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "source" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SvmMigrationInlineSource) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SvmMigrationInlineSource) UnmarshalBinary(b []byte) error {
	var res SvmMigrationInlineSource
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SvmMigrationInlineSourceInlineCluster Source cluster for the SVM migration.
swagger:model svm_migration_inline_source_inline_cluster
*/
type SvmMigrationInlineSourceInlineCluster struct {

	// links
	Links *models.SvmMigrationInlineSourceInlineClusterInlineLinks `json:"_links,omitempty"`

	// name
	// Example: cluster1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this svm migration inline source inline cluster
func (o *SvmMigrationInlineSourceInlineCluster) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmMigrationInlineSourceInlineCluster) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "source" + "." + "cluster" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *SvmMigrationInlineSourceInlineCluster) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(o.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"source"+"."+"cluster"+"."+"uuid", "body", "uuid", o.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this svm migration inline source inline cluster based on the context it is used
func (o *SvmMigrationInlineSourceInlineCluster) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmMigrationInlineSourceInlineCluster) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "source" + "." + "cluster" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SvmMigrationInlineSourceInlineCluster) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SvmMigrationInlineSourceInlineCluster) UnmarshalBinary(b []byte) error {
	var res SvmMigrationInlineSourceInlineCluster
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SvmMigrationInlineSourceInlineClusterInlineLinks svm migration inline source inline cluster inline links
swagger:model svm_migration_inline_source_inline_cluster_inline__links
*/
type SvmMigrationInlineSourceInlineClusterInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this svm migration inline source inline cluster inline links
func (o *SvmMigrationInlineSourceInlineClusterInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmMigrationInlineSourceInlineClusterInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "source" + "." + "cluster" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm migration inline source inline cluster inline links based on the context it is used
func (o *SvmMigrationInlineSourceInlineClusterInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmMigrationInlineSourceInlineClusterInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "source" + "." + "cluster" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SvmMigrationInlineSourceInlineClusterInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SvmMigrationInlineSourceInlineClusterInlineLinks) UnmarshalBinary(b []byte) error {
	var res SvmMigrationInlineSourceInlineClusterInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SvmMigrationInlineSourceInlineSvm Source SVM
swagger:model svm_migration_inline_source_inline_svm
*/
type SvmMigrationInlineSourceInlineSvm struct {

	// links
	Links *models.SvmMigrationInlineSourceInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this svm migration inline source inline svm
func (o *SvmMigrationInlineSourceInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmMigrationInlineSourceInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "source" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm migration inline source inline svm based on the context it is used
func (o *SvmMigrationInlineSourceInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmMigrationInlineSourceInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "source" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SvmMigrationInlineSourceInlineSvm) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SvmMigrationInlineSourceInlineSvm) UnmarshalBinary(b []byte) error {
	var res SvmMigrationInlineSourceInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SvmMigrationInlineSourceInlineSvmInlineLinks svm migration inline source inline svm inline links
swagger:model svm_migration_inline_source_inline_svm_inline__links
*/
type SvmMigrationInlineSourceInlineSvmInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this svm migration inline source inline svm inline links
func (o *SvmMigrationInlineSourceInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmMigrationInlineSourceInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "source" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm migration inline source inline svm inline links based on the context it is used
func (o *SvmMigrationInlineSourceInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmMigrationInlineSourceInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "source" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SvmMigrationInlineSourceInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SvmMigrationInlineSourceInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res SvmMigrationInlineSourceInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SvmMigrationInlineTimeMetrics Various time metrics details
swagger:model svm_migration_inline_time_metrics
*/
type SvmMigrationInlineTimeMetrics struct {

	// Cutover end time
	// Example: 2020-12-02 19:30:19-08:00
	// Read Only: true
	// Format: date-time
	CutoverCompleteTime *strfmt.DateTime `json:"cutover_complete_time,omitempty"`

	// Cutover start time
	// Example: 2020-12-02 18:20:19-08:00
	// Read Only: true
	// Format: date-time
	CutoverStartTime *strfmt.DateTime `json:"cutover_start_time,omitempty"`

	// Cutover trigger time
	// Example: 2020-12-02 19:15:19-08:00
	// Read Only: true
	// Format: date-time
	CutoverTriggerTime *strfmt.DateTime `json:"cutover_trigger_time,omitempty"`

	// Migration end time
	// Example: 2020-12-02 19:36:19-08:00
	// Read Only: true
	// Format: date-time
	EndTime *strfmt.DateTime `json:"end_time,omitempty"`

	// Last migration pause time
	// Example: 2020-12-02 18:50:19-08:00
	// Read Only: true
	// Format: date-time
	LastPauseTime *strfmt.DateTime `json:"last_pause_time,omitempty"`

	// Last post point of no return retry time
	// Example: 2020-12-02 19:30:19-08:00
	// Read Only: true
	// Format: date-time
	LastPostPonrRetryTime *strfmt.DateTime `json:"last_post_ponr_retry_time,omitempty"`

	// Last migration resume time
	// Example: 2020-12-02 18:54:19-08:00
	// Read Only: true
	// Format: date-time
	LastResumeTime *strfmt.DateTime `json:"last_resume_time,omitempty"`

	// Migration start time
	// Example: 2020-12-02 18:36:19-08:00
	// Read Only: true
	// Format: date-time
	StartTime *strfmt.DateTime `json:"start_time,omitempty"`
}

// Validate validates this svm migration inline time metrics
func (o *SvmMigrationInlineTimeMetrics) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateCutoverCompleteTime(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateCutoverStartTime(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateCutoverTriggerTime(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateEndTime(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLastPauseTime(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLastPostPonrRetryTime(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLastResumeTime(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStartTime(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmMigrationInlineTimeMetrics) validateCutoverCompleteTime(formats strfmt.Registry) error {
	if swag.IsZero(o.CutoverCompleteTime) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"time_metrics"+"."+"cutover_complete_time", "body", "date-time", o.CutoverCompleteTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (o *SvmMigrationInlineTimeMetrics) validateCutoverStartTime(formats strfmt.Registry) error {
	if swag.IsZero(o.CutoverStartTime) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"time_metrics"+"."+"cutover_start_time", "body", "date-time", o.CutoverStartTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (o *SvmMigrationInlineTimeMetrics) validateCutoverTriggerTime(formats strfmt.Registry) error {
	if swag.IsZero(o.CutoverTriggerTime) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"time_metrics"+"."+"cutover_trigger_time", "body", "date-time", o.CutoverTriggerTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (o *SvmMigrationInlineTimeMetrics) validateEndTime(formats strfmt.Registry) error {
	if swag.IsZero(o.EndTime) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"time_metrics"+"."+"end_time", "body", "date-time", o.EndTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (o *SvmMigrationInlineTimeMetrics) validateLastPauseTime(formats strfmt.Registry) error {
	if swag.IsZero(o.LastPauseTime) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"time_metrics"+"."+"last_pause_time", "body", "date-time", o.LastPauseTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (o *SvmMigrationInlineTimeMetrics) validateLastPostPonrRetryTime(formats strfmt.Registry) error {
	if swag.IsZero(o.LastPostPonrRetryTime) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"time_metrics"+"."+"last_post_ponr_retry_time", "body", "date-time", o.LastPostPonrRetryTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (o *SvmMigrationInlineTimeMetrics) validateLastResumeTime(formats strfmt.Registry) error {
	if swag.IsZero(o.LastResumeTime) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"time_metrics"+"."+"last_resume_time", "body", "date-time", o.LastResumeTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (o *SvmMigrationInlineTimeMetrics) validateStartTime(formats strfmt.Registry) error {
	if swag.IsZero(o.StartTime) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"time_metrics"+"."+"start_time", "body", "date-time", o.StartTime.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this svm migration inline time metrics based on the context it is used
func (o *SvmMigrationInlineTimeMetrics) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateCutoverCompleteTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateCutoverStartTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateCutoverTriggerTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateEndTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLastPauseTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLastPostPonrRetryTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLastResumeTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStartTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmMigrationInlineTimeMetrics) contextValidateCutoverCompleteTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"time_metrics"+"."+"cutover_complete_time", "body", o.CutoverCompleteTime); err != nil {
		return err
	}

	return nil
}

func (o *SvmMigrationInlineTimeMetrics) contextValidateCutoverStartTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"time_metrics"+"."+"cutover_start_time", "body", o.CutoverStartTime); err != nil {
		return err
	}

	return nil
}

func (o *SvmMigrationInlineTimeMetrics) contextValidateCutoverTriggerTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"time_metrics"+"."+"cutover_trigger_time", "body", o.CutoverTriggerTime); err != nil {
		return err
	}

	return nil
}

func (o *SvmMigrationInlineTimeMetrics) contextValidateEndTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"time_metrics"+"."+"end_time", "body", o.EndTime); err != nil {
		return err
	}

	return nil
}

func (o *SvmMigrationInlineTimeMetrics) contextValidateLastPauseTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"time_metrics"+"."+"last_pause_time", "body", o.LastPauseTime); err != nil {
		return err
	}

	return nil
}

func (o *SvmMigrationInlineTimeMetrics) contextValidateLastPostPonrRetryTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"time_metrics"+"."+"last_post_ponr_retry_time", "body", o.LastPostPonrRetryTime); err != nil {
		return err
	}

	return nil
}

func (o *SvmMigrationInlineTimeMetrics) contextValidateLastResumeTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"time_metrics"+"."+"last_resume_time", "body", o.LastResumeTime); err != nil {
		return err
	}

	return nil
}

func (o *SvmMigrationInlineTimeMetrics) contextValidateStartTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"time_metrics"+"."+"start_time", "body", o.StartTime); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SvmMigrationInlineTimeMetrics) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SvmMigrationInlineTimeMetrics) UnmarshalBinary(b []byte) error {
	var res SvmMigrationInlineTimeMetrics
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
