// Code generated by go-swagger; DO NOT EDIT.

package svm

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SvmMigrationVolumeCollectionGetReader is a Reader for the SvmMigrationVolumeCollectionGet structure.
type SvmMigrationVolumeCollectionGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SvmMigrationVolumeCollectionGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSvmMigrationVolumeCollectionGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSvmMigrationVolumeCollectionGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSvmMigrationVolumeCollectionGetOK creates a SvmMigrationVolumeCollectionGetOK with default headers values
func NewSvmMigrationVolumeCollectionGetOK() *SvmMigrationVolumeCollectionGetOK {
	return &SvmMigrationVolumeCollectionGetOK{}
}

/*
SvmMigrationVolumeCollectionGetOK describes a response with status code 200, with default header values.

OK
*/
type SvmMigrationVolumeCollectionGetOK struct {
	Payload *models.SvmMigrationVolumeResponse
}

// IsSuccess returns true when this svm migration volume collection get o k response has a 2xx status code
func (o *SvmMigrationVolumeCollectionGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this svm migration volume collection get o k response has a 3xx status code
func (o *SvmMigrationVolumeCollectionGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this svm migration volume collection get o k response has a 4xx status code
func (o *SvmMigrationVolumeCollectionGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this svm migration volume collection get o k response has a 5xx status code
func (o *SvmMigrationVolumeCollectionGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this svm migration volume collection get o k response a status code equal to that given
func (o *SvmMigrationVolumeCollectionGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the svm migration volume collection get o k response
func (o *SvmMigrationVolumeCollectionGetOK) Code() int {
	return 200
}

func (o *SvmMigrationVolumeCollectionGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /svm/migrations/{svm_migration.uuid}/volumes][%d] svmMigrationVolumeCollectionGetOK %s", 200, payload)
}

func (o *SvmMigrationVolumeCollectionGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /svm/migrations/{svm_migration.uuid}/volumes][%d] svmMigrationVolumeCollectionGetOK %s", 200, payload)
}

func (o *SvmMigrationVolumeCollectionGetOK) GetPayload() *models.SvmMigrationVolumeResponse {
	return o.Payload
}

func (o *SvmMigrationVolumeCollectionGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SvmMigrationVolumeResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSvmMigrationVolumeCollectionGetDefault creates a SvmMigrationVolumeCollectionGetDefault with default headers values
func NewSvmMigrationVolumeCollectionGetDefault(code int) *SvmMigrationVolumeCollectionGetDefault {
	return &SvmMigrationVolumeCollectionGetDefault{
		_statusCode: code,
	}
}

/*
	SvmMigrationVolumeCollectionGetDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 13172783 | Migrate RDB lookup failed |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type SvmMigrationVolumeCollectionGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this svm migration volume collection get default response has a 2xx status code
func (o *SvmMigrationVolumeCollectionGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this svm migration volume collection get default response has a 3xx status code
func (o *SvmMigrationVolumeCollectionGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this svm migration volume collection get default response has a 4xx status code
func (o *SvmMigrationVolumeCollectionGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this svm migration volume collection get default response has a 5xx status code
func (o *SvmMigrationVolumeCollectionGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this svm migration volume collection get default response a status code equal to that given
func (o *SvmMigrationVolumeCollectionGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the svm migration volume collection get default response
func (o *SvmMigrationVolumeCollectionGetDefault) Code() int {
	return o._statusCode
}

func (o *SvmMigrationVolumeCollectionGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /svm/migrations/{svm_migration.uuid}/volumes][%d] svm_migration_volume_collection_get default %s", o._statusCode, payload)
}

func (o *SvmMigrationVolumeCollectionGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /svm/migrations/{svm_migration.uuid}/volumes][%d] svm_migration_volume_collection_get default %s", o._statusCode, payload)
}

func (o *SvmMigrationVolumeCollectionGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SvmMigrationVolumeCollectionGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
