// Code generated by go-swagger; DO NOT EDIT.

package svm

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewSvmMigrationVolumeGetParams creates a new SvmMigrationVolumeGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSvmMigrationVolumeGetParams() *SvmMigrationVolumeGetParams {
	return &SvmMigrationVolumeGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSvmMigrationVolumeGetParamsWithTimeout creates a new SvmMigrationVolumeGetParams object
// with the ability to set a timeout on a request.
func NewSvmMigrationVolumeGetParamsWithTimeout(timeout time.Duration) *SvmMigrationVolumeGetParams {
	return &SvmMigrationVolumeGetParams{
		timeout: timeout,
	}
}

// NewSvmMigrationVolumeGetParamsWithContext creates a new SvmMigrationVolumeGetParams object
// with the ability to set a context for a request.
func NewSvmMigrationVolumeGetParamsWithContext(ctx context.Context) *SvmMigrationVolumeGetParams {
	return &SvmMigrationVolumeGetParams{
		Context: ctx,
	}
}

// NewSvmMigrationVolumeGetParamsWithHTTPClient creates a new SvmMigrationVolumeGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewSvmMigrationVolumeGetParamsWithHTTPClient(client *http.Client) *SvmMigrationVolumeGetParams {
	return &SvmMigrationVolumeGetParams{
		HTTPClient: client,
	}
}

/*
SvmMigrationVolumeGetParams contains all the parameters to send to the API endpoint

	for the svm migration volume get operation.

	Typically these are written to a http.Request.
*/
type SvmMigrationVolumeGetParams struct {

	/* ErrorsCode.

	   Filter by errors.code
	*/
	ErrorsCode *string

	/* ErrorsMessage.

	   Filter by errors.message
	*/
	ErrorsMessage *string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* Healthy.

	   Filter by healthy
	*/
	Healthy *bool

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* NodeName.

	   Filter by node.name
	*/
	NodeName *string

	/* NodeUUID.

	   Filter by node.uuid
	*/
	NodeUUID *string

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	/* SvmMigrationUUID.

	   Migration UUID
	*/
	SvmMigrationUUID string

	/* TransferState.

	   Filter by transfer_state
	*/
	TransferState *string

	/* VolumeName.

	   Filter by volume.name
	*/
	VolumeName *string

	/* VolumeUUID.

	   Volume UUID
	*/
	VolumeUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the svm migration volume get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SvmMigrationVolumeGetParams) WithDefaults() *SvmMigrationVolumeGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the svm migration volume get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SvmMigrationVolumeGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := SvmMigrationVolumeGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the svm migration volume get params
func (o *SvmMigrationVolumeGetParams) WithTimeout(timeout time.Duration) *SvmMigrationVolumeGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the svm migration volume get params
func (o *SvmMigrationVolumeGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the svm migration volume get params
func (o *SvmMigrationVolumeGetParams) WithContext(ctx context.Context) *SvmMigrationVolumeGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the svm migration volume get params
func (o *SvmMigrationVolumeGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the svm migration volume get params
func (o *SvmMigrationVolumeGetParams) WithHTTPClient(client *http.Client) *SvmMigrationVolumeGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the svm migration volume get params
func (o *SvmMigrationVolumeGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithErrorsCode adds the errorsCode to the svm migration volume get params
func (o *SvmMigrationVolumeGetParams) WithErrorsCode(errorsCode *string) *SvmMigrationVolumeGetParams {
	o.SetErrorsCode(errorsCode)
	return o
}

// SetErrorsCode adds the errorsCode to the svm migration volume get params
func (o *SvmMigrationVolumeGetParams) SetErrorsCode(errorsCode *string) {
	o.ErrorsCode = errorsCode
}

// WithErrorsMessage adds the errorsMessage to the svm migration volume get params
func (o *SvmMigrationVolumeGetParams) WithErrorsMessage(errorsMessage *string) *SvmMigrationVolumeGetParams {
	o.SetErrorsMessage(errorsMessage)
	return o
}

// SetErrorsMessage adds the errorsMessage to the svm migration volume get params
func (o *SvmMigrationVolumeGetParams) SetErrorsMessage(errorsMessage *string) {
	o.ErrorsMessage = errorsMessage
}

// WithFields adds the fields to the svm migration volume get params
func (o *SvmMigrationVolumeGetParams) WithFields(fields []string) *SvmMigrationVolumeGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the svm migration volume get params
func (o *SvmMigrationVolumeGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithHealthy adds the healthy to the svm migration volume get params
func (o *SvmMigrationVolumeGetParams) WithHealthy(healthy *bool) *SvmMigrationVolumeGetParams {
	o.SetHealthy(healthy)
	return o
}

// SetHealthy adds the healthy to the svm migration volume get params
func (o *SvmMigrationVolumeGetParams) SetHealthy(healthy *bool) {
	o.Healthy = healthy
}

// WithMaxRecords adds the maxRecords to the svm migration volume get params
func (o *SvmMigrationVolumeGetParams) WithMaxRecords(maxRecords *int64) *SvmMigrationVolumeGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the svm migration volume get params
func (o *SvmMigrationVolumeGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithNodeName adds the nodeName to the svm migration volume get params
func (o *SvmMigrationVolumeGetParams) WithNodeName(nodeName *string) *SvmMigrationVolumeGetParams {
	o.SetNodeName(nodeName)
	return o
}

// SetNodeName adds the nodeName to the svm migration volume get params
func (o *SvmMigrationVolumeGetParams) SetNodeName(nodeName *string) {
	o.NodeName = nodeName
}

// WithNodeUUID adds the nodeUUID to the svm migration volume get params
func (o *SvmMigrationVolumeGetParams) WithNodeUUID(nodeUUID *string) *SvmMigrationVolumeGetParams {
	o.SetNodeUUID(nodeUUID)
	return o
}

// SetNodeUUID adds the nodeUuid to the svm migration volume get params
func (o *SvmMigrationVolumeGetParams) SetNodeUUID(nodeUUID *string) {
	o.NodeUUID = nodeUUID
}

// WithOrderBy adds the orderBy to the svm migration volume get params
func (o *SvmMigrationVolumeGetParams) WithOrderBy(orderBy []string) *SvmMigrationVolumeGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the svm migration volume get params
func (o *SvmMigrationVolumeGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithReturnRecords adds the returnRecords to the svm migration volume get params
func (o *SvmMigrationVolumeGetParams) WithReturnRecords(returnRecords *bool) *SvmMigrationVolumeGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the svm migration volume get params
func (o *SvmMigrationVolumeGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the svm migration volume get params
func (o *SvmMigrationVolumeGetParams) WithReturnTimeout(returnTimeout *int64) *SvmMigrationVolumeGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the svm migration volume get params
func (o *SvmMigrationVolumeGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSvmName adds the svmName to the svm migration volume get params
func (o *SvmMigrationVolumeGetParams) WithSvmName(svmName *string) *SvmMigrationVolumeGetParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the svm migration volume get params
func (o *SvmMigrationVolumeGetParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the svm migration volume get params
func (o *SvmMigrationVolumeGetParams) WithSvmUUID(svmUUID *string) *SvmMigrationVolumeGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the svm migration volume get params
func (o *SvmMigrationVolumeGetParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WithSvmMigrationUUID adds the svmMigrationUUID to the svm migration volume get params
func (o *SvmMigrationVolumeGetParams) WithSvmMigrationUUID(svmMigrationUUID string) *SvmMigrationVolumeGetParams {
	o.SetSvmMigrationUUID(svmMigrationUUID)
	return o
}

// SetSvmMigrationUUID adds the svmMigrationUuid to the svm migration volume get params
func (o *SvmMigrationVolumeGetParams) SetSvmMigrationUUID(svmMigrationUUID string) {
	o.SvmMigrationUUID = svmMigrationUUID
}

// WithTransferState adds the transferState to the svm migration volume get params
func (o *SvmMigrationVolumeGetParams) WithTransferState(transferState *string) *SvmMigrationVolumeGetParams {
	o.SetTransferState(transferState)
	return o
}

// SetTransferState adds the transferState to the svm migration volume get params
func (o *SvmMigrationVolumeGetParams) SetTransferState(transferState *string) {
	o.TransferState = transferState
}

// WithVolumeName adds the volumeName to the svm migration volume get params
func (o *SvmMigrationVolumeGetParams) WithVolumeName(volumeName *string) *SvmMigrationVolumeGetParams {
	o.SetVolumeName(volumeName)
	return o
}

// SetVolumeName adds the volumeName to the svm migration volume get params
func (o *SvmMigrationVolumeGetParams) SetVolumeName(volumeName *string) {
	o.VolumeName = volumeName
}

// WithVolumeUUID adds the volumeUUID to the svm migration volume get params
func (o *SvmMigrationVolumeGetParams) WithVolumeUUID(volumeUUID string) *SvmMigrationVolumeGetParams {
	o.SetVolumeUUID(volumeUUID)
	return o
}

// SetVolumeUUID adds the volumeUuid to the svm migration volume get params
func (o *SvmMigrationVolumeGetParams) SetVolumeUUID(volumeUUID string) {
	o.VolumeUUID = volumeUUID
}

// WriteToRequest writes these params to a swagger request
func (o *SvmMigrationVolumeGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ErrorsCode != nil {

		// query param errors.code
		var qrErrorsCode string

		if o.ErrorsCode != nil {
			qrErrorsCode = *o.ErrorsCode
		}
		qErrorsCode := qrErrorsCode
		if qErrorsCode != "" {

			if err := r.SetQueryParam("errors.code", qErrorsCode); err != nil {
				return err
			}
		}
	}

	if o.ErrorsMessage != nil {

		// query param errors.message
		var qrErrorsMessage string

		if o.ErrorsMessage != nil {
			qrErrorsMessage = *o.ErrorsMessage
		}
		qErrorsMessage := qrErrorsMessage
		if qErrorsMessage != "" {

			if err := r.SetQueryParam("errors.message", qErrorsMessage); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.Healthy != nil {

		// query param healthy
		var qrHealthy bool

		if o.Healthy != nil {
			qrHealthy = *o.Healthy
		}
		qHealthy := swag.FormatBool(qrHealthy)
		if qHealthy != "" {

			if err := r.SetQueryParam("healthy", qHealthy); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.NodeName != nil {

		// query param node.name
		var qrNodeName string

		if o.NodeName != nil {
			qrNodeName = *o.NodeName
		}
		qNodeName := qrNodeName
		if qNodeName != "" {

			if err := r.SetQueryParam("node.name", qNodeName); err != nil {
				return err
			}
		}
	}

	if o.NodeUUID != nil {

		// query param node.uuid
		var qrNodeUUID string

		if o.NodeUUID != nil {
			qrNodeUUID = *o.NodeUUID
		}
		qNodeUUID := qrNodeUUID
		if qNodeUUID != "" {

			if err := r.SetQueryParam("node.uuid", qNodeUUID); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	// path param svm_migration.uuid
	if err := r.SetPathParam("svm_migration.uuid", o.SvmMigrationUUID); err != nil {
		return err
	}

	if o.TransferState != nil {

		// query param transfer_state
		var qrTransferState string

		if o.TransferState != nil {
			qrTransferState = *o.TransferState
		}
		qTransferState := qrTransferState
		if qTransferState != "" {

			if err := r.SetQueryParam("transfer_state", qTransferState); err != nil {
				return err
			}
		}
	}

	if o.VolumeName != nil {

		// query param volume.name
		var qrVolumeName string

		if o.VolumeName != nil {
			qrVolumeName = *o.VolumeName
		}
		qVolumeName := qrVolumeName
		if qVolumeName != "" {

			if err := r.SetQueryParam("volume.name", qVolumeName); err != nil {
				return err
			}
		}
	}

	// path param volume.uuid
	if err := r.SetPathParam("volume.uuid", o.VolumeUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamSvmMigrationVolumeGet binds the parameter fields
func (o *SvmMigrationVolumeGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamSvmMigrationVolumeGet binds the parameter order_by
func (o *SvmMigrationVolumeGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
