// Code generated by go-swagger; DO NOT EDIT.

package svm

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SvmMigrationVolumeGetReader is a Reader for the SvmMigrationVolumeGet structure.
type SvmMigrationVolumeGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SvmMigrationVolumeGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSvmMigrationVolumeGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSvmMigrationVolumeGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSvmMigrationVolumeGetOK creates a SvmMigrationVolumeGetOK with default headers values
func NewSvmMigrationVolumeGetOK() *SvmMigrationVolumeGetOK {
	return &SvmMigrationVolumeGetOK{}
}

/*
SvmMigrationVolumeGetOK describes a response with status code 200, with default header values.

OK
*/
type SvmMigrationVolumeGetOK struct {
	Payload *models.SvmMigrationVolume
}

// IsSuccess returns true when this svm migration volume get o k response has a 2xx status code
func (o *SvmMigrationVolumeGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this svm migration volume get o k response has a 3xx status code
func (o *SvmMigrationVolumeGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this svm migration volume get o k response has a 4xx status code
func (o *SvmMigrationVolumeGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this svm migration volume get o k response has a 5xx status code
func (o *SvmMigrationVolumeGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this svm migration volume get o k response a status code equal to that given
func (o *SvmMigrationVolumeGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the svm migration volume get o k response
func (o *SvmMigrationVolumeGetOK) Code() int {
	return 200
}

func (o *SvmMigrationVolumeGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /svm/migrations/{svm_migration.uuid}/volumes/{volume.uuid}][%d] svmMigrationVolumeGetOK %s", 200, payload)
}

func (o *SvmMigrationVolumeGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /svm/migrations/{svm_migration.uuid}/volumes/{volume.uuid}][%d] svmMigrationVolumeGetOK %s", 200, payload)
}

func (o *SvmMigrationVolumeGetOK) GetPayload() *models.SvmMigrationVolume {
	return o.Payload
}

func (o *SvmMigrationVolumeGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SvmMigrationVolume)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSvmMigrationVolumeGetDefault creates a SvmMigrationVolumeGetDefault with default headers values
func NewSvmMigrationVolumeGetDefault(code int) *SvmMigrationVolumeGetDefault {
	return &SvmMigrationVolumeGetDefault{
		_statusCode: code,
	}
}

/*
	SvmMigrationVolumeGetDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 13172783 | Migrate RDB lookup failed |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type SvmMigrationVolumeGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this svm migration volume get default response has a 2xx status code
func (o *SvmMigrationVolumeGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this svm migration volume get default response has a 3xx status code
func (o *SvmMigrationVolumeGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this svm migration volume get default response has a 4xx status code
func (o *SvmMigrationVolumeGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this svm migration volume get default response has a 5xx status code
func (o *SvmMigrationVolumeGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this svm migration volume get default response a status code equal to that given
func (o *SvmMigrationVolumeGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the svm migration volume get default response
func (o *SvmMigrationVolumeGetDefault) Code() int {
	return o._statusCode
}

func (o *SvmMigrationVolumeGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /svm/migrations/{svm_migration.uuid}/volumes/{volume.uuid}][%d] svm_migration_volume_get default %s", o._statusCode, payload)
}

func (o *SvmMigrationVolumeGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /svm/migrations/{svm_migration.uuid}/volumes/{volume.uuid}][%d] svm_migration_volume_get default %s", o._statusCode, payload)
}

func (o *SvmMigrationVolumeGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SvmMigrationVolumeGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
