// Code generated by go-swagger; DO NOT EDIT.

package svm

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewSvmModifyCollectionParams creates a new SvmModifyCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSvmModifyCollectionParams() *SvmModifyCollectionParams {
	return &SvmModifyCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSvmModifyCollectionParamsWithTimeout creates a new SvmModifyCollectionParams object
// with the ability to set a timeout on a request.
func NewSvmModifyCollectionParamsWithTimeout(timeout time.Duration) *SvmModifyCollectionParams {
	return &SvmModifyCollectionParams{
		timeout: timeout,
	}
}

// NewSvmModifyCollectionParamsWithContext creates a new SvmModifyCollectionParams object
// with the ability to set a context for a request.
func NewSvmModifyCollectionParamsWithContext(ctx context.Context) *SvmModifyCollectionParams {
	return &SvmModifyCollectionParams{
		Context: ctx,
	}
}

// NewSvmModifyCollectionParamsWithHTTPClient creates a new SvmModifyCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewSvmModifyCollectionParamsWithHTTPClient(client *http.Client) *SvmModifyCollectionParams {
	return &SvmModifyCollectionParams{
		HTTPClient: client,
	}
}

/*
SvmModifyCollectionParams contains all the parameters to send to the API endpoint

	for the svm modify collection operation.

	Typically these are written to a http.Request.
*/
type SvmModifyCollectionParams struct {

	/* AggregatesName.

	   Filter by aggregates.name
	*/
	AggregatesName *string

	/* AggregatesUUID.

	   Filter by aggregates.uuid
	*/
	AggregatesUUID *string

	/* AntiRansomwareAutoSwitchDurationWithoutNewFileExtension.

	   Filter by anti_ransomware_auto_switch_duration_without_new_file_extension
	*/
	AntiRansomwareAutoSwitchDurationWithoutNewFileExtension *int64

	/* AntiRansomwareAutoSwitchFromLearningToEnabled.

	   Filter by anti_ransomware_auto_switch_from_learning_to_enabled
	*/
	AntiRansomwareAutoSwitchFromLearningToEnabled *bool

	/* AntiRansomwareAutoSwitchMinimumFileCount.

	   Filter by anti_ransomware_auto_switch_minimum_file_count
	*/
	AntiRansomwareAutoSwitchMinimumFileCount *int64

	/* AntiRansomwareAutoSwitchMinimumFileExtension.

	   Filter by anti_ransomware_auto_switch_minimum_file_extension
	*/
	AntiRansomwareAutoSwitchMinimumFileExtension *int64

	/* AntiRansomwareAutoSwitchMinimumIncomingData.

	   Filter by anti_ransomware_auto_switch_minimum_incoming_data
	*/
	AntiRansomwareAutoSwitchMinimumIncomingData *string

	/* AntiRansomwareAutoSwitchMinimumIncomingDataPercent.

	   Filter by anti_ransomware_auto_switch_minimum_incoming_data_percent
	*/
	AntiRansomwareAutoSwitchMinimumIncomingDataPercent *int64

	/* AntiRansomwareAutoSwitchMinimumLearningPeriod.

	   Filter by anti_ransomware_auto_switch_minimum_learning_period
	*/
	AntiRansomwareAutoSwitchMinimumLearningPeriod *int64

	/* AntiRansomwareDefaultVolumeState.

	   Filter by anti_ransomware_default_volume_state
	*/
	AntiRansomwareDefaultVolumeState *string

	/* AutoEnableActivityTracking.

	   Filter by auto_enable_activity_tracking.
	*/
	AutoEnableActivityTracking *bool

	/* AutoEnableAnalytics.

	   Filter by auto_enable_analytics.
	*/
	AutoEnableAnalytics *bool

	/* CertificateUUID.

	   Filter by certificate.uuid
	*/
	CertificateUUID *string

	/* CifsAdDomainFqdn.

	   Filter by cifs.ad_domain.fqdn
	*/
	CifsAdDomainFqdn *string

	/* CifsAdDomainOrganizationalUnit.

	   Filter by cifs.ad_domain.organizational_unit
	*/
	CifsAdDomainOrganizationalUnit *string

	/* CifsAllowed.

	   Filter by cifs.allowed
	*/
	CifsAllowed *bool

	/* CifsEnabled.

	   Filter by cifs.enabled
	*/
	CifsEnabled *bool

	/* CifsName.

	   Filter by cifs.name
	*/
	CifsName *string

	/* Comment.

	   Filter by comment
	*/
	Comment *string

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* DNSDomains.

	   Filter by dns.domains
	*/
	DNSDomains *string

	/* DNSServers.

	   Filter by dns.servers
	*/
	DNSServers *string

	/* FcInterfacesDataProtocol.

	   Filter by fc_interfaces.data_protocol
	*/
	FcInterfacesDataProtocol *string

	/* FcInterfacesName.

	   Filter by fc_interfaces.name
	*/
	FcInterfacesName *string

	/* FcpAllowed.

	   Filter by fcp.allowed
	*/
	FcpAllowed *bool

	/* FcpEnabled.

	   Filter by fcp.enabled
	*/
	FcpEnabled *bool

	/* Info.

	   Info specification
	*/
	Info SvmModifyCollectionBody

	/* IpspaceName.

	   Filter by ipspace.name
	*/
	IpspaceName *string

	/* IpspaceUUID.

	   Filter by ipspace.uuid
	*/
	IpspaceUUID *string

	/* IscsiAllowed.

	   Filter by iscsi.allowed
	*/
	IscsiAllowed *bool

	/* IscsiEnabled.

	   Filter by iscsi.enabled
	*/
	IscsiEnabled *bool

	/* Language.

	   Filter by language
	*/
	Language *string

	/* LdapAdDomain.

	   Filter by ldap.ad_domain
	*/
	LdapAdDomain *string

	/* LdapBaseDn.

	   Filter by ldap.base_dn
	*/
	LdapBaseDn *string

	/* LdapBindDn.

	   Filter by ldap.bind_dn
	*/
	LdapBindDn *string

	/* LdapEnabled.

	   Filter by ldap.enabled
	*/
	LdapEnabled *bool

	/* LdapServers.

	   Filter by ldap.servers
	*/
	LdapServers *string

	/* MaxVolumes.

	   Filter max_volumes
	*/
	MaxVolumes *string

	/* Name.

	   Filter by name
	*/
	Name *string

	/* NdmpAllowed.

	   Filter by ndmp.allowed
	*/
	NdmpAllowed *bool

	/* NfsAllowed.

	   Filter by nfs.allowed
	*/
	NfsAllowed *bool

	/* NfsEnabled.

	   Filter by nfs.enabled
	*/
	NfsEnabled *bool

	/* NisDomain.

	   Filter by nis.domain
	*/
	NisDomain *string

	/* NisEnabled.

	   Filter by nis.enabled
	*/
	NisEnabled *bool

	/* NisServers.

	   Filter by nis.servers
	*/
	NisServers *string

	/* NsswitchGroup.

	   Filter by nsswitch.group
	*/
	NsswitchGroup *string

	/* NsswitchHosts.

	   Filter by nsswitch.hosts
	*/
	NsswitchHosts *string

	/* NsswitchNamemap.

	   Filter by nsswitch.namemap
	*/
	NsswitchNamemap *string

	/* NsswitchNetgroup.

	   Filter by nsswitch.netgroup
	*/
	NsswitchNetgroup *string

	/* NsswitchPasswd.

	   Filter by nsswitch.passwd
	*/
	NsswitchPasswd *string

	/* NumberOfVolumesInRecoveryQueue.

	   Filter by number_of_volumes_in_recovery_queue
	*/
	NumberOfVolumesInRecoveryQueue *int64

	/* NvmeAllowed.

	   Filter by nvme.allowed
	*/
	NvmeAllowed *bool

	/* NvmeEnabled.

	   Filter by nvme.enabled
	*/
	NvmeEnabled *bool

	/* QosAdaptivePolicyGroupTemplateName.

	   Filter by qos_adaptive_policy_group_template.name
	*/
	QosAdaptivePolicyGroupTemplateName *string

	/* QosAdaptivePolicyGroupTemplateUUID.

	   Filter by qos_adaptive_policy_group_template.uuid
	*/
	QosAdaptivePolicyGroupTemplateUUID *string

	/* QosPolicyName.

	   Filter qos_policy.name
	*/
	QosPolicyName *string

	/* QosPolicyUUID.

	   Filter qos_policy.uuid
	*/
	QosPolicyUUID *string

	/* QosPolicyGroupTemplateName.

	   Filter by qos_policy_group_template.name
	*/
	QosPolicyGroupTemplateName *string

	/* QosPolicyGroupTemplateUUID.

	   Filter by qos_policy_group_template.uuid
	*/
	QosPolicyGroupTemplateUUID *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* S3Allowed.

	   Filter by s3.allowed
	*/
	S3Allowed *bool

	/* S3CertificateName.

	   Filter by s3.certificate.name
	*/
	S3CertificateName *string

	/* S3CertificateUUID.

	   Filter by s3.certificate.uuid
	*/
	S3CertificateUUID *string

	/* S3Enabled.

	   Filter by s3.enabled
	*/
	S3Enabled *bool

	/* S3IsHTTPEnabled.

	   Filter by s3.is_http_enabled
	*/
	S3IsHTTPEnabled *bool

	/* S3IsHTTPSEnabled.

	   Filter by s3.is_https_enabled
	*/
	S3IsHTTPSEnabled *bool

	/* S3Name.

	   Filter by s3.name
	*/
	S3Name *string

	/* S3Port.

	   Filter by s3.port
	*/
	S3Port *int64

	/* S3SecurePort.

	   Filter by s3.secure_port
	*/
	S3SecurePort *int64

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* SnapshotAutodeleteEnabled.

	   Filter by snapshot_autodelete_enabled
	*/
	SnapshotAutodeleteEnabled *bool

	/* SnapshotPolicyName.

	   Filter by snapshot_policy.name
	*/
	SnapshotPolicyName *string

	/* SnapshotPolicyUUID.

	   Filter by snapshot_policy.uuid
	*/
	SnapshotPolicyUUID *string

	/* SnapshotReservePercent.

	   Filter by snapshot_reserve_percent
	*/
	SnapshotReservePercent *int64

	/* State.

	   Filter by state
	*/
	State *string

	/* StorageAllocated.

	   Filter by storage_allocated
	*/
	StorageAllocated *int64

	/* StorageAvailable.

	   Filter by storage_available
	*/
	StorageAvailable *int64

	/* StorageLimit.

	   Filter by storage.limit
	*/
	StorageLimit *int64

	/* StorageLimitThresholdAlert.

	   Filter by storage.limit_threshold_alert
	*/
	StorageLimitThresholdAlert *int64

	/* StorageLimitThresholdExceeded.

	   Filter by storage.limit_threshold_exceeded
	*/
	StorageLimitThresholdExceeded *int64

	/* StorageUsedPercentage.

	   Filter by storage_used_percentage
	*/
	StorageUsedPercentage *int64

	/* Subtype.

	   Filter by subtype
	*/
	Subtype *string

	/* TotalVolumeSizeInRecoveryQueue.

	   Filter by total_volume_size_in_recovery_queue
	*/
	TotalVolumeSizeInRecoveryQueue *int64

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the svm modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SvmModifyCollectionParams) WithDefaults() *SvmModifyCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the svm modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SvmModifyCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := SvmModifyCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the svm modify collection params
func (o *SvmModifyCollectionParams) WithTimeout(timeout time.Duration) *SvmModifyCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the svm modify collection params
func (o *SvmModifyCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the svm modify collection params
func (o *SvmModifyCollectionParams) WithContext(ctx context.Context) *SvmModifyCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the svm modify collection params
func (o *SvmModifyCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the svm modify collection params
func (o *SvmModifyCollectionParams) WithHTTPClient(client *http.Client) *SvmModifyCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the svm modify collection params
func (o *SvmModifyCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAggregatesName adds the aggregatesName to the svm modify collection params
func (o *SvmModifyCollectionParams) WithAggregatesName(aggregatesName *string) *SvmModifyCollectionParams {
	o.SetAggregatesName(aggregatesName)
	return o
}

// SetAggregatesName adds the aggregatesName to the svm modify collection params
func (o *SvmModifyCollectionParams) SetAggregatesName(aggregatesName *string) {
	o.AggregatesName = aggregatesName
}

// WithAggregatesUUID adds the aggregatesUUID to the svm modify collection params
func (o *SvmModifyCollectionParams) WithAggregatesUUID(aggregatesUUID *string) *SvmModifyCollectionParams {
	o.SetAggregatesUUID(aggregatesUUID)
	return o
}

// SetAggregatesUUID adds the aggregatesUuid to the svm modify collection params
func (o *SvmModifyCollectionParams) SetAggregatesUUID(aggregatesUUID *string) {
	o.AggregatesUUID = aggregatesUUID
}

// WithAntiRansomwareAutoSwitchDurationWithoutNewFileExtension adds the antiRansomwareAutoSwitchDurationWithoutNewFileExtension to the svm modify collection params
func (o *SvmModifyCollectionParams) WithAntiRansomwareAutoSwitchDurationWithoutNewFileExtension(antiRansomwareAutoSwitchDurationWithoutNewFileExtension *int64) *SvmModifyCollectionParams {
	o.SetAntiRansomwareAutoSwitchDurationWithoutNewFileExtension(antiRansomwareAutoSwitchDurationWithoutNewFileExtension)
	return o
}

// SetAntiRansomwareAutoSwitchDurationWithoutNewFileExtension adds the antiRansomwareAutoSwitchDurationWithoutNewFileExtension to the svm modify collection params
func (o *SvmModifyCollectionParams) SetAntiRansomwareAutoSwitchDurationWithoutNewFileExtension(antiRansomwareAutoSwitchDurationWithoutNewFileExtension *int64) {
	o.AntiRansomwareAutoSwitchDurationWithoutNewFileExtension = antiRansomwareAutoSwitchDurationWithoutNewFileExtension
}

// WithAntiRansomwareAutoSwitchFromLearningToEnabled adds the antiRansomwareAutoSwitchFromLearningToEnabled to the svm modify collection params
func (o *SvmModifyCollectionParams) WithAntiRansomwareAutoSwitchFromLearningToEnabled(antiRansomwareAutoSwitchFromLearningToEnabled *bool) *SvmModifyCollectionParams {
	o.SetAntiRansomwareAutoSwitchFromLearningToEnabled(antiRansomwareAutoSwitchFromLearningToEnabled)
	return o
}

// SetAntiRansomwareAutoSwitchFromLearningToEnabled adds the antiRansomwareAutoSwitchFromLearningToEnabled to the svm modify collection params
func (o *SvmModifyCollectionParams) SetAntiRansomwareAutoSwitchFromLearningToEnabled(antiRansomwareAutoSwitchFromLearningToEnabled *bool) {
	o.AntiRansomwareAutoSwitchFromLearningToEnabled = antiRansomwareAutoSwitchFromLearningToEnabled
}

// WithAntiRansomwareAutoSwitchMinimumFileCount adds the antiRansomwareAutoSwitchMinimumFileCount to the svm modify collection params
func (o *SvmModifyCollectionParams) WithAntiRansomwareAutoSwitchMinimumFileCount(antiRansomwareAutoSwitchMinimumFileCount *int64) *SvmModifyCollectionParams {
	o.SetAntiRansomwareAutoSwitchMinimumFileCount(antiRansomwareAutoSwitchMinimumFileCount)
	return o
}

// SetAntiRansomwareAutoSwitchMinimumFileCount adds the antiRansomwareAutoSwitchMinimumFileCount to the svm modify collection params
func (o *SvmModifyCollectionParams) SetAntiRansomwareAutoSwitchMinimumFileCount(antiRansomwareAutoSwitchMinimumFileCount *int64) {
	o.AntiRansomwareAutoSwitchMinimumFileCount = antiRansomwareAutoSwitchMinimumFileCount
}

// WithAntiRansomwareAutoSwitchMinimumFileExtension adds the antiRansomwareAutoSwitchMinimumFileExtension to the svm modify collection params
func (o *SvmModifyCollectionParams) WithAntiRansomwareAutoSwitchMinimumFileExtension(antiRansomwareAutoSwitchMinimumFileExtension *int64) *SvmModifyCollectionParams {
	o.SetAntiRansomwareAutoSwitchMinimumFileExtension(antiRansomwareAutoSwitchMinimumFileExtension)
	return o
}

// SetAntiRansomwareAutoSwitchMinimumFileExtension adds the antiRansomwareAutoSwitchMinimumFileExtension to the svm modify collection params
func (o *SvmModifyCollectionParams) SetAntiRansomwareAutoSwitchMinimumFileExtension(antiRansomwareAutoSwitchMinimumFileExtension *int64) {
	o.AntiRansomwareAutoSwitchMinimumFileExtension = antiRansomwareAutoSwitchMinimumFileExtension
}

// WithAntiRansomwareAutoSwitchMinimumIncomingData adds the antiRansomwareAutoSwitchMinimumIncomingData to the svm modify collection params
func (o *SvmModifyCollectionParams) WithAntiRansomwareAutoSwitchMinimumIncomingData(antiRansomwareAutoSwitchMinimumIncomingData *string) *SvmModifyCollectionParams {
	o.SetAntiRansomwareAutoSwitchMinimumIncomingData(antiRansomwareAutoSwitchMinimumIncomingData)
	return o
}

// SetAntiRansomwareAutoSwitchMinimumIncomingData adds the antiRansomwareAutoSwitchMinimumIncomingData to the svm modify collection params
func (o *SvmModifyCollectionParams) SetAntiRansomwareAutoSwitchMinimumIncomingData(antiRansomwareAutoSwitchMinimumIncomingData *string) {
	o.AntiRansomwareAutoSwitchMinimumIncomingData = antiRansomwareAutoSwitchMinimumIncomingData
}

// WithAntiRansomwareAutoSwitchMinimumIncomingDataPercent adds the antiRansomwareAutoSwitchMinimumIncomingDataPercent to the svm modify collection params
func (o *SvmModifyCollectionParams) WithAntiRansomwareAutoSwitchMinimumIncomingDataPercent(antiRansomwareAutoSwitchMinimumIncomingDataPercent *int64) *SvmModifyCollectionParams {
	o.SetAntiRansomwareAutoSwitchMinimumIncomingDataPercent(antiRansomwareAutoSwitchMinimumIncomingDataPercent)
	return o
}

// SetAntiRansomwareAutoSwitchMinimumIncomingDataPercent adds the antiRansomwareAutoSwitchMinimumIncomingDataPercent to the svm modify collection params
func (o *SvmModifyCollectionParams) SetAntiRansomwareAutoSwitchMinimumIncomingDataPercent(antiRansomwareAutoSwitchMinimumIncomingDataPercent *int64) {
	o.AntiRansomwareAutoSwitchMinimumIncomingDataPercent = antiRansomwareAutoSwitchMinimumIncomingDataPercent
}

// WithAntiRansomwareAutoSwitchMinimumLearningPeriod adds the antiRansomwareAutoSwitchMinimumLearningPeriod to the svm modify collection params
func (o *SvmModifyCollectionParams) WithAntiRansomwareAutoSwitchMinimumLearningPeriod(antiRansomwareAutoSwitchMinimumLearningPeriod *int64) *SvmModifyCollectionParams {
	o.SetAntiRansomwareAutoSwitchMinimumLearningPeriod(antiRansomwareAutoSwitchMinimumLearningPeriod)
	return o
}

// SetAntiRansomwareAutoSwitchMinimumLearningPeriod adds the antiRansomwareAutoSwitchMinimumLearningPeriod to the svm modify collection params
func (o *SvmModifyCollectionParams) SetAntiRansomwareAutoSwitchMinimumLearningPeriod(antiRansomwareAutoSwitchMinimumLearningPeriod *int64) {
	o.AntiRansomwareAutoSwitchMinimumLearningPeriod = antiRansomwareAutoSwitchMinimumLearningPeriod
}

// WithAntiRansomwareDefaultVolumeState adds the antiRansomwareDefaultVolumeState to the svm modify collection params
func (o *SvmModifyCollectionParams) WithAntiRansomwareDefaultVolumeState(antiRansomwareDefaultVolumeState *string) *SvmModifyCollectionParams {
	o.SetAntiRansomwareDefaultVolumeState(antiRansomwareDefaultVolumeState)
	return o
}

// SetAntiRansomwareDefaultVolumeState adds the antiRansomwareDefaultVolumeState to the svm modify collection params
func (o *SvmModifyCollectionParams) SetAntiRansomwareDefaultVolumeState(antiRansomwareDefaultVolumeState *string) {
	o.AntiRansomwareDefaultVolumeState = antiRansomwareDefaultVolumeState
}

// WithAutoEnableActivityTracking adds the autoEnableActivityTracking to the svm modify collection params
func (o *SvmModifyCollectionParams) WithAutoEnableActivityTracking(autoEnableActivityTracking *bool) *SvmModifyCollectionParams {
	o.SetAutoEnableActivityTracking(autoEnableActivityTracking)
	return o
}

// SetAutoEnableActivityTracking adds the autoEnableActivityTracking to the svm modify collection params
func (o *SvmModifyCollectionParams) SetAutoEnableActivityTracking(autoEnableActivityTracking *bool) {
	o.AutoEnableActivityTracking = autoEnableActivityTracking
}

// WithAutoEnableAnalytics adds the autoEnableAnalytics to the svm modify collection params
func (o *SvmModifyCollectionParams) WithAutoEnableAnalytics(autoEnableAnalytics *bool) *SvmModifyCollectionParams {
	o.SetAutoEnableAnalytics(autoEnableAnalytics)
	return o
}

// SetAutoEnableAnalytics adds the autoEnableAnalytics to the svm modify collection params
func (o *SvmModifyCollectionParams) SetAutoEnableAnalytics(autoEnableAnalytics *bool) {
	o.AutoEnableAnalytics = autoEnableAnalytics
}

// WithCertificateUUID adds the certificateUUID to the svm modify collection params
func (o *SvmModifyCollectionParams) WithCertificateUUID(certificateUUID *string) *SvmModifyCollectionParams {
	o.SetCertificateUUID(certificateUUID)
	return o
}

// SetCertificateUUID adds the certificateUuid to the svm modify collection params
func (o *SvmModifyCollectionParams) SetCertificateUUID(certificateUUID *string) {
	o.CertificateUUID = certificateUUID
}

// WithCifsAdDomainFqdn adds the cifsAdDomainFqdn to the svm modify collection params
func (o *SvmModifyCollectionParams) WithCifsAdDomainFqdn(cifsAdDomainFqdn *string) *SvmModifyCollectionParams {
	o.SetCifsAdDomainFqdn(cifsAdDomainFqdn)
	return o
}

// SetCifsAdDomainFqdn adds the cifsAdDomainFqdn to the svm modify collection params
func (o *SvmModifyCollectionParams) SetCifsAdDomainFqdn(cifsAdDomainFqdn *string) {
	o.CifsAdDomainFqdn = cifsAdDomainFqdn
}

// WithCifsAdDomainOrganizationalUnit adds the cifsAdDomainOrganizationalUnit to the svm modify collection params
func (o *SvmModifyCollectionParams) WithCifsAdDomainOrganizationalUnit(cifsAdDomainOrganizationalUnit *string) *SvmModifyCollectionParams {
	o.SetCifsAdDomainOrganizationalUnit(cifsAdDomainOrganizationalUnit)
	return o
}

// SetCifsAdDomainOrganizationalUnit adds the cifsAdDomainOrganizationalUnit to the svm modify collection params
func (o *SvmModifyCollectionParams) SetCifsAdDomainOrganizationalUnit(cifsAdDomainOrganizationalUnit *string) {
	o.CifsAdDomainOrganizationalUnit = cifsAdDomainOrganizationalUnit
}

// WithCifsAllowed adds the cifsAllowed to the svm modify collection params
func (o *SvmModifyCollectionParams) WithCifsAllowed(cifsAllowed *bool) *SvmModifyCollectionParams {
	o.SetCifsAllowed(cifsAllowed)
	return o
}

// SetCifsAllowed adds the cifsAllowed to the svm modify collection params
func (o *SvmModifyCollectionParams) SetCifsAllowed(cifsAllowed *bool) {
	o.CifsAllowed = cifsAllowed
}

// WithCifsEnabled adds the cifsEnabled to the svm modify collection params
func (o *SvmModifyCollectionParams) WithCifsEnabled(cifsEnabled *bool) *SvmModifyCollectionParams {
	o.SetCifsEnabled(cifsEnabled)
	return o
}

// SetCifsEnabled adds the cifsEnabled to the svm modify collection params
func (o *SvmModifyCollectionParams) SetCifsEnabled(cifsEnabled *bool) {
	o.CifsEnabled = cifsEnabled
}

// WithCifsName adds the cifsName to the svm modify collection params
func (o *SvmModifyCollectionParams) WithCifsName(cifsName *string) *SvmModifyCollectionParams {
	o.SetCifsName(cifsName)
	return o
}

// SetCifsName adds the cifsName to the svm modify collection params
func (o *SvmModifyCollectionParams) SetCifsName(cifsName *string) {
	o.CifsName = cifsName
}

// WithComment adds the comment to the svm modify collection params
func (o *SvmModifyCollectionParams) WithComment(comment *string) *SvmModifyCollectionParams {
	o.SetComment(comment)
	return o
}

// SetComment adds the comment to the svm modify collection params
func (o *SvmModifyCollectionParams) SetComment(comment *string) {
	o.Comment = comment
}

// WithContinueOnFailure adds the continueOnFailure to the svm modify collection params
func (o *SvmModifyCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *SvmModifyCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the svm modify collection params
func (o *SvmModifyCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithDNSDomains adds the dNSDomains to the svm modify collection params
func (o *SvmModifyCollectionParams) WithDNSDomains(dNSDomains *string) *SvmModifyCollectionParams {
	o.SetDNSDomains(dNSDomains)
	return o
}

// SetDNSDomains adds the dnsDomains to the svm modify collection params
func (o *SvmModifyCollectionParams) SetDNSDomains(dNSDomains *string) {
	o.DNSDomains = dNSDomains
}

// WithDNSServers adds the dNSServers to the svm modify collection params
func (o *SvmModifyCollectionParams) WithDNSServers(dNSServers *string) *SvmModifyCollectionParams {
	o.SetDNSServers(dNSServers)
	return o
}

// SetDNSServers adds the dnsServers to the svm modify collection params
func (o *SvmModifyCollectionParams) SetDNSServers(dNSServers *string) {
	o.DNSServers = dNSServers
}

// WithFcInterfacesDataProtocol adds the fcInterfacesDataProtocol to the svm modify collection params
func (o *SvmModifyCollectionParams) WithFcInterfacesDataProtocol(fcInterfacesDataProtocol *string) *SvmModifyCollectionParams {
	o.SetFcInterfacesDataProtocol(fcInterfacesDataProtocol)
	return o
}

// SetFcInterfacesDataProtocol adds the fcInterfacesDataProtocol to the svm modify collection params
func (o *SvmModifyCollectionParams) SetFcInterfacesDataProtocol(fcInterfacesDataProtocol *string) {
	o.FcInterfacesDataProtocol = fcInterfacesDataProtocol
}

// WithFcInterfacesName adds the fcInterfacesName to the svm modify collection params
func (o *SvmModifyCollectionParams) WithFcInterfacesName(fcInterfacesName *string) *SvmModifyCollectionParams {
	o.SetFcInterfacesName(fcInterfacesName)
	return o
}

// SetFcInterfacesName adds the fcInterfacesName to the svm modify collection params
func (o *SvmModifyCollectionParams) SetFcInterfacesName(fcInterfacesName *string) {
	o.FcInterfacesName = fcInterfacesName
}

// WithFcpAllowed adds the fcpAllowed to the svm modify collection params
func (o *SvmModifyCollectionParams) WithFcpAllowed(fcpAllowed *bool) *SvmModifyCollectionParams {
	o.SetFcpAllowed(fcpAllowed)
	return o
}

// SetFcpAllowed adds the fcpAllowed to the svm modify collection params
func (o *SvmModifyCollectionParams) SetFcpAllowed(fcpAllowed *bool) {
	o.FcpAllowed = fcpAllowed
}

// WithFcpEnabled adds the fcpEnabled to the svm modify collection params
func (o *SvmModifyCollectionParams) WithFcpEnabled(fcpEnabled *bool) *SvmModifyCollectionParams {
	o.SetFcpEnabled(fcpEnabled)
	return o
}

// SetFcpEnabled adds the fcpEnabled to the svm modify collection params
func (o *SvmModifyCollectionParams) SetFcpEnabled(fcpEnabled *bool) {
	o.FcpEnabled = fcpEnabled
}

// WithInfo adds the info to the svm modify collection params
func (o *SvmModifyCollectionParams) WithInfo(info SvmModifyCollectionBody) *SvmModifyCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the svm modify collection params
func (o *SvmModifyCollectionParams) SetInfo(info SvmModifyCollectionBody) {
	o.Info = info
}

// WithIpspaceName adds the ipspaceName to the svm modify collection params
func (o *SvmModifyCollectionParams) WithIpspaceName(ipspaceName *string) *SvmModifyCollectionParams {
	o.SetIpspaceName(ipspaceName)
	return o
}

// SetIpspaceName adds the ipspaceName to the svm modify collection params
func (o *SvmModifyCollectionParams) SetIpspaceName(ipspaceName *string) {
	o.IpspaceName = ipspaceName
}

// WithIpspaceUUID adds the ipspaceUUID to the svm modify collection params
func (o *SvmModifyCollectionParams) WithIpspaceUUID(ipspaceUUID *string) *SvmModifyCollectionParams {
	o.SetIpspaceUUID(ipspaceUUID)
	return o
}

// SetIpspaceUUID adds the ipspaceUuid to the svm modify collection params
func (o *SvmModifyCollectionParams) SetIpspaceUUID(ipspaceUUID *string) {
	o.IpspaceUUID = ipspaceUUID
}

// WithIscsiAllowed adds the iscsiAllowed to the svm modify collection params
func (o *SvmModifyCollectionParams) WithIscsiAllowed(iscsiAllowed *bool) *SvmModifyCollectionParams {
	o.SetIscsiAllowed(iscsiAllowed)
	return o
}

// SetIscsiAllowed adds the iscsiAllowed to the svm modify collection params
func (o *SvmModifyCollectionParams) SetIscsiAllowed(iscsiAllowed *bool) {
	o.IscsiAllowed = iscsiAllowed
}

// WithIscsiEnabled adds the iscsiEnabled to the svm modify collection params
func (o *SvmModifyCollectionParams) WithIscsiEnabled(iscsiEnabled *bool) *SvmModifyCollectionParams {
	o.SetIscsiEnabled(iscsiEnabled)
	return o
}

// SetIscsiEnabled adds the iscsiEnabled to the svm modify collection params
func (o *SvmModifyCollectionParams) SetIscsiEnabled(iscsiEnabled *bool) {
	o.IscsiEnabled = iscsiEnabled
}

// WithLanguage adds the language to the svm modify collection params
func (o *SvmModifyCollectionParams) WithLanguage(language *string) *SvmModifyCollectionParams {
	o.SetLanguage(language)
	return o
}

// SetLanguage adds the language to the svm modify collection params
func (o *SvmModifyCollectionParams) SetLanguage(language *string) {
	o.Language = language
}

// WithLdapAdDomain adds the ldapAdDomain to the svm modify collection params
func (o *SvmModifyCollectionParams) WithLdapAdDomain(ldapAdDomain *string) *SvmModifyCollectionParams {
	o.SetLdapAdDomain(ldapAdDomain)
	return o
}

// SetLdapAdDomain adds the ldapAdDomain to the svm modify collection params
func (o *SvmModifyCollectionParams) SetLdapAdDomain(ldapAdDomain *string) {
	o.LdapAdDomain = ldapAdDomain
}

// WithLdapBaseDn adds the ldapBaseDn to the svm modify collection params
func (o *SvmModifyCollectionParams) WithLdapBaseDn(ldapBaseDn *string) *SvmModifyCollectionParams {
	o.SetLdapBaseDn(ldapBaseDn)
	return o
}

// SetLdapBaseDn adds the ldapBaseDn to the svm modify collection params
func (o *SvmModifyCollectionParams) SetLdapBaseDn(ldapBaseDn *string) {
	o.LdapBaseDn = ldapBaseDn
}

// WithLdapBindDn adds the ldapBindDn to the svm modify collection params
func (o *SvmModifyCollectionParams) WithLdapBindDn(ldapBindDn *string) *SvmModifyCollectionParams {
	o.SetLdapBindDn(ldapBindDn)
	return o
}

// SetLdapBindDn adds the ldapBindDn to the svm modify collection params
func (o *SvmModifyCollectionParams) SetLdapBindDn(ldapBindDn *string) {
	o.LdapBindDn = ldapBindDn
}

// WithLdapEnabled adds the ldapEnabled to the svm modify collection params
func (o *SvmModifyCollectionParams) WithLdapEnabled(ldapEnabled *bool) *SvmModifyCollectionParams {
	o.SetLdapEnabled(ldapEnabled)
	return o
}

// SetLdapEnabled adds the ldapEnabled to the svm modify collection params
func (o *SvmModifyCollectionParams) SetLdapEnabled(ldapEnabled *bool) {
	o.LdapEnabled = ldapEnabled
}

// WithLdapServers adds the ldapServers to the svm modify collection params
func (o *SvmModifyCollectionParams) WithLdapServers(ldapServers *string) *SvmModifyCollectionParams {
	o.SetLdapServers(ldapServers)
	return o
}

// SetLdapServers adds the ldapServers to the svm modify collection params
func (o *SvmModifyCollectionParams) SetLdapServers(ldapServers *string) {
	o.LdapServers = ldapServers
}

// WithMaxVolumes adds the maxVolumes to the svm modify collection params
func (o *SvmModifyCollectionParams) WithMaxVolumes(maxVolumes *string) *SvmModifyCollectionParams {
	o.SetMaxVolumes(maxVolumes)
	return o
}

// SetMaxVolumes adds the maxVolumes to the svm modify collection params
func (o *SvmModifyCollectionParams) SetMaxVolumes(maxVolumes *string) {
	o.MaxVolumes = maxVolumes
}

// WithName adds the name to the svm modify collection params
func (o *SvmModifyCollectionParams) WithName(name *string) *SvmModifyCollectionParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the svm modify collection params
func (o *SvmModifyCollectionParams) SetName(name *string) {
	o.Name = name
}

// WithNdmpAllowed adds the ndmpAllowed to the svm modify collection params
func (o *SvmModifyCollectionParams) WithNdmpAllowed(ndmpAllowed *bool) *SvmModifyCollectionParams {
	o.SetNdmpAllowed(ndmpAllowed)
	return o
}

// SetNdmpAllowed adds the ndmpAllowed to the svm modify collection params
func (o *SvmModifyCollectionParams) SetNdmpAllowed(ndmpAllowed *bool) {
	o.NdmpAllowed = ndmpAllowed
}

// WithNfsAllowed adds the nfsAllowed to the svm modify collection params
func (o *SvmModifyCollectionParams) WithNfsAllowed(nfsAllowed *bool) *SvmModifyCollectionParams {
	o.SetNfsAllowed(nfsAllowed)
	return o
}

// SetNfsAllowed adds the nfsAllowed to the svm modify collection params
func (o *SvmModifyCollectionParams) SetNfsAllowed(nfsAllowed *bool) {
	o.NfsAllowed = nfsAllowed
}

// WithNfsEnabled adds the nfsEnabled to the svm modify collection params
func (o *SvmModifyCollectionParams) WithNfsEnabled(nfsEnabled *bool) *SvmModifyCollectionParams {
	o.SetNfsEnabled(nfsEnabled)
	return o
}

// SetNfsEnabled adds the nfsEnabled to the svm modify collection params
func (o *SvmModifyCollectionParams) SetNfsEnabled(nfsEnabled *bool) {
	o.NfsEnabled = nfsEnabled
}

// WithNisDomain adds the nisDomain to the svm modify collection params
func (o *SvmModifyCollectionParams) WithNisDomain(nisDomain *string) *SvmModifyCollectionParams {
	o.SetNisDomain(nisDomain)
	return o
}

// SetNisDomain adds the nisDomain to the svm modify collection params
func (o *SvmModifyCollectionParams) SetNisDomain(nisDomain *string) {
	o.NisDomain = nisDomain
}

// WithNisEnabled adds the nisEnabled to the svm modify collection params
func (o *SvmModifyCollectionParams) WithNisEnabled(nisEnabled *bool) *SvmModifyCollectionParams {
	o.SetNisEnabled(nisEnabled)
	return o
}

// SetNisEnabled adds the nisEnabled to the svm modify collection params
func (o *SvmModifyCollectionParams) SetNisEnabled(nisEnabled *bool) {
	o.NisEnabled = nisEnabled
}

// WithNisServers adds the nisServers to the svm modify collection params
func (o *SvmModifyCollectionParams) WithNisServers(nisServers *string) *SvmModifyCollectionParams {
	o.SetNisServers(nisServers)
	return o
}

// SetNisServers adds the nisServers to the svm modify collection params
func (o *SvmModifyCollectionParams) SetNisServers(nisServers *string) {
	o.NisServers = nisServers
}

// WithNsswitchGroup adds the nsswitchGroup to the svm modify collection params
func (o *SvmModifyCollectionParams) WithNsswitchGroup(nsswitchGroup *string) *SvmModifyCollectionParams {
	o.SetNsswitchGroup(nsswitchGroup)
	return o
}

// SetNsswitchGroup adds the nsswitchGroup to the svm modify collection params
func (o *SvmModifyCollectionParams) SetNsswitchGroup(nsswitchGroup *string) {
	o.NsswitchGroup = nsswitchGroup
}

// WithNsswitchHosts adds the nsswitchHosts to the svm modify collection params
func (o *SvmModifyCollectionParams) WithNsswitchHosts(nsswitchHosts *string) *SvmModifyCollectionParams {
	o.SetNsswitchHosts(nsswitchHosts)
	return o
}

// SetNsswitchHosts adds the nsswitchHosts to the svm modify collection params
func (o *SvmModifyCollectionParams) SetNsswitchHosts(nsswitchHosts *string) {
	o.NsswitchHosts = nsswitchHosts
}

// WithNsswitchNamemap adds the nsswitchNamemap to the svm modify collection params
func (o *SvmModifyCollectionParams) WithNsswitchNamemap(nsswitchNamemap *string) *SvmModifyCollectionParams {
	o.SetNsswitchNamemap(nsswitchNamemap)
	return o
}

// SetNsswitchNamemap adds the nsswitchNamemap to the svm modify collection params
func (o *SvmModifyCollectionParams) SetNsswitchNamemap(nsswitchNamemap *string) {
	o.NsswitchNamemap = nsswitchNamemap
}

// WithNsswitchNetgroup adds the nsswitchNetgroup to the svm modify collection params
func (o *SvmModifyCollectionParams) WithNsswitchNetgroup(nsswitchNetgroup *string) *SvmModifyCollectionParams {
	o.SetNsswitchNetgroup(nsswitchNetgroup)
	return o
}

// SetNsswitchNetgroup adds the nsswitchNetgroup to the svm modify collection params
func (o *SvmModifyCollectionParams) SetNsswitchNetgroup(nsswitchNetgroup *string) {
	o.NsswitchNetgroup = nsswitchNetgroup
}

// WithNsswitchPasswd adds the nsswitchPasswd to the svm modify collection params
func (o *SvmModifyCollectionParams) WithNsswitchPasswd(nsswitchPasswd *string) *SvmModifyCollectionParams {
	o.SetNsswitchPasswd(nsswitchPasswd)
	return o
}

// SetNsswitchPasswd adds the nsswitchPasswd to the svm modify collection params
func (o *SvmModifyCollectionParams) SetNsswitchPasswd(nsswitchPasswd *string) {
	o.NsswitchPasswd = nsswitchPasswd
}

// WithNumberOfVolumesInRecoveryQueue adds the numberOfVolumesInRecoveryQueue to the svm modify collection params
func (o *SvmModifyCollectionParams) WithNumberOfVolumesInRecoveryQueue(numberOfVolumesInRecoveryQueue *int64) *SvmModifyCollectionParams {
	o.SetNumberOfVolumesInRecoveryQueue(numberOfVolumesInRecoveryQueue)
	return o
}

// SetNumberOfVolumesInRecoveryQueue adds the numberOfVolumesInRecoveryQueue to the svm modify collection params
func (o *SvmModifyCollectionParams) SetNumberOfVolumesInRecoveryQueue(numberOfVolumesInRecoveryQueue *int64) {
	o.NumberOfVolumesInRecoveryQueue = numberOfVolumesInRecoveryQueue
}

// WithNvmeAllowed adds the nvmeAllowed to the svm modify collection params
func (o *SvmModifyCollectionParams) WithNvmeAllowed(nvmeAllowed *bool) *SvmModifyCollectionParams {
	o.SetNvmeAllowed(nvmeAllowed)
	return o
}

// SetNvmeAllowed adds the nvmeAllowed to the svm modify collection params
func (o *SvmModifyCollectionParams) SetNvmeAllowed(nvmeAllowed *bool) {
	o.NvmeAllowed = nvmeAllowed
}

// WithNvmeEnabled adds the nvmeEnabled to the svm modify collection params
func (o *SvmModifyCollectionParams) WithNvmeEnabled(nvmeEnabled *bool) *SvmModifyCollectionParams {
	o.SetNvmeEnabled(nvmeEnabled)
	return o
}

// SetNvmeEnabled adds the nvmeEnabled to the svm modify collection params
func (o *SvmModifyCollectionParams) SetNvmeEnabled(nvmeEnabled *bool) {
	o.NvmeEnabled = nvmeEnabled
}

// WithQosAdaptivePolicyGroupTemplateName adds the qosAdaptivePolicyGroupTemplateName to the svm modify collection params
func (o *SvmModifyCollectionParams) WithQosAdaptivePolicyGroupTemplateName(qosAdaptivePolicyGroupTemplateName *string) *SvmModifyCollectionParams {
	o.SetQosAdaptivePolicyGroupTemplateName(qosAdaptivePolicyGroupTemplateName)
	return o
}

// SetQosAdaptivePolicyGroupTemplateName adds the qosAdaptivePolicyGroupTemplateName to the svm modify collection params
func (o *SvmModifyCollectionParams) SetQosAdaptivePolicyGroupTemplateName(qosAdaptivePolicyGroupTemplateName *string) {
	o.QosAdaptivePolicyGroupTemplateName = qosAdaptivePolicyGroupTemplateName
}

// WithQosAdaptivePolicyGroupTemplateUUID adds the qosAdaptivePolicyGroupTemplateUUID to the svm modify collection params
func (o *SvmModifyCollectionParams) WithQosAdaptivePolicyGroupTemplateUUID(qosAdaptivePolicyGroupTemplateUUID *string) *SvmModifyCollectionParams {
	o.SetQosAdaptivePolicyGroupTemplateUUID(qosAdaptivePolicyGroupTemplateUUID)
	return o
}

// SetQosAdaptivePolicyGroupTemplateUUID adds the qosAdaptivePolicyGroupTemplateUuid to the svm modify collection params
func (o *SvmModifyCollectionParams) SetQosAdaptivePolicyGroupTemplateUUID(qosAdaptivePolicyGroupTemplateUUID *string) {
	o.QosAdaptivePolicyGroupTemplateUUID = qosAdaptivePolicyGroupTemplateUUID
}

// WithQosPolicyName adds the qosPolicyName to the svm modify collection params
func (o *SvmModifyCollectionParams) WithQosPolicyName(qosPolicyName *string) *SvmModifyCollectionParams {
	o.SetQosPolicyName(qosPolicyName)
	return o
}

// SetQosPolicyName adds the qosPolicyName to the svm modify collection params
func (o *SvmModifyCollectionParams) SetQosPolicyName(qosPolicyName *string) {
	o.QosPolicyName = qosPolicyName
}

// WithQosPolicyUUID adds the qosPolicyUUID to the svm modify collection params
func (o *SvmModifyCollectionParams) WithQosPolicyUUID(qosPolicyUUID *string) *SvmModifyCollectionParams {
	o.SetQosPolicyUUID(qosPolicyUUID)
	return o
}

// SetQosPolicyUUID adds the qosPolicyUuid to the svm modify collection params
func (o *SvmModifyCollectionParams) SetQosPolicyUUID(qosPolicyUUID *string) {
	o.QosPolicyUUID = qosPolicyUUID
}

// WithQosPolicyGroupTemplateName adds the qosPolicyGroupTemplateName to the svm modify collection params
func (o *SvmModifyCollectionParams) WithQosPolicyGroupTemplateName(qosPolicyGroupTemplateName *string) *SvmModifyCollectionParams {
	o.SetQosPolicyGroupTemplateName(qosPolicyGroupTemplateName)
	return o
}

// SetQosPolicyGroupTemplateName adds the qosPolicyGroupTemplateName to the svm modify collection params
func (o *SvmModifyCollectionParams) SetQosPolicyGroupTemplateName(qosPolicyGroupTemplateName *string) {
	o.QosPolicyGroupTemplateName = qosPolicyGroupTemplateName
}

// WithQosPolicyGroupTemplateUUID adds the qosPolicyGroupTemplateUUID to the svm modify collection params
func (o *SvmModifyCollectionParams) WithQosPolicyGroupTemplateUUID(qosPolicyGroupTemplateUUID *string) *SvmModifyCollectionParams {
	o.SetQosPolicyGroupTemplateUUID(qosPolicyGroupTemplateUUID)
	return o
}

// SetQosPolicyGroupTemplateUUID adds the qosPolicyGroupTemplateUuid to the svm modify collection params
func (o *SvmModifyCollectionParams) SetQosPolicyGroupTemplateUUID(qosPolicyGroupTemplateUUID *string) {
	o.QosPolicyGroupTemplateUUID = qosPolicyGroupTemplateUUID
}

// WithReturnRecords adds the returnRecords to the svm modify collection params
func (o *SvmModifyCollectionParams) WithReturnRecords(returnRecords *bool) *SvmModifyCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the svm modify collection params
func (o *SvmModifyCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the svm modify collection params
func (o *SvmModifyCollectionParams) WithReturnTimeout(returnTimeout *int64) *SvmModifyCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the svm modify collection params
func (o *SvmModifyCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithS3Allowed adds the s3Allowed to the svm modify collection params
func (o *SvmModifyCollectionParams) WithS3Allowed(s3Allowed *bool) *SvmModifyCollectionParams {
	o.SetS3Allowed(s3Allowed)
	return o
}

// SetS3Allowed adds the s3Allowed to the svm modify collection params
func (o *SvmModifyCollectionParams) SetS3Allowed(s3Allowed *bool) {
	o.S3Allowed = s3Allowed
}

// WithS3CertificateName adds the s3CertificateName to the svm modify collection params
func (o *SvmModifyCollectionParams) WithS3CertificateName(s3CertificateName *string) *SvmModifyCollectionParams {
	o.SetS3CertificateName(s3CertificateName)
	return o
}

// SetS3CertificateName adds the s3CertificateName to the svm modify collection params
func (o *SvmModifyCollectionParams) SetS3CertificateName(s3CertificateName *string) {
	o.S3CertificateName = s3CertificateName
}

// WithS3CertificateUUID adds the s3CertificateUUID to the svm modify collection params
func (o *SvmModifyCollectionParams) WithS3CertificateUUID(s3CertificateUUID *string) *SvmModifyCollectionParams {
	o.SetS3CertificateUUID(s3CertificateUUID)
	return o
}

// SetS3CertificateUUID adds the s3CertificateUuid to the svm modify collection params
func (o *SvmModifyCollectionParams) SetS3CertificateUUID(s3CertificateUUID *string) {
	o.S3CertificateUUID = s3CertificateUUID
}

// WithS3Enabled adds the s3Enabled to the svm modify collection params
func (o *SvmModifyCollectionParams) WithS3Enabled(s3Enabled *bool) *SvmModifyCollectionParams {
	o.SetS3Enabled(s3Enabled)
	return o
}

// SetS3Enabled adds the s3Enabled to the svm modify collection params
func (o *SvmModifyCollectionParams) SetS3Enabled(s3Enabled *bool) {
	o.S3Enabled = s3Enabled
}

// WithS3IsHTTPEnabled adds the s3IsHTTPEnabled to the svm modify collection params
func (o *SvmModifyCollectionParams) WithS3IsHTTPEnabled(s3IsHTTPEnabled *bool) *SvmModifyCollectionParams {
	o.SetS3IsHTTPEnabled(s3IsHTTPEnabled)
	return o
}

// SetS3IsHTTPEnabled adds the s3IsHttpEnabled to the svm modify collection params
func (o *SvmModifyCollectionParams) SetS3IsHTTPEnabled(s3IsHTTPEnabled *bool) {
	o.S3IsHTTPEnabled = s3IsHTTPEnabled
}

// WithS3IsHTTPSEnabled adds the s3IsHTTPSEnabled to the svm modify collection params
func (o *SvmModifyCollectionParams) WithS3IsHTTPSEnabled(s3IsHTTPSEnabled *bool) *SvmModifyCollectionParams {
	o.SetS3IsHTTPSEnabled(s3IsHTTPSEnabled)
	return o
}

// SetS3IsHTTPSEnabled adds the s3IsHttpsEnabled to the svm modify collection params
func (o *SvmModifyCollectionParams) SetS3IsHTTPSEnabled(s3IsHTTPSEnabled *bool) {
	o.S3IsHTTPSEnabled = s3IsHTTPSEnabled
}

// WithS3Name adds the s3Name to the svm modify collection params
func (o *SvmModifyCollectionParams) WithS3Name(s3Name *string) *SvmModifyCollectionParams {
	o.SetS3Name(s3Name)
	return o
}

// SetS3Name adds the s3Name to the svm modify collection params
func (o *SvmModifyCollectionParams) SetS3Name(s3Name *string) {
	o.S3Name = s3Name
}

// WithS3Port adds the s3Port to the svm modify collection params
func (o *SvmModifyCollectionParams) WithS3Port(s3Port *int64) *SvmModifyCollectionParams {
	o.SetS3Port(s3Port)
	return o
}

// SetS3Port adds the s3Port to the svm modify collection params
func (o *SvmModifyCollectionParams) SetS3Port(s3Port *int64) {
	o.S3Port = s3Port
}

// WithS3SecurePort adds the s3SecurePort to the svm modify collection params
func (o *SvmModifyCollectionParams) WithS3SecurePort(s3SecurePort *int64) *SvmModifyCollectionParams {
	o.SetS3SecurePort(s3SecurePort)
	return o
}

// SetS3SecurePort adds the s3SecurePort to the svm modify collection params
func (o *SvmModifyCollectionParams) SetS3SecurePort(s3SecurePort *int64) {
	o.S3SecurePort = s3SecurePort
}

// WithSerialRecords adds the serialRecords to the svm modify collection params
func (o *SvmModifyCollectionParams) WithSerialRecords(serialRecords *bool) *SvmModifyCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the svm modify collection params
func (o *SvmModifyCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithSnapshotAutodeleteEnabled adds the snapshotAutodeleteEnabled to the svm modify collection params
func (o *SvmModifyCollectionParams) WithSnapshotAutodeleteEnabled(snapshotAutodeleteEnabled *bool) *SvmModifyCollectionParams {
	o.SetSnapshotAutodeleteEnabled(snapshotAutodeleteEnabled)
	return o
}

// SetSnapshotAutodeleteEnabled adds the snapshotAutodeleteEnabled to the svm modify collection params
func (o *SvmModifyCollectionParams) SetSnapshotAutodeleteEnabled(snapshotAutodeleteEnabled *bool) {
	o.SnapshotAutodeleteEnabled = snapshotAutodeleteEnabled
}

// WithSnapshotPolicyName adds the snapshotPolicyName to the svm modify collection params
func (o *SvmModifyCollectionParams) WithSnapshotPolicyName(snapshotPolicyName *string) *SvmModifyCollectionParams {
	o.SetSnapshotPolicyName(snapshotPolicyName)
	return o
}

// SetSnapshotPolicyName adds the snapshotPolicyName to the svm modify collection params
func (o *SvmModifyCollectionParams) SetSnapshotPolicyName(snapshotPolicyName *string) {
	o.SnapshotPolicyName = snapshotPolicyName
}

// WithSnapshotPolicyUUID adds the snapshotPolicyUUID to the svm modify collection params
func (o *SvmModifyCollectionParams) WithSnapshotPolicyUUID(snapshotPolicyUUID *string) *SvmModifyCollectionParams {
	o.SetSnapshotPolicyUUID(snapshotPolicyUUID)
	return o
}

// SetSnapshotPolicyUUID adds the snapshotPolicyUuid to the svm modify collection params
func (o *SvmModifyCollectionParams) SetSnapshotPolicyUUID(snapshotPolicyUUID *string) {
	o.SnapshotPolicyUUID = snapshotPolicyUUID
}

// WithSnapshotReservePercent adds the snapshotReservePercent to the svm modify collection params
func (o *SvmModifyCollectionParams) WithSnapshotReservePercent(snapshotReservePercent *int64) *SvmModifyCollectionParams {
	o.SetSnapshotReservePercent(snapshotReservePercent)
	return o
}

// SetSnapshotReservePercent adds the snapshotReservePercent to the svm modify collection params
func (o *SvmModifyCollectionParams) SetSnapshotReservePercent(snapshotReservePercent *int64) {
	o.SnapshotReservePercent = snapshotReservePercent
}

// WithState adds the state to the svm modify collection params
func (o *SvmModifyCollectionParams) WithState(state *string) *SvmModifyCollectionParams {
	o.SetState(state)
	return o
}

// SetState adds the state to the svm modify collection params
func (o *SvmModifyCollectionParams) SetState(state *string) {
	o.State = state
}

// WithStorageAllocated adds the storageAllocated to the svm modify collection params
func (o *SvmModifyCollectionParams) WithStorageAllocated(storageAllocated *int64) *SvmModifyCollectionParams {
	o.SetStorageAllocated(storageAllocated)
	return o
}

// SetStorageAllocated adds the storageAllocated to the svm modify collection params
func (o *SvmModifyCollectionParams) SetStorageAllocated(storageAllocated *int64) {
	o.StorageAllocated = storageAllocated
}

// WithStorageAvailable adds the storageAvailable to the svm modify collection params
func (o *SvmModifyCollectionParams) WithStorageAvailable(storageAvailable *int64) *SvmModifyCollectionParams {
	o.SetStorageAvailable(storageAvailable)
	return o
}

// SetStorageAvailable adds the storageAvailable to the svm modify collection params
func (o *SvmModifyCollectionParams) SetStorageAvailable(storageAvailable *int64) {
	o.StorageAvailable = storageAvailable
}

// WithStorageLimit adds the storageLimit to the svm modify collection params
func (o *SvmModifyCollectionParams) WithStorageLimit(storageLimit *int64) *SvmModifyCollectionParams {
	o.SetStorageLimit(storageLimit)
	return o
}

// SetStorageLimit adds the storageLimit to the svm modify collection params
func (o *SvmModifyCollectionParams) SetStorageLimit(storageLimit *int64) {
	o.StorageLimit = storageLimit
}

// WithStorageLimitThresholdAlert adds the storageLimitThresholdAlert to the svm modify collection params
func (o *SvmModifyCollectionParams) WithStorageLimitThresholdAlert(storageLimitThresholdAlert *int64) *SvmModifyCollectionParams {
	o.SetStorageLimitThresholdAlert(storageLimitThresholdAlert)
	return o
}

// SetStorageLimitThresholdAlert adds the storageLimitThresholdAlert to the svm modify collection params
func (o *SvmModifyCollectionParams) SetStorageLimitThresholdAlert(storageLimitThresholdAlert *int64) {
	o.StorageLimitThresholdAlert = storageLimitThresholdAlert
}

// WithStorageLimitThresholdExceeded adds the storageLimitThresholdExceeded to the svm modify collection params
func (o *SvmModifyCollectionParams) WithStorageLimitThresholdExceeded(storageLimitThresholdExceeded *int64) *SvmModifyCollectionParams {
	o.SetStorageLimitThresholdExceeded(storageLimitThresholdExceeded)
	return o
}

// SetStorageLimitThresholdExceeded adds the storageLimitThresholdExceeded to the svm modify collection params
func (o *SvmModifyCollectionParams) SetStorageLimitThresholdExceeded(storageLimitThresholdExceeded *int64) {
	o.StorageLimitThresholdExceeded = storageLimitThresholdExceeded
}

// WithStorageUsedPercentage adds the storageUsedPercentage to the svm modify collection params
func (o *SvmModifyCollectionParams) WithStorageUsedPercentage(storageUsedPercentage *int64) *SvmModifyCollectionParams {
	o.SetStorageUsedPercentage(storageUsedPercentage)
	return o
}

// SetStorageUsedPercentage adds the storageUsedPercentage to the svm modify collection params
func (o *SvmModifyCollectionParams) SetStorageUsedPercentage(storageUsedPercentage *int64) {
	o.StorageUsedPercentage = storageUsedPercentage
}

// WithSubtype adds the subtype to the svm modify collection params
func (o *SvmModifyCollectionParams) WithSubtype(subtype *string) *SvmModifyCollectionParams {
	o.SetSubtype(subtype)
	return o
}

// SetSubtype adds the subtype to the svm modify collection params
func (o *SvmModifyCollectionParams) SetSubtype(subtype *string) {
	o.Subtype = subtype
}

// WithTotalVolumeSizeInRecoveryQueue adds the totalVolumeSizeInRecoveryQueue to the svm modify collection params
func (o *SvmModifyCollectionParams) WithTotalVolumeSizeInRecoveryQueue(totalVolumeSizeInRecoveryQueue *int64) *SvmModifyCollectionParams {
	o.SetTotalVolumeSizeInRecoveryQueue(totalVolumeSizeInRecoveryQueue)
	return o
}

// SetTotalVolumeSizeInRecoveryQueue adds the totalVolumeSizeInRecoveryQueue to the svm modify collection params
func (o *SvmModifyCollectionParams) SetTotalVolumeSizeInRecoveryQueue(totalVolumeSizeInRecoveryQueue *int64) {
	o.TotalVolumeSizeInRecoveryQueue = totalVolumeSizeInRecoveryQueue
}

// WithUUID adds the uuid to the svm modify collection params
func (o *SvmModifyCollectionParams) WithUUID(uuid *string) *SvmModifyCollectionParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the svm modify collection params
func (o *SvmModifyCollectionParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *SvmModifyCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.AggregatesName != nil {

		// query param aggregates.name
		var qrAggregatesName string

		if o.AggregatesName != nil {
			qrAggregatesName = *o.AggregatesName
		}
		qAggregatesName := qrAggregatesName
		if qAggregatesName != "" {

			if err := r.SetQueryParam("aggregates.name", qAggregatesName); err != nil {
				return err
			}
		}
	}

	if o.AggregatesUUID != nil {

		// query param aggregates.uuid
		var qrAggregatesUUID string

		if o.AggregatesUUID != nil {
			qrAggregatesUUID = *o.AggregatesUUID
		}
		qAggregatesUUID := qrAggregatesUUID
		if qAggregatesUUID != "" {

			if err := r.SetQueryParam("aggregates.uuid", qAggregatesUUID); err != nil {
				return err
			}
		}
	}

	if o.AntiRansomwareAutoSwitchDurationWithoutNewFileExtension != nil {

		// query param anti_ransomware_auto_switch_duration_without_new_file_extension
		var qrAntiRansomwareAutoSwitchDurationWithoutNewFileExtension int64

		if o.AntiRansomwareAutoSwitchDurationWithoutNewFileExtension != nil {
			qrAntiRansomwareAutoSwitchDurationWithoutNewFileExtension = *o.AntiRansomwareAutoSwitchDurationWithoutNewFileExtension
		}
		qAntiRansomwareAutoSwitchDurationWithoutNewFileExtension := swag.FormatInt64(qrAntiRansomwareAutoSwitchDurationWithoutNewFileExtension)
		if qAntiRansomwareAutoSwitchDurationWithoutNewFileExtension != "" {

			if err := r.SetQueryParam("anti_ransomware_auto_switch_duration_without_new_file_extension", qAntiRansomwareAutoSwitchDurationWithoutNewFileExtension); err != nil {
				return err
			}
		}
	}

	if o.AntiRansomwareAutoSwitchFromLearningToEnabled != nil {

		// query param anti_ransomware_auto_switch_from_learning_to_enabled
		var qrAntiRansomwareAutoSwitchFromLearningToEnabled bool

		if o.AntiRansomwareAutoSwitchFromLearningToEnabled != nil {
			qrAntiRansomwareAutoSwitchFromLearningToEnabled = *o.AntiRansomwareAutoSwitchFromLearningToEnabled
		}
		qAntiRansomwareAutoSwitchFromLearningToEnabled := swag.FormatBool(qrAntiRansomwareAutoSwitchFromLearningToEnabled)
		if qAntiRansomwareAutoSwitchFromLearningToEnabled != "" {

			if err := r.SetQueryParam("anti_ransomware_auto_switch_from_learning_to_enabled", qAntiRansomwareAutoSwitchFromLearningToEnabled); err != nil {
				return err
			}
		}
	}

	if o.AntiRansomwareAutoSwitchMinimumFileCount != nil {

		// query param anti_ransomware_auto_switch_minimum_file_count
		var qrAntiRansomwareAutoSwitchMinimumFileCount int64

		if o.AntiRansomwareAutoSwitchMinimumFileCount != nil {
			qrAntiRansomwareAutoSwitchMinimumFileCount = *o.AntiRansomwareAutoSwitchMinimumFileCount
		}
		qAntiRansomwareAutoSwitchMinimumFileCount := swag.FormatInt64(qrAntiRansomwareAutoSwitchMinimumFileCount)
		if qAntiRansomwareAutoSwitchMinimumFileCount != "" {

			if err := r.SetQueryParam("anti_ransomware_auto_switch_minimum_file_count", qAntiRansomwareAutoSwitchMinimumFileCount); err != nil {
				return err
			}
		}
	}

	if o.AntiRansomwareAutoSwitchMinimumFileExtension != nil {

		// query param anti_ransomware_auto_switch_minimum_file_extension
		var qrAntiRansomwareAutoSwitchMinimumFileExtension int64

		if o.AntiRansomwareAutoSwitchMinimumFileExtension != nil {
			qrAntiRansomwareAutoSwitchMinimumFileExtension = *o.AntiRansomwareAutoSwitchMinimumFileExtension
		}
		qAntiRansomwareAutoSwitchMinimumFileExtension := swag.FormatInt64(qrAntiRansomwareAutoSwitchMinimumFileExtension)
		if qAntiRansomwareAutoSwitchMinimumFileExtension != "" {

			if err := r.SetQueryParam("anti_ransomware_auto_switch_minimum_file_extension", qAntiRansomwareAutoSwitchMinimumFileExtension); err != nil {
				return err
			}
		}
	}

	if o.AntiRansomwareAutoSwitchMinimumIncomingData != nil {

		// query param anti_ransomware_auto_switch_minimum_incoming_data
		var qrAntiRansomwareAutoSwitchMinimumIncomingData string

		if o.AntiRansomwareAutoSwitchMinimumIncomingData != nil {
			qrAntiRansomwareAutoSwitchMinimumIncomingData = *o.AntiRansomwareAutoSwitchMinimumIncomingData
		}
		qAntiRansomwareAutoSwitchMinimumIncomingData := qrAntiRansomwareAutoSwitchMinimumIncomingData
		if qAntiRansomwareAutoSwitchMinimumIncomingData != "" {

			if err := r.SetQueryParam("anti_ransomware_auto_switch_minimum_incoming_data", qAntiRansomwareAutoSwitchMinimumIncomingData); err != nil {
				return err
			}
		}
	}

	if o.AntiRansomwareAutoSwitchMinimumIncomingDataPercent != nil {

		// query param anti_ransomware_auto_switch_minimum_incoming_data_percent
		var qrAntiRansomwareAutoSwitchMinimumIncomingDataPercent int64

		if o.AntiRansomwareAutoSwitchMinimumIncomingDataPercent != nil {
			qrAntiRansomwareAutoSwitchMinimumIncomingDataPercent = *o.AntiRansomwareAutoSwitchMinimumIncomingDataPercent
		}
		qAntiRansomwareAutoSwitchMinimumIncomingDataPercent := swag.FormatInt64(qrAntiRansomwareAutoSwitchMinimumIncomingDataPercent)
		if qAntiRansomwareAutoSwitchMinimumIncomingDataPercent != "" {

			if err := r.SetQueryParam("anti_ransomware_auto_switch_minimum_incoming_data_percent", qAntiRansomwareAutoSwitchMinimumIncomingDataPercent); err != nil {
				return err
			}
		}
	}

	if o.AntiRansomwareAutoSwitchMinimumLearningPeriod != nil {

		// query param anti_ransomware_auto_switch_minimum_learning_period
		var qrAntiRansomwareAutoSwitchMinimumLearningPeriod int64

		if o.AntiRansomwareAutoSwitchMinimumLearningPeriod != nil {
			qrAntiRansomwareAutoSwitchMinimumLearningPeriod = *o.AntiRansomwareAutoSwitchMinimumLearningPeriod
		}
		qAntiRansomwareAutoSwitchMinimumLearningPeriod := swag.FormatInt64(qrAntiRansomwareAutoSwitchMinimumLearningPeriod)
		if qAntiRansomwareAutoSwitchMinimumLearningPeriod != "" {

			if err := r.SetQueryParam("anti_ransomware_auto_switch_minimum_learning_period", qAntiRansomwareAutoSwitchMinimumLearningPeriod); err != nil {
				return err
			}
		}
	}

	if o.AntiRansomwareDefaultVolumeState != nil {

		// query param anti_ransomware_default_volume_state
		var qrAntiRansomwareDefaultVolumeState string

		if o.AntiRansomwareDefaultVolumeState != nil {
			qrAntiRansomwareDefaultVolumeState = *o.AntiRansomwareDefaultVolumeState
		}
		qAntiRansomwareDefaultVolumeState := qrAntiRansomwareDefaultVolumeState
		if qAntiRansomwareDefaultVolumeState != "" {

			if err := r.SetQueryParam("anti_ransomware_default_volume_state", qAntiRansomwareDefaultVolumeState); err != nil {
				return err
			}
		}
	}

	if o.AutoEnableActivityTracking != nil {

		// query param auto_enable_activity_tracking
		var qrAutoEnableActivityTracking bool

		if o.AutoEnableActivityTracking != nil {
			qrAutoEnableActivityTracking = *o.AutoEnableActivityTracking
		}
		qAutoEnableActivityTracking := swag.FormatBool(qrAutoEnableActivityTracking)
		if qAutoEnableActivityTracking != "" {

			if err := r.SetQueryParam("auto_enable_activity_tracking", qAutoEnableActivityTracking); err != nil {
				return err
			}
		}
	}

	if o.AutoEnableAnalytics != nil {

		// query param auto_enable_analytics
		var qrAutoEnableAnalytics bool

		if o.AutoEnableAnalytics != nil {
			qrAutoEnableAnalytics = *o.AutoEnableAnalytics
		}
		qAutoEnableAnalytics := swag.FormatBool(qrAutoEnableAnalytics)
		if qAutoEnableAnalytics != "" {

			if err := r.SetQueryParam("auto_enable_analytics", qAutoEnableAnalytics); err != nil {
				return err
			}
		}
	}

	if o.CertificateUUID != nil {

		// query param certificate.uuid
		var qrCertificateUUID string

		if o.CertificateUUID != nil {
			qrCertificateUUID = *o.CertificateUUID
		}
		qCertificateUUID := qrCertificateUUID
		if qCertificateUUID != "" {

			if err := r.SetQueryParam("certificate.uuid", qCertificateUUID); err != nil {
				return err
			}
		}
	}

	if o.CifsAdDomainFqdn != nil {

		// query param cifs.ad_domain.fqdn
		var qrCifsAdDomainFqdn string

		if o.CifsAdDomainFqdn != nil {
			qrCifsAdDomainFqdn = *o.CifsAdDomainFqdn
		}
		qCifsAdDomainFqdn := qrCifsAdDomainFqdn
		if qCifsAdDomainFqdn != "" {

			if err := r.SetQueryParam("cifs.ad_domain.fqdn", qCifsAdDomainFqdn); err != nil {
				return err
			}
		}
	}

	if o.CifsAdDomainOrganizationalUnit != nil {

		// query param cifs.ad_domain.organizational_unit
		var qrCifsAdDomainOrganizationalUnit string

		if o.CifsAdDomainOrganizationalUnit != nil {
			qrCifsAdDomainOrganizationalUnit = *o.CifsAdDomainOrganizationalUnit
		}
		qCifsAdDomainOrganizationalUnit := qrCifsAdDomainOrganizationalUnit
		if qCifsAdDomainOrganizationalUnit != "" {

			if err := r.SetQueryParam("cifs.ad_domain.organizational_unit", qCifsAdDomainOrganizationalUnit); err != nil {
				return err
			}
		}
	}

	if o.CifsAllowed != nil {

		// query param cifs.allowed
		var qrCifsAllowed bool

		if o.CifsAllowed != nil {
			qrCifsAllowed = *o.CifsAllowed
		}
		qCifsAllowed := swag.FormatBool(qrCifsAllowed)
		if qCifsAllowed != "" {

			if err := r.SetQueryParam("cifs.allowed", qCifsAllowed); err != nil {
				return err
			}
		}
	}

	if o.CifsEnabled != nil {

		// query param cifs.enabled
		var qrCifsEnabled bool

		if o.CifsEnabled != nil {
			qrCifsEnabled = *o.CifsEnabled
		}
		qCifsEnabled := swag.FormatBool(qrCifsEnabled)
		if qCifsEnabled != "" {

			if err := r.SetQueryParam("cifs.enabled", qCifsEnabled); err != nil {
				return err
			}
		}
	}

	if o.CifsName != nil {

		// query param cifs.name
		var qrCifsName string

		if o.CifsName != nil {
			qrCifsName = *o.CifsName
		}
		qCifsName := qrCifsName
		if qCifsName != "" {

			if err := r.SetQueryParam("cifs.name", qCifsName); err != nil {
				return err
			}
		}
	}

	if o.Comment != nil {

		// query param comment
		var qrComment string

		if o.Comment != nil {
			qrComment = *o.Comment
		}
		qComment := qrComment
		if qComment != "" {

			if err := r.SetQueryParam("comment", qComment); err != nil {
				return err
			}
		}
	}

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}

	if o.DNSDomains != nil {

		// query param dns.domains
		var qrDNSDomains string

		if o.DNSDomains != nil {
			qrDNSDomains = *o.DNSDomains
		}
		qDNSDomains := qrDNSDomains
		if qDNSDomains != "" {

			if err := r.SetQueryParam("dns.domains", qDNSDomains); err != nil {
				return err
			}
		}
	}

	if o.DNSServers != nil {

		// query param dns.servers
		var qrDNSServers string

		if o.DNSServers != nil {
			qrDNSServers = *o.DNSServers
		}
		qDNSServers := qrDNSServers
		if qDNSServers != "" {

			if err := r.SetQueryParam("dns.servers", qDNSServers); err != nil {
				return err
			}
		}
	}

	if o.FcInterfacesDataProtocol != nil {

		// query param fc_interfaces.data_protocol
		var qrFcInterfacesDataProtocol string

		if o.FcInterfacesDataProtocol != nil {
			qrFcInterfacesDataProtocol = *o.FcInterfacesDataProtocol
		}
		qFcInterfacesDataProtocol := qrFcInterfacesDataProtocol
		if qFcInterfacesDataProtocol != "" {

			if err := r.SetQueryParam("fc_interfaces.data_protocol", qFcInterfacesDataProtocol); err != nil {
				return err
			}
		}
	}

	if o.FcInterfacesName != nil {

		// query param fc_interfaces.name
		var qrFcInterfacesName string

		if o.FcInterfacesName != nil {
			qrFcInterfacesName = *o.FcInterfacesName
		}
		qFcInterfacesName := qrFcInterfacesName
		if qFcInterfacesName != "" {

			if err := r.SetQueryParam("fc_interfaces.name", qFcInterfacesName); err != nil {
				return err
			}
		}
	}

	if o.FcpAllowed != nil {

		// query param fcp.allowed
		var qrFcpAllowed bool

		if o.FcpAllowed != nil {
			qrFcpAllowed = *o.FcpAllowed
		}
		qFcpAllowed := swag.FormatBool(qrFcpAllowed)
		if qFcpAllowed != "" {

			if err := r.SetQueryParam("fcp.allowed", qFcpAllowed); err != nil {
				return err
			}
		}
	}

	if o.FcpEnabled != nil {

		// query param fcp.enabled
		var qrFcpEnabled bool

		if o.FcpEnabled != nil {
			qrFcpEnabled = *o.FcpEnabled
		}
		qFcpEnabled := swag.FormatBool(qrFcpEnabled)
		if qFcpEnabled != "" {

			if err := r.SetQueryParam("fcp.enabled", qFcpEnabled); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.IpspaceName != nil {

		// query param ipspace.name
		var qrIpspaceName string

		if o.IpspaceName != nil {
			qrIpspaceName = *o.IpspaceName
		}
		qIpspaceName := qrIpspaceName
		if qIpspaceName != "" {

			if err := r.SetQueryParam("ipspace.name", qIpspaceName); err != nil {
				return err
			}
		}
	}

	if o.IpspaceUUID != nil {

		// query param ipspace.uuid
		var qrIpspaceUUID string

		if o.IpspaceUUID != nil {
			qrIpspaceUUID = *o.IpspaceUUID
		}
		qIpspaceUUID := qrIpspaceUUID
		if qIpspaceUUID != "" {

			if err := r.SetQueryParam("ipspace.uuid", qIpspaceUUID); err != nil {
				return err
			}
		}
	}

	if o.IscsiAllowed != nil {

		// query param iscsi.allowed
		var qrIscsiAllowed bool

		if o.IscsiAllowed != nil {
			qrIscsiAllowed = *o.IscsiAllowed
		}
		qIscsiAllowed := swag.FormatBool(qrIscsiAllowed)
		if qIscsiAllowed != "" {

			if err := r.SetQueryParam("iscsi.allowed", qIscsiAllowed); err != nil {
				return err
			}
		}
	}

	if o.IscsiEnabled != nil {

		// query param iscsi.enabled
		var qrIscsiEnabled bool

		if o.IscsiEnabled != nil {
			qrIscsiEnabled = *o.IscsiEnabled
		}
		qIscsiEnabled := swag.FormatBool(qrIscsiEnabled)
		if qIscsiEnabled != "" {

			if err := r.SetQueryParam("iscsi.enabled", qIscsiEnabled); err != nil {
				return err
			}
		}
	}

	if o.Language != nil {

		// query param language
		var qrLanguage string

		if o.Language != nil {
			qrLanguage = *o.Language
		}
		qLanguage := qrLanguage
		if qLanguage != "" {

			if err := r.SetQueryParam("language", qLanguage); err != nil {
				return err
			}
		}
	}

	if o.LdapAdDomain != nil {

		// query param ldap.ad_domain
		var qrLdapAdDomain string

		if o.LdapAdDomain != nil {
			qrLdapAdDomain = *o.LdapAdDomain
		}
		qLdapAdDomain := qrLdapAdDomain
		if qLdapAdDomain != "" {

			if err := r.SetQueryParam("ldap.ad_domain", qLdapAdDomain); err != nil {
				return err
			}
		}
	}

	if o.LdapBaseDn != nil {

		// query param ldap.base_dn
		var qrLdapBaseDn string

		if o.LdapBaseDn != nil {
			qrLdapBaseDn = *o.LdapBaseDn
		}
		qLdapBaseDn := qrLdapBaseDn
		if qLdapBaseDn != "" {

			if err := r.SetQueryParam("ldap.base_dn", qLdapBaseDn); err != nil {
				return err
			}
		}
	}

	if o.LdapBindDn != nil {

		// query param ldap.bind_dn
		var qrLdapBindDn string

		if o.LdapBindDn != nil {
			qrLdapBindDn = *o.LdapBindDn
		}
		qLdapBindDn := qrLdapBindDn
		if qLdapBindDn != "" {

			if err := r.SetQueryParam("ldap.bind_dn", qLdapBindDn); err != nil {
				return err
			}
		}
	}

	if o.LdapEnabled != nil {

		// query param ldap.enabled
		var qrLdapEnabled bool

		if o.LdapEnabled != nil {
			qrLdapEnabled = *o.LdapEnabled
		}
		qLdapEnabled := swag.FormatBool(qrLdapEnabled)
		if qLdapEnabled != "" {

			if err := r.SetQueryParam("ldap.enabled", qLdapEnabled); err != nil {
				return err
			}
		}
	}

	if o.LdapServers != nil {

		// query param ldap.servers
		var qrLdapServers string

		if o.LdapServers != nil {
			qrLdapServers = *o.LdapServers
		}
		qLdapServers := qrLdapServers
		if qLdapServers != "" {

			if err := r.SetQueryParam("ldap.servers", qLdapServers); err != nil {
				return err
			}
		}
	}

	if o.MaxVolumes != nil {

		// query param max_volumes
		var qrMaxVolumes string

		if o.MaxVolumes != nil {
			qrMaxVolumes = *o.MaxVolumes
		}
		qMaxVolumes := qrMaxVolumes
		if qMaxVolumes != "" {

			if err := r.SetQueryParam("max_volumes", qMaxVolumes); err != nil {
				return err
			}
		}
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.NdmpAllowed != nil {

		// query param ndmp.allowed
		var qrNdmpAllowed bool

		if o.NdmpAllowed != nil {
			qrNdmpAllowed = *o.NdmpAllowed
		}
		qNdmpAllowed := swag.FormatBool(qrNdmpAllowed)
		if qNdmpAllowed != "" {

			if err := r.SetQueryParam("ndmp.allowed", qNdmpAllowed); err != nil {
				return err
			}
		}
	}

	if o.NfsAllowed != nil {

		// query param nfs.allowed
		var qrNfsAllowed bool

		if o.NfsAllowed != nil {
			qrNfsAllowed = *o.NfsAllowed
		}
		qNfsAllowed := swag.FormatBool(qrNfsAllowed)
		if qNfsAllowed != "" {

			if err := r.SetQueryParam("nfs.allowed", qNfsAllowed); err != nil {
				return err
			}
		}
	}

	if o.NfsEnabled != nil {

		// query param nfs.enabled
		var qrNfsEnabled bool

		if o.NfsEnabled != nil {
			qrNfsEnabled = *o.NfsEnabled
		}
		qNfsEnabled := swag.FormatBool(qrNfsEnabled)
		if qNfsEnabled != "" {

			if err := r.SetQueryParam("nfs.enabled", qNfsEnabled); err != nil {
				return err
			}
		}
	}

	if o.NisDomain != nil {

		// query param nis.domain
		var qrNisDomain string

		if o.NisDomain != nil {
			qrNisDomain = *o.NisDomain
		}
		qNisDomain := qrNisDomain
		if qNisDomain != "" {

			if err := r.SetQueryParam("nis.domain", qNisDomain); err != nil {
				return err
			}
		}
	}

	if o.NisEnabled != nil {

		// query param nis.enabled
		var qrNisEnabled bool

		if o.NisEnabled != nil {
			qrNisEnabled = *o.NisEnabled
		}
		qNisEnabled := swag.FormatBool(qrNisEnabled)
		if qNisEnabled != "" {

			if err := r.SetQueryParam("nis.enabled", qNisEnabled); err != nil {
				return err
			}
		}
	}

	if o.NisServers != nil {

		// query param nis.servers
		var qrNisServers string

		if o.NisServers != nil {
			qrNisServers = *o.NisServers
		}
		qNisServers := qrNisServers
		if qNisServers != "" {

			if err := r.SetQueryParam("nis.servers", qNisServers); err != nil {
				return err
			}
		}
	}

	if o.NsswitchGroup != nil {

		// query param nsswitch.group
		var qrNsswitchGroup string

		if o.NsswitchGroup != nil {
			qrNsswitchGroup = *o.NsswitchGroup
		}
		qNsswitchGroup := qrNsswitchGroup
		if qNsswitchGroup != "" {

			if err := r.SetQueryParam("nsswitch.group", qNsswitchGroup); err != nil {
				return err
			}
		}
	}

	if o.NsswitchHosts != nil {

		// query param nsswitch.hosts
		var qrNsswitchHosts string

		if o.NsswitchHosts != nil {
			qrNsswitchHosts = *o.NsswitchHosts
		}
		qNsswitchHosts := qrNsswitchHosts
		if qNsswitchHosts != "" {

			if err := r.SetQueryParam("nsswitch.hosts", qNsswitchHosts); err != nil {
				return err
			}
		}
	}

	if o.NsswitchNamemap != nil {

		// query param nsswitch.namemap
		var qrNsswitchNamemap string

		if o.NsswitchNamemap != nil {
			qrNsswitchNamemap = *o.NsswitchNamemap
		}
		qNsswitchNamemap := qrNsswitchNamemap
		if qNsswitchNamemap != "" {

			if err := r.SetQueryParam("nsswitch.namemap", qNsswitchNamemap); err != nil {
				return err
			}
		}
	}

	if o.NsswitchNetgroup != nil {

		// query param nsswitch.netgroup
		var qrNsswitchNetgroup string

		if o.NsswitchNetgroup != nil {
			qrNsswitchNetgroup = *o.NsswitchNetgroup
		}
		qNsswitchNetgroup := qrNsswitchNetgroup
		if qNsswitchNetgroup != "" {

			if err := r.SetQueryParam("nsswitch.netgroup", qNsswitchNetgroup); err != nil {
				return err
			}
		}
	}

	if o.NsswitchPasswd != nil {

		// query param nsswitch.passwd
		var qrNsswitchPasswd string

		if o.NsswitchPasswd != nil {
			qrNsswitchPasswd = *o.NsswitchPasswd
		}
		qNsswitchPasswd := qrNsswitchPasswd
		if qNsswitchPasswd != "" {

			if err := r.SetQueryParam("nsswitch.passwd", qNsswitchPasswd); err != nil {
				return err
			}
		}
	}

	if o.NumberOfVolumesInRecoveryQueue != nil {

		// query param number_of_volumes_in_recovery_queue
		var qrNumberOfVolumesInRecoveryQueue int64

		if o.NumberOfVolumesInRecoveryQueue != nil {
			qrNumberOfVolumesInRecoveryQueue = *o.NumberOfVolumesInRecoveryQueue
		}
		qNumberOfVolumesInRecoveryQueue := swag.FormatInt64(qrNumberOfVolumesInRecoveryQueue)
		if qNumberOfVolumesInRecoveryQueue != "" {

			if err := r.SetQueryParam("number_of_volumes_in_recovery_queue", qNumberOfVolumesInRecoveryQueue); err != nil {
				return err
			}
		}
	}

	if o.NvmeAllowed != nil {

		// query param nvme.allowed
		var qrNvmeAllowed bool

		if o.NvmeAllowed != nil {
			qrNvmeAllowed = *o.NvmeAllowed
		}
		qNvmeAllowed := swag.FormatBool(qrNvmeAllowed)
		if qNvmeAllowed != "" {

			if err := r.SetQueryParam("nvme.allowed", qNvmeAllowed); err != nil {
				return err
			}
		}
	}

	if o.NvmeEnabled != nil {

		// query param nvme.enabled
		var qrNvmeEnabled bool

		if o.NvmeEnabled != nil {
			qrNvmeEnabled = *o.NvmeEnabled
		}
		qNvmeEnabled := swag.FormatBool(qrNvmeEnabled)
		if qNvmeEnabled != "" {

			if err := r.SetQueryParam("nvme.enabled", qNvmeEnabled); err != nil {
				return err
			}
		}
	}

	if o.QosAdaptivePolicyGroupTemplateName != nil {

		// query param qos_adaptive_policy_group_template.name
		var qrQosAdaptivePolicyGroupTemplateName string

		if o.QosAdaptivePolicyGroupTemplateName != nil {
			qrQosAdaptivePolicyGroupTemplateName = *o.QosAdaptivePolicyGroupTemplateName
		}
		qQosAdaptivePolicyGroupTemplateName := qrQosAdaptivePolicyGroupTemplateName
		if qQosAdaptivePolicyGroupTemplateName != "" {

			if err := r.SetQueryParam("qos_adaptive_policy_group_template.name", qQosAdaptivePolicyGroupTemplateName); err != nil {
				return err
			}
		}
	}

	if o.QosAdaptivePolicyGroupTemplateUUID != nil {

		// query param qos_adaptive_policy_group_template.uuid
		var qrQosAdaptivePolicyGroupTemplateUUID string

		if o.QosAdaptivePolicyGroupTemplateUUID != nil {
			qrQosAdaptivePolicyGroupTemplateUUID = *o.QosAdaptivePolicyGroupTemplateUUID
		}
		qQosAdaptivePolicyGroupTemplateUUID := qrQosAdaptivePolicyGroupTemplateUUID
		if qQosAdaptivePolicyGroupTemplateUUID != "" {

			if err := r.SetQueryParam("qos_adaptive_policy_group_template.uuid", qQosAdaptivePolicyGroupTemplateUUID); err != nil {
				return err
			}
		}
	}

	if o.QosPolicyName != nil {

		// query param qos_policy.name
		var qrQosPolicyName string

		if o.QosPolicyName != nil {
			qrQosPolicyName = *o.QosPolicyName
		}
		qQosPolicyName := qrQosPolicyName
		if qQosPolicyName != "" {

			if err := r.SetQueryParam("qos_policy.name", qQosPolicyName); err != nil {
				return err
			}
		}
	}

	if o.QosPolicyUUID != nil {

		// query param qos_policy.uuid
		var qrQosPolicyUUID string

		if o.QosPolicyUUID != nil {
			qrQosPolicyUUID = *o.QosPolicyUUID
		}
		qQosPolicyUUID := qrQosPolicyUUID
		if qQosPolicyUUID != "" {

			if err := r.SetQueryParam("qos_policy.uuid", qQosPolicyUUID); err != nil {
				return err
			}
		}
	}

	if o.QosPolicyGroupTemplateName != nil {

		// query param qos_policy_group_template.name
		var qrQosPolicyGroupTemplateName string

		if o.QosPolicyGroupTemplateName != nil {
			qrQosPolicyGroupTemplateName = *o.QosPolicyGroupTemplateName
		}
		qQosPolicyGroupTemplateName := qrQosPolicyGroupTemplateName
		if qQosPolicyGroupTemplateName != "" {

			if err := r.SetQueryParam("qos_policy_group_template.name", qQosPolicyGroupTemplateName); err != nil {
				return err
			}
		}
	}

	if o.QosPolicyGroupTemplateUUID != nil {

		// query param qos_policy_group_template.uuid
		var qrQosPolicyGroupTemplateUUID string

		if o.QosPolicyGroupTemplateUUID != nil {
			qrQosPolicyGroupTemplateUUID = *o.QosPolicyGroupTemplateUUID
		}
		qQosPolicyGroupTemplateUUID := qrQosPolicyGroupTemplateUUID
		if qQosPolicyGroupTemplateUUID != "" {

			if err := r.SetQueryParam("qos_policy_group_template.uuid", qQosPolicyGroupTemplateUUID); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.S3Allowed != nil {

		// query param s3.allowed
		var qrS3Allowed bool

		if o.S3Allowed != nil {
			qrS3Allowed = *o.S3Allowed
		}
		qS3Allowed := swag.FormatBool(qrS3Allowed)
		if qS3Allowed != "" {

			if err := r.SetQueryParam("s3.allowed", qS3Allowed); err != nil {
				return err
			}
		}
	}

	if o.S3CertificateName != nil {

		// query param s3.certificate.name
		var qrS3CertificateName string

		if o.S3CertificateName != nil {
			qrS3CertificateName = *o.S3CertificateName
		}
		qS3CertificateName := qrS3CertificateName
		if qS3CertificateName != "" {

			if err := r.SetQueryParam("s3.certificate.name", qS3CertificateName); err != nil {
				return err
			}
		}
	}

	if o.S3CertificateUUID != nil {

		// query param s3.certificate.uuid
		var qrS3CertificateUUID string

		if o.S3CertificateUUID != nil {
			qrS3CertificateUUID = *o.S3CertificateUUID
		}
		qS3CertificateUUID := qrS3CertificateUUID
		if qS3CertificateUUID != "" {

			if err := r.SetQueryParam("s3.certificate.uuid", qS3CertificateUUID); err != nil {
				return err
			}
		}
	}

	if o.S3Enabled != nil {

		// query param s3.enabled
		var qrS3Enabled bool

		if o.S3Enabled != nil {
			qrS3Enabled = *o.S3Enabled
		}
		qS3Enabled := swag.FormatBool(qrS3Enabled)
		if qS3Enabled != "" {

			if err := r.SetQueryParam("s3.enabled", qS3Enabled); err != nil {
				return err
			}
		}
	}

	if o.S3IsHTTPEnabled != nil {

		// query param s3.is_http_enabled
		var qrS3IsHTTPEnabled bool

		if o.S3IsHTTPEnabled != nil {
			qrS3IsHTTPEnabled = *o.S3IsHTTPEnabled
		}
		qS3IsHTTPEnabled := swag.FormatBool(qrS3IsHTTPEnabled)
		if qS3IsHTTPEnabled != "" {

			if err := r.SetQueryParam("s3.is_http_enabled", qS3IsHTTPEnabled); err != nil {
				return err
			}
		}
	}

	if o.S3IsHTTPSEnabled != nil {

		// query param s3.is_https_enabled
		var qrS3IsHTTPSEnabled bool

		if o.S3IsHTTPSEnabled != nil {
			qrS3IsHTTPSEnabled = *o.S3IsHTTPSEnabled
		}
		qS3IsHTTPSEnabled := swag.FormatBool(qrS3IsHTTPSEnabled)
		if qS3IsHTTPSEnabled != "" {

			if err := r.SetQueryParam("s3.is_https_enabled", qS3IsHTTPSEnabled); err != nil {
				return err
			}
		}
	}

	if o.S3Name != nil {

		// query param s3.name
		var qrS3Name string

		if o.S3Name != nil {
			qrS3Name = *o.S3Name
		}
		qS3Name := qrS3Name
		if qS3Name != "" {

			if err := r.SetQueryParam("s3.name", qS3Name); err != nil {
				return err
			}
		}
	}

	if o.S3Port != nil {

		// query param s3.port
		var qrS3Port int64

		if o.S3Port != nil {
			qrS3Port = *o.S3Port
		}
		qS3Port := swag.FormatInt64(qrS3Port)
		if qS3Port != "" {

			if err := r.SetQueryParam("s3.port", qS3Port); err != nil {
				return err
			}
		}
	}

	if o.S3SecurePort != nil {

		// query param s3.secure_port
		var qrS3SecurePort int64

		if o.S3SecurePort != nil {
			qrS3SecurePort = *o.S3SecurePort
		}
		qS3SecurePort := swag.FormatInt64(qrS3SecurePort)
		if qS3SecurePort != "" {

			if err := r.SetQueryParam("s3.secure_port", qS3SecurePort); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.SnapshotAutodeleteEnabled != nil {

		// query param snapshot_autodelete_enabled
		var qrSnapshotAutodeleteEnabled bool

		if o.SnapshotAutodeleteEnabled != nil {
			qrSnapshotAutodeleteEnabled = *o.SnapshotAutodeleteEnabled
		}
		qSnapshotAutodeleteEnabled := swag.FormatBool(qrSnapshotAutodeleteEnabled)
		if qSnapshotAutodeleteEnabled != "" {

			if err := r.SetQueryParam("snapshot_autodelete_enabled", qSnapshotAutodeleteEnabled); err != nil {
				return err
			}
		}
	}

	if o.SnapshotPolicyName != nil {

		// query param snapshot_policy.name
		var qrSnapshotPolicyName string

		if o.SnapshotPolicyName != nil {
			qrSnapshotPolicyName = *o.SnapshotPolicyName
		}
		qSnapshotPolicyName := qrSnapshotPolicyName
		if qSnapshotPolicyName != "" {

			if err := r.SetQueryParam("snapshot_policy.name", qSnapshotPolicyName); err != nil {
				return err
			}
		}
	}

	if o.SnapshotPolicyUUID != nil {

		// query param snapshot_policy.uuid
		var qrSnapshotPolicyUUID string

		if o.SnapshotPolicyUUID != nil {
			qrSnapshotPolicyUUID = *o.SnapshotPolicyUUID
		}
		qSnapshotPolicyUUID := qrSnapshotPolicyUUID
		if qSnapshotPolicyUUID != "" {

			if err := r.SetQueryParam("snapshot_policy.uuid", qSnapshotPolicyUUID); err != nil {
				return err
			}
		}
	}

	if o.SnapshotReservePercent != nil {

		// query param snapshot_reserve_percent
		var qrSnapshotReservePercent int64

		if o.SnapshotReservePercent != nil {
			qrSnapshotReservePercent = *o.SnapshotReservePercent
		}
		qSnapshotReservePercent := swag.FormatInt64(qrSnapshotReservePercent)
		if qSnapshotReservePercent != "" {

			if err := r.SetQueryParam("snapshot_reserve_percent", qSnapshotReservePercent); err != nil {
				return err
			}
		}
	}

	if o.State != nil {

		// query param state
		var qrState string

		if o.State != nil {
			qrState = *o.State
		}
		qState := qrState
		if qState != "" {

			if err := r.SetQueryParam("state", qState); err != nil {
				return err
			}
		}
	}

	if o.StorageAllocated != nil {

		// query param storage.allocated
		var qrStorageAllocated int64

		if o.StorageAllocated != nil {
			qrStorageAllocated = *o.StorageAllocated
		}
		qStorageAllocated := swag.FormatInt64(qrStorageAllocated)
		if qStorageAllocated != "" {

			if err := r.SetQueryParam("storage.allocated", qStorageAllocated); err != nil {
				return err
			}
		}
	}

	if o.StorageAvailable != nil {

		// query param storage.available
		var qrStorageAvailable int64

		if o.StorageAvailable != nil {
			qrStorageAvailable = *o.StorageAvailable
		}
		qStorageAvailable := swag.FormatInt64(qrStorageAvailable)
		if qStorageAvailable != "" {

			if err := r.SetQueryParam("storage.available", qStorageAvailable); err != nil {
				return err
			}
		}
	}

	if o.StorageLimit != nil {

		// query param storage.limit
		var qrStorageLimit int64

		if o.StorageLimit != nil {
			qrStorageLimit = *o.StorageLimit
		}
		qStorageLimit := swag.FormatInt64(qrStorageLimit)
		if qStorageLimit != "" {

			if err := r.SetQueryParam("storage.limit", qStorageLimit); err != nil {
				return err
			}
		}
	}

	if o.StorageLimitThresholdAlert != nil {

		// query param storage.limit_threshold_alert
		var qrStorageLimitThresholdAlert int64

		if o.StorageLimitThresholdAlert != nil {
			qrStorageLimitThresholdAlert = *o.StorageLimitThresholdAlert
		}
		qStorageLimitThresholdAlert := swag.FormatInt64(qrStorageLimitThresholdAlert)
		if qStorageLimitThresholdAlert != "" {

			if err := r.SetQueryParam("storage.limit_threshold_alert", qStorageLimitThresholdAlert); err != nil {
				return err
			}
		}
	}

	if o.StorageLimitThresholdExceeded != nil {

		// query param storage.limit_threshold_exceeded
		var qrStorageLimitThresholdExceeded int64

		if o.StorageLimitThresholdExceeded != nil {
			qrStorageLimitThresholdExceeded = *o.StorageLimitThresholdExceeded
		}
		qStorageLimitThresholdExceeded := swag.FormatInt64(qrStorageLimitThresholdExceeded)
		if qStorageLimitThresholdExceeded != "" {

			if err := r.SetQueryParam("storage.limit_threshold_exceeded", qStorageLimitThresholdExceeded); err != nil {
				return err
			}
		}
	}

	if o.StorageUsedPercentage != nil {

		// query param storage.used_percentage
		var qrStorageUsedPercentage int64

		if o.StorageUsedPercentage != nil {
			qrStorageUsedPercentage = *o.StorageUsedPercentage
		}
		qStorageUsedPercentage := swag.FormatInt64(qrStorageUsedPercentage)
		if qStorageUsedPercentage != "" {

			if err := r.SetQueryParam("storage.used_percentage", qStorageUsedPercentage); err != nil {
				return err
			}
		}
	}

	if o.Subtype != nil {

		// query param subtype
		var qrSubtype string

		if o.Subtype != nil {
			qrSubtype = *o.Subtype
		}
		qSubtype := qrSubtype
		if qSubtype != "" {

			if err := r.SetQueryParam("subtype", qSubtype); err != nil {
				return err
			}
		}
	}

	if o.TotalVolumeSizeInRecoveryQueue != nil {

		// query param total_volume_size_in_recovery_queue
		var qrTotalVolumeSizeInRecoveryQueue int64

		if o.TotalVolumeSizeInRecoveryQueue != nil {
			qrTotalVolumeSizeInRecoveryQueue = *o.TotalVolumeSizeInRecoveryQueue
		}
		qTotalVolumeSizeInRecoveryQueue := swag.FormatInt64(qrTotalVolumeSizeInRecoveryQueue)
		if qTotalVolumeSizeInRecoveryQueue != "" {

			if err := r.SetQueryParam("total_volume_size_in_recovery_queue", qTotalVolumeSizeInRecoveryQueue); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
