// Code generated by go-swagger; DO NOT EDIT.

package svm

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SvmModifyCollectionReader is a Reader for the SvmModifyCollection structure.
type SvmModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SvmModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSvmModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewSvmModifyCollectionAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSvmModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSvmModifyCollectionOK creates a SvmModifyCollectionOK with default headers values
func NewSvmModifyCollectionOK() *SvmModifyCollectionOK {
	return &SvmModifyCollectionOK{}
}

/*
SvmModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type SvmModifyCollectionOK struct {
	Payload *models.SvmJobLinkResponse
}

// IsSuccess returns true when this svm modify collection o k response has a 2xx status code
func (o *SvmModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this svm modify collection o k response has a 3xx status code
func (o *SvmModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this svm modify collection o k response has a 4xx status code
func (o *SvmModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this svm modify collection o k response has a 5xx status code
func (o *SvmModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this svm modify collection o k response a status code equal to that given
func (o *SvmModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the svm modify collection o k response
func (o *SvmModifyCollectionOK) Code() int {
	return 200
}

func (o *SvmModifyCollectionOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /svm/svms][%d] svmModifyCollectionOK %s", 200, payload)
}

func (o *SvmModifyCollectionOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /svm/svms][%d] svmModifyCollectionOK %s", 200, payload)
}

func (o *SvmModifyCollectionOK) GetPayload() *models.SvmJobLinkResponse {
	return o.Payload
}

func (o *SvmModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SvmJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSvmModifyCollectionAccepted creates a SvmModifyCollectionAccepted with default headers values
func NewSvmModifyCollectionAccepted() *SvmModifyCollectionAccepted {
	return &SvmModifyCollectionAccepted{}
}

/*
SvmModifyCollectionAccepted describes a response with status code 202, with default header values.

Accepted
*/
type SvmModifyCollectionAccepted struct {
	Payload *models.SvmJobLinkResponse
}

// IsSuccess returns true when this svm modify collection accepted response has a 2xx status code
func (o *SvmModifyCollectionAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this svm modify collection accepted response has a 3xx status code
func (o *SvmModifyCollectionAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this svm modify collection accepted response has a 4xx status code
func (o *SvmModifyCollectionAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this svm modify collection accepted response has a 5xx status code
func (o *SvmModifyCollectionAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this svm modify collection accepted response a status code equal to that given
func (o *SvmModifyCollectionAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the svm modify collection accepted response
func (o *SvmModifyCollectionAccepted) Code() int {
	return 202
}

func (o *SvmModifyCollectionAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /svm/svms][%d] svmModifyCollectionAccepted %s", 202, payload)
}

func (o *SvmModifyCollectionAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /svm/svms][%d] svmModifyCollectionAccepted %s", 202, payload)
}

func (o *SvmModifyCollectionAccepted) GetPayload() *models.SvmJobLinkResponse {
	return o.Payload
}

func (o *SvmModifyCollectionAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SvmJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSvmModifyCollectionDefault creates a SvmModifyCollectionDefault with default headers values
func NewSvmModifyCollectionDefault(code int) *SvmModifyCollectionDefault {
	return &SvmModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	SvmModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

<br/>
```
| Error codes | Description |
| ----------- | ----------- |
| 13434880    | Failed to modify SVM parameters. |
| 13434881    | Failed to rename SVM. |
| 13434883    | SVM parameters except name modified successfully. |
| 13434885    | Non-UTF8 language(s) not supported. |
| 13434886    | Invalid snapshot policy. |
| 13434902    | Modification of NSSwitch parameters failed for the SVM. |
| 13434906    | Operation not supported for an SVM of type sync-destination. |
| 12451843    | Certificate does not exist. |
| 13434908    | Invalid SVM name. The name is already in use by another SVM, IPSpace or cluster. |
| 13434916    | SVM is in the process of being created. Wait a few minutes, and then try the command again. |
| 13434915    | Failed to unlock the SVM because SVM create or delete job is in progress. Wait a few minutes, and then try the command again. |
| 13434911    | Invalid SVM name. Maximum supported length is 41 if SVM is of type \\\"sync-source\\\", otherwise 47. |
| 262179      | Unexpected argument \"storage_limit\". |<personalities supports=asar2>
| 13434935    | FCP, iSCSI and NVMe cannot be disabled or disallowed on this platform. |</personalities>
| 23724038    | Invalid source for the provided ns-switch database. |
| 2621779     | Operation not supported for an SVM of type data-engine. |
```
<br/>
*/
type SvmModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this svm modify collection default response has a 2xx status code
func (o *SvmModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this svm modify collection default response has a 3xx status code
func (o *SvmModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this svm modify collection default response has a 4xx status code
func (o *SvmModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this svm modify collection default response has a 5xx status code
func (o *SvmModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this svm modify collection default response a status code equal to that given
func (o *SvmModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the svm modify collection default response
func (o *SvmModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *SvmModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /svm/svms][%d] svm_modify_collection default %s", o._statusCode, payload)
}

func (o *SvmModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /svm/svms][%d] svm_modify_collection default %s", o._statusCode, payload)
}

func (o *SvmModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SvmModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
SvmModifyCollectionBody svm modify collection body
swagger:model SvmModifyCollectionBody
*/
type SvmModifyCollectionBody struct {

	// links
	Links *models.SvmInlineLinks `json:"_links,omitempty"`

	// This property is true when the administrator has delegated the aggregates for the SVM volumes.
	// Read Only: true
	AggregatesDelegated *bool `json:"aggregates_delegated,omitempty"`

	// Anti-ransomware related information for the SVM.
	AntiRansomware *models.ArwVserver `json:"anti_ransomware,omitempty"`

	// One of the many conditions to be satisfied to automatically switch the anti-ransomware state of the volumes in this SVM from “learning” (dry-run) to “enabled” is that no new file-extensions are observed in the volume in recent time. This parameter optionally specifies the recent time duration (in days) to be considered during which no new file-extension should be observed in a given volume to automatically switch the anti-ransomware state from “learning” to “enabled”. This field will no longer be supported in a future release.
	AntiRansomwareAutoSwitchDurationWithoutNewFileExtension *int64 `json:"anti_ransomware_auto_switch_duration_without_new_file_extension,omitempty"`

	// This property specifies whether anti-ransomware state of the volumes in this SVM are automatically switched by the system from “learning” (dry-run) to “enabled” (active) state after sufficient learning. This field will no longer be supported in a future release.
	AntiRansomwareAutoSwitchFromLearningToEnabled *bool `json:"anti_ransomware_auto_switch_from_learning_to_enabled,omitempty"`

	// One of the many conditions to be satisfied to automatically switch the anti-ransomware state of the volumes in this SVM from “learning” (dry-run) to “enabled” is that the volume should have a minimum file count in “learning” state. This parameter optionally specifies the minimum number of newly created files in “learning” state in a given volume to automatically switch the anti-ransomware state from “learning” to “enabled”. This field will no longer be supported in a future release.
	AntiRansomwareAutoSwitchMinimumFileCount *int64 `json:"anti_ransomware_auto_switch_minimum_file_count,omitempty"`

	// One of the many conditions to be satisfied to automatically switch the anti-ransomware state of the volumes in this SVM from “learning” (dry-run) to “enabled” is that the volume should have minimum number of file extensions in “learning” state. This parameter optionally specifies the minimum number of new file extensions in “learning” state in a given volume to automatically switch the anti-ransomware state from “learning” to “enabled”. This field will no longer be supported in a future release.
	AntiRansomwareAutoSwitchMinimumFileExtension *int64 `json:"anti_ransomware_auto_switch_minimum_file_extension,omitempty"`

	// One of the many conditions to be satisfied to automatically switch the anti-ransomware state of the volumes in this SVM from “learning” (dry-run) to “enabled” is that the volume should have sufficient data ingested to do the learning. This parameter optionally specifies the minimum amount of data (in GB) to be written to a given volume during the learning period to automatically switch the anti-ransomware state from “learning” to “enabled”. The amount of data considered as ingested also includes the data that is deleted or overwritten after ingestion. This field will no longer be supported in a future release.
	AntiRansomwareAutoSwitchMinimumIncomingData *string `json:"anti_ransomware_auto_switch_minimum_incoming_data,omitempty"`

	// One of the many conditions to be satisfied to automatically switch the anti-ransomware state of the volumes in this SVM from “learning” (dry-run) to “enabled” is that the volume should be in “learning” state for sufficient time period. This parameter optionally specifies the minimum number of days a given volume should be in “learning” state to automatically switch the anti-ransomware state from “learning” to “enabled”. This field will no longer be supported in a future release.
	AntiRansomwareAutoSwitchMinimumLearningPeriod *int64 `json:"anti_ransomware_auto_switch_minimum_learning_period,omitempty"`

	// Specifies the default anti-ransomware state of the volumes in the SVM. The default "anti_ransomware_default_volume_state" property is disabled for POST operations. If this value is "disabled", anti-ransomware protection is disabled by default on the new volumes that are created in the SVM. If this value is "dry_run", anti-ransomware protection is in learning mode by default on the new volumes that are created in the SVM.  When the anti-ransomware license is not present, this property is ignored and volumes will be created with the "disabled" state. This value "dry_run" will no longer be supported in a future release.
	// Enum: ["disabled","dry_run"]
	AntiRansomwareDefaultVolumeState *string `json:"anti_ransomware_default_volume_state,omitempty"`

	// One of the many conditions to be satisfied to automatically switch the anti-ransomware state of the volumes in this SVM from “learning” (dry-run) to “enabled” is that the volume should have sufficient data ingested to do the learning. This parameter optionally specifies the minimum amount of data (in GB) to be written to a given volume during the learning period to automatically switch the anti-ransomware state from “learning” to “enabled”. The amount of data considered as ingested also includes the data that is deleted or overwritten after ingestion. This field is no longer supported.
	AntiRansomwareIncomingWriteThreshold *string `json:"anti_ransomware_incoming_write_threshold,omitempty"`

	// One of the many conditions to be satisfied to automatically switch the anti-ransomware state of the volumes in this SVM from “learning” (dry-run) to “enabled” is that the volume should have sufficient data ingested to do the learning. This parameter optionally specifies the minimum amount of data (in percentage) to be written to a given volume during the learning period to automatically switch the anti-ransomware state from “learning” to “enabled”. The amount of data considered as ingested also includes the data that is deleted or overwritten after ingestion. This field will no longer be supported in a future release.
	AntiRansomwareIncomingWriteThresholdPercent *string `json:"anti_ransomware_incoming_write_threshold_percent,omitempty"`

	// Specifies whether volume activity tracking is automatically enabled on volumes that are created in the SVM.
	AutoEnableActivityTracking *bool `json:"auto_enable_activity_tracking,omitempty"`

	// Specifies whether file system analytics is automatically enabled on volumes that are created in the SVM.
	AutoEnableAnalytics *bool `json:"auto_enable_analytics,omitempty"`

	// certificate
	Certificate *models.SvmInlineCertificate `json:"certificate,omitempty"`

	// cifs
	Cifs *models.SvmInlineCifs `json:"cifs,omitempty"`

	// Comment
	// Max Length: 255
	// Min Length: 0
	Comment *string `json:"comment,omitempty"`

	// dns
	DNS *models.SvmInlineDNS `json:"dns,omitempty"`

	// fcp
	Fcp *models.SvmInlineFcp `json:"fcp,omitempty"`

	// ipspace
	Ipspace *models.SvmInlineIpspace `json:"ipspace,omitempty"`

	// Indicates whether logical space enforcement for the SVM is enabled.
	IsSpaceEnforcementLogical *bool `json:"is_space_enforcement_logical,omitempty"`

	// Indicates whether logical space reporting for the SVM is enabled.
	IsSpaceReportingLogical *bool `json:"is_space_reporting_logical,omitempty"`

	// iscsi
	Iscsi *models.SvmInlineIscsi `json:"iscsi,omitempty"`

	// Default volume language code. UTF-8 encoded languages are valid in POST or PATCH. Non UTF-8 language encodings are for backward compatibility and are not valid input for POST and PATCH requests.
	// Example: c.utf_8
	// Enum: ["c","da","de","en","en_us","es","fi","fr","he","it","ja","ja_jp.pck","ko","no","nl","pt","sv","zh","zh.gbk","zh_tw","zh_tw.big5","c.utf_8","ar","ar.utf_8","cs","cs.utf_8","da.utf_8","de.utf_8","en.utf_8","en_us.utf_8","es.utf_8","fi.utf_8","fr.utf_8","he.utf_8","hr","hr.utf_8","hu","hu.utf_8","it.utf_8","ja.utf_8","ja_v1","ja_v1.utf_8","ja_jp.pck.utf_8","ja_jp.932","ja_jp.932.utf_8","ja_jp.pck_v2","ja_jp.pck_v2.utf_8","ko.utf_8","no.utf_8","nl.utf_8","pl","pl.utf_8","pt.utf_8","ro","ro.utf_8","ru","ru.utf_8","sk","sk.utf_8","sl","sl.utf_8","sv.utf_8","tr","tr.utf_8","zh.utf_8","zh.gbk.utf_8","zh_tw.utf_8","zh_tw.big5.utf_8","utf8mb4"]
	Language *string `json:"language,omitempty"`

	// ldap
	Ldap *models.SvmInlineLdap `json:"ldap,omitempty"`

	// This property is used by cluster administrator to specify the limit on maximum number of volumes allowed in the SVM. The value can be either the string "unlimited" or a number.
	MaxVolumes *string `json:"max_volumes,omitempty"`

	// The name of the SVM.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// ndmp
	Ndmp *models.SvmInlineNdmp `json:"ndmp,omitempty"`

	// nfs
	Nfs *models.SvmInlineNfs `json:"nfs,omitempty"`

	// nis
	Nis *models.SvmInlineNis `json:"nis,omitempty"`

	// nsswitch
	Nsswitch *models.SvmInlineNsswitch `json:"nsswitch,omitempty"`

	// Number of volumes in the recovery queue.
	// Read Only: true
	NumberOfVolumesInRecoveryQueue *int64 `json:"number_of_volumes_in_recovery_queue,omitempty"`

	// nvme
	Nvme *models.SvmInlineNvme `json:"nvme,omitempty"`

	// qos adaptive policy group template
	QosAdaptivePolicyGroupTemplate *models.SvmInlineQosAdaptivePolicyGroupTemplate `json:"qos_adaptive_policy_group_template,omitempty"`

	// qos policy
	QosPolicy *models.SvmInlineQosPolicy `json:"qos_policy,omitempty"`

	// qos policy group template
	QosPolicyGroupTemplate *models.SvmInlineQosPolicyGroupTemplate `json:"qos_policy_group_template,omitempty"`

	// s3
	S3 *models.SvmInlineS3 `json:"s3,omitempty"`

	// snapmirror
	Snapmirror *models.SvmInlineSnapmirror `json:"snapmirror,omitempty"`

	// Specifies whether snapshot autodelete is automatically enabled on storage units that are created in the SVM.
	SnapshotAutodeleteEnabled *bool `json:"snapshot_autodelete_enabled,omitempty"`

	// snapshot policy
	SnapshotPolicy *models.SvmInlineSnapshotPolicy `json:"snapshot_policy,omitempty"`

	// Specifies the amount of space reserved for snapshots on the storage units that are created in the SVM.
	SnapshotReservePercent *int64 `json:"snapshot_reserve_percent,omitempty"`

	// SVM State
	// Example: running
	// Enum: ["starting","running","stopping","stopped","deleting","initializing"]
	State *string `json:"state,omitempty"`

	// storage
	Storage *models.SvmInlineStorage `json:"storage,omitempty"`

	// SVM subtype. The SVM subtype sync_destination is created automatically when an SVM of subtype sync_source is created on the source MetroCluster cluster. A POST request with sync_destination as SVM subtype is invalid. SVM of subtype data_engine cannot be explicitly created by the admin and most management changes are not allowed on it.
	// Enum: ["default","dp_destination","sync_source","sync_destination","data_engine"]
	Subtype *string `json:"subtype,omitempty"`

	// List of allowed aggregates for SVM volumes. An administrator is allowed to create volumes on these aggregates.
	SvmInlineAggregates []*models.SvmInlineAggregatesInlineArrayItem `json:"aggregates,omitempty"`

	// FC Interface for the SVM
	SvmInlineFcInterfaces []*models.FcInterfaceSvm `json:"fc_interfaces,omitempty"`

	// IP interfaces for the SVM
	SvmInlineIPInterfaces []*models.IPInterfaceSvm `json:"ip_interfaces,omitempty"`

	// Optional array of routes for the SVM
	SvmInlineRoutes []*models.NetworkRouteForSvm `json:"routes,omitempty"`

	// svm response inline records
	SvmResponseInlineRecords []*models.Svm `json:"records,omitempty"`

	// Sum of the sizes of the volumes in the recovery queue.
	// Read Only: true
	TotalVolumeSizeInRecoveryQueue *int64 `json:"total_volume_size_in_recovery_queue,omitempty"`

	// The unique identifier of the SVM.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this svm modify collection body
func (o *SvmModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateAntiRansomware(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateAntiRansomwareDefaultVolumeState(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateCertificate(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateCifs(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateComment(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateDNS(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateFcp(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateIpspace(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateIscsi(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLanguage(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLdap(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNdmp(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNfs(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNis(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNsswitch(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNvme(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateQosAdaptivePolicyGroupTemplate(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateQosPolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateQosPolicyGroupTemplate(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateS3(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSnapmirror(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSnapshotPolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStorage(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSubtype(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSvmInlineAggregates(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSvmInlineFcInterfaces(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSvmInlineIPInterfaces(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSvmInlineRoutes(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSvmResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *SvmModifyCollectionBody) validateAntiRansomware(formats strfmt.Registry) error {
	if swag.IsZero(o.AntiRansomware) { // not required
		return nil
	}

	if o.AntiRansomware != nil {
		if err := o.AntiRansomware.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "anti_ransomware")
			}
			return err
		}
	}

	return nil
}

var svmModifyCollectionBodyTypeAntiRansomwareDefaultVolumeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["disabled","dry_run"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		svmModifyCollectionBodyTypeAntiRansomwareDefaultVolumeStatePropEnum = append(svmModifyCollectionBodyTypeAntiRansomwareDefaultVolumeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// SvmModifyCollectionBody
	// SvmModifyCollectionBody
	// anti_ransomware_default_volume_state
	// AntiRansomwareDefaultVolumeState
	// disabled
	// END DEBUGGING
	// SvmModifyCollectionBodyAntiRansomwareDefaultVolumeStateDisabled captures enum value "disabled"
	SvmModifyCollectionBodyAntiRansomwareDefaultVolumeStateDisabled string = "disabled"

	// BEGIN DEBUGGING
	// SvmModifyCollectionBody
	// SvmModifyCollectionBody
	// anti_ransomware_default_volume_state
	// AntiRansomwareDefaultVolumeState
	// dry_run
	// END DEBUGGING
	// SvmModifyCollectionBodyAntiRansomwareDefaultVolumeStateDryRun captures enum value "dry_run"
	SvmModifyCollectionBodyAntiRansomwareDefaultVolumeStateDryRun string = "dry_run"
)

// prop value enum
func (o *SvmModifyCollectionBody) validateAntiRansomwareDefaultVolumeStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, svmModifyCollectionBodyTypeAntiRansomwareDefaultVolumeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *SvmModifyCollectionBody) validateAntiRansomwareDefaultVolumeState(formats strfmt.Registry) error {
	if swag.IsZero(o.AntiRansomwareDefaultVolumeState) { // not required
		return nil
	}

	// value enum
	if err := o.validateAntiRansomwareDefaultVolumeStateEnum("info"+"."+"anti_ransomware_default_volume_state", "body", *o.AntiRansomwareDefaultVolumeState); err != nil {
		return err
	}

	return nil
}

func (o *SvmModifyCollectionBody) validateCertificate(formats strfmt.Registry) error {
	if swag.IsZero(o.Certificate) { // not required
		return nil
	}

	if o.Certificate != nil {
		if err := o.Certificate.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "certificate")
			}
			return err
		}
	}

	return nil
}

func (o *SvmModifyCollectionBody) validateCifs(formats strfmt.Registry) error {
	if swag.IsZero(o.Cifs) { // not required
		return nil
	}

	if o.Cifs != nil {
		if err := o.Cifs.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "cifs")
			}
			return err
		}
	}

	return nil
}

func (o *SvmModifyCollectionBody) validateComment(formats strfmt.Registry) error {
	if swag.IsZero(o.Comment) { // not required
		return nil
	}

	if err := validate.MinLength("info"+"."+"comment", "body", *o.Comment, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("info"+"."+"comment", "body", *o.Comment, 255); err != nil {
		return err
	}

	return nil
}

func (o *SvmModifyCollectionBody) validateDNS(formats strfmt.Registry) error {
	if swag.IsZero(o.DNS) { // not required
		return nil
	}

	if o.DNS != nil {
		if err := o.DNS.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "dns")
			}
			return err
		}
	}

	return nil
}

func (o *SvmModifyCollectionBody) validateFcp(formats strfmt.Registry) error {
	if swag.IsZero(o.Fcp) { // not required
		return nil
	}

	if o.Fcp != nil {
		if err := o.Fcp.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "fcp")
			}
			return err
		}
	}

	return nil
}

func (o *SvmModifyCollectionBody) validateIpspace(formats strfmt.Registry) error {
	if swag.IsZero(o.Ipspace) { // not required
		return nil
	}

	if o.Ipspace != nil {
		if err := o.Ipspace.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "ipspace")
			}
			return err
		}
	}

	return nil
}

func (o *SvmModifyCollectionBody) validateIscsi(formats strfmt.Registry) error {
	if swag.IsZero(o.Iscsi) { // not required
		return nil
	}

	if o.Iscsi != nil {
		if err := o.Iscsi.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "iscsi")
			}
			return err
		}
	}

	return nil
}

var svmModifyCollectionBodyTypeLanguagePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["c","da","de","en","en_us","es","fi","fr","he","it","ja","ja_jp.pck","ko","no","nl","pt","sv","zh","zh.gbk","zh_tw","zh_tw.big5","c.utf_8","ar","ar.utf_8","cs","cs.utf_8","da.utf_8","de.utf_8","en.utf_8","en_us.utf_8","es.utf_8","fi.utf_8","fr.utf_8","he.utf_8","hr","hr.utf_8","hu","hu.utf_8","it.utf_8","ja.utf_8","ja_v1","ja_v1.utf_8","ja_jp.pck.utf_8","ja_jp.932","ja_jp.932.utf_8","ja_jp.pck_v2","ja_jp.pck_v2.utf_8","ko.utf_8","no.utf_8","nl.utf_8","pl","pl.utf_8","pt.utf_8","ro","ro.utf_8","ru","ru.utf_8","sk","sk.utf_8","sl","sl.utf_8","sv.utf_8","tr","tr.utf_8","zh.utf_8","zh.gbk.utf_8","zh_tw.utf_8","zh_tw.big5.utf_8","utf8mb4"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		svmModifyCollectionBodyTypeLanguagePropEnum = append(svmModifyCollectionBodyTypeLanguagePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// SvmModifyCollectionBody
	// SvmModifyCollectionBody
	// language
	// Language
	// c
	// END DEBUGGING
	// SvmModifyCollectionBodyLanguageC captures enum value "c"
	SvmModifyCollectionBodyLanguageC string = "c"

	// BEGIN DEBUGGING
	// SvmModifyCollectionBody
	// SvmModifyCollectionBody
	// language
	// Language
	// da
	// END DEBUGGING
	// SvmModifyCollectionBodyLanguageDa captures enum value "da"
	SvmModifyCollectionBodyLanguageDa string = "da"

	// BEGIN DEBUGGING
	// SvmModifyCollectionBody
	// SvmModifyCollectionBody
	// language
	// Language
	// de
	// END DEBUGGING
	// SvmModifyCollectionBodyLanguageDe captures enum value "de"
	SvmModifyCollectionBodyLanguageDe string = "de"

	// BEGIN DEBUGGING
	// SvmModifyCollectionBody
	// SvmModifyCollectionBody
	// language
	// Language
	// en
	// END DEBUGGING
	// SvmModifyCollectionBodyLanguageEn captures enum value "en"
	SvmModifyCollectionBodyLanguageEn string = "en"

	// BEGIN DEBUGGING
	// SvmModifyCollectionBody
	// SvmModifyCollectionBody
	// language
	// Language
	// en_us
	// END DEBUGGING
	// SvmModifyCollectionBodyLanguageEnUs captures enum value "en_us"
	SvmModifyCollectionBodyLanguageEnUs string = "en_us"

	// BEGIN DEBUGGING
	// SvmModifyCollectionBody
	// SvmModifyCollectionBody
	// language
	// Language
	// es
	// END DEBUGGING
	// SvmModifyCollectionBodyLanguageEs captures enum value "es"
	SvmModifyCollectionBodyLanguageEs string = "es"

	// BEGIN DEBUGGING
	// SvmModifyCollectionBody
	// SvmModifyCollectionBody
	// language
	// Language
	// fi
	// END DEBUGGING
	// SvmModifyCollectionBodyLanguageFi captures enum value "fi"
	SvmModifyCollectionBodyLanguageFi string = "fi"

	// BEGIN DEBUGGING
	// SvmModifyCollectionBody
	// SvmModifyCollectionBody
	// language
	// Language
	// fr
	// END DEBUGGING
	// SvmModifyCollectionBodyLanguageFr captures enum value "fr"
	SvmModifyCollectionBodyLanguageFr string = "fr"

	// BEGIN DEBUGGING
	// SvmModifyCollectionBody
	// SvmModifyCollectionBody
	// language
	// Language
	// he
	// END DEBUGGING
	// SvmModifyCollectionBodyLanguageHe captures enum value "he"
	SvmModifyCollectionBodyLanguageHe string = "he"

	// BEGIN DEBUGGING
	// SvmModifyCollectionBody
	// SvmModifyCollectionBody
	// language
	// Language
	// it
	// END DEBUGGING
	// SvmModifyCollectionBodyLanguageIt captures enum value "it"
	SvmModifyCollectionBodyLanguageIt string = "it"

	// BEGIN DEBUGGING
	// SvmModifyCollectionBody
	// SvmModifyCollectionBody
	// language
	// Language
	// ja
	// END DEBUGGING
	// SvmModifyCollectionBodyLanguageJa captures enum value "ja"
	SvmModifyCollectionBodyLanguageJa string = "ja"

	// BEGIN DEBUGGING
	// SvmModifyCollectionBody
	// SvmModifyCollectionBody
	// language
	// Language
	// ja_jp.pck
	// END DEBUGGING
	// SvmModifyCollectionBodyLanguageJaJpDotPck captures enum value "ja_jp.pck"
	SvmModifyCollectionBodyLanguageJaJpDotPck string = "ja_jp.pck"

	// BEGIN DEBUGGING
	// SvmModifyCollectionBody
	// SvmModifyCollectionBody
	// language
	// Language
	// ko
	// END DEBUGGING
	// SvmModifyCollectionBodyLanguageKo captures enum value "ko"
	SvmModifyCollectionBodyLanguageKo string = "ko"

	// BEGIN DEBUGGING
	// SvmModifyCollectionBody
	// SvmModifyCollectionBody
	// language
	// Language
	// no
	// END DEBUGGING
	// SvmModifyCollectionBodyLanguageNo captures enum value "no"
	SvmModifyCollectionBodyLanguageNo string = "no"

	// BEGIN DEBUGGING
	// SvmModifyCollectionBody
	// SvmModifyCollectionBody
	// language
	// Language
	// nl
	// END DEBUGGING
	// SvmModifyCollectionBodyLanguageNl captures enum value "nl"
	SvmModifyCollectionBodyLanguageNl string = "nl"

	// BEGIN DEBUGGING
	// SvmModifyCollectionBody
	// SvmModifyCollectionBody
	// language
	// Language
	// pt
	// END DEBUGGING
	// SvmModifyCollectionBodyLanguagePt captures enum value "pt"
	SvmModifyCollectionBodyLanguagePt string = "pt"

	// BEGIN DEBUGGING
	// SvmModifyCollectionBody
	// SvmModifyCollectionBody
	// language
	// Language
	// sv
	// END DEBUGGING
	// SvmModifyCollectionBodyLanguageSv captures enum value "sv"
	SvmModifyCollectionBodyLanguageSv string = "sv"

	// BEGIN DEBUGGING
	// SvmModifyCollectionBody
	// SvmModifyCollectionBody
	// language
	// Language
	// zh
	// END DEBUGGING
	// SvmModifyCollectionBodyLanguageZh captures enum value "zh"
	SvmModifyCollectionBodyLanguageZh string = "zh"

	// BEGIN DEBUGGING
	// SvmModifyCollectionBody
	// SvmModifyCollectionBody
	// language
	// Language
	// zh.gbk
	// END DEBUGGING
	// SvmModifyCollectionBodyLanguageZhDotGbk captures enum value "zh.gbk"
	SvmModifyCollectionBodyLanguageZhDotGbk string = "zh.gbk"

	// BEGIN DEBUGGING
	// SvmModifyCollectionBody
	// SvmModifyCollectionBody
	// language
	// Language
	// zh_tw
	// END DEBUGGING
	// SvmModifyCollectionBodyLanguageZhTw captures enum value "zh_tw"
	SvmModifyCollectionBodyLanguageZhTw string = "zh_tw"

	// BEGIN DEBUGGING
	// SvmModifyCollectionBody
	// SvmModifyCollectionBody
	// language
	// Language
	// zh_tw.big5
	// END DEBUGGING
	// SvmModifyCollectionBodyLanguageZhTwDotBig5 captures enum value "zh_tw.big5"
	SvmModifyCollectionBodyLanguageZhTwDotBig5 string = "zh_tw.big5"

	// BEGIN DEBUGGING
	// SvmModifyCollectionBody
	// SvmModifyCollectionBody
	// language
	// Language
	// c.utf_8
	// END DEBUGGING
	// SvmModifyCollectionBodyLanguageCDotUTF8 captures enum value "c.utf_8"
	SvmModifyCollectionBodyLanguageCDotUTF8 string = "c.utf_8"

	// BEGIN DEBUGGING
	// SvmModifyCollectionBody
	// SvmModifyCollectionBody
	// language
	// Language
	// ar
	// END DEBUGGING
	// SvmModifyCollectionBodyLanguageAr captures enum value "ar"
	SvmModifyCollectionBodyLanguageAr string = "ar"

	// BEGIN DEBUGGING
	// SvmModifyCollectionBody
	// SvmModifyCollectionBody
	// language
	// Language
	// ar.utf_8
	// END DEBUGGING
	// SvmModifyCollectionBodyLanguageArDotUTF8 captures enum value "ar.utf_8"
	SvmModifyCollectionBodyLanguageArDotUTF8 string = "ar.utf_8"

	// BEGIN DEBUGGING
	// SvmModifyCollectionBody
	// SvmModifyCollectionBody
	// language
	// Language
	// cs
	// END DEBUGGING
	// SvmModifyCollectionBodyLanguageCs captures enum value "cs"
	SvmModifyCollectionBodyLanguageCs string = "cs"

	// BEGIN DEBUGGING
	// SvmModifyCollectionBody
	// SvmModifyCollectionBody
	// language
	// Language
	// cs.utf_8
	// END DEBUGGING
	// SvmModifyCollectionBodyLanguageCsDotUTF8 captures enum value "cs.utf_8"
	SvmModifyCollectionBodyLanguageCsDotUTF8 string = "cs.utf_8"

	// BEGIN DEBUGGING
	// SvmModifyCollectionBody
	// SvmModifyCollectionBody
	// language
	// Language
	// da.utf_8
	// END DEBUGGING
	// SvmModifyCollectionBodyLanguageDaDotUTF8 captures enum value "da.utf_8"
	SvmModifyCollectionBodyLanguageDaDotUTF8 string = "da.utf_8"

	// BEGIN DEBUGGING
	// SvmModifyCollectionBody
	// SvmModifyCollectionBody
	// language
	// Language
	// de.utf_8
	// END DEBUGGING
	// SvmModifyCollectionBodyLanguageDeDotUTF8 captures enum value "de.utf_8"
	SvmModifyCollectionBodyLanguageDeDotUTF8 string = "de.utf_8"

	// BEGIN DEBUGGING
	// SvmModifyCollectionBody
	// SvmModifyCollectionBody
	// language
	// Language
	// en.utf_8
	// END DEBUGGING
	// SvmModifyCollectionBodyLanguageEnDotUTF8 captures enum value "en.utf_8"
	SvmModifyCollectionBodyLanguageEnDotUTF8 string = "en.utf_8"

	// BEGIN DEBUGGING
	// SvmModifyCollectionBody
	// SvmModifyCollectionBody
	// language
	// Language
	// en_us.utf_8
	// END DEBUGGING
	// SvmModifyCollectionBodyLanguageEnUsDotUTF8 captures enum value "en_us.utf_8"
	SvmModifyCollectionBodyLanguageEnUsDotUTF8 string = "en_us.utf_8"

	// BEGIN DEBUGGING
	// SvmModifyCollectionBody
	// SvmModifyCollectionBody
	// language
	// Language
	// es.utf_8
	// END DEBUGGING
	// SvmModifyCollectionBodyLanguageEsDotUTF8 captures enum value "es.utf_8"
	SvmModifyCollectionBodyLanguageEsDotUTF8 string = "es.utf_8"

	// BEGIN DEBUGGING
	// SvmModifyCollectionBody
	// SvmModifyCollectionBody
	// language
	// Language
	// fi.utf_8
	// END DEBUGGING
	// SvmModifyCollectionBodyLanguageFiDotUTF8 captures enum value "fi.utf_8"
	SvmModifyCollectionBodyLanguageFiDotUTF8 string = "fi.utf_8"

	// BEGIN DEBUGGING
	// SvmModifyCollectionBody
	// SvmModifyCollectionBody
	// language
	// Language
	// fr.utf_8
	// END DEBUGGING
	// SvmModifyCollectionBodyLanguageFrDotUTF8 captures enum value "fr.utf_8"
	SvmModifyCollectionBodyLanguageFrDotUTF8 string = "fr.utf_8"

	// BEGIN DEBUGGING
	// SvmModifyCollectionBody
	// SvmModifyCollectionBody
	// language
	// Language
	// he.utf_8
	// END DEBUGGING
	// SvmModifyCollectionBodyLanguageHeDotUTF8 captures enum value "he.utf_8"
	SvmModifyCollectionBodyLanguageHeDotUTF8 string = "he.utf_8"

	// BEGIN DEBUGGING
	// SvmModifyCollectionBody
	// SvmModifyCollectionBody
	// language
	// Language
	// hr
	// END DEBUGGING
	// SvmModifyCollectionBodyLanguageHr captures enum value "hr"
	SvmModifyCollectionBodyLanguageHr string = "hr"

	// BEGIN DEBUGGING
	// SvmModifyCollectionBody
	// SvmModifyCollectionBody
	// language
	// Language
	// hr.utf_8
	// END DEBUGGING
	// SvmModifyCollectionBodyLanguageHrDotUTF8 captures enum value "hr.utf_8"
	SvmModifyCollectionBodyLanguageHrDotUTF8 string = "hr.utf_8"

	// BEGIN DEBUGGING
	// SvmModifyCollectionBody
	// SvmModifyCollectionBody
	// language
	// Language
	// hu
	// END DEBUGGING
	// SvmModifyCollectionBodyLanguageHu captures enum value "hu"
	SvmModifyCollectionBodyLanguageHu string = "hu"

	// BEGIN DEBUGGING
	// SvmModifyCollectionBody
	// SvmModifyCollectionBody
	// language
	// Language
	// hu.utf_8
	// END DEBUGGING
	// SvmModifyCollectionBodyLanguageHuDotUTF8 captures enum value "hu.utf_8"
	SvmModifyCollectionBodyLanguageHuDotUTF8 string = "hu.utf_8"

	// BEGIN DEBUGGING
	// SvmModifyCollectionBody
	// SvmModifyCollectionBody
	// language
	// Language
	// it.utf_8
	// END DEBUGGING
	// SvmModifyCollectionBodyLanguageItDotUTF8 captures enum value "it.utf_8"
	SvmModifyCollectionBodyLanguageItDotUTF8 string = "it.utf_8"

	// BEGIN DEBUGGING
	// SvmModifyCollectionBody
	// SvmModifyCollectionBody
	// language
	// Language
	// ja.utf_8
	// END DEBUGGING
	// SvmModifyCollectionBodyLanguageJaDotUTF8 captures enum value "ja.utf_8"
	SvmModifyCollectionBodyLanguageJaDotUTF8 string = "ja.utf_8"

	// BEGIN DEBUGGING
	// SvmModifyCollectionBody
	// SvmModifyCollectionBody
	// language
	// Language
	// ja_v1
	// END DEBUGGING
	// SvmModifyCollectionBodyLanguageJaV1 captures enum value "ja_v1"
	SvmModifyCollectionBodyLanguageJaV1 string = "ja_v1"

	// BEGIN DEBUGGING
	// SvmModifyCollectionBody
	// SvmModifyCollectionBody
	// language
	// Language
	// ja_v1.utf_8
	// END DEBUGGING
	// SvmModifyCollectionBodyLanguageJaV1DotUTF8 captures enum value "ja_v1.utf_8"
	SvmModifyCollectionBodyLanguageJaV1DotUTF8 string = "ja_v1.utf_8"

	// BEGIN DEBUGGING
	// SvmModifyCollectionBody
	// SvmModifyCollectionBody
	// language
	// Language
	// ja_jp.pck.utf_8
	// END DEBUGGING
	// SvmModifyCollectionBodyLanguageJaJpDotPckDotUTF8 captures enum value "ja_jp.pck.utf_8"
	SvmModifyCollectionBodyLanguageJaJpDotPckDotUTF8 string = "ja_jp.pck.utf_8"

	// BEGIN DEBUGGING
	// SvmModifyCollectionBody
	// SvmModifyCollectionBody
	// language
	// Language
	// ja_jp.932
	// END DEBUGGING
	// SvmModifyCollectionBodyLanguageJaJpDot932 captures enum value "ja_jp.932"
	SvmModifyCollectionBodyLanguageJaJpDot932 string = "ja_jp.932"

	// BEGIN DEBUGGING
	// SvmModifyCollectionBody
	// SvmModifyCollectionBody
	// language
	// Language
	// ja_jp.932.utf_8
	// END DEBUGGING
	// SvmModifyCollectionBodyLanguageJaJpDot932DotUTF8 captures enum value "ja_jp.932.utf_8"
	SvmModifyCollectionBodyLanguageJaJpDot932DotUTF8 string = "ja_jp.932.utf_8"

	// BEGIN DEBUGGING
	// SvmModifyCollectionBody
	// SvmModifyCollectionBody
	// language
	// Language
	// ja_jp.pck_v2
	// END DEBUGGING
	// SvmModifyCollectionBodyLanguageJaJpDotPckV2 captures enum value "ja_jp.pck_v2"
	SvmModifyCollectionBodyLanguageJaJpDotPckV2 string = "ja_jp.pck_v2"

	// BEGIN DEBUGGING
	// SvmModifyCollectionBody
	// SvmModifyCollectionBody
	// language
	// Language
	// ja_jp.pck_v2.utf_8
	// END DEBUGGING
	// SvmModifyCollectionBodyLanguageJaJpDotPckV2DotUTF8 captures enum value "ja_jp.pck_v2.utf_8"
	SvmModifyCollectionBodyLanguageJaJpDotPckV2DotUTF8 string = "ja_jp.pck_v2.utf_8"

	// BEGIN DEBUGGING
	// SvmModifyCollectionBody
	// SvmModifyCollectionBody
	// language
	// Language
	// ko.utf_8
	// END DEBUGGING
	// SvmModifyCollectionBodyLanguageKoDotUTF8 captures enum value "ko.utf_8"
	SvmModifyCollectionBodyLanguageKoDotUTF8 string = "ko.utf_8"

	// BEGIN DEBUGGING
	// SvmModifyCollectionBody
	// SvmModifyCollectionBody
	// language
	// Language
	// no.utf_8
	// END DEBUGGING
	// SvmModifyCollectionBodyLanguageNoDotUTF8 captures enum value "no.utf_8"
	SvmModifyCollectionBodyLanguageNoDotUTF8 string = "no.utf_8"

	// BEGIN DEBUGGING
	// SvmModifyCollectionBody
	// SvmModifyCollectionBody
	// language
	// Language
	// nl.utf_8
	// END DEBUGGING
	// SvmModifyCollectionBodyLanguageNlDotUTF8 captures enum value "nl.utf_8"
	SvmModifyCollectionBodyLanguageNlDotUTF8 string = "nl.utf_8"

	// BEGIN DEBUGGING
	// SvmModifyCollectionBody
	// SvmModifyCollectionBody
	// language
	// Language
	// pl
	// END DEBUGGING
	// SvmModifyCollectionBodyLanguagePl captures enum value "pl"
	SvmModifyCollectionBodyLanguagePl string = "pl"

	// BEGIN DEBUGGING
	// SvmModifyCollectionBody
	// SvmModifyCollectionBody
	// language
	// Language
	// pl.utf_8
	// END DEBUGGING
	// SvmModifyCollectionBodyLanguagePlDotUTF8 captures enum value "pl.utf_8"
	SvmModifyCollectionBodyLanguagePlDotUTF8 string = "pl.utf_8"

	// BEGIN DEBUGGING
	// SvmModifyCollectionBody
	// SvmModifyCollectionBody
	// language
	// Language
	// pt.utf_8
	// END DEBUGGING
	// SvmModifyCollectionBodyLanguagePtDotUTF8 captures enum value "pt.utf_8"
	SvmModifyCollectionBodyLanguagePtDotUTF8 string = "pt.utf_8"

	// BEGIN DEBUGGING
	// SvmModifyCollectionBody
	// SvmModifyCollectionBody
	// language
	// Language
	// ro
	// END DEBUGGING
	// SvmModifyCollectionBodyLanguageRo captures enum value "ro"
	SvmModifyCollectionBodyLanguageRo string = "ro"

	// BEGIN DEBUGGING
	// SvmModifyCollectionBody
	// SvmModifyCollectionBody
	// language
	// Language
	// ro.utf_8
	// END DEBUGGING
	// SvmModifyCollectionBodyLanguageRoDotUTF8 captures enum value "ro.utf_8"
	SvmModifyCollectionBodyLanguageRoDotUTF8 string = "ro.utf_8"

	// BEGIN DEBUGGING
	// SvmModifyCollectionBody
	// SvmModifyCollectionBody
	// language
	// Language
	// ru
	// END DEBUGGING
	// SvmModifyCollectionBodyLanguageRu captures enum value "ru"
	SvmModifyCollectionBodyLanguageRu string = "ru"

	// BEGIN DEBUGGING
	// SvmModifyCollectionBody
	// SvmModifyCollectionBody
	// language
	// Language
	// ru.utf_8
	// END DEBUGGING
	// SvmModifyCollectionBodyLanguageRuDotUTF8 captures enum value "ru.utf_8"
	SvmModifyCollectionBodyLanguageRuDotUTF8 string = "ru.utf_8"

	// BEGIN DEBUGGING
	// SvmModifyCollectionBody
	// SvmModifyCollectionBody
	// language
	// Language
	// sk
	// END DEBUGGING
	// SvmModifyCollectionBodyLanguageSk captures enum value "sk"
	SvmModifyCollectionBodyLanguageSk string = "sk"

	// BEGIN DEBUGGING
	// SvmModifyCollectionBody
	// SvmModifyCollectionBody
	// language
	// Language
	// sk.utf_8
	// END DEBUGGING
	// SvmModifyCollectionBodyLanguageSkDotUTF8 captures enum value "sk.utf_8"
	SvmModifyCollectionBodyLanguageSkDotUTF8 string = "sk.utf_8"

	// BEGIN DEBUGGING
	// SvmModifyCollectionBody
	// SvmModifyCollectionBody
	// language
	// Language
	// sl
	// END DEBUGGING
	// SvmModifyCollectionBodyLanguageSl captures enum value "sl"
	SvmModifyCollectionBodyLanguageSl string = "sl"

	// BEGIN DEBUGGING
	// SvmModifyCollectionBody
	// SvmModifyCollectionBody
	// language
	// Language
	// sl.utf_8
	// END DEBUGGING
	// SvmModifyCollectionBodyLanguageSlDotUTF8 captures enum value "sl.utf_8"
	SvmModifyCollectionBodyLanguageSlDotUTF8 string = "sl.utf_8"

	// BEGIN DEBUGGING
	// SvmModifyCollectionBody
	// SvmModifyCollectionBody
	// language
	// Language
	// sv.utf_8
	// END DEBUGGING
	// SvmModifyCollectionBodyLanguageSvDotUTF8 captures enum value "sv.utf_8"
	SvmModifyCollectionBodyLanguageSvDotUTF8 string = "sv.utf_8"

	// BEGIN DEBUGGING
	// SvmModifyCollectionBody
	// SvmModifyCollectionBody
	// language
	// Language
	// tr
	// END DEBUGGING
	// SvmModifyCollectionBodyLanguageTr captures enum value "tr"
	SvmModifyCollectionBodyLanguageTr string = "tr"

	// BEGIN DEBUGGING
	// SvmModifyCollectionBody
	// SvmModifyCollectionBody
	// language
	// Language
	// tr.utf_8
	// END DEBUGGING
	// SvmModifyCollectionBodyLanguageTrDotUTF8 captures enum value "tr.utf_8"
	SvmModifyCollectionBodyLanguageTrDotUTF8 string = "tr.utf_8"

	// BEGIN DEBUGGING
	// SvmModifyCollectionBody
	// SvmModifyCollectionBody
	// language
	// Language
	// zh.utf_8
	// END DEBUGGING
	// SvmModifyCollectionBodyLanguageZhDotUTF8 captures enum value "zh.utf_8"
	SvmModifyCollectionBodyLanguageZhDotUTF8 string = "zh.utf_8"

	// BEGIN DEBUGGING
	// SvmModifyCollectionBody
	// SvmModifyCollectionBody
	// language
	// Language
	// zh.gbk.utf_8
	// END DEBUGGING
	// SvmModifyCollectionBodyLanguageZhDotGbkDotUTF8 captures enum value "zh.gbk.utf_8"
	SvmModifyCollectionBodyLanguageZhDotGbkDotUTF8 string = "zh.gbk.utf_8"

	// BEGIN DEBUGGING
	// SvmModifyCollectionBody
	// SvmModifyCollectionBody
	// language
	// Language
	// zh_tw.utf_8
	// END DEBUGGING
	// SvmModifyCollectionBodyLanguageZhTwDotUTF8 captures enum value "zh_tw.utf_8"
	SvmModifyCollectionBodyLanguageZhTwDotUTF8 string = "zh_tw.utf_8"

	// BEGIN DEBUGGING
	// SvmModifyCollectionBody
	// SvmModifyCollectionBody
	// language
	// Language
	// zh_tw.big5.utf_8
	// END DEBUGGING
	// SvmModifyCollectionBodyLanguageZhTwDotBig5DotUTF8 captures enum value "zh_tw.big5.utf_8"
	SvmModifyCollectionBodyLanguageZhTwDotBig5DotUTF8 string = "zh_tw.big5.utf_8"

	// BEGIN DEBUGGING
	// SvmModifyCollectionBody
	// SvmModifyCollectionBody
	// language
	// Language
	// utf8mb4
	// END DEBUGGING
	// SvmModifyCollectionBodyLanguageUtf8mb4 captures enum value "utf8mb4"
	SvmModifyCollectionBodyLanguageUtf8mb4 string = "utf8mb4"
)

// prop value enum
func (o *SvmModifyCollectionBody) validateLanguageEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, svmModifyCollectionBodyTypeLanguagePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *SvmModifyCollectionBody) validateLanguage(formats strfmt.Registry) error {
	if swag.IsZero(o.Language) { // not required
		return nil
	}

	// value enum
	if err := o.validateLanguageEnum("info"+"."+"language", "body", *o.Language); err != nil {
		return err
	}

	return nil
}

func (o *SvmModifyCollectionBody) validateLdap(formats strfmt.Registry) error {
	if swag.IsZero(o.Ldap) { // not required
		return nil
	}

	if o.Ldap != nil {
		if err := o.Ldap.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "ldap")
			}
			return err
		}
	}

	return nil
}

func (o *SvmModifyCollectionBody) validateNdmp(formats strfmt.Registry) error {
	if swag.IsZero(o.Ndmp) { // not required
		return nil
	}

	if o.Ndmp != nil {
		if err := o.Ndmp.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "ndmp")
			}
			return err
		}
	}

	return nil
}

func (o *SvmModifyCollectionBody) validateNfs(formats strfmt.Registry) error {
	if swag.IsZero(o.Nfs) { // not required
		return nil
	}

	if o.Nfs != nil {
		if err := o.Nfs.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "nfs")
			}
			return err
		}
	}

	return nil
}

func (o *SvmModifyCollectionBody) validateNis(formats strfmt.Registry) error {
	if swag.IsZero(o.Nis) { // not required
		return nil
	}

	if o.Nis != nil {
		if err := o.Nis.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "nis")
			}
			return err
		}
	}

	return nil
}

func (o *SvmModifyCollectionBody) validateNsswitch(formats strfmt.Registry) error {
	if swag.IsZero(o.Nsswitch) { // not required
		return nil
	}

	if o.Nsswitch != nil {
		if err := o.Nsswitch.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "nsswitch")
			}
			return err
		}
	}

	return nil
}

func (o *SvmModifyCollectionBody) validateNvme(formats strfmt.Registry) error {
	if swag.IsZero(o.Nvme) { // not required
		return nil
	}

	if o.Nvme != nil {
		if err := o.Nvme.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "nvme")
			}
			return err
		}
	}

	return nil
}

func (o *SvmModifyCollectionBody) validateQosAdaptivePolicyGroupTemplate(formats strfmt.Registry) error {
	if swag.IsZero(o.QosAdaptivePolicyGroupTemplate) { // not required
		return nil
	}

	if o.QosAdaptivePolicyGroupTemplate != nil {
		if err := o.QosAdaptivePolicyGroupTemplate.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "qos_adaptive_policy_group_template")
			}
			return err
		}
	}

	return nil
}

func (o *SvmModifyCollectionBody) validateQosPolicy(formats strfmt.Registry) error {
	if swag.IsZero(o.QosPolicy) { // not required
		return nil
	}

	if o.QosPolicy != nil {
		if err := o.QosPolicy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "qos_policy")
			}
			return err
		}
	}

	return nil
}

func (o *SvmModifyCollectionBody) validateQosPolicyGroupTemplate(formats strfmt.Registry) error {
	if swag.IsZero(o.QosPolicyGroupTemplate) { // not required
		return nil
	}

	if o.QosPolicyGroupTemplate != nil {
		if err := o.QosPolicyGroupTemplate.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "qos_policy_group_template")
			}
			return err
		}
	}

	return nil
}

func (o *SvmModifyCollectionBody) validateS3(formats strfmt.Registry) error {
	if swag.IsZero(o.S3) { // not required
		return nil
	}

	if o.S3 != nil {
		if err := o.S3.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "s3")
			}
			return err
		}
	}

	return nil
}

func (o *SvmModifyCollectionBody) validateSnapmirror(formats strfmt.Registry) error {
	if swag.IsZero(o.Snapmirror) { // not required
		return nil
	}

	if o.Snapmirror != nil {
		if err := o.Snapmirror.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "snapmirror")
			}
			return err
		}
	}

	return nil
}

func (o *SvmModifyCollectionBody) validateSnapshotPolicy(formats strfmt.Registry) error {
	if swag.IsZero(o.SnapshotPolicy) { // not required
		return nil
	}

	if o.SnapshotPolicy != nil {
		if err := o.SnapshotPolicy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "snapshot_policy")
			}
			return err
		}
	}

	return nil
}

var svmModifyCollectionBodyTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["starting","running","stopping","stopped","deleting","initializing"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		svmModifyCollectionBodyTypeStatePropEnum = append(svmModifyCollectionBodyTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// SvmModifyCollectionBody
	// SvmModifyCollectionBody
	// state
	// State
	// starting
	// END DEBUGGING
	// SvmModifyCollectionBodyStateStarting captures enum value "starting"
	SvmModifyCollectionBodyStateStarting string = "starting"

	// BEGIN DEBUGGING
	// SvmModifyCollectionBody
	// SvmModifyCollectionBody
	// state
	// State
	// running
	// END DEBUGGING
	// SvmModifyCollectionBodyStateRunning captures enum value "running"
	SvmModifyCollectionBodyStateRunning string = "running"

	// BEGIN DEBUGGING
	// SvmModifyCollectionBody
	// SvmModifyCollectionBody
	// state
	// State
	// stopping
	// END DEBUGGING
	// SvmModifyCollectionBodyStateStopping captures enum value "stopping"
	SvmModifyCollectionBodyStateStopping string = "stopping"

	// BEGIN DEBUGGING
	// SvmModifyCollectionBody
	// SvmModifyCollectionBody
	// state
	// State
	// stopped
	// END DEBUGGING
	// SvmModifyCollectionBodyStateStopped captures enum value "stopped"
	SvmModifyCollectionBodyStateStopped string = "stopped"

	// BEGIN DEBUGGING
	// SvmModifyCollectionBody
	// SvmModifyCollectionBody
	// state
	// State
	// deleting
	// END DEBUGGING
	// SvmModifyCollectionBodyStateDeleting captures enum value "deleting"
	SvmModifyCollectionBodyStateDeleting string = "deleting"

	// BEGIN DEBUGGING
	// SvmModifyCollectionBody
	// SvmModifyCollectionBody
	// state
	// State
	// initializing
	// END DEBUGGING
	// SvmModifyCollectionBodyStateInitializing captures enum value "initializing"
	SvmModifyCollectionBodyStateInitializing string = "initializing"
)

// prop value enum
func (o *SvmModifyCollectionBody) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, svmModifyCollectionBodyTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *SvmModifyCollectionBody) validateState(formats strfmt.Registry) error {
	if swag.IsZero(o.State) { // not required
		return nil
	}

	// value enum
	if err := o.validateStateEnum("info"+"."+"state", "body", *o.State); err != nil {
		return err
	}

	return nil
}

func (o *SvmModifyCollectionBody) validateStorage(formats strfmt.Registry) error {
	if swag.IsZero(o.Storage) { // not required
		return nil
	}

	if o.Storage != nil {
		if err := o.Storage.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "storage")
			}
			return err
		}
	}

	return nil
}

var svmModifyCollectionBodyTypeSubtypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["default","dp_destination","sync_source","sync_destination","data_engine"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		svmModifyCollectionBodyTypeSubtypePropEnum = append(svmModifyCollectionBodyTypeSubtypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// SvmModifyCollectionBody
	// SvmModifyCollectionBody
	// subtype
	// Subtype
	// default
	// END DEBUGGING
	// SvmModifyCollectionBodySubtypeDefault captures enum value "default"
	SvmModifyCollectionBodySubtypeDefault string = "default"

	// BEGIN DEBUGGING
	// SvmModifyCollectionBody
	// SvmModifyCollectionBody
	// subtype
	// Subtype
	// dp_destination
	// END DEBUGGING
	// SvmModifyCollectionBodySubtypeDpDestination captures enum value "dp_destination"
	SvmModifyCollectionBodySubtypeDpDestination string = "dp_destination"

	// BEGIN DEBUGGING
	// SvmModifyCollectionBody
	// SvmModifyCollectionBody
	// subtype
	// Subtype
	// sync_source
	// END DEBUGGING
	// SvmModifyCollectionBodySubtypeSyncSource captures enum value "sync_source"
	SvmModifyCollectionBodySubtypeSyncSource string = "sync_source"

	// BEGIN DEBUGGING
	// SvmModifyCollectionBody
	// SvmModifyCollectionBody
	// subtype
	// Subtype
	// sync_destination
	// END DEBUGGING
	// SvmModifyCollectionBodySubtypeSyncDestination captures enum value "sync_destination"
	SvmModifyCollectionBodySubtypeSyncDestination string = "sync_destination"

	// BEGIN DEBUGGING
	// SvmModifyCollectionBody
	// SvmModifyCollectionBody
	// subtype
	// Subtype
	// data_engine
	// END DEBUGGING
	// SvmModifyCollectionBodySubtypeDataEngine captures enum value "data_engine"
	SvmModifyCollectionBodySubtypeDataEngine string = "data_engine"
)

// prop value enum
func (o *SvmModifyCollectionBody) validateSubtypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, svmModifyCollectionBodyTypeSubtypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *SvmModifyCollectionBody) validateSubtype(formats strfmt.Registry) error {
	if swag.IsZero(o.Subtype) { // not required
		return nil
	}

	// value enum
	if err := o.validateSubtypeEnum("info"+"."+"subtype", "body", *o.Subtype); err != nil {
		return err
	}

	return nil
}

func (o *SvmModifyCollectionBody) validateSvmInlineAggregates(formats strfmt.Registry) error {
	if swag.IsZero(o.SvmInlineAggregates) { // not required
		return nil
	}

	for i := 0; i < len(o.SvmInlineAggregates); i++ {
		if swag.IsZero(o.SvmInlineAggregates[i]) { // not required
			continue
		}

		if o.SvmInlineAggregates[i] != nil {
			if err := o.SvmInlineAggregates[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "aggregates" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *SvmModifyCollectionBody) validateSvmInlineFcInterfaces(formats strfmt.Registry) error {
	if swag.IsZero(o.SvmInlineFcInterfaces) { // not required
		return nil
	}

	for i := 0; i < len(o.SvmInlineFcInterfaces); i++ {
		if swag.IsZero(o.SvmInlineFcInterfaces[i]) { // not required
			continue
		}

		if o.SvmInlineFcInterfaces[i] != nil {
			if err := o.SvmInlineFcInterfaces[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "fc_interfaces" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *SvmModifyCollectionBody) validateSvmInlineIPInterfaces(formats strfmt.Registry) error {
	if swag.IsZero(o.SvmInlineIPInterfaces) { // not required
		return nil
	}

	for i := 0; i < len(o.SvmInlineIPInterfaces); i++ {
		if swag.IsZero(o.SvmInlineIPInterfaces[i]) { // not required
			continue
		}

		if o.SvmInlineIPInterfaces[i] != nil {
			if err := o.SvmInlineIPInterfaces[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "ip_interfaces" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *SvmModifyCollectionBody) validateSvmInlineRoutes(formats strfmt.Registry) error {
	if swag.IsZero(o.SvmInlineRoutes) { // not required
		return nil
	}

	for i := 0; i < len(o.SvmInlineRoutes); i++ {
		if swag.IsZero(o.SvmInlineRoutes[i]) { // not required
			continue
		}

		if o.SvmInlineRoutes[i] != nil {
			if err := o.SvmInlineRoutes[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "routes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *SvmModifyCollectionBody) validateSvmResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.SvmResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.SvmResponseInlineRecords); i++ {
		if swag.IsZero(o.SvmResponseInlineRecords[i]) { // not required
			continue
		}

		if o.SvmResponseInlineRecords[i] != nil {
			if err := o.SvmResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this svm modify collection body based on the context it is used
func (o *SvmModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateAggregatesDelegated(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateAntiRansomware(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateCertificate(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateCifs(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateDNS(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateFcp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIpspace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIscsi(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLdap(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNdmp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNfs(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNis(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNsswitch(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNumberOfVolumesInRecoveryQueue(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNvme(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateQosAdaptivePolicyGroupTemplate(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateQosPolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateQosPolicyGroupTemplate(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateS3(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSnapmirror(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSnapshotPolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStorage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSvmInlineAggregates(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSvmInlineFcInterfaces(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSvmInlineIPInterfaces(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSvmInlineRoutes(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSvmResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTotalVolumeSizeInRecoveryQueue(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *SvmModifyCollectionBody) contextValidateAggregatesDelegated(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"aggregates_delegated", "body", o.AggregatesDelegated); err != nil {
		return err
	}

	return nil
}

func (o *SvmModifyCollectionBody) contextValidateAntiRansomware(ctx context.Context, formats strfmt.Registry) error {

	if o.AntiRansomware != nil {
		if err := o.AntiRansomware.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "anti_ransomware")
			}
			return err
		}
	}

	return nil
}

func (o *SvmModifyCollectionBody) contextValidateCertificate(ctx context.Context, formats strfmt.Registry) error {

	if o.Certificate != nil {
		if err := o.Certificate.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "certificate")
			}
			return err
		}
	}

	return nil
}

func (o *SvmModifyCollectionBody) contextValidateCifs(ctx context.Context, formats strfmt.Registry) error {

	if o.Cifs != nil {
		if err := o.Cifs.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "cifs")
			}
			return err
		}
	}

	return nil
}

func (o *SvmModifyCollectionBody) contextValidateDNS(ctx context.Context, formats strfmt.Registry) error {

	if o.DNS != nil {
		if err := o.DNS.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "dns")
			}
			return err
		}
	}

	return nil
}

func (o *SvmModifyCollectionBody) contextValidateFcp(ctx context.Context, formats strfmt.Registry) error {

	if o.Fcp != nil {
		if err := o.Fcp.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "fcp")
			}
			return err
		}
	}

	return nil
}

func (o *SvmModifyCollectionBody) contextValidateIpspace(ctx context.Context, formats strfmt.Registry) error {

	if o.Ipspace != nil {
		if err := o.Ipspace.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "ipspace")
			}
			return err
		}
	}

	return nil
}

func (o *SvmModifyCollectionBody) contextValidateIscsi(ctx context.Context, formats strfmt.Registry) error {

	if o.Iscsi != nil {
		if err := o.Iscsi.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "iscsi")
			}
			return err
		}
	}

	return nil
}

func (o *SvmModifyCollectionBody) contextValidateLdap(ctx context.Context, formats strfmt.Registry) error {

	if o.Ldap != nil {
		if err := o.Ldap.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "ldap")
			}
			return err
		}
	}

	return nil
}

func (o *SvmModifyCollectionBody) contextValidateNdmp(ctx context.Context, formats strfmt.Registry) error {

	if o.Ndmp != nil {
		if err := o.Ndmp.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "ndmp")
			}
			return err
		}
	}

	return nil
}

func (o *SvmModifyCollectionBody) contextValidateNfs(ctx context.Context, formats strfmt.Registry) error {

	if o.Nfs != nil {
		if err := o.Nfs.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "nfs")
			}
			return err
		}
	}

	return nil
}

func (o *SvmModifyCollectionBody) contextValidateNis(ctx context.Context, formats strfmt.Registry) error {

	if o.Nis != nil {
		if err := o.Nis.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "nis")
			}
			return err
		}
	}

	return nil
}

func (o *SvmModifyCollectionBody) contextValidateNsswitch(ctx context.Context, formats strfmt.Registry) error {

	if o.Nsswitch != nil {
		if err := o.Nsswitch.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "nsswitch")
			}
			return err
		}
	}

	return nil
}

func (o *SvmModifyCollectionBody) contextValidateNumberOfVolumesInRecoveryQueue(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"number_of_volumes_in_recovery_queue", "body", o.NumberOfVolumesInRecoveryQueue); err != nil {
		return err
	}

	return nil
}

func (o *SvmModifyCollectionBody) contextValidateNvme(ctx context.Context, formats strfmt.Registry) error {

	if o.Nvme != nil {
		if err := o.Nvme.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "nvme")
			}
			return err
		}
	}

	return nil
}

func (o *SvmModifyCollectionBody) contextValidateQosAdaptivePolicyGroupTemplate(ctx context.Context, formats strfmt.Registry) error {

	if o.QosAdaptivePolicyGroupTemplate != nil {
		if err := o.QosAdaptivePolicyGroupTemplate.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "qos_adaptive_policy_group_template")
			}
			return err
		}
	}

	return nil
}

func (o *SvmModifyCollectionBody) contextValidateQosPolicy(ctx context.Context, formats strfmt.Registry) error {

	if o.QosPolicy != nil {
		if err := o.QosPolicy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "qos_policy")
			}
			return err
		}
	}

	return nil
}

func (o *SvmModifyCollectionBody) contextValidateQosPolicyGroupTemplate(ctx context.Context, formats strfmt.Registry) error {

	if o.QosPolicyGroupTemplate != nil {
		if err := o.QosPolicyGroupTemplate.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "qos_policy_group_template")
			}
			return err
		}
	}

	return nil
}

func (o *SvmModifyCollectionBody) contextValidateS3(ctx context.Context, formats strfmt.Registry) error {

	if o.S3 != nil {
		if err := o.S3.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "s3")
			}
			return err
		}
	}

	return nil
}

func (o *SvmModifyCollectionBody) contextValidateSnapmirror(ctx context.Context, formats strfmt.Registry) error {

	if o.Snapmirror != nil {
		if err := o.Snapmirror.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "snapmirror")
			}
			return err
		}
	}

	return nil
}

func (o *SvmModifyCollectionBody) contextValidateSnapshotPolicy(ctx context.Context, formats strfmt.Registry) error {

	if o.SnapshotPolicy != nil {
		if err := o.SnapshotPolicy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "snapshot_policy")
			}
			return err
		}
	}

	return nil
}

func (o *SvmModifyCollectionBody) contextValidateStorage(ctx context.Context, formats strfmt.Registry) error {

	if o.Storage != nil {
		if err := o.Storage.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "storage")
			}
			return err
		}
	}

	return nil
}

func (o *SvmModifyCollectionBody) contextValidateSvmInlineAggregates(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.SvmInlineAggregates); i++ {

		if o.SvmInlineAggregates[i] != nil {
			if err := o.SvmInlineAggregates[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "aggregates" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *SvmModifyCollectionBody) contextValidateSvmInlineFcInterfaces(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.SvmInlineFcInterfaces); i++ {

		if o.SvmInlineFcInterfaces[i] != nil {
			if err := o.SvmInlineFcInterfaces[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "fc_interfaces" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *SvmModifyCollectionBody) contextValidateSvmInlineIPInterfaces(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.SvmInlineIPInterfaces); i++ {

		if o.SvmInlineIPInterfaces[i] != nil {
			if err := o.SvmInlineIPInterfaces[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "ip_interfaces" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *SvmModifyCollectionBody) contextValidateSvmInlineRoutes(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.SvmInlineRoutes); i++ {

		if o.SvmInlineRoutes[i] != nil {
			if err := o.SvmInlineRoutes[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "routes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *SvmModifyCollectionBody) contextValidateSvmResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.SvmResponseInlineRecords); i++ {

		if o.SvmResponseInlineRecords[i] != nil {
			if err := o.SvmResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *SvmModifyCollectionBody) contextValidateTotalVolumeSizeInRecoveryQueue(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"total_volume_size_in_recovery_queue", "body", o.TotalVolumeSizeInRecoveryQueue); err != nil {
		return err
	}

	return nil
}

func (o *SvmModifyCollectionBody) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SvmModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SvmModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res SvmModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SvmInlineLinks svm inline links
swagger:model svm_inline__links
*/
type SvmInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this svm inline links
func (o *SvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm inline links based on the context it is used
func (o *SvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SvmInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res SvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SvmInlineAggregatesInlineArrayItem svm inline aggregates inline array item
swagger:model svm_inline_aggregates_inline_array_item
*/
type SvmInlineAggregatesInlineArrayItem struct {

	// links
	Links *models.SvmInlineAggregatesInlineArrayItemInlineLinks `json:"_links,omitempty"`

	// Space available, in bytes.
	// Example: 10156560384
	// Read Only: true
	AvailableSize *int64 `json:"available_size,omitempty"`

	// name
	// Example: aggr1
	Name *string `json:"name,omitempty"`

	// SnapLock type.
	// Read Only: true
	// Enum: ["non_snaplock","compliance","enterprise"]
	SnaplockType *string `json:"snaplock_type,omitempty"`

	// Aggregate state.
	// Read Only: true
	// Enum: ["online","offline","unknown"]
	State *string `json:"state,omitempty"`

	// Type of aggregate.
	// Read Only: true
	// Enum: ["hdd","hybrid","lun","ssd","vmdisk"]
	Type *string `json:"type,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this svm inline aggregates inline array item
func (o *SvmInlineAggregatesInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSnaplockType(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmInlineAggregatesInlineArrayItem) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

var svmInlineAggregatesInlineArrayItemTypeSnaplockTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["non_snaplock","compliance","enterprise"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		svmInlineAggregatesInlineArrayItemTypeSnaplockTypePropEnum = append(svmInlineAggregatesInlineArrayItemTypeSnaplockTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// svm_inline_aggregates_inline_array_item
	// SvmInlineAggregatesInlineArrayItem
	// snaplock_type
	// SnaplockType
	// non_snaplock
	// END DEBUGGING
	// SvmInlineAggregatesInlineArrayItemSnaplockTypeNonSnaplock captures enum value "non_snaplock"
	SvmInlineAggregatesInlineArrayItemSnaplockTypeNonSnaplock string = "non_snaplock"

	// BEGIN DEBUGGING
	// svm_inline_aggregates_inline_array_item
	// SvmInlineAggregatesInlineArrayItem
	// snaplock_type
	// SnaplockType
	// compliance
	// END DEBUGGING
	// SvmInlineAggregatesInlineArrayItemSnaplockTypeCompliance captures enum value "compliance"
	SvmInlineAggregatesInlineArrayItemSnaplockTypeCompliance string = "compliance"

	// BEGIN DEBUGGING
	// svm_inline_aggregates_inline_array_item
	// SvmInlineAggregatesInlineArrayItem
	// snaplock_type
	// SnaplockType
	// enterprise
	// END DEBUGGING
	// SvmInlineAggregatesInlineArrayItemSnaplockTypeEnterprise captures enum value "enterprise"
	SvmInlineAggregatesInlineArrayItemSnaplockTypeEnterprise string = "enterprise"
)

// prop value enum
func (o *SvmInlineAggregatesInlineArrayItem) validateSnaplockTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, svmInlineAggregatesInlineArrayItemTypeSnaplockTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *SvmInlineAggregatesInlineArrayItem) validateSnaplockType(formats strfmt.Registry) error {
	if swag.IsZero(o.SnaplockType) { // not required
		return nil
	}

	// value enum
	if err := o.validateSnaplockTypeEnum("snaplock_type", "body", *o.SnaplockType); err != nil {
		return err
	}

	return nil
}

var svmInlineAggregatesInlineArrayItemTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["online","offline","unknown"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		svmInlineAggregatesInlineArrayItemTypeStatePropEnum = append(svmInlineAggregatesInlineArrayItemTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// svm_inline_aggregates_inline_array_item
	// SvmInlineAggregatesInlineArrayItem
	// state
	// State
	// online
	// END DEBUGGING
	// SvmInlineAggregatesInlineArrayItemStateOnline captures enum value "online"
	SvmInlineAggregatesInlineArrayItemStateOnline string = "online"

	// BEGIN DEBUGGING
	// svm_inline_aggregates_inline_array_item
	// SvmInlineAggregatesInlineArrayItem
	// state
	// State
	// offline
	// END DEBUGGING
	// SvmInlineAggregatesInlineArrayItemStateOffline captures enum value "offline"
	SvmInlineAggregatesInlineArrayItemStateOffline string = "offline"

	// BEGIN DEBUGGING
	// svm_inline_aggregates_inline_array_item
	// SvmInlineAggregatesInlineArrayItem
	// state
	// State
	// unknown
	// END DEBUGGING
	// SvmInlineAggregatesInlineArrayItemStateUnknown captures enum value "unknown"
	SvmInlineAggregatesInlineArrayItemStateUnknown string = "unknown"
)

// prop value enum
func (o *SvmInlineAggregatesInlineArrayItem) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, svmInlineAggregatesInlineArrayItemTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *SvmInlineAggregatesInlineArrayItem) validateState(formats strfmt.Registry) error {
	if swag.IsZero(o.State) { // not required
		return nil
	}

	// value enum
	if err := o.validateStateEnum("state", "body", *o.State); err != nil {
		return err
	}

	return nil
}

var svmInlineAggregatesInlineArrayItemTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["hdd","hybrid","lun","ssd","vmdisk"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		svmInlineAggregatesInlineArrayItemTypeTypePropEnum = append(svmInlineAggregatesInlineArrayItemTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// svm_inline_aggregates_inline_array_item
	// SvmInlineAggregatesInlineArrayItem
	// type
	// Type
	// hdd
	// END DEBUGGING
	// SvmInlineAggregatesInlineArrayItemTypeHdd captures enum value "hdd"
	SvmInlineAggregatesInlineArrayItemTypeHdd string = "hdd"

	// BEGIN DEBUGGING
	// svm_inline_aggregates_inline_array_item
	// SvmInlineAggregatesInlineArrayItem
	// type
	// Type
	// hybrid
	// END DEBUGGING
	// SvmInlineAggregatesInlineArrayItemTypeHybrid captures enum value "hybrid"
	SvmInlineAggregatesInlineArrayItemTypeHybrid string = "hybrid"

	// BEGIN DEBUGGING
	// svm_inline_aggregates_inline_array_item
	// SvmInlineAggregatesInlineArrayItem
	// type
	// Type
	// lun
	// END DEBUGGING
	// SvmInlineAggregatesInlineArrayItemTypeLun captures enum value "lun"
	SvmInlineAggregatesInlineArrayItemTypeLun string = "lun"

	// BEGIN DEBUGGING
	// svm_inline_aggregates_inline_array_item
	// SvmInlineAggregatesInlineArrayItem
	// type
	// Type
	// ssd
	// END DEBUGGING
	// SvmInlineAggregatesInlineArrayItemTypeSsd captures enum value "ssd"
	SvmInlineAggregatesInlineArrayItemTypeSsd string = "ssd"

	// BEGIN DEBUGGING
	// svm_inline_aggregates_inline_array_item
	// SvmInlineAggregatesInlineArrayItem
	// type
	// Type
	// vmdisk
	// END DEBUGGING
	// SvmInlineAggregatesInlineArrayItemTypeVmdisk captures enum value "vmdisk"
	SvmInlineAggregatesInlineArrayItemTypeVmdisk string = "vmdisk"
)

// prop value enum
func (o *SvmInlineAggregatesInlineArrayItem) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, svmInlineAggregatesInlineArrayItemTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *SvmInlineAggregatesInlineArrayItem) validateType(formats strfmt.Registry) error {
	if swag.IsZero(o.Type) { // not required
		return nil
	}

	// value enum
	if err := o.validateTypeEnum("type", "body", *o.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this svm inline aggregates inline array item based on the context it is used
func (o *SvmInlineAggregatesInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateAvailableSize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSnaplockType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmInlineAggregatesInlineArrayItem) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (o *SvmInlineAggregatesInlineArrayItem) contextValidateAvailableSize(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "available_size", "body", o.AvailableSize); err != nil {
		return err
	}

	return nil
}

func (o *SvmInlineAggregatesInlineArrayItem) contextValidateSnaplockType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "snaplock_type", "body", o.SnaplockType); err != nil {
		return err
	}

	return nil
}

func (o *SvmInlineAggregatesInlineArrayItem) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "state", "body", o.State); err != nil {
		return err
	}

	return nil
}

func (o *SvmInlineAggregatesInlineArrayItem) contextValidateType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "type", "body", o.Type); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SvmInlineAggregatesInlineArrayItem) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SvmInlineAggregatesInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res SvmInlineAggregatesInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SvmInlineAggregatesInlineArrayItemInlineLinks svm inline aggregates inline array item inline links
swagger:model svm_inline_aggregates_inline_array_item_inline__links
*/
type SvmInlineAggregatesInlineArrayItemInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this svm inline aggregates inline array item inline links
func (o *SvmInlineAggregatesInlineArrayItemInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmInlineAggregatesInlineArrayItemInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm inline aggregates inline array item inline links based on the context it is used
func (o *SvmInlineAggregatesInlineArrayItemInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmInlineAggregatesInlineArrayItemInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SvmInlineAggregatesInlineArrayItemInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SvmInlineAggregatesInlineArrayItemInlineLinks) UnmarshalBinary(b []byte) error {
	var res SvmInlineAggregatesInlineArrayItemInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SvmInlineCertificate Support for this field will be removed in a future release. Please use /svm/svms/{svm.uuid}/web for this field. Certificate for incoming TLS connection requests.
swagger:model svm_inline_certificate
*/
type SvmInlineCertificate struct {

	// links
	Links *models.SvmInlineCertificateInlineLinks `json:"_links,omitempty"`

	// Certificate name
	Name *string `json:"name,omitempty"`

	// Certificate UUID
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this svm inline certificate
func (o *SvmInlineCertificate) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmInlineCertificate) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "certificate" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm inline certificate based on the context it is used
func (o *SvmInlineCertificate) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmInlineCertificate) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "certificate" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SvmInlineCertificate) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SvmInlineCertificate) UnmarshalBinary(b []byte) error {
	var res SvmInlineCertificate
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SvmInlineCertificateInlineLinks svm inline certificate inline links
swagger:model svm_inline_certificate_inline__links
*/
type SvmInlineCertificateInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this svm inline certificate inline links
func (o *SvmInlineCertificateInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmInlineCertificateInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "certificate" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm inline certificate inline links based on the context it is used
func (o *SvmInlineCertificateInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmInlineCertificateInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "certificate" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SvmInlineCertificateInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SvmInlineCertificateInlineLinks) UnmarshalBinary(b []byte) error {
	var res SvmInlineCertificateInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SvmInlineCifs svm inline cifs
swagger:model svm_inline_cifs
*/
type SvmInlineCifs struct {

	// links
	Links *models.SvmInlineCifsInlineLinks `json:"_links,omitempty"`

	// ad domain
	AdDomain *models.SvmInlineCifsInlineAdDomain `json:"ad_domain,omitempty"`

	// If this is set to true, an SVM administrator can manage the CIFS service. If it is false, only the cluster administrator can manage the service.
	Allowed *bool `json:"allowed,omitempty"`

	// Authentication type.
	// Example: domain
	// Read Only: true
	// Enum: ["domain","workgroup"]
	AuthStyle *string `json:"auth-style,omitempty"`

	// The NetBIOS name of the domain or workgroup associated with the CIFS server.
	//
	// Read Only: true
	DomainWorkgroup *string `json:"domain_workgroup,omitempty"`

	// If allowed, setting to true enables the CIFS service.
	Enabled *bool `json:"enabled,omitempty"`

	// The NetBIOS name of the CIFS server.
	// Example: CIFS1
	// Max Length: 15
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// The workgroup name.
	// Example: workgrp1
	// Max Length: 15
	// Min Length: 1
	Workgroup *string `json:"workgroup,omitempty"`
}

// Validate validates this svm inline cifs
func (o *SvmInlineCifs) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateAdDomain(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateAuthStyle(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateWorkgroup(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmInlineCifs) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "cifs" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *SvmInlineCifs) validateAdDomain(formats strfmt.Registry) error {
	if swag.IsZero(o.AdDomain) { // not required
		return nil
	}

	if o.AdDomain != nil {
		if err := o.AdDomain.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "cifs" + "." + "ad_domain")
			}
			return err
		}
	}

	return nil
}

var svmInlineCifsTypeAuthStylePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["domain","workgroup"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		svmInlineCifsTypeAuthStylePropEnum = append(svmInlineCifsTypeAuthStylePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// svm_inline_cifs
	// SvmInlineCifs
	// auth-style
	// AuthStyle
	// domain
	// END DEBUGGING
	// SvmInlineCifsAuthStyleDomain captures enum value "domain"
	SvmInlineCifsAuthStyleDomain string = "domain"

	// BEGIN DEBUGGING
	// svm_inline_cifs
	// SvmInlineCifs
	// auth-style
	// AuthStyle
	// workgroup
	// END DEBUGGING
	// SvmInlineCifsAuthStyleWorkgroup captures enum value "workgroup"
	SvmInlineCifsAuthStyleWorkgroup string = "workgroup"
)

// prop value enum
func (o *SvmInlineCifs) validateAuthStyleEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, svmInlineCifsTypeAuthStylePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *SvmInlineCifs) validateAuthStyle(formats strfmt.Registry) error {
	if swag.IsZero(o.AuthStyle) { // not required
		return nil
	}

	// value enum
	if err := o.validateAuthStyleEnum("info"+"."+"cifs"+"."+"auth-style", "body", *o.AuthStyle); err != nil {
		return err
	}

	return nil
}

func (o *SvmInlineCifs) validateName(formats strfmt.Registry) error {
	if swag.IsZero(o.Name) { // not required
		return nil
	}

	if err := validate.MinLength("info"+"."+"cifs"+"."+"name", "body", *o.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("info"+"."+"cifs"+"."+"name", "body", *o.Name, 15); err != nil {
		return err
	}

	return nil
}

func (o *SvmInlineCifs) validateWorkgroup(formats strfmt.Registry) error {
	if swag.IsZero(o.Workgroup) { // not required
		return nil
	}

	if err := validate.MinLength("info"+"."+"cifs"+"."+"workgroup", "body", *o.Workgroup, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("info"+"."+"cifs"+"."+"workgroup", "body", *o.Workgroup, 15); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this svm inline cifs based on the context it is used
func (o *SvmInlineCifs) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateAdDomain(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateAuthStyle(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateDomainWorkgroup(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmInlineCifs) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "cifs" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *SvmInlineCifs) contextValidateAdDomain(ctx context.Context, formats strfmt.Registry) error {

	if o.AdDomain != nil {
		if err := o.AdDomain.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "cifs" + "." + "ad_domain")
			}
			return err
		}
	}

	return nil
}

func (o *SvmInlineCifs) contextValidateAuthStyle(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"cifs"+"."+"auth-style", "body", o.AuthStyle); err != nil {
		return err
	}

	return nil
}

func (o *SvmInlineCifs) contextValidateDomainWorkgroup(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"cifs"+"."+"domain_workgroup", "body", o.DomainWorkgroup); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SvmInlineCifs) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SvmInlineCifs) UnmarshalBinary(b []byte) error {
	var res SvmInlineCifs
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SvmInlineCifsInlineLinks svm inline cifs inline links
swagger:model svm_inline_cifs_inline__links
*/
type SvmInlineCifsInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this svm inline cifs inline links
func (o *SvmInlineCifsInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmInlineCifsInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "cifs" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm inline cifs inline links based on the context it is used
func (o *SvmInlineCifsInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmInlineCifsInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "cifs" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SvmInlineCifsInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SvmInlineCifsInlineLinks) UnmarshalBinary(b []byte) error {
	var res SvmInlineCifsInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SvmInlineCifsInlineAdDomain svm inline cifs inline ad domain
swagger:model svm_inline_cifs_inline_ad_domain
*/
type SvmInlineCifsInlineAdDomain struct {

	// The default site used by LIFs that do not have a site membership.
	//
	DefaultSite *string `json:"default_site,omitempty"`

	// The fully qualified domain name of the Windows Active Directory to which this CIFS server belongs. A CIFS server appears as a member of Windows server object in the Active Directory store.
	//
	// Example: example.com
	Fqdn *string `json:"fqdn,omitempty"`

	// Specifies the organizational unit within the Active Directory domain to associate with the CIFS server.
	//
	OrganizationalUnit *string `json:"organizational_unit,omitempty"`

	// The account password used to add this CIFS server to the Active Directory. This is not audited. Valid in POST only.
	//
	Password *string `json:"password,omitempty"`

	// The user account used to add this CIFS server to the Active Directory. Valid in POST only.
	//
	User *string `json:"user,omitempty"`
}

// Validate validates this svm inline cifs inline ad domain
func (o *SvmInlineCifsInlineAdDomain) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this svm inline cifs inline ad domain based on context it is used
func (o *SvmInlineCifsInlineAdDomain) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *SvmInlineCifsInlineAdDomain) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SvmInlineCifsInlineAdDomain) UnmarshalBinary(b []byte) error {
	var res SvmInlineCifsInlineAdDomain
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SvmInlineDNS svm inline dns
swagger:model svm_inline_dns
*/
type SvmInlineDNS struct {

	// links
	Links *models.SvmInlineDNSInlineLinks `json:"_links,omitempty"`

	// domains
	Domains models.DNSDomainsArrayInline `json:"domains,omitempty"`

	// servers
	Servers models.NameServersArrayInline `json:"servers,omitempty"`
}

// Validate validates this svm inline dns
func (o *SvmInlineDNS) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateDomains(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateServers(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmInlineDNS) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "dns" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *SvmInlineDNS) validateDomains(formats strfmt.Registry) error {
	if swag.IsZero(o.Domains) { // not required
		return nil
	}

	if err := o.Domains.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("info" + "." + "dns" + "." + "domains")
		}
		return err
	}

	return nil
}

func (o *SvmInlineDNS) validateServers(formats strfmt.Registry) error {
	if swag.IsZero(o.Servers) { // not required
		return nil
	}

	if err := o.Servers.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("info" + "." + "dns" + "." + "servers")
		}
		return err
	}

	return nil
}

// ContextValidate validate this svm inline dns based on the context it is used
func (o *SvmInlineDNS) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateDomains(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateServers(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmInlineDNS) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "dns" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *SvmInlineDNS) contextValidateDomains(ctx context.Context, formats strfmt.Registry) error {

	if err := o.Domains.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("info" + "." + "dns" + "." + "domains")
		}
		return err
	}

	return nil
}

func (o *SvmInlineDNS) contextValidateServers(ctx context.Context, formats strfmt.Registry) error {

	if err := o.Servers.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("info" + "." + "dns" + "." + "servers")
		}
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SvmInlineDNS) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SvmInlineDNS) UnmarshalBinary(b []byte) error {
	var res SvmInlineDNS
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SvmInlineDNSInlineLinks svm inline dns inline links
swagger:model svm_inline_dns_inline__links
*/
type SvmInlineDNSInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this svm inline dns inline links
func (o *SvmInlineDNSInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmInlineDNSInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "dns" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm inline dns inline links based on the context it is used
func (o *SvmInlineDNSInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmInlineDNSInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "dns" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SvmInlineDNSInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SvmInlineDNSInlineLinks) UnmarshalBinary(b []byte) error {
	var res SvmInlineDNSInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SvmInlineFcp <personalities supports=unified>
// Available for GET, POST, and PATCH requests.
// </personalities>
// <personalities supports=asar2>
// Available for GET requests. All SVMs are provisioned with the FCP service configured.
// </personalities>
//
swagger:model svm_inline_fcp
*/
type SvmInlineFcp struct {

	// links
	Links *models.SvmInlineFcpInlineLinks `json:"_links,omitempty"`

	// If this is set to true, an SVM administrator can manage the FCP service. If it is false, only the cluster administrator can manage the service.
	Allowed *bool `json:"allowed,omitempty"`

	// If allowed, setting to true enables the FCP service.
	Enabled *bool `json:"enabled,omitempty"`
}

// Validate validates this svm inline fcp
func (o *SvmInlineFcp) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmInlineFcp) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "fcp" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm inline fcp based on the context it is used
func (o *SvmInlineFcp) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmInlineFcp) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "fcp" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SvmInlineFcp) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SvmInlineFcp) UnmarshalBinary(b []byte) error {
	var res SvmInlineFcp
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SvmInlineFcpInlineLinks svm inline fcp inline links
swagger:model svm_inline_fcp_inline__links
*/
type SvmInlineFcpInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this svm inline fcp inline links
func (o *SvmInlineFcpInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmInlineFcpInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "fcp" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm inline fcp inline links based on the context it is used
func (o *SvmInlineFcpInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmInlineFcpInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "fcp" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SvmInlineFcpInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SvmInlineFcpInlineLinks) UnmarshalBinary(b []byte) error {
	var res SvmInlineFcpInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SvmInlineIpspace Either the UUID or name may be supplied on input.
swagger:model svm_inline_ipspace
*/
type SvmInlineIpspace struct {

	// links
	Links *models.SvmInlineIpspaceInlineLinks `json:"_links,omitempty"`

	// IPspace name
	// Example: Default
	Name *string `json:"name,omitempty"`

	// IPspace UUID
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this svm inline ipspace
func (o *SvmInlineIpspace) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmInlineIpspace) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "ipspace" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm inline ipspace based on the context it is used
func (o *SvmInlineIpspace) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmInlineIpspace) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "ipspace" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SvmInlineIpspace) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SvmInlineIpspace) UnmarshalBinary(b []byte) error {
	var res SvmInlineIpspace
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SvmInlineIpspaceInlineLinks svm inline ipspace inline links
swagger:model svm_inline_ipspace_inline__links
*/
type SvmInlineIpspaceInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this svm inline ipspace inline links
func (o *SvmInlineIpspaceInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmInlineIpspaceInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "ipspace" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm inline ipspace inline links based on the context it is used
func (o *SvmInlineIpspaceInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmInlineIpspaceInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "ipspace" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SvmInlineIpspaceInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SvmInlineIpspaceInlineLinks) UnmarshalBinary(b []byte) error {
	var res SvmInlineIpspaceInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SvmInlineIscsi <personalities supports=unified>
// Available for GET, POST, and PATCH requests.
// </personalities>
// <personalities supports=asar2>
// Available for GET requests. All SVMs are provisioned with the iSCSI service configured.
// </personalities>
//
swagger:model svm_inline_iscsi
*/
type SvmInlineIscsi struct {

	// links
	Links *models.SvmInlineIscsiInlineLinks `json:"_links,omitempty"`

	// If this is set to true, an SVM administrator can manage the iSCSI service. If it is false, only the cluster administrator can manage the service.
	Allowed *bool `json:"allowed,omitempty"`

	// If allowed, setting to true enables the iSCSI service.
	Enabled *bool `json:"enabled,omitempty"`
}

// Validate validates this svm inline iscsi
func (o *SvmInlineIscsi) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmInlineIscsi) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "iscsi" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm inline iscsi based on the context it is used
func (o *SvmInlineIscsi) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmInlineIscsi) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "iscsi" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SvmInlineIscsi) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SvmInlineIscsi) UnmarshalBinary(b []byte) error {
	var res SvmInlineIscsi
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SvmInlineIscsiInlineLinks svm inline iscsi inline links
swagger:model svm_inline_iscsi_inline__links
*/
type SvmInlineIscsiInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this svm inline iscsi inline links
func (o *SvmInlineIscsiInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmInlineIscsiInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "iscsi" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm inline iscsi inline links based on the context it is used
func (o *SvmInlineIscsiInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmInlineIscsiInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "iscsi" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SvmInlineIscsiInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SvmInlineIscsiInlineLinks) UnmarshalBinary(b []byte) error {
	var res SvmInlineIscsiInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SvmInlineLdap svm inline ldap
swagger:model svm_inline_ldap
*/
type SvmInlineLdap struct {

	// This parameter specifies the name of the Active Directory domain
	// used to discover LDAP servers for use by this client.
	// This is mutually exclusive with `servers` during POST.
	//
	AdDomain *string `json:"ad_domain,omitempty"`

	// Specifies the default base DN for all searches.
	BaseDn *string `json:"base_dn,omitempty"`

	// Specifies the user that binds to the LDAP servers. SVM API supports anonymous binding. For Simple and SASL LDAP binding, use the LDAP API endpoint.
	BindDn *string `json:"bind_dn,omitempty"`

	// Enable LDAP? Setting to true creates a configuration if not already created.
	Enabled *bool `json:"enabled,omitempty"`

	// Specifies whether or not LDAP server discovery is restricted to site-scope.
	//
	RestrictDiscoveryToSite *bool `json:"restrict_discovery_to_site,omitempty"`

	// servers
	Servers []*string `json:"servers,omitempty"`
}

// Validate validates this svm inline ldap
func (o *SvmInlineLdap) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this svm inline ldap based on context it is used
func (o *SvmInlineLdap) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *SvmInlineLdap) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SvmInlineLdap) UnmarshalBinary(b []byte) error {
	var res SvmInlineLdap
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SvmInlineNdmp svm inline ndmp
swagger:model svm_inline_ndmp
*/
type SvmInlineNdmp struct {

	// If this is set to true, an SVM administrator can manage the NDMP service. If it is false, only the cluster administrator can manage the service.
	Allowed *bool `json:"allowed,omitempty"`
}

// Validate validates this svm inline ndmp
func (o *SvmInlineNdmp) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this svm inline ndmp based on context it is used
func (o *SvmInlineNdmp) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *SvmInlineNdmp) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SvmInlineNdmp) UnmarshalBinary(b []byte) error {
	var res SvmInlineNdmp
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SvmInlineNfs svm inline nfs
swagger:model svm_inline_nfs
*/
type SvmInlineNfs struct {

	// links
	Links *models.SvmInlineNfsInlineLinks `json:"_links,omitempty"`

	// If this is set to true, an SVM administrator can manage the NFS service. If it is false, only the cluster administrator can manage the service.
	Allowed *bool `json:"allowed,omitempty"`

	// If allowed, setting to true enables the NFS service.
	Enabled *bool `json:"enabled,omitempty"`
}

// Validate validates this svm inline nfs
func (o *SvmInlineNfs) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmInlineNfs) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "nfs" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm inline nfs based on the context it is used
func (o *SvmInlineNfs) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmInlineNfs) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "nfs" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SvmInlineNfs) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SvmInlineNfs) UnmarshalBinary(b []byte) error {
	var res SvmInlineNfs
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SvmInlineNfsInlineLinks svm inline nfs inline links
swagger:model svm_inline_nfs_inline__links
*/
type SvmInlineNfsInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this svm inline nfs inline links
func (o *SvmInlineNfsInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmInlineNfsInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "nfs" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm inline nfs inline links based on the context it is used
func (o *SvmInlineNfsInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmInlineNfsInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "nfs" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SvmInlineNfsInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SvmInlineNfsInlineLinks) UnmarshalBinary(b []byte) error {
	var res SvmInlineNfsInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SvmInlineNis svm inline nis
swagger:model svm_inline_nis
*/
type SvmInlineNis struct {

	// links
	Links *models.SvmInlineNisInlineLinks `json:"_links,omitempty"`

	// domain
	Domain *models.NisDomain `json:"domain,omitempty"`

	// Enable NIS? Setting to true creates a configuration if not already created.
	Enabled *bool `json:"enabled,omitempty"`

	// servers
	Servers models.NisServersArrayInline `json:"servers,omitempty"`
}

// Validate validates this svm inline nis
func (o *SvmInlineNis) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateDomain(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateServers(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmInlineNis) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "nis" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *SvmInlineNis) validateDomain(formats strfmt.Registry) error {
	if swag.IsZero(o.Domain) { // not required
		return nil
	}

	if o.Domain != nil {
		if err := o.Domain.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "nis" + "." + "domain")
			}
			return err
		}
	}

	return nil
}

func (o *SvmInlineNis) validateServers(formats strfmt.Registry) error {
	if swag.IsZero(o.Servers) { // not required
		return nil
	}

	if err := o.Servers.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("info" + "." + "nis" + "." + "servers")
		}
		return err
	}

	return nil
}

// ContextValidate validate this svm inline nis based on the context it is used
func (o *SvmInlineNis) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateDomain(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateServers(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmInlineNis) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "nis" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *SvmInlineNis) contextValidateDomain(ctx context.Context, formats strfmt.Registry) error {

	if o.Domain != nil {
		if err := o.Domain.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "nis" + "." + "domain")
			}
			return err
		}
	}

	return nil
}

func (o *SvmInlineNis) contextValidateServers(ctx context.Context, formats strfmt.Registry) error {

	if err := o.Servers.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("info" + "." + "nis" + "." + "servers")
		}
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SvmInlineNis) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SvmInlineNis) UnmarshalBinary(b []byte) error {
	var res SvmInlineNis
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SvmInlineNisInlineLinks svm inline nis inline links
swagger:model svm_inline_nis_inline__links
*/
type SvmInlineNisInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this svm inline nis inline links
func (o *SvmInlineNisInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmInlineNisInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "nis" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm inline nis inline links based on the context it is used
func (o *SvmInlineNisInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmInlineNisInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "nis" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SvmInlineNisInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SvmInlineNisInlineLinks) UnmarshalBinary(b []byte) error {
	var res SvmInlineNisInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SvmInlineNsswitch Name service switch configuration
swagger:model svm_inline_nsswitch
*/
type SvmInlineNsswitch struct {

	// Group sources
	Group []*models.NsswitchSource `json:"group,omitempty"`

	// Host sources
	Hosts []*models.NsswitchSource `json:"hosts,omitempty"`

	// NameMap sources
	Namemap []*models.NsswitchSource `json:"namemap,omitempty"`

	// NetGroup sources
	Netgroup []*models.NsswitchSource `json:"netgroup,omitempty"`

	// Password sources
	Passwd []*models.NsswitchSource `json:"passwd,omitempty"`
}

// Validate validates this svm inline nsswitch
func (o *SvmInlineNsswitch) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateGroup(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateHosts(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNamemap(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNetgroup(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validatePasswd(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmInlineNsswitch) validateGroup(formats strfmt.Registry) error {
	if swag.IsZero(o.Group) { // not required
		return nil
	}

	for i := 0; i < len(o.Group); i++ {
		if swag.IsZero(o.Group[i]) { // not required
			continue
		}

		if o.Group[i] != nil {
			if err := o.Group[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "nsswitch" + "." + "group" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *SvmInlineNsswitch) validateHosts(formats strfmt.Registry) error {
	if swag.IsZero(o.Hosts) { // not required
		return nil
	}

	for i := 0; i < len(o.Hosts); i++ {
		if swag.IsZero(o.Hosts[i]) { // not required
			continue
		}

		if o.Hosts[i] != nil {
			if err := o.Hosts[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "nsswitch" + "." + "hosts" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *SvmInlineNsswitch) validateNamemap(formats strfmt.Registry) error {
	if swag.IsZero(o.Namemap) { // not required
		return nil
	}

	for i := 0; i < len(o.Namemap); i++ {
		if swag.IsZero(o.Namemap[i]) { // not required
			continue
		}

		if o.Namemap[i] != nil {
			if err := o.Namemap[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "nsswitch" + "." + "namemap" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *SvmInlineNsswitch) validateNetgroup(formats strfmt.Registry) error {
	if swag.IsZero(o.Netgroup) { // not required
		return nil
	}

	for i := 0; i < len(o.Netgroup); i++ {
		if swag.IsZero(o.Netgroup[i]) { // not required
			continue
		}

		if o.Netgroup[i] != nil {
			if err := o.Netgroup[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "nsswitch" + "." + "netgroup" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *SvmInlineNsswitch) validatePasswd(formats strfmt.Registry) error {
	if swag.IsZero(o.Passwd) { // not required
		return nil
	}

	for i := 0; i < len(o.Passwd); i++ {
		if swag.IsZero(o.Passwd[i]) { // not required
			continue
		}

		if o.Passwd[i] != nil {
			if err := o.Passwd[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "nsswitch" + "." + "passwd" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this svm inline nsswitch based on the context it is used
func (o *SvmInlineNsswitch) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateGroup(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateHosts(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNamemap(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNetgroup(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidatePasswd(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmInlineNsswitch) contextValidateGroup(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.Group); i++ {

		if o.Group[i] != nil {
			if err := o.Group[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "nsswitch" + "." + "group" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *SvmInlineNsswitch) contextValidateHosts(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.Hosts); i++ {

		if o.Hosts[i] != nil {
			if err := o.Hosts[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "nsswitch" + "." + "hosts" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *SvmInlineNsswitch) contextValidateNamemap(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.Namemap); i++ {

		if o.Namemap[i] != nil {
			if err := o.Namemap[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "nsswitch" + "." + "namemap" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *SvmInlineNsswitch) contextValidateNetgroup(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.Netgroup); i++ {

		if o.Netgroup[i] != nil {
			if err := o.Netgroup[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "nsswitch" + "." + "netgroup" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *SvmInlineNsswitch) contextValidatePasswd(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.Passwd); i++ {

		if o.Passwd[i] != nil {
			if err := o.Passwd[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "nsswitch" + "." + "passwd" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *SvmInlineNsswitch) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SvmInlineNsswitch) UnmarshalBinary(b []byte) error {
	var res SvmInlineNsswitch
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SvmInlineNvme <personalities supports=unified>
// Available for GET, POST, and PATCH requests.
// </personalities>
// <personalities supports=asar2>
// Available for GET requests. All SVMs are provisioned with the NVMe service configured.
// </personalities>
//
swagger:model svm_inline_nvme
*/
type SvmInlineNvme struct {

	// links
	Links *models.SvmInlineNvmeInlineLinks `json:"_links,omitempty"`

	// If this is set to true, an SVM administrator can manage the NVMe service. If it is false, only the cluster administrator can manage the service.
	Allowed *bool `json:"allowed,omitempty"`

	// If allowed, setting to true enables the NVMe service.
	Enabled *bool `json:"enabled,omitempty"`
}

// Validate validates this svm inline nvme
func (o *SvmInlineNvme) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmInlineNvme) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "nvme" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm inline nvme based on the context it is used
func (o *SvmInlineNvme) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmInlineNvme) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "nvme" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SvmInlineNvme) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SvmInlineNvme) UnmarshalBinary(b []byte) error {
	var res SvmInlineNvme
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SvmInlineNvmeInlineLinks svm inline nvme inline links
swagger:model svm_inline_nvme_inline__links
*/
type SvmInlineNvmeInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this svm inline nvme inline links
func (o *SvmInlineNvmeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmInlineNvmeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "nvme" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm inline nvme inline links based on the context it is used
func (o *SvmInlineNvmeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmInlineNvmeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "nvme" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SvmInlineNvmeInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SvmInlineNvmeInlineLinks) UnmarshalBinary(b []byte) error {
	var res SvmInlineNvmeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SvmInlineQosAdaptivePolicyGroupTemplate This optionally specifies which QoS adaptive policy group to apply to the SVM as a template. This policy group will then be assigned to volumes created or rehosted into this SVM. This policy group defines measurable service level objectives (SLOs) and Service Level Agreements (SLAs) that adjust based on the volume allocated space or used space.
swagger:model svm_inline_qos_adaptive_policy_group_template
*/
type SvmInlineQosAdaptivePolicyGroupTemplate struct {

	// links
	Links *models.SvmInlineQosAdaptivePolicyGroupTemplateInlineLinks `json:"_links,omitempty"`

	// Specifies the maximum throughput in Kilobytes per sec, Megabytes per sec or Gigabytes per sec along with or without IOPS. 0 means none. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when either max_throughput_mbps or max_throughput_iops are set during POST or PATCH. During GET, the returned value is rounded to the largest unit with a value greater than 1.
	// Example: ["900KB/s","500MB/s","120GB/s","5000IOPS","5000IOPS,500KB/s","2500IOPS,100MB/s","1000IOPS,25MB/s"]
	MaxThroughput *string `json:"max_throughput,omitempty"`

	// Specifies the maximum throughput in IOPS, 0 means none. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when max_throughput is set during POST or PATCH.
	// Example: 10000
	// Maximum: 2.147483647e+09
	// Minimum: 0
	MaxThroughputIops *int64 `json:"max_throughput_iops,omitempty"`

	// Specifies the maximum throughput in Megabytes per sec, 0 means none. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when max_throughput is set during POST or PATCH.
	// Example: 500
	// Maximum: 4.194303e+06
	// Minimum: 0
	MaxThroughputMbps *int64 `json:"max_throughput_mbps,omitempty"`

	// Specifies the minimum throughput in Kilobytes per sec, Megabytes per sec or Gigabytes per sec along with or without IOPS. 0 means none.Setting "min_throughput" is supported on AFF platforms only, unless FabricPool tiering policies are set. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when either min_throughput_mbps or min_throughput_iops are set during POST or PATCH. During GET, the returned value is rounded to the largest unit with a value greater than 1.
	// Example: ["900KB/s","500MB/s","120GB/s","5000IOPS","5000IOPS,500KB/s","2500IOPS,100MB/s","1000IOPS,25MB/s"]
	MinThroughput *string `json:"min_throughput,omitempty"`

	// Specifies the minimum throughput in IOPS, 0 means none. Setting "min_throughput" is supported on AFF platforms only, unless FabricPool tiering policies are set. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when min_throughput is set during POST or PATCH.
	// Example: 2000
	// Maximum: 2.147483647e+09
	// Minimum: 0
	MinThroughputIops *int64 `json:"min_throughput_iops,omitempty"`

	// Specifies the minimum throughput in Megabytes per sec, 0 means none. This is mutually exclusive with name and UUID during POST and PATCH.This cannot be set when min_throughput is set during POST or PATCH.
	// Example: 500
	// Maximum: 4.194303e+06
	// Minimum: 0
	MinThroughputMbps *int64 `json:"min_throughput_mbps,omitempty"`

	// The QoS policy group name. This is mutually exclusive with UUID and other QoS attributes during POST and PATCH.
	// Example: performance
	Name *string `json:"name,omitempty"`

	// The QoS policy group UUID. This is mutually exclusive with name and other QoS attributes during POST and PATCH.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this svm inline qos adaptive policy group template
func (o *SvmInlineQosAdaptivePolicyGroupTemplate) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMaxThroughputIops(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMaxThroughputMbps(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMinThroughputIops(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMinThroughputMbps(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmInlineQosAdaptivePolicyGroupTemplate) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "qos_adaptive_policy_group_template" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *SvmInlineQosAdaptivePolicyGroupTemplate) validateMaxThroughputIops(formats strfmt.Registry) error {
	if swag.IsZero(o.MaxThroughputIops) { // not required
		return nil
	}

	if err := validate.MinimumInt("info"+"."+"qos_adaptive_policy_group_template"+"."+"max_throughput_iops", "body", *o.MaxThroughputIops, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("info"+"."+"qos_adaptive_policy_group_template"+"."+"max_throughput_iops", "body", *o.MaxThroughputIops, 2.147483647e+09, false); err != nil {
		return err
	}

	return nil
}

func (o *SvmInlineQosAdaptivePolicyGroupTemplate) validateMaxThroughputMbps(formats strfmt.Registry) error {
	if swag.IsZero(o.MaxThroughputMbps) { // not required
		return nil
	}

	if err := validate.MinimumInt("info"+"."+"qos_adaptive_policy_group_template"+"."+"max_throughput_mbps", "body", *o.MaxThroughputMbps, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("info"+"."+"qos_adaptive_policy_group_template"+"."+"max_throughput_mbps", "body", *o.MaxThroughputMbps, 4.194303e+06, false); err != nil {
		return err
	}

	return nil
}

func (o *SvmInlineQosAdaptivePolicyGroupTemplate) validateMinThroughputIops(formats strfmt.Registry) error {
	if swag.IsZero(o.MinThroughputIops) { // not required
		return nil
	}

	if err := validate.MinimumInt("info"+"."+"qos_adaptive_policy_group_template"+"."+"min_throughput_iops", "body", *o.MinThroughputIops, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("info"+"."+"qos_adaptive_policy_group_template"+"."+"min_throughput_iops", "body", *o.MinThroughputIops, 2.147483647e+09, false); err != nil {
		return err
	}

	return nil
}

func (o *SvmInlineQosAdaptivePolicyGroupTemplate) validateMinThroughputMbps(formats strfmt.Registry) error {
	if swag.IsZero(o.MinThroughputMbps) { // not required
		return nil
	}

	if err := validate.MinimumInt("info"+"."+"qos_adaptive_policy_group_template"+"."+"min_throughput_mbps", "body", *o.MinThroughputMbps, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("info"+"."+"qos_adaptive_policy_group_template"+"."+"min_throughput_mbps", "body", *o.MinThroughputMbps, 4.194303e+06, false); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this svm inline qos adaptive policy group template based on the context it is used
func (o *SvmInlineQosAdaptivePolicyGroupTemplate) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmInlineQosAdaptivePolicyGroupTemplate) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "qos_adaptive_policy_group_template" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SvmInlineQosAdaptivePolicyGroupTemplate) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SvmInlineQosAdaptivePolicyGroupTemplate) UnmarshalBinary(b []byte) error {
	var res SvmInlineQosAdaptivePolicyGroupTemplate
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SvmInlineQosAdaptivePolicyGroupTemplateInlineLinks svm inline qos adaptive policy group template inline links
swagger:model svm_inline_qos_adaptive_policy_group_template_inline__links
*/
type SvmInlineQosAdaptivePolicyGroupTemplateInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this svm inline qos adaptive policy group template inline links
func (o *SvmInlineQosAdaptivePolicyGroupTemplateInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmInlineQosAdaptivePolicyGroupTemplateInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "qos_adaptive_policy_group_template" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm inline qos adaptive policy group template inline links based on the context it is used
func (o *SvmInlineQosAdaptivePolicyGroupTemplateInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmInlineQosAdaptivePolicyGroupTemplateInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "qos_adaptive_policy_group_template" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SvmInlineQosAdaptivePolicyGroupTemplateInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SvmInlineQosAdaptivePolicyGroupTemplateInlineLinks) UnmarshalBinary(b []byte) error {
	var res SvmInlineQosAdaptivePolicyGroupTemplateInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SvmInlineQosPolicy This optionally specifies which QoS policy group to apply to the Vserver. This policy group defines measurable service level objectives (SLOs) that apply to the storage objects with which the policy group is associated.
swagger:model svm_inline_qos_policy
*/
type SvmInlineQosPolicy struct {

	// links
	Links *models.SvmInlineQosPolicyInlineLinks `json:"_links,omitempty"`

	// Specifies the maximum throughput in Kilobytes per sec, Megabytes per sec or Gigabytes per sec along with or without IOPS. 0 means none. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when either max_throughput_mbps or max_throughput_iops are set during POST or PATCH. During GET, the returned value is rounded to the largest unit with a value greater than 1.
	// Example: ["900KB/s","500MB/s","120GB/s","5000IOPS","5000IOPS,500KB/s","2500IOPS,100MB/s","1000IOPS,25MB/s"]
	MaxThroughput *string `json:"max_throughput,omitempty"`

	// Specifies the maximum throughput in IOPS, 0 means none. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when max_throughput is set during POST or PATCH.
	// Example: 10000
	// Maximum: 2.147483647e+09
	// Minimum: 0
	MaxThroughputIops *int64 `json:"max_throughput_iops,omitempty"`

	// Specifies the maximum throughput in Megabytes per sec, 0 means none. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when max_throughput is set during POST or PATCH.
	// Example: 500
	// Maximum: 4.194303e+06
	// Minimum: 0
	MaxThroughputMbps *int64 `json:"max_throughput_mbps,omitempty"`

	// Specifies the minimum throughput in Kilobytes per sec, Megabytes per sec or Gigabytes per sec along with or without IOPS. 0 means none.Setting "min_throughput" is supported on AFF platforms only, unless FabricPool tiering policies are set. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when either min_throughput_mbps or min_throughput_iops are set during POST or PATCH. During GET, the returned value is rounded to the largest unit with a value greater than 1.
	// Example: ["900KB/s","500MB/s","120GB/s","5000IOPS","5000IOPS,500KB/s","2500IOPS,100MB/s","1000IOPS,25MB/s"]
	MinThroughput *string `json:"min_throughput,omitempty"`

	// Specifies the minimum throughput in IOPS, 0 means none. Setting "min_throughput" is supported on AFF platforms only, unless FabricPool tiering policies are set. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when min_throughput is set during POST or PATCH.
	// Example: 2000
	// Maximum: 2.147483647e+09
	// Minimum: 0
	MinThroughputIops *int64 `json:"min_throughput_iops,omitempty"`

	// Specifies the minimum throughput in Megabytes per sec, 0 means none. This is mutually exclusive with name and UUID during POST and PATCH.This cannot be set when min_throughput is set during POST or PATCH.
	// Example: 500
	// Maximum: 4.194303e+06
	// Minimum: 0
	MinThroughputMbps *int64 `json:"min_throughput_mbps,omitempty"`

	// The QoS policy group name. This is mutually exclusive with UUID and other QoS attributes during POST and PATCH.
	// Example: performance
	Name *string `json:"name,omitempty"`

	// The QoS policy group UUID. This is mutually exclusive with name and other QoS attributes during POST and PATCH.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this svm inline qos policy
func (o *SvmInlineQosPolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMaxThroughputIops(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMaxThroughputMbps(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMinThroughputIops(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMinThroughputMbps(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmInlineQosPolicy) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "qos_policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *SvmInlineQosPolicy) validateMaxThroughputIops(formats strfmt.Registry) error {
	if swag.IsZero(o.MaxThroughputIops) { // not required
		return nil
	}

	if err := validate.MinimumInt("info"+"."+"qos_policy"+"."+"max_throughput_iops", "body", *o.MaxThroughputIops, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("info"+"."+"qos_policy"+"."+"max_throughput_iops", "body", *o.MaxThroughputIops, 2.147483647e+09, false); err != nil {
		return err
	}

	return nil
}

func (o *SvmInlineQosPolicy) validateMaxThroughputMbps(formats strfmt.Registry) error {
	if swag.IsZero(o.MaxThroughputMbps) { // not required
		return nil
	}

	if err := validate.MinimumInt("info"+"."+"qos_policy"+"."+"max_throughput_mbps", "body", *o.MaxThroughputMbps, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("info"+"."+"qos_policy"+"."+"max_throughput_mbps", "body", *o.MaxThroughputMbps, 4.194303e+06, false); err != nil {
		return err
	}

	return nil
}

func (o *SvmInlineQosPolicy) validateMinThroughputIops(formats strfmt.Registry) error {
	if swag.IsZero(o.MinThroughputIops) { // not required
		return nil
	}

	if err := validate.MinimumInt("info"+"."+"qos_policy"+"."+"min_throughput_iops", "body", *o.MinThroughputIops, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("info"+"."+"qos_policy"+"."+"min_throughput_iops", "body", *o.MinThroughputIops, 2.147483647e+09, false); err != nil {
		return err
	}

	return nil
}

func (o *SvmInlineQosPolicy) validateMinThroughputMbps(formats strfmt.Registry) error {
	if swag.IsZero(o.MinThroughputMbps) { // not required
		return nil
	}

	if err := validate.MinimumInt("info"+"."+"qos_policy"+"."+"min_throughput_mbps", "body", *o.MinThroughputMbps, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("info"+"."+"qos_policy"+"."+"min_throughput_mbps", "body", *o.MinThroughputMbps, 4.194303e+06, false); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this svm inline qos policy based on the context it is used
func (o *SvmInlineQosPolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmInlineQosPolicy) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "qos_policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SvmInlineQosPolicy) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SvmInlineQosPolicy) UnmarshalBinary(b []byte) error {
	var res SvmInlineQosPolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SvmInlineQosPolicyGroupTemplate This optionally specifies which QoS non-shared policy group to apply to the SVM as a template. This policy group is then assigned to volumes created or rehosted into this SVM. This policy group defines measurable service level objectives (SLOs) and Service Level Agreements (SLAs).
swagger:model svm_inline_qos_policy_group_template
*/
type SvmInlineQosPolicyGroupTemplate struct {

	// links
	Links *models.SvmInlineQosPolicyGroupTemplateInlineLinks `json:"_links,omitempty"`

	// Specifies the maximum throughput in Kilobytes per sec, Megabytes per sec or Gigabytes per sec along with or without IOPS. 0 means none. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when either max_throughput_mbps or max_throughput_iops are set during POST or PATCH. During GET, the returned value is rounded to the largest unit with a value greater than 1.
	// Example: ["900KB/s","500MB/s","120GB/s","5000IOPS","5000IOPS,500KB/s","2500IOPS,100MB/s","1000IOPS,25MB/s"]
	MaxThroughput *string `json:"max_throughput,omitempty"`

	// Specifies the maximum throughput in IOPS, 0 means none. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when max_throughput is set during POST or PATCH.
	// Example: 10000
	// Maximum: 2.147483647e+09
	// Minimum: 0
	MaxThroughputIops *int64 `json:"max_throughput_iops,omitempty"`

	// Specifies the maximum throughput in Megabytes per sec, 0 means none. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when max_throughput is set during POST or PATCH.
	// Example: 500
	// Maximum: 4.194303e+06
	// Minimum: 0
	MaxThroughputMbps *int64 `json:"max_throughput_mbps,omitempty"`

	// Specifies the minimum throughput in Kilobytes per sec, Megabytes per sec or Gigabytes per sec along with or without IOPS. 0 means none.Setting "min_throughput" is supported on AFF platforms only, unless FabricPool tiering policies are set. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when either min_throughput_mbps or min_throughput_iops are set during POST or PATCH. During GET, the returned value is rounded to the largest unit with a value greater than 1.
	// Example: ["900KB/s","500MB/s","120GB/s","5000IOPS","5000IOPS,500KB/s","2500IOPS,100MB/s","1000IOPS,25MB/s"]
	MinThroughput *string `json:"min_throughput,omitempty"`

	// Specifies the minimum throughput in IOPS, 0 means none. Setting "min_throughput" is supported on AFF platforms only, unless FabricPool tiering policies are set. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when min_throughput is set during POST or PATCH.
	// Example: 2000
	// Maximum: 2.147483647e+09
	// Minimum: 0
	MinThroughputIops *int64 `json:"min_throughput_iops,omitempty"`

	// Specifies the minimum throughput in Megabytes per sec, 0 means none. This is mutually exclusive with name and UUID during POST and PATCH.This cannot be set when min_throughput is set during POST or PATCH.
	// Example: 500
	// Maximum: 4.194303e+06
	// Minimum: 0
	MinThroughputMbps *int64 `json:"min_throughput_mbps,omitempty"`

	// The QoS policy group name. This is mutually exclusive with UUID and other QoS attributes during POST and PATCH.
	// Example: performance
	Name *string `json:"name,omitempty"`

	// The QoS policy group UUID. This is mutually exclusive with name and other QoS attributes during POST and PATCH.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this svm inline qos policy group template
func (o *SvmInlineQosPolicyGroupTemplate) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMaxThroughputIops(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMaxThroughputMbps(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMinThroughputIops(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMinThroughputMbps(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmInlineQosPolicyGroupTemplate) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "qos_policy_group_template" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *SvmInlineQosPolicyGroupTemplate) validateMaxThroughputIops(formats strfmt.Registry) error {
	if swag.IsZero(o.MaxThroughputIops) { // not required
		return nil
	}

	if err := validate.MinimumInt("info"+"."+"qos_policy_group_template"+"."+"max_throughput_iops", "body", *o.MaxThroughputIops, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("info"+"."+"qos_policy_group_template"+"."+"max_throughput_iops", "body", *o.MaxThroughputIops, 2.147483647e+09, false); err != nil {
		return err
	}

	return nil
}

func (o *SvmInlineQosPolicyGroupTemplate) validateMaxThroughputMbps(formats strfmt.Registry) error {
	if swag.IsZero(o.MaxThroughputMbps) { // not required
		return nil
	}

	if err := validate.MinimumInt("info"+"."+"qos_policy_group_template"+"."+"max_throughput_mbps", "body", *o.MaxThroughputMbps, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("info"+"."+"qos_policy_group_template"+"."+"max_throughput_mbps", "body", *o.MaxThroughputMbps, 4.194303e+06, false); err != nil {
		return err
	}

	return nil
}

func (o *SvmInlineQosPolicyGroupTemplate) validateMinThroughputIops(formats strfmt.Registry) error {
	if swag.IsZero(o.MinThroughputIops) { // not required
		return nil
	}

	if err := validate.MinimumInt("info"+"."+"qos_policy_group_template"+"."+"min_throughput_iops", "body", *o.MinThroughputIops, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("info"+"."+"qos_policy_group_template"+"."+"min_throughput_iops", "body", *o.MinThroughputIops, 2.147483647e+09, false); err != nil {
		return err
	}

	return nil
}

func (o *SvmInlineQosPolicyGroupTemplate) validateMinThroughputMbps(formats strfmt.Registry) error {
	if swag.IsZero(o.MinThroughputMbps) { // not required
		return nil
	}

	if err := validate.MinimumInt("info"+"."+"qos_policy_group_template"+"."+"min_throughput_mbps", "body", *o.MinThroughputMbps, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("info"+"."+"qos_policy_group_template"+"."+"min_throughput_mbps", "body", *o.MinThroughputMbps, 4.194303e+06, false); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this svm inline qos policy group template based on the context it is used
func (o *SvmInlineQosPolicyGroupTemplate) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmInlineQosPolicyGroupTemplate) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "qos_policy_group_template" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SvmInlineQosPolicyGroupTemplate) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SvmInlineQosPolicyGroupTemplate) UnmarshalBinary(b []byte) error {
	var res SvmInlineQosPolicyGroupTemplate
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SvmInlineQosPolicyGroupTemplateInlineLinks svm inline qos policy group template inline links
swagger:model svm_inline_qos_policy_group_template_inline__links
*/
type SvmInlineQosPolicyGroupTemplateInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this svm inline qos policy group template inline links
func (o *SvmInlineQosPolicyGroupTemplateInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmInlineQosPolicyGroupTemplateInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "qos_policy_group_template" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm inline qos policy group template inline links based on the context it is used
func (o *SvmInlineQosPolicyGroupTemplateInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmInlineQosPolicyGroupTemplateInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "qos_policy_group_template" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SvmInlineQosPolicyGroupTemplateInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SvmInlineQosPolicyGroupTemplateInlineLinks) UnmarshalBinary(b []byte) error {
	var res SvmInlineQosPolicyGroupTemplateInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SvmInlineQosPolicyInlineLinks svm inline qos policy inline links
swagger:model svm_inline_qos_policy_inline__links
*/
type SvmInlineQosPolicyInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this svm inline qos policy inline links
func (o *SvmInlineQosPolicyInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmInlineQosPolicyInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "qos_policy" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm inline qos policy inline links based on the context it is used
func (o *SvmInlineQosPolicyInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmInlineQosPolicyInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "qos_policy" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SvmInlineQosPolicyInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SvmInlineQosPolicyInlineLinks) UnmarshalBinary(b []byte) error {
	var res SvmInlineQosPolicyInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SvmInlineS3 svm inline s3
swagger:model svm_inline_s3
*/
type SvmInlineS3 struct {

	// links
	Links *models.SvmInlineS3InlineLinks `json:"_links,omitempty"`

	// If this is set to true, an SVM administrator can manage the S3 service. If it is false, only the cluster administrator can manage the service.
	Allowed *bool `json:"allowed,omitempty"`

	// certificate
	Certificate *models.SvmInlineS3InlineCertificate `json:"certificate,omitempty"`

	// Specifies the default UNIX user for NAS Access.
	DefaultUnixUser *string `json:"default_unix_user,omitempty"`

	// Specifies the default Windows user for NAS Access.
	DefaultWinUser *string `json:"default_win_user,omitempty"`

	// Specifies whether or not to enable S3. Setting this value to true creates a service if one is not yet created.
	Enabled *bool `json:"enabled,omitempty"`

	// Specifies whether HTTP is enabled on the S3 server. By default, HTTP is disabled on the S3 server.
	IsHTTPEnabled *bool `json:"is_http_enabled,omitempty"`

	// Specifies whether HTTPS is enabled on the S3 server. By default, HTTPS is enabled on the S3 server.
	IsHTTPSEnabled *bool `json:"is_https_enabled,omitempty"`

	// Specifies the name of the S3 server. A server name length can range from 1 to 253 characters and can only contain the following combination of characters 0-9, A-Z, a-z, ".", and "-".
	// Example: s3-server-1
	// Max Length: 253
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// Specifies the HTTP listener port for the S3 server. By default, HTTP is enabled on port 80.
	Port *int64 `json:"port,omitempty"`

	// Specifies the HTTPS listener port for the S3 server. By default, HTTPS is enabled on port 443.
	SecurePort *int64 `json:"secure_port,omitempty"`
}

// Validate validates this svm inline s3
func (o *SvmInlineS3) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateCertificate(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmInlineS3) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "s3" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *SvmInlineS3) validateCertificate(formats strfmt.Registry) error {
	if swag.IsZero(o.Certificate) { // not required
		return nil
	}

	if o.Certificate != nil {
		if err := o.Certificate.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "s3" + "." + "certificate")
			}
			return err
		}
	}

	return nil
}

func (o *SvmInlineS3) validateName(formats strfmt.Registry) error {
	if swag.IsZero(o.Name) { // not required
		return nil
	}

	if err := validate.MinLength("info"+"."+"s3"+"."+"name", "body", *o.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("info"+"."+"s3"+"."+"name", "body", *o.Name, 253); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this svm inline s3 based on the context it is used
func (o *SvmInlineS3) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateCertificate(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmInlineS3) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "s3" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *SvmInlineS3) contextValidateCertificate(ctx context.Context, formats strfmt.Registry) error {

	if o.Certificate != nil {
		if err := o.Certificate.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "s3" + "." + "certificate")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SvmInlineS3) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SvmInlineS3) UnmarshalBinary(b []byte) error {
	var res SvmInlineS3
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SvmInlineS3InlineLinks svm inline s3 inline links
swagger:model svm_inline_s3_inline__links
*/
type SvmInlineS3InlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this svm inline s3 inline links
func (o *SvmInlineS3InlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmInlineS3InlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "s3" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm inline s3 inline links based on the context it is used
func (o *SvmInlineS3InlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmInlineS3InlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "s3" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SvmInlineS3InlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SvmInlineS3InlineLinks) UnmarshalBinary(b []byte) error {
	var res SvmInlineS3InlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SvmInlineS3InlineCertificate Specifies the certificate that will be used for creating HTTPS connections to the S3 server.
swagger:model svm_inline_s3_inline_certificate
*/
type SvmInlineS3InlineCertificate struct {

	// links
	Links *models.SvmInlineS3InlineCertificateInlineLinks `json:"_links,omitempty"`

	// Certificate name
	Name *string `json:"name,omitempty"`

	// Certificate UUID
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this svm inline s3 inline certificate
func (o *SvmInlineS3InlineCertificate) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmInlineS3InlineCertificate) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "s3" + "." + "certificate" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm inline s3 inline certificate based on the context it is used
func (o *SvmInlineS3InlineCertificate) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmInlineS3InlineCertificate) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "s3" + "." + "certificate" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SvmInlineS3InlineCertificate) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SvmInlineS3InlineCertificate) UnmarshalBinary(b []byte) error {
	var res SvmInlineS3InlineCertificate
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SvmInlineS3InlineCertificateInlineLinks svm inline s3 inline certificate inline links
swagger:model svm_inline_s3_inline_certificate_inline__links
*/
type SvmInlineS3InlineCertificateInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this svm inline s3 inline certificate inline links
func (o *SvmInlineS3InlineCertificateInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmInlineS3InlineCertificateInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "s3" + "." + "certificate" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm inline s3 inline certificate inline links based on the context it is used
func (o *SvmInlineS3InlineCertificateInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmInlineS3InlineCertificateInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "s3" + "." + "certificate" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SvmInlineS3InlineCertificateInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SvmInlineS3InlineCertificateInlineLinks) UnmarshalBinary(b []byte) error {
	var res SvmInlineS3InlineCertificateInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SvmInlineSnapmirror Specifies attributes for SVM DR protection.
swagger:model svm_inline_snapmirror
*/
type SvmInlineSnapmirror struct {

	// Specifies whether the SVM is a SnapMirror source SVM, using SnapMirror to protect its data.
	// Read Only: true
	IsProtected *bool `json:"is_protected,omitempty"`

	// Specifies the number of SVM DR protected consistency groups in the SVM.
	// Read Only: true
	ProtectedConsistencyGroupCount *int64 `json:"protected_consistency_group_count,omitempty"`

	// Specifies the number of SVM DR protected volumes in the SVM.
	// Read Only: true
	ProtectedVolumesCount *int64 `json:"protected_volumes_count,omitempty"`
}

// Validate validates this svm inline snapmirror
func (o *SvmInlineSnapmirror) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this svm inline snapmirror based on the context it is used
func (o *SvmInlineSnapmirror) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateIsProtected(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateProtectedConsistencyGroupCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateProtectedVolumesCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmInlineSnapmirror) contextValidateIsProtected(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"snapmirror"+"."+"is_protected", "body", o.IsProtected); err != nil {
		return err
	}

	return nil
}

func (o *SvmInlineSnapmirror) contextValidateProtectedConsistencyGroupCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"snapmirror"+"."+"protected_consistency_group_count", "body", o.ProtectedConsistencyGroupCount); err != nil {
		return err
	}

	return nil
}

func (o *SvmInlineSnapmirror) contextValidateProtectedVolumesCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"snapmirror"+"."+"protected_volumes_count", "body", o.ProtectedVolumesCount); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SvmInlineSnapmirror) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SvmInlineSnapmirror) UnmarshalBinary(b []byte) error {
	var res SvmInlineSnapmirror
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SvmInlineSnapshotPolicy This is a reference to the snapshot policy.
swagger:model svm_inline_snapshot_policy
*/
type SvmInlineSnapshotPolicy struct {

	// links
	Links *models.SvmInlineSnapshotPolicyInlineLinks `json:"_links,omitempty"`

	// name
	// Example: default
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this svm inline snapshot policy
func (o *SvmInlineSnapshotPolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmInlineSnapshotPolicy) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "snapshot_policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm inline snapshot policy based on the context it is used
func (o *SvmInlineSnapshotPolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmInlineSnapshotPolicy) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "snapshot_policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SvmInlineSnapshotPolicy) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SvmInlineSnapshotPolicy) UnmarshalBinary(b []byte) error {
	var res SvmInlineSnapshotPolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SvmInlineSnapshotPolicyInlineLinks svm inline snapshot policy inline links
swagger:model svm_inline_snapshot_policy_inline__links
*/
type SvmInlineSnapshotPolicyInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this svm inline snapshot policy inline links
func (o *SvmInlineSnapshotPolicyInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmInlineSnapshotPolicyInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "snapshot_policy" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this svm inline snapshot policy inline links based on the context it is used
func (o *SvmInlineSnapshotPolicyInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmInlineSnapshotPolicyInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "snapshot_policy" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SvmInlineSnapshotPolicyInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SvmInlineSnapshotPolicyInlineLinks) UnmarshalBinary(b []byte) error {
	var res SvmInlineSnapshotPolicyInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SvmInlineStorage svm inline storage
swagger:model svm_inline_storage
*/
type SvmInlineStorage struct {

	// Total size of the volumes in SVM, in bytes.
	// Read Only: true
	Allocated *int64 `json:"allocated,omitempty"`

	// Currently available storage capacity in SVM, in bytes.
	// Read Only: true
	Available *int64 `json:"available,omitempty"`

	// Maximum storage permitted on a single SVM, in bytes.
	Limit *int64 `json:"limit,omitempty"`

	// Indicates at what percentage of storage capacity an alert message is sent. The default value is 90.
	LimitThresholdAlert *int64 `json:"limit_threshold_alert,omitempty"`

	// Indicates whether the total storage capacity exceeds the alert percentage.
	// Read Only: true
	LimitThresholdExceeded *bool `json:"limit_threshold_exceeded,omitempty"`

	// The percentage of storage capacity used.
	// Read Only: true
	UsedPercentage *int64 `json:"used_percentage,omitempty"`
}

// Validate validates this svm inline storage
func (o *SvmInlineStorage) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this svm inline storage based on the context it is used
func (o *SvmInlineStorage) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateAllocated(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateAvailable(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLimitThresholdExceeded(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUsedPercentage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SvmInlineStorage) contextValidateAllocated(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"storage"+"."+"allocated", "body", o.Allocated); err != nil {
		return err
	}

	return nil
}

func (o *SvmInlineStorage) contextValidateAvailable(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"storage"+"."+"available", "body", o.Available); err != nil {
		return err
	}

	return nil
}

func (o *SvmInlineStorage) contextValidateLimitThresholdExceeded(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"storage"+"."+"limit_threshold_exceeded", "body", o.LimitThresholdExceeded); err != nil {
		return err
	}

	return nil
}

func (o *SvmInlineStorage) contextValidateUsedPercentage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"storage"+"."+"used_percentage", "body", o.UsedPercentage); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SvmInlineStorage) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SvmInlineStorage) UnmarshalBinary(b []byte) error {
	var res SvmInlineStorage
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
